var updateClientHandler;
var robots;
var myStatus;
var currentUpdateClientTimeout;
var lastHandshakeReceived;
var serverDownNotification;
var robotsToDelete;
var robotsToBackup;
var searchingForRobots = false;
var importingRobots = false;
var handshakeTimeout = 2000;
var backupJobPopup;
var reopenBackupJobs;
var showLicenceInfo = false;
var reloadAlertFlag = false;
// var reopenBackupManagement = false;

myTitle.textContent = PRODUCT_NAME;
myNavbarTitle.textContent = PRODUCT_NAME;

// Set the name of the hidden property and the change event for visibility
var hidden, visibilityChange;
if (typeof document.hidden !== "undefined") { // Opera 12.10 and Firefox 18 and later support 
  hidden = "hidden";
  visibilityChange = "visibilitychange";
} else if (typeof document.msHidden !== "undefined") {
  hidden = "msHidden";
  visibilityChange = "msvisibilitychange";
} else if (typeof document.webkitHidden !== "undefined") {
  hidden = "webkitHidden";
  visibilityChange = "webkitvisibilitychange";
}

// If the page is hidden, pause the video;
// if the page is shown, play the video
function handleVisibilityChange() {
  if (document[hidden]) {
    log('browser is hidden');
    StopUpdateClient();
  } else {
    log('browser is not hidden');
    StartUpdateClient(1000);
  }
}

function OnLoad() {
  log('OnLoad');

  //tabID = sessionStorage.tabID ? sessionStorage.tabID : sessionStorage.tabID = Math.random();
  // n = navigator;

  // app.views.current.router.on('pageInit', function(pageData){
  //   log();
  // });
  // app.views.current.router.on('routeChange', function(newRoute, previousRoute, router){
  //   log();
  // });

  app.views.current.router.on('pageBeforeIn', function (pageData) {

    if (pageData.route.path === '/history/') {
      SetHistoryPageLanguage();
    } else if (pageData.route.path === '/messages/') {
      SetMessagesPageLanguage();
    }

  });

  createSessionId();

  t = language.de.password;
  if (IsEnglishLanguage()) {
    t = language.eng.password;
  }

  // app.dialog.password(t, "",
  //   function (username, password) {
  //     LoggedIn();
  //   },
  //   function (username, password) {
  //     NotLoggedIn();
  //   });

  LoggedIn();
}

function NotLoggedIn() {
  app = document.getElementById("app");
  app.style.display = "none";
  // app.setAttribute("disabled", "");

  // overlay = "<div style='width:100%; height: 100%; top: 0; z-index: 100; position: absolute; background: lightgray; opacity: 0.5; text-align: center; font-size: large; padding-top: 25%; font-weight: bold;'>Loading...</div>";
  // document.getElementsByTagName("BODY")[0].append(overlay);
}

function LoggedIn() {
  // Warn if the browser doesn't support addEventListener or the Page Visibility API
  if (typeof document.addEventListener === "undefined" || typeof document[hidden] === "undefined") {
    console.log("This app requires a browser, such as Google Chrome or Firefox, that supports the Page Visibility API.");
  } else {
    // Handle page visibility change   
    document.addEventListener(visibilityChange, handleVisibilityChange, false);
  }

  showLicenceInfo = false;
  sendRequestToServer(COMMANDS.GET_LICENCE_STATE, null, GetLicenceStateCallback);
}

function OpenLicenceInfo() {

  if (!myStatus || !myStatus.LicenceState) {
    return;
  }

  s1 = language.de.licenceInfo;
  s2 = language.de.close;
  s3 = language.de.lastLicenceCheckLbl;
  s4 = language.de.productNameLbl;
  s5 = language.de.productIdLbl;
  s6 = language.de.licenceLimitedInDays;
  s8 = language.de.licenceUnits;
  s9 = language.de.licenceUpload;
  s10 = language.de.licenceRequest;

  if (IsEnglishLanguage()) {
    s1 = language.eng.licenceInfo;
    s2 = language.eng.close;
    s3 = language.eng.lastLicenceCheckLbl;
    s4 = language.eng.productNameLbl;
    s5 = language.eng.productIdLbl;
    s6 = language.eng.licenceLimitedInDays;
    s8 = language.eng.licenceUnits
    s9 = language.eng.licenceUpload;
    s10 = language.eng.licenceRequest;
  }

  if (myStatus.LicenceState.LastCheck && myStatus.LicenceState.LastCheck !== '0001-01-01T00:00:00') {
    date = new Date(Date.parse(myStatus.LicenceState.LastCheck)).toLocaleString();
    s3 += date;
  } else {
    s3 += " - ";
  }

  s7 = myStatus.LicenceState.DaysLeft;

  if (myStatus.LicenceState.State === 'UNLIMITED_LICENCE') {
    s7 = currentLanguage !== 'de' ? language.eng.licenceUnlimited : language.de.licenceUnlimited;
  } else if (myStatus.LicenceState.State === 'NO_LICENCE') {
    s7 = currentLanguage !== 'de' ? language.eng.noLicenceAvailable : language.de.noLicenceAvailable;
  }

  popupContent = '<div class="popup" style="height: 41%;">'
    + '<div class="view">'
    + '<div class="page color-deeporange">'
    + '<div class="navbar">'
    + '<div class="navbar-bg"></div>'
    + '<div class="navbar-inner">'
    + '<div class="title">' + s1 + '</div>'
    + '<div class="right">'
    + '<a class="link popup-close">' + s2 + '</a>'
    + '</div>'
    + '</div>'
    + '</div>'
    + '<div class="page-content">'

    + '<div class="block inset">'
    + '<div class="block-header">' + s3 + '</div>'
    + '</div>'

    + '<div class="block inset">'
    + '<div class="list">'
    + '  <ul>'
    + '    <li>'
    + '      <div class="item-content">'
    + '        <div class="item-inner">'
    + '       <div class="item-title">' + s4 + '</div>'
    + '       <div class="item-after">' + myStatus.LicenceState.ProductName + '</div>'
    + '     </div>'
    + '   </div>'
    + ' </li>'
    + ' <li>'
    + '   <div class="item-content">'
    + '     <div class="item-inner">'
    + '       <div class="item-title">' + s5 + '</div>'
    + '       <div class="item-after">' + myStatus.LicenceState.ProductId + '</div>'
    + '     </div>'
    + '   </div>'
    + ' </li>'
    + ' <li>'
    + '   <div class="item-content">'
    + '     <div class="item-inner">'
    + '       <div class="item-title">' + s6 + '</div>'
    + '       <div class="item-after">' + s7 + '</div>'
    + '     </div>'
    + '   </div>'
    + ' </li>';

  if (myStatus.LicenceState.Units > 0) {
    popupContent += ' <li>'
      + '   <div class="item-content">'
      + '     <div class="item-inner">'
      + '       <div class="item-title">' + s8 + '</div>'
      + '       <div class="item-after">' + myStatus.LicenceState.Units + '</div>'
      + '     </div>'
      + '   </div>'
      + ' </li>'
  }

  popupContent += '</ul>'
    + '</div>'
    + '</div>'
    + '<div class="block inset">'
    + '<div class="row">'
    + '   <button class="col button button-large button-fill popup-close color-deeporange" onclick="UploadLicFile()">' + s9 + '</button>'
    + '   <button class="col button button-large button-fill popup-close color-deeporange" onclick="RequestLicence()">' + s10 + '</button>'
    + '</div>'
    + '</div>'

    + '</div>'
    + '</div>'
    + '</div>'
    + '</div>';

  app.popup.create({
    content: popupContent
  }).open();
}

function RequestLicence() {

  if (!myStatus || !myStatus.LicenceState) {
    return;
  }

  a = document.createElement('a');
  a.class = 'link external';
  a.href = 'mailto:info@orangeapps.de?subject=' + myStatus.LicenceState.ProductName + '&body=Product-ID: ' + myStatus.LicenceState.ProductId;
  a.click();
}

function GetLicenceStateCallback(responseText) {
  log('GetLicenceStateCallback: ' + responseText);

  if (!responseText) {
    return;
  }

  result = JSON.parse(responseText);

  if (!result.Successful && !StringIsNullOrEmpty(result.Error)) {
    s0 = currentLanguage !== 'de' ? language.eng.licenceUploadError : language.de.licenceUploadError;
    app.dialog.alert(result.Error, s0);
  }

  if (result.State === 'UNLIMITED_LICENCE') {
    menuPageContent.style.display = 'block';
    sendRequestToServer(COMMANDS.GET_ROBOTS, null, GetRobotsCallback);
    if (showLicenceInfo) {
      s = currentLanguage !== 'de' ? language.eng.licenceUnlimited : language.de.licenceUnlimited;
      app.dialog.alert(s, '');
    }
  } else if (result.State === 'LIMITED_LICENCE') {
    menuPageContent.style.display = 'block';
    sendRequestToServer(COMMANDS.GET_ROBOTS, null, GetRobotsCallback);
    if (showLicenceInfo) {
      s = currentLanguage !== 'de' ? language.eng.licenceLimitedInDays : language.de.licenceLimitedInDays;
      s += ': ' + result.DaysLeft;
      app.dialog.alert(s, '');
    }
  } else {
    productId = result.ProductId;
    // formattedProductId = productId.slice(0, 4) + '-' + productId.slice(4, 8) + '-' + productId.slice(8, 12) + '-' + productId.slice(12, 16);
    // s0 = '<a href="mailto:info@orangeapps.de?subject=Feedback&body=Message">info@orangeapps.de</a>';
    s1 = currentLanguage !== 'de' ? language.eng.noLicenceAvailable : language.de.noLicenceAvailable;
    s2 = currentLanguage !== 'de' ? language.eng.noValidLicence : language.de.noValidLicence;
    s3 = currentLanguage !== 'de' ? language.eng.licenceRequest1 : language.de.licenceRequest1;
    s4 = currentLanguage !== 'de' ? language.eng.licenceRequest2 : language.de.licenceRequest2;

    app.dialog.create({
      title: s1,
      // text: s2,
      content: '<div class="block inset">'
        + '<p>' + s2 + '</p>'
        + '<p></p>'
        + '<p><b>' + productId + '</b></p>'
        + '<p></p>'
        + '<p>' + s3 + '</p>'
        + '<a class="link external" href="mailto:info@orangeapps.de?subject=' + result.ProductName + '&body=Product-ID: ' + productId + '">info@orangeapps.de</a>'
        + '<p>' + s4 + '</p>'
        + '</div>',
      buttons: [
        {
          color: 'deeporange',
          text: currentLanguage !== 'de' ? language.eng.licenceUpload : language.de.licenceUpload,
          onClick: function () {
            UploadLicFile();
          }
        },
        {
          color: 'deeporange',
          text: currentLanguage !== 'de' ? language.eng.cancel : language.de.cancel,
          onClick: function () {
            t = result.ProductName;
            t += currentLanguage !== 'de' ? language.eng.noValidLicenceWarning : language.de.noValidLicenceWarning
            app.dialog.alert(t, '');
          }
        }
      ]
    }).open();
  }
}

function UploadLicFile() {

  // Check for the various File API support.
  if (window.File && window.FileReader && window.FileList && window.Blob) {
    // Great success! All the File APIs are supported.
  } else {
    s = language.de.notSupported;
    if (IsEnglishLanguage()) {
      s = language.eng.notSupported;
    }
    app.dialog.alert(s);
    return;
  }

  input = document.createElement('input');
  input.type = 'file';
  input.accept = '.lic';

  input.onchange = e => {
    file = e.target.files[0];
    filename = file.name;
    ext = filename.substring(filename.lastIndexOf('.') + 1);

    if (ext !== 'lic') {
      s = language.de.invalidFileExtension;
      if (IsEnglishLanguage()) {
        s = language.eng.invalidFileExtension;
      }
      app.dialog.alert(s, '');
      return;
    }

    var reader = new FileReader();
    var senddata = new Object();

    // Auslesen der Datei-Metadaten
    senddata.name = file.name;
    senddata.date = file.lastModified;
    senddata.size = file.size;
    senddata.type = file.type;

    // Wenn der Dateiinhalt ausgelesen wurde...
    reader.onload = function (theFileData) {
      senddata.fileData = theFileData.target.result; // Ergebnis vom FileReader auslesen

      /*
      Code für AJAX-Request hier einfügen
      */

      json = JSON.stringify(senddata);
      showLicenceInfo = true;
      postToServer(COMMANDS.UPLOAD_LIC, senddata.fileData, GetLicenceStateCallback);
    }

    // Die Datei einlesen und in eine Data-URL konvertieren
    reader.readAsBinaryString(file);
  }

  input.click();
}

function GetRobotsCallback(responseText) {
  log('GetRobotsCallback: ' + responseText);

  StartUpdateClient(1000);

  x = document.getElementById("noRobotsAvailableView");
  y = document.getElementById("robotsAvailableView");
  robList = document.getElementById("robotList");
  RemoveAllChilds(robList);

  if (responseText === 'undefined') {
    x.style.display = "block";
    y.style.display = "none";
    return;
  }

  robots = JSON.parse(responseText);

  if (!robots || robots.length < 1) {
    x.style.display = "block";
    y.style.display = "none";
    return;
  }

  robots.forEach(element => {
    str = CreateRobotItem(element);
    robList.insertAdjacentHTML('beforeend', str);
    SetRobotBackupLedState(element)
  });

  x.style.display = "none";
  y.style.display = "block";
}

function StartUpdateClient(timeout) {
  if (updateClientHandler && timeout == currentUpdateClientTimeout) {
    return;
  }

  if (updateClientHandler) {
    StopUpdateClient();
  }

  currentUpdateClientTimeout = timeout;
  sendRequestToServer(COMMANDS.INIT_CLIENT, null, UpdateClientCallback);
  updateClientHandler = setInterval(function () { UpdateCient() }, timeout);
}

function StopUpdateClient() {
  clearInterval(updateClientHandler);
  updateClientHandler = null;
}

function UpdateCient() {
  log('UpdateCient');
  sendRequestToServer(COMMANDS.UPDATE_CLIENT, sessionId, UpdateClientCallback);

  subT = language.de.connectionLost;

  if (IsEnglishLanguage()) {
    subT = language.eng.connectionLost;
  }

  if (!serverDownNotification && lastHandshakeReceived && Date.now() - lastHandshakeReceived > currentUpdateClientTimeout * 2) {
    serverDownNotification = app.notification.create({
      icon: '<i class="icon f7-icons">info_circle</i>',
      title: PRODUCT_NAME,
      subtitle: subT,
      titleRightText: new Date().toLocaleString(),
      closeButton: true,
    }).open();
  }
}

function UpdateClientCallback(responseText) {
  log('UpdateClientCallback: ' + responseText);

  lastHandshakeReceived = Date.now();

  if (serverDownNotification) {
    serverDownNotification.close();
    serverDownNotification = undefined;
  }

  // null ==> Client ist aktuell und es muss nichts aktualisiert werden
  if (!responseText || responseText === 'null') {
    return;
  }

  newReceived = JSON.parse(responseText);

  // überprüfen, ob das neu empfangene Objekt das Property BackupInProgressTotalCount enthält
  // falls ja ==> neuen Status empfangen
  // falls nein ==> neue Message empfangen
  if (newReceived.BackupInProgressTotalCount !== undefined) {
    UpdateStates(newReceived);
  } else if (newReceived) {
    t = currentLanguage !== 'de' ? newReceived[0].message : newReceived[1].message;
    infoMessage.textContent = t;
  }
}

function UpdateStates(newStatus) {

  // myStatus = JSON.parse(responseText);

  if (!newStatus) {
    return;
  }

  myStatus = newStatus;
  if (robots && robots.length !== newStatus.Robots.length) {
    t = language.de.robotListChanged;
    if (IsEnglishLanguage()) {
      t = language.eng.robotListChanged;
    }
    app.toast.create({
      text: t,
      position: 'center',
      closeTimeout: 10000,
      closeButton: true
    }).open();
    sendRequestToServer(COMMANDS.GET_ROBOTS, null, GetRobotsCallback);
  }

  robots = newStatus.Robots;

  UpdateRobotSearcherState(myStatus);
  UpdateRobotImporterState(myStatus);
  UpdateCurrentBackupJobsCountBadge(myStatus);
  UpdateRobotStates(myStatus);
  UpdateProgressbar(myStatus);
  UpdateLicenceBadge(myStatus.LicenceState);

  if (reopenBackupJobs) {
    reopenBackupJobs = false;
    OpenBackupJobs();
  }
}

function UpdateLicenceBadge(licenceState) {

  if (!licenceState) {
    return;
  }

  color = licenceBadge.classList[1];
  if (licenceState.State === 'UNLIMITED_LICENCE') {
    licenceBadge.style.display = 'none';
  } else if (licenceState.State === 'LIMITED_LICENCE') {
    if (licenceState.DaysLeft > 30) {
      licenceBadge.classList.remove(color);
      licenceBadge.classList.add('color-green');
    } else {
      licenceBadge.classList.remove(color);
      licenceBadge.classList.add('color-yellow');
    }
    // s = currentLanguage !== 'de' ? language.eng.licenceLimitedInDays : language.de.licenceLimitedInDays;
    // s += result.DaysLeft;
    licenceBadge.textContent = result.DaysLeft;
    licenceBadge.style.display = 'inline-flex';
  } else {
    t = currentLanguage !== 'de' ? language.eng.noValidLicenceAvailable : language.de.noValidLicenceAvailable;

    if (reloadAlertFlag) {
      return;
    }

    reloadAlertFlag = true;
    app.dialog.alert(t, '', function () {
      location.reload();
      reloadAlertFlag = false;
    });
  }
}

function UpdateProgressbar(status) {
  log('UpdateProgressbar: ' + JSON.stringify(status));

  bar = document.getElementById('progbar');

  if (!bar) {
    return;
  }

  if (status.BackupInProgressTotalCount > 0) {
    if (bar.style.display !== "block") {
      bar.style.display = "block";
      app.progressbar.set(bar, 0);
    }

    progress = status.BackupInProgressCount / status.BackupInProgressTotalCount;

    if (progress === 1) {
      progress = 95;
    } else {
      progress = progress * 100;
    }

    app.progressbar.set(bar, progress, 500);

  } else {
    if (bar.style.display !== "none") {
      bar.style.display = "none";
      app.progressbar.set(bar, 0);
    }
  }
}

function UpdateRobotStates(status) {
  log('UpdateRobotStates: ' + JSON.stringify(status));

  if (!status.Robots) {
    return;
  }

  status.Robots.forEach(rob => {
    UpdateOnlineState(rob);
    UpdateRobotBackupState(rob);
  });
}

function UpdateOnlineState(rob) {
  log('UpdateOnlineStates: ' + rob);

  if (!rob) {
    return;
  }

  badge = document.getElementById('OnlineBadge_' + rob.Ip);

  if (!badge) {
    return;
  }

  if (rob.State.Online) {
    badge.style.display = 'none';
  } else {
    badge.style.display = 'inline-flex';
  }
}

function UpdateRobotBackupState(rob) {
  log('UpdateRobotBackupState: ' + rob);

  if (!rob) {
    return;
  }

  SetRobotBackupLedState(rob)
}

function SetRobotBackupLedState(rob) {

  if (!rob) {
    return;
  }

  led = document.getElementById('Led_' + rob.Ip);

  if (!led) {
    return;
  }

  state = led.classList[0];

  if (rob.State.BackupProgressState && rob.State.BackupProgressState !== BACKUP_PROGRESS_STATES.IDLE) {
    if (state !== BACKUP_STATE.BACKUP_RUNNING) {
      led.classList.remove(state);
      led.classList.add(BACKUP_STATE.BACKUP_RUNNING);
    }

    return;
  }

  if (rob.AvailableBackups.length < 1) {
    if (state === BACKUP_STATE.NO_BACKUPS) {
      return;
    }

    led.classList.remove(state);
    led.classList.add(BACKUP_STATE.NO_BACKUPS);

    return;
  }

  if (!rob.State.BackupStateOk) {
    if (state !== BACKUP_STATE.BACKUP_OUT_OF_DATE) {
      led.classList.remove(state);
      led.classList.add(BACKUP_STATE.BACKUP_OUT_OF_DATE);
    }

    return;
  }

  if (state !== BACKUP_STATE.BACKUP_OK) {
    led.classList.remove(state);
    led.classList.add(BACKUP_STATE.BACKUP_OK);
  }
}

function UpdateCurrentBackupJobsCountBadge(status) {
  log('UpdateCurrentBackupJobsCountBadge: ' + JSON.stringify(status));

  badge = document.getElementById('currentBackupJobsCountBadge');

  if (!badge || !status) {
    return;
  }

  count = 0;

  if (status.CurrentBackupJob) {
    count++;
  }

  if (status.CurrentBackupJobs) {
    count += status.CurrentBackupJobs.length;
  }

  badge.innerHTML = count;
}

function UpdateRobotImporterState(status) {
  log('UpdateRobotImporterState: ' + JSON.stringify(status));

  if (!status.RobotImporterState) {
    return;
  }

  bar = document.getElementById("robotImporterProgbar");

  if (!bar) {
    return;
  }

  if (status.RobotImporterState.Progress > 0 && bar.style.display === 'block') {
    app.progressbar.set(bar, status.RobotImporterState.Progress, 500);
  }

  if (status.RobotImporterState.IsImporting) {
    if (!importingRobots) {
      importingRobots = true;
      bar.style.display = 'block';

      t = language.de.robotImportStarted;
      if (IsEnglishLanguage()) {
        t = language.eng.robotImportStarted;
      }

      app.toast.create({
        text: t,
        position: 'center',
        closeTimeout: 1000,
      }).open();
    }

  } else {
    if (bar.style.display !== 'none') {
      bar.style.display = 'none';
    }

    app.progressbar.set(bar, 0);

    if (importingRobots || status.RobotImporterState.ImportedRobots !== null) {
      importingRobots = false;

      if (!status.RobotImporterState.ImportedRobots) {

        t = language.de.robotImportStarted;
        if (IsEnglishLanguage()) {
          t = language.eng.robotImportStarted;
        }

        app.toast.create({
          text: t,
          position: 'center',
          closeTimeout: 3000,
        }).open();

        return;
      }

      ShowNewRobots(status.RobotImporterState.ImportedRobots, 'true');
    }
  }
}

function UpdateRobotSearcherState(status) {
  log('UpdateRobotSearcherState: ' + JSON.stringify(status));

  if (!status.RobotSearcherState) {
    return;
  }

  bar = document.getElementById("infiniteProgbar");

  if (status.RobotSearcherState.IsSearching && !searchingForRobots) {
    searchingForRobots = true;
    bar.style.display = 'block';

    t = language.de.searchingForRobotsStarted;
    if (IsEnglishLanguage()) {
      t = language.eng.searchingForRobotsStarted;
    }

    app.toast.create({
      text: t,
      position: 'center',
      closeTimeout: 3000,
    }).open();
  } else {
    if (bar.style.display !== 'none') {
      bar.style.display = 'none';
    }

    if (searchingForRobots) {
      searchingForRobots = false;

      if (!status.RobotSearcherState.FoundRobots) {

        t = language.de.searchingForRobotsFinished;
        if (IsEnglishLanguage()) {
          t = language.eng.searchingForRobotsFinished;
        }

        app.toast.create({
          text: t,
          position: 'center',
          closeTimeout: 3000,
        }).open();

        return;
      }

      ShowNewRobots(status.RobotSearcherState.FoundRobots, 'false');
    }
  }
}

function IsRobotEqual(element, array) {

  found = array.find(e => e.Ip === element.Ip);

  if (found === undefined) {
    return false;
  }

  return true;
}

function ShowNewRobots(allRobots, imported) {
  log('ShowNewRobots: ' + allRobots);

  if (!allRobots) {
    return;
  }

  newRobots = allRobots.filter(x => !IsRobotEqual(x, robots));
  stillAvailableRobots = allRobots.filter(x => IsRobotEqual(x, robots));

  if (newRobots.length < 1) {
    t = language.de.noNewRobotsFound;
    if (IsEnglishLanguage()) {
      t = language.eng.noNewRobotsFound;
    }
    app.toast.create({
      text: t,
      position: 'center',
      closeTimeout: 3000,
    }).open();
    RefuseNewRobots(imported);
    return;
  }

  s1 = language.de.showNewRobotsPopupTitle;
  s2 = language.de.showNewRobotsPopupOverview;
  s3 = allRobots.length + language.de.showNewRobotsPopupRobotsFound;
  s4 = newRobots.length + language.de.showNewRobotsPopupNewRobots;
  s5 = stillAvailableRobots.length + language.de.showNewRobotsPopupStillAvailableRobots;
  s6 = language.de.showNewRobotsPopupStillNewRobotsTitle;
  s7 = language.de.showNewRobotsPopupStillAvailableTitle;
  s8 = language.de.showNewRobotsPopupBackupNewRobots;
  s9 = language.de.yes;
  s10 = language.de.no;

  if (IsEnglishLanguage()) {
    s1 = language.eng.showNewRobotsPopupTitle;
    s2 = language.eng.showNewRobotsPopupOverview;
    s3 = allRobots.length + language.eng.showNewRobotsPopupRobotsFound;
    s4 = newRobots.length + language.eng.showNewRobotsPopupNewRobots;
    s5 = stillAvailableRobots.length + language.eng.showNewRobotsPopupStillAvailableRobots;
    s6 = language.eng.showNewRobotsPopupStillNewRobotsTitle;
    s7 = language.eng.showNewRobotsPopupStillAvailableTitle;
    s8 = language.eng.showNewRobotsPopupBackupNewRobots;
    s9 = language.eng.yes;
    s10 = language.eng.no;
  }

  app.popup.create({
    content: '<div class="popup my-popup">'
      + '<div class="view">'
      + '<div class="page color-deeporange">'
      + '<div class="navbar">'
      + '<div class="navbar-bg"></div>'
      + '<div class="navbar-inner">'
      + '<div class="title">' + s1 + '</div>'
      + '</div>'
      + '</div>'
      + '<div class="page-content">'

      + '<div class="block inset">'
      + '<div class="block-header">' + s2 + '</div>'
      + '<p>' + s3 + '</p>'
      + '<p>' + s4 + '</p>'
      + '<p>' + s5 + '</p>'
      + '</div>'

      + '<div class="block inset">'
      + '<div class="block-header">' + s6 + '</div>'
      + CreateRobotListPopoverItems(newRobots)
      + '</div>'

      + '<div class="block inset">'
      + '<div class="block-header">' + s7 + '</div>'
      + CreateRobotListPopoverItems(stillAvailableRobots)
      + '</div>'

      + '<div class="block inset">'
      + '<p><label class="checkbox"><input id="backupNewRobots" type="checkbox"><i class="icon-checkbox"></i></label>' + s8 + '</p>'
      + '<div class="row">'
      + '<button class="col button button-large button-fill popup-close color-deeporange" onclick="UseNewRobots(\'' + imported + '\')">' + s9 + '</button>'
      + '<button class="col button button-large button-fill popup-close color-blue" onclick="RefuseNewRobots(\'' + imported + '\')">' + s10 + '</button>'
      + '</div>'
      + '</div>'

      + '</div>'
      + '</div>'
      + '</div>'
      + '</div>'
  }).open();
}

function RefuseNewRobots(imported) {
  log('RefuseNewRobots: ' + imported);

  if (imported === 'true') {
    sendRequestToServer(COMMANDS.REFUSE_IMPORTED_ROBOTS);
  } else {
    sendRequestToServer(COMMANDS.REFUSE_FOUND_ROBOTS);
  }
}

function UseNewRobots(imported) {
  log('UseNewRobots: ' + imported);

  backup = false;
  ele = document.getElementById('backupNewRobots');
  if (ele) {
    backup = ele.checked;
  }

  if (imported === 'true') {
    sendRequestToServer(COMMANDS.USE_NEW_IMPORTED_ROBOTS, backup, UseNewRobotsCallback);
  } else {
    sendRequestToServer(COMMANDS.USE_NEW_FOUND_ROBOTS, backup, UseNewRobotsCallback);
  }
}

function UseNewRobotsCallback(responseText) {
  log('UseNewRobotsCallback: ' + responseText);

  if (!responseText || responseText === '') {
    return;
  }

  result = JSON.parse(responseText);

  if (result) {
    t = language.de.addingNewRobotSuccessful;
    if (IsEnglishLanguage()) {
      t = language.eng.addingNewRobotSuccessful;
    }
    app.toast.create({
      text: t,
      position: 'center',
      closeTimeout: 3000,
    }).open();
  }

  sendRequestToServer(COMMANDS.GET_ROBOTS, null, GetRobotsCallback);
}

function OnTitleClick() {
  x = document.getElementById("treeviewDiv");
  //x.style.display = "block";

  location.reload();
}

async function SearchForRobotsClick() {
  log('SearchForRobotsClick');

  sendRequestToServer(COMMANDS.SEARCH_FOR_ROBOTS);

  robList = document.getElementById("robotList");
}

function CreateRobotItem(element) {

  ip = element.Ip;
  header = element.Name;
  footer = 'IP: ' + element.Ip;
  online = element.State.Online;

  if (element.Info !== null) {
    footer = element.Info.RoboterType + ' | Ser. ' + element.Info.Serialnumber + ' | ' + 'IP: ' + element.Ip;
  }

  ledId = 'Led_' + ip;
  onlineBadgeId = 'OnlineBadge_' + ip;
  displayOnline = 'inline-flex';

  if (online) {
    displayOnline = 'none';
  }

  // button.onclick = function () {
  //   maintenanceButtonClicked(name);
  // };

  return '<li>'
    + '<div href="#" class="item-content">'
    + '<div class="item-media"><i id="' + ledId + '" class="ledOrange"></i></div>'
    + '<div class="item-inner">'
    // + '<div class="item-title popup-open" data-popup=".my-popup">'
    + '<div class="item-link item-title" onclick="OpenRobotInfoPopup(\'' + ip + '\')">'
    // + '<div class="item-header"></div>'
    + header //'Z1_100RB_100'
    + '<span id="' + onlineBadgeId + '" class="badge color-red" style="margin-left: 10px; margin-bottom: 4px; display: ' + displayOnline + '">offline</span>'
    + '<div class="item-footer">' + footer + '</div>'
    + '</div>'
    + '<div class="item-after">'
    + '<label class="toggle color-blue">'
    + '<input id="' + ip + '" name="toogleCheckbox" type="checkbox">'
    + '<span class="toggle-icon"></span>'
    + '</label>'
    + '</div>'
    + '</div>'
    + '</div>'
    + '</li>'
}

function OpenRobotInfoPopup(ip) {

  rob = robots.find(e => e.Ip === ip);

  if (!rob) {
    return;
  }

  ip = rob.Ip;

  if (!rob.Info) {
    t = language.de.noRobotInfoAvailable;
    if (IsEnglishLanguage()) {
      t = language.eng.noRobotInfoAvailable;
    }
    app.toast.create({
      text: t,
      position: 'center',
      closeTimeout: 2000,
    }).open();
    return;
  }

  s1 = language.de.close;
  s2 = language.de.backupNow;
  s3 = language.de.restoreAssistent;
  s4 = language.de.robotInfoUpdateTimeStamp;
  s5 = language.de.robotInfo;
  s6 = language.de.robotType;
  s7 = language.de.serialNr;
  s8 = language.de.kssVerion;
  s9 = language.de.availableBackups;
  s10 = language.de.installedOptions;
  s11 = language.de.deleteRobotBtn;

  if (IsEnglishLanguage()) {
    s1 = language.eng.close;
    s2 = language.eng.backupNow;
    s3 = language.eng.restoreAssistent;
    s4 = language.eng.robotInfoUpdateTimeStamp;
    s5 = language.eng.robotInfo;
    s6 = language.eng.robotType;
    s7 = language.eng.serialNr;
    s8 = language.eng.kssVerion;
    s9 = language.eng.availableBackups;
    s10 = language.eng.installedOptions;
    s11 = language.eng.deleteRobotBtn;
  }

  if (rob.Info.TimeStamp && rob.Info.TimeStamp !== '0001-01-01T00:00:00') {
    date = new Date(Date.parse(rob.Info.TimeStamp)).toLocaleString();
    s4 += date;
  } else {
    s4 += " - ";
  }

  app.popup.create({
    content: '<div class="popup my-popup">'
      + '<div class="view">'
      + '<div class="page color-deeporange">'
      + '<div class="navbar">'
      + '<div class="navbar-bg"></div>'
      + '<div class="navbar-inner">'
      + '<div class="title">' + rob.Name + '</div>'
      + '<div class="right">'
      + '<a class="link popup-close">' + s1 + '</a>'
      + '</div>'
      + '</div>'
      + '</div>'
      + '<div class="page-content">'

      + '<div class="block inset">'
      + '<div class="row">'
      + '<button class="col button button-large button-fill popup-close color-deeporange" onclick="BackupRobot(\'' + rob.Ip + '\')">' + s2 + '</button>'
      + '<button  class="col button button-large button-fill popup-close color-blue" onclick="OpenRestoreAssistent()">' + s3 + '</button>'
      + '</div>'
      + '</div>'

      + '<div class="block inset">'
      + '<div class="block-header">' + s4 + '</div>'
      + '</div>'

      + '<div class="block inset">'
      + '<div class="block-header">' + s5 + '</div>'
      + '<div class="list">'
      + '  <ul>'
      + '    <li>'
      + '      <div class="item-content">'
      + '        <div class="item-inner">'
      + '       <div class="item-title">' + s6 + '</div>'
      + '       <div class="item-after">' + rob.Info.RoboterType + '</div>'
      + '     </div>'
      + '   </div>'
      + ' </li>'
      + ' <li>'
      + '   <div class="item-content">'
      + '     <div class="item-inner">'
      + '       <div class="item-title">' + s7 + '</div>'
      + '       <div class="item-after">' + rob.Info.Serialnumber + '</div>'
      + '     </div>'
      + '   </div>'
      + ' </li>'
      + ' <li>'
      + '   <div class="item-content">'
      + '     <div class="item-inner">'
      + '       <div class="item-title">' + s8 + '</div>'
      + '       <div class="item-after">' + rob.Info.Version + '</div>'
      + '     </div>'
      + '   </div>'
      + ' </li>'
      // + ' <li>'
      // + '   <div class="item-content">'
      // + '     <div class="item-inner">'
      // + '       <div class="item-title">Sicherheitsupdate</div>'
      // + '       <div class="item-after">' + rob.Info.Version + '</div>'
      // + '     </div>'
      // + '   </div>'
      // + ' </li>'
      + '</ul>'
      + '</div>'
      + '</div>'

      + '<div class="block inset">'
      + '<div class="block-header">' + s9 + '</div>'
      + CreateRobotInfoBackupItems(rob)
      + '</div>'

      + '<div class="block inset">'
      + '<div class="block-header">' + s10 + '</div>'
      + CreateRobotInfoOptionItems(rob)
      + ' </div>'

      + '<div class="block inset">'
      + '<div class="row">'
      + '   <button class="col button button-large button-fill popup-close color-red" onclick="DeleteRobot(\'' + ip + '\')">' + s11 + '</button>'
      + '</div>'
      + '</div>'

      + '</div>'
      + '</div>'
      + '</div>'
      + '</div>'
  }).open();
}

function CreateRobotInfoBackupItems(rob) {

  if (!rob) {
    return '';
  }

  availableBackups = rob.AvailableBackups;

  result = '<div class="list" style="max-height:490px;overflow:auto;">'
    + '<ul>';

  if (!availableBackups || availableBackups.length < 1) {
    result += CreateRobotInfoBackupItem();
  } else {
    availableBackups.forEach(element => {
      result += CreateRobotInfoBackupItem(element);
    });
  }

  result += '</ul>'
    + '</div>';

  return result;
}

function CreateRobotInfoBackupItem(entry) {

  if (!entry) {
    return '<li>'
      + '     <div class="item-content">'
      + '        <div class="item-inner">'
      + '         <div class="item-title"> - </div>'
      + '       </div>'
      + '      </div>'
      + '    </li>';
  }

  date = new Date(Date.parse(entry.Key)).toLocaleString();
  path = entry.Value.replace(/\\/g, '!');

  return '<li>'
    + '     <div class="item-content">'
    + '        <div class="item-inner">'
    // + '         <div class="item-title">24.03.2020 22:00:00 Uhr</div>'
    + '         <div class="item-title">' + date + '</div>'
    + '         <div class="item-after"><a title="Download" class="icon f7-icons popup-close" onclick="DownloadBackup(\'' + path + '\')">download_circle</a></div>'
    // <a title="Restore" class="icon f7-icons popup-close color-blue" onclick="RestoreBackup(\'' + path + '\')">upload_circle</a>
    + '       </div>'
    + '      </div>'
    + '    </li>';
}

function OpenRestoreAssistent() {
  app.dialog.create({
    title: currentLanguage !== 'de' ? language.eng.restoreAssistentTitle : language.de.restoreAssistentTitle,
    buttons: [
      {
        color: 'deeporange',
        text: currentLanguage !== 'de' ? language.eng.restoreAssistentNewest : language.de.restoreAssistentNewest,
        onClick: function () {
          ShowRestoreAssistentForNewestBackup();
        }
      },
      {
        color: 'deeporange',
        text: currentLanguage !== 'de' ? language.eng.restoreAssistentOlder : language.de.restoreAssistentOlder,
        onClick: function () {
          ShowRestoreAssistentForOlderBackups();
        }
      },
      // {
      //   color: 'deeporange',
      //   text: currentLanguage !== 'de' ? language.eng.close : language.de.close
      // }
    ]
  }).open();
}

function ShowRestoreAssistentForNewestBackup() {
  s1 = language.de.restoreAssistentForNewestTitle;
  s2 = language.de.close;
  s3 = language.de.restoreAssistentLogin;
  s4 = language.de.restoreAssistentLoginHeader;
  s5 = language.de.restoreAssistentLoginStep1;
  s6 = language.de.restoreAssistentLoginStep2;
  s7 = language.de.restoreAssistentLoginStep3;
  s8 = language.de.restoreAssistentRestore;
  s9 = language.de.restoreAssistentRestoreHeader;
  s10 = language.de.restoreAssistentRestoreStep1;
  s11 = language.de.restoreAssistentRestoreStep2;
  s12 = language.de.restoreAssistentRestoreStep3;
  s13 = language.de.restoreAssistentRestoreStep4;
  s14 = language.de.restoreAssistentRestoreStep5;
  s15 = language.de.restoreAssistentActivation;
  s16 = language.de.restoreAssistentActivationHeader;
  s17 = language.de.restoreAssistentActivationStep1;
  s18 = language.de.restoreAssistentChangings;
  s19 = language.de.restoreAssistentChangingsHeader;
  s20 = language.de.restoreAssistentChangingsStep1;
  s22 = language.de.restoreAssistentFinish;
  s21 = language.de.restoreAssistentFinishHeader;

  if (IsEnglishLanguage()) {
    s1 = language.eng.restoreAssistentForNewestTitle;
    s2 = language.eng.close;
    s3 = language.eng.restoreAssistentLogin;
    s4 = language.eng.restoreAssistentLoginHeader;
    s5 = language.eng.restoreAssistentLoginStep1;
    s6 = language.eng.restoreAssistentLoginStep2;
    s7 = language.eng.restoreAssistentLoginStep3;
    s8 = language.eng.restoreAssistentRestore;
    s9 = language.eng.restoreAssistentRestoreHeader;
    s10 = language.eng.restoreAssistentRestoreStep1;
    s11 = language.eng.restoreAssistentRestoreStep2;
    s12 = language.eng.restoreAssistentRestoreStep3;
    s13 = language.eng.restoreAssistentRestoreStep4;
    s14 = language.eng.restoreAssistentRestoreStep5;
    s15 = language.eng.restoreAssistentActivation;
    s16 = language.eng.restoreAssistentActivationHeader;
    s17 = language.eng.restoreAssistentActivationStep1;
    s18 = language.eng.restoreAssistentChangings;
    s19 = language.eng.restoreAssistentChangingsHeader;
    s20 = language.eng.restoreAssistentChangingsStep1;
    s22 = language.eng.restoreAssistentFinish;
    s21 = language.eng.restoreAssistentFinishHeader;
  }

  app.sheet.create({
    content: '<div class="sheet-modal" style="height:100%">' +
      '<div class="toolbar">' +
      '<div class="toolbar-inner">' +
      '<div class="left"></div>' +
      '<div class="title">' + s1 + '</div>' +
      '<div class="right"><a class="link sheet-close">' + s2 + '</a></div>' +
      '</div>' +
      '</div>' +
      '<div class="sheet-modal-inner">' +

      '<div class="page-content">' +
      '<div class="block">' +

      '<div class="card card-outline">' +
      '<div class="card-header">' +
      '<div class="chip">' +
      '<div class="chip-media">' +
      '<span class="badge color-blue">1</span>' +
      '</div>' +
      '<div class="chip-label">' + s3 + '</div>' +
      '</div>' +
      '</div>' +
      '<div class="card-content card-content-padding">' + s4 + '</div>' +
      '<div class="card-footer">' +
      '<ul>' +
      '<li>' + s5 + '</li>' +
      '<li>' + s6 + '</li>' +
      '<li>' + s7 + '</li>' +
      '</ul> ' +
      '</div>' +
      '</div>' +

      '<div class="card card-outline">' +
      '<div class="card-header">' +
      '<div class="chip">' +
      '<div class="chip-media">' +
      '<span class="badge color-blue">2</span>' +
      '</div>' +
      '<div class="chip-label">' + s8 + '</div>' +
      '</div>' +
      '</div>' +
      '<div class="card-content card-content-padding">' + s9 + '</div>' +
      '<div class="card-footer">' +
      '<ul>' +
      '<li>' + s10 + '</li>' +
      '<li>' + s11 + '</li>' +
      '<li>' + s12 + '</li>' +
      '<li>' + s13 + '</li>' +
      '<li>' + s14 + '</li>' +
      '</ul> ' +
      '</div>' +
      '</div>' +

      '<div class="card card-outline">' +
      '<div class="card-header">' +
      '<div class="chip">' +
      '<div class="chip-media">' +
      '<span class="badge color-blue">3</span>' +
      '</div>' +
      '<div class="chip-label">' + s15 + '</div>' +
      '</div>' +
      '</div>' +
      '<div class="card-content card-content-padding">' + s16 + '</div>' +
      '<div class="card-footer">' +
      '<ul>' +
      '<li>' + s17 + '</li>' +
      '</ul> ' +
      '</div>' +
      '</div>' +

      '<div class="card card-outline">' +
      '<div class="card-header">' +
      '<div class="chip">' +
      '<div class="chip-media">' +
      '<span class="badge color-blue">4</span>' +
      '</div>' +
      '<div class="chip-label">' + s18 + '</div>' +
      '</div>' +
      '</div>' +
      '<div class="card-content card-content-padding">' + s19 + '</div>' +
      '<div class="card-footer">' +
      '<ul>' +
      '<li>' + s20 + '</li>' +
      '</ul> ' +
      '</div>' +
      '</div>' +

      '<div class="card card-outline">' +
      '<div class="card-header">' +
      '<div class="chip">' +
      '<div class="chip-media">' +
      '<span class="badge color-blue">5</span>' +
      '</div>' +
      '<div class="chip-label">' + s21 + '</div>' +
      '</div>' +
      '</div>' +
      '<div class="card-content card-content-padding">' + s22 + '</div>' +
      '</div>' +

      '</div>' +
      '</div>' +

      '</div>' +
      '</div>',
    // Events
    on: {
      open: function (sheet) {
        // console.log('Sheet open');
      },
      opened: function (sheet) {
        // console.log('Sheet opened');
      },
    }
  }).open();
}

function ShowRestoreAssistentForOlderBackups() {
  s1 = language.de.restoreAssistentForOlderTitle;
  s2 = language.de.close;
  s3 = language.de.restoreAssistentLogin;
  s4 = language.de.restoreAssistentLoginHeader;
  s5 = language.de.restoreAssistentLoginStep1;
  s6 = language.de.restoreAssistentLoginStep2;
  s7 = language.de.restoreAssistentLoginStep3;
  s8 = language.de.restoreAssistentRestore;
  s9 = language.de.restoreAssistentRestoreHeader;
  s10 = language.de.restoreAssistentRestoreStep1;
  s11 = language.de.restoreAssistentRestoreStep2;
  s12 = language.de.restoreAssistentRestoreStep3;
  s13 = language.de.restoreAssistentRestoreStep41;
  s14 = language.de.restoreAssistentRestoreStep5;
  s15 = language.de.restoreAssistentBackupSelection;
  s16 = language.de.restoreAssistentBackupSelectionHeader;
  s17 = language.de.restoreAssistentBackupSelectionStep1;
  s18 = language.de.restoreAssistentBackupSelectionStep2;
  s19 = language.de.restoreAssistentBackupSelectionStep3;
  s20 = language.de.restoreAssistentActivation;
  s21 = language.de.restoreAssistentActivationHeader;
  s22 = language.de.restoreAssistentActivationStep1;
  s23 = language.de.restoreAssistentChangings;
  s24 = language.de.restoreAssistentChangingsHeader;
  s25 = language.de.restoreAssistentChangingsStep1;
  s26 = language.de.restoreAssistentFinish;
  s27 = language.de.restoreAssistentFinishHeader;

  if (IsEnglishLanguage()) {
    s1 = language.eng.restoreAssistentForOlderTitle;
    s2 = language.eng.close;
    s3 = language.eng.restoreAssistentLogin;
    s4 = language.eng.restoreAssistentLoginHeader;
    s5 = language.eng.restoreAssistentLoginStep1;
    s6 = language.eng.restoreAssistentLoginStep2;
    s7 = language.eng.restoreAssistentLoginStep3;
    s8 = language.eng.restoreAssistentRestore;
    s9 = language.eng.restoreAssistentRestoreHeader;
    s10 = language.eng.restoreAssistentRestoreStep1;
    s11 = language.eng.restoreAssistentRestoreStep2;
    s12 = language.eng.restoreAssistentRestoreStep3;
    s13 = language.eng.restoreAssistentRestoreStep41;
    s14 = language.eng.restoreAssistentRestoreStep5;
    s15 = language.eng.restoreAssistentBackupSelection;
    s16 = language.eng.restoreAssistentBackupSelectionHeader;
    s17 = language.eng.restoreAssistentBackupSelectionStep1;
    s18 = language.eng.restoreAssistentBackupSelectionStep2;
    s19 = language.eng.restoreAssistentBackupSelectionStep3;
    s20 = language.eng.restoreAssistentActivation;
    s21 = language.eng.restoreAssistentActivationHeader;
    s22 = language.eng.restoreAssistentActivationStep1;
    s23 = language.eng.restoreAssistentChangings;
    s24 = language.eng.restoreAssistentChangingsHeader;
    s25 = language.eng.restoreAssistentChangingsStep1;
    s26 = language.eng.restoreAssistentFinish;
    s27 = language.eng.restoreAssistentFinishHeader;
  }

  app.sheet.create({
    content: '<div class="sheet-modal" style="height:100%">' +
      '<div class="toolbar">' +
      '<div class="toolbar-inner">' +
      '<div class="left"></div>' +
      '<div class="title">' + s1 + '</div>' +
      '<div class="right"><a class="link sheet-close">' + s2 + '</a></div>' +
      '</div>' +
      '</div>' +
      '<div class="sheet-modal-inner">' +

      '<div class="page-content">' +
      '<div class="block">' +

      '<div class="card card-outline">' +
      '<div class="card-header">' +
      '<div class="chip">' +
      '<div class="chip-media">' +
      '<span class="badge color-blue">1</span>' +
      '</div>' +
      '<div class="chip-label">' + s3 + '</div>' +
      '</div>' +
      '</div>' +
      '<div class="card-content card-content-padding">' + s4 + '</div>' +
      '<div class="card-footer">' +
      '<ul>' +
      '<li>' + s5 + '</li>' +
      '<li>' + s6 + '</li>' +
      '<li>' + s7 + '</li>' +
      '</ul> ' +
      '</div>' +
      '</div>' +

      '<div class="card card-outline">' +
      '<div class="card-header">' +
      '<div class="chip">' +
      '<div class="chip-media">' +
      '<span class="badge color-blue">2</span>' +
      '</div>' +
      '<div class="chip-label">' + s8 + '</div>' +
      '</div>' +
      '</div>' +
      '<div class="card-content card-content-padding">' + s9 + '</div>' +
      '<div class="card-footer">' +
      '<ul>' +
      '<li>' + s10 + '</li>' +
      '<li>' + s11 + '</li>' +
      '<li>' + s12 + '</li>' +
      '<li>' + s13 + '</li>' +
      '<li>' + s14 + '</li>' +
      '</ul> ' +
      '</div>' +
      '</div>' +

      '<div class="card card-outline">' +
      '<div class="card-header">' +
      '<div class="chip">' +
      '<div class="chip-media">' +
      '<span class="badge color-blue">3</span>' +
      '</div>' +
      '<div class="chip-label">' + s15 + '</div>' +
      '</div>' +
      '</div>' +
      '<div class="card-content card-content-padding">' + s16 + '</div>' +
      '<div class="card-footer">' +
      '<ul>' +
      '<li>' + s17 + '</li>' +
      '<li>' + s18 + '</li>' +
      '<li>' + s19 + '</li>' +
      '</ul> ' +
      '</div>' +
      '</div>' +

      '<div class="card card-outline">' +
      '<div class="card-header">' +
      '<div class="chip">' +
      '<div class="chip-media">' +
      '<span class="badge color-blue">4</span>' +
      '</div>' +
      '<div class="chip-label">' + s20 + '</div>' +
      '</div>' +
      '</div>' +
      '<div class="card-content card-content-padding">' + s21 + '</div>' +
      '<div class="card-footer">' +
      '<ul>' +
      '<li>' + s22 + '</li>' +
      '</ul> ' +
      '</div>' +
      '</div>' +

      '<div class="card card-outline">' +
      '<div class="card-header">' +
      '<div class="chip">' +
      '<div class="chip-media">' +
      '<span class="badge color-blue">5</span>' +
      '</div>' +
      '<div class="chip-label">' + s23 + '</div>' +
      '</div>' +
      '</div>' +
      '<div class="card-content card-content-padding">' + s24 + '</div>' +
      '<div class="card-footer">' +
      '<ul>' +
      '<li>' + s25 + '</li>' +
      '</ul> ' +
      '</div>' +
      '</div>' +

      '<div class="card card-outline">' +
      '<div class="card-header">' +
      '<div class="chip">' +
      '<div class="chip-media">' +
      '<span class="badge color-blue">6</span>' +
      '</div>' +
      '<div class="chip-label">' + s26 + '</div>' +
      '</div>' +
      '</div>' +
      '<div class="card-content card-content-padding">' + s27 + '</div>' +
      '</div>' +

      '</div>' +
      '</div>' +

      '</div>' +
      '</div>',
    // Events
    on: {
      open: function (sheet) {
        // console.log('Sheet open');
      },
      opened: function (sheet) {
        // console.log('Sheet opened');
      },
    }
  }).open();
}

// function RestoreBackup(path) {
//   log('RestoreBackup: ' + path);

//   app.dialog.create({
//     title: currentLanguage !== 'de' ? language.eng.restoreBackup : language.de.restoreBackup,
//     buttons: [
//       {
//         color: 'deeporange',
//         text: currentLanguage !== 'de' ? language.eng.yes : language.de.yes,
//         onClick: function () {
//           path = path.replace(/!/g, '\\');
//           sendRequestToServer(COMMANDS.RESTORE_BACKUP, encodeURIComponent(path), RestoreBackupCallback)
//         }
//       },
//       {
//         color: 'deeporange',
//         text: currentLanguage !== 'de' ? language.eng.no : language.de.no
//       }
//     ]
//   }).open();
// }

// function RestoreBackupCallback(responseText) {
//   log('RestoreBackupCallback: ' + responseText);

// }

// function RestoreRobot(ip) {
//   log('RestoreRobot: ' + ip);

//   app.dialog.create({
//     title: currentLanguage !== 'de' ? language.eng.restoreRobot : language.de.restoreRobot,
//     buttons: [
//       {
//         color: 'deeporange',
//         text: currentLanguage !== 'de' ? language.eng.yes : language.de.yes,
//         onClick: function () {
//           path = path.replace(/!/g, '\\');
//           sendRequestToServer(COMMANDS.RESTORE_ROBOT, encodeURIComponent(path), RestoreRobotCallback)
//         }
//       },
//       {
//         color: 'deeporange',
//         text: currentLanguage !== 'de' ? language.eng.no : language.de.no
//       }
//     ]
//   }).open();
// }

// function RestoreRobotCallback(responseText) {
//   log('RestoreRobotCallback: ' + responseText);

// }

function DownloadBackup(path) {
  log('DownloadBackup: ' + path);
  path = path.replace(/!/g, '\\');
  sendRequestToServer(COMMANDS.DOWNLOAD_BACKUP, encodeURIComponent(path), DownloadBackupCallback)
}

function DownloadBackupCallback(responseText) {
  log('DownloadBackupCallback: ' + responseText);

  if (!responseText) {
    return;
  }

  result = JSON.parse(responseText);

  if (result === false) {
    t = currentLanguage !== 'de' ? language.eng.downloadBackupError + ' ' + language.eng.checkMessages : language.de.downloadBackupError + ' ' + language.de.checkMessages;
    app.dialog.alert(t, '');
    return;
  }

  app.dialog.create({
    title: currentLanguage !== 'de' ? language.eng.downloadBackupOk : language.de.downloadBackupOk,
    buttons: [
      {
        color: 'deeporange',
        text: currentLanguage !== 'de' ? language.eng.ok : language.de.ok,
        onClick: function () {
          Download(result[0], result[1]);
        }
      },
      {
        color: 'deeporange',
        text: currentLanguage !== 'de' ? language.eng.cancel : language.de.cancel
      }
    ]
  }).open();
}

function OpenExplorer(path) {

  input = document.createElement('input');
  input.type = 'file';
}

function CreateRobotInfoOptionItems(rob) {

  if (!rob) {
    return '';
  }

  options = [];
  info = rob.Info;

  if (info) {
    options = info.Options
  }

  result = '<div class="list">'
    + '<ul>';

  if (options && options.length < 1) {
    result += CreateRobotInfoOptionItem();
  } else {
    options.forEach(element => {
      result += CreateRobotInfoOptionItem(element);
    });
  }

  result += '</ul>'
    + '</div>';

  return result;
}

function CreateRobotInfoOptionItem(item) {

  if (!item) {
    return '<li>'
      + '     <div class="item-content">'
      + '        <div class="item-inner">'
      + '         <div class="item-title"> - </div>'
      + '       </div>'
      + '      </div>'
      + '    </li>';
  }

  v = item.Version;
  version = 'V' + '.' + v.Major + '.' + v.Minor + '.' + v.Build + '.' + v.Revision;

  return '<li>'
    + '     <div class="item-content">'
    + '       <div class="item-inner">'
    + '          <div class="item-title">' + item.Name + '</div>'
    + '         <div class="item-after">' + version + '</div>'
    + '        </div>'
    + '      </div>'
    + '    </li>'
}

function OpenRobotManagement() {

  s1 = language.de.robotManagementDialogTitle;
  s2 = language.de.robotManagementDialogSearchForRobots;
  s3 = language.de.robotManagementDialogAddRobot;
  s4 = language.de.robotManagementDialogImport;
  s5 = language.de.robotManagementDialogGroupRobots;
  s6 = language.de.close;

  if (IsEnglishLanguage()) {
    s1 = language.eng.robotManagementDialogTitle;
    s2 = language.eng.robotManagementDialogSearchForRobots;
    s3 = language.eng.robotManagementDialogAddRobot;
    s4 = language.eng.robotManagementDialogImport;
    s5 = language.eng.robotManagementDialogGroupRobots;
    s6 = language.eng.close;
  }

  app.dialog.create({
    title: s1,
    buttons: [
      {
        color: 'deeporange',
        text: s2,
        onClick: function () {
          SearchForRobotsClick();
        }
      },
      {
        color: 'deeporange',
        text: s3,
        onClick: function () {
          AddRobot();
        }
      },
      {
        color: 'deeporange',
        text: s4,
        onClick: function () {
          LoadRobotFile();
        }
      },
      {
        color: 'deeporange',
        text: currentLanguage !== 'de' ? language.eng.deleteAll : language.de.deleteAll,
        onClick: function () {
          DeleteAllRobots();
        }
      },
      //TODO Gruppieren implementieren 
      // {
      //   color: 'deeporange',
      //   text: s5, //gruppieren
      //   onClick: function () {
      //     FunctionNotAvailable();
      //   }
      // },
      {
        color: 'deeporange',
        text: s6,
      },
    ],
    verticalButtons: true,
  }).open();
}

function OpenSettings() {
  //TODO Settings einstellbar 
  FunctionNotAvailable();
}

function AddRobot() {

  s1 = language.de.enterIpAdress;
  s2 = language.de.invalidIpAdress;
  s3 = language.de.confirmIpAdress;

  if (IsEnglishLanguage()) {
    s1 = language.eng.enterIpAdress;
    s2 = language.eng.invalidIpAdress;
    s3 = language.eng.confirmIpAdress;
  }

  app.dialog.prompt(s1, '', function (ip) {

    if (!ValidateIPaddress(ip)) {
      s2 += ' (' + ip + ')';
      app.dialog.alert(s2, '');
      return;
    }

    s3 += ' (' + ip + ')';
    app.dialog.confirm(s3, '', function () {
      sendRequestToServer(COMMANDS.ADD_ROBOT, ip, AddRobotCallback)
    });
  }, null, '0.0.0.0');
}

function AddRobotCallback(responseText) {
  log('AddRobotCallback: ' + responseText);

  if (responseText === 'undefined' || responseText === '') {
    return;
  }

  result = JSON.parse(responseText);

  if (result === null || result === undefined) {
    return;
  }

  //NEW_ROBOT_IS_NULL,
  //STILL_AVAILABLE,
  //OK

  s1 = language.de.robotAddedSuccessfully;
  s2 = language.de.robotAddedStillAvailable;
  s3 = language.de.robotAddedError + ' ' + language.de.checkMessages;

  if (IsEnglishLanguage()) {
    s1 = language.eng.robotAddedSuccessfully;
    s2 = language.eng.robotAddedStillAvailable;
    s3 = language.eng.robotAddedError + ' ' + language.eng.checkMessages;
  }

  if (result.Result === 'OK') {
    s1 += ' (' + result.Ip + ')';
    app.dialog.alert(s1, '');
    sendRequestToServer(COMMANDS.GET_ROBOTS, null, GetRobotsCallback);
  } else if (result.Result === 'STILL_AVAILABLE') {
    s2 += ' (' + result.Ip + ')';
    app.dialog.alert(s2, '');
  } else {
    app.dialog.alert(s3, '');
  }
}

function LoadRobotFile() {

  // Check for the various File API support.
  if (window.File && window.FileReader && window.FileList && window.Blob) {
    // Great success! All the File APIs are supported.
  } else {
    s = language.de.notSupported;
    if (IsEnglishLanguage()) {
      s = language.eng.notSupported;
    }
    app.dialog.alert(s);
    return;
  }

  input = document.createElement('input');
  input.type = 'file';
  input.accept = '.csv';

  input.onchange = e => {
    file = e.target.files[0];
    filename = file.name;
    ext = filename.substring(filename.lastIndexOf('.') + 1);

    if (ext !== 'csv') {
      s = language.de.invalidFileExtension;
      if (IsEnglishLanguage()) {
        s = language.eng.invalidFileExtension;
      }
      app.dialog.alert(s, '');
      return;
    }

    var reader = new FileReader();
    var senddata = new Object();

    // Auslesen der Datei-Metadaten
    senddata.name = file.name;
    senddata.date = file.lastModified;
    senddata.size = file.size;
    senddata.type = file.type;

    // Wenn der Dateiinhalt ausgelesen wurde...
    reader.onload = function (theFileData) {
      senddata.fileData = theFileData.target.result; // Ergebnis vom FileReader auslesen

      /*
      Code für AJAX-Request hier einfügen
      */

      json = JSON.stringify(senddata);
      postToServer(COMMANDS.UPLOAD_CSV, senddata.fileData, UploadCsvCallback);
    }

    // Die Datei einlesen und in eine Data-URL konvertieren
    reader.readAsBinaryString(file);
  }

  input.click();
}

function UploadCsvCallback(responseText) {
  log('UploadCsvCallback: ' + responseText);

}

function OpenBackupManagement() {
  OpenBackupManagementPopup();
}

function OpenBackupManagementPopup() {
  sendRequestToServer(COMMANDS.GET_SHEDULED_JOBS, null, OpenBackupManagementPopupCallback);
}

function OpenBackupManagementPopupCallback(responseText) {
  log('OpenBackupManagementPopupCallback: ' + responseText)

  sheduledJobs = null;
  if (responseText) {
    sheduledJobs = JSON.parse(responseText);
  }

  s1 = language.de.close;
  s2 = language.de.openBackupManagement;
  s3 = language.de.createNewBackupJob;
  s4 = language.de.days;
  s5 = language.de.time;
  s6 = language.de.robotCount;
  if (IsEnglishLanguage()) {
    s1 = language.eng.close;
    s2 = language.eng.openBackupManagement;
    s3 = language.eng.createNewBackupJob;
    s4 = language.eng.days;
    s5 = language.eng.time;
    s6 = language.eng.robotCount;
  }

  myContent = '<div class="popup my-popup">'
    + '<div class="view">'
    + '<div class="page color-deeporange">'
    + '<div class="navbar">'
    + '<div class="navbar-bg"></div>'
    + '<div class="navbar-inner">'
    + '<div class="left">'
    + '<a class="link popup-close">' + s1 + '</a>'
    + '</div>'
    + '<div class="title">' + s2 + '</div>'
    + '<div class="right">'
    + '<a class="link popup-close"><i class="icon f7-icons" onclick="OpenBackupManagementPopup()">arrow_clockwise</i></a>'
    + '</div>'
    + '</div>'
    + '</div>'
    + '<div class="page-content">'

    + '<div class="block block-strong" style="margin-top: unset;margin-bottom: unset;">'
    + '<button class="button button-large button-fill popup-close color-blue" onclick="OpenCreateBackupJobPopup()">' + s3 + '</button>'
    + '</div>'

    + '<div class="block block-strong" style="margin-top: unset;margin-bottom: unset;margin-left: unset;margin-right: unset;">'
    + '<div class="data-table" style="margin-left: unset;margin-right: unset;">'
    + '<table>'

    + '<thead>'
    + '<tr>'
    + '<th class="label-cell" style="text-align: center;"></th>'
    + '<th class="label-cell">Name</th>'
    + '<th class="label-cell" style="text-align: center;">' + s4 + '</th>'
    + '<th class="label-cell" style="text-align: center;">' + s5 + '</th>'
    + '<th class="label-cell" style="text-align: center;">' + s6 + '</th>'
    + '<th class="label-cell" style="text-align: center;"></th>'
    + '</tr>'
    + '</thead>'

    + '<tbody>';

  if (sheduledJobs && sheduledJobs.length > 0) {
    sheduledJobs.forEach(element => {
      myContent += '<tr>'
      myContent += '<td class="label-cell popup-close"><a class="icon f7-icons color-deeporange" onclick="OpenCreateBackupJobPopup(\'' + element.Name + '\')">pencil_circle</a></td>'
      myContent += '<td class="label-cell">' + element.Name + '</td>'
      myContent += '<td class="label-cell" style="text-align: center;">' + element.DaysOfBackup.length + '</td>'
      myContent += '<td class="label-cell" style="text-align: center;">' + element.TimeOfBackup + '</td>'
      myContent += '<td class="label-cell" style="text-align: center;">' + element.Robots.length + '</td>'
      myContent += '<td class="label-cell popup-close"><a class="icon f7-icons color-deeporange" onclick="RemoveJob(\'' + element.Name + '\')">xmark_circle</a></td>'
      myContent += '</tr>'
    });
  } else {
    myContent += '<tr>'
    myContent += '<td class="label-cell"></td>'
    myContent += '<td class="label-cell"></td>'
    myContent += '<td class="label-cell" style="text-align: center;"></td>'
    myContent += '<td class="label-cell" style="text-align: center;"></td>'
    myContent += '<td class="label-cell" style="text-align: center;"></td>'
    myContent += '<td class="label-cell"></td>'
    myContent += '</tr>'
  }

  myContent += '</tbody>'

    + '</table>'
    + '</div>'
    + '</div>'

    + '</div>'
    + '</div>'
    + '</div>'
    + '</div>'

  app.popup.create({
    content: myContent,
    on: {
      closed: function () {
        // sendRequestToServer(COMMANDS.RELEASE_SHEDULED_JOBS);
      }
    }
  }).open();
}

function RemoveJob(name) {
  log('RemoveJob: ' + name)

  s1 = language.de.deleteBackupJob;
  s2 = language.de.yes;
  s3 = language.de.no;
  if (IsEnglishLanguage()) {
    s1 = language.eng.deleteBackupJob;
    s2 = language.eng.yes;
    s3 = language.eng.no;
  }

  s1 += ' (' + name + ')';
  app.dialog.create({
    title: s1,
    buttons: [
      {
        color: 'deeporange',
        text: s2,
        onClick: function () {
          sendRequestToServer(COMMANDS.REMOVE_SHEDULED_JOB, encodeURIComponent(name), RemoveJobCallback);
        }
      },
      {
        color: 'deeporange',
        text: s3,
        onClick: function () {

        }
      }
    ]
  }).open();
}

function RemoveJobCallback(responseText) {
  log('RemoveJobCallback: ' + responseText)

  r = JSON.parse(responseText);
  t = '';

  if (r === 'null') {
    t = currentLanguage !== 'de' ? language.eng.noDataSendToServer : language.de.noDataSendToServer;
  } else if (r === 'ERROR') {
    t = currentLanguage !== 'de' ? language.eng.deleteBackupJobError : language.de.deleteBackupJobError;
  } else if (r === 'NOT_AVAILABLE') {
    t = currentLanguage !== 'de' ? language.eng.deleteBackupJobNotAvailable : language.de.deleteBackupJobNotAvailable;
  } else {
    t = currentLanguage !== 'de' ? language.eng.backupJobAddedSuccessfully : language.de.backupJobAddedSuccessfully;
    OpenBackupManagementPopup();
  }

  app.toast.create({
    text: t,
    position: 'center',
    closeTimeout: 2000,
  }).open();

}

function OpenCreateBackupJobPopup(name) {

  if (!robots || robots.length < 1) {
    app.toast.create({
      text: currentLanguage !== 'de' ? language.eng.noRobotsAvailable : language.de.noRobotsAvailable,
      position: 'center',
      closeTimeout: 2000,
    }).open();
    return;
  }

  reopenBackupManagement = false;
  jobName = '';
  jobEmails = '';
  jobTime = '';
  jobRobots = [];

  jobWeekdays = '';
  monday = currentLanguage !== 'de' ? dayOfWeek.eng.Monday : dayOfWeek.de.Monday;
  tuesday = currentLanguage !== 'de' ? dayOfWeek.eng.Tuesday : dayOfWeek.de.Tuesday;
  wednesday = currentLanguage !== 'de' ? dayOfWeek.eng.Wednesday : dayOfWeek.de.Wednesday;
  thursday = currentLanguage !== 'de' ? dayOfWeek.eng.Thursday : dayOfWeek.de.Thursday;
  friday = currentLanguage !== 'de' ? dayOfWeek.eng.Friday : dayOfWeek.de.Friday;
  saturday = currentLanguage !== 'de' ? dayOfWeek.eng.Saturday : dayOfWeek.de.Saturday;
  sunday = currentLanguage !== 'de' ? dayOfWeek.eng.Sunday : dayOfWeek.de.Sunday;

  mondaySelected = '';
  tuesdaySelected = '';
  wednesdaySelected = '';
  thursdaySelected = '';
  fridaySelected = '';
  saturdaySelected = '';
  sundaySelected = '';

  jobTime = '';

  s1 = language.de.cancel;
  s2 = language.de.backupJobPopupTitle;
  s3 = language.de.assume;
  s4 = language.de.executeNow;
  s5 = language.de.required;
  s6 = language.de.optional;
  s7 = language.de.backupJobPopupName;
  s8 = language.de.email;
  s9 = language.de.backupJobPopupEmailPlaceholder;
  s10 = language.de.weekdays;
  s11 = language.de.time;
  s12 = language.de.backupJobPopupTimePlaceholder;
  s13 = language.de.backupJobPopupRobotSelection;

  if (IsEnglishLanguage()) {
    s1 = language.eng.cancel;
    s2 = language.eng.backupJobPopupTitle;
    s3 = language.eng.assume;
    s4 = language.eng.executeNow;
    s5 = language.eng.required;
    s6 = language.eng.optional;
    s7 = language.eng.backupJobPopupName;
    s8 = language.eng.email;
    s9 = language.eng.backupJobPopupEmailPlaceholder;
    s10 = language.eng.weekdays;
    s11 = language.eng.time;
    s12 = language.eng.backupJobPopupTimePlaceholder;
    s13 = language.eng.backupJobPopupRobotSelection;
  }

  if (name) {
    found = sheduledJobs.find(s => s.Name === name);
    if (found) {
      reopenBackupManagement = true;

      if (IsEnglishLanguage()) {
        s2 = language.eng.backupJobEditPopupTitle;
      } else {
        s2 = language.de.backupJobEditPopupTitle;
      }

      jobName = name;
      jobTime = found.TimeOfBackup;
      jobRobots = found.Robots;

      if (found.DaysOfBackup && found.DaysOfBackup.length > 0) {
        found.DaysOfBackup.forEach(d => {
          if (d === 0) {
            jobWeekdays += sunday + ', ';
            sundaySelected = 'selected';
          } else if (d === 1) {
            jobWeekdays += monday + ', ';
            mondaySelected = 'selected';
          } else if (d === 2) {
            jobWeekdays += tuesday + ', ';
            tuesdaySelected = 'selected';
          } else if (d === 3) {
            jobWeekdays += wednesday + ', ';
            wednesdaySelected = 'selected';
          } else if (d === 4) {
            jobWeekdays += thursday + ', ';
            thursdaySelected = 'selected';
          } else if (d === 5) {
            jobWeekdays += friday + ', ';
            fridaySelected = 'selected';
          } else if (d === 6) {
            jobWeekdays += saturday + ', ';
            saturdaySelected = 'selected';
          }
        });

        jobWeekdays = jobWeekdays.substring(0, jobWeekdays.length - 2);
      }

      if (found.EmailAddresses) {
        jobEmails = found.EmailAddresses;
      }
    }
  } else {
    //vorausgewählte Roboter ermitteln
    x = document.getElementsByName("toogleCheckbox");

    if (x && x.length > 0) {
      x.forEach(element => {
        if (element.checked) {
          jobRobots.push({ Key: element.id });
        }
      });
    }
  }

  monday = currentLanguage !== 'de' ? dayOfWeek.eng.Monday : dayOfWeek.de.Monday;
  tuesday = currentLanguage !== 'de' ? dayOfWeek.eng.Tuesday : dayOfWeek.de.Tuesday;
  wednesday = currentLanguage !== 'de' ? dayOfWeek.eng.Wednesday : dayOfWeek.de.Wednesday;
  thursday = currentLanguage !== 'de' ? dayOfWeek.eng.Thursday : dayOfWeek.de.Thursday;
  friday = currentLanguage !== 'de' ? dayOfWeek.eng.Friday : dayOfWeek.de.Friday;
  saturday = currentLanguage !== 'de' ? dayOfWeek.eng.Saturday : dayOfWeek.de.Saturday;
  sunday = currentLanguage !== 'de' ? dayOfWeek.eng.Sunday : dayOfWeek.de.Sunday;

  content = '<div class="popup my-popup">'
    + '<div class="view">'
    + '<div class="page color-deeporange">'
    + '<div class="navbar">'
    + '<div class="navbar-bg"></div>'
    + '<div class="navbar-inner">'
    + '<div class="left">'
    + '<a class="link popup-close">' + s1 + '</a>'
    + '</div>'
    + '<div class="title">' + s2 + '</div>'
    + '<div class="right">'
    + '<a class="link" onclick="CreateBackupJob(\'' + jobName + '\')">' + s3 + '</a>'
    + '</div>'
    + '</div>'
    + '</div>'
    + '<div class="page-content">';

  if (jobName !== '') {
    content += '<div class="block block-strong" style="margin-top: unset;margin-bottom: unset;">'
      + '<button class="button button-large button-fill popup-close color-blue" onclick="StartJob(\'' + jobName + '\')">' + s4 + '</button>'
      + '</div>';
  }

  content += '<div class="list no-hairlines-md" style="margin-top: unset;">'
    + '<ul>'

    + '  <li class="item-content item-input item-input-with-info">'
    + '    <div class="item-inner">'
    + '      <div class="item-title item-label">' + s7 + '</div>'
    + '      <div class="item-input-wrap">'
    + '        <input id="nameInput" type="text" value="' + jobName + '" placeholder="Name" required validate>'
    + '        <span class="input-clear-button"></span>'
    + '        <div class="item-input-info">' + s5 + '</div>'
    + '      </div>'
    + '    </div>'
    + '  </li>'

    + '  <li class="item-content item-input item-input-with-info">'
    + '    <div class="item-inner">'
    + '      <div class="item-title item-label">' + s8 + '</div>'
    + '      <div class="item-input-wrap">'
    + '       <input id="emailsInput" value="' + jobEmails + '" type="text" placeholder="' + s9 + '">'
    + '       <span class="input-clear-button"></span>'
    + '       <div class="item-input-info">' + s6 + '</div>'
    + '     </div>'
    + '   </div>'
    + '  </li>'

    + ' <li class="item-content item-input item-input-with-info">'
    + '    <div class="item-inner">'
    + '      <div class="item-title item-label">' + s10 + '</div>'
    + '      <div class="item-input-wrap">'
    + '       <div class="item-link smart-select smart-select-init" data-open-in="popover">'
    + '         <select id="mySmartSelect" multiple>'
    + '            <option value="0" ' + mondaySelected + '>' + monday + '</option>'
    + '            <option value="1" ' + tuesdaySelected + '>' + tuesday + '</option>'
    + '            <option value="2" ' + wednesdaySelected + '>' + wednesday + '</option>'
    + '            <option value="3" ' + thursdaySelected + '>' + thursday + '</option>'
    + '            <option value="4" ' + fridaySelected + '>' + friday + '</option>'
    + '            <option value="5" ' + saturdaySelected + '>' + saturday + '</option>'
    + '            <option value="6" ' + sundaySelected + '>' + sunday + '</option>'
    + '          </select>'
    + '          <div class="item-inner">'
    + '            <div class="item-title"></div>'
    + '           <div id="weekdaySelector" class="item-after" style="max-width: unset;">' + jobWeekdays + '</div>'
    + '         </div>'
    + '        </div>'
    + '      </div>'
    + '    </div>'
    + '  </li>'

    + '  <li class="item-content item-input item-input-with-info">'
    + '    <div class="item-inner">'
    + '      <div class="item-title item-label">' + s11 + '</div>'
    + '      <div class="item-input-wrap">'
    + '        <!-- <input type="email" placeholder="Uhrzeit auswählen" required validate> -->'
    + '        <input id="timeInput" value="' + jobTime + '" type="text" placeholder="' + s12 + '" readonly="readonly" required validate>'
    + '        <span class="input-clear-button"></span>'
    + '        <div class="item-input-info">' + s5 + '</div>'
    + '      </div>'
    + '    </div>'
    + '  </li>'

    + ' <li class="item-content item-input item-input-with-info">'
    + '    <div class="item-inner">'
    + '      <div class="item-title item-label">' + s13 + '</div>'
    + '     <div class="item-input-wrap">'

    + '       <div class="list no-hairlines-between" style="margin-top: unset;margin-bottom: unset;max-height:500px">'
    + '         <ul id="robotSelectionList" style="padding-left: unset;max-height:500px;overflow:auto;">';

  robots.forEach(element => {
    str = CreateJobRobot(element, jobRobots);
    content += str;
  });

  content += '</ul>'
    + '</div>'
    + '</div>'
    + '</div>'
    + '</li>'
    + '</ul>'

    + '</div>'

    + '</div>'
    + '</div>'
    + '</div>'
    + '</div>';

  backupJobPopup = app.popup.create({
    content: content,
    on: {
      close: function () {
        if (reopenBackupManagement) {
          OpenBackupManagementPopup();
        }
      }
    }
  }).open();

  hour = '00';
  minutes = '00';

  if (jobTime !== '') {
    s = jobTime.split(':');
    hour = s[0];
    minutes = s[1];
  }

  app.picker.create({
    inputEl: '#timeInput',
    rotateEffect: true,
    cols: [
      {
        textAlign: 'left',
        values: ('00 01 02 03 04 05 06 07 08 09 10 11 12 13 14 15 16 17 18 19 20 21 22 23').split(' ')
      },
      {
        values: ('00 05 10 15 20 25 30 35 40 45 50 55').split(' ')
      }

    ],
    value: [hour, minutes]
  });

}

function StartJob(name) {

  if (!name) {
    return;
  }

  sendRequestToServer(COMMANDS.START_SHEDULED_JOB, name, StartJobCallback);
}

function StartJobCallback(responseText) {
  log('StartJobCallback: ' + responseText);

  if (!responseText) {
    return;
  }

  text = '';
  if (responseText === 'ERROR') {
    t = currentLanguage !== 'de' ? language.eng.backupJobStartError + ' ' + language.eng.checkMessages : language.de.backupJobStartError + ' ' + language.de.checkMessages;
  } else if (responseText === 'NOT_AVAILABLE') {
    t = currentLanguage !== 'de' ? language.eng.jobNotFound : language.de.jobNotFound;
  } else {
    t = currentLanguage !== 'de' ? language.eng.backupJobStartOk : language.de.backupJobStartOk;
  }

  app.toast.create({
    text: t,
    position: 'center',
    closeTimeout: 2000,
  }).open();

}

function CreateJobRobot(rob, jobRobots) {

  if (!rob) {
    return '';
  }

  checked = '';

  if (jobRobots && jobRobots.length > 0) {
    found = jobRobots.find(r => r.Key === rob.Ip);
    if (found) {
      checked = 'checked';
    }
  } else {
    checked = 'checked';
  }

  return '<li>' +
    '<div class="item-content">' +
    '<div class="item-media">' +
    '<label class="toggle color-blue">' +
    '<input id="jobRobRadio_' + rob.Name + '" name="jobRobRadio" type="checkbox" ' + checked + '>' +
    '<span class="toggle-icon"></span>' +
    '</label></div>' +
    '<div class="item-inner">' +
    '<div class="item-title">' + rob.Name + '</div>' +
    '</div>' +
    '</div>' +
    '</li>';
}

var backupJobPopup;

function CreateBackupJob(jobName) {

  newJob = CreateNewBackupJob();

  if (!newJob) {
    return;
  }

  if (jobName) {
    sendRequestToServer(COMMANDS.UPDATE_SHEDULED_JOB, JSON.stringify(newJob), UpdateBackupJobCallback);
  } else {
    sendRequestToServer(COMMANDS.ADD_SHEDULED_JOB, JSON.stringify(newJob), CreateNewBackupJobCallback);
  }

  if (backupJobPopup) {
    backupJobPopup.close();
  }
}

function UpdateBackupJobCallback(responseText) {
  log('UpdateBackupJobCallback: ' + responseText);

  r = JSON.parse(responseText);
  t = '';

  if (r === 'null') {
    t = currentLanguage !== 'de' ? language.eng.noDataSendToServer : language.de.noDataSendToServer;
  } else if (reopenBackupJobs === 'ERROR') {
    t = currentLanguage !== 'de' ? language.eng.backupJobEditError + ' ' + language.eng.checkMessages : language.de.backupJobEditError + ' ' + language.de.checkMessages;
  } else if (r === 'NOT_AVAILABLE') {
    t = currentLanguage !== 'de' ? language.eng.jobNotFound : language.de.jobNotFound;
  } else if (r === 'EQUAL') {
    t = currentLanguage !== 'de' ? language.eng.backupJobEditEqual : language.de.backupJobEditEqual;
  } else {
    t = currentLanguage !== 'de' ? language.eng.backupJobEditOk : language.de.backupJobEditOk;
    OpenBackupManagementPopup();
  }

  app.toast.create({
    text: t,
    position: 'center',
    closeTimeout: 2000,
  }).open();

}

function CreateNewBackupJobCallback(responseText) {
  log('CreateNewBackuJobCallback: ' + responseText);

  r = JSON.parse(responseText);
  t = '';

  if (r === 'null') {
    t = currentLanguage !== 'de' ? language.eng.noDataSendToServer : language.de.noDataSendToServer;
  } else if (reopenBackupJobs === 'ERROR') {
    t = currentLanguage !== 'de' ? language.eng.backupJobCreateError + ' ' + language.eng.checkMessages : language.de.backupJobCreateError + ' ' + language.de.checkMessages;
  } else if (r === 'STILL_AVAILABLE') {
    t = currentLanguage !== 'de' ? language.eng.backupJobCreateAlreadyExists : language.de.backupJobCreateAlreadyExists;
  } else {
    t = currentLanguage !== 'de' ? language.eng.backupJobCreateOk : language.de.backupJobCreateOk;
    OpenBackupManagementPopup();
  }

  app.toast.create({
    text: t,
    position: 'center',
    closeTimeout: 2000,
  }).open();
}

function CreateNewBackupJob() {

  jobName = document.getElementById('nameInput').value;
  jobEmails = document.getElementById('emailsInput').value;
  jobTime = document.getElementById('timeInput').value.replace(' ', ':');
  jobWeekdays = GetWeekdays();
  jobRobots = GetJobRobots();

  if (jobName === '' || jobTime === '' || !jobWeekdays || jobWeekdays.length < 1 || !jobRobots || jobRobots.length < 1) {
    t = '';

    if (jobName === '') {
      t = currentLanguage !== 'de' ? language.eng.backupJobCheckNoName : language.de.backupJobCheckNoName;
    } else if (jobTime === '') {
      t = currentLanguage !== 'de' ? language.eng.backupJobCheckNoTime : language.de.backupJobCheckNoTime;
    } else if (!jobWeekdays || jobWeekdays.length < 1) {
      t = currentLanguage !== 'de' ? language.eng.backupJobCheckNoDays : language.de.backupJobCheckNoDays;
    } else if (!jobRobots || jobRobots.length < 1) {
      t = currentLanguage !== 'de' ? language.eng.backupJobCheckNoRobots : language.de.backupJobCheckNoRobots;
    }

    app.toast.create({
      text: t,
      position: 'center',
      closeTimeout: 2000,
    }).open();

    return null;
  }

  newJob = { Name: jobName, Time: jobTime, Weekdays: jobWeekdays, Robots: jobRobots, Emails: jobEmails };

  return newJob;
}

function GetWeekdays() {
  t = document.getElementById('weekdaySelector').textContent;
  splitted = t.split(',');

  if (!splitted || splitted.length < 1) {
    return null;
  }

  wd = [];

  splitted.forEach(element => {
    if (dayOfWeek.de.Sunday === element.trim() || dayOfWeek.eng.Sunday === element.trim()) {
      wd.push(dayOfWeek.eng.Sunday);
    }
    if (dayOfWeek.de.Monday === element.trim() || dayOfWeek.eng.Monday === element.trim()) {
      wd.push(dayOfWeek.eng.Monday);
    }
    if (dayOfWeek.de.Tuesday === element.trim() || dayOfWeek.eng.Tuesday === element.trim()) {
      wd.push(dayOfWeek.eng.Tuesday);
    }
    if (dayOfWeek.de.Wednesday === element.trim() || dayOfWeek.eng.Wednesday === element.trim()) {
      wd.push(dayOfWeek.eng.Wednesday);
    }
    if (dayOfWeek.de.Thursday === element.trim() || dayOfWeek.eng.Thursday === element.trim()) {
      wd.push(dayOfWeek.eng.Thursday);
    }
    if (dayOfWeek.de.Friday === element.trim() || dayOfWeek.eng.Friday === element.trim()) {
      wd.push(dayOfWeek.eng.Friday);
    }
    if (dayOfWeek.de.Saturday === element.trim() || dayOfWeek.eng.Saturday === element.trim()) {
      wd.push(dayOfWeek.eng.Saturday);
    }
  });

  return wd;
}

function GetJobRobots() {

  jrr = document.getElementsByName('jobRobRadio');

  if (!jrr || jrr.length < 1) {
    return null;
  }

  jr = [];

  jrr.forEach(element => {
    if (element.checked) {
      found = robots.find(e => e.Name === element.id.replace('jobRobRadio_', ''))
      if (found && found !== undefined) {
        jr.push(found.Ip);
      }
    }
  });

  return jr;
}

function OpenBackupJobs() {

  if (!myStatus) {
    return;
  }

  if (!myStatus.CurrentBackupJob) {
    app.toast.create({
      text: currentLanguage !== 'de' ? language.eng.noBackupJobsRunning : language.de.noBackupJobsRunning,
      position: 'center',
      closeTimeout: 2000,
    }).open();
    return;
  }

  if (backupJobPopup) {
    backupJobPopup.close();
  }

  s1 = language.de.backupJobOverviewPopupTitle;
  s2 = language.de.backupJobOverviewPopupRunning;
  s3 = language.de.backupJobOverviewPopupWaiting;

  if (IsEnglishLanguage()) {
    s1 = language.eng.backupJobOverviewPopupTitle;
    s2 = language.eng.backupJobOverviewPopupRunning;
    s3 = language.eng.backupJobOverviewPopupWaiting;
  }

  backupJobPopup = app.popup.create({
    content: '<div class="popup my-popup">'
      + '<div class="view">'
      + '<div class="page color-deeporange">'
      + '<div class="navbar">'
      + '<div class="navbar-bg"></div>'
      + '<div class="navbar-inner">'
      + '<div class="title">' + s1 + '</div>'
      + '<div class="right">'
      + '<a class="link popup-close"><i class="icon f7-icons" onclick="OpenBackupJobs()">arrow_clockwise</i></a>'
      + '</div>'
      + '</div>'
      + '</div>'
      + '<div class="page-content">'

      + '<div class="block inset">'
      + '<div class="block-header">' + s2 + '</div>'
      + CreateCurrentBackupJobItem(myStatus.CurrentBackupJob)
      + '</div>'

      + '<div class="block inset">'
      + '<div class="block-header">' + s3 + '</div>'
      + CreateBackupJobItems(myStatus.CurrentBackupJobs)
      + '</div>'

      + '</div>'
      + '</div>'
      + '</div>'
      + '</div>'
  }).open();
}

function CreateCurrentBackupJobItem(job) {

  if (!job) {
    return '';
  }

  popupDiv = job.Name + 0;
  s = popupDiv;
  job.Robots.forEach(rob => {
    s += ';';
    s += rob.Ip;
    s += ';';
    s += rob.Name;
  });

  canceled = job.cts.Token.IsCancellationRequested;

  showCancelButton = 'inline-block';
  showCanceledBadge = 'none';

  if (canceled) {
    showCancelButton = 'none';
    showCanceledBadge = 'inline-flex';
  }

  result = '<div class="list">'
    + '<ul>';

  result += '<li>'
    + '<div href="#" class="item-content">'
    + '<div class="item-inner">'
    + '<div class="item-title">'
    + job.Name
    + '<span class="badge" style="margin-left: 10px; margin-bottom: 4px;">' + job.RobotCounter + '</span>'
    + '<a id="' + job.Name + '" class="badge ' + popupDiv + '" onclick="OpenJobRobots(\'' + s + '\')" style="margin-left: 10px; margin-bottom: 4px;">' + job.Robots.length + '</a>'
    + '<div class="item-footer">' + new Date(Date.parse(job.RequestedTime)).toLocaleString() + '</div>'
    + '</div>'
    + '<div class="item-after">'
    + '<a class="icon f7-icons" style="display: ' + showCancelButton + '" onclick="CancelJob(\'' + job.Id + '\')">clear_fill</a>'
    + '<span class="badge color-red" style="margin-left: 10px;display: ' + showCanceledBadge + '">abgebrochen</span>'
    + '</div>'
    + '</div>'
    + '</div>'
    + '</li>';

  result += '</ul>'
    + '</div>';

  return result;
}

function CreateBackupJobItems(jobs) {

  if (!jobs) {
    return '';
  }

  result = '<div class="list">'
    + '<ul>';

  i = 1;
  if (jobs.length) {
    jobs.forEach(element => {
      result += CreateBackupJobItem(element, i++);
    });
  } else {
    result += CreateBackupJobItem(jobs, i);
  }

  result += '</ul>'
    + '</div>';

  return result;
}

function CreateBackupJobItem(job, i) {

  if (!job || job.length < 1) {
    return '<li>'
      + '<div href="#" class="item-content">'
      // + '<div class="item-media"><i id="' + ledId + '" class="ledOrange"></i></div>'
      + '<div class="item-inner">'
      + '<div class="item-title"">'
      + ' - '
      + '<div class="item-footer"></div>'
      + '</div>'
      + '<div class="item-after">'
      + '</div>'
      + '</div>'
      + '</div>'
      + '</li>';
  }

  canceled = job.cts.Token.IsCancellationRequested;

  showCancelButton = 'inline-block';
  showCanceledBadge = 'none';

  if (canceled) {
    showCancelButton = 'none';
    showCanceledBadge = 'inline-flex';
  }

  popupDiv = job.Name + i;
  s = popupDiv;
  job.Robots.forEach(rob => {
    s += ';';
    s += rob.Ip;
    s += ';';
    s += rob.Name;
  });

  return '<li>'
    + '<div href="#" class="item-content">'
    + '<div class="item-inner">'
    + '<div class="item-title">'
    + job.Name
    + '<a id="' + job.Name + '" class="badge ' + popupDiv + '" onclick="OpenJobRobots(\'' + s + '\')" style="margin-left: 10px; margin-bottom: 4px;">' + job.Robots.length + '</a>'
    + '<div class="item-footer">' + new Date(Date.parse(job.RequestedTime)).toLocaleString() + '</div>'
    + '</div>'
    + '<div class="item-after">'
    + '<a class="icon f7-icons" style="display: ' + showCancelButton + '" onclick="CancelJob(\'' + job.Id + '\')">clear_fill</a>'
    + '<span class="badge color-red" style="margin-left: 10px;display: ' + showCanceledBadge + '">abgebrochen</span>'
    + '</div>'
    + '</div>'
    + '</div>'
    + '</li>';
}

function CancelJob(id) {
  log('CancelJob: ' + id)

  sendRequestToServer(COMMANDS.CANCEL_JOB, id, CancelJobCallback);
}

function CancelJobCallback(responseText) {
  log('CancelJobCallback: ' + responseText)

  if (responseText === 'false') {
    toastCenter = app.toast.create({
      text: currentLanguage !== 'de' ? language.eng.backupJobCancelError : language.de.backupJobCancelError,
      position: 'center',
      closeTimeout: 3000,
    }).open();
    return;
  }

  toastCenter = app.toast.create({
    text: currentLanguage !== 'de' ? language.eng.backupJobCancelOk : language.de.backupJobCancelOk,
    position: 'center',
    closeTimeout: 1000,
  }).open();

  UpdateCient();
  reopenBackupJobs = true;
}

function OpenJobRobots(jobNameAndRobotsAsString) {

  if (!jobNameAndRobotsAsString) {
    return;
  }

  res = jobNameAndRobotsAsString.split(";");
  robots = [];
  for (let index = 1; index < res.length; index++) {
    ip = res[index];
    name = res[index++];
    robots.push({ ip, name });
  }

  content = '<div class="popover" style="width: 350px">' +
    '<div class="popover-inner">' +
    '<div class="block">' +
    '<div class="list">' +
    '<ul>';

  robots.forEach(rob => {
    content += '<li>'
      + '     <div class="item-content">'
      + '       <div class="item-inner">'
      + '          <div class="item-title">' + rob.ip + '</div>'
      + '         <div class="item-after">' + rob.name + '</div>'
      + '        </div>'
      + '      </div>'
      + '    </li>'
  });

  content += '</ul>' +
    '</div>' +
    '</div>' +
    '</div>' +
    '</div>';

  dynamicPopover = app.popover.create({
    targetEl: 'a.badge.' + res[0],
    content: content,
  }).open();
}

$('.backup_open-vertical').on('click', function () {
  app.dialog.create({
    title: currentLanguage !== 'de' ? language.eng.backupBtn : language.de.backupBtn,
    buttons: [
      {
        color: 'deeporange',
        text: currentLanguage !== 'de' ? language.eng.backupAll : language.de.backupAll,
        onClick: function () {
          BackupAllRobots();
        }
      },
      {
        color: 'deeporange',
        text: currentLanguage !== 'de' ? language.eng.backupSelected : language.de.backupSelected,
        onClick: function () {
          BackupSelectedRobots();
        }
      },
      {
        color: 'deeporange',
        text: currentLanguage !== 'de' ? language.eng.close : language.de.close,
      },
    ],
    verticalButtons: true,
  }).open();
});

$('.select_open-vertical').on('click', function () {
  app.dialog.create({
    title: currentLanguage !== 'de' ? language.eng.selectionBtn : language.de.selectionBtn,
    buttons: [
      {
        color: 'deeporange',
        text: currentLanguage !== 'de' ? language.eng.selectAll : language.de.selectAll,
        onClick: function () {
          SelectAll(true);
        }
      },
      {
        color: 'deeporange',
        text: currentLanguage !== 'de' ? language.eng.selectReset : language.de.selectReset,
        onClick: function () {
          SelectAll(false);
        }
      },
      {
        color: 'deeporange',
        text: currentLanguage !== 'de' ? language.eng.selectInvert : language.de.selectInvert,
        onClick: function () {
          SelectInvert();
        }
      },
      {
        color: 'deeporange',
        text: currentLanguage !== 'de' ? language.eng.close : language.de.close,
      },
    ],
    verticalButtons: true,
  }).open();
});

$('.select_action_open-vertical').on('click', function () {
  selectedRobots = GetSelectedRobots();
  if (!selectedRobots || selectedRobots.length < 1) {
    app.dialog.alert(currentLanguage !== 'de' ? language.eng.noRobotsSelected : language.de.noRobotsSelected, '');
    return;
  }
  app.dialog.create({
    title: currentLanguage !== 'de' ? language.eng.selectionActionBtn : language.de.selectionActionBtn,
    buttons: [
      {
        color: 'deeporange',
        text: currentLanguage !== 'de' ? language.eng.createJobFromSelection : language.de.createJobFromSelection,
        onClick: function () {
          OpenCreateBackupJobPopup();
        }
      },
      {
        color: 'deeporange',
        text: currentLanguage !== 'de' ? language.eng.selectDelete : language.de.selectDelete,
        onClick: function () {
          DeleteSelectedRobots();
        }
      },
      {
        color: 'deeporange',
        text: currentLanguage !== 'de' ? language.eng.close : language.de.close,
      },
    ],
    verticalButtons: true,
  }).open();
});

function ToogleCheckbox(x, value) {

  if (x.type !== "checkbox") {
    return;
  }

  x.checked = value;
}

function SelectAll(value) {

  x = document.getElementsByName("toogleCheckbox");

  for (let i = 0; i < x.length; i++) {
    liElement = GetNParent(x[i], 4);

    if (liElement) {
      if (!liElement.classList.contains('hidden-by-searchbar')) {
        ToogleCheckbox(x[i], value);
      }
    } else {
      ToogleCheckbox(x[i], value);
    }
  }
}

function GetNParent(ele, level) {

  if (!ele || level < 0) {
    return null;
  }

  if (level == 0) {
    return ele.parentElement;
  }

  for (let index = 0; index <= level; index++) {
    e = ele.parentElement;
    ele = e;
  }

  return ele;
}

function SelectInvert() {

  x = document.getElementsByName("toogleCheckbox");

  for (let i = 0; i < x.length; i++) {
    if (x[i].type !== "checkbox") {
      continue;
    }
    ToogleCheckbox(x[i], !x[i].checked)
  }
}

function CreateRobotListPopover(targetElement, title, robList) {
  popover = app.popover.create({
    targetEl: targetElement, //'a.dynamic-popover',
    content: '<div class="popover">' +
      '<div class="popover-inner">' +
      '<div class="block">' +
      '<p>' + title + '</p>' +
      '</div>' +
      '<div class="block">' +
      CreateRobotListPopoverItems(robList) +
      '</div>' +
      '</div>' +
      '</div>',
    // Events
    on: {
      open: function (popover) {
        //console.log('Popover open');
      },
      opened: function (popover) {
        //console.log('Popover opened');
      },
    }
  });

  return popover;
}

function CreateRobotListPopoverItems(robList) {

  if (robList === null || robList === undefined) {
    return '';
  }

  result = '<div class="list">'
    + '<ul style="max-height:400px;overflow:auto;">';

  if (robList.length < 1) {
    result += CreateRobotListPopoverItem(null);
  } else {
    robList.forEach(element => {
      result += CreateRobotListPopoverItem(element);
    });
  }

  result += '</ul>'
    + '</div>';

  return result;
}

function CreateRobotListPopoverItem(item) {

  ip = '-';
  name = '-';

  if (item && item.Ip) {
    ip = item.Ip;
  }

  if (item && item.Name) {
    name = item.Name;
  }

  return '<li>'
    + '     <div class="item-content">'
    + '       <div class="item-inner">'
    + '          <div class="item-title">' + ip + '</div>'
    + '         <div class="item-after">' + name + '</div>'
    + '        </div>'
    + '      </div>'
    + '    </li>'
}

function DeleteSelectedRobots() {
  log('DeleteRobots');

  selectedRobots = GetSelectedRobots();

  if (!selectedRobots || selectedRobots.length < 1) {
    app.dialog.alert(currentLanguage !== 'de' ? language.eng.noRobotsSelected : language.de.noRobotsSelected, '');
    return;
  }

  s1 = language.de.deleteRobotsPopupTitle;
  s2 = language.de.yes;
  s3 = language.de.no;

  if (IsEnglishLanguage()) {
    s1 = language.eng.deleteRobotsPopupTitle;
    s2 = language.eng.yes;
    s3 = language.eng.no;
  }

  robotsToDelete = RobotsToRobotsIpList(selectedRobots);
  app.popup.create({
    content: '<div class="popup my-popup">'
      + '<div class="view">'
      + '<div class="page color-deeporange">'
      + '<div class="navbar">'
      + '<div class="navbar-bg"></div>'
      + '<div class="navbar-inner">'
      + '<div class="title">' + s1 + '</div>'
      + '</div>'
      + '</div>'
      + '<div class="page-content">'

      + '<div class="block inset">'
      + '<div class="block-header"></div>'
      + CreateRobotListPopoverItems(selectedRobots)
      + '</div>'

      + '<div class="block inset">'
      + '<div class="row">'
      + '<button class="col button button-large button-fill popup-close color-deeporange" onclick="DeleteRobots()">' + s2 + '</button>'
      + '<button  class="col button button-large button-fill popup-close color-blue">' + s3 + '</button>'
      + '</div>'
      + '</div>'

      + '</div>'
      + '</div>'
      + '</div>'
      + '</div>'
  }).open();
}

function DeleteAllRobots() {

  app.dialog.create({
    title: currentLanguage !== 'de' ? language.eng.deleteAllRobots : language.de.deleteAllRobots,
    buttons: [
      {
        color: 'deeporange',
        text: currentLanguage !== 'de' ? language.eng.yes : language.de.yes,
        onClick: function () {
          sendRequestToServer(COMMANDS.DELETE_ALL_ROBOTS, null, DeleteAllRobotsCallback);
        }
      },
      {
        color: 'deeporange',
        text: currentLanguage !== 'de' ? language.eng.no : language.de.no
      }
    ]
  }).open();
}

function DeleteAllRobotsCallback(responseText) {
  sendRequestToServer(COMMANDS.GET_ROBOTS, null, GetRobotsCallback);

}

function DeleteRobots() {

  if (!robotsToDelete) {
    return;
  }

  value = JSON.stringify(robotsToDelete);
  sendRequestToServer(COMMANDS.DELETE_ROBOTS, encodeURIComponent(value), DeleteRobotsCallback);
  robotsToDelete = undefined;
}

function DeleteRobotsCallback(responseText) {
  log('DeleteRobotCallback: ' + responseText);

  if (responseText === 'undefined') {
    return;
  }

  result = JSON.parse(responseText);

  if (result === null || result === undefined) {
    return;
  }

  sendRequestToServer(COMMANDS.GET_ROBOTS, null, GetRobotsCallback);

  resultOk = result.Results.filter(e => e.Result === 'OK');
  resultNotAvailable = result.Results.filter(e => e.Result === 'NOT_AVAILABLE');
  resultNoIp = result.Results.filter(e => e.Result === 'NO_IP');

  resultOkCount = 0;
  resultNotAvailableCount = 0;
  resultNoIpCount = 0;

  if (resultOk) {
    resultOkCount = resultOk.length;
  }

  if (resultNotAvailable) {
    resultNotAvailableCount = resultNotAvailable.length;
  }

  if (resultNoIp) {
    resultNoIpCount = resultNoIp.length;
  }

  resultNokCount = resultNotAvailableCount + resultNoIpCount;

  if (result.Results.length === resultOkCount) {
    app.dialog.alert(currentLanguage !== 'de' ? language.eng.deleteAllRobotsSuccessful : language.de.deleteAllRobotsSuccessful, '');
  } else {
    ok = resultOkCount + currentLanguage !== 'de' ? language.eng.deleteRobotsSuccessful : language.de.deleteRobotsSuccessful;
    nok = resultNokCount + currentLanguage !== 'de' ? language.eng.deleteRobotsFailed : language.de.deleteRobotsFailed;
    app.dialog.alert(ok + nok, '');
  }
}

function DeleteRobot(ip) {
  log('DeleteRobot: ' + ip);

  t = currentLanguage !== 'de' ? language.eng.deleteRobot : language.de.deleteRobot;
  t += ' (' + ip + ')';
  app.dialog.confirm(t, '', function () {
    sendRequestToServer(COMMANDS.DELETE_ROBOT, ip, DeleteRobotCallback);
  });
}

function DeleteRobotCallback(responseText) {
  log('DeleteRobotCallback: ' + responseText);

  if (responseText === 'undefined') {
    return;
  }

  result = JSON.parse(responseText);

  if (result === null || result === undefined) {
    return;
  }

  // NEW_ROBOT_IS_NULL,
  // NOT_AVAILABLE,
  // OK,
  // NO_IP

  if (result.Result === 'OK') {
    t = currentLanguage !== 'de' ? language.eng.deleteRobotSuccessful : language.de.deleteRobotSuccessful;
    t += ' (' + ip + ')';
    app.dialog.alert(t, '');
    sendRequestToServer(COMMANDS.GET_ROBOTS, null, GetRobotsCallback);
  } else if (result.Result === 'NOT_AVAILABLE') {
    t = currentLanguage !== 'de' ? language.eng.deleteRobotNotAvailable : language.de.deleteRobotNotAvailable;
    t += '(' + ip + ')';
    app.dialog.alert(t, '');
  } else if (result.Result === 'NO_IP') {
    app.dialog.alert(currentLanguage !== 'de' ? language.eng.deleteRobotNoIp : language.de.deleteRobotNoIp, '');
  } else {
    t = currentLanguage !== 'de' ? language.eng.deleteRobotError + ' ' + language.eng.checkMessages : language.de.deleteRobotError + ' ' + language.de.checkMessages;
    app.dialog.alert(t, '');
  }
}

function BackupAllRobots() {
  sendRequestToServer(COMMANDS.BACKUP_ALL_ROBOTS, null, BackupAllRobotsCallback);
}

function BackupAllRobotsCallback(responseText) {
  log('BackupAllRobotsCallback: ' + responseText);
}

function BackupSelectedRobots() {
  selectedRobots = GetSelectedRobots();

  if (!selectedRobots || selectedRobots.length < 1) {
    app.dialog.alert(currentLanguage !== 'de' ? language.eng.noRobotsSelected : language.de.noRobotsSelected, '');
    return;
  }

  // dynamicPopover = CreateRobotListPopover('button.dynamic-popover', 'Löschen', selectedRobots);
  // app.dialog.confirm('Sollen <a class="link dynamic-popover" href="#">' + selectedRobots.length + '</a> Roboter wirklich gelöscht werden?', '');

  robotsToBackup = RobotsToRobotsIpList(selectedRobots);

  s1 = language.de.backupRobot;
  s2 = language.de.yes;
  s3 = language.de.no;

  if (IsEnglishLanguage()) {
    s1 = language.eng.backupRobot;
    s2 = language.eng.yes;
    s3 = language.eng.no;
  }

  app.popup.create({
    content: '<div class="popup my-popup">'
      + '<div class="view">'
      + '<div class="page color-deeporange">'
      + '<div class="navbar">'
      + '<div class="navbar-bg"></div>'
      + '<div class="navbar-inner">'
      + '<div class="title">' + s1 + '</div>'
      + '</div>'
      + '</div>'
      + '<div class="page-content">'

      + '<div class="block inset">'
      + '<div class="block-header"></div>'
      + CreateRobotListPopoverItems(selectedRobots)
      + '</div>'

      + '<div class="block inset">'
      + '<div class="row">'
      + '<button class="col button button-large button-fill popup-close color-deeporange" onclick="BackupRobots()">' + s2 + '</button>'
      + '<button  class="col button button-large button-fill popup-close color-blue">' + s3 + '</button>'
      + '</div>'
      + '</div>'

      + '</div>'
      + '</div>'
      + '</div>'
      + '</div>'
  }).open();
}

function BackupRobots() {

  if (!robotsToBackup) {
    return;
  }

  jsonValue = JSON.stringify(robotsToBackup);
  log(jsonValue);
  sendRequestToServer(COMMANDS.BACKUP_ROBOTS, encodeURIComponent(jsonValue), BackupRobotsCallback);
  robotsToBackup = undefined;
}

function BackupRobotsCallback(responseText) {
  log('BackupRobotsCallback: ' + responseText);

  if (!responseText) {
    return;
  }


}

function BackupRobot(ip) {
  log('BackupRobot: ' + ip);

  sendRequestToServer(COMMANDS.BACKUP_ROBOT, ip, BackupRobotCallback);
}

function BackupRobotCallback(responseText) {
  log('BackupRobotCallback: ' + responseText);

  if (!responseText) {
    return;
  }


}

function GetSelectedRobots() {

  x = document.getElementsByName("toogleCheckbox");
  selRobots = [];

  for (let i = 0; i < x.length; i++) {
    if (x[i].type === "checkbox" && x[i].checked) {
      selRobots.push(robots.find(e => e.Ip === x[i].id));
    }
  }

  return selRobots;
}

function CreateMessages() {
  app.preloader.show('color-orange');
  sendRequestToServer(COMMANDS.GET_MESSAGES, currentLanguage, GetMessagesCallback);
}

function GetMessagesCallback(responseText) {
  log('GetMessagesCallback: ' + responseText);

  if (responseText === '' || responseText === 'null') {
    app.preloader.hide();
    return;
  }

  msg = JSON.parse(responseText);

  if (msg === undefined || msg.length < 1) {
    app.preloader.hide();
    return;
  }

  msgList = document.getElementById('messageList');
  RemoveAllChilds(msgList);

  // Dummy items array
  items = [];

  for (let i = msg.length; i > 0; i--) {
    m = msg[i - 1];
    ic = 'info_circle';
    icColor = '';

    //TODO -> erledigt -> WARN mit einbauen
    if (m.level === 1) {
      ic = 'xmark_circle';
      icColor = 'color-yellow';
    } else if (m.level === 2) {
      ic = 'xmark_circle';
      icColor = 'color-red';
    }

    date = new Date(Date.parse(m.dateTime)).toLocaleString();

    items.push({
      title: m.message,
      subtitle: date,
      icon: ic,
      iconColor: icColor
    });
  }

  app.preloader.hide();

  var virtualList = app.virtualList.create({
    // List Element
    el: '.virtual-list',
    // Pass array with items
    items: items,
    // Custom search function for searchbar
    // searchAll: function (query, items) {
    //   var found = [];
    //   for (var i = 0; i < items.length; i++) {
    //     if (items[i].title.toLowerCase().indexOf(query.toLowerCase()) >= 0 || query.trim() === '') found.push(i);
    //   }
    //   return found; //return array with mathced indexes
    // },
    // List item Template7 template
    itemTemplate:
      '<li>' +
      '<a href="#" class="item-content">' +
      '<div class="item-media"><i class="icon f7-icons {{iconColor}}">{{icon}}</i></div>' +
      '<div class="item-inner">' +
      '<div class="item-title" style="white-space: normal;">' +
      '{{ title }}' +
      '<div class="item-footer">{{subtitle}}</div>' +
      '</div>' +
      '</div>' +
      '</a>' +
      '</li>',
    // Item height
    height: app.theme === 'ios' ? 63 : (app.theme === 'md' ? 73 : 46),
  });
}


function CreateHistory() {
  // app.preloader.show('color-orange');
  sendRequestToServer(COMMANDS.GET_HISTORY, sessionId, GetHistoryCallback);
}

function GetHistoryCallback(responseText) {
  log('GetHistoryCallback: ' + responseText);

  if (responseText === undefined || responseText === '') {
    return;
  }

  // SetHistoryPageLanguage();

  hist = document.getElementById('historyTable');
  RemoveAllChilds(hist);

  if (responseText === 'null') {
    app.toast.create({
      text: currentLanguage !== 'de' ? language.eng.noHistoryElements : language.de.noHistoryElements,
      position: 'center',
      closeTimeout: 3000,
    }).open();

    return;
  }

  historyList = JSON.parse(responseText).reverse();

  if (historyList === undefined || historyList.length < 1) {
    return;
  }

  i = 0;
  historyList.forEach(element => {
    i++;
    str = CreateHistoryItem(element, i);
    hist.insertAdjacentHTML('beforeend', str);
    a = document.getElementById('historyItemPopover_' + i);
    a._variable = element;
  });
}

function CreateHistoryItem(item, i) {

  if (!item) {
    return '';
  }

  ic = 'checkmark_alt_circle';
  icColor = 'color-green';
  popoverOpen = '';
  htmlElement = 'a';
  date = new Date(Date.parse(item.StartedAt)).toLocaleString();
  elementId = 'historyItemPopover_' + i;

  if (item.BackupErrorCounter > 0) {
    ic = 'xmark_circle';
    icColor = 'color-red';
    popoverOpen = 'popover-open';
    htmlElement = 'a';
  } else if (item.DecomposerErrorCounter > 0) {
    ic = 'exclamationmark_circle';
    icColor = 'color-yellow';
    popoverOpen = 'popover-open';
    htmlElement = 'a';
  }

  return '<tr>' +
    '<td class="label-cell">' + date + '</td>' +
    '<td class="label-cell style="text-align: center;">' + item.Name + '</td>' +
    '<td class="numeric-cell" style="text-align: center;">' + item.RobotCounter + '</td>' +
    '<td class="numeric-cell"><' + htmlElement + ' id="' + elementId + '" class="icon f7-icons ' + icColor + '" onclick="OpenHistoryItemPopover(\'' + elementId + '\')">' + ic + '</' + htmlElement + '></td>' +
    '</tr>';
}

//CreateHistoryItemPopover(\'' + json + '\')
function OpenHistoryItemPopover(eleId) {

  target = document.getElementById(eleId);
  variable = target._variable;
  date = new Date(Date.parse(variable.StartedAt)).toLocaleString();
  t = currentLanguage !== 'de' ? language.eng.backupFrom + date : language.de.backupFrom + date;

  content = '<div class="popover" style="width: 450px">' +
    '<div class="popover-inner" style="max-height: 500px;">' +
    '<div class="block">' +
    '<h2>' + t + '</h2>';// +

  variable.Robots.forEach(element => {
    r = robots.find(e => e.Ip === element.Key);

    if (r) {
      name = r.Name;
      text = '';

      if (element.Value.Started) {
        if (!element.Value.BackupSuccessfull) {
          text = GetBackupErrorText(element.Value);
        } else if (!element.Value.DecomposerSuccessfull) {
          text = GetDecomposerErrorText(element.Value);
        } else {
          text = currentLanguage !== 'de' ? language.eng.successful : language.de.successful;
        }
      } else {
        text = ' - ';
      }

      content += '<p>' + name + ' -> ' + text + '</p>';
    }
  });

  content += '</div>' +
    '</div>' +
    '</div>';

  app.popover.create({
    targetEl: target,
    content: content
  }).open();
}

function GetBackupErrorText(value) {

  if (!value) {
    return '';
  }

  backupError = value.BackupError;
  if (backupError) {
    // TODO -> erledigt -> translate BackupError
    if (backupError === 'NoProjectBackupDirectory') {
      text = currentLanguage !== 'de' ? language.eng.NoProjectBackupDirectory : language.de.NoProjectBackupDirectory;
    } else if (backupError === 'KopBackupDirectoryPath') {
      text = currentLanguage !== 'de' ? language.eng.NoKopBackupDirectoryPath : language.de.NoKopBackupDirectoryPath;
    } else if (backupError === 'RobotNotReachable') {
      text = currentLanguage !== 'de' ? language.eng.RobotNotReachable : language.de.RobotNotReachable;
    } else {
      text = backupError;
    }
  } else {
    text = 'BackupManager - ExitCode: ' + value.BackupExitCode + ' -> ' + value.BackupExitCodeText;
  }

  return text;
}

function GetDecomposerErrorText(value) {

  if (!value) {
    return '';
  }

  // if (element.Value.DecomposerError) {
  //   text = element.Value.DecomposerError;
  // } else {
  //   text = 'Decomposer - ExitCode: ' + element.Value.BackupExitCode;
  // }

  error = value.DecomposerError;
  if (error) {
    // TODO -> erledigt -> translate BackupError
    if (error === 'NoProjectBackupDirectory') {
      text = currentLanguage !== 'de' ? language.eng.NoProjectBackupDirectory : language.de.NoProjectBackupDirectory;
    } else if (error === 'DecomposerNoProjectFileAvailable') {
      text = currentLanguage !== 'de' ? language.eng.DecomposerNoProjectFileAvailable : language.de.DecomposerNoProjectFileAvailable;
    } else {
      text = error;
    }
  } else {
    text = 'Decomposer - ExitCode: ' + value.DecomposerExitCode;
  }

  return text;
}

function CreateDiagnosticPackage() {
  sendRequestToServer(COMMANDS.CREATE_DIAG, null, CreateDiagnosisPackageCallback);
}

function CreateDiagnosisPackageCallback(responseText) {
  log("CreateDiagnosisPackage: " + responseText);

  if (!responseText) {
    return;
  }

  result = JSON.parse(responseText);

  if (result === false) {
    t = currentLanguage !== 'de' ? language.eng.createDiagError + ' ' + language.eng.checkMessages : language.de.createDiagError + ' ' + language.de.checkMessages;
    app.dialog.alert(t, '');
    return;
  }

  app.dialog.create({
    title: currentLanguage !== 'de' ? language.eng.createDiagOk : language.de.createDiagOk,
    // text: 'Dialog with vertical buttons',
    buttons: [
      {
        color: 'deeporange',
        text: currentLanguage !== 'de' ? language.eng.ok : language.de.ok,
        onClick: function () {
          Download(result[0], result[1]);
        }
      },
      {
        color: 'deeporange',
        text: currentLanguage !== 'de' ? language.eng.cancel : language.de.cancel
      }
    ]
  }).open();
}

// function DownloadDiag(result) {
//   //url = result[0].split('\\').join('/')
//   a = document.createElement('a');
//   a.href = result[0]; //'downloads/diags/diag.zip';
//   a.download = result[1];
//   a.click();
// }

function ShowTreeView() {
  //TODO Baumstruktur implementieren
  FunctionNotAvailable();
}

function EncryptPassword() {

  myContent = '<div class="popup">' +
    '<div class="view">' +
    '<div class="page color-deeporange">' +
    '<div class="navbar">' +
    '<div class="navbar-bg"></div>' +
    '<div class="navbar-inner">' +
    '<div class="title">Passwort verschlüsseln</div>' +
    '</div>' +
    '</div>' +
    '<div class="page-content block inset" style="margin-left: unset;margin-right: unset;padding-left: unset;padding-right: unset;">' +

    // '<div class="block-title">Passwort verschlüsseln</div>' +
    '<div class="list no-hairlines-md">' +
    '<ul>' +
    ' <li class="item-content item-input item-input-outline">' +
    // '   <div class="item-media">' +
    // '       <i class="icon demo-list-icon"></i>' +
    // '     </div>' +
    '     <div class="item-inner">' +
    '       <div class="item-title item-floating-label">Klartext-Passwort</div>' +
    '        <div class="item-input-wrap">' +
    '          <input type="text" placeholder="Dein Klartext-Passwort">' +
    '          <span class="input-clear-button"></span>' +
    '       </div>' +
    '     </div>' +
    '   </li>' +
    '   <li class="item-content item-input item-input-outline">' +
    // '     <div class="item-media">' +
    // '       <i class="icon demo-list-icon"></i>' +
    // '     </div>' +
    '     <div class="item-inner">' +
    '       <div class="item-title item-floating-label">Verschlüsseltes Passwort</div>' +
    '       <div class="item-input-wrap">' +
    '         <input type="text" readonly placeholder="Dein verschlüsseltes Passwort">' +
    // '         <span class="input-clear-button"></span>' +
    '       </div>' +
    '     </div>' +
    '   </li>' +

    '   <li class="item-content item-input item-input-outline">' +
    '     <div class="item-inner">' +
    '       <div class="item-input-wrap">' +
    '         <a class="button button-large button-fill color-deeporange">Verschlüsseln</a>' +
    '     </div>' +
    '   </li>' +

    '</div>' +


    '</div>' +
    '</div>' +
    '</div>' +
    '</div>';

  app.popup.create({
    content: myContent,
    on: {
      closed: function () {
        // sendRequestToServer(COMMANDS.RELEASE_SHEDULED_JOBS);
      }
    }
  }).open();

}

function Download(path, name) {

  if (!path) {
    t = currentLanguage !== 'de' ? language.eng.noDownloadPath : language.de.noDownloadPath;
    app.dialog.alert(t, '');
  }

  a = document.createElement('a');
  //a.setAttribute('download', name);
  a.href = /* '\\' +  */path;

  if (name) {
    a.download = name;
  }

  a.click();
}
