/**
 * Framework7 5.5.1
 * Full featured mobile HTML framework for building iOS & Android apps
 * https://framework7.io/
 *
 * Copyright 2014-2020 Vladimir Kharlampidi
 *
 * Released under the MIT License
 *
 * Released on: March 20, 2020
 */

!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?module.exports=t():"function"==typeof define&&define.amd?define(t):(e=e||self).Framework7=t()}(this,(function(){"use strict";var t7ctx;t7ctx="undefined"!=typeof window?window:"undefined"!=typeof global?global:void 0;var Template7Context=t7ctx,Template7Utils={quoteSingleRexExp:new RegExp("'","g"),quoteDoubleRexExp:new RegExp('"',"g"),isFunction:function(e){return"function"==typeof e},escape:function(e){return void 0===e&&(e=""),e.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&#039;")},helperToSlices:function(e){var t,a,r,n=Template7Utils.quoteDoubleRexExp,i=Template7Utils.quoteSingleRexExp,o=e.replace(/[{}#}]/g,"").trim().split(" "),s=[];for(a=0;a<o.length;a+=1){var l=o[a],p=void 0,c=void 0;if(0===a)s.push(l);else if(0===l.indexOf('"')||0===l.indexOf("'"))if(p=0===l.indexOf('"')?n:i,c=0===l.indexOf('"')?'"':"'",2===l.match(p).length)s.push(l);else{for(t=0,r=a+1;r<o.length;r+=1)if(l+=" "+o[r],o[r].indexOf(c)>=0){t=r,s.push(l);break}t&&(a=t)}else if(l.indexOf("=")>0){var d=l.split("="),u=d[0],h=d[1];if(p||(p=0===h.indexOf('"')?n:i,c=0===h.indexOf('"')?'"':"'"),2!==h.match(p).length){for(t=0,r=a+1;r<o.length;r+=1)if(h+=" "+o[r],o[r].indexOf(c)>=0){t=r;break}t&&(a=t)}var f=[u,h.replace(p,"")];s.push(f)}else s.push(l)}return s},stringToBlocks:function(e){var t,a,r=[];if(!e)return[];var n=e.split(/({{[^{^}]*}})/);for(t=0;t<n.length;t+=1){var i=n[t];if(""!==i)if(i.indexOf("{{")<0)r.push({type:"plain",content:i});else{if(i.indexOf("{/")>=0)continue;if((i=i.replace(/{{([#/])*([ ])*/,"{{$1").replace(/([ ])*}}/,"}}")).indexOf("{#")<0&&i.indexOf(" ")<0&&i.indexOf("else")<0){r.push({type:"variable",contextName:i.replace(/[{}]/g,"")});continue}var o=Template7Utils.helperToSlices(i),s=o[0],l=">"===s,p=[],c={};for(a=1;a<o.length;a+=1){var d=o[a];Array.isArray(d)?c[d[0]]="false"!==d[1]&&d[1]:p.push(d)}if(i.indexOf("{#")>=0){var u="",h="",f=0,m=void 0,v=!1,g=!1,b=0;for(a=t+1;a<n.length;a+=1)if(n[a].indexOf("{{#")>=0&&(b+=1),n[a].indexOf("{{/")>=0&&(b-=1),n[a].indexOf("{{#"+s)>=0)u+=n[a],g&&(h+=n[a]),f+=1;else if(n[a].indexOf("{{/"+s)>=0){if(!(f>0)){m=a,v=!0;break}f-=1,u+=n[a],g&&(h+=n[a])}else n[a].indexOf("else")>=0&&0===b?g=!0:(g||(u+=n[a]),g&&(h+=n[a]));v&&(m&&(t=m),"raw"===s?r.push({type:"plain",content:u}):r.push({type:"helper",helperName:s,contextName:p,content:u,inverseContent:h,hash:c}))}else i.indexOf(" ")>0&&(l&&(s="_partial",p[0]&&(0===p[0].indexOf("[")?p[0]=p[0].replace(/[[\]]/g,""):p[0]='"'+p[0].replace(/"|'/g,"")+'"')),r.push({type:"helper",helperName:s,contextName:p,hash:c}))}}return r},parseJsVariable:function(e,t,a){return e.split(/([+ \-*/^()&=|<>!%:?])/g).reduce((function(e,r){if(!r)return e;if(r.indexOf(t)<0)return e.push(r),e;if(!a)return e.push(JSON.stringify("")),e;var n=a;return r.indexOf(t+".")>=0&&r.split(t+".")[1].split(".").forEach((function(e){n=e in n?n[e]:void 0})),("string"==typeof n||Array.isArray(n)||n.constructor&&n.constructor===Object)&&(n=JSON.stringify(n)),void 0===n&&(n="undefined"),e.push(n),e}),[]).join("")},parseJsParents:function(e,t){return e.split(/([+ \-*^()&=|<>!%:?])/g).reduce((function(e,a){if(!a)return e;if(a.indexOf("../")<0)return e.push(a),e;if(!t||0===t.length)return e.push(JSON.stringify("")),e;var r=a.split("../").length-1,n=r>t.length?t[t.length-1]:t[r-1];return a.replace(/..\//g,"").split(".").forEach((function(e){n=void 0!==n[e]?n[e]:"undefined"})),!1===n||!0===n?(e.push(JSON.stringify(n)),e):null===n||"undefined"===n?(e.push(JSON.stringify("")),e):(e.push(JSON.stringify(n)),e)}),[]).join("")},getCompileVar:function(e,t,a){void 0===a&&(a="data_1");var r,n,i=t,o=0;0===e.indexOf("../")?(o=e.split("../").length-1,n=i.split("_")[1]-o,i="ctx_"+(n>=1?n:1),r=e.split("../")[o].split(".")):0===e.indexOf("@global")?(i="Template7.global",r=e.split("@global.")[1].split(".")):0===e.indexOf("@root")?(i="root",r=e.split("@root.")[1].split(".")):r=e.split(".");for(var s=0;s<r.length;s+=1){var l=r[s];if(0===l.indexOf("@")){var p=a.split("_")[1];o>0&&(p=n),s>0?i+="[(data_"+p+" && data_"+p+"."+l.replace("@","")+")]":i="(data_"+p+" && data_"+p+"."+l.replace("@","")+")"}else(Number.isFinite?Number.isFinite(l):Template7Context.isFinite(l))?i+="["+l+"]":"this"===l||l.indexOf("this.")>=0||l.indexOf("this[")>=0||l.indexOf("this(")>=0?i=l.replace("this",t):i+="."+l}return i},getCompiledArguments:function(e,t,a){for(var r=[],n=0;n<e.length;n+=1)/^['"]/.test(e[n])||/^(true|false|\d+)$/.test(e[n])?r.push(e[n]):r.push(Template7Utils.getCompileVar(e[n],t,a));return r.join(", ")}},Template7Helpers={_partial:function(e,t){var a=this,r=Template7Class.partials[e];return!r||r&&!r.template?"":(r.compiled||(r.compiled=new Template7Class(r.template).compile()),Object.keys(t.hash).forEach((function(e){a[e]=t.hash[e]})),r.compiled(a,t.data,t.root))},escape:function(e){if(null==e)return"";if("string"!=typeof e)throw new Error('Template7: Passed context to "escape" helper should be a string');return Template7Utils.escape(e)},if:function(e,t){var a=e;return Template7Utils.isFunction(a)&&(a=a.call(this)),a?t.fn(this,t.data):t.inverse(this,t.data)},unless:function(e,t){var a=e;return Template7Utils.isFunction(a)&&(a=a.call(this)),a?t.inverse(this,t.data):t.fn(this,t.data)},each:function(e,t){var a=e,r="",n=0;if(Template7Utils.isFunction(a)&&(a=a.call(this)),Array.isArray(a)){for(t.hash.reverse&&(a=a.reverse()),n=0;n<a.length;n+=1)r+=t.fn(a[n],{first:0===n,last:n===a.length-1,index:n});t.hash.reverse&&(a=a.reverse())}else for(var i in a)n+=1,r+=t.fn(a[i],{key:i});return n>0?r:t.inverse(this)},with:function(e,t){var a=e;return Template7Utils.isFunction(a)&&(a=e.call(this)),t.fn(a)},join:function(e,t){var a=e;return Template7Utils.isFunction(a)&&(a=a.call(this)),a.join(t.hash.delimiter||t.hash.delimeter)},js:function js(expression,options){var data=options.data,func,execute=expression;return"index first last key".split(" ").forEach((function(e){if(void 0!==data[e]){var t=new RegExp("this.@"+e,"g"),a=new RegExp("@"+e,"g");execute=execute.replace(t,JSON.stringify(data[e])).replace(a,JSON.stringify(data[e]))}})),options.root&&execute.indexOf("@root")>=0&&(execute=Template7Utils.parseJsVariable(execute,"@root",options.root)),execute.indexOf("@global")>=0&&(execute=Template7Utils.parseJsVariable(execute,"@global",Template7Context.Template7.global)),execute.indexOf("../")>=0&&(execute=Template7Utils.parseJsParents(execute,options.parents)),func=execute.indexOf("return")>=0?"(function(){"+execute+"})":"(function(){return ("+execute+")})",eval(func).call(this)},js_if:function js_if(expression,options){var data=options.data,func,execute=expression;"index first last key".split(" ").forEach((function(e){if(void 0!==data[e]){var t=new RegExp("this.@"+e,"g"),a=new RegExp("@"+e,"g");execute=execute.replace(t,JSON.stringify(data[e])).replace(a,JSON.stringify(data[e]))}})),options.root&&execute.indexOf("@root")>=0&&(execute=Template7Utils.parseJsVariable(execute,"@root",options.root)),execute.indexOf("@global")>=0&&(execute=Template7Utils.parseJsVariable(execute,"@global",Template7Context.Template7.global)),execute.indexOf("../")>=0&&(execute=Template7Utils.parseJsParents(execute,options.parents)),func=execute.indexOf("return")>=0?"(function(){"+execute+"})":"(function(){return ("+execute+")})";var condition=eval(func).call(this);return condition?options.fn(this,options.data):options.inverse(this,options.data)}};Template7Helpers.js_compare=Template7Helpers.js_if;var Template7Options={},Template7Partials={},Template7Class=function(e){this.template=e},staticAccessors={options:{configurable:!0},partials:{configurable:!0},helpers:{configurable:!0}};function Template7(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];var a=e[0],r=e[1];if(2===e.length){var n=new Template7Class(a),i=n.compile()(r);return n=null,i}return new Template7Class(a)}Template7Class.prototype.compile=function compile(template,depth){void 0===template&&(template=this.template),void 0===depth&&(depth=1);var t=this;if(t.compiled)return t.compiled;if("string"!=typeof template)throw new Error("Template7: Template must be a string");var stringToBlocks=Template7Utils.stringToBlocks,getCompileVar=Template7Utils.getCompileVar,getCompiledArguments=Template7Utils.getCompiledArguments,blocks=stringToBlocks(template),ctx="ctx_"+depth,data="data_"+depth;if(0===blocks.length)return function(){return""};function getCompileFn(e,a){return e.content?t.compile(e.content,a):function(){return""}}function getCompileInverse(e,a){return e.inverseContent?t.compile(e.inverseContent,a):function(){return""}}var resultString="",i;for(resultString+=1===depth?"(function ("+ctx+", "+data+", root) {\n":"(function ("+ctx+", "+data+") {\n",1===depth&&(resultString+="function isArray(arr){return Array.isArray(arr);}\n",resultString+="function isFunction(func){return (typeof func === 'function');}\n",resultString+='function c(val, ctx) {if (typeof val !== "undefined" && val !== null) {if (isFunction(val)) {return val.call(ctx);} else return val;} else return "";}\n',resultString+="root = root || ctx_1 || {};\n"),resultString+="var r = '';\n",i=0;i<blocks.length;i+=1){var block=blocks[i];if("plain"!==block.type){var variable=void 0,compiledArguments=void 0;if("variable"===block.type&&(variable=getCompileVar(block.contextName,ctx,data),resultString+="r += c("+variable+", "+ctx+");"),"helper"===block.type){var parents=void 0;if("ctx_1"!==ctx){for(var level=ctx.split("_")[1],parentsString="ctx_"+(level-1),j=level-2;j>=1;j-=1)parentsString+=", ctx_"+j;parents="["+parentsString+"]"}else parents="["+ctx+"]";var dynamicHelper=void 0;if(0===block.helperName.indexOf("[")&&(block.helperName=getCompileVar(block.helperName.replace(/[[\]]/g,""),ctx,data),dynamicHelper=!0),dynamicHelper||block.helperName in Template7Helpers)compiledArguments=getCompiledArguments(block.contextName,ctx,data),resultString+="r += (Template7Helpers"+(dynamicHelper?"["+block.helperName+"]":"."+block.helperName)+").call("+ctx+", "+(compiledArguments&&compiledArguments+", ")+"{hash:"+JSON.stringify(block.hash)+", data: "+data+" || {}, fn: "+getCompileFn(block,depth+1)+", inverse: "+getCompileInverse(block,depth+1)+", root: root, parents: "+parents+"});";else{if(block.contextName.length>0)throw new Error('Template7: Missing helper: "'+block.helperName+'"');variable=getCompileVar(block.helperName,ctx,data),resultString+="if ("+variable+") {",resultString+="if (isArray("+variable+")) {",resultString+="r += (Template7Helpers.each).call("+ctx+", "+variable+", {hash:"+JSON.stringify(block.hash)+", data: "+data+" || {}, fn: "+getCompileFn(block,depth+1)+", inverse: "+getCompileInverse(block,depth+1)+", root: root, parents: "+parents+"});",resultString+="}else {",resultString+="r += (Template7Helpers.with).call("+ctx+", "+variable+", {hash:"+JSON.stringify(block.hash)+", data: "+data+" || {}, fn: "+getCompileFn(block,depth+1)+", inverse: "+getCompileInverse(block,depth+1)+", root: root, parents: "+parents+"});",resultString+="}}"}}}else resultString+="r +='"+block.content.replace(/\r/g,"\\r").replace(/\n/g,"\\n").replace(/'/g,"\\'")+"';"}return resultString+="\nreturn r;})",1===depth?(t.compiled=eval(resultString),t.compiled):resultString},staticAccessors.options.get=function(){return Template7Options},staticAccessors.partials.get=function(){return Template7Partials},staticAccessors.helpers.get=function(){return Template7Helpers},Object.defineProperties(Template7Class,staticAccessors),Template7.registerHelper=function(e,t){Template7Class.helpers[e]=t},Template7.unregisterHelper=function(e){Template7Class.helpers[e]=void 0,delete Template7Class.helpers[e]},Template7.registerPartial=function(e,t){Template7Class.partials[e]={template:t}},Template7.unregisterPartial=function(e){Template7Class.partials[e]&&(Template7Class.partials[e]=void 0,delete Template7Class.partials[e])},Template7.compile=function(e,t){return new Template7Class(e,t).compile()},Template7.options=Template7Class.options,Template7.helpers=Template7Class.helpers,Template7.partials=Template7Class.partials;var doc="undefined"==typeof document?{body:{},addEventListener:function(){},removeEventListener:function(){},activeElement:{blur:function(){},nodeName:""},querySelector:function(){return null},querySelectorAll:function(){return[]},getElementById:function(){return null},createEvent:function(){return{initEvent:function(){}}},createElement:function(){return{children:[],childNodes:[],style:{},setAttribute:function(){},getElementsByTagName:function(){return[]}}},location:{hash:""}}:document,win="undefined"==typeof window?{document:doc,navigator:{userAgent:""},location:{},history:{},CustomEvent:function(){return this},addEventListener:function(){},removeEventListener:function(){},getComputedStyle:function(){return{getPropertyValue:function(){return""}}},Image:function(){},Date:function(){},screen:{},setTimeout:function(){},clearTimeout:function(){}}:window,Dom7=function(e){for(var t=0;t<e.length;t+=1)this[t]=e[t];return this.length=e.length,this};function $(e,t){var a=[],r=0;if(e&&!t&&e instanceof Dom7)return e;if(e)if("string"==typeof e){var n,i,o=e.trim();if(o.indexOf("<")>=0&&o.indexOf(">")>=0){var s="div";for(0===o.indexOf("<li")&&(s="ul"),0===o.indexOf("<tr")&&(s="tbody"),0!==o.indexOf("<td")&&0!==o.indexOf("<th")||(s="tr"),0===o.indexOf("<tbody")&&(s="table"),0===o.indexOf("<option")&&(s="select"),(i=doc.createElement(s)).innerHTML=o,r=0;r<i.childNodes.length;r+=1)a.push(i.childNodes[r])}else for(n=t||"#"!==e[0]||e.match(/[ .<>:~]/)?(t||doc).querySelectorAll(e.trim()):[doc.getElementById(e.trim().split("#")[1])],r=0;r<n.length;r+=1)n[r]&&a.push(n[r])}else if(e.nodeType||e===win||e===doc)a.push(e);else if(e.length>0&&e[0].nodeType)for(r=0;r<e.length;r+=1)a.push(e[r]);return new Dom7(a)}function unique(e){for(var t=[],a=0;a<e.length;a+=1)-1===t.indexOf(e[a])&&t.push(e[a]);return t}function toCamelCase(e){return e.toLowerCase().replace(/-(.)/g,(function(e,t){return t.toUpperCase()}))}function requestAnimationFrame(e){return win.requestAnimationFrame?win.requestAnimationFrame(e):win.webkitRequestAnimationFrame?win.webkitRequestAnimationFrame(e):win.setTimeout(e,1e3/60)}function cancelAnimationFrame(e){return win.cancelAnimationFrame?win.cancelAnimationFrame(e):win.webkitCancelAnimationFrame?win.webkitCancelAnimationFrame(e):win.clearTimeout(e)}function addClass(e){if(void 0===e)return this;for(var t=e.split(" "),a=0;a<t.length;a+=1)for(var r=0;r<this.length;r+=1)void 0!==this[r]&&void 0!==this[r].classList&&this[r].classList.add(t[a]);return this}function removeClass(e){for(var t=e.split(" "),a=0;a<t.length;a+=1)for(var r=0;r<this.length;r+=1)void 0!==this[r]&&void 0!==this[r].classList&&this[r].classList.remove(t[a]);return this}function hasClass(e){return!!this[0]&&this[0].classList.contains(e)}function toggleClass(e){for(var t=e.split(" "),a=0;a<t.length;a+=1)for(var r=0;r<this.length;r+=1)void 0!==this[r]&&void 0!==this[r].classList&&this[r].classList.toggle(t[a]);return this}function attr(e,t){var a=arguments;if(1===arguments.length&&"string"==typeof e)return this[0]?this[0].getAttribute(e):void 0;for(var r=0;r<this.length;r+=1)if(2===a.length)this[r].setAttribute(e,t);else for(var n in e)this[r][n]=e[n],this[r].setAttribute(n,e[n]);return this}function removeAttr(e){for(var t=0;t<this.length;t+=1)this[t].removeAttribute(e);return this}function prop(e,t){var a=arguments;if(1!==arguments.length||"string"!=typeof e){for(var r=0;r<this.length;r+=1)if(2===a.length)this[r][e]=t;else for(var n in e)this[r][n]=e[n];return this}if(this[0])return this[0][e]}function data(e,t){var a;if(void 0!==t){for(var r=0;r<this.length;r+=1)(a=this[r]).dom7ElementDataStorage||(a.dom7ElementDataStorage={}),a.dom7ElementDataStorage[e]=t;return this}if(a=this[0]){if(a.dom7ElementDataStorage&&e in a.dom7ElementDataStorage)return a.dom7ElementDataStorage[e];var n=a.getAttribute("data-"+e);return n||void 0}}function removeData(e){for(var t=0;t<this.length;t+=1){var a=this[t];a.dom7ElementDataStorage&&a.dom7ElementDataStorage[e]&&(a.dom7ElementDataStorage[e]=null,delete a.dom7ElementDataStorage[e])}}function dataset(){var e=this[0];if(e){var t={};if(e.dataset)for(var a in e.dataset)t[a]=e.dataset[a];else for(var r=0;r<e.attributes.length;r+=1){var n=e.attributes[r];n.name.indexOf("data-")>=0&&(t[toCamelCase(n.name.split("data-")[1])]=n.value)}for(var i in t)"false"===t[i]?t[i]=!1:"true"===t[i]?t[i]=!0:parseFloat(t[i])===1*t[i]&&(t[i]*=1);return t}}function val(e){if(void 0!==e){for(var t=0;t<this.length;t+=1){var a=this[t];if(Array.isArray(e)&&a.multiple&&"select"===a.nodeName.toLowerCase())for(var r=0;r<a.options.length;r+=1)a.options[r].selected=e.indexOf(a.options[r].value)>=0;else a.value=e}return this}if(this[0]){if(this[0].multiple&&"select"===this[0].nodeName.toLowerCase()){for(var n=[],i=0;i<this[0].selectedOptions.length;i+=1)n.push(this[0].selectedOptions[i].value);return n}return this[0].value}}function transform(e){for(var t=0;t<this.length;t+=1){var a=this[t].style;a.webkitTransform=e,a.transform=e}return this}function transition(e){"string"!=typeof e&&(e+="ms");for(var t=0;t<this.length;t+=1){var a=this[t].style;a.webkitTransitionDuration=e,a.transitionDuration=e}return this}function on(){for(var e,t=[],a=arguments.length;a--;)t[a]=arguments[a];var r=t[0],n=t[1],i=t[2],o=t[3];function s(e){var t=e.target;if(t){var a=e.target.dom7EventData||[];if(a.indexOf(e)<0&&a.unshift(e),$(t).is(n))i.apply(t,a);else for(var r=$(t).parents(),o=0;o<r.length;o+=1)$(r[o]).is(n)&&i.apply(r[o],a)}}function l(e){var t=e&&e.target&&e.target.dom7EventData||[];t.indexOf(e)<0&&t.unshift(e),i.apply(this,t)}"function"==typeof t[1]&&(r=(e=t)[0],i=e[1],o=e[2],n=void 0),o||(o=!1);for(var p,c=r.split(" "),d=0;d<this.length;d+=1){var u=this[d];if(n)for(p=0;p<c.length;p+=1){var h=c[p];u.dom7LiveListeners||(u.dom7LiveListeners={}),u.dom7LiveListeners[h]||(u.dom7LiveListeners[h]=[]),u.dom7LiveListeners[h].push({listener:i,proxyListener:s}),u.addEventListener(h,s,o)}else for(p=0;p<c.length;p+=1){var f=c[p];u.dom7Listeners||(u.dom7Listeners={}),u.dom7Listeners[f]||(u.dom7Listeners[f]=[]),u.dom7Listeners[f].push({listener:i,proxyListener:l}),u.addEventListener(f,l,o)}}return this}function off(){for(var e,t=[],a=arguments.length;a--;)t[a]=arguments[a];var r=t[0],n=t[1],i=t[2],o=t[3];"function"==typeof t[1]&&(r=(e=t)[0],i=e[1],o=e[2],n=void 0),o||(o=!1);for(var s=r.split(" "),l=0;l<s.length;l+=1)for(var p=s[l],c=0;c<this.length;c+=1){var d=this[c],u=void 0;if(!n&&d.dom7Listeners?u=d.dom7Listeners[p]:n&&d.dom7LiveListeners&&(u=d.dom7LiveListeners[p]),u&&u.length)for(var h=u.length-1;h>=0;h-=1){var f=u[h];i&&f.listener===i||i&&f.listener&&f.listener.dom7proxy&&f.listener.dom7proxy===i?(d.removeEventListener(p,f.proxyListener,o),u.splice(h,1)):i||(d.removeEventListener(p,f.proxyListener,o),u.splice(h,1))}}return this}function once(){for(var e,t=[],a=arguments.length;a--;)t[a]=arguments[a];var r=this,n=t[0],i=t[1],o=t[2],s=t[3];function l(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];o.apply(this,e),r.off(n,i,l,s),l.dom7proxy&&delete l.dom7proxy}return"function"==typeof t[1]&&(n=(e=t)[0],o=e[1],s=e[2],i=void 0),l.dom7proxy=o,r.on(n,i,l,s)}function trigger(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];for(var a=e[0].split(" "),r=e[1],n=0;n<a.length;n+=1)for(var i=a[n],o=0;o<this.length;o+=1){var s=this[o],l=void 0;try{l=new win.CustomEvent(i,{detail:r,bubbles:!0,cancelable:!0})}catch(e){(l=doc.createEvent("Event")).initEvent(i,!0,!0),l.detail=r}s.dom7EventData=e.filter((function(e,t){return t>0})),s.dispatchEvent(l),s.dom7EventData=[],delete s.dom7EventData}return this}function transitionEnd(e){var t,a=["webkitTransitionEnd","transitionend"],r=this;function n(i){if(i.target===this)for(e.call(this,i),t=0;t<a.length;t+=1)r.off(a[t],n)}if(e)for(t=0;t<a.length;t+=1)r.on(a[t],n);return this}function animationEnd(e){var t,a=["webkitAnimationEnd","animationend"],r=this;function n(i){if(i.target===this)for(e.call(this,i),t=0;t<a.length;t+=1)r.off(a[t],n)}if(e)for(t=0;t<a.length;t+=1)r.on(a[t],n);return this}function width(){return this[0]===win?win.innerWidth:this.length>0?parseFloat(this.css("width")):null}function outerWidth(e){if(this.length>0){if(e){var t=this.styles();return this[0].offsetWidth+parseFloat(t.getPropertyValue("margin-right"))+parseFloat(t.getPropertyValue("margin-left"))}return this[0].offsetWidth}return null}function height(){return this[0]===win?win.innerHeight:this.length>0?parseFloat(this.css("height")):null}function outerHeight(e){if(this.length>0){if(e){var t=this.styles();return this[0].offsetHeight+parseFloat(t.getPropertyValue("margin-top"))+parseFloat(t.getPropertyValue("margin-bottom"))}return this[0].offsetHeight}return null}function offset(){if(this.length>0){var e=this[0],t=e.getBoundingClientRect(),a=doc.body,r=e.clientTop||a.clientTop||0,n=e.clientLeft||a.clientLeft||0,i=e===win?win.scrollY:e.scrollTop,o=e===win?win.scrollX:e.scrollLeft;return{top:t.top+i-r,left:t.left+o-n}}return null}function hide(){for(var e=0;e<this.length;e+=1)this[e].style.display="none";return this}function show(){for(var e=0;e<this.length;e+=1){var t=this[e];"none"===t.style.display&&(t.style.display=""),"none"===win.getComputedStyle(t,null).getPropertyValue("display")&&(t.style.display="block")}return this}function styles(){return this[0]?win.getComputedStyle(this[0],null):{}}function css(e,t){var a;if(1===arguments.length){if("string"!=typeof e){for(a=0;a<this.length;a+=1)for(var r in e)this[a].style[r]=e[r];return this}if(this[0])return win.getComputedStyle(this[0],null).getPropertyValue(e)}if(2===arguments.length&&"string"==typeof e){for(a=0;a<this.length;a+=1)this[a].style[e]=t;return this}return this}function toArray(){for(var e=[],t=0;t<this.length;t+=1)e.push(this[t]);return e}function each(e){if(!e)return this;for(var t=0;t<this.length;t+=1)if(!1===e.call(this[t],t,this[t]))return this;return this}function forEach(e){if(!e)return this;for(var t=0;t<this.length;t+=1)if(!1===e.call(this[t],this[t],t))return this;return this}function filter(e){for(var t=[],a=0;a<this.length;a+=1)e.call(this[a],a,this[a])&&t.push(this[a]);return new Dom7(t)}function map(e){for(var t=[],a=0;a<this.length;a+=1)t.push(e.call(this[a],a,this[a]));return new Dom7(t)}function html(e){if(void 0===e)return this[0]?this[0].innerHTML:void 0;for(var t=0;t<this.length;t+=1)this[t].innerHTML=e;return this}function text(e){if(void 0===e)return this[0]?this[0].textContent.trim():null;for(var t=0;t<this.length;t+=1)this[t].textContent=e;return this}function is(e){var t,a,r=this[0];if(!r||void 0===e)return!1;if("string"==typeof e){if(r.matches)return r.matches(e);if(r.webkitMatchesSelector)return r.webkitMatchesSelector(e);if(r.msMatchesSelector)return r.msMatchesSelector(e);for(t=$(e),a=0;a<t.length;a+=1)if(t[a]===r)return!0;return!1}if(e===doc)return r===doc;if(e===win)return r===win;if(e.nodeType||e instanceof Dom7){for(t=e.nodeType?[e]:e,a=0;a<t.length;a+=1)if(t[a]===r)return!0;return!1}return!1}function indexOf(e){for(var t=0;t<this.length;t+=1)if(this[t]===e)return t;return-1}function index(){var e,t=this[0];if(t){for(e=0;null!==(t=t.previousSibling);)1===t.nodeType&&(e+=1);return e}}function eq(e){if(void 0===e)return this;var t,a=this.length;return new Dom7(e>a-1?[]:e<0?(t=a+e)<0?[]:[this[t]]:[this[e]])}function append(){for(var e,t=[],a=arguments.length;a--;)t[a]=arguments[a];for(var r=0;r<t.length;r+=1){e=t[r];for(var n=0;n<this.length;n+=1)if("string"==typeof e){var i=doc.createElement("div");for(i.innerHTML=e;i.firstChild;)this[n].appendChild(i.firstChild)}else if(e instanceof Dom7)for(var o=0;o<e.length;o+=1)this[n].appendChild(e[o]);else this[n].appendChild(e)}return this}function appendTo(e){return $(e).append(this),this}function prepend(e){var t,a;for(t=0;t<this.length;t+=1)if("string"==typeof e){var r=doc.createElement("div");for(r.innerHTML=e,a=r.childNodes.length-1;a>=0;a-=1)this[t].insertBefore(r.childNodes[a],this[t].childNodes[0])}else if(e instanceof Dom7)for(a=0;a<e.length;a+=1)this[t].insertBefore(e[a],this[t].childNodes[0]);else this[t].insertBefore(e,this[t].childNodes[0]);return this}function prependTo(e){return $(e).prepend(this),this}function insertBefore(e){for(var t=$(e),a=0;a<this.length;a+=1)if(1===t.length)t[0].parentNode.insertBefore(this[a],t[0]);else if(t.length>1)for(var r=0;r<t.length;r+=1)t[r].parentNode.insertBefore(this[a].cloneNode(!0),t[r])}function insertAfter(e){for(var t=$(e),a=0;a<this.length;a+=1)if(1===t.length)t[0].parentNode.insertBefore(this[a],t[0].nextSibling);else if(t.length>1)for(var r=0;r<t.length;r+=1)t[r].parentNode.insertBefore(this[a].cloneNode(!0),t[r].nextSibling)}function next(e){return this.length>0?e?this[0].nextElementSibling&&$(this[0].nextElementSibling).is(e)?new Dom7([this[0].nextElementSibling]):new Dom7([]):this[0].nextElementSibling?new Dom7([this[0].nextElementSibling]):new Dom7([]):new Dom7([])}function nextAll(e){var t=[],a=this[0];if(!a)return new Dom7([]);for(;a.nextElementSibling;){var r=a.nextElementSibling;e?$(r).is(e)&&t.push(r):t.push(r),a=r}return new Dom7(t)}function prev(e){if(this.length>0){var t=this[0];return e?t.previousElementSibling&&$(t.previousElementSibling).is(e)?new Dom7([t.previousElementSibling]):new Dom7([]):t.previousElementSibling?new Dom7([t.previousElementSibling]):new Dom7([])}return new Dom7([])}function prevAll(e){var t=[],a=this[0];if(!a)return new Dom7([]);for(;a.previousElementSibling;){var r=a.previousElementSibling;e?$(r).is(e)&&t.push(r):t.push(r),a=r}return new Dom7(t)}function siblings(e){return this.nextAll(e).add(this.prevAll(e))}function parent(e){for(var t=[],a=0;a<this.length;a+=1)null!==this[a].parentNode&&(e?$(this[a].parentNode).is(e)&&t.push(this[a].parentNode):t.push(this[a].parentNode));return $(unique(t))}function parents(e){for(var t=[],a=0;a<this.length;a+=1)for(var r=this[a].parentNode;r;)e?$(r).is(e)&&t.push(r):t.push(r),r=r.parentNode;return $(unique(t))}function closest(e){var t=this;return void 0===e?new Dom7([]):(t.is(e)||(t=t.parents(e).eq(0)),t)}function find(e){for(var t=[],a=0;a<this.length;a+=1)for(var r=this[a].querySelectorAll(e),n=0;n<r.length;n+=1)t.push(r[n]);return new Dom7(t)}function children(e){for(var t=[],a=0;a<this.length;a+=1)for(var r=this[a].childNodes,n=0;n<r.length;n+=1)e?1===r[n].nodeType&&$(r[n]).is(e)&&t.push(r[n]):1===r[n].nodeType&&t.push(r[n]);return new Dom7(unique(t))}function remove(){for(var e=0;e<this.length;e+=1)this[e].parentNode&&this[e].parentNode.removeChild(this[e]);return this}function detach(){return this.remove()}function add(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];var a,r,n=this;for(a=0;a<e.length;a+=1){var i=$(e[a]);for(r=0;r<i.length;r+=1)n[n.length]=i[r],n.length+=1}return n}function empty(){for(var e=0;e<this.length;e+=1){var t=this[e];if(1===t.nodeType){for(var a=0;a<t.childNodes.length;a+=1)t.childNodes[a].parentNode&&t.childNodes[a].parentNode.removeChild(t.childNodes[a]);t.textContent=""}}return this}$.fn=Dom7.prototype,$.Class=Dom7,$.Dom7=Dom7;var Methods=Object.freeze({addClass:addClass,removeClass:removeClass,hasClass:hasClass,toggleClass:toggleClass,attr:attr,removeAttr:removeAttr,prop:prop,data:data,removeData:removeData,dataset:dataset,val:val,transform:transform,transition:transition,on:on,off:off,once:once,trigger:trigger,transitionEnd:transitionEnd,animationEnd:animationEnd,width:width,outerWidth:outerWidth,height:height,outerHeight:outerHeight,offset:offset,hide:hide,show:show,styles:styles,css:css,toArray:toArray,each:each,forEach:forEach,filter:filter,map:map,html:html,text:text,is:is,indexOf:indexOf,index:index,eq:eq,append:append,appendTo:appendTo,prepend:prepend,prependTo:prependTo,insertBefore:insertBefore,insertAfter:insertAfter,next:next,nextAll:nextAll,prev:prev,prevAll:prevAll,siblings:siblings,parent:parent,parents:parents,closest:closest,find:find,children:children,remove:remove,detach:detach,add:add,empty:empty});function scrollTo(){for(var e,t=[],a=arguments.length;a--;)t[a]=arguments[a];var r=t[0],n=t[1],i=t[2],o=t[3],s=t[4];return 4===t.length&&"function"==typeof o&&(s=o,r=(e=t)[0],n=e[1],i=e[2],s=e[3],o=e[4]),void 0===o&&(o="swing"),this.each((function(){var e,t,a,l,p,c,d,u,h=this,f=n>0||0===n,m=r>0||0===r;if(void 0===o&&(o="swing"),f&&(e=h.scrollTop,i||(h.scrollTop=n)),m&&(t=h.scrollLeft,i||(h.scrollLeft=r)),i){f&&(a=h.scrollHeight-h.offsetHeight,p=Math.max(Math.min(n,a),0)),m&&(l=h.scrollWidth-h.offsetWidth,c=Math.max(Math.min(r,l),0));var v=null;f&&p===e&&(f=!1),m&&c===t&&(m=!1),requestAnimationFrame((function a(r){void 0===r&&(r=(new Date).getTime()),null===v&&(v=r);var n,l=Math.max(Math.min((r-v)/i,1),0),g="linear"===o?l:.5-Math.cos(l*Math.PI)/2;f&&(d=e+g*(p-e)),m&&(u=t+g*(c-t)),f&&p>e&&d>=p&&(h.scrollTop=p,n=!0),f&&p<e&&d<=p&&(h.scrollTop=p,n=!0),m&&c>t&&u>=c&&(h.scrollLeft=c,n=!0),m&&c<t&&u<=c&&(h.scrollLeft=c,n=!0),n?s&&s():(f&&(h.scrollTop=d),m&&(h.scrollLeft=u),requestAnimationFrame(a))}))}}))}function scrollTop(){for(var e,t=[],a=arguments.length;a--;)t[a]=arguments[a];var r=t[0],n=t[1],i=t[2],o=t[3];3===t.length&&"function"==typeof i&&(r=(e=t)[0],n=e[1],o=e[2],i=e[3]);var s=this;return void 0===r?s.length>0?s[0].scrollTop:null:s.scrollTo(void 0,r,n,i,o)}function scrollLeft(){for(var e,t=[],a=arguments.length;a--;)t[a]=arguments[a];var r=t[0],n=t[1],i=t[2],o=t[3];3===t.length&&"function"==typeof i&&(r=(e=t)[0],n=e[1],o=e[2],i=e[3]);var s=this;return void 0===r?s.length>0?s[0].scrollLeft:null:s.scrollTo(r,void 0,n,i,o)}var Scroll=Object.freeze({scrollTo:scrollTo,scrollTop:scrollTop,scrollLeft:scrollLeft});function animate(e,t){var a,r=this,n={props:Object.assign({},e),params:Object.assign({duration:300,easing:"swing"},t),elements:r,animating:!1,que:[],easingProgress:function(e,t){return"swing"===e?.5-Math.cos(t*Math.PI)/2:"function"==typeof e?e(t):t},stop:function(){n.frameId&&cancelAnimationFrame(n.frameId),n.animating=!1,n.elements.each((function(e,t){delete t.dom7AnimateInstance})),n.que=[]},done:function(e){if(n.animating=!1,n.elements.each((function(e,t){delete t.dom7AnimateInstance})),e&&e(r),n.que.length>0){var t=n.que.shift();n.animate(t[0],t[1])}},animate:function(e,t){if(n.animating)return n.que.push([e,t]),n;var a=[];n.elements.each((function(t,r){var i,o,s,l,p;r.dom7AnimateInstance||(n.elements[t].dom7AnimateInstance=n),a[t]={container:r},Object.keys(e).forEach((function(n){i=win.getComputedStyle(r,null).getPropertyValue(n).replace(",","."),o=parseFloat(i),s=i.replace(o,""),l=parseFloat(e[n]),p=e[n]+s,a[t][n]={initialFullValue:i,initialValue:o,unit:s,finalValue:l,finalFullValue:p,currentValue:o}}))}));var i,o,s=null,l=0,p=0,c=!1;return n.animating=!0,n.frameId=requestAnimationFrame((function d(){var u,h;i=(new Date).getTime(),c||(c=!0,t.begin&&t.begin(r)),null===s&&(s=i),t.progress&&t.progress(r,Math.max(Math.min((i-s)/t.duration,1),0),s+t.duration-i<0?0:s+t.duration-i,s),a.forEach((function(r){var c=r;o||c.done||Object.keys(e).forEach((function(r){if(!o&&!c.done){u=Math.max(Math.min((i-s)/t.duration,1),0),h=n.easingProgress(t.easing,u);var d=c[r],f=d.initialValue,m=d.finalValue,v=d.unit;c[r].currentValue=f+h*(m-f);var g=c[r].currentValue;(m>f&&g>=m||m<f&&g<=m)&&(c.container.style[r]=m+v,(p+=1)===Object.keys(e).length&&(c.done=!0,l+=1),l===a.length&&(o=!0)),o?n.done(t.complete):c.container.style[r]=g+v}}))})),o||(n.frameId=requestAnimationFrame(d))})),n}};if(0===n.elements.length)return r;for(var i=0;i<n.elements.length;i+=1)n.elements[i].dom7AnimateInstance?a=n.elements[i].dom7AnimateInstance:n.elements[i].dom7AnimateInstance=n;return a||(a=n),"stop"===e?a.stop():a.animate(n.props,n.params),r}function stop(){for(var e=0;e<this.length;e+=1)this[e].dom7AnimateInstance&&this[e].dom7AnimateInstance.stop()}var Animate=Object.freeze({animate:animate,stop:stop}),noTrigger="resize scroll".split(" ");function eventShortcut(e){for(var t,a=[],r=arguments.length-1;r-- >0;)a[r]=arguments[r+1];if(void 0===a[0]){for(var n=0;n<this.length;n+=1)noTrigger.indexOf(e)<0&&(e in this[n]?this[n][e]():$(this[n]).trigger(e));return this}return(t=this).on.apply(t,[e].concat(a))}function click(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["click"].concat(e))}function blur(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["blur"].concat(e))}function focus(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["focus"].concat(e))}function focusin(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["focusin"].concat(e))}function focusout(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["focusout"].concat(e))}function keyup(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["keyup"].concat(e))}function keydown(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["keydown"].concat(e))}function keypress(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["keypress"].concat(e))}function submit(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["submit"].concat(e))}function change(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["change"].concat(e))}function mousedown(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["mousedown"].concat(e))}function mousemove(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["mousemove"].concat(e))}function mouseup(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["mouseup"].concat(e))}function mouseenter(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["mouseenter"].concat(e))}function mouseleave(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["mouseleave"].concat(e))}function mouseout(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["mouseout"].concat(e))}function mouseover(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["mouseover"].concat(e))}function touchstart(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["touchstart"].concat(e))}function touchend(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["touchend"].concat(e))}function touchmove(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["touchmove"].concat(e))}function resize(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["resize"].concat(e))}function scroll(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return eventShortcut.bind(this).apply(void 0,["scroll"].concat(e))}var eventShortcuts=Object.freeze({click:click,blur:blur,focus:focus,focusin:focusin,focusout:focusout,keyup:keyup,keydown:keydown,keypress:keypress,submit:submit,change:change,mousedown:mousedown,mousemove:mousemove,mouseup:mouseup,mouseenter:mouseenter,mouseleave:mouseleave,mouseout:mouseout,mouseover:mouseover,touchstart:touchstart,touchend:touchend,touchmove:touchmove,resize:resize,scroll:scroll});[Methods,Scroll,Animate,eventShortcuts].forEach((function(e){Object.keys(e).forEach((function(t){$.fn[t]=e[t]}))}));for(var defaultDiacriticsRemovalap=[{base:"A",letters:"AⒶＡÀÁÂẦẤẪẨÃĀĂẰẮẴẲȦǠÄǞẢÅǺǍȀȂẠẬẶḀĄȺⱯ"},{base:"AA",letters:"Ꜳ"},{base:"AE",letters:"ÆǼǢ"},{base:"AO",letters:"Ꜵ"},{base:"AU",letters:"Ꜷ"},{base:"AV",letters:"ꜸꜺ"},{base:"AY",letters:"Ꜽ"},{base:"B",letters:"BⒷＢḂḄḆɃƂƁ"},{base:"C",letters:"CⒸＣĆĈĊČÇḈƇȻꜾ"},{base:"D",letters:"DⒹＤḊĎḌḐḒḎĐƋƊƉꝹ"},{base:"DZ",letters:"ǱǄ"},{base:"Dz",letters:"ǲǅ"},{base:"E",letters:"EⒺＥÈÉÊỀẾỄỂẼĒḔḖĔĖËẺĚȄȆẸỆȨḜĘḘḚƐƎ"},{base:"F",letters:"FⒻＦḞƑꝻ"},{base:"G",letters:"GⒼＧǴĜḠĞĠǦĢǤƓꞠꝽꝾ"},{base:"H",letters:"HⒽＨĤḢḦȞḤḨḪĦⱧⱵꞍ"},{base:"I",letters:"IⒾＩÌÍÎĨĪĬİÏḮỈǏȈȊỊĮḬƗ"},{base:"J",letters:"JⒿＪĴɈ"},{base:"K",letters:"KⓀＫḰǨḲĶḴƘⱩꝀꝂꝄꞢ"},{base:"L",letters:"LⓁＬĿĹĽḶḸĻḼḺŁȽⱢⱠꝈꝆꞀ"},{base:"LJ",letters:"Ǉ"},{base:"Lj",letters:"ǈ"},{base:"M",letters:"MⓂＭḾṀṂⱮƜ"},{base:"N",letters:"NⓃＮǸŃÑṄŇṆŅṊṈȠƝꞐꞤ"},{base:"NJ",letters:"Ǌ"},{base:"Nj",letters:"ǋ"},{base:"O",letters:"OⓄＯÒÓÔỒỐỖỔÕṌȬṎŌṐṒŎȮȰÖȪỎŐǑȌȎƠỜỚỠỞỢỌỘǪǬØǾƆƟꝊꝌ"},{base:"OI",letters:"Ƣ"},{base:"OO",letters:"Ꝏ"},{base:"OU",letters:"Ȣ"},{base:"OE",letters:"Œ"},{base:"oe",letters:"œ"},{base:"P",letters:"PⓅＰṔṖƤⱣꝐꝒꝔ"},{base:"Q",letters:"QⓆＱꝖꝘɊ"},{base:"R",letters:"RⓇＲŔṘŘȐȒṚṜŖṞɌⱤꝚꞦꞂ"},{base:"S",letters:"SⓈＳẞŚṤŜṠŠṦṢṨȘŞⱾꞨꞄ"},{base:"T",letters:"TⓉＴṪŤṬȚŢṰṮŦƬƮȾꞆ"},{base:"TZ",letters:"Ꜩ"},{base:"U",letters:"UⓊＵÙÚÛŨṸŪṺŬÜǛǗǕǙỦŮŰǓȔȖƯỪỨỮỬỰỤṲŲṶṴɄ"},{base:"V",letters:"VⓋＶṼṾƲꝞɅ"},{base:"VY",letters:"Ꝡ"},{base:"W",letters:"WⓌＷẀẂŴẆẄẈⱲ"},{base:"X",letters:"XⓍＸẊẌ"},{base:"Y",letters:"YⓎＹỲÝŶỸȲẎŸỶỴƳɎỾ"},{base:"Z",letters:"ZⓏＺŹẐŻŽẒẔƵȤⱿⱫꝢ"},{base:"a",letters:"aⓐａẚàáâầấẫẩãāăằắẵẳȧǡäǟảåǻǎȁȃạậặḁąⱥɐ"},{base:"aa",letters:"ꜳ"},{base:"ae",letters:"æǽǣ"},{base:"ao",letters:"ꜵ"},{base:"au",letters:"ꜷ"},{base:"av",letters:"ꜹꜻ"},{base:"ay",letters:"ꜽ"},{base:"b",letters:"bⓑｂḃḅḇƀƃɓ"},{base:"c",letters:"cⓒｃćĉċčçḉƈȼꜿↄ"},{base:"d",letters:"dⓓｄḋďḍḑḓḏđƌɖɗꝺ"},{base:"dz",letters:"ǳǆ"},{base:"e",letters:"eⓔｅèéêềếễểẽēḕḗĕėëẻěȅȇẹệȩḝęḙḛɇɛǝ"},{base:"f",letters:"fⓕｆḟƒꝼ"},{base:"g",letters:"gⓖｇǵĝḡğġǧģǥɠꞡᵹꝿ"},{base:"h",letters:"hⓗｈĥḣḧȟḥḩḫẖħⱨⱶɥ"},{base:"hv",letters:"ƕ"},{base:"i",letters:"iⓘｉìíîĩīĭïḯỉǐȉȋịįḭɨı"},{base:"j",letters:"jⓙｊĵǰɉ"},{base:"k",letters:"kⓚｋḱǩḳķḵƙⱪꝁꝃꝅꞣ"},{base:"l",letters:"lⓛｌŀĺľḷḹļḽḻſłƚɫⱡꝉꞁꝇ"},{base:"lj",letters:"ǉ"},{base:"m",letters:"mⓜｍḿṁṃɱɯ"},{base:"n",letters:"nⓝｎǹńñṅňṇņṋṉƞɲŉꞑꞥ"},{base:"nj",letters:"ǌ"},{base:"o",letters:"oⓞｏòóôồốỗổõṍȭṏōṑṓŏȯȱöȫỏőǒȍȏơờớỡởợọộǫǭøǿɔꝋꝍɵ"},{base:"oi",letters:"ƣ"},{base:"ou",letters:"ȣ"},{base:"oo",letters:"ꝏ"},{base:"p",letters:"pⓟｐṕṗƥᵽꝑꝓꝕ"},{base:"q",letters:"qⓠｑɋꝗꝙ"},{base:"r",letters:"rⓡｒŕṙřȑȓṛṝŗṟɍɽꝛꞧꞃ"},{base:"s",letters:"sⓢｓßśṥŝṡšṧṣṩșşȿꞩꞅẛ"},{base:"t",letters:"tⓣｔṫẗťṭțţṱṯŧƭʈⱦꞇ"},{base:"tz",letters:"ꜩ"},{base:"u",letters:"uⓤｕùúûũṹūṻŭüǜǘǖǚủůűǔȕȗưừứữửựụṳųṷṵʉ"},{base:"v",letters:"vⓥｖṽṿʋꝟʌ"},{base:"vy",letters:"ꝡ"},{base:"w",letters:"wⓦｗẁẃŵẇẅẘẉⱳ"},{base:"x",letters:"xⓧｘẋẍ"},{base:"y",letters:"yⓨｙỳýŷỹȳẏÿỷẙỵƴɏỿ"},{base:"z",letters:"zⓩｚźẑżžẓẕƶȥɀⱬꝣ"}],diacriticsMap={},i=0;i<defaultDiacriticsRemovalap.length;i+=1)for(var letters=defaultDiacriticsRemovalap[i].letters,j=0;j<letters.length;j+=1)diacriticsMap[letters[j]]=defaultDiacriticsRemovalap[i].base;var uniqueNumber=1,Utils={uniqueNumber:function(){return uniqueNumber+=1},id:function(e,t){void 0===e&&(e="xxxxxxxxxx"),void 0===t&&(t="0123456789abcdef");var a=t.length;return e.replace(/x/g,(function(){return t[Math.floor(Math.random()*a)]}))},mdPreloaderContent:'\n    <span class="preloader-inner">\n      <span class="preloader-inner-gap"></span>\n      <span class="preloader-inner-left">\n          <span class="preloader-inner-half-circle"></span>\n      </span>\n      <span class="preloader-inner-right">\n          <span class="preloader-inner-half-circle"></span>\n      </span>\n    </span>\n  '.trim(),iosPreloaderContent:('\n    <span class="preloader-inner">\n      '+[0,1,2,3,4,5,6,7,8,9,10,11].map((function(){return'<span class="preloader-inner-line"></span>'})).join("")+"\n    </span>\n  ").trim(),auroraPreloaderContent:'\n    <span class="preloader-inner">\n      <span class="preloader-inner-circle"></span>\n    </span>\n  ',eventNameToColonCase:function(e){var t;return e.split("").map((function(e,a){return e.match(/[A-Z]/)&&0!==a&&!t?(t=!0,":"+e.toLowerCase()):e.toLowerCase()})).join("")},deleteProps:function(e){var t=e;Object.keys(t).forEach((function(e){try{t[e]=null}catch(e){}try{delete t[e]}catch(e){}}))},nextTick:function(e,t){return void 0===t&&(t=0),setTimeout(e,t)},nextFrame:function(e){return Utils.requestAnimationFrame((function(){Utils.requestAnimationFrame(e)}))},now:function(){return Date.now()},requestAnimationFrame:function(e){return win.requestAnimationFrame(e)},cancelAnimationFrame:function(e){return win.cancelAnimationFrame(e)},removeDiacritics:function(e){return e.replace(/[^\u0000-\u007E]/g,(function(e){return diacriticsMap[e]||e}))},parseUrlQuery:function(e){var t,a,r,n,i={},o=e||win.location.href;if("string"==typeof o&&o.length)for(n=(a=(o=o.indexOf("?")>-1?o.replace(/\S*\?/,""):"").split("&").filter((function(e){return""!==e}))).length,t=0;t<n;t+=1)r=a[t].replace(/#\S+/g,"").split("="),i[decodeURIComponent(r[0])]=void 0===r[1]?void 0:decodeURIComponent(r.slice(1).join("="))||"";return i},getTranslate:function(e,t){var a,r,n;void 0===t&&(t="x");var i=win.getComputedStyle(e,null);return win.WebKitCSSMatrix?((r=i.transform||i.webkitTransform).split(",").length>6&&(r=r.split(", ").map((function(e){return e.replace(",",".")})).join(", ")),n=new win.WebKitCSSMatrix("none"===r?"":r)):a=(n=i.MozTransform||i.OTransform||i.MsTransform||i.msTransform||i.transform||i.getPropertyValue("transform").replace("translate(","matrix(1, 0, 0, 1,")).toString().split(","),"x"===t&&(r=win.WebKitCSSMatrix?n.m41:16===a.length?parseFloat(a[12]):parseFloat(a[4])),"y"===t&&(r=win.WebKitCSSMatrix?n.m42:16===a.length?parseFloat(a[13]):parseFloat(a[5])),r||0},serializeObject:function(e,t){if(void 0===t&&(t=[]),"string"==typeof e)return e;var a,r=[];function n(e){if(t.length>0){for(var a="",r=0;r<t.length;r+=1)a+=0===r?t[r]:"["+encodeURIComponent(t[r])+"]";return a+"["+encodeURIComponent(e)+"]"}return encodeURIComponent(e)}function i(e){return encodeURIComponent(e)}return Object.keys(e).forEach((function(o){var s;if(Array.isArray(e[o])){s=[];for(var l=0;l<e[o].length;l+=1)Array.isArray(e[o][l])||"object"!=typeof e[o][l]?s.push(n(o)+"[]="+i(e[o][l])):((a=t.slice()).push(o),a.push(String(l)),s.push(Utils.serializeObject(e[o][l],a)));s.length>0&&r.push(s.join("&"))}else null===e[o]||""===e[o]?r.push(n(o)+"="):"object"==typeof e[o]?((a=t.slice()).push(o),""!==(s=Utils.serializeObject(e[o],a))&&r.push(s)):void 0!==e[o]&&""!==e[o]?r.push(n(o)+"="+i(e[o])):""===e[o]&&r.push(n(o))})),r.join("&")},isObject:function(e){return"object"==typeof e&&null!==e&&e.constructor&&e.constructor===Object},merge:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];var a=e[0];e.splice(0,1);for(var r=e,n=0;n<r.length;n+=1){var i=e[n];if(null!=i)for(var o=Object.keys(Object(i)),s=0,l=o.length;s<l;s+=1){var p=o[s],c=Object.getOwnPropertyDescriptor(i,p);void 0!==c&&c.enumerable&&(a[p]=i[p])}}return a},extend:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];var a,r,n=!0;"boolean"==typeof e[0]?(n=e[0],a=e[1],e.splice(0,2),r=e):(a=e[0],e.splice(0,1),r=e);for(var i=0;i<r.length;i+=1){var o=e[i];if(null!=o)for(var s=Object.keys(Object(o)),l=0,p=s.length;l<p;l+=1){var c=s[l],d=Object.getOwnPropertyDescriptor(o,c);void 0!==d&&d.enumerable&&(n?Utils.isObject(a[c])&&Utils.isObject(o[c])?Utils.extend(a[c],o[c]):!Utils.isObject(a[c])&&Utils.isObject(o[c])?(a[c]={},Utils.extend(a[c],o[c])):a[c]=o[c]:a[c]=o[c])}}return a},colorHexToRgb:function(e){var t=e.replace(/^#?([a-f\d])([a-f\d])([a-f\d])$/i,(function(e,t,a,r){return t+t+a+a+r+r})),a=/^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(t);return a?a.slice(1).map((function(e){return parseInt(e,16)})):null},colorRgbToHex:function(e,t,a){return"#"+[e,t,a].map((function(e){var t=e.toString(16);return 1===t.length?"0"+t:t})).join("")},colorRgbToHsl:function(e,t,a){e/=255,t/=255,a/=255;var r,n=Math.max(e,t,a),i=Math.min(e,t,a),o=n-i;0===o?r=0:n===e?r=(t-a)/o%6:n===t?r=(a-e)/o+2:n===a&&(r=(e-t)/o+4);var s=(i+n)/2;return r<0&&(r=6+r),[60*r,0===o?0:o/(1-Math.abs(2*s-1)),s]},colorHslToRgb:function(e,t,a){var r,n=(1-Math.abs(2*a-1))*t,i=e/60,o=n*(1-Math.abs(i%2-1));Number.isNaN(e)||void 0===e?r=[0,0,0]:i<=1?r=[n,o,0]:i<=2?r=[o,n,0]:i<=3?r=[0,n,o]:i<=4?r=[0,o,n]:i<=5?r=[o,0,n]:i<=6&&(r=[n,0,o]);var s=a-n/2;return r.map((function(e){return Math.max(0,Math.min(255,Math.round(255*(e+s))))}))},colorHsbToHsl:function(e,t,a){var r={h:e,s:0,l:0},n=t,i=a;return r.l=(2-n)*i/2,r.s=r.l&&r.l<1?n*i/(r.l<.5?2*r.l:2-2*r.l):r.s,[r.h,r.s,r.l]},colorHslToHsb:function(e,t,a){var r={h:e,s:0,b:0},n=a,i=t*(n<.5?n:1-n);return r.b=n+i,r.s=n>0?2*i/r.b:r.s,[r.h,r.s,r.b]},colorThemeCSSProperties:function(){for(var e,t,a=[],r=arguments.length;r--;)a[r]=arguments[r];if(1===a.length?(e=a[0],t=Utils.colorHexToRgb(e)):3===a.length&&(t=a,e=Utils.colorRgbToHex.apply(Utils,t)),!t)return{};var n=Utils.colorRgbToHsl.apply(Utils,t),i=[n[0],n[1],Math.max(0,n[2]-.08)],o=[n[0],n[1],Math.max(0,n[2]+.08)],s=Utils.colorRgbToHex.apply(Utils,Utils.colorHslToRgb.apply(Utils,i)),l=Utils.colorRgbToHex.apply(Utils,Utils.colorHslToRgb.apply(Utils,o));return{"--f7-theme-color":e,"--f7-theme-color-rgb":t.join(", "),"--f7-theme-color-shade":s,"--f7-theme-color-tint":l}}},Support={touch:!!(win.navigator.maxTouchPoints>0||"ontouchstart"in win||win.DocumentTouch&&doc instanceof win.DocumentTouch),pointerEvents:!!win.PointerEvent,observer:"MutationObserver"in win||"WebkitMutationObserver"in win,passiveListener:function(){var e=!1;try{var t=Object.defineProperty({},"passive",{get:function(){e=!0}});win.addEventListener("testPassiveListener",null,t)}catch(e){}return e}(),gestures:"ongesturestart"in win,intersectionObserver:"IntersectionObserver"in win},Device=function(){var e=win.navigator.platform,t=win.navigator.userAgent,a={ios:!1,android:!1,androidChrome:!1,desktop:!1,iphone:!1,ipod:!1,ipad:!1,edge:!1,ie:!1,firefox:!1,macos:!1,windows:!1,cordova:!(!win.cordova&&!win.phonegap),phonegap:!(!win.cordova&&!win.phonegap),electron:!1},r=win.screen.width,n=win.screen.height,i=t.match(/(Android);?[\s\/]+([\d.]+)?/),o=t.match(/(iPad).*OS\s([\d_]+)/),s=t.match(/(iPod)(.*OS\s([\d_]+))?/),l=!o&&t.match(/(iPhone\sOS|iOS)\s([\d_]+)/),p=t.indexOf("MSIE ")>=0||t.indexOf("Trident/")>=0,c=t.indexOf("Edge/")>=0,d=t.indexOf("Gecko/")>=0&&t.indexOf("Firefox/")>=0,u="Win32"===e,h=t.toLowerCase().indexOf("electron")>=0,f="MacIntel"===e;!o&&f&&Support.touch&&(1024===r&&1366===n||834===r&&1194===n||834===r&&1112===n||768===r&&1024===n)&&(o=t.match(/(Version)\/([\d.]+)/),f=!1),a.ie=p,a.edge=c,a.firefox=d,i&&!u&&(a.os="android",a.osVersion=i[2],a.android=!0,a.androidChrome=t.toLowerCase().indexOf("chrome")>=0),(o||l||s)&&(a.os="ios",a.ios=!0),l&&!s&&(a.osVersion=l[2].replace(/_/g,"."),a.iphone=!0),o&&(a.osVersion=o[2].replace(/_/g,"."),a.ipad=!0),s&&(a.osVersion=s[3]?s[3].replace(/_/g,"."):null,a.ipod=!0),a.ios&&a.osVersion&&t.indexOf("Version/")>=0&&"10"===a.osVersion.split(".")[0]&&(a.osVersion=t.toLowerCase().split("version/")[1].split(" ")[0]),a.webView=!(!(l||o||s)||!t.match(/.*AppleWebKit(?!.*Safari)/i)&&!win.navigator.standalone)||win.matchMedia&&win.matchMedia("(display-mode: standalone)").matches,a.webview=a.webView,a.standalone=a.webView,a.desktop=!(a.ios||a.android)||h,a.desktop&&(a.electron=h,a.macos=f,a.windows=u,a.macos&&(a.os="macos"),a.windows&&(a.os="windows")),a.pixelRatio=win.devicePixelRatio||1;return a.prefersColorScheme=function(){var e;return win.matchMedia&&win.matchMedia("(prefers-color-scheme: light)").matches&&(e="light"),win.matchMedia&&win.matchMedia("(prefers-color-scheme: dark)").matches&&(e="dark"),e},a}(),EventsClass=function(e){void 0===e&&(e=[]);this.eventsParents=e,this.eventsListeners={}};EventsClass.prototype.on=function(e,t,a){var r=this;if("function"!=typeof t)return r;var n=a?"unshift":"push";return e.split(" ").forEach((function(e){r.eventsListeners[e]||(r.eventsListeners[e]=[]),r.eventsListeners[e][n](t)})),r},EventsClass.prototype.once=function(e,t,a){var r=this;if("function"!=typeof t)return r;function n(){for(var a=[],i=arguments.length;i--;)a[i]=arguments[i];r.off(e,n),n.f7proxy&&delete n.f7proxy,t.apply(r,a)}return n.f7proxy=t,r.on(e,n,a)},EventsClass.prototype.off=function(e,t){var a=this;return a.eventsListeners?(e.split(" ").forEach((function(e){void 0===t?a.eventsListeners[e]=[]:a.eventsListeners[e]&&a.eventsListeners[e].forEach((function(r,n){(r===t||r.f7proxy&&r.f7proxy===t)&&a.eventsListeners[e].splice(n,1)}))})),a):a},EventsClass.prototype.emit=function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];var a,r,n,i,o=this;if(!o.eventsListeners)return o;"string"==typeof e[0]||Array.isArray(e[0])?(a=e[0],r=e.slice(1,e.length),n=o,i=o.eventsParents):(a=e[0].events,r=e[0].data,n=e[0].context||o,i=e[0].local?[]:e[0].parents||o.eventsParents);var s=Array.isArray(a)?a:a.split(" "),l=s.map((function(e){return e.replace("local::","")})),p=s.filter((function(e){return e.indexOf("local::")<0}));return l.forEach((function(e){if(o.eventsListeners&&o.eventsListeners[e]){var t=[];o.eventsListeners[e].forEach((function(e){t.push(e)})),t.forEach((function(e){e.apply(n,r)}))}})),i&&i.length>0&&i.forEach((function(e){e.emit.apply(e,[p].concat(r))})),o};var Framework7Class=function(e){function t(t,a){void 0===t&&(t={}),void 0===a&&(a=[]),e.call(this,a);var r=this;r.params=t,r.params&&r.params.on&&Object.keys(r.params.on).forEach((function(e){r.on(e,r.params.on[e])}))}e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t;var a={components:{configurable:!0}};return t.prototype.useModuleParams=function(e,t){if(e.params){var a={};Object.keys(e.params).forEach((function(e){void 0!==t[e]&&(a[e]=Utils.extend({},t[e]))})),Utils.extend(t,e.params),Object.keys(a).forEach((function(e){Utils.extend(t[e],a[e])}))}},t.prototype.useModulesParams=function(e){var t=this;t.modules&&Object.keys(t.modules).forEach((function(a){var r=t.modules[a];r.params&&Utils.extend(e,r.params)}))},t.prototype.useModule=function(e,t){void 0===e&&(e=""),void 0===t&&(t={});var a=this;if(a.modules){var r="string"==typeof e?a.modules[e]:e;r&&(r.instance&&Object.keys(r.instance).forEach((function(e){var t=r.instance[e];a[e]="function"==typeof t?t.bind(a):t})),r.on&&a.on&&Object.keys(r.on).forEach((function(e){a.on(e,r.on[e])})),r.vnode&&(a.vnodeHooks||(a.vnodeHooks={}),Object.keys(r.vnode).forEach((function(e){Object.keys(r.vnode[e]).forEach((function(t){var n=r.vnode[e][t];a.vnodeHooks[t]||(a.vnodeHooks[t]={}),a.vnodeHooks[t][e]||(a.vnodeHooks[t][e]=[]),a.vnodeHooks[t][e].push(n.bind(a))}))}))),r.create&&r.create.bind(a)(t))}},t.prototype.useModules=function(e){void 0===e&&(e={});var t=this;t.modules&&Object.keys(t.modules).forEach((function(a){var r=e[a]||{};t.useModule(a,r)}))},a.components.set=function(e){this.use&&this.use(e)},t.installModule=function(e){for(var t=[],a=arguments.length-1;a-- >0;)t[a]=arguments[a+1];var r=this;r.prototype.modules||(r.prototype.modules={});var n=e.name||Object.keys(r.prototype.modules).length+"_"+Utils.now();return r.prototype.modules[n]=e,e.proto&&Object.keys(e.proto).forEach((function(t){r.prototype[t]=e.proto[t]})),e.static&&Object.keys(e.static).forEach((function(t){r[t]=e.static[t]})),e.install&&e.install.apply(r,t),r},t.use=function(e){for(var t=[],a=arguments.length-1;a-- >0;)t[a]=arguments[a+1];var r=this;return Array.isArray(e)?(e.forEach((function(e){return r.installModule(e)})),r):r.installModule.apply(r,[e].concat(t))},Object.defineProperties(t,a),t}(EventsClass);function ConstructorMethods(e){void 0===e&&(e={});var t=e.defaultSelector,a=e.constructor,r=e.domProp,n=e.app,i=e.addMethods,o={create:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return n?new(Function.prototype.bind.apply(a,[null].concat([n],e))):new(Function.prototype.bind.apply(a,[null].concat(e)))},get:function(e){if(void 0===e&&(e=t),e instanceof a)return e;var n=$(e);return 0!==n.length?n[0][r]:void 0},destroy:function(e){var t=o.get(e);if(t&&t.destroy)return t.destroy()}};return i&&Array.isArray(i)&&i.forEach((function(e){o[e]=function(a){void 0===a&&(a=t);for(var r=[],n=arguments.length-1;n-- >0;)r[n]=arguments[n+1];var i=o.get(a);if(i&&i[e])return i[e].apply(i,r)}})),o}function ModalMethods(e){void 0===e&&(e={});var t=e.defaultSelector,a=e.constructor,r=e.app;return Utils.extend(ConstructorMethods({defaultSelector:t,constructor:a,app:r,domProp:"f7Modal"}),{open:function(e,t){var n=$(e);if(n.length){var i=n[0].f7Modal;return i||(i=new a(r,{el:n})),i.open(t)}},close:function(e,n){void 0===e&&(e=t);var i=$(e);if(i.length){var o=i[0].f7Modal;return o||(o=new a(r,{el:i})),o.close(n)}}})}var fetchedModules=[];function loadModule(e){var t=this;return new Promise((function(a,r){var n,i,o,s=t.instance;if(e){if("string"==typeof e){var l=e.match(/([a-z0-9-]*)/i);if(e.indexOf(".")<0&&l&&l[0].length===e.length){if(!s||s&&!s.params.lazyModulesPath)return void r(new Error('Framework7: "lazyModulesPath" app parameter must be specified to fetch module by name'));n=s.params.lazyModulesPath+"/"+e+".js"}else n=e}else"function"==typeof e?o=e:i=e;if(o){var p=o(t,!1);if(!p)return void r(new Error("Framework7: Can't find Framework7 component in specified component function"));if(t.prototype.modules&&t.prototype.modules[p.name])return void a();h(p),a()}if(i){var c=i;if(!c)return void r(new Error("Framework7: Can't find Framework7 component in specified component"));if(t.prototype.modules&&t.prototype.modules[c.name])return void a();h(c),a()}if(n){if(fetchedModules.indexOf(n)>=0)return void a();fetchedModules.push(n);var d=new Promise((function(e,a){t.request.get(n,(function(r){var i="f7_component_loader_callback_"+Utils.id(),o=doc.createElement("script");o.innerHTML="window."+i+" = function (Framework7, Framework7AutoInstallComponent) {return "+r.trim()+"}",$("head").append(o);var s=win[i];delete win[i],$(o).remove();var l=s(t,!1);l?(t.prototype.modules&&t.prototype.modules[l.name]||h(l),e()):a(new Error("Framework7: Can't find Framework7 component in "+n+" file"))}),(function(e,t){a(e,t)}))})),u=new Promise((function(e){t.request.get(n.replace(".js",s.rtl?".rtl.css":".css"),(function(t){var a=doc.createElement("style");a.innerHTML=t,$("head").append(a),e()}),(function(){e()}))}));Promise.all([d,u]).then((function(){a()})).catch((function(e){r(e)}))}}else r(new Error("Framework7: Lazy module must be specified"));function h(e){t.use(e),s&&(s.useModuleParams(e,s.params),s.useModule(e))}}))}var Framework7=function(e){function t(a){if(e.call(this,a),t.instance)throw new Error("Framework7 is already initialized and can't be initialized more than once");var r=Utils.extend({},a),n=this;t.instance=n;var i={version:"1.0.0",id:"io.framework7.testapp",root:"body",theme:"auto",language:win.navigator.language,routes:[],name:"Framework7",lazyModulesPath:null,initOnDeviceReady:!0,init:!0,autoDarkTheme:!1,iosTranslucentBars:!0,iosTranslucentModals:!0,component:void 0,componentUrl:void 0};n.useModulesParams(i),n.params=Utils.extend(i,a);var o=$(n.params.root);Utils.extend(n,{id:n.params.id,name:n.params.name,version:n.params.version,routes:n.params.routes,language:n.params.language,root:o,rtl:"rtl"===o.css("direction"),theme:"auto"===n.params.theme?Device.ios?"ios":Device.desktop&&Device.electron?"aurora":"md":n.params.theme,passedParams:r,online:win.navigator.onLine}),n.root&&n.root[0]&&(n.root[0].f7=n),n.useModules(),n.initData();var s="(prefers-color-scheme: dark)",l="(prefers-color-scheme: light)";return n.mq={},win.matchMedia&&(n.mq.dark=win.matchMedia(s),n.mq.light=win.matchMedia(l)),n.colorSchemeListener=function(e){var t=e.matches,a=e.media;if(t){var r=doc.querySelector("html");a===s?r.classList.add("theme-dark"):a===l&&r.classList.remove("theme-dark")}},n.params.init&&(Device.cordova&&n.params.initOnDeviceReady?$(doc).on("deviceready",(function(){n.init()})):n.init()),n}e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t;var a={$:{configurable:!0},t7:{configurable:!0}},r={Dom7:{configurable:!0},$:{configurable:!0},Template7:{configurable:!0},Class:{configurable:!0},Events:{configurable:!0}};return t.prototype.initData=function(){var e=this;e.data={},e.params.data&&"function"==typeof e.params.data?Utils.extend(e.data,e.params.data.bind(e)()):e.params.data&&Utils.extend(e.data,e.params.data),e.methods={},e.params.methods&&Object.keys(e.params.methods).forEach((function(t){"function"==typeof e.params.methods[t]?e.methods[t]=e.params.methods[t].bind(e):e.methods[t]=e.params.methods[t]}))},t.prototype.enableAutoDarkTheme=function(){if(win.matchMedia){var e=this,t=doc.querySelector("html");e.mq.dark&&e.mq.light&&(e.mq.dark.addListener(e.colorSchemeListener),e.mq.light.addListener(e.colorSchemeListener)),e.mq.dark&&e.mq.dark.matches?t.classList.add("theme-dark"):e.mq.light&&e.mq.light.matches&&t.classList.remove("theme-dark")}},t.prototype.disableAutoDarkTheme=function(){if(win.matchMedia){this.mq.dark&&this.mq.dark.removeListener(this.colorSchemeListener),this.mq.light&&this.mq.light.removeListener(this.colorSchemeListener)}},t.prototype.initAppComponent=function(e){var t=this;t.router.componentLoader(t.params.component,t.params.componentUrl,{componentOptions:{el:t.root[0],root:!0}},(function(a){t.root=$(a),t.root[0].f7=t,t.rootComponent=a.f7Component,e&&e()}),(function(){}))},t.prototype._init=function(){var e=this;return e.initialized||(e.root.addClass("framework7-initializing"),e.rtl&&$("html").attr("dir","rtl"),e.params.autoDarkTheme&&e.enableAutoDarkTheme(),win.addEventListener("offline",(function(){e.online=!1,e.emit("offline"),e.emit("connection",!1)})),win.addEventListener("online",(function(){e.online=!0,e.emit("online"),e.emit("connection",!0)})),e.root.addClass("framework7-root"),$("html").removeClass("ios md aurora").addClass(e.theme),e.params.iosTranslucentBars&&"ios"===e.theme&&Device.ios&&$("html").addClass("ios-translucent-bars"),e.params.iosTranslucentModals&&"ios"===e.theme&&Device.ios&&$("html").addClass("ios-translucent-modals"),Utils.nextFrame((function(){e.root.removeClass("framework7-initializing")})),e.initialized=!0,e.emit("init")),e},t.prototype.init=function(){var e=this;e.params.component||e.params.componentUrl?e.initAppComponent((function(){e._init()})):e._init()},t.prototype.loadModule=function(){for(var e=[],a=arguments.length;a--;)e[a]=arguments[a];return t.loadModule.apply(t,e)},t.prototype.loadModules=function(){for(var e=[],a=arguments.length;a--;)e[a]=arguments[a];return t.loadModules.apply(t,e)},t.prototype.getVnodeHooks=function(e,t){return this.vnodeHooks&&this.vnodeHooks[e]&&this.vnodeHooks[e][t]||[]},a.$.get=function(){return $},a.t7.get=function(){return Template7},r.Dom7.get=function(){return $},r.$.get=function(){return $},r.Template7.get=function(){return Template7},r.Class.get=function(){return e},r.Events.get=function(){return EventsClass},Object.defineProperties(t.prototype,a),Object.defineProperties(t,r),t}(Framework7Class);Framework7.ModalMethods=ModalMethods,Framework7.ConstructorMethods=ConstructorMethods,Framework7.loadModule=loadModule,Framework7.loadModules=function(e){return Promise.all(e.map((function(e){return Framework7.loadModule(e)})))};var DeviceModule={name:"device",proto:{device:Device},static:{device:Device},on:{init:function(){var e=[],t=doc.querySelector("html"),a=doc.querySelector('meta[name="apple-mobile-web-app-status-bar-style"]');t&&(Device.standalone&&Device.ios&&a&&"black-translucent"===a.content&&e.push("device-full-viewport"),e.push("device-pixel-ratio-"+Math.floor(Device.pixelRatio)),Device.os&&!Device.desktop?e.push("device-"+Device.os):Device.desktop&&(e.push("device-desktop"),Device.os&&e.push("device-"+Device.os)),(Device.cordova||Device.phonegap)&&e.push("device-cordova"),e.forEach((function(e){t.classList.add(e)})))}}},SupportModule={name:"support",proto:{support:Support},static:{support:Support}},UtilsModule={name:"utils",proto:{utils:Utils},static:{utils:Utils}},ResizeModule={name:"resize",instance:{getSize:function(){if(!this.root[0])return{width:0,height:0,left:0,top:0};var e=this.root.offset(),t=[this.root[0].offsetWidth,this.root[0].offsetHeight,e.left,e.top],a=t[0],r=t[1],n=t[2],i=t[3];return this.width=a,this.height=r,this.left=n,this.top=i,{width:a,height:r,left:n,top:i}}},on:{init:function(){var e=this;e.getSize(),win.addEventListener("resize",(function(){e.emit("resize")}),!1),win.addEventListener("orientationchange",(function(){e.emit("orientationchange")}))},orientationchange:function(){this.device.ipad&&(doc.body.scrollLeft=0,setTimeout((function(){doc.body.scrollLeft=0}),0))},resize:function(){this.getSize()}}},globals={},jsonpRequests=0;function Request(e){var t=Utils.extend({},globals);"beforeCreate beforeOpen beforeSend error complete success statusCode".split(" ").forEach((function(e){delete t[e]}));var a=Utils.extend({url:win.location.toString(),method:"GET",data:!1,async:!0,cache:!0,user:"",password:"",headers:{},xhrFields:{},statusCode:{},processData:!0,dataType:"text",contentType:"application/x-www-form-urlencoded",timeout:0},t),r=Utils.extend({},a,e);function n(e){for(var t,a,n=[],i=arguments.length-1;i-- >0;)n[i]=arguments[i+1];return globals[e]&&(t=globals[e].apply(globals,n)),r[e]&&(a=r[e].apply(r,n)),"boolean"!=typeof t&&(t=!0),"boolean"!=typeof a&&(a=!0),t&&a}if(!1!==n("beforeCreate",r)){r.type&&(r.method=r.type);var i,o=r.url.indexOf("?")>=0?"&":"?",s=r.method.toUpperCase();if(("GET"===s||"HEAD"===s||"OPTIONS"===s||"DELETE"===s)&&r.data)(i="string"==typeof r.data?r.data.indexOf("?")>=0?r.data.split("?")[1]:r.data:Utils.serializeObject(r.data)).length&&(r.url+=o+i,"?"===o&&(o="&"));if("json"===r.dataType&&r.url.indexOf("callback=")>=0){var l,p="f7jsonp_"+(Date.now()+(jsonpRequests+=1)),c=r.url.split("callback="),d=c[0]+"callback="+p;if(c[1].indexOf("&")>=0){var u=c[1].split("&").filter((function(e){return e.indexOf("=")>0})).join("&");u.length>0&&(d+="&"+u)}var h=doc.createElement("script");return h.type="text/javascript",h.onerror=function(){clearTimeout(l),n("error",null,"scripterror","scripterror"),n("complete",null,"scripterror")},h.src=d,win[p]=function(e){clearTimeout(l),n("success",e),h.parentNode.removeChild(h),h=null,delete win[p]},doc.querySelector("head").appendChild(h),void(r.timeout>0&&(l=setTimeout((function(){h.parentNode.removeChild(h),h=null,n("error",null,"timeout","timeout")}),r.timeout)))}"GET"!==s&&"HEAD"!==s&&"OPTIONS"!==s&&"DELETE"!==s||!1===r.cache&&(r.url+=o+"_nocache"+Date.now());var f=new XMLHttpRequest;if(f.requestUrl=r.url,f.requestParameters=r,!1===n("beforeOpen",f,r))return f;f.open(s,r.url,r.async,r.user,r.password);var m=null;if(("POST"===s||"PUT"===s||"PATCH"===s)&&r.data)if(r.processData)if([ArrayBuffer,Blob,Document,FormData].indexOf(r.data.constructor)>=0)m=r.data;else{var v="---------------------------"+Date.now().toString(16);"multipart/form-data"===r.contentType?f.setRequestHeader("Content-Type","multipart/form-data; boundary="+v):f.setRequestHeader("Content-Type",r.contentType),m="";var g=Utils.serializeObject(r.data);if("multipart/form-data"===r.contentType){g=g.split("&");for(var b=[],y=0;y<g.length;y+=1)b.push('Content-Disposition: form-data; name="'+g[y].split("=")[0]+'"\r\n\r\n'+g[y].split("=")[1]+"\r\n");m="--"+v+"\r\n"+b.join("--"+v+"\r\n")+"--"+v+"--\r\n"}else m="application/json"===r.contentType?JSON.stringify(r.data):g}else m=r.data,f.setRequestHeader("Content-Type",r.contentType);return"json"!==r.dataType||r.headers&&r.headers.Accept||f.setRequestHeader("Accept","application/json"),r.headers&&Object.keys(r.headers).forEach((function(e){void 0!==r.headers[e]&&f.setRequestHeader(e,r.headers[e])})),void 0===r.crossDomain&&(r.crossDomain=/^([\w-]+:)?\/\/([^\/]+)/.test(r.url)&&RegExp.$2!==win.location.host),r.crossDomain||f.setRequestHeader("X-Requested-With","XMLHttpRequest"),r.xhrFields&&Utils.extend(f,r.xhrFields),f.onload=function(){var e;if(f.status>=200&&f.status<300||0===f.status)if("json"===r.dataType){var t;try{e=JSON.parse(f.responseText)}catch(e){t=!0}t?n("error",f,"parseerror","parseerror"):n("success",e,f.status,f)}else n("success",e="text"===f.responseType||""===f.responseType?f.responseText:f.response,f.status,f);else n("error",f,f.status,f.statusText);r.statusCode&&(globals.statusCode&&globals.statusCode[f.status]&&globals.statusCode[f.status](f),r.statusCode[f.status]&&r.statusCode[f.status](f)),n("complete",f,f.status)},f.onerror=function(){n("error",f,f.status,f.status),n("complete",f,"error")},r.timeout>0&&(f.timeout=r.timeout,f.ontimeout=function(){n("error",f,"timeout","timeout"),n("complete",f,"timeout")}),!1===n("beforeSend",f,r)?f:(f.send(m),f)}}function RequestShortcut(e){for(var t,a,r=[],n=arguments.length-1;n-- >0;)r[n]=arguments[n+1];var i=[],o=i[0],s=i[1],l=i[2],p=i[3],c=i[4];"function"==typeof r[1]?(o=(t=r)[0],l=t[1],p=t[2],c=t[3]):(o=(a=r)[0],s=a[1],l=a[2],p=a[3],c=a[4]),[l,p].forEach((function(e){"string"==typeof e&&(c=e,e===l?l=void 0:p=void 0)}));var d={url:o,method:"post"===e||"postJSON"===e?"POST":"GET",data:s,success:l,error:p,dataType:c=c||("json"===e||"postJSON"===e?"json":void 0)};return"postJSON"===e&&Utils.extend(d,{contentType:"application/json",processData:!1,crossDomain:!0,data:"string"==typeof s?s:JSON.stringify(s)}),Request(d)}function RequestShortcutPromise(e){for(var t=[],a=arguments.length-1;a-- >0;)t[a]=arguments[a+1];var r=t[0],n=t[1],i=t[2];return new Promise((function(t,a){RequestShortcut(e,r,n,(function(e,a,r){t({data:e,status:a,xhr:r})}),(function(e,t,r){a({xhr:e,status:t,message:r})}),i)}))}Object.assign(Request,{get:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return RequestShortcut.apply(void 0,["get"].concat(e))},post:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return RequestShortcut.apply(void 0,["post"].concat(e))},json:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return RequestShortcut.apply(void 0,["json"].concat(e))},getJSON:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return RequestShortcut.apply(void 0,["json"].concat(e))},postJSON:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return RequestShortcut.apply(void 0,["postJSON"].concat(e))}}),Request.promise=function(e){return new Promise((function(t,a){Request(Object.assign(e,{success:function(e,a,r){t({data:e,status:a,xhr:r})},error:function(e,t,r){a({xhr:e,status:t,message:r})}}))}))},Object.assign(Request.promise,{get:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return RequestShortcutPromise.apply(void 0,["get"].concat(e))},post:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return RequestShortcutPromise.apply(void 0,["post"].concat(e))},json:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return RequestShortcutPromise.apply(void 0,["json"].concat(e))},getJSON:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return RequestShortcutPromise.apply(void 0,["json"].concat(e))},postJSON:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return RequestShortcutPromise.apply(void 0,["postJSON"].concat(e))}}),Request.setup=function(e){e.type&&!e.method&&Utils.extend(e,{method:e.type}),Utils.extend(globals,e)};var RequestModule={name:"request",proto:{request:Request},static:{request:Request}};function initTouch(){var e,t,a,r,n,i,o,s,l,p,c,d,u=this,h=u.params.touch,f=h[u.theme+"TouchRipple"];function m(e){var t,a=$(e),r=a.parents(h.activeStateElements);if(a.closest(".no-active-state").length)return null;if(a.is(h.activeStateElements)&&(t=a),r.length>0&&(t=t?t.add(r):r),t&&t.length>1){for(var n,i=[],o=0;o<t.length;o+=1)n||(i.push(t[o]),(t.eq(o).hasClass("prevent-active-state-propagation")||t.eq(o).hasClass("no-active-state-propagation"))&&(n=!0));t=$(i)}return t||a}function v(e){return e.parents(".page-content").length>0}function g(){s&&s.addClass("active-state")}function b(){s&&(s.removeClass("active-state"),s=null)}function y(e,t,a){e&&(p=u.touchRipple.create(e,t,a))}function w(){p&&(p.remove(),p=void 0,c=void 0)}function C(a){(c=function(e){var t=h.touchRippleElements,a=$(e);if(a.is(t))return!a.hasClass("no-ripple")&&a;if(a.parents(t).length>0){var r=a.parents(t).eq(0);return!r.hasClass("no-ripple")&&r}return!1}(a))&&0!==c.length?v(c)?(clearTimeout(d),d=setTimeout((function(){w(),y(c,e,t)}),80)):(w(),y(c,e,t)):c=void 0}function x(){clearTimeout(d),w()}function k(){p||!c||r?w():(clearTimeout(d),y(c,e,t),setTimeout(w,0))}function E(){$(".active-state").removeClass("active-state"),f&&k()}function T(e,t){u.emit({events:e,data:[t]})}function S(e){T("touchstart touchstart:active",e)}function M(e){T("touchmove touchmove:active",e)}function P(e){T("touchend touchend:active",e)}function O(e){T("touchstart:passive",e)}function D(e){T("touchmove:passive",e)}function I(e){T("touchend:passive",e)}function B(e){T(e.type+" "+e.type+":active",e)}function R(e){T(e.type+":passive",e)}Device.ios&&Device.webView&&win.addEventListener("touchstart",(function(){}));var L=!!Support.passiveListener&&{passive:!0},z=!Support.passiveListener||{passive:!0,capture:!0},A=!!Support.passiveListener&&{passive:!1},H=!Support.passiveListener||{passive:!1,capture:!0};doc.addEventListener("click",(function(e){T("click",e)}),!0),Support.passiveListener?(doc.addEventListener(u.touchEvents.start,S,H),doc.addEventListener(u.touchEvents.move,M,A),doc.addEventListener(u.touchEvents.end,P,A),doc.addEventListener(u.touchEvents.start,O,z),doc.addEventListener(u.touchEvents.move,D,L),doc.addEventListener(u.touchEvents.end,I,L),Support.touch&&Support.gestures&&(doc.addEventListener("gesturestart",B,A),doc.addEventListener("gesturechange",B,A),doc.addEventListener("gestureend",B,A),doc.addEventListener("gesturestart",R,L),doc.addEventListener("gesturechange",R,L),doc.addEventListener("gestureend",R,L))):(doc.addEventListener(u.touchEvents.start,(function(e){S(e),O(e)}),!0),doc.addEventListener(u.touchEvents.move,(function(e){M(e),D(e)}),!1),doc.addEventListener(u.touchEvents.end,(function(e){P(e),I(e)}),!1),Support.touch&&Support.gestures&&(doc.addEventListener("gesturestart",(function(e){B(e),R(e)}),!1),doc.addEventListener("gesturechange",(function(e){B(e),R(e)}),!1),doc.addEventListener("gestureend",(function(e){B(e),R(e)}),!1))),Support.touch?(u.on("click",(function(e){var t=e&&e.detail&&"f7Overswipe"===e.detail,r=o;return a&&e.target!==a&&(r=!t),h.tapHold&&h.tapHoldPreventClicks&&n&&(r=!0),r&&(e.stopImmediatePropagation(),e.stopPropagation(),e.preventDefault()),h.tapHold&&(i=setTimeout((function(){n=!1}),Device.ios||Device.androidChrome?100:400)),o=!1,a=null,!r})),u.on("touchstart",(function(p){return r=!1,n=!1,o=!1,p.targetTouches.length>1?(s&&b(),!0):(p.touches.length>1&&s&&b(),h.tapHold&&(i&&clearTimeout(i),i=setTimeout((function(){p&&p.touches&&p.touches.length>1||(n=!0,p.preventDefault(),o=!0,$(p.target).trigger("taphold",p),u.emit("taphold",p))}),h.tapHoldDelay)),a=p.target,e=p.targetTouches[0].pageX,t=p.targetTouches[0].pageY,h.activeState&&((s=m(a))&&!v(s)?g():s&&(l=setTimeout(g,80))),f&&C(a),!0)})),u.on("touchmove",(function(a){var n,s;if("touchmove"===a.type&&(n=a.targetTouches[0],s=h.touchClicksDistanceThreshold),s&&n){var p=n.pageX,c=n.pageY;(Math.abs(p-e)>s||Math.abs(c-t)>s)&&(r=!0)}else r=!0;r&&(o=!0,h.tapHold&&clearTimeout(i),h.activeState&&(clearTimeout(l),b()),f&&x())})),u.on("touchend",(function(e){return clearTimeout(l),clearTimeout(i),doc.activeElement===e.target?(h.activeState&&b(),f&&k(),!0):(h.activeState&&(g(),setTimeout(b,0)),f&&k(),!(h.tapHoldPreventClicks&&n||o)||(e.cancelable&&e.preventDefault(),o=!0,!1))})),doc.addEventListener("touchcancel",(function(){a=null,clearTimeout(l),clearTimeout(i),h.activeState&&b(),f&&k()}),{passive:!0})):h.activeState&&(u.on("touchstart",(function(a){var r=m(a.target);r&&(r.addClass("active-state"),"which"in a&&3===a.which&&setTimeout((function(){$(".active-state").removeClass("active-state")}),0)),f&&(e=a.pageX,t=a.pageY,C(a.target,a.pageX,a.pageY))})),u.on("touchmove",(function(){h.activeStateOnMouseMove||$(".active-state").removeClass("active-state"),f&&x()})),u.on("touchend",E),doc.addEventListener("pointercancel",E,{passive:!0})),doc.addEventListener("contextmenu",(function(e){h.disableContextMenu&&(Device.ios||Device.android||Device.cordova)&&e.preventDefault(),f&&(s&&b(),k())}))}var TouchModule={name:"touch",params:{touch:{touchClicksDistanceThreshold:5,disableContextMenu:!1,tapHold:!1,tapHoldDelay:750,tapHoldPreventClicks:!0,activeState:!0,activeStateElements:"a, button, label, span, .actions-button, .stepper-button, .stepper-button-plus, .stepper-button-minus, .card-expandable, .menu-item, .link, .item-link, .accordion-item-toggle",activeStateOnMouseMove:!1,mdTouchRipple:!0,iosTouchRipple:!1,auroraTouchRipple:!1,touchRippleElements:".ripple, .link, .item-link, .list-button, .links-list a, .button, button, .input-clear-button, .dialog-button, .tab-link, .item-radio, .item-checkbox, .actions-button, .searchbar-disable-button, .fab a, .checkbox, .radio, .data-table .sortable-cell:not(.input-cell), .notification-close-button, .stepper-button, .stepper-button-minus, .stepper-button-plus, .menu-item-content, .list.accordion-list .accordion-item-toggle"}},instance:{touchEvents:{start:Support.touch?"touchstart":Support.pointerEvents?"pointerdown":"mousedown",move:Support.touch?"touchmove":Support.pointerEvents?"pointermove":"mousemove",end:Support.touch?"touchend":Support.pointerEvents?"pointerup":"mouseup"}},on:{init:initTouch}};function lexer(e){for(var t=[],a=0;a<e.length;){var r=e[a];if("*"!==r&&"+"!==r&&"?"!==r)if("\\"!==r)if("{"!==r)if("}"!==r)if(":"!==r)if("("!==r)t.push({type:"CHAR",index:a,value:e[a++]});else{var n=1,i="";if("?"===e[s=a+1])throw new TypeError('Pattern cannot start with "?" at '+s);for(;s<e.length;)if("\\"!==e[s]){if(")"===e[s]){if(0===--n){s++;break}}else if("("===e[s]&&(n++,"?"!==e[s+1]))throw new TypeError("Capturing groups are not allowed at "+s);i+=e[s++]}else i+=e[s++]+e[s++];if(n)throw new TypeError("Unbalanced pattern at "+a);if(!i)throw new TypeError("Missing pattern at "+a);t.push({type:"PATTERN",index:a,value:i}),a=s}else{for(var o="",s=a+1;s<e.length;){var l=e.charCodeAt(s);if(!(l>=48&&l<=57||l>=65&&l<=90||l>=97&&l<=122||95===l))break;o+=e[s++]}if(!o)throw new TypeError("Missing parameter name at "+a);t.push({type:"NAME",index:a,value:o}),a=s}else t.push({type:"CLOSE",index:a,value:e[a++]});else t.push({type:"OPEN",index:a,value:e[a++]});else t.push({type:"ESCAPED_CHAR",index:a++,value:e[a++]});else t.push({type:"MODIFIER",index:a,value:e[a++]})}return t.push({type:"END",index:a,value:""}),t}function parse(e,t){void 0===t&&(t={});for(var a=lexer(e),r=t.prefixes,n=void 0===r?"./":r,i="[^"+escapeString(t.delimiter||"/#?")+"]+?",o=[],s=0,l=0,p="",c=function(e){if(l<a.length&&a[l].type===e)return a[l++].value},d=function(e){var t=c(e);if(void 0!==t)return t;var r=a[l],n=r.type,i=r.index;throw new TypeError("Unexpected "+n+" at "+i+", expected "+e)},u=function(){for(var e,t="";e=c("CHAR")||c("ESCAPED_CHAR");)t+=e;return t};l<a.length;){var h=c("CHAR"),f=c("NAME"),m=c("PATTERN");if(f||m){var v=h||"";-1===n.indexOf(v)&&(p+=v,v=""),p&&(o.push(p),p=""),o.push({name:f||s++,prefix:v,suffix:"",pattern:m||i,modifier:c("MODIFIER")||""})}else{var g=h||c("ESCAPED_CHAR");if(g)p+=g;else if(p&&(o.push(p),p=""),c("OPEN")){v=u();var b=c("NAME")||"",y=c("PATTERN")||"",w=u();d("CLOSE"),o.push({name:b||(y?s++:""),pattern:b&&!y?i:y,prefix:v,suffix:w,modifier:c("MODIFIER")||""})}else d("END")}}return o}function compile(e,t){return tokensToFunction(parse(e,t),t)}function tokensToFunction(e,t){void 0===t&&(t={});var a=flags(t),r=t.encode,n=void 0===r?function(e){return e}:r,i=t.validate,o=void 0===i||i,s=e.map((function(e){if("object"==typeof e)return new RegExp("^(?:"+e.pattern+")$",a)}));return function(t){for(var a="",r=0;r<e.length;r++){var i=e[r];if("string"!=typeof i){var l=t?t[i.name]:void 0,p="?"===i.modifier||"*"===i.modifier,c="*"===i.modifier||"+"===i.modifier;if(Array.isArray(l)){if(!c)throw new TypeError('Expected "'+i.name+'" to not repeat, but got an array');if(0===l.length){if(p)continue;throw new TypeError('Expected "'+i.name+'" to not be empty')}for(var d=0;d<l.length;d++){var u=n(l[d],i);if(o&&!s[r].test(u))throw new TypeError('Expected all "'+i.name+'" to match "'+i.pattern+'", but got "'+u+'"');a+=i.prefix+u+i.suffix}}else if("string"!=typeof l&&"number"!=typeof l){if(!p){var h=c?"an array":"a string";throw new TypeError('Expected "'+i.name+'" to be '+h)}}else{u=n(String(l),i);if(o&&!s[r].test(u))throw new TypeError('Expected "'+i.name+'" to match "'+i.pattern+'", but got "'+u+'"');a+=i.prefix+u+i.suffix}}else a+=i}return a}}function escapeString(e){return e.replace(/([.+*?=^!:${}()[\]|/\\])/g,"\\$1")}function flags(e){return e&&e.sensitive?"":"i"}function regexpToRegexp(e,t){if(!t)return e;var a=e.source.match(/\((?!\?)/g);if(a)for(var r=0;r<a.length;r++)t.push({name:r,prefix:"",suffix:"",modifier:"",pattern:""});return e}function arrayToRegexp(e,t,a){var r=e.map((function(e){return pathToRegexp(e,t,a).source}));return new RegExp("(?:"+r.join("|")+")",flags(a))}function stringToRegexp(e,t,a){return tokensToRegexp(parse(e,a),t,a)}function tokensToRegexp(e,t,a){void 0===a&&(a={});for(var r=a.strict,n=void 0!==r&&r,i=a.start,o=void 0===i||i,s=a.end,l=void 0===s||s,p=a.encode,c=void 0===p?function(e){return e}:p,d="["+escapeString(a.endsWith||"")+"]|$",u="["+escapeString(a.delimiter||"/#?")+"]",h=o?"^":"",f=0,m=e;f<m.length;f++){var v=m[f];if("string"==typeof v)h+=escapeString(c(v));else{var g=escapeString(c(v.prefix)),b=escapeString(c(v.suffix));if(v.pattern)if(t&&t.push(v),g||b)if("+"===v.modifier||"*"===v.modifier){var y="*"===v.modifier?"?":"";h+="(?:"+g+"((?:"+v.pattern+")(?:"+b+g+"(?:"+v.pattern+"))*)"+b+")"+y}else h+="(?:"+g+"("+v.pattern+")"+b+")"+v.modifier;else h+="("+v.pattern+")"+v.modifier;else h+="(?:"+g+b+")"+v.modifier}}if(l)n||(h+=u+"?"),h+=a.endsWith?"(?="+d+")":"$";else{var w=e[e.length-1],C="string"==typeof w?u.indexOf(w[w.length-1])>-1:void 0===w;n||(h+="(?:"+u+"(?="+d+"))?"),C||(h+="(?="+u+"|"+d+")")}return new RegExp(h,flags(a))}function pathToRegexp(e,t,a){return e instanceof RegExp?regexpToRegexp(e,t):Array.isArray(e)?arrayToRegexp(e,t,a):stringToRegexp(e,t,a)}var History={queue:[],clearQueue:function(){0!==History.queue.length&&History.queue.shift()()},routerQueue:[],clearRouterQueue:function(){if(0!==History.routerQueue.length){var e=History.routerQueue.pop(),t=e.router,a=e.stateUrl,r=e.action,n=t.params.animate;!1===t.params.pushStateAnimate&&(n=!1),"back"===r&&t.back({animate:n,pushState:!1}),"load"===r&&t.navigate(a,{animate:n,pushState:!1})}},handle:function(e){if(!History.blockPopstate){var t=e.state;History.previousState=History.state,History.state=t,History.allowChange=!0,History.clearQueue(),(t=History.state)||(t={}),this.views.forEach((function(e){var a=e.router,r=t[e.id];if(!r&&e.params.pushState&&(r={url:e.router.history[0]}),r){var n=r.url||void 0,i=a.params.animate;!1===a.params.pushStateAnimate&&(i=!1),n!==a.url&&(a.history.indexOf(n)>=0?a.allowPageChange?a.back({animate:i,pushState:!1}):History.routerQueue.push({action:"back",router:a}):a.allowPageChange?a.navigate(n,{animate:i,pushState:!1}):History.routerQueue.unshift({action:"load",stateUrl:n,router:a}))}}))}},initViewState:function(e,t){var a,r=Utils.extend({},History.state||{},((a={})[e]=t,a));History.state=r,win.history.replaceState(r,"")},push:function(e,t,a){var r;if(History.allowChange){History.previousState=History.state;var n=Utils.extend({},History.previousState||{},((r={})[e]=t,r));History.state=n,win.history.pushState(n,"",a)}else History.queue.push((function(){History.push(e,t,a)}))},replace:function(e,t,a){var r;if(History.allowChange){History.previousState=History.state;var n=Utils.extend({},History.previousState||{},((r={})[e]=t,r));History.state=n,win.history.replaceState(n,"",a)}else History.queue.push((function(){History.replace(e,t,a)}))},go:function(e){History.allowChange=!1,win.history.go(e)},back:function(){History.allowChange=!1,win.history.back()},allowChange:!0,previousState:{},state:win.history.state,blockPopstate:!0,init:function(e){$(win).on("load",(function(){setTimeout((function(){History.blockPopstate=!1}),0)})),doc.readyState&&"complete"===doc.readyState&&(History.blockPopstate=!1),$(win).on("popstate",History.handle.bind(e))}};function SwipeBack(e){var t,a,r,n,i,o,s,l,p,c=e,d=c.$el,u=c.$navbarsEl,h=c.app,f=c.params,m=!1,v=!1,g={},b=[],y=[],w=!0,C=[],x=[],k=f[h.theme+"SwipeBackAnimateShadow"],E=f[h.theme+"SwipeBackAnimateOpacity"],T=f[h.theme+"SwipeBackActiveArea"],S=f[h.theme+"SwipeBackThreshold"],M=h.rtl?"right center":"left center",P=h.rtl?"calc(100% - var(--f7-navbar-large-title-padding-left) - var(--f7-safe-area-left)) center":"calc(var(--f7-navbar-large-title-padding-left) + var(--f7-safe-area-left)) center";function O(e){void 0===e&&(e={});for(var t=e.progress,a=e.reset,r=e.transition,n=["overflow","transform","transform-origin","opacity"],i=0;i<l.length;i+=1){var o=l[i];if(o&&o.el){!0===r&&o.el.classList.add("navbar-page-transitioning"),!1===r&&o.el.classList.remove("navbar-page-transitioning"),!o.className||o.classNameSet||a||(o.el.classList.add(o.className),o.classNameSet=!0),o.className&&a&&o.el.classList.remove(o.className);for(var s=0;s<n.length;s+=1){var p=n[s];o[p]&&(a?o.el.style[p]="":"function"==typeof o[p]?o.el.style[p]=o[p](t):o.el.style[p]=o[p])}}}}function D(e){var a=f[h.theme+"SwipeBack"];!w||!a||m||h.swipeout&&h.swipeout.el||!c.allowPageChange||$(e.target).closest(".range-slider, .calendar-months").length>0||$(e.target).closest(".page-master, .page-master-detail").length>0&&f.masterDetailBreakpoint>0&&h.width>=f.masterDetailBreakpoint||(v=!1,m=!0,t=void 0,g.x="touchstart"===e.type?e.targetTouches[0].pageX:e.pageX,g.y="touchstart"===e.type?e.targetTouches[0].pageY:e.pageY,n=Utils.now(),i=c.dynamicNavbar)}function I(e){if(m){var n="touchmove"===e.type?e.targetTouches[0].pageX:e.pageX,p="touchmove"===e.type?e.targetTouches[0].pageY:e.pageY;if(void 0===t&&(t=!!(t||Math.abs(p-g.y)>Math.abs(n-g.x))||n<g.x&&!h.rtl||n>g.x&&h.rtl),t||e.f7PreventSwipeBack||h.preventSwipeBack)m=!1;else{if(!v){var w=!1,D=$(e.target),I=D.closest(".swipeout");I.length>0&&(!h.rtl&&I.find(".swipeout-actions-left").length>0&&(w=!0),h.rtl&&I.find(".swipeout-actions-right").length>0&&(w=!0)),((b=D.closest(".page")).hasClass("no-swipeback")||D.closest(".no-swipeback, .card-opened").length>0)&&(w=!0),(y=d.find(".page-previous:not(.stacked)")).length>1&&(y=y.eq(y.length-1));g.x,d.offset().left;if(a=d.width(),(h.rtl?g.x<d.offset().left-d[0].scrollLeft+(a-T):g.x-d.offset().left>T)&&(w=!0),0!==y.length&&0!==b.length||(w=!0),w)return void(m=!1);k&&0===(o=b.find(".page-shadow-effect")).length&&(o=$('<div class="page-shadow-effect"></div>'),b.append(o)),E&&0===(s=y.find(".page-opacity-effect")).length&&(s=$('<div class="page-opacity-effect"></div>'),y.append(s)),i&&(C=u.find(".navbar-current:not(.stacked)"),(x=u.find(".navbar-previous:not(.stacked)")).length>1&&(x=x.eq(x.length-1)),l=function(){var e,t,a=[],r=h.rtl?-1:1,n=C.hasClass("navbar-transparent")&&!C.hasClass("navbar-large")&&!C.hasClass("navbar-transparent-visible"),i=C.hasClass("navbar-large"),o=C.hasClass("navbar-large-collapsed"),s=C.hasClass("navbar-large-transparent")||C.hasClass("navbar-large")&&C.hasClass("navbar-transparent"),l=x.hasClass("navbar-transparent")&&!x.hasClass("navbar-large")&&!x.hasClass("navbar-transparent-visible"),p=x.hasClass("navbar-large"),c=x.hasClass("navbar-large-collapsed"),d=x.hasClass("navbar-large-transparent")||x.hasClass("navbar-large")&&x.hasClass("navbar-transparent"),u=i&&!o,m=p&&!c,v=C.find(".left, .title, .right, .subnavbar, .fading, .title-large, .navbar-bg"),g=x.find(".left, .title, .right, .subnavbar, .fading, .title-large, .navbar-bg");return f.iosAnimateNavbarBackIcon&&(e=C.hasClass("sliding")||C.find(".navbar-inner.sliding").length?C.find(".left").find(".back .icon + span").eq(0):C.find(".left.sliding").find(".back .icon + span").eq(0),t=x.hasClass("sliding")||x.find(".navbar-inner.sliding").length?x.find(".left").find(".back .icon + span").eq(0):x.find(".left.sliding").find(".back .icon + span").eq(0),e.length&&g.each((function(t,a){$(a).hasClass("title")&&(a.f7NavbarLeftOffset+=e.prev(".icon")[0].offsetWidth)}))),v.each((function(t,l){var p=$(l),c=p.hasClass("subnavbar"),d=p.hasClass("left"),h=p.hasClass("title"),v=p.hasClass("navbar-bg");if((!h&&!v||!n)&&(u||!p.hasClass(".title-large"))){var g={el:l};if(u){if(h)return;if(p.hasClass("title-large"))return a.indexOf(g)<0&&a.push(g),g.overflow="visible",void p.find(".title-large-text").each((function(e,t){a.push({el:t,transform:function(e){return"translateX("+100*e*r+"%)"}})}))}if(m&&(u||p.hasClass("title-large")&&(a.indexOf(g)<0&&a.push(g),g.opacity=0),d))return a.indexOf(g)<0&&a.push(g),g.opacity=function(e){return 1-Math.pow(e,.33)},void p.find(".back span").each((function(e,t){a.push({el:t,"transform-origin":M,transform:function(e){return"translateX(calc("+e+" * (var(--f7-navbarTitleLargeOffset) - var(--f7-navbarLeftTextOffset)))) translateY(calc("+e+" * (var(--f7-navbar-large-title-height) - var(--f7-navbar-large-title-padding-vertical) / 2))) scale("+(1+1*e)+")"}})}));if(v)return a.indexOf(g)<0&&a.push(g),u||m||(o?(s&&(g.className="ios-swipeback-navbar-bg-large"),g.transform=function(e){return"translateX("+100*e*r+"%) translateY(calc(-1 * var(--f7-navbar-large-title-height)))"}):g.transform=function(e){return"translateX("+100*e*r+"%)"}),!u&&m&&(g.className="ios-swipeback-navbar-bg-large",g.transform=function(e){return"translateX("+100*e*r+"%) translateY(calc(-1 * "+(1-e)+" * var(--f7-navbar-large-title-height)))"}),u&&m&&(g.transform=function(e){return"translateX("+100*e*r+"%)"}),void(u&&!m&&(g.transform=function(e){return"translateX("+100*e*r+"%) translateY(calc(-"+e+" * var(--f7-navbar-large-title-height)))"}));if(!p.hasClass("title-large")){var b=p.hasClass("sliding")||p.parents(".navbar-inner.sliding").length;if(a.indexOf(g)<0&&a.push(g),(!c||c&&!b)&&(g.opacity=function(e){return 1-Math.pow(e,.33)}),b){var y=g;if(d&&e.length&&f.iosAnimateNavbarBackIcon){var w={el:e[0]};y=w,a.push(w)}y.transform=function(e){var t=e*y.el.f7NavbarRightOffset;return 1===Device.pixelRatio&&(t=Math.round(t)),c&&i?"translate3d("+t+"px, calc(-1 * var(--f7-navbar-large-collapse-progress) * var(--f7-navbar-large-title-height)), 0)":"translate3d("+t+"px,0,0)"}}}}})),g.each((function(e,n){var i=$(n),o=i.hasClass("subnavbar"),s=i.hasClass("left"),h=i.hasClass("title"),v=i.hasClass("navbar-bg");if(!h&&!v||!l){var g={el:n};if(m){if(h)return;if(a.indexOf(g)<0&&a.push(g),i.hasClass("title-large"))return g.opacity=1,g.overflow="visible",void i.find(".title-large-text").each((function(e,t){a.push({el:t,"transform-origin":P,opacity:function(e){return Math.pow(e,3)},transform:function(e){return"translateX(calc("+(1-e)+" * (var(--f7-navbarLeftTextOffset) - var(--f7-navbarTitleLargeOffset)))) translateY(calc("+(e-1)+" * var(--f7-navbar-large-title-height) + "+(1-e)+" * var(--f7-navbar-large-title-padding-vertical))) scale("+(.5+.5*e)+")"}})}))}if(v)return a.indexOf(g)<0&&a.push(g),u||m||(c?(d&&(g.className="ios-swipeback-navbar-bg-large"),g.transform=function(e){return"translateX("+(100*e-100)*r+"%) translateY(calc(-1 * var(--f7-navbar-large-title-height)))"}):g.transform=function(e){return"translateX("+(100*e-100)*r+"%)"}),!u&&m&&(g.transform=function(e){return"translateX("+(100*e-100)*r+"%) translateY(calc(-1 * "+(1-e)+" * var(--f7-navbar-large-title-height)))"}),u&&!m&&(g.className="ios-swipeback-navbar-bg-large",g.transform=function(e){return"translateX("+(100*e-100)*r+"%) translateY(calc(-"+e+" * var(--f7-navbar-large-title-height)))"}),void(u&&m&&(g.transform=function(e){return"translateX("+(100*e-100)*r+"%)"}));if(!i.hasClass("title-large")){var b=i.hasClass("sliding")||x.children(".navbar-inner.sliding").length;if(a.indexOf(g)<0&&a.push(g),(!o||o&&!b)&&(g.opacity=function(e){return Math.pow(e,3)}),b){var y=g;if(s&&t.length&&f.iosAnimateNavbarBackIcon){var w={el:t[0]};y=w,a.push(w)}y.transform=function(e){var t=y.el.f7NavbarLeftOffset*(1-e);return 1===Device.pixelRatio&&(t=Math.round(t)),o&&p?"translate3d("+t+"px, calc(-1 * var(--f7-navbar-large-collapse-progress) * var(--f7-navbar-large-title-height)), 0)":"translate3d("+t+"px,0,0)"}}}}})),a}()),$(".sheet.modal-in").length>0&&h.sheet&&h.sheet.close($(".sheet.modal-in"))}e.f7PreventSwipePanel=!0,v=!0,h.preventSwipePanelBySwipeBack=!0,e.preventDefault();var B=h.rtl?-1:1;(r=(n-g.x-S)*B)<0&&(r=0);var R=Math.min(Math.max(r/a,0),1),L={percentage:R,progress:R,currentPageEl:b[0],previousPageEl:y[0],currentNavbarEl:C[0],previousNavbarEl:x[0]};d.trigger("swipeback:move",L),c.emit("swipebackMove",L);var z=r*B,A=(r/5-a/5)*B;h.rtl?(z=Math.max(z,-a),A=Math.max(A,0)):(z=Math.min(z,a),A=Math.min(A,0)),1===Device.pixelRatio&&(z=Math.round(z),A=Math.round(A)),c.swipeBackActive=!0,$([b[0],y[0]]).addClass("page-swipeback-active"),b.transform("translate3d("+z+"px,0,0)"),k&&(o[0].style.opacity=1-1*R),"ios"===h.theme&&y.transform("translate3d("+A+"px,0,0)"),E&&(s[0].style.opacity=1-1*R),i&&O({progress:R})}}}function B(){if(h.preventSwipePanelBySwipeBack=!1,!m||!v)return m=!1,void(v=!1);if(m=!1,v=!1,c.swipeBackActive=!1,$([b[0],y[0]]).removeClass("page-swipeback-active"),0===r)return $([b[0],y[0]]).transform(""),o&&o.length>0&&o.remove(),s&&s.length>0&&s.remove(),void(i&&O({reset:!0}));var e=Utils.now()-n,t=!1;(e<300&&r>10||e>=300&&r>a/2)&&(b.removeClass("page-current").addClass("page-next"+("ios"!==h.theme?" page-next-on-right":"")),y.removeClass("page-previous").addClass("page-current").removeAttr("aria-hidden"),o&&(o[0].style.opacity=""),s&&(s[0].style.opacity=""),i&&(c.setNavbarPosition(C,"next"),c.setNavbarPosition(x,"current",!1)),t=!0),$([b[0],y[0]]).addClass("page-transitioning page-transitioning-swipeback").transform(""),i&&O({progress:t?1:0,transition:!0}),w=!1,c.allowPageChange=!1;var l={currentPageEl:b[0],previousPageEl:y[0],currentNavbarEl:C[0],previousNavbarEl:x[0]};t?(c.currentRoute=y[0].f7Page.route,c.currentPage=y[0],c.pageCallback("beforeOut",b,C,"current","next",{route:b[0].f7Page.route,swipeBack:!0}),c.pageCallback("beforeIn",y,x,"previous","current",{route:y[0].f7Page.route,swipeBack:!0},b[0]),d.trigger("swipeback:beforechange",l),c.emit("swipebackBeforeChange",l)):(d.trigger("swipeback:beforereset",l),c.emit("swipebackBeforeReset",l)),b.transitionEnd((function(){$([b[0],y[0]]).removeClass("page-transitioning page-transitioning-swipeback"),i&&O({reset:!0,transition:!1}),w=!0,c.allowPageChange=!0,t?(1===c.history.length&&c.history.unshift(c.url),c.history.pop(),c.saveHistory(),f.pushState&&History.back(),c.pageCallback("afterOut",b,C,"current","next",{route:b[0].f7Page.route,swipeBack:!0}),c.pageCallback("afterIn",y,x,"previous","current",{route:y[0].f7Page.route,swipeBack:!0}),f.stackPages&&c.initialPages.indexOf(b[0])>=0?(b.addClass("stacked"),i&&C.addClass("stacked")):(c.pageCallback("beforeRemove",b,C,"next",{swipeBack:!0}),c.removePage(b),i&&c.removeNavbar(C)),d.trigger("swipeback:afterchange",l),c.emit("swipebackAfterChange",l),c.emit("routeChanged",c.currentRoute,c.previousRoute,c),f.preloadPreviousPage&&c.back(c.history[c.history.length-2],{preload:!0})):(d.trigger("swipeback:afterreset",l),c.emit("swipebackAfterReset",l)),o&&o.length>0&&o.remove(),s&&s.length>0&&s.remove()}))}p=!("touchstart"!==h.touchEvents.start||!Support.passiveListener)&&{passive:!0,capture:!1},d.on(h.touchEvents.start,D,p),h.on("touchmove:active",I),h.on("touchend:passive",B),c.on("routerDestroy",(function(){var e=!("touchstart"!==h.touchEvents.start||!Support.passiveListener)&&{passive:!0,capture:!1};d.off(h.touchEvents.start,D,e),h.off("touchmove:active",I),h.off("touchend:passive",B)}))}function redirect(e,t,a){var r=this,n=t.route.redirect;if(a.initial&&r.params.pushState&&(a.replaceState=!0,a.history=!0),"function"==typeof n){r.allowPageChange=!1;var i=n.call(r,t,(function(t,n){void 0===n&&(n={}),r.allowPageChange=!0,r[e](t,Utils.extend({},a,n))}),(function(){r.allowPageChange=!0}));return i&&"string"==typeof i?(r.allowPageChange=!0,r[e](i,a)):r}return r[e](n,a)}function processQueue(e,t,a,r,n,i,o){var s=[];Array.isArray(a)?s.push.apply(s,a):a&&"function"==typeof a&&s.push(a),t&&(Array.isArray(t)?s.push.apply(s,t):s.push(t)),function t(){0!==s.length?s.shift().call(e,r,n,(function(){t()}),(function(){o()})):i()}()}function processRouteQueue(e,t,a,r){var n=this;function i(){e&&e.route&&(n.params.routesBeforeEnter||e.route.beforeEnter)?(n.allowPageChange=!1,processQueue(n,n.params.routesBeforeEnter,e.route.beforeEnter,e,t,(function(){n.allowPageChange=!0,a()}),(function(){r()}))):a()}t&&t.route&&(n.params.routesBeforeLeave||t.route.beforeLeave)?(n.allowPageChange=!1,processQueue(n,n.params.routesBeforeLeave,t.route.beforeLeave,e,t,(function(){n.allowPageChange=!0,i()}),(function(){r()}))):i()}function appRouterCheck(e,t){if(!e.view)throw new Error("Framework7: it is not allowed to use router methods on global app router. Use router methods only on related View, e.g. app.views.main.router."+t+"(...)")}function asyncComponent(e,t,a,r){function n(e){e.then((function(e){a({component:e.default||e._default||e})})).catch((function(e){throw r(),new Error(e)}))}if(t instanceof Promise)n(t);else{var i=t.call(e);i instanceof Promise?n(i):a({component:i})}}function refreshPage(){return appRouterCheck(this,"refreshPage"),this.navigate(this.currentRoute.url,{ignoreCache:!0,reloadCurrent:!0})}function forward(e,t){void 0===t&&(t={});var a,r,n,i=this,o=$(e),s=i.app,l=i.view,p=Utils.extend(!1,{animate:i.params.animate,pushState:!0,replaceState:!1,history:!0,reloadCurrent:i.params.reloadPages,reloadPrevious:!1,reloadAll:!1,clearPreviousHistory:!1,reloadDetail:i.params.reloadDetail,on:{}},t),c=i.params.masterDetailBreakpoint>0,d=c&&p.route&&p.route.route&&!0===p.route.route.master,u=i.currentRoute.modal;if(u||"popup popover sheet loginScreen actions customModal panel".split(" ").forEach((function(e){i.currentRoute&&i.currentRoute.route&&i.currentRoute.route[e]&&(u=!0,n=e)})),u){var h=i.currentRoute.modal||i.currentRoute.route.modalInstance||s[n].get(),f=i.history[i.history.length-2],m=i.findMatchingRoute(f);!m&&f&&(m={url:f,path:f.split("?")[0],query:Utils.parseUrlQuery(f),route:{path:f.split("?")[0],url:f}}),i.modalRemove(h)}var v,g,b,y,w=i.dynamicNavbar,C=i.$el,x=o,k=p.reloadPrevious||p.reloadCurrent||p.reloadAll;if(i.allowPageChange=!1,0===x.length)return i.allowPageChange=!0,i;x.length&&i.removeThemeElements(x),w&&(b=x.children(".navbar"),g=i.$navbarsEl,0===b.length&&x[0]&&x[0].f7Page&&(b=x[0].f7Page.$navbarEl)),p.route&&p.route.route&&p.route.route.keepAlive&&!p.route.route.keepAliveData&&(p.route.route.keepAliveData={pageEl:o[0]});var E,T,S,M,P=C.children(".page:not(.stacked)").filter((function(e,t){return t!==x[0]}));if(w&&(E=g.children(".navbar:not(.stacked)").filter((function(e,t){return t!==b[0]}))),p.reloadPrevious&&P.length<2)return i.allowPageChange=!0,i;if(c&&!p.reloadAll){for(var O=0;O<P.length;O+=1)a||!P[O].classList.contains("page-master")||(a=P[O]);if((T=!d&&a)&&a)for(var D=0;D<P.length;D+=1)P[D].classList.contains("page-master-detail")&&(r=P[D]);S=T&&p.reloadDetail&&s.width>=i.params.masterDetailBreakpoint&&a}T&&(M=!r||S||p.reloadAll||p.reloadCurrent);var I="next";if(p.reloadCurrent||p.reloadAll||S?I="current":p.reloadPrevious&&(I="previous"),x.removeClass("page-previous page-current page-next").addClass("page-"+I+(d?" page-master":"")+(T?" page-master-detail":"")+(M?" page-master-detail-root":"")).removeClass("stacked").trigger("page:unstack").trigger("page:position",{position:I}),i.emit("pageUnstack",x[0]),i.emit("pagePosition",x[0],I),(d||T)&&(x.trigger("page:role",{role:d?"master":"detail",root:!!M}),i.emit("pageRole",x[0],{role:d?"master":"detail",detailRoot:!!M})),w&&b.length&&(b.removeClass("navbar-previous navbar-current navbar-next").addClass("navbar-"+I+(d?" navbar-master":"")+(T?" navbar-master-detail":"")+(M?" navbar-master-detail-root":"")).removeClass("stacked"),b.trigger("navbar:position",{position:"newPagePosition"}),i.emit("navbarPosition",b[0],"newPagePosition"),(d||T)&&i.emit("navbarRole",b[0],{role:d?"master":"detail",detailRoot:!!M})),p.reloadCurrent||S)v=P.eq(P.length-1),w&&(y=$(s.navbar.getElByPage(v)));else if(p.reloadPrevious)v=P.eq(P.length-2),w&&(y=$(s.navbar.getElByPage(v)));else if(p.reloadAll)v=P.filter((function(e,t){return t!==x[0]})),w&&(y=E.filter((function(e,t){return t!==b[0]})));else{var B=[],R=[];if(P.length>1){var L=0;for(L=0;L<P.length-1;L+=1)if(a&&P[L]===a)P.eq(L).addClass("page-master-stacked"),P.eq(L).trigger("page:masterstack"),i.emit("pageMasterStack",P[L]),w&&($(s.navbar.getElByPage(a)).addClass("navbar-master-stacked"),i.emit("navbarMasterStack",s.navbar.getElByPage(a)));else{var z=s.navbar.getElByPage(P.eq(L));i.params.stackPages?(P.eq(L).addClass("stacked"),P.eq(L).trigger("page:stack"),i.emit("pageStack",P[L]),w&&$(z).addClass("stacked")):(B.push(P[L]),i.pageCallback("beforeRemove",P[L],E&&E[L],"previous",void 0,p),i.removePage(P[L]),w&&z&&(R.push(z),i.removeNavbar(z)))}}v=C.children(".page:not(.stacked)").filter((function(e,t){return t!==x[0]&&B.indexOf(t)<0})),w&&(y=g.children(".navbar:not(.stacked)").filter((function(e,t){return t!==b[0]&&R.indexOf(R)<0}))),B=[],R=[]}if(T&&!p.reloadAll&&((v.length>1||S)&&(v=v.filter((function(e,t){return!t.classList.contains("page-master")}))),y&&(y.length>1||S)&&(y=y.filter((function(e,t){return!t.classList.contains("navbar-master")})))),i.params.pushState&&(p.pushState||p.replaceState)&&!p.reloadPrevious){var A=i.params.pushStateRoot||"";History[p.reloadCurrent||S&&r||p.reloadAll||p.replaceState?"replace":"push"](l.id,{url:p.route.url},A+i.params.pushStateSeparator+p.route.url)}p.reloadPrevious||(i.currentPageEl=x[0],w&&b.length?i.currentNavbarEl=b[0]:delete i.currentNavbarEl,i.currentRoute=p.route);var H=p.route.url;p.history&&(((p.reloadCurrent||S&&r)&&i.history.length)>0||p.replaceState?i.history[i.history.length-(p.reloadPrevious?2:1)]=H:p.reloadPrevious?i.history[i.history.length-2]=H:p.reloadAll?i.history=[H]:i.history.push(H)),i.saveHistory();var U=x.parents(doc).length>0,N=x[0].f7Component;if(p.reloadPrevious?(N&&!U?N.$mount((function(e){$(e).insertBefore(v)})):x.insertBefore(v),w&&b.length&&(b.find(".title-large").length&&b.addClass("navbar-large"),y.length?b.insertBefore(y):(i.$navbarsEl.parents(doc).length||i.$el.prepend(i.$navbarsEl),g.append(b)))):(v.next(".page")[0]!==x[0]&&(N&&!U?N.$mount((function(e){C.append(e)})):C.append(x[0])),w&&b.length&&(b.find(".title-large").length&&b.addClass("navbar-large"),i.$navbarsEl.parents(doc).length||i.$el.prepend(i.$navbarsEl),g.append(b[0]))),U?p.route&&p.route.route&&p.route.route.keepAlive&&!x[0].f7PageMounted&&(x[0].f7PageMounted=!0,i.pageCallback("mounted",x,b,I,k?I:"current",p,v)):i.pageCallback("mounted",x,b,I,k?I:"current",p,v),(p.reloadCurrent||S)&&v.length>0?i.params.stackPages&&i.initialPages.indexOf(v[0])>=0?(v.addClass("stacked"),v.trigger("page:stack"),i.emit("pageStack",v[0]),w&&y.addClass("stacked")):(i.pageCallback("beforeOut",v,y,"current",void 0,p),i.pageCallback("afterOut",v,y,"current",void 0,p),i.pageCallback("beforeRemove",v,y,"current",void 0,p),i.removePage(v),w&&y&&y.length&&i.removeNavbar(y)):p.reloadAll?v.each((function(e,t){var a=$(t),r=$(s.navbar.getElByPage(a));i.params.stackPages&&i.initialPages.indexOf(a[0])>=0?(a.addClass("stacked"),a.trigger("page:stack"),i.emit("pageStack",a[0]),w&&r.addClass("stacked")):(a.hasClass("page-current")&&(i.pageCallback("beforeOut",v,y,"current",void 0,p),i.pageCallback("afterOut",v,y,"current",void 0,p)),i.pageCallback("beforeRemove",a,y&&y.eq(e),"previous",void 0,p),i.removePage(a),w&&r.length&&i.removeNavbar(r))})):p.reloadPrevious&&(i.params.stackPages&&i.initialPages.indexOf(v[0])>=0?(v.addClass("stacked"),v.trigger("page:stack"),i.emit("pageStack",v[0]),w&&y.addClass("stacked")):(i.pageCallback("beforeRemove",v,y,"previous",void 0,p),i.removePage(v),w&&y&&y.length&&i.removeNavbar(y))),p.route.route.tab&&i.tabLoad(p.route.route.tab,Utils.extend({},p,{history:!1,pushState:!1})),c&&l.checkMasterDetailBreakpoint(),i.pageCallback("init",x,b,I,k?I:"current",p,v),p.reloadCurrent||p.reloadAll||S)return i.allowPageChange=!0,i.pageCallback("beforeIn",x,b,I,"current",p),x.removeAttr("aria-hidden"),w&&b&&b.removeAttr("aria-hidden"),i.pageCallback("afterIn",x,b,I,"current",p),p.reloadCurrent&&p.clearPreviousHistory&&i.clearPreviousHistory(),S&&(i.setPagePosition($(a),"previous"),a.f7Page&&a.f7Page.navbarEl&&i.setNavbarPosition($(a.f7Page.navbarEl),"previous")),i;if(p.reloadPrevious)return i.allowPageChange=!0,i;function F(){i.setPagePosition(x,"current",!1),i.setPagePosition(v,"previous",!v.hasClass("page-master")),w&&(i.setNavbarPosition(b,"current",!1),i.setNavbarPosition(y,"previous",!y.hasClass("navbar-master"))),i.allowPageChange=!0,i.pageCallback("afterOut",v,y,"current","previous",p),i.pageCallback("afterIn",x,b,"next","current",p);var e=(i.params.preloadPreviousPage||i.params[s.theme+"SwipeBack"])&&!d;e||(x.hasClass("smart-select-page")||x.hasClass("photo-browser-page")||x.hasClass("autocomplete-page")||x.hasClass("color-picker-page"))&&(e=!0),e||(i.params.stackPages?(v.addClass("stacked"),v.trigger("page:stack"),i.emit("pageStack",v[0]),w&&y.addClass("stacked")):x.attr("data-name")&&"smart-select-page"===x.attr("data-name")||(i.pageCallback("beforeRemove",v,y,"previous",void 0,p),i.removePage(v),w&&y.length&&i.removeNavbar(y))),p.clearPreviousHistory&&i.clearPreviousHistory(),i.emit("routeChanged",i.currentRoute,i.previousRoute,i),i.params.pushState&&History.clearRouterQueue()}function V(){i.setPagePosition(v,"current",!1),i.setPagePosition(x,"next",!1),w&&(i.setNavbarPosition(y,"current",!1),i.setNavbarPosition(b,"next",!1))}if(i.pageCallback("beforeOut",v,y,"current","previous",p),i.pageCallback("beforeIn",x,b,"next","current",p),!p.animate||d&&s.width>=i.params.masterDetailBreakpoint)F();else{var q=i.params[i.app.theme+"PageLoadDelay"],j=i.params.transition;p.transition&&(j=p.transition),!j&&i.currentRoute&&i.currentRoute.route&&(j=i.currentRoute.route.transition),!j&&i.currentRoute&&i.currentRoute.route.options&&(j=i.currentRoute.route.options.transition),j&&(x[0].f7PageTransition=j),q?setTimeout((function(){V(),i.animate(v,x,y,b,"forward",j,(function(){F()}))}),q):(V(),i.animate(v,x,y,b,"forward",j,(function(){F()})))}return i}function load(e,t,a){void 0===e&&(e={}),void 0===t&&(t={});var r=this;if(!r.allowPageChange&&!a)return r;var n=e,i=t,o=n.url,s=n.content,l=n.el,p=n.pageName,c=n.template,d=n.templateUrl,u=n.component,h=n.componentUrl;if(!i.reloadCurrent&&i.route&&i.route.route&&i.route.route.parentPath&&r.currentRoute.route&&r.currentRoute.route.parentPath===i.route.route.parentPath){if(i.route.url===r.url)return r.allowPageChange=!0,!1;var f=Object.keys(i.route.params).length===Object.keys(r.currentRoute.params).length;if(f&&Object.keys(i.route.params).forEach((function(e){e in r.currentRoute.params&&r.currentRoute.params[e]===i.route.params[e]||(f=!1)})),f)return!!i.route.route.tab&&r.tabLoad(i.route.route.tab,i);if(!f&&i.route.route.tab&&r.currentRoute.route.tab&&r.currentRoute.parentPath===i.route.parentPath)return r.tabLoad(i.route.route.tab,i)}if(i.route&&i.route.url&&r.url===i.route.url&&!i.reloadCurrent&&!i.reloadPrevious&&!r.params.allowDuplicateUrls)return r.allowPageChange=!0,!1;function m(e,t){return r.forward(e,Utils.extend(i,t))}function v(){return r.allowPageChange=!0,r}if(!i.route&&o&&(i.route=r.parseRouteUrl(o),Utils.extend(i.route,{route:{url:o,path:o}})),(o||d||h)&&(r.allowPageChange=!1),s)r.forward(r.getPageEl(s),i);else if(c||d)try{r.pageTemplateLoader(c,d,i,m,v)}catch(e){throw r.allowPageChange=!0,e}else if(l)r.forward(r.getPageEl(l),i);else if(p)r.forward(r.$el.children('.page[data-name="'+p+'"]').eq(0),i);else if(u||h)try{r.pageComponentLoader(r.el,u,h,i,m,v)}catch(e){throw r.allowPageChange=!0,e}else o&&(r.xhr&&(r.xhr.abort(),r.xhr=!1),r.xhrRequest(o,i).then((function(e){r.forward(r.getPageEl(e),i)})).catch((function(){r.allowPageChange=!0})));return r}function navigate(e,t){void 0===t&&(t={});var a,r,n,i,o,s,l=this;if(l.swipeBackActive)return l;if("string"==typeof e?a=e:(a=e.url,r=e.route,n=e.name,i=e.query,o=e.params),n)return(a=l.generateUrl({name:n,params:o,query:i}))?l.navigate(a,t):l;var p=l.app;if(appRouterCheck(l,"navigate"),"#"===a||""===a)return l;var c=a.replace("./","");if("/"!==c[0]&&0!==c.indexOf("#")){var d=l.currentRoute.parentPath||l.currentRoute.path;c=((d?d+"/":"/")+c).replace("///","/").replace("//","/")}if(!(s=r?Utils.extend(l.parseRouteUrl(c),{route:Utils.extend({},r)}):l.findMatchingRoute(c)))return l;if(s.route&&s.route.viewName){var u=s.route.viewName,h=p.views[u];if(!h)throw new Error('Framework7: There is no View with "'+u+'" name that was specified in this route');if(h!==l.view)return h.router.navigate(e,t)}if(s.route.redirect)return redirect.call(l,"navigate",s,t);var f={};function m(){var e=!1;function t(e,t){l.allowPageChange=!1;var a=!1;t&&t.context&&(s.context?s.context=Utils.extend({},s.context,t.context):s.context=t.context,f.route.context=s.context),"popup popover sheet loginScreen actions customModal panel".split(" ").forEach((function(r){if(e[r]){a=!0;var n=Utils.extend({},s,{route:e});l.allowPageChange=!0,l.modalLoad(r,n,Utils.extend(f,t))}})),a||l.load(e,Utils.extend(f,t),!0)}function a(){l.allowPageChange=!0}"popup popover sheet loginScreen actions customModal panel".split(" ").forEach((function(t){s.route[t]&&!e&&(e=!0,l.modalLoad(t,s,f))})),s.route.keepAlive&&s.route.keepAliveData&&(l.load({el:s.route.keepAliveData.pageEl},f,!1),e=!0),"url content component pageName el componentUrl template templateUrl".split(" ").forEach((function(t){var a;s.route[t]&&!e&&(e=!0,l.load(((a={})[t]=s.route[t],a),f,!1))})),e||(s.route.async&&(l.allowPageChange=!1,s.route.async.call(l,f.route,l.currentRoute,t,a)),s.route.asyncComponent&&asyncComponent(l,s.route.asyncComponent,t,a))}function v(){l.allowPageChange=!0}if(s.route.options?Utils.extend(f,s.route.options,t):Utils.extend(f,t),f.route=s,f&&f.context&&(s.context=f.context,f.route.context=f.context),l.params.masterDetailBreakpoint>0&&s.route.masterRoute){var g=!0,b=!1;if(l.currentRoute&&l.currentRoute.route&&(!l.currentRoute.route.master||l.currentRoute.route!==s.route.masterRoute&&l.currentRoute.route.path!==s.route.masterRoute.path||(g=!1),!l.currentRoute.route.masterRoute||l.currentRoute.route.masterRoute!==s.route.masterRoute&&l.currentRoute.route.masterRoute.path!==s.route.masterRoute.path||(g=!1,b=!0)),g||b&&t.reloadAll)return l.navigate(s.route.masterRoute.path,{animate:!1,reloadAll:t.reloadAll,reloadCurrent:t.reloadCurrent,reloadPrevious:t.reloadPrevious,pushState:!t.initial,history:!t.initial,once:{pageAfterIn:function(){l.navigate(e,Utils.extend({},t,{animate:!1,reloadAll:!1,reloadCurrent:!1,reloadPrevious:!1,history:!t.initial,pushState:!t.initial}))}}}),l}return processRouteQueue.call(l,s,l.currentRoute,(function(){s.route.modules?p.loadModules(Array.isArray(s.route.modules)?s.route.modules:[s.route.modules]).then((function(){m()})).catch((function(){v()})):m()}),(function(){v()})),l}function tabLoad(e,t){void 0===t&&(t={});var a,r,n=this,i=Utils.extend({animate:n.params.animate,pushState:!0,history:!0,parentPageEl:null,preload:!1,on:{}},t);i.route&&(i.preload||i.route===n.currentRoute||(r=n.previousRoute,n.currentRoute=i.route),i.preload?(a=i.route,r=n.currentRoute):(a=n.currentRoute,r||(r=n.previousRoute)),n.params.pushState&&i.pushState&&!i.reloadPrevious&&History.replace(n.view.id,{url:i.route.url},(n.params.pushStateRoot||"")+n.params.pushStateSeparator+i.route.url),i.history&&(n.history[Math.max(n.history.length-1,0)]=i.route.url,n.saveHistory()));var o,s=$(i.parentPageEl||n.currentPageEl);o=s.length&&s.find("#"+e.id).length?s.find("#"+e.id).eq(0):n.view.selector?n.view.selector+" #"+e.id:"#"+e.id;var l,p=n.app.tab.show({tabEl:o,animate:i.animate,tabRoute:i.route}),c=p.$newTabEl,d=p.$oldTabEl,u=p.animated,h=p.onTabsChanged;if(c&&c.parents(".page").length>0&&i.route){var f=c.parents(".page")[0].f7Page;f&&i.route&&(f.route=i.route)}if(c[0].f7RouterTabLoaded)return d&&d.length?(u?h((function(){n.emit("routeChanged",n.currentRoute,n.previousRoute,n)})):n.emit("routeChanged",n.currentRoute,n.previousRoute,n),n):n;function m(t,a){var r=t.url,i=t.content,o=t.el,s=t.template,l=t.templateUrl,p=t.component,f=t.componentUrl;function m(t){n.allowPageChange=!0,t&&("string"==typeof t?c.html(t):(c.html(""),t.f7Component?t.f7Component.$mount((function(e){c.append(e)})):c.append(t)),c[0].f7RouterTabLoaded=!0,function(t){n.removeThemeElements(c);var a=c;"string"!=typeof t&&(a=$(t)),a.trigger("tab:init tab:mounted",e),n.emit("tabInit tabMounted",c[0],e),d&&d.length&&(u?h((function(){n.emit("routeChanged",n.currentRoute,n.previousRoute,n),n.params.unloadTabContent&&n.tabRemove(d,c,e)})):(n.emit("routeChanged",n.currentRoute,n.previousRoute,n),n.params.unloadTabContent&&n.tabRemove(d,c,e)))}(t))}function v(){return n.allowPageChange=!0,n}if(i)m(i);else if(s||l)try{n.tabTemplateLoader(s,l,a,m,v)}catch(e){throw n.allowPageChange=!0,e}else if(o)m(o);else if(p||f)try{n.tabComponentLoader(c[0],p,f,a,m,v)}catch(e){throw n.allowPageChange=!0,e}else r&&(n.xhr&&(n.xhr.abort(),n.xhr=!1),n.xhrRequest(r,a).then((function(e){m(e)})).catch((function(){n.allowPageChange=!0})))}function v(e,t){m(e,Utils.extend(i,t))}function g(){n.allowPageChange=!0}return"url content component el componentUrl template templateUrl".split(" ").forEach((function(t){var a;e[t]&&(l=!0,m(((a={})[t]=e[t],a),i))})),e.async?e.async.call(n,a,r,v,g):e.asyncComponent?asyncComponent(n,e.asyncComponent,v,g):l||(n.allowPageChange=!0),n}function tabRemove(e,t,a){var r;e[0]&&(e[0].f7RouterTabLoaded=!1,delete e[0].f7RouterTabLoaded),e.children().each((function(e,t){t.f7Component&&(r=!0,$(t).trigger("tab:beforeremove",a),t.f7Component.$destroy())})),r||e.trigger("tab:beforeremove",a),this.emit("tabBeforeRemove",e[0],t[0],a),this.removeTabContent(e[0],a)}function modalLoad(e,t,a){void 0===a&&(a={});var r,n=this,i=n.app,o="panel"===e,s=o?"panel":"modal",l=Utils.extend({animate:n.params.animate,pushState:!0,history:!0,on:{}},a),p=Utils.extend({},t.route[e]),c=t.route;function d(){var a=i[e].create(p);c.modalInstance=a;var r=a.el;function d(){a.close()}a.on(s+"Open",(function(){r||(n.removeThemeElements(a.el),a.$el.trigger(e.toLowerCase()+":init "+e.toLowerCase()+":mounted",t,a),n.emit((o?"":"modalInit")+" "+e+"Init "+e+"Mounted",a.el,t,a)),n.once("swipeBackMove",d)})),a.on(s+"Close",(function(){n.off("swipeBackMove",d),a.closeByRouter||n.back()})),a.on(s+"Closed",(function(){a.$el.trigger(e.toLowerCase()+":beforeremove",t,a),a.emit((o?"":"modalBeforeRemove ")+e+"BeforeRemove",a.el,t,a);var r=a.el.f7Component;r&&r.$destroy(),Utils.nextTick((function(){(r||p.component)&&n.removeModal(a.el),a.destroy(),delete a.route,delete c.modalInstance}))})),l.route&&(n.params.pushState&&l.pushState&&History.push(n.view.id,{url:l.route.url,modal:e},(n.params.pushStateRoot||"")+n.params.pushStateSeparator+l.route.url),l.route!==n.currentRoute&&(a.route=Utils.extend(l.route,{modal:a}),n.currentRoute=a.route),l.history&&(n.history.push(l.route.url),n.saveHistory())),r&&(n.removeThemeElements(a.el),a.$el.trigger(e.toLowerCase()+":init "+e.toLowerCase()+":mounted",t,a),n.emit(s+"Init "+e+"Init "+e+"Mounted",a.el,t,a)),a.open()}function u(e,t){var a=e.url,r=e.content,o=e.template,s=e.templateUrl,l=e.component,c=e.componentUrl;function u(e){e&&("string"==typeof e?p.content=e:e.f7Component?e.f7Component.$mount((function(e){p.el=e,i.root.append(e)})):p.el=e,d())}function h(){return n.allowPageChange=!0,n}if(r)u(r);else if(o||s)try{n.modalTemplateLoader(o,s,t,u,h)}catch(e){throw n.allowPageChange=!0,e}else if(l||c)try{n.modalComponentLoader(i.root[0],l,c,t,u,h)}catch(e){throw n.allowPageChange=!0,e}else a?(n.xhr&&(n.xhr.abort(),n.xhr=!1),n.xhrRequest(a,t).then((function(e){p.content=e,d()})).catch((function(){n.allowPageChange=!0}))):d()}function h(e,t){u(e,Utils.extend(l,t))}function f(){n.allowPageChange=!0}return"url content component el componentUrl template templateUrl".split(" ").forEach((function(e){var t;p[e]&&!r&&(r=!0,u(((t={})[e]=p[e],t),l))})),r||"actions"!==e||d(),p.async&&p.async.call(n,l.route,n.currentRoute,h,f),p.asyncComponent&&asyncComponent(n,p.asyncComponent,h,f),n}function modalRemove(e){Utils.extend(e,{closeByRouter:!0}),e.close()}function backward(e,t){var a,r,n,i,o,s,l,p,c=this,d=$(e),u=c.app,h=c.view,f=Utils.extend({animate:c.params.animate,pushState:!0,replaceState:!1},t),m=c.params.masterDetailBreakpoint>0,v=m&&f.route&&f.route.route&&!0===f.route.route.master,g=c.dynamicNavbar,b=d,y=c.$el.children(".page-current"),w=m&&y.hasClass("page-master");if(b.length&&c.removeThemeElements(b),g&&(i=b.children(".navbar"),n=c.$navbarsEl,0===i.length&&b[0]&&b[0].f7Page&&(i=b[0].f7Page.$navbarEl),o=n.find(".navbar-current")),c.allowPageChange=!1,0===b.length||0===y.length)return c.allowPageChange=!0,c;if(c.removeThemeElements(b),f.route&&f.route.route&&f.route.route.keepAlive&&!f.route.route.keepAliveData&&(f.route.route.keepAliveData={pageEl:d[0]}),m){for(var C=c.$el.children(".page:not(.stacked)").filter((function(e,t){return t!==b[0]})),x=0;x<C.length;x+=1)a||!C[x].classList.contains("page-master")||(a=C[x]);!(s=!v&&a&&c.history.indexOf(f.route.url)>c.history.indexOf(a.f7Page.route.url))&&!v&&a&&a.f7Page&&f.route.route.masterRoute&&(s=f.route.route.masterRoute.path===a.f7Page.route.route.path)}if(s&&a&&a.f7Page&&(l=c.history.indexOf(f.route.url)-c.history.indexOf(a.f7Page.route.url)==1),b.addClass("page-previous"+(v?" page-master":"")+(s?" page-master-detail":"")+(l?" page-master-detail-root":"")).removeClass("stacked").removeAttr("aria-hidden").trigger("page:unstack").trigger("page:position",{position:"previous"}),c.emit("pageUnstack",b[0]),c.emit("pagePosition",b[0],"previous"),(v||s)&&(b.trigger("page:role",{role:v?"master":"detail",root:!!l}),c.emit("pageRole",b[0],{role:v?"master":"detail",detailRoot:!!l})),g&&i.length>0&&(i.addClass("navbar-previous"+(v?" navbar-master":"")+(s?" navbar-master-detail":"")+(l?" navbar-master-detail-root":"")).removeClass("stacked").removeAttr("aria-hidden"),i.trigger("navbar:position",{position:"previous"}),c.emit("navbarPosition",i[0],"previous"),(v||l)&&c.emit("navbarRole",i[0],{role:v?"master":"detail",detailRoot:!!l})),f.force&&(y.prev(".page-previous:not(.stacked)").length>0||0===y.prev(".page-previous").length))if(c.history.indexOf(f.route.url)>=0?(p=c.history.length-c.history.indexOf(f.route.url)-1,c.history=c.history.slice(0,c.history.indexOf(f.route.url)+2),h.history=c.history):c.history[[c.history.length-2]]?c.history[c.history.length-2]=f.route.url:c.history.unshift(c.url),p&&c.params.stackPages)y.prevAll(".page-previous").each((function(e,t){var n,i=$(t);g&&(n=$(u.navbar.getElByPage(i))),i[0]!==b[0]&&i.index()>b.index()&&(c.initialPages.indexOf(i[0])>=0?(i.addClass("stacked"),i.trigger("page:stack"),c.emit("pageStack",i[0]),g&&n.addClass("stacked")):(c.pageCallback("beforeRemove",i,n,"previous",void 0,f),i[0]===a&&(r=!0),c.removePage(i),g&&n.length>0&&c.removeNavbar(n)))}));else{var k,E=y.prev(".page-previous:not(.stacked)");g&&(k=$(u.navbar.getElByPage(E))),c.params.stackPages&&c.initialPages.indexOf(E[0])>=0?(E.addClass("stacked"),E.trigger("page:stack"),c.emit("pageStack",E[0]),k.addClass("stacked")):E.length>0&&(c.pageCallback("beforeRemove",E,k,"previous",void 0,f),E[0]===a&&(r=!0),c.removePage(E),g&&k.length&&c.removeNavbar(k))}var T=b.parents(doc).length>0,S=b[0].f7Component;function M(){0===b.next(y).length&&(!T&&S?S.$mount((function(e){$(e).insertBefore(y)})):b.insertBefore(y)),g&&i.length&&(i.find(".title-large").length&&i.addClass("navbar-large"),i.insertBefore(o),o.length>0?i.insertBefore(o):(c.$navbarsEl.parents(doc).length||c.$el.prepend(c.$navbarsEl),n.append(i))),T?f.route&&f.route.route&&f.route.route.keepAlive&&!b[0].f7PageMounted&&(b[0].f7PageMounted=!0,c.pageCallback("mounted",b,i,"previous","current",f,y)):c.pageCallback("mounted",b,i,"previous","current",f,y)}if(f.preload){M(),f.route.route.tab&&c.tabLoad(f.route.route.tab,Utils.extend({},f,{history:!1,pushState:!1,preload:!0})),v&&(b.removeClass("page-master-stacked").trigger("page:masterunstack"),c.emit("pageMasterUnstack",b[0]),g&&($(u.navbar.getElByPage(b)).removeClass("navbar-master-stacked"),c.emit("navbarMasterUnstack",u.navbar.getElByPage(b)))),c.pageCallback("init",b,i,"previous","current",f,y);var P=b.prevAll(".page-previous:not(.stacked):not(.page-master)");return P.length>0&&P.each((function(e,t){var a,r=$(t);g&&(a=$(u.navbar.getElByPage(r))),c.params.stackPages&&c.initialPages.indexOf(t)>=0?(r.addClass("stacked"),r.trigger("page:stack"),c.emit("pageStack",r[0]),g&&a.addClass("stacked")):(c.pageCallback("beforeRemove",r,a,"previous",void 0),c.removePage(r),g&&a.length&&c.removeNavbar(a))})),c.allowPageChange=!0,c}if(!(Device.ie||Device.edge||Device.firefox&&!Device.ios)&&c.params.pushState&&f.pushState)if(f.replaceState){var O=c.params.pushStateRoot||"";History.replace(h.id,{url:f.route.url},O+c.params.pushStateSeparator+f.route.url)}else p?History.go(-p):History.back();if(f.replaceState?c.history[c.history.length-1]=f.route.url:(1===c.history.length&&c.history.unshift(c.url),c.history.pop()),c.saveHistory(),c.currentPageEl=b[0],g&&i.length?c.currentNavbarEl=i[0]:delete c.currentNavbarEl,c.currentRoute=f.route,(Device.ie||Device.edge||Device.firefox&&!Device.ios)&&c.params.pushState&&f.pushState)if(f.replaceState){var D=c.params.pushStateRoot||"";History.replace(h.id,{url:f.route.url},D+c.params.pushStateSeparator+f.route.url)}else p?History.go(-p):History.back();function I(){c.setPagePosition(b,"current",!1),c.setPagePosition(y,"next",!0),g&&(c.setNavbarPosition(i,"current",!1),c.setNavbarPosition(o,"next",!0)),c.pageCallback("afterOut",y,o,"current","next",f),c.pageCallback("afterIn",b,i,"previous","current",f),c.params.stackPages&&c.initialPages.indexOf(y[0])>=0?(y.addClass("stacked"),y.trigger("page:stack"),c.emit("pageStack",y[0]),g&&o.addClass("stacked")):(c.pageCallback("beforeRemove",y,o,"next",void 0,f),c.removePage(y),g&&o.length&&c.removeNavbar(o)),c.allowPageChange=!0,c.emit("routeChanged",c.currentRoute,c.previousRoute,c),(c.params.preloadPreviousPage||c.params[u.theme+"SwipeBack"])&&c.history[c.history.length-2]&&!v&&c.back(c.history[c.history.length-2],{preload:!0}),c.params.pushState&&History.clearRouterQueue()}if(M(),f.route.route.tab&&c.tabLoad(f.route.route.tab,Utils.extend({},f,{history:!1,pushState:!1})),m&&(w||r)&&h.checkMasterDetailBreakpoint(!1),c.pageCallback("init",b,i,"previous","current",f,y),c.pageCallback("beforeOut",y,o,"current","next",f),c.pageCallback("beforeIn",b,i,"previous","current",f),!f.animate||w&&u.width>=c.params.masterDetailBreakpoint)I();else{var B=c.params.transition;y[0]&&y[0].f7PageTransition&&(B=y[0].f7PageTransition,delete y[0].f7PageTransition),f.transition&&(B=f.transition),!B&&c.previousRoute&&c.previousRoute.route&&(B=c.previousRoute.route.transition),!B&&c.previousRoute&&c.previousRoute.route&&c.previousRoute.route.options&&(B=c.previousRoute.route.options.transition),c.setPagePosition(y,"current"),c.setPagePosition(b,"previous",!1),g&&(c.setNavbarPosition(o,"current"),c.setNavbarPosition(i,"previous",!1)),c.animate(y,b,o,i,"backward",B,(function(){I()}))}return c}function loadBack(e,t,a){var r=this;if(!r.allowPageChange&&!a)return r;var n=e,i=t,o=n.url,s=n.content,l=n.el,p=n.pageName,c=n.template,d=n.templateUrl,u=n.component,h=n.componentUrl;if(i.route.url&&r.url===i.route.url&&!i.reloadCurrent&&!i.reloadPrevious&&!r.params.allowDuplicateUrls)return!1;function f(e,t){return r.backward(e,Utils.extend(i,t))}function m(){return r.allowPageChange=!0,r}if(!i.route&&o&&(i.route=r.parseRouteUrl(o)),(o||d||h)&&(r.allowPageChange=!1),s)r.backward(r.getPageEl(s),i);else if(c||d)try{r.pageTemplateLoader(c,d,i,f,m)}catch(e){throw r.allowPageChange=!0,e}else if(l)r.backward(r.getPageEl(l),i);else if(p)r.backward(r.$el.children('.page[data-name="'+p+'"]').eq(0),i);else if(u||h)try{r.pageComponentLoader(r.el,u,h,i,f,m)}catch(e){throw r.allowPageChange=!0,e}else o&&(r.xhr&&(r.xhr.abort(),r.xhr=!1),r.xhrRequest(o,i).then((function(e){r.backward(r.getPageEl(e),i)})).catch((function(){r.allowPageChange=!0})));return r}function back(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];var a,r,n,i=this;if(i.swipeBackActive)return i;"object"==typeof e[0]?r=e[0]||{}:(a=e[0],r=e[1]||{});var o=r.name,s=r.params,l=r.query;if(o)return(a=i.generateUrl({name:o,params:s,query:l}))?i.back(a,Utils.extend({},r,{name:null,params:null,query:null})):i;var p=i.app;appRouterCheck(i,"back");var c,d=i.currentRoute.modal;if(d||"popup popover sheet loginScreen actions customModal panel".split(" ").forEach((function(e){i.currentRoute.route[e]&&(d=!0,c=e)})),d){var u,h=i.currentRoute.modal||i.currentRoute.route.modalInstance||p[c].get(),f=i.history[i.history.length-2];if(h&&h.$el){var m=h.$el.prevAll(".modal-in");m.length&&m[0].f7Modal&&(u=m[0].f7Modal.route)}if(u||(u=i.findMatchingRoute(f)),!u&&f&&(u={url:f,path:f.split("?")[0],query:Utils.parseUrlQuery(f),route:{path:f.split("?")[0],url:f}}),!(a&&0!==a.replace(/[# ]/g,"").trim().length||u&&h))return i;var v=r.force&&u&&a;if(u&&h){var g=Device.ie||Device.edge||Device.firefox&&!Device.ios,b=i.params.pushState&&!1!==r.pushState;b&&!g&&History.back(),i.currentRoute=u,i.history.pop(),i.saveHistory(),b&&g&&History.back(),i.modalRemove(h),v&&i.navigate(a,{reloadCurrent:!0})}else h&&(i.modalRemove(h),a&&i.navigate(a,{reloadCurrent:!0}));return i}var y,w=i.$el.children(".page-current").prevAll(".page-previous:not(.page-master)").eq(0);if(i.params.masterDetailBreakpoint>0){var C=i.$el.children(".page-current").prevAll(".page-master").eq(0);if(C.length){var x=i.history[i.history.length-2],$=i.findMatchingRoute(x);$&&$.route===C[0].f7Page.route.route&&(w=C,r.preload||(y=p.width>=i.params.masterDetailBreakpoint))}}if(!r.force&&w.length&&!y){if(i.params.pushState&&w[0].f7Page&&i.history[i.history.length-2]!==w[0].f7Page.route.url)return i.back(i.history[i.history.length-2],Utils.extend(r,{force:!0})),i;var k=w[0].f7Page.route;return processRouteQueue.call(i,k,i.currentRoute,(function(){i.loadBack({el:w},Utils.extend(r,{route:k}))}),(function(){})),i}if("#"===a&&(a=void 0),a&&"/"!==a[0]&&0!==a.indexOf("#")&&(a=((i.path||"/")+a).replace("//","/")),!a&&i.history.length>1&&(a=i.history[i.history.length-2]),y&&!r.force&&i.history[i.history.length-3])return i.back(i.history[i.history.length-3],Utils.extend({},r||{},{force:!0,animate:!1}));if(y&&!r.force)return i;if((n=i.findMatchingRoute(a))||a&&(n={url:a,path:a.split("?")[0],query:Utils.parseUrlQuery(a),route:{path:a.split("?")[0],url:a}}),!n)return i;if(n.route.redirect)return redirect.call(i,"back",n,r);var E,T={};if(n.route.options?Utils.extend(T,n.route.options,r):Utils.extend(T,r),T.route=n,T&&T.context&&(n.context=T.context,T.route.context=T.context),T.force&&i.params.stackPages&&(i.$el.children(".page-previous.stacked").each((function(e,t){t.f7Page&&t.f7Page.route&&t.f7Page.route.url===n.url&&(E=!0,i.loadBack({el:t},T))})),E))return i;function S(){var e=!1;function t(e,t){i.allowPageChange=!1,t&&t.context&&(n.context?n.context=Utils.extend({},n.context,t.context):n.context=t.context,T.route.context=n.context),i.loadBack(e,Utils.extend(T,t),!0)}function a(){i.allowPageChange=!0}n.route.keepAlive&&n.route.keepAliveData&&(i.loadBack({el:n.route.keepAliveData.pageEl},T),e=!0),"url content component pageName el componentUrl template templateUrl".split(" ").forEach((function(t){var a;n.route[t]&&!e&&(e=!0,i.loadBack(((a={})[t]=n.route[t],a),T))})),e||(n.route.async&&(i.allowPageChange=!1,n.route.async.call(i,n,i.currentRoute,t,a)),n.route.asyncComponent&&asyncComponent(i,n.route.asyncComponent,t,a))}function M(){i.allowPageChange=!0}return T.preload?S():processRouteQueue.call(i,n,i.currentRoute,(function(){n.route.modules?p.loadModules(Array.isArray(n.route.modules)?n.route.modules:[n.route.modules]).then((function(){S()})).catch((function(){M()})):S()}),(function(){M()})),i}function clearPreviousPages(e){appRouterCheck(e,"clearPreviousPages");var t=e.app,a=e.dynamicNavbar;e.$el.children(".page").filter((function(t,a){return!(!e.currentRoute||!e.currentRoute.modal&&!e.currentRoute.panel)||a!==e.currentPageEl})).each((function(r,n){var i=$(n),o=$(t.navbar.getElByPage(i));e.params.stackPages&&e.initialPages.indexOf(i[0])>=0?(i.addClass("stacked"),a&&o.addClass("stacked")):(e.pageCallback("beforeRemove",i,o,"previous",void 0,{}),e.removePage(i),a&&o.length&&e.removeNavbar(o))}))}function clearPreviousHistory(){appRouterCheck(this,"clearPreviousHistory");var e=this.history[this.history.length-1];clearPreviousPages(this),this.history=[e],this.view.history=[e],this.saveHistory()}var Router=function(e){function t(t,a){e.call(this,{},[void 0===a?t:a]);var r=this;r.isAppRouter=void 0===a,r.isAppRouter?Utils.extend(!1,r,{app:t,params:t.params.view,routes:t.routes||[],cache:t.cache}):Utils.extend(!1,r,{app:t,view:a,viewId:a.id,params:a.params,routes:a.routes,$el:a.$el,el:a.el,$navbarsEl:a.$navbarsEl,navbarsEl:a.navbarsEl,history:a.history,scrollHistory:a.scrollHistory,cache:t.cache,dynamicNavbar:"ios"===t.theme&&a.params.iosDynamicNavbar,initialPages:[],initialNavbars:[]}),r.useModules(),r.tempDom=doc.createElement("div"),r.allowPageChange=!0;var n={},i={};return Object.defineProperty(r,"currentRoute",{enumerable:!0,configurable:!0,set:function(e){void 0===e&&(e={}),i=Utils.extend({},n),(n=e)&&(r.url=n.url,r.emit("routeChange",e,i,r))},get:function(){return n}}),Object.defineProperty(r,"previousRoute",{enumerable:!0,configurable:!0,get:function(){return i},set:function(e){i=e}}),r}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t.prototype.animatableNavElements=function(e,t,a,r,n){var i,o,s=this.dynamicNavbar,l=this.params.iosAnimateNavbarBackIcon;function p(e,t){var a,r=e.hasClass("sliding")||t.hasClass("sliding"),n=e.hasClass("subnavbar"),i=!r||!n,o=e.find(".back .icon");return r&&l&&e.hasClass("left")&&o.length>0&&o.next("span").length&&(e=o.next("span"),a=!0),{$el:e,isIconLabel:a,leftOffset:e[0].f7NavbarLeftOffset,rightOffset:e[0].f7NavbarRightOffset,isSliding:r,isSubnavbar:n,needsOpacityTransition:i}}return s&&(i=[],o=[],e.children(".navbar-inner").children(".left, .right, .title, .subnavbar").each((function(t,o){var s=$(o);s.hasClass("left")&&r&&"forward"===n||s.hasClass("title")&&a||i.push(p(s,e.children(".navbar-inner")))})),t.hasClass("navbar-master")&&this.params.masterDetailBreakpoint>0&&this.app.width>=this.params.masterDetailBreakpoint||t.children(".navbar-inner").children(".left, .right, .title, .subnavbar").each((function(e,i){var s=$(i);s.hasClass("left")&&a&&!r&&"forward"===n||s.hasClass("left")&&a&&"backward"===n||s.hasClass("title")&&r||o.push(p(s,t.children(".navbar-inner")))})),[o,i].forEach((function(e){e.forEach((function(t){var a=t,r=t.isSliding,n=t.$el,s=e===o?i:o;r&&n.hasClass("title")&&s&&s.forEach((function(e){if(e.isIconLabel){var t=e.$el[0];a.leftOffset+=t&&t.offsetLeft||0}}))}))}))),{newNavEls:i,oldNavEls:o}},t.prototype.animate=function(e,t,a,r,n,i,o){var s=this;if(s.params.animateCustom)s.params.animateCustom.apply(s,[e,t,a,r,n,o]);else{var l=s.dynamicNavbar,p="ios"===s.app.theme;if(i){var c="router-transition-custom router-transition-"+i+"-"+n;return("forward"===n?t:e).animationEnd((function(){s.$el.removeClass(c),l&&s.$navbarsEl.length&&(r&&s.$navbarsEl.prepend(r),a&&s.$navbarsEl.prepend(a)),o&&o()})),l&&(r&&t&&(s.setNavbarPosition(r,""),r.removeClass("navbar-next navbar-previous navbar-current"),t.prepend(r)),a&&e&&(s.setNavbarPosition(a,""),a.removeClass("navbar-next navbar-previous navbar-current"),e.prepend(a))),void s.$el.addClass(c)}var d,u,h,f,m,v,g="router-transition-"+n+" router-transition";if(p&&l){s.params.masterDetailBreakpoint>0&&s.app.width>=s.params.masterDetailBreakpoint&&(a.hasClass("navbar-master")&&r.hasClass("navbar-master-detail")||a.hasClass("navbar-master-detail")&&r.hasClass("navbar-master"))||(m=a&&a.hasClass("navbar-large"),v=r&&r.hasClass("navbar-large"),h=m&&!a.hasClass("navbar-large-collapsed"),f=v&&!r.hasClass("navbar-large-collapsed"));var b=s.animatableNavElements(r,a,f,h,n);d=b.newNavEls,u=b.oldNavEls}("forward"===n?t:e).animationEnd((function(){s.dynamicNavbar&&(r&&(r.removeClass("router-navbar-transition-to-large router-navbar-transition-from-large"),r.addClass("navbar-no-title-large-transition"),Utils.nextFrame((function(){r.removeClass("navbar-no-title-large-transition")}))),a&&a.removeClass("router-navbar-transition-to-large router-navbar-transition-from-large"),r.hasClass("sliding")?r.find(".title, .left, .right, .left .icon, .subnavbar").transform(""):r.find(".sliding").transform(""),a.hasClass("sliding")?a.find(".title, .left, .right, .left .icon, .subnavbar").transform(""):a.find(".sliding").transform("")),s.$el.removeClass(g),o&&o()})),l?(y(0),Utils.nextFrame((function(){y(1),s.$el.addClass(g)}))):s.$el.addClass(g)}function y(e){p&&l&&(1===e&&(f&&(r.addClass("router-navbar-transition-to-large"),a.addClass("router-navbar-transition-to-large")),h&&(r.addClass("router-navbar-transition-from-large"),a.addClass("router-navbar-transition-from-large"))),d.forEach((function(t){var a=t.$el,r="forward"===n?t.rightOffset:t.leftOffset;t.isSliding&&(t.isSubnavbar&&v?a[0].style.setProperty("transform","translate3d("+r*(1-e)+"px, calc(-1 * var(--f7-navbar-large-collapse-progress) * var(--f7-navbar-large-title-height)), 0)","important"):a.transform("translate3d("+r*(1-e)+"px,0,0)"))})),u.forEach((function(t){var a=t.$el,r="forward"===n?t.leftOffset:t.rightOffset;t.isSliding&&(t.isSubnavbar&&m?a.transform("translate3d("+r*e+"px, calc(-1 * var(--f7-navbar-large-collapse-progress) * var(--f7-navbar-large-title-height)), 0)"):a.transform("translate3d("+r*e+"px,0,0)"))})))}},t.prototype.removeModal=function(e){this.removeEl(e)},t.prototype.removeTabContent=function(e){$(e).html("")},t.prototype.removeNavbar=function(e){this.removeEl(e)},t.prototype.removePage=function(e){var t=$(e),a=t&&t[0]&&t[0].f7Page;a&&a.route&&a.route.route&&a.route.route.keepAlive?t.remove():this.removeEl(e)},t.prototype.removeEl=function(e){if(e){var t=$(e);0!==t.length&&(t.find(".tab").each((function(e,t){$(t).children().each((function(e,t){t.f7Component&&($(t).trigger("tab:beforeremove"),t.f7Component.$destroy())}))})),t[0].f7Component&&t[0].f7Component.$destroy&&t[0].f7Component.$destroy(),this.params.removeElements&&(this.params.removeElementsWithTimeout?setTimeout((function(){t.remove()}),this.params.removeElementsTimeout):t.remove()))}},t.prototype.getPageEl=function(e){if("string"==typeof e)this.tempDom.innerHTML=e;else{if($(e).hasClass("page"))return e;this.tempDom.innerHTML="",$(this.tempDom).append(e)}return this.findElement(".page",this.tempDom)},t.prototype.findElement=function(e,t,a){var r=this.view,n=this.app,i=$(t),o=e;a&&(o+=":not(.stacked)");var s=i.find(o).filter((function(e,t){return 0===$(t).parents(".popup, .dialog, .popover, .actions-modal, .sheet-modal, .login-screen, .page").length}));return s.length>1&&("string"==typeof r.selector&&(s=i.find(r.selector+" "+o)),s.length>1&&(s=i.find("."+n.params.viewMainClass+" "+o))),1===s.length?s:(a||(s=this.findElement(o,i,!0)),s&&1===s.length?s:s&&s.length>1?$(s[0]):void 0)},t.prototype.flattenRoutes=function(e){void 0===e&&(e=this.routes);var t=this,a=[];return e.forEach((function(e){var r=!1;if("tabs"in e&&e.tabs){var n=e.tabs.map((function(t){var a=Utils.extend({},e,{path:(e.path+"/"+t.path).replace("///","/").replace("//","/"),parentPath:e.path,tab:t});return delete a.tabs,delete a.routes,a}));r=!0,a=a.concat(t.flattenRoutes(n))}if("detailRoutes"in e){var i=e.detailRoutes.map((function(t){var a=Utils.extend({},t);return a.masterRoute=e,a.masterRoutePath=e.path,a}));a=a.concat(e,t.flattenRoutes(i))}if("routes"in e){var o=e.routes.map((function(t){var a=Utils.extend({},t);return a.path=(e.path+"/"+a.path).replace("///","/").replace("//","/"),a}));a=r?a.concat(t.flattenRoutes(o)):a.concat(e,t.flattenRoutes(o))}"routes"in e||"tabs"in e&&e.tabs||"detailRoutes"in e||a.push(e)})),a},t.prototype.parseRouteUrl=function(e){if(!e)return{};var t=Utils.parseUrlQuery(e),a=e.split("#")[1],r=e.split("#")[0].split("?")[0];return{query:t,hash:a,params:{},url:e,path:r}},t.prototype.generateUrl=function(e){if(void 0===e&&(e={}),"string"==typeof e)return e;var t=e.name,a=e.params,r=e.query;if(!t)throw new Error("Framework7: name parameter is required");var n=this.findRouteByKey("name",t);if(!n)throw new Error('Framework7: route with name "'+t+'" not found');var i=this.constructRouteUrl(n,{params:a,query:r});if(!i)throw new Error("Framework7: can't construct URL for route with name \""+t+'"');return i},t.prototype.constructRouteUrl=function(e,t){void 0===t&&(t={});var a,r=t.params,n=t.query,i=e.path,o=compile(i);try{a=o(r||{})}catch(e){throw new Error("Framework7: error constructing route URL from passed params:\nRoute: "+i+"\n"+e.toString())}return n&&(a+="string"==typeof n?"?"+n:"?"+Utils.serializeObject(n)),a},t.prototype.findTabRoute=function(e){var t,a=$(e),r=this.currentRoute.route.parentPath,n=a.attr("id");return this.flattenRoutes(this.routes).forEach((function(e){e.parentPath===r&&e.tab&&e.tab.id===n&&(t=e)})),t},t.prototype.findRouteByKey=function(e,t){var a,r=this.routes;return this.flattenRoutes(r).forEach((function(r){a||r[e]===t&&(a=r)})),a},t.prototype.findMatchingRoute=function(e){if(e){var t,a=this.routes,r=this.flattenRoutes(a),n=this.parseRouteUrl(e),i=n.path,o=n.query,s=n.hash,l=n.params;return r.forEach((function(a){if(!t){var r,n,p=[],c=[a.path];if(a.alias&&("string"==typeof a.alias?c.push(a.alias):Array.isArray(a.alias)&&a.alias.forEach((function(e){c.push(e)}))),c.forEach((function(e){r||(r=pathToRegexp(e,p).exec(i))})),r)p.forEach((function(e,t){if("number"!=typeof e.name){var a=r[t+1];l[e.name]=null==a?a:decodeURIComponent(a)}})),a.parentPath&&(n=i.split("/").slice(0,a.parentPath.split("/").length-1).join("/")),t={query:o,hash:s,params:l,url:e,path:i,parentPath:n,route:a,name:a.name}}})),t}},t.prototype.replaceRequestUrlParams=function(e,t){void 0===e&&(e=""),void 0===t&&(t={});var a=e;return"string"==typeof a&&a.indexOf("{{")>=0&&t&&t.route&&t.route.params&&Object.keys(t.route.params).length&&Object.keys(t.route.params).forEach((function(e){var r=new RegExp("{{"+e+"}}","g");a=a.replace(r,t.route.params[e]||"")})),a},t.prototype.removeFromXhrCache=function(e){for(var t=this.cache.xhr,a=!1,r=0;r<t.length;r+=1)t[r].url===e&&(a=r);!1!==a&&t.splice(a,1)},t.prototype.xhrRequest=function(e,t){var a=this,r=a.params,n=t.ignoreCache,i=e,o=i.indexOf("?")>=0;return r.passRouteQueryToRequest&&t&&t.route&&t.route.query&&Object.keys(t.route.query).length&&(i+=(o?"&":"?")+Utils.serializeObject(t.route.query),o=!0),r.passRouteParamsToRequest&&t&&t.route&&t.route.params&&Object.keys(t.route.params).length&&(i+=(o?"&":"?")+Utils.serializeObject(t.route.params),o=!0),i.indexOf("{{")>=0&&(i=a.replaceRequestUrlParams(i,t)),r.xhrCacheIgnoreGetParameters&&i.indexOf("?")>=0&&(i=i.split("?")[0]),new Promise((function(e,o){if(r.xhrCache&&!n&&i.indexOf("nocache")<0&&r.xhrCacheIgnore.indexOf(i)<0)for(var s=0;s<a.cache.xhr.length;s+=1){var l=a.cache.xhr[s];if(l.url===i&&Utils.now()-l.time<r.xhrCacheDuration)return void e(l.content)}a.xhr=a.app.request({url:i,method:"GET",beforeSend:function(e){a.emit("routerAjaxStart",e,t)},complete:function(n,s){a.emit("routerAjaxComplete",n),"error"!==s&&"timeout"!==s&&n.status>=200&&n.status<300||0===n.status?(r.xhrCache&&""!==n.responseText&&(a.removeFromXhrCache(i),a.cache.xhr.push({url:i,time:Utils.now(),content:n.responseText})),a.emit("routerAjaxSuccess",n,t),e(n.responseText)):(a.emit("routerAjaxError",n,t),o(n))},error:function(e){a.emit("routerAjaxError",e,t),o(e)}})}))},t.prototype.setNavbarPosition=function(e,t,a){e.removeClass("navbar-previous navbar-current navbar-next"),t&&e.addClass("navbar-"+t),!1===a?e.removeAttr("aria-hidden"):!0===a&&e.attr("aria-hidden","true"),e.trigger("navbar:position",{position:t}),this.emit("navbarPosition",e[0],t)},t.prototype.setPagePosition=function(e,t,a){e.removeClass("page-previous page-current page-next"),e.addClass("page-"+t),!1===a?e.removeAttr("aria-hidden"):!0===a&&e.attr("aria-hidden","true"),e.trigger("page:position",{position:t}),this.emit("pagePosition",e[0],t)},t.prototype.removeThemeElements=function(e){var t,a=this.app.theme;"ios"===a?t=".md-only, .aurora-only, .if-md, .if-aurora, .if-not-ios, .not-ios":"md"===a?t=".ios-only, .aurora-only, .if-ios, .if-aurora, .if-not-md, .not-md":"aurora"===a&&(t=".ios-only, .md-only, .if-ios, .if-md, .if-not-aurora, .not-aurora"),$(e).find(t).remove()},t.prototype.getPageData=function(e,t,a,r,n,i){void 0===n&&(n={});var o,s,l=$(e).eq(0),p=$(t).eq(0),c=l[0].f7Page||{};if(("next"===a&&"current"===r||"current"===a&&"previous"===r)&&(o="forward"),("current"===a&&"next"===r||"previous"===a&&"current"===r)&&(o="backward"),c&&!c.fromPage){var d=$(i);d.length&&(s=d[0].f7Page)}(s=c.pageFrom||s)&&s.pageFrom&&(s.pageFrom=null);var u={app:this.app,view:this.view,router:this,$el:l,el:l[0],$pageEl:l,pageEl:l[0],$navbarEl:p,navbarEl:p[0],name:l.attr("data-name"),position:a,from:a,to:r,direction:o,route:c.route?c.route:n,pageFrom:s};return l[0].f7Page=u,u},t.prototype.pageCallback=function(e,t,a,r,n,i,o){if(void 0===i&&(i={}),t){var s=this,l=$(t);if(l.length){var p=$(a),c=i.route,d=s.params.restoreScrollTopOnBack&&!(s.params.masterDetailBreakpoint>0&&l.hasClass("page-master")&&s.app.width>=s.params.masterDetailBreakpoint),u=l[0].f7Page&&l[0].f7Page.route&&l[0].f7Page.route.route&&l[0].f7Page.route.route.keepAlive;"beforeRemove"===e&&u&&(e="beforeUnmount");var h="page"+(e[0].toUpperCase()+e.slice(1,e.length)),f="page:"+e.toLowerCase(),m={};(m="beforeRemove"===e&&l[0].f7Page?Utils.extend(l[0].f7Page,{from:r,to:n,position:r}):s.getPageData(l[0],p[0],r,n,c,o)).swipeBack=!!i.swipeBack;var v=i.route?i.route.route:{},g=v.on;void 0===g&&(g={});var b=v.once;if(void 0===b&&(b={}),i.on&&Utils.extend(g,i.on),i.once&&Utils.extend(b,i.once),"mounted"===e&&C(),"init"===e){if(d&&("previous"===r||!r)&&"current"===n&&s.scrollHistory[m.route.url]&&!l.hasClass("no-restore-scroll")){var y=l.find(".page-content");y.length>0&&(y=y.filter((function(e,t){return 0===$(t).parents(".tab:not(.tab-active)").length&&!$(t).is(".tab:not(.tab-active)")}))),y.scrollTop(s.scrollHistory[m.route.url])}if(C(),l[0].f7PageInitialized)return l.trigger("page:reinit",m),void s.emit("pageReinit",m);l[0].f7PageInitialized=!0}if(d&&"beforeOut"===e&&"current"===r&&"previous"===n){var w=l.find(".page-content");w.length>0&&(w=w.filter((function(e,t){return 0===$(t).parents(".tab:not(.tab-active)").length&&!$(t).is(".tab:not(.tab-active)")}))),s.scrollHistory[m.route.url]=w.scrollTop()}d&&"beforeOut"===e&&"current"===r&&"next"===n&&delete s.scrollHistory[m.route.url],l.trigger(f,m),s.emit(h,m),"beforeRemove"!==e&&"beforeUnmount"!==e||(l[0].f7RouteEventsAttached&&(l[0].f7RouteEventsOn&&Object.keys(l[0].f7RouteEventsOn).forEach((function(e){l.off(Utils.eventNameToColonCase(e),l[0].f7RouteEventsOn[e])})),l[0].f7RouteEventsOnce&&Object.keys(l[0].f7RouteEventsOnce).forEach((function(e){l.off(Utils.eventNameToColonCase(e),l[0].f7RouteEventsOnce[e])})),l[0].f7RouteEventsAttached=null,l[0].f7RouteEventsOn=null,l[0].f7RouteEventsOnce=null,delete l[0].f7RouteEventsAttached,delete l[0].f7RouteEventsOn,delete l[0].f7RouteEventsOnce),u||(l[0].f7Page&&l[0].f7Page.navbarEl&&delete l[0].f7Page.navbarEl.f7Page,l[0].f7Page=null))}}function C(){l[0].f7RouteEventsAttached||(l[0].f7RouteEventsAttached=!0,g&&Object.keys(g).length>0&&(l[0].f7RouteEventsOn=g,Object.keys(g).forEach((function(e){g[e]=g[e].bind(s),l.on(Utils.eventNameToColonCase(e),g[e])}))),b&&Object.keys(b).length>0&&(l[0].f7RouteEventsOnce=b,Object.keys(b).forEach((function(e){b[e]=b[e].bind(s),l.once(Utils.eventNameToColonCase(e),b[e])}))))}},t.prototype.saveHistory=function(){this.view.history=this.history,this.params.pushState&&(win.localStorage["f7router-"+this.view.id+"-history"]=JSON.stringify(this.history))},t.prototype.restoreHistory=function(){this.params.pushState&&win.localStorage["f7router-"+this.view.id+"-history"]&&(this.history=JSON.parse(win.localStorage["f7router-"+this.view.id+"-history"]),this.view.history=this.history)},t.prototype.clearHistory=function(){this.history=[],this.view&&(this.view.history=[]),this.saveHistory()},t.prototype.updateCurrentUrl=function(e){appRouterCheck(this,"updateCurrentUrl"),this.history.length?this.history[this.history.length-1]=e:this.history.push(e);var t=this.parseRouteUrl(e),a=t.query,r=t.hash,n=t.params,i=t.url,o=t.path;if(this.currentRoute&&Utils.extend(this.currentRoute,{query:a,hash:r,params:n,url:i,path:o}),this.params.pushState){var s=this.params.pushStateRoot||"";History.replace(this.view.id,{url:e},s+this.params.pushStateSeparator+e)}this.saveHistory(),this.emit("routeUrlUpdate",this.currentRoute,this)},t.prototype.init=function(){var e=this,t=e.app,a=e.view;(a&&e.params.iosSwipeBack&&"ios"===t.theme||a&&e.params.mdSwipeBack&&"md"===t.theme||a&&e.params.auroraSwipeBack&&"aurora"===t.theme)&&SwipeBack(e);var r,n,i=e.params.url,o=doc.location.href.split(doc.location.origin)[1],s=e.params,l=s.pushState,p=s.pushStateOnLoad,c=s.pushStateSeparator,d=s.pushStateAnimateOnLoad,u=e.params.pushStateRoot;if(win.cordova&&l&&!c&&!u&&doc.location.pathname.indexOf("index.html")&&(console.warn("Framework7: wrong or not complete pushState configuration, trying to guess pushStateRoot"),u=doc.location.pathname.split("index.html")[0]),l&&p?(u&&o.indexOf(u)>=0&&""===(o=o.split(u)[1])&&(o="/"),i=c.length>0&&o.indexOf(c)>=0?o.split(c)[1]:o,e.restoreHistory(),e.history.indexOf(i)>=0?e.history=e.history.slice(0,e.history.indexOf(i)+1):e.params.url===i?e.history=[i]:History.state&&History.state[a.id]&&History.state[a.id].url===e.history[e.history.length-1]?i=e.history[e.history.length-1]:e.history=[o.split(c)[0]||"/",i],e.history.length>1?r=!0:e.history=[],e.saveHistory()):(i||(i=o),doc.location.search&&i.indexOf("?")<0&&(i+=doc.location.search),doc.location.hash&&i.indexOf("#")<0&&(i+=doc.location.hash)),e.history.length>1?(n=e.findMatchingRoute(e.history[0]))||(n=Utils.extend(e.parseRouteUrl(e.history[0]),{route:{url:e.history[0],path:e.history[0].split("?")[0]}})):(n=e.findMatchingRoute(i))||(n=Utils.extend(e.parseRouteUrl(i),{route:{url:i,path:i.split("?")[0]}})),e.params.stackPages&&e.$el.children(".page").each((function(t,a){var r=$(a);e.initialPages.push(r[0]),e.dynamicNavbar&&r.children(".navbar").length>0&&e.initialNavbars.push(r.children(".navbar")[0])})),0===e.$el.children(".page:not(.stacked)").length&&i&&e.params.loadInitialPage)e.navigate(i,{initial:!0,reloadCurrent:!0,pushState:!1});else if(e.$el.children(".page:not(.stacked)").length){var h;e.currentRoute=n,e.$el.children(".page:not(.stacked)").each((function(t,r){var n,i=$(r);e.setPagePosition(i,"current"),e.dynamicNavbar&&((n=i.children(".navbar")).length>0?(e.$navbarsEl.parents(doc).length||e.$el.prepend(e.$navbarsEl),e.setNavbarPosition(n,"current"),e.$navbarsEl.append(n),n.children(".title-large").length&&n.addClass("navbar-large"),i.children(".navbar").remove()):(e.$navbarsEl.addClass("navbar-hidden"),n.children(".title-large").length&&e.$navbarsEl.addClass("navbar-hidden navbar-large-hidden"))),e.currentRoute&&e.currentRoute.route&&e.currentRoute.route.master&&e.params.masterDetailBreakpoint>0&&(i.addClass("page-master"),i.trigger("page:role",{role:"master"}),n&&n.length&&n.addClass("navbar-master"),a.checkMasterDetailBreakpoint());var o={route:e.currentRoute};e.currentRoute&&e.currentRoute.route&&e.currentRoute.route.options&&Utils.extend(o,e.currentRoute.route.options),e.currentPageEl=i[0],e.dynamicNavbar&&n.length&&(e.currentNavbarEl=n[0]),e.removeThemeElements(i),e.dynamicNavbar&&n.length&&e.removeThemeElements(n),o.route.route.tab&&(h=!0,e.tabLoad(o.route.route.tab,Utils.extend({},o))),e.pageCallback("init",i,n,"current",void 0,o)})),r&&e.navigate(i,{initial:!0,pushState:!1,history:!1,animate:d,once:{pageAfterIn:function(){(e.params.preloadPreviousPage||e.params[t.theme+"SwipeBack"])&&e.history.length>2&&e.back({preload:!0})}}}),r||h||(e.history.push(i),e.saveHistory())}!(i&&l&&p)||History.state&&History.state[a.id]||History.initViewState(a.id,{url:i}),e.emit("local::init routerInit",e)},t.prototype.destroy=function(){var e=this;e.emit("local::destroy routerDestroy",e),Object.keys(e).forEach((function(t){e[t]=null,delete e[t]})),e=null},t}(Framework7Class);Router.prototype.forward=forward,Router.prototype.load=load,Router.prototype.navigate=navigate,Router.prototype.refreshPage=refreshPage,Router.prototype.tabLoad=tabLoad,Router.prototype.tabRemove=tabRemove,Router.prototype.modalLoad=modalLoad,Router.prototype.modalRemove=modalRemove,Router.prototype.backward=backward,Router.prototype.loadBack=loadBack,Router.prototype.back=back,Router.prototype.clearPreviousHistory=clearPreviousHistory;var RouterModule={name:"router",static:{Router:Router},instance:{cache:{xhr:[],templates:[],components:[]}},create:function(){this.app?this.params.router&&(this.router=new Router(this.app,this)):this.router=new Router(this)}},View=function(e){function t(t,a,r){void 0===r&&(r={}),e.call(this,r,[t]);var n,i,o,s=t,l=$(a),p=this;if(0===l.length){var c="Framework7: can't create a View instance because ";throw new Error(c+="string"==typeof a?'the selector "'+a+"\" didn't match any element":"el must be an HTMLElement or Dom7 object")}return p.params=Utils.extend({routes:[],routesAdd:[]},s.params.view,r),p.params.routes.length>0?p.routes=p.params.routes:p.routes=[].concat(s.routes,p.params.routesAdd),n="string"==typeof a?a:(l.attr("id")?"#"+l.attr("id"):"")+(l.attr("class")?"."+l.attr("class").replace(/ /g,".").replace(".active",""):""),"ios"===s.theme&&p.params.iosDynamicNavbar&&0===(i=l.children(".navbars").eq(0)).length&&(i=$('<div class="navbars"></div>')),Utils.extend(!1,p,{app:s,$el:l,el:l[0],name:p.params.name,main:p.params.main||l.hasClass("view-main"),$navbarsEl:i,navbarsEl:i?i[0]:void 0,selector:n,history:[],scrollHistory:{}}),l[0].f7View=p,p.useModules(),s.views.push(p),p.main&&(s.views.main=p),p.name&&(s.views[p.name]=p),p.index=s.views.indexOf(p),o=p.name?"view_"+p.name:p.main?"view_main":"view_"+p.index,p.id=o,s.initialized?p.init():s.on("init",(function(){p.init()})),p}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t.prototype.destroy=function(){var e=this,t=e.app;e.$el.trigger("view:beforedestroy"),e.emit("local::beforeDestroy viewBeforeDestroy",e),t.off("resize",e.checkMasterDetailBreakpoint),e.main?(t.views.main=null,delete t.views.main):e.name&&(t.views[e.name]=null,delete t.views[e.name]),e.$el[0].f7View=null,delete e.$el[0].f7View,t.views.splice(t.views.indexOf(e),1),e.params.router&&e.router&&e.router.destroy(),e.emit("local::destroy viewDestroy",e),Object.keys(e).forEach((function(t){e[t]=null,delete e[t]})),e=null},t.prototype.checkMasterDetailBreakpoint=function(e){var t=this.app,a=this.$el.hasClass("view-master-detail"),r=t.width>=this.params.masterDetailBreakpoint&&this.$el.children(".page-master").length;void 0===e&&r||!0===e?(this.$el.addClass("view-master-detail"),a||(this.emit("local::masterDetailBreakpoint viewMasterDetailBreakpoint",this),this.$el.trigger("view:masterDetailBreakpoint"))):(this.$el.removeClass("view-master-detail"),a&&(this.emit("local::masterDetailBreakpoint viewMasterDetailBreakpoint",this),this.$el.trigger("view:masterDetailBreakpoint")))},t.prototype.initMasterDetail=function(){var e=this.app;this.checkMasterDetailBreakpoint=this.checkMasterDetailBreakpoint.bind(this),this.checkMasterDetailBreakpoint(),e.on("resize",this.checkMasterDetailBreakpoint)},t.prototype.init=function(){this.params.router&&(this.params.masterDetailBreakpoint>0&&this.initMasterDetail(),this.router.init(),this.$el.trigger("view:init"),this.emit("local::init viewInit",this))},t}(Framework7Class);function initClicks(e){e.on("click",(function(t){var a=$(t.target),r=a.closest("a"),n=r.length>0,i=n&&r.attr("href");if(n&&(r.is(e.params.clicks.externalLinks)||i&&i.indexOf("javascript:")>=0)){var o=r.attr("target");i&&win.cordova&&win.cordova.InAppBrowser&&("_system"===o||"_blank"===o)&&(t.preventDefault(),win.cordova.InAppBrowser.open(i,o))}else{Object.keys(e.modules).forEach((function(r){var n=e.modules[r].clicks;n&&(t.preventF7Router||Object.keys(n).forEach((function(r){var i=a.closest(r).eq(0);i.length>0&&n[r].call(e,i,i.dataset(),t)})))}));var s={};if(n&&(t.preventDefault(),s=r.dataset()),!t.preventF7Router)if(!r.hasClass("prevent-router")&&!r.hasClass("router-prevent"))if(i&&i.length>0&&"#"!==i[0]||r.hasClass("back")){var l;if(s.view&&"current"===s.view?l=e.views.current:s.view?l=$(s.view)[0].f7View:(l=a.parents(".view")[0]&&a.parents(".view")[0].f7View,!r.hasClass("back")&&l&&l.params.linksView&&("string"==typeof l.params.linksView?l=$(l.params.linksView)[0].f7View:l.params.linksView instanceof View&&(l=l.params.linksView))),l||e.views.main&&(l=e.views.main),!l||!l.router)return;if(s.context&&"string"==typeof s.context)try{s.context=JSON.parse(s.context)}catch(e){}r[0].f7RouteProps&&(s.props=r[0].f7RouteProps),r.hasClass("back")?l.router.back(i,s):l.router.navigate(i,s)}}}))}View.use(RouterModule);var ClicksModule={name:"clicks",params:{clicks:{externalLinks:".external"}},on:{init:function(){initClicks(this)}}},RouterTemplateLoaderModule={name:"routerTemplateLoader",proto:{templateLoader:function(e,t,a,r,n){var i=this;function o(e){var t,o;try{if("function"==typeof(o=a.context||{}))o=o.call(i);else if("string"==typeof o)try{o=JSON.parse(o)}catch(e){throw n(),e}t="function"==typeof e?e(o):Template7.compile(e)(Utils.extend({},o||{},{$app:i.app,$root:Utils.extend({},i.app.data,i.app.methods),$route:a.route,$f7route:a.route,$router:i,$f7router:i,$theme:{ios:"ios"===i.app.theme,md:"md"===i.app.theme,aurora:"aurora"===i.app.theme}}))}catch(e){throw n(),e}r(t,{context:o})}t?(i.xhr&&(i.xhr.abort(),i.xhr=!1),i.xhrRequest(t,a).then((function(e){o(e)})).catch((function(){n()}))):o(e)},modalTemplateLoader:function(e,t,a,r,n){return this.templateLoader(e,t,a,(function(e){r(e)}),n)},tabTemplateLoader:function(e,t,a,r,n){return this.templateLoader(e,t,a,(function(e){r(e)}),n)},pageTemplateLoader:function(e,t,a,r,n){var i=this;return i.templateLoader(e,t,a,(function(e,t){void 0===t&&(t={}),r(i.getPageEl(e),t)}),n)}}},RouterComponentLoaderModule={name:"routerComponentLoader",proto:{componentLoader:function(e,t,a,r,n){void 0===a&&(a={});var i,o=this,s=o.app,l="string"==typeof e?e:t,p=o.replaceRequestUrlParams(l,a);function c(e){var t=a.context||{};if("function"==typeof t)t=t.call(o);else if("string"==typeof t)try{t=JSON.parse(t)}catch(e){throw n(e),e}var i=Utils.merge({},t,{$route:a.route,$f7route:a.route,$router:o,$f7router:o,$theme:{ios:"ios"===s.theme,md:"md"===s.theme,aurora:"aurora"===s.theme}});a.componentOptions&&a.componentOptions.el&&(e.el=a.componentOptions.el),a.componentOptions&&a.componentOptions.root&&(e.root=a.componentOptions.root),s.component.create(e,i).then((function(e){r(e.el)})).catch((function(e){throw n(e),new Error(e)}))}p&&o.params.componentCache&&o.cache.components.forEach((function(e){e.url===p&&(i=e.component)})),p&&i?c(i):p&&!i?(o.xhr&&(o.xhr.abort(),o.xhr=!1),o.xhrRequest(l,a).then((function(e){var t=s.component.parse(e);o.params.componentCache&&o.cache.components.push({url:p,component:t}),c(t)})).catch((function(e){throw n(),e}))):c(e)},modalComponentLoader:function(e,t,a,r,n,i){this.componentLoader(t,a,r,(function(e){n(e)}),i)},tabComponentLoader:function(e,t,a,r,n,i){this.componentLoader(t,a,r,(function(e){n(e)}),i)},pageComponentLoader:function(e,t,a,r,n,i){this.componentLoader(t,a,r,(function(e,t){void 0===t&&(t={}),n(e,t)}),i)}}};function vnode(e,t,a,r,n){return{sel:e,data:t,children:a,text:r,elm:n,key:void 0===t?void 0:t.key}}var array=Array.isArray;function primitive(e){return"string"==typeof e||"number"==typeof e}function addNS(e,t,a){if(e.ns="http://www.w3.org/2000/svg","foreignObject"!==a&&void 0!==t)for(var r=0;r<t.length;++r){var n=t[r].data;void 0!==n&&addNS(n,t[r].children,t[r].sel)}}function h(e,t,a){var r,n,i,o={};if(void 0!==a?(o=t,array(a)?r=a:primitive(a)?n=a:a&&a.sel&&(r=[a])):void 0!==t&&(array(t)?r=t:primitive(t)?n=t:t&&t.sel?r=[t]:o=t),array(r))for(i=0;i<r.length;++i)primitive(r[i])&&(r[i]=vnode(void 0,void 0,void 0,r[i],void 0));return"s"!==e[0]||"v"!==e[1]||"g"!==e[2]||3!==e.length&&"."!==e[3]&&"#"!==e[3]||addNS(o,r,e),vnode(e,o,r,n,void 0)}var customComponents={},selfClosing="area base br col command embed hr img input keygen link menuitem meta param source track wbr".split(" "),propsAttrs="hidden checked disabled readonly selected autofocus autoplay required multiple value indeterminate".split(" "),booleanProps="hidden checked disabled readonly selected autofocus autoplay required multiple readOnly indeterminate".split(" "),tempDomDIV=doc.createElement("div"),tempDomTBODY,tempDomTROW;function toCamelCase$1(e){return e.split("-").map((function(e,t){return 0===t?e.toLowerCase():e[0].toUpperCase()+e.substr(1)})).join("")}function contextFromAttrs(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];var a={};return e.forEach((function(e){void 0===e&&(e={}),Object.keys(e).forEach((function(t){a[toCamelCase$1(t)]=e[t]}))})),a}function createCustomComponent(e){var t=e.app,a=e.vnode,r=e.tagName,n=e.data;t.component.create(Object.assign({el:a.elm},customComponents[r]),{$props:contextFromAttrs(n.attrs||{},n.props||{})},a.children).then((function(e){a.data&&a.data.on&&e&&e.$el&&Object.keys(a.data.on).forEach((function(t){e.$el.on(t,a.data.on[t])})),a.elm.__component__=e}))}function updateCustomComponent(e){var t=e&&e.elm&&e.elm.__component__;if(t){var a=contextFromAttrs(e.data.attrs||{},e.data.props||{});t.$children=e.children,Object.assign(t.$props,a),t.$update()}}function destroyCustomComponent(e){var t=e&&e.elm&&e.elm.__component__;if(t){var a=t.el,r=t.$el;e.data&&e.data.on&&r&&Object.keys(e.data.on).forEach((function(t){r.off(t,e.data.on[t])})),t.$destroy&&t.$destroy(),a&&a.parentNode&&a.parentNode.removeChild(a),delete e.elm.__component__}}function getHooks(e,t,a,r,n){var i={},o=[],s=[],l=[],p=[],c=!1;e&&e.attrs&&e.attrs.component&&(n=e.attrs.component,delete e.attrs.component,c=!0);var d=n&&n.indexOf("-")>0&&customComponents[n];if(d&&(o.push((function(a){(a.sel===n||c)&&createCustomComponent({app:t,vnode:a,tagName:n,data:e})})),s.push((function(e){destroyCustomComponent(e)})),l.push((function(e,t){updateCustomComponent(t)}))),!d){if(!e||!e.attrs||!e.attrs.class)return i;e.attrs.class.split(" ").forEach((function(e){a||o.push.apply(o,t.getVnodeHooks("insert",e)),s.push.apply(s,t.getVnodeHooks("destroy",e)),l.push.apply(l,t.getVnodeHooks("update",e)),p.push.apply(p,t.getVnodeHooks("postpatch",e))}))}return r&&!a&&p.push((function(e,t){var a=t||e;a&&a.data&&a.data.context&&a.data.context.$options.updated&&a.data.context.$hook("updated")})),0===o.length&&0===s.length&&0===l.length&&0===p.length||(o.length&&(i.insert=function(e){o.forEach((function(t){return t(e)}))}),s.length&&(i.destroy=function(e){s.forEach((function(t){return t(e)}))}),l.length&&(i.update=function(e,t){l.forEach((function(a){return a(e,t)}))}),p.length&&(i.postpatch=function(e,t){p.forEach((function(a){return a(e,t)}))})),i}function getEventHandler(e,t,a){void 0===a&&(a={});var r,n,i=a.stop,o=a.prevent,s=a.once,l=!1,p=[],c=!0;if((r=e.indexOf("(")<0?e:e.split("(")[0]).indexOf(".")>=0)r.split(".").forEach((function(e,a){if(0!==a||"this"!==e){if(0===a&&"window"===e)return n=win,void(c=!1);if(n||(n=t),!n[e])throw new Error("Framework7: Component doesn't have method \""+r.split(".").slice(0,a+1).join(".")+'"');n=n[e]}}));else{if(!t[r])throw new Error("Framework7: Component doesn't have method \""+r+'"');n=t[r]}return c&&(n=n.bind(t)),function(){for(var a=[],r=arguments.length;r--;)a[r]=arguments[r];var c=a[0];if(!s||!l){if(i&&c.stopPropagation(),o&&c.preventDefault(),l=!0,e.indexOf("(")<0)p=a;else{var d=e.split("(")[1].split(")")[0].replace(/'[^']*'|"[^"]*"/g,(function(e){return e.replace(/,/g,"<_comma_>")})).split(",").map((function(e){return e.replace(/<_comma_>/g,",")}));d.forEach((function(e){var a=e.trim();if(isNaN(a))if("true"===a)a=!0;else if("false"===a)a=!1;else if("null"===a)a=null;else if("undefined"===a)a=void 0;else if('"'===a[0])a=a.replace(/"/g,"");else if("'"===a[0])a=a.replace(/'/g,"");else if(a.indexOf(".")>0){var r;a.split(".").forEach((function(e){r||(r=t),r=r[e]})),a=r}else a=t[a];else a=parseFloat(a);p.push(a)}))}n.apply(void 0,p)}}}function getData(e,t,a,r,n,i){var o={context:t},s=e.attributes;Array.prototype.forEach.call(s,(function(e){var a=e.name,r=e.value;if(propsAttrs.indexOf(a)>=0)o.props||(o.props={}),"readonly"===a&&(a="readOnly"),booleanProps.indexOf(a)>=0?o.props[a]=!1!==r:o.props[a]=r;else if("key"===a)o.key=r;else if(0===a.indexOf("@")){o.on||(o.on={});var i=a.substr(1),s=!1,l=!1,p=!1;i.indexOf(".")>=0&&i.split(".").forEach((function(e,t){0===t?i=e:("stop"===e&&(s=!0),"prevent"===e&&(l=!0),"once"===e&&(p=!0))})),o.on[i]=getEventHandler(r,t,{stop:s,prevent:l,once:p})}else if("style"===a)if(r.indexOf("{")>=0&&r.indexOf("}")>=0)try{o.style=JSON.parse(r)}catch(e){o.attrs||(o.attrs={}),o.attrs.style=r}else o.attrs||(o.attrs={}),o.attrs.style=r;else o.attrs||(o.attrs={}),o.attrs[a]=r,"id"!==a||o.key||n||(o.key=r)})),n&&t&&t.$id&&t.$style&&t.$styleScoped&&(o.attrs||(o.attrs={}),o.attrs["data-f7-"+t.$id]="");var l=getHooks(o,a,r,n,i);return l.prepatch=function(e,t){e&&t&&e&&e.data&&e.data.props&&Object.keys(e.data.props).forEach((function(a){booleanProps.indexOf(a)<0||(t.data||(t.data={}),t.data.props||(t.data.props={}),!0!==e.data.props[a]||a in t.data.props||(t.data.props[a]=!1))}))},l&&(o.hook=l),o}function getChildren(e,t,a,r){for(var n=[],i=e.childNodes,o=0;o<i.length;o+=1){var s=elementToVNode(i[o],t,a,r);Array.isArray(s)?n.push.apply(n,s):s&&n.push(s)}return n}function getSlots(e,t,a,r){var n=e.getAttribute("name")||"default",i=(t.$children||[]).filter((function(e){var t="default";return e.data&&(t=e.data.attrs&&e.data.attrs.slot||"default"),t===n}));return 0===i.length?getChildren(e,t,a,r):i}function elementToVNode(e,t,a,r,n){if(3===e.nodeType)return e.textContent;if(1!==e.nodeType)return null;var i=e instanceof win.SVGElement?e.nodeName:e.nodeName.toLowerCase();return"slot"===i?getSlots(e,t,a,r):h(i,getData(e,t,a,r,n,i),selfClosing.indexOf(i)>=0?[]:getChildren(e,t,a,r))}function vdom(e,t,a){void 0===e&&(e="");var r,n=e.trim(),i=tempDomDIV;0===n.indexOf("<tr")&&(tempDomTBODY||(tempDomTBODY=doc.createElement("tbody")),i=tempDomTBODY),0!==n.indexOf("<td")&&0!==n.indexOf("<th")||(tempDomTROW||(tempDomTROW=doc.createElement("tr")),i=tempDomTROW),i.innerHTML=n;for(var o=0;o<i.childNodes.length;o+=1)r||1!==i.childNodes[o].nodeType||(r=i.childNodes[o]);var s=elementToVNode(r,t,t.$app,a,!0);return i.innerHTML="",s}function createElement(e){return document.createElement(e)}function createElementNS(e,t){return document.createElementNS(e,t)}function createTextNode(e){return document.createTextNode(e)}function createComment(e){return document.createComment(e)}function insertBefore$1(e,t,a){a&&a.parentNode!==e&&a.__component__&&(a=a.__component__.el),e.insertBefore(t,a)}function removeChild(e,t){e&&e.removeChild(t)}function appendChild(e,t){e.appendChild(t)}function parentNode(e){return e.parentNode}function nextSibling(e){return e.nextSibling}function tagName(e){return e.tagName}function setTextContent(e,t){e.textContent=t}function getTextContent(e){return e.textContent}function isElement(e){return 1===e.nodeType}function isText(e){return 3===e.nodeType}function isComment(e){return 8===e.nodeType}var htmlDomApi={createElement:createElement,createElementNS:createElementNS,createTextNode:createTextNode,createComment:createComment,insertBefore:insertBefore$1,removeChild:removeChild,appendChild:appendChild,parentNode:parentNode,nextSibling:nextSibling,tagName:tagName,setTextContent:setTextContent,getTextContent:getTextContent,isElement:isElement,isText:isText,isComment:isComment};function isUndef(e){return void 0===e}function isDef(e){return void 0!==e}var emptyNode=vnode("",{},[],void 0,void 0);function sameVnode(e,t){return e.key===t.key&&e.sel===t.sel}function isVnode(e){return void 0!==e.sel}function createKeyToOldIdx(e,t,a){var r,n,i,o={};for(r=t;r<=a;++r)null!=(i=e[r])&&void 0!==(n=i.key)&&(o[n]=r);return o}var hooks=["create","update","remove","destroy","pre","post"];function init(e,t){var a,r,n={},i=void 0!==t?t:htmlDomApi;for(a=0;a<hooks.length;++a)for(n[hooks[a]]=[],r=0;r<e.length;++r){var o=e[r][hooks[a]];void 0!==o&&n[hooks[a]].push(o)}function s(e){var t=e.id?"#"+e.id:"",a=e.className?"."+e.className.split(" ").join("."):"";return vnode(i.tagName(e).toLowerCase()+t+a,{},[],void 0,e)}function l(e,t){return function(){if(0==--t){var a=i.parentNode(e);i.removeChild(a,e)}}}function p(e,t){var a,r=e.data;void 0!==r&&isDef(a=r.hook)&&isDef(a=a.init)&&(a(e),r=e.data);var o=e.children,s=e.sel;if("!"===s)isUndef(e.text)&&(e.text=""),e.elm=i.createComment(e.text);else if(void 0!==s){var l=s.indexOf("#"),c=s.indexOf(".",l),d=l>0?l:s.length,u=c>0?c:s.length,h=-1!==l||-1!==c?s.slice(0,Math.min(d,u)):s,f=e.elm=isDef(r)&&isDef(a=r.ns)?i.createElementNS(a,h):i.createElement(h);for(d<u&&f.setAttribute("id",s.slice(d+1,u)),c>0&&f.setAttribute("class",s.slice(u+1).replace(/\./g," ")),a=0;a<n.create.length;++a)n.create[a](emptyNode,e);if(array(o))for(a=0;a<o.length;++a){var m=o[a];null!=m&&i.appendChild(f,p(m,t))}else primitive(e.text)&&i.appendChild(f,i.createTextNode(e.text));isDef(a=e.data.hook)&&(a.create&&a.create(emptyNode,e),a.insert&&t.push(e))}else e.elm=i.createTextNode(e.text);return e.elm}function c(e,t,a,r,n,o){for(;r<=n;++r){var s=a[r];null!=s&&i.insertBefore(e,p(s,o),t)}}function d(e){var t,a,r=e.data;if(void 0!==r){for(isDef(t=r.hook)&&isDef(t=t.destroy)&&t(e),t=0;t<n.destroy.length;++t)n.destroy[t](e);if(void 0!==e.children)for(a=0;a<e.children.length;++a)null!=(t=e.children[a])&&"string"!=typeof t&&d(t)}}function u(e,t,a,r){for(;a<=r;++a){var o=void 0,s=void 0,p=void 0,c=t[a];if(null!=c)if(isDef(c.sel)){for(d(c),s=n.remove.length+1,p=l(c.elm,s),o=0;o<n.remove.length;++o)n.remove[o](c,p);isDef(o=c.data)&&isDef(o=o.hook)&&isDef(o=o.remove)?o(c,p):p()}else i.removeChild(e,c.elm)}}function h(e,t,a){var r,o;isDef(r=t.data)&&isDef(o=r.hook)&&isDef(r=o.prepatch)&&r(e,t);var s=t.elm=e.elm,l=e.children,d=t.children;if(e!==t){if(void 0!==t.data){for(r=0;r<n.update.length;++r)n.update[r](e,t);isDef(r=t.data.hook)&&isDef(r=r.update)&&r(e,t)}isUndef(t.text)?isDef(l)&&isDef(d)?l!==d&&function(e,t,a,r){for(var n,o,s,l=0,d=0,f=t.length-1,m=t[0],v=t[f],g=a.length-1,b=a[0],y=a[g];l<=f&&d<=g;)null==m?m=t[++l]:null==v?v=t[--f]:null==b?b=a[++d]:null==y?y=a[--g]:sameVnode(m,b)?(h(m,b,r),m=t[++l],b=a[++d]):sameVnode(v,y)?(h(v,y,r),v=t[--f],y=a[--g]):sameVnode(m,y)?(h(m,y,r),i.insertBefore(e,m.elm,i.nextSibling(v.elm)),m=t[++l],y=a[--g]):sameVnode(v,b)?(h(v,b,r),i.insertBefore(e,v.elm,m.elm),v=t[--f],b=a[++d]):(void 0===n&&(n=createKeyToOldIdx(t,l,f)),isUndef(o=n[b.key])?(i.insertBefore(e,p(b,r),m.elm),b=a[++d]):((s=t[o]).sel!==b.sel?i.insertBefore(e,p(b,r),m.elm):(h(s,b,r),t[o]=void 0,i.insertBefore(e,s.elm,m.elm)),b=a[++d]));(l<=f||d<=g)&&(l>f?c(e,null==a[g+1]?null:a[g+1].elm,a,d,g,r):u(e,t,l,f))}(s,l,d,a):isDef(d)?(isDef(e.text)&&i.setTextContent(s,""),c(s,null,d,0,d.length-1,a)):isDef(l)?u(s,l,0,l.length-1):isDef(e.text)&&i.setTextContent(s,""):e.text!==t.text&&i.setTextContent(s,t.text),isDef(o)&&isDef(r=o.postpatch)&&r(e,t)}}return function(e,t){var a,r,o,l=[];for(a=0;a<n.pre.length;++a)n.pre[a]();for(isVnode(e)||(e=s(e)),sameVnode(e,t)?h(e,t,l):(r=e.elm,o=i.parentNode(r),p(t,l),null!==o&&(i.insertBefore(o,t.elm,i.nextSibling(r)),u(o,[e],0,0))),a=0;a<l.length;++a)l[a].data.hook.insert(l[a]);for(a=0;a<n.post.length;++a)n.post[a]();return t}}var xlinkNS="http://www.w3.org/1999/xlink",xmlNS="http://www.w3.org/XML/1998/namespace",colonChar=58,xChar=120;function updateAttrs(e,t){var a,r=t.elm,n=e.data.attrs,i=t.data.attrs;if((n||i)&&n!==i){for(a in n=n||{},i=i||{}){var o=i[a];n[a]!==o&&(!0===o?r.setAttribute(a,""):!1===o?r.removeAttribute(a):a.charCodeAt(0)!==xChar?r.setAttribute(a,o):a.charCodeAt(3)===colonChar?r.setAttributeNS(xmlNS,a,o):a.charCodeAt(5)===colonChar?r.setAttributeNS(xlinkNS,a,o):r.setAttribute(a,o))}for(a in n)a in i||r.removeAttribute(a)}}var attributesModule={create:updateAttrs,update:updateAttrs};function updateProps(e,t){var a,r,n=t.elm,i=e.data.props,o=t.data.props;if((i||o)&&i!==o){for(a in o=o||{},i=i||{})o[a]||delete n[a];for(a in o)r=o[a],i[a]===r||"value"===a&&n[a]===r||(n[a]=r)}}var propsModule={create:updateProps,update:updateProps},raf="undefined"!=typeof window&&window.requestAnimationFrame||setTimeout,nextFrame=function(e){raf((function(){raf(e)}))};function setNextFrame(e,t,a){nextFrame((function(){e[t]=a}))}function updateStyle(e,t){var a,r,n=t.elm,i=e.data.style,o=t.data.style;if((i||o)&&i!==o){o=o||{};var s="delayed"in(i=i||{});for(r in i)o[r]||("-"===r[0]&&"-"===r[1]?n.style.removeProperty(r):n.style[r]="");for(r in o)if(a=o[r],"delayed"===r&&o.delayed)for(var l in o.delayed)a=o.delayed[l],s&&a===i.delayed[l]||setNextFrame(n.style,l,a);else"remove"!==r&&a!==i[r]&&("-"===r[0]&&"-"===r[1]?n.style.setProperty(r,a):n.style[r]=a)}}function applyDestroyStyle(e){var t,a,r=e.elm,n=e.data.style;if(n&&(t=n.destroy))for(a in t)r.style[a]=t[a]}function applyRemoveStyle(e,t){var a=e.data.style;if(a&&a.remove){var r,n=e.elm,i=0,o=a.remove,s=0,l=[];for(r in o)l.push(r),n.style[r]=o[r];for(var p=getComputedStyle(n)["transition-property"].split(", ");i<p.length;++i)-1!==l.indexOf(p[i])&&s++;n.addEventListener("transitionend",(function(e){e.target===n&&--s,0===s&&t()}))}else t()}var styleModule={create:updateStyle,update:updateStyle,destroy:applyDestroyStyle,remove:applyRemoveStyle};function invokeHandler(e,t,a){"function"==typeof e&&e.apply(void 0,[t].concat(a))}function handleEvent(e,t,a){var r=e.type,n=a.data.on;n&&n[r]&&invokeHandler(n[r],e,t)}function createListener(){return function e(t){for(var a=[],r=arguments.length-1;r-- >0;)a[r]=arguments[r+1];handleEvent(t,a,e.vnode)}}function updateEvents(e,t){var a=e.data.on,r=e.listener,n=e.elm,i=t&&t.data.on,o=t&&t.elm;if(a!==i&&(a&&r&&(i?Object.keys(a).forEach((function(e){i[e]||$(n).off(e,r)})):Object.keys(a).forEach((function(e){$(n).off(e,r)}))),i)){var s=e.listener||createListener();t.listener=s,s.vnode=t,a?Object.keys(i).forEach((function(e){a[e]||$(o).on(e,s)})):Object.keys(i).forEach((function(e){$(o).on(e,s)}))}}var eventListenersModule={create:updateEvents,update:updateEvents,destroy:updateEvents},patch=init([attributesModule,propsModule,styleModule,eventListenersModule]),componentMixins={},Component=function(e,t,a,r){void 0===t&&(t={}),void 0===a&&(a={});var n=Utils.id(),i=this;Utils.merge(i,{$props:{}},a,{$:$,$$:$,$dom7:$,$app:e,$f7:e,$options:Utils.extend({id:n},t),$id:t.isClassComponent?i.constructor.id:t.id||n,$mixins:t.isClassComponent?i.constructor.mixins:t.mixins,$children:r||[],$isRootComponent:!!t.root});var o=i.$options;if(i.$mixins&&i.$mixins.length)for(var s=i.$mixins.length-1;s>=0;s-=1){var l=i.$mixins[s];"string"==typeof l&&(componentMixins[l]?i.$mixins[s]=componentMixins[l]:i.$mixins.splice(s,1))}Object.defineProperty(i,"$slots",{enumerable:!0,configurable:!0,get:function(){var e={};return i.$children.forEach((function(t){var a="default";t.data&&(a=t.data.attrs&&t.data.attrs.slot||"default"),e[a]||(e[a]=[]),e[a].push(t)})),e}}),Object.defineProperty(i,"$root",{enumerable:!0,configurable:!0,get:function(){if(i.$isRootComponent)return i;if(e.rootComponent)return i.$onRootUpdated||(i.$onRootUpdated=function(){return i.$update()},e.on("rootComponentUpdated",i.$onRootUpdated)),e.rootComponent;var t=Utils.merge({},e.data,e.methods);return win&&win.Proxy&&(t=new win.Proxy(t,{set:function(t,a,r){e.data[a]=r},deleteProperty:function(t,a){delete e.data[a],delete e.methods[a]},has:function(t,a){return a in e.data||a in e.methods}})),t},set:function(){}}),o.render&&(o.render=o.render.bind(i));var p={};return i.$mixins&&i.$mixins.length&&i.$mixins.forEach((function(e){e.methods&&Object.assign(p,e.methods)})),o.methods&&Object.assign(p,o.methods),Object.keys(p).forEach((function(e){i[e]=p[e].bind(i)})),o.on&&Object.keys(o.on).forEach((function(e){o.on[e]=o.on[e].bind(i)})),o.once&&Object.keys(o.once).forEach((function(e){o.once[e]=o.once[e].bind(i)})),i.$style=o.isClassComponent?i.constructor.style:o.style,i.$styleScoped=o.isClassComponent?i.constructor.styleScoped:o.styleScoped,i.__updateQueue=[],new Promise((function(e,t){i.$hook("data",!0).then((function(t){var a={};t.forEach((function(e){Object.assign(a,e||{})})),Utils.extend(i,a),i.$hook("beforeCreate");var r=i.$render();if(i.$options.el)return r=r.trim(),i.$vnode=vdom(r,i,!0),i.$style&&(i.$styleEl=doc.createElement("style"),i.$styleEl.innerHTML=i.$style),i.el=i.$options.el,patch(i.el,i.$vnode),i.el=i.$vnode.elm,i.$el=$(i.el),i.$attachEvents(),i.el.f7Component=i,i.$hook("created"),i.$mount(),void e(i);r&&"string"==typeof r?(r=r.trim(),i.$vnode=vdom(r,i,!0),i.el=doc.createElement(i.$vnode.sel||"div"),patch(i.el,i.$vnode),i.$el=$(i.el)):r&&(i.el=r,i.$el=$(i.el)),i.$style&&(i.$styleEl=doc.createElement("style"),i.$styleEl.innerHTML=i.$style),i.$attachEvents(),i.el&&(i.el.f7Component=i),i.$hook("created"),e(i)})).catch((function(e){t(e)}))}))};function parseComponent(e){var t,a=Utils.id(),r="f7_component_create_callback_"+a,n="f7_component_render_callback_"+a,i=e.match(/<template([ ]?)([a-z0-9-]*)>/),o=i[2]||"t7";i&&(t=e.split(/<template[ ]?[a-z0-9-]*>/).filter((function(e,t){return t>0})).join("<template>").split("</template>").filter((function(e,t,a){return t<a.length-1})).join("</template>").replace(/{{#raw}}([ \n]*)<template/g,"{{#raw}}<template").replace(/\/template>([ \n]*){{\/raw}}/g,"/template>{{/raw}}").replace(/([ \n])<template/g,"$1{{#raw}}<template").replace(/\/template>([ \n])/g,"/template>{{/raw}}$1"));var s,l,p=null,c=!1;if(e.indexOf("<style>")>=0?p=e.split("<style>")[1].split("</style>")[0]:e.indexOf("<style scoped>")>=0&&(c=!0,p=(p=e.split("<style scoped>")[1].split("</style>")[0]).replace(/{{this}}/g,"[data-f7-"+a+"]").replace(/[\n]?([^{^}]*){/gi,(function(e,t){return"\n"+(t=t.split(",").map((function(e){return e.indexOf("@")>=0||e.indexOf("[data-f7-"+a+"]")>=0?e:"[data-f7-"+a+"] "+e.trim()})).join(", "))+" {"}))),e.indexOf("<script>")>=0){var d=e.split("<script>");s=d[d.length-1].split("<\/script>")[0].trim()}else s="return {}";s&&s.trim()||(s="return {}"),s="window."+r+" = function () {"+s+"}",(l=doc.createElement("script")).innerHTML=s,$("head").append(l);var u=win[r](),h="function"==typeof u;if($(l).remove(),win[r]=null,delete win[r],u.template||u.render||(u.template=t,u.templateType=o),u.template){if("t7"===u.templateType)if(h){var f=Template7.compile(u.template);u.prototype.render=function(){return f(this)}}else u.template=Template7.compile(u.template);if("es"===u.templateType){var m="window."+n+" = function () {\n        return function render() {\n          return `"+u.template+"`;\n        }\n      }";(l=doc.createElement("script")).innerHTML=m,$("head").append(l),h?u.prototype.render=u.template:u.render=win[n](),$(l).remove(),win[n]=null,delete win[n]}}return h&&(delete u.template,delete u.templateType),p&&(u.style=p,u.styleScoped=c),u.id=a,u}function registerComponentMixin(e,t){componentMixins[e]=t}function registerComponent(e,t){customComponents[e]=t}Component.prototype.$attachEvents=function(){var e=this,t=e.$options,a=e.$el;e.$mixins&&e.$mixins.length&&(e.$detachEventsHandlers={},e.$mixins.forEach((function(t){t.on&&Object.keys(t.on).forEach((function(r){var n=t.on[r].bind(e);e.$detachEventsHandlers[r]||(e.$detachEventsHandlers[r]=[]),e.$detachEventsHandlers[r].push(n),a.on(Utils.eventNameToColonCase(r),n)})),t.once&&Object.keys(t.once).forEach((function(r){var n=t.once[r].bind(e);e.$detachEventsHandlers[r]||(e.$detachEventsHandlers[r]=[]),e.$detachEventsHandlers[r].push(n),a.once(Utils.eventNameToColonCase(r),n)}))}))),t.on&&Object.keys(t.on).forEach((function(e){a.on(Utils.eventNameToColonCase(e),t.on[e])})),t.once&&Object.keys(t.once).forEach((function(e){a.once(Utils.eventNameToColonCase(e),t.once[e])}))},Component.prototype.$detachEvents=function(){var e=this,t=e.$options,a=e.$el;t.on&&Object.keys(t.on).forEach((function(e){a.off(Utils.eventNameToColonCase(e),t.on[e])})),t.once&&Object.keys(t.once).forEach((function(e){a.off(Utils.eventNameToColonCase(e),t.once[e])})),e.$detachEventsHandlers&&(Object.keys(e.$detachEventsHandlers).forEach((function(t){e.$detachEventsHandlers[t].forEach((function(e){a.off(Utils.eventNameToColonCase(t),e)})),e.$detachEventsHandlers[t]=[],delete e.$detachEventsHandlers[t]})),e.$detachEventsHandlers=null,delete e.$detachEventsHandlers)},Component.prototype.$render=function(){var e=this.$options,t="";return e.render?t=e.render():this.render?t=this.render.call(this):e.template&&(t="string"==typeof e.template?Template7.compile(e.template)(this):e.template(this)),t},Component.prototype.$startUpdateQueue=function(){var e=this;e.__requestAnimationFrameId||(e.__requestAnimationFrameId=win.requestAnimationFrame((function(){e.__updateIsPending&&function(){var t=e.$render();if(t&&"string"==typeof t){var a=vdom(t=t.trim(),e,!1);e.$vnode=patch(e.$vnode,a)}}();var t=[].concat(e.__updateQueue);e.__updateQueue=[],e.__updateIsPending=!1,win.cancelAnimationFrame(e.__requestAnimationFrameId),delete e.__requestAnimationFrameId,delete e.__updateIsPending,t.forEach((function(e){return e()})),t=[]})))},Component.prototype.$tick=function(e){var t=this;return new Promise((function(a){t.__updateQueue.push((function(){a(),e&&e()})),t.$startUpdateQueue()}))},Component.prototype.$update=function(e){var t=this;return new Promise((function(a){t.__updateIsPending=!0,t.__updateQueue.push((function(){a(),e&&e(),t.$isRootComponent&&t.$f7.emit("rootComponentUpdated")})),t.$startUpdateQueue()}))},Component.prototype.$setState=function(e,t){void 0===e&&(e={});return Utils.merge(this,e),this.$update(t)},Component.prototype.$f7ready=function(e){var t=this;this.$f7.initialized?e(this.$f7):this.$f7.once("init",(function(){e(t.$f7)}))},Component.prototype.$mount=function(e){this.$hook("beforeMount"),this.$styleEl&&$("head").append(this.$styleEl),e&&e(this.el),this.$hook("mounted")},Component.prototype.$destroy=function(){this.$hook("beforeDestroy"),this.$styleEl&&$(this.$styleEl).remove(),this.$onRootUpdated&&(this.$f7.off("rootComponentUpdated",this.$onRootUpdated),delete this.$onRootUpdated),this.$detachEvents(),this.$hook("destroyed"),this.el&&this.el.f7Component&&(this.el.f7Component=null,delete this.el.f7Component),this.$vnode&&(this.$vnode=patch(this.$vnode,{sel:this.$vnode.sel,data:{}})),win.cancelAnimationFrame(this.__requestAnimationFrameId),Utils.deleteProps(this)},Component.prototype.$hook=function(e,t){var a=this;if(t){var r=[];return a.$mixins&&a.$mixins.length&&a.$mixins.forEach((function(t){t[e]&&r.push(t[e].call(a))})),a[e]&&"function"==typeof a[e]&&r.push(a[e].call(a)),a.$options[e]&&r.push(a.$options[e].call(a)),Promise.all(r)}return a.$mixins&&a.$mixins.length&&a.$mixins.forEach((function(t){t[e]&&"function"==typeof t[e]&&t[e].call(a)})),a.$options[e]?a.$options[e].call(a):a[e]?a[e].call(a):void 0};var ComponentModule={name:"component",static:{Component:Component,registerComponentMixin:registerComponentMixin,registerComponent:registerComponent},create:function(){var e=this;e.component={registerComponentMixin:registerComponentMixin,registerComponent:registerComponent,parse:function(e){return parseComponent(e)},create:function(t,a,r){return"function"==typeof t?new t(e,{isClassComponent:!0},a,r):new Component(e,t,a,r)}}}},HistoryModule={name:"history",static:{history:History},on:{init:function(){History.init(this)}}},SW={registrations:[],register:function(e,t){var a=this;return"serviceWorker"in win.navigator&&a.serviceWorker.container?new Promise((function(r,n){a.serviceWorker.container.register(e,t?{scope:t}:{}).then((function(e){SW.registrations.push(e),a.emit("serviceWorkerRegisterSuccess",e),r(e)})).catch((function(e){a.emit("serviceWorkerRegisterError",e),n(e)}))})):new Promise((function(e,t){t(new Error("Service worker is not supported"))}))},unregister:function(e){var t,a=this;return"serviceWorker"in win.navigator&&a.serviceWorker.container?(t=e?Array.isArray(e)?e:[e]:SW.registrations,Promise.all(t.map((function(e){return new Promise((function(t,r){e.unregister().then((function(){SW.registrations.indexOf(e)>=0&&SW.registrations.splice(SW.registrations.indexOf(e),1),a.emit("serviceWorkerUnregisterSuccess",e),t()})).catch((function(t){a.emit("serviceWorkerUnregisterError",e,t),r(t)}))}))})))):new Promise((function(e,t){t(new Error("Service worker is not supported"))}))}},ServiceWorkerModule={name:"sw",params:{serviceWorker:{path:void 0,scope:void 0}},create:function(){Utils.extend(this,{serviceWorker:{container:"serviceWorker"in win.navigator?win.navigator.serviceWorker:void 0,registrations:SW.registrations,register:SW.register.bind(this),unregister:SW.unregister.bind(this)}})},on:{init:function(){if("serviceWorker"in win.navigator){var e=this;if(e.serviceWorker.container){var t=e.params.serviceWorker.path,a=e.params.serviceWorker.scope;if(t&&(!Array.isArray(t)||t.length))(Array.isArray(t)?t:[t]).forEach((function(t){e.serviceWorker.register(t,a)}))}}}}},Statusbar={hide:function(){Device.cordova&&win.StatusBar&&win.StatusBar.hide()},show:function(){Device.cordova&&win.StatusBar&&win.StatusBar.show()},onClick:function(){var e;(e=$(".popup.modal-in").length>0?$(".popup.modal-in").find(".page:not(.page-previous):not(.page-next):not(.cached)").find(".page-content"):$(".panel.panel-in").length>0?$(".panel.panel-in").find(".page:not(.page-previous):not(.page-next):not(.cached)").find(".page-content"):$(".views > .view.tab-active").length>0?$(".views > .view.tab-active").find(".page:not(.page-previous):not(.page-next):not(.cached)").find(".page-content"):$(".views").length>0?$(".views").find(".page:not(.page-previous):not(.page-next):not(.cached)").find(".page-content"):this.root.children(".view").find(".page:not(.page-previous):not(.page-next):not(.cached)").find(".page-content"))&&e.length>0&&(e.hasClass("tab")&&(e=e.parent(".tabs").children(".page-content.tab-active")),e.length>0&&e.scrollTop(0,300))},setTextColor:function(e){Device.cordova&&win.StatusBar&&("white"===e?win.StatusBar.styleLightContent():win.StatusBar.styleDefault())},setBackgroundColor:function(e){Device.cordova&&win.StatusBar&&win.StatusBar.backgroundColorByHexString(e)},isVisible:function(){return!(!Device.cordova||!win.StatusBar)&&win.StatusBar.isVisible},overlaysWebView:function(e){void 0===e&&(e=!0),Device.cordova&&win.StatusBar&&win.StatusBar.overlaysWebView(e)},init:function(){var e=this.params.statusbar;e.enabled&&(Device.cordova&&win.StatusBar&&(e.scrollTopOnClick&&$(win).on("statusTap",Statusbar.onClick.bind(this)),Device.ios&&(e.iosOverlaysWebView?win.StatusBar.overlaysWebView(!0):win.StatusBar.overlaysWebView(!1),"white"===e.iosTextColor?win.StatusBar.styleLightContent():win.StatusBar.styleDefault()),Device.android&&(e.androidOverlaysWebView?win.StatusBar.overlaysWebView(!0):win.StatusBar.overlaysWebView(!1),"white"===e.androidTextColor?win.StatusBar.styleLightContent():win.StatusBar.styleDefault())),e.iosBackgroundColor&&Device.ios&&Statusbar.setBackgroundColor(e.iosBackgroundColor),e.androidBackgroundColor&&Device.android&&Statusbar.setBackgroundColor(e.androidBackgroundColor))}},Statusbar$1={name:"statusbar",params:{statusbar:{enabled:!0,scrollTopOnClick:!0,iosOverlaysWebView:!0,iosTextColor:"black",iosBackgroundColor:null,androidOverlaysWebView:!1,androidTextColor:"black",androidBackgroundColor:null}},create:function(){Utils.extend(this,{statusbar:{hide:Statusbar.hide,show:Statusbar.show,overlaysWebView:Statusbar.overlaysWebView,setTextColor:Statusbar.setTextColor,setBackgroundColor:Statusbar.setBackgroundColor,isVisible:Statusbar.isVisible,init:Statusbar.init.bind(this)}})},on:{init:function(){Statusbar.init.call(this)}}};function getCurrentView(e){var t=$(".popover.modal-in .view"),a=$(".popup.modal-in .view"),r=$(".panel.panel-in .view"),n=$(".views");0===n.length&&(n=e.root);var i=n.children(".view");if(i.length>1&&i.hasClass("tab")&&(i=n.children(".view.tab-active")),t.length>0&&t[0].f7View)return t[0].f7View;if(a.length>0&&a[0].f7View)return a[0].f7View;if(r.length>0&&r[0].f7View)return r[0].f7View;if(i.length>0){if(1===i.length&&i[0].f7View)return i[0].f7View;if(i.length>1)return e.views.main}}var View$1={name:"view",params:{view:{name:void 0,main:!1,router:!0,linksView:null,stackPages:!1,xhrCache:!0,xhrCacheIgnore:[],xhrCacheIgnoreGetParameters:!1,xhrCacheDuration:6e5,componentCache:!0,preloadPreviousPage:!0,allowDuplicateUrls:!1,reloadPages:!1,reloadDetail:!1,masterDetailBreakpoint:0,removeElements:!0,removeElementsWithTimeout:!1,removeElementsTimeout:0,restoreScrollTopOnBack:!0,unloadTabContent:!0,passRouteQueryToRequest:!0,passRouteParamsToRequest:!1,loadInitialPage:!0,iosSwipeBack:!0,iosSwipeBackAnimateShadow:!0,iosSwipeBackAnimateOpacity:!0,iosSwipeBackActiveArea:30,iosSwipeBackThreshold:0,mdSwipeBack:!1,mdSwipeBackAnimateShadow:!0,mdSwipeBackAnimateOpacity:!1,mdSwipeBackActiveArea:30,mdSwipeBackThreshold:0,auroraSwipeBack:!1,auroraSwipeBackAnimateShadow:!1,auroraSwipeBackAnimateOpacity:!0,auroraSwipeBackActiveArea:30,auroraSwipeBackThreshold:0,pushState:!1,pushStateRoot:void 0,pushStateAnimate:!0,pushStateAnimateOnLoad:!1,pushStateSeparator:"#!",pushStateOnLoad:!0,animate:!0,iosDynamicNavbar:!0,iosAnimateNavbarBackIcon:!0,iosPageLoadDelay:0,mdPageLoadDelay:0,auroraPageLoadDelay:0,routesBeforeEnter:null,routesBeforeLeave:null}},static:{View:View},create:function(){var e=this;Utils.extend(e,{views:Utils.extend([],{create:function(t,a){return new View(e,t,a)},get:function(e){var t=$(e);if(t.length&&t[0].f7View)return t[0].f7View}})}),Object.defineProperty(e.views,"current",{enumerable:!0,configurable:!0,get:function(){return getCurrentView(e)}}),e.view=e.views},on:{init:function(){var e=this;$(".view-init").each((function(t,a){if(!a.f7View){var r=$(a).dataset();e.views.create(a,r)}}))},modalOpen:function(e){var t=this;e.$el.find(".view-init").each((function(e,a){if(!a.f7View){var r=$(a).dataset();t.views.create(a,r)}}))},modalBeforeDestroy:function(e){e&&e.$el&&e.$el.find(".view-init").each((function(e,t){var a=t.f7View;a&&a.destroy()}))}},vnode:{"view-init":{insert:function(e){var t=e.elm;if(!t.f7View){var a=$(t).dataset();this.views.create(t,a)}},destroy:function(e){var t=e.elm.f7View;t&&t.destroy()}}}},Navbar={size:function(e){var t=this,a=$(e);if(a.hasClass("navbars"))a=a.children(".navbar").each((function(e,a){t.navbar.size(a)}));else{var r=a.children(".navbar-inner");if(r.length){var n=r.hasClass("navbar-inner-centered-title")||t.params.navbar[t.theme+"CenterTitle"],i="ios"===t.theme&&!t.params.navbar[t.theme+"CenterTitle"];if((n||i)&&!(a.hasClass("stacked")||a.parents(".stacked").length>0||a.parents(".tab:not(.tab-active)").length>0||a.parents(".popup:not(.modal-in)").length>0)){"ios"!==t.theme&&t.params.navbar[t.theme+"CenterTitle"]&&r.addClass("navbar-inner-centered-title"),"ios"!==t.theme||t.params.navbar.iosCenterTitle||r.addClass("navbar-inner-left-title");var o,s,l,p,c=a.parents(".view").eq(0),d=t.rtl?r.children(".right"):r.children(".left"),u=t.rtl?r.children(".left"):r.children(".right"),h=r.children(".title"),f=r.children(".subnavbar"),m=0===d.length,v=0===u.length,g=m?0:d.outerWidth(!0),b=v?0:u.outerWidth(!0),y=h.outerWidth(!0),w=r.styles(),C=r[0].offsetWidth-parseInt(w.paddingLeft,10)-parseInt(w.paddingRight,10),x=a.hasClass("navbar-previous"),k=r.hasClass("sliding");c.length>0&&c[0].f7View&&(s=(o=c[0].f7View.router)&&o.dynamicNavbar),v&&(l=C-y),m&&(l=0),m||v||(l=(C-b-y+g)/2);var E=(C-y)/2;C-g-b>y?(E<g&&(E=g),E+y>C-b&&(E=C-b-y),p=E-l):p=0;var T=t.rtl?-1:1;if(s&&"ios"===t.theme){if(h.hasClass("sliding")||h.length>0&&k){var S=-(l+p)*T,M=(C-l-p-y)*T;if(x&&o&&o.params.iosAnimateNavbarBackIcon){var P=a.parent().find(".navbar-current").children(".left.sliding").find(".back .icon ~ span");P.length>0&&(S+=P[0].offsetLeft)}h[0].f7NavbarLeftOffset=S,h[0].f7NavbarRightOffset=M}if(!m&&(d.hasClass("sliding")||k))if(t.rtl)d[0].f7NavbarLeftOffset=-(C-d[0].offsetWidth)/2*T,d[0].f7NavbarRightOffset=g*T;else if(d[0].f7NavbarLeftOffset=-g,d[0].f7NavbarRightOffset=(C-d[0].offsetWidth)/2,o&&o.params.iosAnimateNavbarBackIcon&&d.find(".back .icon").length>0&&d.find(".back .icon ~ span").length){var O=d[0].f7NavbarLeftOffset,D=d[0].f7NavbarRightOffset;d[0].f7NavbarLeftOffset=0,d[0].f7NavbarRightOffset=0,d.find(".back .icon ~ span")[0].f7NavbarLeftOffset=O,d.find(".back .icon ~ span")[0].f7NavbarRightOffset=D-d.find(".back .icon")[0].offsetWidth}v||!u.hasClass("sliding")&&!k||(t.rtl?(u[0].f7NavbarLeftOffset=-b*T,u[0].f7NavbarRightOffset=(C-u[0].offsetWidth)/2*T):(u[0].f7NavbarLeftOffset=-(C-u[0].offsetWidth)/2,u[0].f7NavbarRightOffset=b)),f.length&&(f.hasClass("sliding")||k)&&(f[0].f7NavbarLeftOffset=t.rtl?f[0].offsetWidth:-f[0].offsetWidth,f[0].f7NavbarRightOffset=-f[0].f7NavbarLeftOffset)}if(n){var I=p;t.rtl&&m&&v&&h.length>0&&(I=-I),h.css({left:I+"px"})}}}}},hide:function(e,t,a){void 0===t&&(t=!0),void 0===a&&(a=!1);var r=this,n=$(e),i=n.hasClass("navbar")&&n.parent(".navbars").length;if(i&&(n=n.parents(".navbars")),n.length&&!n.hasClass("navbar-hidden")){var o="navbar-hidden"+(t?" navbar-transitioning":"");(i?n.find(".navbar-current .title-large").length:n.find(".title-large").length)&&(o+=" navbar-large-hidden"),a&&(o+=" navbar-hidden-statusbar"),n.transitionEnd((function(){n.removeClass("navbar-transitioning")})),n.addClass(o),i?n.children(".navbar").each((function(e,t){$(t).trigger("navbar:hide"),r.emit("navbarHide",t)})):(n.trigger("navbar:hide"),r.emit("navbarHide",n[0]))}},show:function(e,t){void 0===e&&(e=".navbar-hidden"),void 0===t&&(t=!0);var a=this,r=$(e),n=r.hasClass("navbar")&&r.parent(".navbars").length;n&&(r=r.parents(".navbars")),r.length&&r.hasClass("navbar-hidden")&&(t&&(r.addClass("navbar-transitioning"),r.transitionEnd((function(){r.removeClass("navbar-transitioning")}))),r.removeClass("navbar-hidden navbar-large-hidden navbar-hidden-statusbar"),n?r.children(".navbar").each((function(e,t){$(t).trigger("navbar:show"),a.emit("navbarShow",t)})):(r.trigger("navbar:show"),a.emit("navbarShow",r[0])))},getElByPage:function(e){var t,a,r;if(e.$navbarEl||e.$el?(r=e,t=e.$el):(t=$(e)).length>0&&(r=t[0].f7Page),r&&r.$navbarEl&&r.$navbarEl.length>0?a=r.$navbarEl:t&&(a=t.children(".navbar")),a&&(!a||0!==a.length))return a[0]},getPageByEl:function(e){var t,a=$(e);return a.parents(".page").length?a.parents(".page")[0]:(a.parents(".view").find(".page").each((function(e,r){r&&r.f7Page&&r.f7Page.navbarEl&&a[0]===r.f7Page.navbarEl&&(t=r)})),t)},collapseLargeTitle:function(e){var t=$(e);if(!(t.hasClass("navbars")&&((t=t.find(".navbar")).length>1&&(t=$(e).find(".navbar-large.navbar-current")),t.length>1||!t.length))){var a=$(this.navbar.getPageByEl(t));t.addClass("navbar-large-collapsed"),a.eq(0).addClass("page-with-navbar-large-collapsed").trigger("page:navbarlargecollapsed"),this.emit("pageNavbarLargeCollapsed",a[0]),t.trigger("navbar:collapse"),this.emit("navbarCollapse",t[0])}},expandLargeTitle:function(e){var t=$(e);if(!(t.hasClass("navbars")&&((t=t.find(".navbar-large")).length>1&&(t=$(e).find(".navbar-large.navbar-current")),t.length>1||!t.length))){var a=$(this.navbar.getPageByEl(t));t.removeClass("navbar-large-collapsed"),a.eq(0).removeClass("page-with-navbar-large-collapsed").trigger("page:navbarlargeexpanded"),this.emit("pageNavbarLargeExpanded",a[0]),t.trigger("navbar:expand"),this.emit("navbarExpand",t[0])}},toggleLargeTitle:function(e){var t=$(e);t.hasClass("navbars")&&((t=t.find(".navbar-large")).length>1&&(t=$(e).find(".navbar-large.navbar-current")),t.length>1||!t.length)||(t.hasClass("navbar-large-collapsed")?this.navbar.expandLargeTitle(t):this.navbar.collapseLargeTitle(t))},initNavbarOnScroll:function(e,t,a,r,n){var i,o,s,l,p,c,d,u,h,f,m,v,g,b,y=this,w=$(e),C=$(t),x=C.find(".title-large"),k=x.length||C.hasClass(".navbar-large"),E=44,T=y.params.navbar.snapPageScrollToLargeTitle,S=y.params.navbar.snapPageScrollToTransparentNavbar;(r||a&&k)&&((h=C.css("--f7-navbar-large-title-height"))&&h.indexOf("px")>=0?(h=parseInt(h,10),Number.isNaN(h)&&x.length?h=x[0].offsetHeight:Number.isNaN(h)&&("ios"===y.theme?h=52:"md"===y.theme?h=48:"aurora"===y.theme&&(h=38))):x.length?h=x[0].offsetHeight:"ios"===y.theme?h=52:"md"===y.theme?h=48:"aurora"===y.theme&&(h=38)),a&&k&&(E+=h);function M(){C.hasClass("with-searchbar-expandable-enabled")||!v||o<0||(o>=h/2&&o<h?$(v).scrollTop(h,100):o<h&&$(v).scrollTop(0,200))}function P(){C.hasClass("with-searchbar-expandable-enabled")||!v||o<0||(o>=f/2&&o<f?$(v).scrollTop(f,100):o<f&&$(v).scrollTop(0,200))}var O=null,D=null;function I(e){v=this,e&&e.target&&e.target!==v||(o=v.scrollTop,m=o,r?function(){if(!(C.hasClass("navbar-hidden")||C.parent(".navbars").hasClass("navbar-hidden"))){var e=C.hasClass("navbar-large-transparent")||C.hasClass("navbar-large")&&C.hasClass("navbar-transparent");O=D,D=Math.min(Math.max(o/h,0),1);var t=O>0&&O<1;C.hasClass("with-searchbar-expandable-enabled")||(u=C.hasClass("navbar-large-collapsed"),0===D&&u?y.navbar.expandLargeTitle(C[0]):1!==D||u||y.navbar.collapseLargeTitle(C[0]),0===D&&u||0===D&&t||1===D&&!u||1===D&&t?("md"===y.theme&&C.find(".navbar-inner").css("overflow",""),C.find(".title").css("opacity",""),C.find(".title-large-text, .subnavbar").css("transform",""),e?C.find(".navbar-bg").css("opacity",""):C.find(".navbar-bg").css("transform","")):D>0&&D<1&&("md"===y.theme&&C.find(".navbar-inner").css("overflow","visible"),C.find(".title").css("opacity",D),C.find(".title-large-text, .subnavbar").css("transform","translate3d(0px, "+-1*D*h+"px, 0)"),e?C.find(".navbar-bg").css("opacity",D):C.find(".navbar-bg").css("transform","translate3d(0px, "+-1*D*h+"px, 0)")),T&&(Support.touch?b&&(clearTimeout(b),b=null,b=setTimeout((function(){M(),clearTimeout(b),b=null}),70)):(clearTimeout(g),g=setTimeout((function(){M()}),300))))}}():n&&function(){var e=C.hasClass("navbar-hidden")||C.parent(".navbars").hasClass("navbar-hidden");if(!C.hasClass("with-searchbar-expandable-enabled")&&!e){f||(f=t.offsetHeight);var a=o/f,r=C.hasClass("navbar-transparent-visible");if(a=Math.max(Math.min(a,1),0),r&&1===a||!r&&0===a)C.find(".navbar-bg, .title").css("opacity","");else{if(r&&0===a)return C.trigger("navbar:transparenthide"),y.emit("navbarTransparentHide",C[0]),C.removeClass("navbar-transparent-visible"),void C.find(".navbar-bg, .title").css("opacity","");if(!r&&1===a)return C.trigger("navbar:transparentshow"),y.emit("navbarTransparentShow",C[0]),C.addClass("navbar-transparent-visible"),void C.find(".navbar-bg, .title").css("opacity","");C.find(".navbar-bg, .title").css("opacity",a),S&&(Support.touch?b&&(clearTimeout(b),b=null,b=setTimeout((function(){P(),clearTimeout(b),b=null}),70)):(clearTimeout(g),g=setTimeout((function(){P()}),300)))}}}(),w.hasClass("page-previous")||a&&(s=v.scrollHeight,l=v.offsetHeight,p=o+l>=s,d=C.hasClass("navbar-hidden")||C.parent(".navbars").hasClass("navbar-hidden"),p?y.params.navbar.showOnPageScrollEnd&&(c="show"):c=i>o?y.params.navbar.showOnPageScrollTop||o<=E?"show":"hide":o>E?"hide":"show","show"===c&&d?(y.navbar.show(C),d=!1):"hide"!==c||d||(y.navbar.hide(C),d=!0),i=o))}function B(){m=!1}function R(){clearTimeout(b),b=null,b=setTimeout((function(){!1!==m&&(n&&!r?P():M(),clearTimeout(b),b=null)}),70)}w.on("scroll",".page-content",I,!0),Support.touch&&(r&&T||n&&S)&&(y.on("touchstart:passive",B),y.on("touchend:passive",R)),(r||n)&&w.find(".page-content").each((function(e,t){t.scrollTop>0&&I.call(t)})),w[0].f7DetachNavbarScrollHandlers=function(){delete w[0].f7DetachNavbarScrollHandlers,w.off("scroll",".page-content",I,!0),Support.touch&&(r&&T||n&&S)&&(y.off("touchstart:passive",B),y.off("touchend:passive",R))}}},Navbar$1={name:"navbar",create:function(){var e=this;Utils.extend(e,{navbar:{size:Navbar.size.bind(e),hide:Navbar.hide.bind(e),show:Navbar.show.bind(e),getElByPage:Navbar.getElByPage.bind(e),getPageByEl:Navbar.getPageByEl.bind(e),collapseLargeTitle:Navbar.collapseLargeTitle.bind(e),expandLargeTitle:Navbar.expandLargeTitle.bind(e),toggleLargeTitle:Navbar.toggleLargeTitle.bind(e),initNavbarOnScroll:Navbar.initNavbarOnScroll.bind(e)}})},params:{navbar:{scrollTopOnTitleClick:!0,iosCenterTitle:!0,mdCenterTitle:!1,auroraCenterTitle:!0,hideOnPageScroll:!1,showOnPageScrollEnd:!0,showOnPageScrollTop:!0,collapseLargeTitleOnScroll:!0,snapPageScrollToLargeTitle:!0,snapPageScrollToTransparentNavbar:!0}},on:{"panelBreakpoint panelCollapsedBreakpoint panelResize resize viewMasterDetailBreakpoint":function(){var e=this;$(".navbar").each((function(t,a){e.navbar.size(a)}))},pageBeforeRemove:function(e){e.$el[0].f7DetachNavbarScrollHandlers&&e.$el[0].f7DetachNavbarScrollHandlers()},pageBeforeIn:function(e){if("ios"===this.theme){var t,a=e.$el.parents(".view")[0].f7View,r=this.navbar.getElByPage(e);if(t=r?$(r).parents(".navbars"):e.$el.parents(".view").children(".navbars"),e.$el.hasClass("no-navbar")||a.router.dynamicNavbar&&!r){var n=!!(e.pageFrom&&e.router.history.length>0);this.navbar.hide(t,n)}else this.navbar.show(t)}},pageReinit:function(e){var t=$(this.navbar.getElByPage(e));t&&0!==t.length&&this.navbar.size(t)},pageInit:function(e){var t,a,r,n=$(this.navbar.getElByPage(e));n&&0!==n.length&&(this.navbar.size(n),n.find(".title-large").length>0&&n.addClass("navbar-large"),n.hasClass("navbar-large")&&(this.params.navbar.collapseLargeTitleOnScroll&&(t=!0),e.$el.addClass("page-with-navbar-large")),!t&&n.hasClass("navbar-transparent")&&(a=!0),(this.params.navbar.hideOnPageScroll||e.$el.find(".hide-navbar-on-scroll").length||e.$el.hasClass("hide-navbar-on-scroll")||e.$el.find(".hide-bars-on-scroll").length||e.$el.hasClass("hide-bars-on-scroll"))&&(r=!(e.$el.find(".keep-navbar-on-scroll").length||e.$el.hasClass("keep-navbar-on-scroll")||e.$el.find(".keep-bars-on-scroll").length||e.$el.hasClass("keep-bars-on-scroll"))),(t||r||a)&&this.navbar.initNavbarOnScroll(e.el,n[0],r,t,a))},"panelOpen panelSwipeOpen modalOpen":function(e){var t=this;e.$el.find(".navbar:not(.navbar-previous):not(.stacked)").each((function(e,a){t.navbar.size(a)}))},tabShow:function(e){var t=this;$(e).find(".navbar:not(.navbar-previous):not(.stacked)").each((function(e,a){t.navbar.size(a)}))}},clicks:{".navbar .title":function(e){if(this.params.navbar.scrollTopOnTitleClick&&!(e.closest("a").length>0)){var t,a=e.parents(".navbar"),r=a.parents(".navbars");0===(t=a.parents(".page-content")).length&&(a.parents(".page").length>0&&(t=a.parents(".page").find(".page-content")),0===t.length&&r.length&&r.nextAll(".page-current:not(.stacked)").length>0&&(t=r.nextAll(".page-current:not(.stacked)").find(".page-content")),0===t.length&&a.nextAll(".page-current:not(.stacked)").length>0&&(t=a.nextAll(".page-current:not(.stacked)").find(".page-content"))),t&&t.length>0&&(t.hasClass("tab")&&(t=t.parent(".tabs").children(".page-content.tab-active")),t.length>0&&t.scrollTop(0,300))}}},vnode:{navbar:{postpatch:function(e){this.navbar.size(e.elm)}}}},Toolbar={setHighlight:function(e){if("md"===this.theme){var t=$(e);if(0!==t.length&&(t.hasClass("tabbar")||t.hasClass("tabbar-labels"))){var a=t.find(".tab-link-highlight"),r=t.find(".tab-link").length;if(0!==r){0===a.length?(t.children(".toolbar-inner").append('<span class="tab-link-highlight"></span>'),a=t.find(".tab-link-highlight")):a.next().length&&t.children(".toolbar-inner").append(a);var n,i,o=t.find(".tab-link-active");if(t.hasClass("tabbar-scrollable")&&o&&o[0])n=o[0].offsetWidth+"px",i=o[0].offsetLeft+"px";else{var s=o.index();n=100/r+"%",i=100*(this.rtl?-s:s)+"%"}Utils.nextFrame((function(){a.css("width",n).transform("translate3d("+i+",0,0)")}))}else a.remove()}}},init:function(e){this.toolbar.setHighlight(e)},hide:function(e,t){void 0===t&&(t=!0);var a=$(e);if(!a.hasClass("toolbar-hidden")){var r="toolbar-hidden"+(t?" toolbar-transitioning":"");a.transitionEnd((function(){a.removeClass("toolbar-transitioning")})),a.addClass(r),a.trigger("toolbar:hide"),this.emit("toolbarHide",a[0])}},show:function(e,t){void 0===t&&(t=!0);var a=$(e);a.hasClass("toolbar-hidden")&&(t&&(a.addClass("toolbar-transitioning"),a.transitionEnd((function(){a.removeClass("toolbar-transitioning")}))),a.removeClass("toolbar-hidden"),a.trigger("toolbar:show"),this.emit("toolbarShow",a[0]))},initHideToolbarOnScroll:function(e){var t,a,r,n,i,o,s,l=this,p=$(e),c=p.parents(".view").children(".toolbar");(0===c.length&&(c=p.find(".toolbar")),0===c.length&&(c=p.parents(".views").children(".tabbar, .tabbar-labels")),0!==c.length)&&(p.on("scroll",".page-content",d,!0),p[0].f7ScrollToolbarHandler=d);function d(e){e&&e.target&&e.target!==this||p.hasClass("page-previous")||(a=this.scrollTop,r=this.scrollHeight,n=this.offsetHeight,i=a+n>=r,s=c.hasClass("toolbar-hidden"),i?l.params.toolbar.showOnPageScrollEnd&&(o="show"):o=t>a?l.params.toolbar.showOnPageScrollTop||a<=44?"show":"hide":a>44?"hide":"show","show"===o&&s?(l.toolbar.show(c),s=!1):"hide"!==o||s||(l.toolbar.hide(c),s=!0),t=a)}}},Toolbar$1={name:"toolbar",create:function(){Utils.extend(this,{toolbar:{hide:Toolbar.hide.bind(this),show:Toolbar.show.bind(this),setHighlight:Toolbar.setHighlight.bind(this),initHideToolbarOnScroll:Toolbar.initHideToolbarOnScroll.bind(this),init:Toolbar.init.bind(this)}})},params:{toolbar:{hideOnPageScroll:!1,showOnPageScrollEnd:!0,showOnPageScrollTop:!0}},on:{pageBeforeRemove:function(e){e.$el[0].f7ScrollToolbarHandler&&e.$el.off("scroll",".page-content",e.$el[0].f7ScrollToolbarHandler,!0)},pageBeforeIn:function(e){var t=e.$el.parents(".view").children(".toolbar");0===t.length&&(t=e.$el.parents(".views").children(".tabbar, .tabbar-labels")),0===t.length&&(t=e.$el.find(".toolbar")),0!==t.length&&(e.$el.hasClass("no-toolbar")?this.toolbar.hide(t):this.toolbar.show(t))},pageInit:function(e){var t=this;if(e.$el.find(".tabbar, .tabbar-labels").each((function(e,a){t.toolbar.init(a)})),t.params.toolbar.hideOnPageScroll||e.$el.find(".hide-toolbar-on-scroll").length||e.$el.hasClass("hide-toolbar-on-scroll")||e.$el.find(".hide-bars-on-scroll").length||e.$el.hasClass("hide-bars-on-scroll")){if(e.$el.find(".keep-toolbar-on-scroll").length||e.$el.hasClass("keep-toolbar-on-scroll")||e.$el.find(".keep-bars-on-scroll").length||e.$el.hasClass("keep-bars-on-scroll"))return;t.toolbar.initHideToolbarOnScroll(e.el)}},init:function(){var e=this;e.root.find(".tabbar, .tabbar-labels").each((function(t,a){e.toolbar.init(a)}))}},vnode:{tabbar:{insert:function(e){this.toolbar.init(e.elm)}}}},Subnavbar={name:"subnavbar",on:{pageInit:function(e){e.$navbarEl&&e.$navbarEl.length&&e.$navbarEl.find(".subnavbar").length&&e.$el.addClass("page-with-subnavbar"),e.$el.find(".subnavbar").length&&e.$el.addClass("page-with-subnavbar")}}},TouchRipple=function(e,t,a){var r=this;if(e){var n=e[0].getBoundingClientRect(),i=t-n.left,o=a-n.top,s=n.width,l=n.height,p=Math.max(Math.pow(Math.pow(l,2)+Math.pow(s,2),.5),48);return r.$rippleWaveEl=$('<div class="ripple-wave" style="width: '+p+"px; height: "+p+"px; margin-top:-"+p/2+"px; margin-left:-"+p/2+"px; left:"+i+"px; top:"+o+'px;"></div>'),e.prepend(r.$rippleWaveEl),r.rippleTransform="translate3d("+(s/2-i)+"px, "+(l/2-o)+"px, 0) scale(1)",Utils.nextFrame((function(){r&&r.$rippleWaveEl&&r.$rippleWaveEl.transform(r.rippleTransform)})),r}};TouchRipple.prototype.destroy=function(){var e=this;e.$rippleWaveEl&&e.$rippleWaveEl.remove(),Object.keys(e).forEach((function(t){e[t]=null,delete e[t]})),e=null},TouchRipple.prototype.remove=function(){var e=this;if(!e.removing){var t=this.$rippleWaveEl,a=this.rippleTransform,r=Utils.nextTick((function(){e.destroy()}),400);e.removing=!0,t.addClass("ripple-wave-fill").transform(a.replace("scale(1)","scale(1.01)")).transitionEnd((function(){clearTimeout(r),Utils.nextFrame((function(){t.addClass("ripple-wave-out").transform(a.replace("scale(1)","scale(1.01)")),r=Utils.nextTick((function(){e.destroy()}),700),t.transitionEnd((function(){clearTimeout(r),e.destroy()}))}))}))}};var TouchRipple$1={name:"touch-ripple",static:{TouchRipple:TouchRipple},create:function(){this.touchRipple={create:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];return new(Function.prototype.bind.apply(TouchRipple,[null].concat(e)))}}}},openedModals=[],dialogsQueue=[];function clearDialogsQueue(){0!==dialogsQueue.length&&dialogsQueue.shift().open()}var Modal=function(e){function t(t,a){e.call(this,a,[t]);var r={};return this.useModulesParams(r),this.params=Utils.extend(r,a),this.opened=!1,this.useModules(),this}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t.prototype.onOpen=function(){this.opened=!0,openedModals.push(this),$("html").addClass("with-modal-"+this.type.toLowerCase()),this.$el.trigger("modal:open "+this.type.toLowerCase()+":open"),this.emit("local::open modalOpen "+this.type+"Open",this)},t.prototype.onOpened=function(){this.$el.trigger("modal:opened "+this.type.toLowerCase()+":opened"),this.emit("local::opened modalOpened "+this.type+"Opened",this)},t.prototype.onClose=function(){this.opened=!1,this.type&&this.$el&&(openedModals.splice(openedModals.indexOf(this),1),$("html").removeClass("with-modal-"+this.type.toLowerCase()),this.$el.trigger("modal:close "+this.type.toLowerCase()+":close"),this.emit("local::close modalClose "+this.type+"Close",this))},t.prototype.onClosed=function(){this.type&&this.$el&&(this.$el.removeClass("modal-out"),this.$el.hide(),this.$el.trigger("modal:closed "+this.type.toLowerCase()+":closed"),this.emit("local::closed modalClosed "+this.type+"Closed",this))},t.prototype.open=function(e){var t,a=this,r=a.app,n=a.$el,i=a.$backdropEl,o=a.type,s=!0;if(void 0!==e?s=e:void 0!==a.params.animate&&(s=a.params.animate),!n||n.hasClass("modal-in"))return a;if("dialog"===o&&r.params.modal.queueDialogs&&($(".dialog.modal-in").length>0?t=!0:openedModals.length>0&&openedModals.forEach((function(e){"dialog"===e.type&&(t=!0)})),t))return dialogsQueue.push(a),a;var l=n.parent(),p=n.parents(doc).length>0;function c(){n.hasClass("modal-out")?a.onClosed():n.hasClass("modal-in")&&a.onOpened()}return r.params.modal.moveToRoot&&!l.is(r.root)&&(r.root.append(n),a.once(o+"Closed",(function(){p?l.append(n):n.remove()}))),n.show(),a._clientLeft=n[0].clientLeft,s?(i&&(i.removeClass("not-animated"),i.addClass("backdrop-in")),n.animationEnd((function(){c()})),n.transitionEnd((function(){c()})),n.removeClass("modal-out not-animated").addClass("modal-in"),a.onOpen()):(i&&i.addClass("backdrop-in not-animated"),n.removeClass("modal-out").addClass("modal-in not-animated"),a.onOpen(),a.onOpened()),a},t.prototype.close=function(e){var t=this,a=t.$el,r=t.$backdropEl,n=!0;if(void 0!==e?n=e:void 0!==t.params.animate&&(n=t.params.animate),!a||!a.hasClass("modal-in"))return dialogsQueue.indexOf(t)>=0&&dialogsQueue.splice(dialogsQueue.indexOf(t),1),t;if(r){var i=!0;"popup"===t.type&&t.$el.prevAll(".popup.modal-in").each((function(e,a){var r=a.f7Modal;r&&r.params.closeByBackdropClick&&r.params.backdrop&&r.backdropEl===t.backdropEl&&(i=!1)})),i&&(r[n?"removeClass":"addClass"]("not-animated"),r.removeClass("backdrop-in"))}function o(){a.hasClass("modal-out")?t.onClosed():a.hasClass("modal-in")&&t.onOpened()}return a[n?"removeClass":"addClass"]("not-animated"),n?(a.animationEnd((function(){o()})),a.transitionEnd((function(){o()})),a.removeClass("modal-in").addClass("modal-out"),t.onClose()):(a.addClass("not-animated").removeClass("modal-in").addClass("modal-out"),t.onClose(),t.onClosed()),"dialog"===t.type&&clearDialogsQueue(),t},t.prototype.destroy=function(){this.destroyed||(this.emit("local::beforeDestroy modalBeforeDestroy "+this.type+"BeforeDestroy",this),this.$el&&(this.$el.trigger("modal:beforedestroy "+this.type.toLowerCase()+":beforedestroy"),this.$el.length&&this.$el[0].f7Modal&&delete this.$el[0].f7Modal),Utils.deleteProps(this),this.destroyed=!0)},t}(Framework7Class),CustomModal=function(e){function t(t,a){var r=Utils.extend({backdrop:!0,closeByBackdropClick:!0,on:{}},a);e.call(this,t,r);var n,i,o=this;if(o.params=r,(n=o.params.el?$(o.params.el):$(o.params.content))&&n.length>0&&n[0].f7Modal)return n[0].f7Modal;if(0===n.length)return o.destroy();function s(e){o&&!o.destroyed&&i&&e.target===i[0]&&o.close()}return o.params.backdrop&&0===(i=t.root.children(".custom-modal-backdrop")).length&&(i=$('<div class="custom-modal-backdrop"></div>'),t.root.append(i)),o.on("customModalOpened",(function(){o.params.closeByBackdropClick&&o.params.backdrop&&t.on("click",s)})),o.on("customModalClose",(function(){o.params.closeByBackdropClick&&o.params.backdrop&&t.off("click",s)})),Utils.extend(o,{app:t,$el:n,el:n[0],$backdropEl:i,backdropEl:i&&i[0],type:"customModal"}),n[0].f7Modal=o,o}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t}(Modal),Modal$1={name:"modal",static:{Modal:Modal,CustomModal:CustomModal},create:function(){var e=this;e.customModal={create:function(t){return new CustomModal(e,t)}}},params:{modal:{moveToRoot:!0,queueDialogs:!0}}},Appbar={name:"appbar"},Dialog=function(e){function t(t,a){var r=Utils.extend({title:t.params.dialog.title,text:void 0,content:"",buttons:[],verticalButtons:!1,onClick:void 0,cssClass:void 0,destroyOnClose:!1,on:{}},a);void 0===r.closeByBackdropClick&&(r.closeByBackdropClick=t.params.dialog.closeByBackdropClick),void 0===r.backdrop&&(r.backdrop=t.params.dialog.backdrop),e.call(this,t,r);var n,i,o,s=this,l=r.title,p=r.text,c=r.content,d=r.buttons,u=r.verticalButtons,h=r.cssClass,f=r.backdrop;if(s.params=r,s.params.el)n=$(s.params.el);else{var m=["dialog"];0===d.length&&m.push("dialog-no-buttons"),d.length>0&&m.push("dialog-buttons-"+d.length),u&&m.push("dialog-buttons-vertical"),h&&m.push(h);var v="";d.length>0&&(v='\n          <div class="dialog-buttons">\n            '+d.map((function(e){return'\n              <span class="dialog-button'+(e.bold?" dialog-button-bold":"")+(e.color?" color-"+e.color:"")+(e.cssClass?" "+e.cssClass:"")+'">'+e.text+"</span>\n            "})).join("")+"\n          </div>\n        ");var g='\n        <div class="'+m.join(" ")+'">\n          <div class="dialog-inner">\n            '+(l?'<div class="dialog-title">'+l+"</div>":"")+"\n            "+(p?'<div class="dialog-text">'+p+"</div>":"")+"\n            "+c+"\n          </div>\n          "+v+"\n        </div>\n      ";n=$(g)}if(n&&n.length>0&&n[0].f7Modal)return n[0].f7Modal;if(0===n.length)return s.destroy();function b(e){var t=$(this).index(),a=d[t];a.onClick&&a.onClick(s,e),s.params.onClick&&s.params.onClick(s,t),!1!==a.close&&s.close()}function y(e){var t=e.keyCode;d.forEach((function(a,r){a.keyCodes&&a.keyCodes.indexOf(t)>=0&&(doc.activeElement&&doc.activeElement.blur(),a.onClick&&a.onClick(s,e),s.params.onClick&&s.params.onClick(s,r),!1!==a.close&&s.close())}))}function w(e){var t=e.target;0===$(t).closest(s.el).length&&s.params.closeByBackdropClick&&s.backdropEl&&s.backdropEl===t&&s.close()}return f&&0===(i=t.root.children(".dialog-backdrop")).length&&(i=$('<div class="dialog-backdrop"></div>'),t.root.append(i)),d&&d.length>0&&(s.on("open",(function(){n.find(".dialog-button").each((function(e,t){d[e].keyCodes&&(o=!0),$(t).on("click",b)})),!o||t.device.ios||t.device.android||t.device.cordova||$(doc).on("keydown",y)})),s.on("close",(function(){n.find(".dialog-button").each((function(e,t){$(t).off("click",b)})),!o||t.device.ios||t.device.android||t.device.cordova||$(doc).off("keydown",y),o=!1}))),Utils.extend(s,{app:t,$el:n,el:n[0],$backdropEl:i,backdropEl:i&&i[0],type:"dialog",setProgress:function(e,a){return t.progressbar.set(n.find(".progressbar"),e,a),s},setText:function(e){var t=n.find(".dialog-text");return 0===t.length&&(t=$('<div class="dialog-text"></div>'),void 0!==l?t.insertAfter(n.find(".dialog-title")):n.find(".dialog-inner").prepend(t)),t.html(e),s.params.text=e,s},setTitle:function(e){var t=n.find(".dialog-title");return 0===t.length&&(t=$('<div class="dialog-title"></div>'),n.find(".dialog-inner").prepend(t)),t.html(e),s.params.title=e,s}}),s.on("opened",(function(){s.params.closeByBackdropClick&&t.on("click",w)})),s.on("close",(function(){s.params.closeByBackdropClick&&t.off("click",w)})),n[0].f7Modal=s,s.params.destroyOnClose&&s.once("closed",(function(){setTimeout((function(){s.destroy()}),0)})),s}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t}(Modal),Dialog$1={name:"dialog",params:{dialog:{title:void 0,buttonOk:"OK",buttonCancel:"Cancel",usernamePlaceholder:"Username",passwordPlaceholder:"Password",preloaderTitle:"Loading... ",progressTitle:"Loading... ",backdrop:!0,closeByBackdropClick:!1,destroyPredefinedDialogs:!0,keyboardActions:!0,autoFocus:!0}},static:{Dialog:Dialog},create:function(){var e=this;function t(){return e.params.dialog.title||e.name}var a=e.params.dialog.destroyPredefinedDialogs,r=e.params.dialog.keyboardActions,n=e.params.dialog.autoFocus?{on:{opened:function(e){e.$el.find("input").eq(0).focus()}}}:{};e.dialog=Utils.extend(ModalMethods({app:e,constructor:Dialog,defaultSelector:".dialog.modal-in"}),{alert:function(){for(var n,i=[],o=arguments.length;o--;)i[o]=arguments[o];var s=i[0],l=i[1],p=i[2];return 2===i.length&&"function"==typeof i[1]&&(s=(n=i)[0],p=n[1],l=n[2]),new Dialog(e,{title:void 0===l?t():l,text:s,buttons:[{text:e.params.dialog.buttonOk,bold:!0,onClick:p,keyCodes:r?[13,27]:null}],destroyOnClose:a}).open()},prompt:function(){for(var i,o=[],s=arguments.length;s--;)o[s]=arguments[s];var l=o[0],p=o[1],c=o[2],d=o[3],u=o[4];return"function"==typeof o[1]&&(l=(i=o)[0],c=i[1],d=i[2],u=i[3],p=i[4]),u=null==u?"":u,new Dialog(e,Object.assign({},{title:void 0===p?t():p,text:l,content:'<div class="dialog-input-field input"><input type="text" class="dialog-input" value="'+u+'"></div>',buttons:[{text:e.params.dialog.buttonCancel,keyCodes:r?[27]:null,color:"aurora"===e.theme?"gray":null},{text:e.params.dialog.buttonOk,bold:!0,keyCodes:r?[13]:null}],onClick:function(e,t){var a=e.$el.find(".dialog-input").val();0===t&&d&&d(a),1===t&&c&&c(a)},destroyOnClose:a},n)).open()},confirm:function(){for(var n,i=[],o=arguments.length;o--;)i[o]=arguments[o];var s=i[0],l=i[1],p=i[2],c=i[3];return"function"==typeof i[1]&&(s=(n=i)[0],p=n[1],c=n[2],l=n[3]),new Dialog(e,{title:void 0===l?t():l,text:s,buttons:[{text:e.params.dialog.buttonCancel,onClick:c,keyCodes:r?[27]:null,color:"aurora"===e.theme?"gray":null},{text:e.params.dialog.buttonOk,bold:!0,onClick:p,keyCodes:r?[13]:null}],destroyOnClose:a}).open()},login:function(){for(var i,o=[],s=arguments.length;s--;)o[s]=arguments[s];var l=o[0],p=o[1],c=o[2],d=o[3];return"function"==typeof o[1]&&(l=(i=o)[0],c=i[1],d=i[2],p=i[3]),new Dialog(e,Object.assign({},{title:void 0===p?t():p,text:l,content:'\n              <div class="dialog-input-field dialog-input-double input">\n                <input type="text" name="dialog-username" placeholder="'+e.params.dialog.usernamePlaceholder+'" class="dialog-input">\n              </div>\n              <div class="dialog-input-field dialog-input-double input">\n                <input type="password" name="dialog-password" placeholder="'+e.params.dialog.passwordPlaceholder+'" class="dialog-input">\n              </div>',buttons:[{text:e.params.dialog.buttonCancel,keyCodes:r?[27]:null,color:"aurora"===e.theme?"gray":null},{text:e.params.dialog.buttonOk,bold:!0,keyCodes:r?[13]:null}],onClick:function(e,t){var a=e.$el.find('[name="dialog-username"]').val(),r=e.$el.find('[name="dialog-password"]').val();0===t&&d&&d(a,r),1===t&&c&&c(a,r)},destroyOnClose:a},n)).open()},password:function(){for(var i,o=[],s=arguments.length;s--;)o[s]=arguments[s];var l=o[0],p=o[1],c=o[2],d=o[3];return"function"==typeof o[1]&&(l=(i=o)[0],c=i[1],d=i[2],p=i[3]),new Dialog(e,Object.assign({},{title:void 0===p?t():p,text:l,content:'\n              <div class="dialog-input-field input">\n                <input type="password" name="dialog-password" placeholder="'+e.params.dialog.passwordPlaceholder+'" class="dialog-input">\n              </div>',buttons:[{text:e.params.dialog.buttonCancel,keyCodes:r?[27]:null,color:"aurora"===e.theme?"gray":null},{text:e.params.dialog.buttonOk,bold:!0,keyCodes:r?[13]:null}],onClick:function(e,t){var a=e.$el.find('[name="dialog-password"]').val();0===t&&d&&d(a),1===t&&c&&c(a)},destroyOnClose:a},n)).open()},preloader:function(t,r){var n=Utils[e.theme+"PreloaderContent"]||"";return new Dialog(e,{title:null==t?e.params.dialog.preloaderTitle:t,content:'<div class="preloader'+(r?" color-"+r:"")+'">'+n+"</div>",cssClass:"dialog-preloader",destroyOnClose:a}).open()},progress:function(){for(var t,r,n,i=[],o=arguments.length;o--;)i[o]=arguments[o];var s=i[0],l=i[1],p=i[2];2===i.length?"number"==typeof i[0]?(l=(t=i)[0],p=t[1],s=t[2]):"string"==typeof i[0]&&"string"==typeof i[1]&&(s=(r=i)[0],p=r[1],l=r[2]):1===i.length&&"number"==typeof i[0]&&(l=(n=i)[0],s=n[1],p=n[2]);var c=void 0===l,d=new Dialog(e,{title:void 0===s?e.params.dialog.progressTitle:s,cssClass:"dialog-progress",content:'\n              <div class="progressbar'+(c?"-infinite":"")+(p?" color-"+p:"")+'">\n                '+(c?"":"<span></span>")+"\n              </div>\n            ",destroyOnClose:a});return c||d.setProgress(l),d.open()}})}},Popup=function(e){function t(t,a){var r=Utils.extend({on:{}},t.params.popup,a);e.call(this,t,r);var n,i,o,s,l=this;if(l.params=r,(n=l.params.el?$(l.params.el).eq(0):$(l.params.content).filter((function(e,t){return 1===t.nodeType})).eq(0))&&n.length>0&&n[0].f7Modal)return n[0].f7Modal;if(0===n.length)return l.destroy();function p(e){var a=e.target,r=$(a);if(!(!t.device.desktop&&t.device.cordova&&(win.Keyboard&&win.Keyboard.isVisible||win.cordova.plugins&&win.cordova.plugins.Keyboard&&win.cordova.plugins.Keyboard.isVisible))&&0===r.closest(l.el).length&&l.params&&l.params.closeByBackdropClick&&l.params.backdrop&&l.backdropEl&&l.backdropEl===a){var n=!0;l.$el.nextAll(".popup.modal-in").each((function(e,t){var a=t.f7Modal;a&&a.params.closeByBackdropClick&&a.params.backdrop&&a.backdropEl===l.backdropEl&&(n=!1)})),n&&l.close()}}function c(e){27===e.keyCode&&l.params.closeOnEscape&&l.close()}function d(e){return(t.height-2*e)/t.height}l.params.backdrop&&l.params.backdropEl?i=$(l.params.backdropEl):l.params.backdrop&&0===(i=t.root.children(".popup-backdrop")).length&&(i=$('<div class="popup-backdrop"></div>'),t.root.append(i)),Utils.extend(l,{app:t,push:n.hasClass("popup-push")||l.params.push,$el:n,el:n[0],$backdropEl:i,backdropEl:i&&i[0],type:"popup",$htmlEl:$("html")}),l.params.push&&n.addClass("popup-push");var u,h,f,m,v,g,b,y,w,C,x,k=!0,E=!1,T=!1;function S(e){!E&&k&&l.params.swipeToClose&&(l.params.swipeHandler&&0===$(e.target).closest(l.params.swipeHandler).length||(E=!0,T=!1,u={x:"touchstart"===e.type?e.targetTouches[0].pageX:e.pageX,y:"touchstart"===e.type?e.targetTouches[0].pageY:e.pageY},m=Utils.now(),f=void 0,l.params.swipeHandler||"touchstart"!==e.type||(g=$(e.target).closest(".page-content")[0])))}function M(e){if(E){if(h={x:"touchmove"===e.type?e.targetTouches[0].pageX:e.pageX,y:"touchmove"===e.type?e.targetTouches[0].pageY:e.pageY},void 0===f&&(f=!!(f||Math.abs(h.x-u.x)>Math.abs(h.y-u.y))),f)return E=!1,void(T=!1);v=u.y-h.y,s&&o&&v>0&&(v=0);var a=v<0?"to-bottom":"to-top";if(n.transition(0),"string"==typeof l.params.swipeToClose&&a!==l.params.swipeToClose)return n.transform(""),void n.transition("");if(T)l.emit("local::swipeMove popupSwipeMove",l),l.$el.trigger("popup:swipemove");else{if(s&&o&&(C=n[0].offsetHeight,x=t.root.children(".view, .views")),g&&(b=g.scrollTop,w=g.scrollHeight,y=g.offsetHeight,!(w===y||"to-bottom"===a&&0===b||"to-top"===a&&b===w-y)))return n.transform(""),n.transition(""),E=!1,void(T=!1);T=!0,l.emit("local::swipeStart popupSwipeStart",l),l.$el.trigger("popup:swipestart")}if(e.preventDefault(),s&&o){var r=1-Math.abs(v/C),i=1-(1-d(o))*r;x.transition(0).transform("translate3d(0,0,0) scale("+i+")")}n.transition(0).transform("translate3d(0,"+-v+"px,0)")}}function P(){if(E=!1,T){l.emit("local::swipeEnd popupSwipeEnd",l),l.$el.trigger("popup:swipeend"),T=!1,k=!1,n.transition(""),s&&o&&x.transition("").transform("");var e=v<=0?"to-bottom":"to-top";if("string"==typeof l.params.swipeToClose&&e!==l.params.swipeToClose)return n.transform(""),void(k=!0);var t=Math.abs(v),a=(new Date).getTime()-m;a<300&&t>20||a>=300&&t>100?Utils.nextTick((function(){"to-bottom"===e?n.addClass("swipe-close-to-bottom"):n.addClass("swipe-close-to-top"),n.transform(""),l.emit("local::swipeclose popupSwipeClose",l),l.$el.trigger("popup:swipeclose"),l.close(),k=!0})):(k=!0,n.transform(""))}}var O=!!Support.passiveListener&&{passive:!0};return l.params.swipeToClose&&(n.on(t.touchEvents.start,S,O),t.on("touchmove",M),t.on("touchend:passive",P),l.once("popupDestroy",(function(){n.off(t.touchEvents.start,S,O),t.off("touchmove",M),t.off("touchend:passive",P)}))),l.on("open",(function(){l.params.closeOnEscape&&$(doc).on("keydown",c),l.push&&(s=l.push&&(t.width<630||t.height<630||n.hasClass("popup-tablet-fullscreen"))),s&&(o=parseInt(n.css("--f7-popup-push-offset"),10),Number.isNaN(o)&&(o=0),o&&(n.addClass("popup-push"),l.$htmlEl.addClass("with-modal-popup-push"),l.$htmlEl[0].style.setProperty("--f7-popup-push-scale",d(o))))})),l.on("opened",(function(){n.removeClass("swipe-close-to-bottom swipe-close-to-top"),l.params.closeByBackdropClick&&t.on("click",p)})),l.on("close",(function(){l.params.closeOnEscape&&$(doc).off("keydown",c),l.params.closeByBackdropClick&&t.off("click",p),s&&o&&(l.$htmlEl.removeClass("with-modal-popup-push"),l.$htmlEl.addClass("with-modal-popup-push-closing"))})),l.on("closed",(function(){s&&o&&(l.$htmlEl.removeClass("with-modal-popup-push-closing"),l.$htmlEl[0].style.removeProperty("--f7-popup-push-scale"))})),n[0].f7Modal=l,l}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t}(Modal),Popup$1={name:"popup",params:{popup:{backdrop:!0,backdropEl:void 0,closeByBackdropClick:!0,closeOnEscape:!1,swipeToClose:!1,swipeHandler:null,push:!1}},static:{Popup:Popup},create:function(){this.popup=ModalMethods({app:this,constructor:Popup,defaultSelector:".popup.modal-in"})},clicks:{".popup-open":function(e,t){void 0===t&&(t={});this.popup.open(t.popup,t.animate)},".popup-close":function(e,t){void 0===t&&(t={});this.popup.close(t.popup,t.animate)}}},LoginScreen=function(e){function t(t,a){var r=Utils.extend({on:{}},a);e.call(this,t,r);var n;return this.params=r,(n=this.params.el?$(this.params.el).eq(0):$(this.params.content).filter((function(e,t){return 1===t.nodeType})).eq(0))&&n.length>0&&n[0].f7Modal?n[0].f7Modal:0===n.length?this.destroy():(Utils.extend(this,{app:t,$el:n,el:n[0],type:"loginScreen"}),n[0].f7Modal=this,this)}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t}(Modal),LoginScreen$1={name:"loginScreen",static:{LoginScreen:LoginScreen},create:function(){this.loginScreen=ModalMethods({app:this,constructor:LoginScreen,defaultSelector:".login-screen.modal-in"})},clicks:{".login-screen-open":function(e,t){void 0===t&&(t={});this.loginScreen.open(t.loginScreen,t.animate)},".login-screen-close":function(e,t){void 0===t&&(t={});this.loginScreen.close(t.loginScreen,t.animate)}}},Popover=function(e){function t(t,a){var r=Utils.extend({on:{}},t.params.popover,a);e.call(this,t,r);var n,i=this;if(i.params=r,(n=i.params.el?$(i.params.el).eq(0):$(i.params.content).filter((function(e,t){return 1===t.nodeType})).eq(0))&&n.length>0&&n[0].f7Modal)return n[0].f7Modal;var o,s,l=$(i.params.targetEl).eq(0);if(0===n.length)return i.destroy();i.params.backdrop&&i.params.backdropEl?o=$(i.params.backdropEl):i.params.backdrop&&0===(o=t.root.children(".popover-backdrop")).length&&(o=$('<div class="popover-backdrop"></div>'),t.root.append(o)),0===n.find(".popover-angle").length?(s=$('<div class="popover-angle"></div>'),n.prepend(s)):s=n.find(".popover-angle");var p=i.open;function c(){i.resize()}function d(e){var a=e.target,r=$(a);!t.device.desktop&&t.device.cordova&&(win.Keyboard&&win.Keyboard.isVisible||win.cordova.plugins&&win.cordova.plugins.Keyboard&&win.cordova.plugins.Keyboard.isVisible)||0===r.closest(i.el).length&&(i.params.closeByBackdropClick&&i.params.backdrop&&i.backdropEl&&i.backdropEl===a||i.params.closeByOutsideClick)&&i.close()}function u(e){27===e.keyCode&&i.params.closeOnEscape&&i.close()}return Utils.extend(i,{app:t,$el:n,el:n[0],$targetEl:l,targetEl:l[0],$angleEl:s,angleEl:s[0],$backdropEl:o,backdropEl:o&&o[0],type:"popover",open:function(){for(var e,t=[],a=arguments.length;a--;)t[a]=arguments[a];var r=t[0],n=t[1];return"boolean"==typeof t[0]&&(n=(e=t)[0],r=e[1]),r&&(i.$targetEl=$(r),i.targetEl=i.$targetEl[0]),p.call(i,n)}}),i.on("popoverOpen",(function(){i.resize(),t.on("resize",c),$(win).on("keyboardDidShow keyboardDidHide",c),i.on("popoverClose popoverBeforeDestroy",(function(){t.off("resize",c),$(win).off("keyboardDidShow keyboardDidHide",c)}))})),i.params.closeOnEscape&&(i.on("popoverOpen",(function(){$(doc).on("keydown",u)})),i.on("popoverClose",(function(){$(doc).off("keydown",u)}))),i.on("popoverOpened",(function(){(i.params.closeByOutsideClick||i.params.closeByBackdropClick)&&t.on("click",d)})),i.on("popoverClose",(function(){(i.params.closeByOutsideClick||i.params.closeByBackdropClick)&&t.off("click",d)})),n[0].f7Modal=i,i}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t.prototype.resize=function(){var e=this.app,t=this.$el,a=this.$targetEl,r=this.$angleEl,n=this.params,i=n.targetX,o=n.targetY;t.css({left:"",top:""});var s,l,p,c,d,u,h=[t.width(),t.height()],f=h[0],m=h[1],v=0;"ios"===e.theme||"aurora"===e.theme?(r.removeClass("on-left on-right on-top on-bottom").css({left:"",top:""}),v=r.width()/2):t.removeClass("popover-on-left popover-on-right popover-on-top popover-on-bottom popover-on-middle").css({left:"",top:""});var g=parseInt($("html").css("--f7-safe-area-top"),10);if(Number.isNaN(g)&&(g=0),a&&a.length>0){p=a.outerWidth(),c=a.outerHeight();var b=a.offset();d=b.left-e.left,u=b.top-e.top;var y=a.parents(".page");y.length>0&&(u-=y[0].scrollTop)}else void 0!==i&&"undefined"!==o&&(d=i,u=o,p=this.params.targetWidth||0,c=this.params.targetHeight||0);var w,C=[0,0,0],x=C[0],k=C[1],E=C[2],T="md"===e.theme?"bottom":"top";"md"===e.theme?(m<e.height-u-c?(T="bottom",k=u+c):m<u-g?(k=u-m,T="top"):(T="middle",k=c/2+u-m/2),k=Math.max(8,Math.min(k,e.height-m-8)),d<e.width/2?(w="right",x="middle"===T?d+p:d):(w="left",x="middle"===T?d-f:d+p-f),x=Math.max(8,Math.min(x,e.width-f-8)),t.addClass("popover-on-"+T+" popover-on-"+w)):(m+v<u-g?k=u-m-v:m+v<e.height-u-c?(T="bottom",k=u+c+v):(T="middle",E=k=c/2+u-m/2,E-=k=Math.max(5,Math.min(k,e.height-m-5))),"top"===T||"bottom"===T?(E=x=p/2+d-f/2,x=Math.max(5,Math.min(x,e.width-f-5)),"top"===T&&r.addClass("on-bottom"),"bottom"===T&&r.addClass("on-top"),s=f/2-v+(E-=x),s=Math.max(Math.min(s,f-2*v-13),13),r.css({left:s+"px"})):"middle"===T&&(x=d-f-v,r.addClass("on-right"),(x<5||x+f>e.width)&&(x<5&&(x=d+p+v),x+f>e.width&&(x=e.width-f-5),r.removeClass("on-right").addClass("on-left")),l=m/2-v+E,l=Math.max(Math.min(l,m-2*v-13),13),r.css({top:l+"px"})));t.css({top:k+"px",left:x+"px"})},t}(Modal),Popover$1={name:"popover",params:{popover:{backdrop:!0,backdropEl:void 0,closeByBackdropClick:!0,closeByOutsideClick:!0,closeOnEscape:!1}},static:{Popover:Popover},create:function(){var e=this;e.popover=Utils.extend(ModalMethods({app:e,constructor:Popover,defaultSelector:".popover.modal-in"}),{open:function(t,a,r){var n=$(t),i=n[0].f7Modal;return i||(i=new Popover(e,{el:n,targetEl:a})),i.open(a,r)}})},clicks:{".popover-open":function(e,t){void 0===t&&(t={});this.popover.open(t.popover,e,t.animate)},".popover-close":function(e,t){void 0===t&&(t={});this.popover.close(t.popover,t.animate)}}},Actions=function(e){function t(t,a){var r=Utils.extend({on:{}},t.params.actions,a);e.call(this,t,r);var n,i,o,s=this;if(s.params=r,s.params.buttons&&(n=s.params.buttons,Array.isArray(n[0])||(n=[n])),s.groups=n,s.params.el?i=$(s.params.el).eq(0):s.params.content?i=$(s.params.content).filter((function(e,t){return 1===t.nodeType})).eq(0):s.params.buttons&&(s.params.convertToPopover&&(s.popoverHtml=s.renderPopover()),s.actionsHtml=s.render()),i&&i.length>0&&i[0].f7Modal)return i[0].f7Modal;if(i&&0===i.length&&!s.actionsHtml&&!s.popoverHtml)return s.destroy();s.params.backdrop&&s.params.backdropEl?o=$(s.params.backdropEl):s.params.backdrop&&0===(o=t.root.children(".actions-backdrop")).length&&(o=$('<div class="actions-backdrop"></div>'),t.root.append(o));var l,p=s.open,c=s.close;function d(e){var t,a,r=$(this);if(r.hasClass("list-button")||r.hasClass("item-link")?(t=r.parents("li").index(),a=r.parents(".list").index()):(t=r.index(),a=r.parents(".actions-group").index()),void 0!==n){var i=n[a][t];i.onClick&&i.onClick(s,e),s.params.onClick&&s.params.onClick(s,e),!1!==i.close&&s.close()}}function u(e){var a=e.target,r=$(a);!t.device.desktop&&t.device.cordova&&(win.Keyboard&&win.Keyboard.isVisible||win.cordova.plugins&&win.cordova.plugins.Keyboard&&win.cordova.plugins.Keyboard.isVisible)||0===r.closest(s.el).length&&(s.params.closeByBackdropClick&&s.params.backdrop&&s.backdropEl&&s.backdropEl===a||s.params.closeByOutsideClick)&&s.close()}function h(e){27===e.keyCode&&s.params.closeOnEscape&&s.close()}return s.open=function(e){var a=!1,r=s.params,n=r.targetEl,i=r.targetX,o=r.targetY,c=r.targetWidth,u=r.targetHeight;return s.params.convertToPopover&&(n||void 0!==i&&void 0!==o)&&(s.params.forceToPopover||t.device.ios&&t.device.ipad||t.width>=768||t.device.desktop&&"aurora"===t.theme)&&(a=!0),a&&s.popoverHtml?((l=t.popover.create({content:s.popoverHtml,backdrop:s.params.backdrop,targetEl:n,targetX:i,targetY:o,targetWidth:c,targetHeight:u,on:{open:function(){s.$el.trigger("modal:open "+s.type.toLowerCase()+":open"),s.emit("local::open modalOpen "+s.type+"Open",s)},opened:function(){s.$el.trigger("modal:opened "+s.type.toLowerCase()+":opened"),s.emit("local::opened modalOpened "+s.type+"Opened",s)},close:function(){s.$el.trigger("modal:close "+s.type.toLowerCase()+":close"),s.emit("local::close modalClose "+s.type+"Close",s)},closed:function(){s.$el.trigger("modal:closed "+s.type.toLowerCase()+":closed"),s.emit("local::closed modalClosed "+s.type+"Closed",s)}}})).open(e),l.once("popoverOpened",(function(){l.$el.find(".list-button, .item-link").each((function(e,t){$(t).on("click",d)}))})),l.once("popoverClosed",(function(){l.$el.find(".list-button, .item-link").each((function(e,t){$(t).off("click",d)})),Utils.nextTick((function(){l.destroy(),l=void 0}))}))):(s.$el=s.actionsHtml?$(s.actionsHtml):s.$el,s.$el[0].f7Modal=s,s.groups&&(s.$el.find(".actions-button").each((function(e,t){$(t).on("click",d)})),s.once("actionsClosed",(function(){s.$el.find(".actions-button").each((function(e,t){$(t).off("click",d)}))}))),s.el=s.$el[0],p.call(s,e)),s},s.close=function(e){return l?l.close(e):c.call(s,e),s},Utils.extend(s,{app:t,$el:i,el:i?i[0]:void 0,$backdropEl:o,backdropEl:o&&o[0],type:"actions"}),s.params.closeOnEscape&&(s.on("open",(function(){$(doc).on("keydown",h)})),s.on("close",(function(){$(doc).off("keydown",h)}))),s.on("opened",(function(){(s.params.closeByBackdropClick||s.params.closeByOutsideClick)&&t.on("click",u)})),s.on("close",(function(){(s.params.closeByBackdropClick||s.params.closeByOutsideClick)&&t.off("click",u)})),i&&(i[0].f7Modal=s),s}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t.prototype.render=function(){if(this.params.render)return this.params.render.call(this,this);var e=this.groups,t=this.params.cssClass;return('\n      <div class="actions-modal'+(this.params.grid?" actions-grid":"")+" "+(t||"")+'">\n        '+e.map((function(e){return'<div class="actions-group">\n            '+e.map((function(e){var t=["actions-"+(e.label?"label":"button")],a=e.color,r=e.bg,n=e.bold,i=e.disabled,o=e.label,s=e.text,l=e.icon;return a&&t.push("color-"+a),r&&t.push("bg-color-"+r),n&&t.push("actions-button-bold"),i&&t.push("disabled"),o?'<div class="'+t.join(" ")+'">'+s+"</div>":('\n                <div class="'+t.join(" ")+'">\n                  '+(l?'<div class="actions-button-media">'+l+"</div>":"")+'\n                  <div class="actions-button-text">'+s+"</div>\n                </div>").trim()})).join("")+"\n          </div>"})).join("")+"\n      </div>\n    ").trim()},t.prototype.renderPopover=function(){if(this.params.renderPopover)return this.params.renderPopover.call(this,this);var e=this.groups;return('\n      <div class="popover popover-from-actions '+(this.params.cssClass||"")+'">\n        <div class="popover-inner">\n          '+e.map((function(e){return'\n            <div class="list">\n              <ul>\n                '+e.map((function(e){var t=[],a=e.color,r=e.bg,n=e.bold,i=e.disabled,o=e.label,s=e.text,l=e.icon;return a&&t.push("color-"+a),r&&t.push("bg-color-"+r),n&&t.push("popover-from-actions-bold"),i&&t.push("disabled"),o?(t.push("popover-from-actions-label"),'<li class="'+t.join(" ")+'">'+s+"</li>"):l?(t.push("item-link item-content"),'\n                      <li>\n                        <a class="'+t.join(" ")+'">\n                          <div class="item-media">\n                            '+l+'\n                          </div>\n                          <div class="item-inner">\n                            <div class="item-title">\n                              '+s+"\n                            </div>\n                          </div>\n                        </a>\n                      </li>\n                    "):(t.push("list-button"),'\n                    <li>\n                      <a class="'+t.join(" ")+'">'+s+"</a>\n                    </li>\n                  ")})).join("")+"\n              </ul>\n            </div>\n          "})).join("")+"\n        </div>\n      </div>\n    ").trim()},t}(Modal),Actions$1={name:"actions",params:{actions:{convertToPopover:!0,forceToPopover:!1,backdrop:!0,backdropEl:void 0,cssClass:null,closeByBackdropClick:!0,closeOnEscape:!1,render:null,renderPopover:null}},static:{Actions:Actions},create:function(){this.actions=ModalMethods({app:this,constructor:Actions,defaultSelector:".actions-modal.modal-in"})},clicks:{".actions-open":function(e,t){void 0===t&&(t={});this.actions.open(t.actions,t.animate)},".actions-close":function(e,t){void 0===t&&(t={});this.actions.close(t.actions,t.animate)}}},Sheet=function(e){function t(t,a){var r=Utils.extend({on:{}},t.params.sheet,a);e.call(this,t,r);var n,i,o,s,l=this;if(l.params=r,void 0===l.params.backdrop&&(l.params.backdrop="ios"!==t.theme),(n=l.params.el?$(l.params.el).eq(0):$(l.params.content).filter((function(e,t){return 1===t.nodeType})).eq(0))&&n.length>0&&n[0].f7Modal)return n[0].f7Modal;if(0===n.length)return l.destroy();function p(e){var a=e.target,r=$(a);!t.device.desktop&&t.device.cordova&&(win.Keyboard&&win.Keyboard.isVisible||win.cordova.plugins&&win.cordova.plugins.Keyboard&&win.cordova.plugins.Keyboard.isVisible)||0===r.closest(l.el).length&&(l.params.closeByBackdropClick&&l.params.backdrop&&l.backdropEl&&l.backdropEl===a||l.params.closeByOutsideClick)&&l.close()}function c(e){27===e.keyCode&&l.params.closeOnEscape&&l.close()}function d(e){return(t.height-2*e)/t.height}l.params.backdrop&&l.params.backdropEl?i=$(l.params.backdropEl):l.params.backdrop&&0===(i=t.root.children(".sheet-backdrop")).length&&(i=$('<div class="sheet-backdrop"></div>'),t.root.append(i)),Utils.extend(l,{app:t,push:n.hasClass("sheet-modal-push")||l.params.push,$el:n,el:n[0],$backdropEl:i,backdropEl:i&&i[0],type:"sheet",$htmlEl:$("html")}),l.params.push&&n.addClass("sheet-modal-push");var u,h,f,m,v,g,b,y,w,C,x,k,E,T,S,M,P,O,D=!1,I=!1;function B(e){D||!l.params.swipeToClose&&!l.params.swipeToStep||l.params.swipeHandler&&0===$(e.target).closest(l.params.swipeHandler).length||(D=!0,I=!1,u={x:"touchstart"===e.type?e.targetTouches[0].pageX:e.pageX,y:"touchstart"===e.type?e.targetTouches[0].pageY:e.pageY},m=Utils.now(),f=void 0,g=n.hasClass("sheet-modal-top"),l.params.swipeHandler||"touchstart"!==e.type||(S=$(e.target).closest(".page-content")[0]))}function R(e){if(D){if(h={x:"touchmove"===e.type?e.targetTouches[0].pageX:e.pageX,y:"touchmove"===e.type?e.targetTouches[0].pageY:e.pageY},void 0===f&&(f=!!(f||Math.abs(h.x-u.x)>Math.abs(h.y-u.y))),f)return D=!1,void(I=!1);var a,r=(v=u.y-h.y)<0?"to-bottom":"to-top";if(!I){if(S&&!n.hasClass("modal-in-swipe-step")&&(M=S.scrollTop,P=S.scrollHeight,O=S.offsetHeight,!(P===O||"to-bottom"===r&&0===M||"to-top"===r&&M===P-O)))return n.transform(""),D=!1,void(I=!1);l.push&&s&&(E=t.root.children(".view, .views")),C=n[0].offsetHeight,y=Utils.getTranslate(n[0],"y"),g?(x=l.params.swipeToClose?-C:-b,k=0):(x=0,k=l.params.swipeToClose?C:b),I=!0}if(w=y-v,w=Math.min(Math.max(w,x),k),e.preventDefault(),l.push&&s){var i=(w-y)/C;l.params.swipeToStep&&(i=g?w/b:1-(b-w)/b),i=Math.abs(i);var o=1-(i=Math.min(Math.max(i,0),1)),p=1-(1-d(s))*o;E.transition(0).transform("translate3d(0,0,0) scale("+p+")"),l.params.swipeToStep&&E.css("border-radius",T*o+"px")}if(n.transition(0).transform("translate3d(0,"+w+"px,0)"),l.params.swipeToStep)a=g?1-w/b:(b-w)/b,a=Math.min(Math.max(a,0),1),n.trigger("sheet:stepprogress",a),l.emit("local::stepProgress sheetStepProgress",l,a)}}function L(){if(D=!1,I){I=!1,n.transform("").transition(""),l.push&&s&&(E.transition("").transform(""),E.css("border-radius",""));var e=v<0?"to-bottom":"to-top",t=Math.abs(v);if(0!==t&&w!==y){var a=(new Date).getTime()-m;if(l.params.swipeToStep){var r=g?"to-bottom":"to-top",i=g?"to-top":"to-bottom",o=Math.abs(w),p=Math.abs(b);if(a<300&&t>10)return e===r&&o<p&&(n.removeClass("modal-in-swipe-step"),n.trigger("sheet:stepprogress",1),l.emit("local::stepProgress sheetStepProgress",l,1),n.trigger("sheet:stepopen"),l.emit("local::stepOpen sheetStepOpen",l),l.push&&s&&(l.$htmlEl[0].style.setProperty("--f7-sheet-push-scale",d(s)),E.css("border-radius",""))),e===i&&o>p&&(l.params.swipeToClose?l.close():(n.addClass("modal-in-swipe-step"),n.trigger("sheet:stepprogress",0),l.emit("local::stepProgress sheetStepProgress",l,0),n.trigger("sheet:stepclose"),l.emit("local::stepClose sheetStepClose",l),l.push&&s&&(l.$htmlEl[0].style.removeProperty("--f7-sheet-push-scale"),E.css("border-radius","0px")))),void(e===i&&o<=p&&(n.addClass("modal-in-swipe-step"),n.trigger("sheet:stepprogress",0),l.emit("local::stepProgress sheetStepProgress",l,0),n.trigger("sheet:stepclose"),l.emit("local::stepClose sheetStepClose",l),l.push&&s&&(l.$htmlEl[0].style.removeProperty("--f7-sheet-push-scale"),E.css("border-radius","0px"))));if(a>=300){var c=!n.hasClass("modal-in-swipe-step");c?c&&(o>p+(C-p)/2?l.params.swipeToClose&&l.close():o>p/2&&(n.addClass("modal-in-swipe-step"),n.trigger("sheet:stepprogress",0),l.emit("local::stepProgress sheetStepProgress",l,0),n.trigger("sheet:stepclose"),l.emit("local::stepClose sheetStepClose",l),l.push&&s&&(l.$htmlEl[0].style.removeProperty("--f7-sheet-push-scale"),E.css("border-radius","0px")))):o<p/2?(n.removeClass("modal-in-swipe-step"),n.trigger("sheet:stepprogress",1),l.emit("local::stepProgress sheetStepProgress",l,1),n.trigger("sheet:stepopen"),l.emit("local::stepOpen sheetStepOpen",l),l.push&&s&&(l.$htmlEl[0].style.setProperty("--f7-sheet-push-scale",d(s)),E.css("border-radius",""))):o-p>(C-p)/2&&l.params.swipeToClose&&l.close()}}else{if(e!==(g?"to-top":"to-bottom"))return;(a<300&&t>20||a>=300&&t>C/2)&&l.close()}}}}function z(){l.setSwipeStep(!0)}l.setSwipeStep=function(e){void 0===e&&(e=!0);var t=n.find(".sheet-modal-swipe-step").eq(0);t.length&&(b=n.hasClass("sheet-modal-top")?-(t.offset().top-n.offset().top+t[0].offsetHeight):n[0].offsetHeight-(t.offset().top-n.offset().top+t[0].offsetHeight),n[0].style.setProperty("--f7-sheet-swipe-step",b+"px"),e||n.addClass("modal-in-swipe-step"))};var A=!!Support.passiveListener&&{passive:!0};return(l.params.swipeToClose||l.params.swipeToStep)&&(n.on(t.touchEvents.start,B,A),t.on("touchmove",R),t.on("touchend:passive",L),l.once("sheetDestroy",(function(){n.off(t.touchEvents.start,B,A),t.off("touchmove",R),t.off("touchend:passive",L)}))),l.on("open",(function(){l.params.closeOnEscape&&$(doc).on("keydown",c),l.params.swipeToStep&&(l.setSwipeStep(!1),t.on("resize",z)),l.params.scrollToEl&&function(){var e=$(l.params.scrollToEl).eq(0);if(0!==e.length&&0!==(o=e.parents(".page-content")).length){var t,a=parseInt(o.css("padding-top"),10),r=parseInt(o.css("padding-bottom"),10),i=o[0].offsetHeight-a-n.height(),s=o[0].scrollHeight-a-n.height(),p=o.scrollTop(),c=e.offset().top-a+e[0].offsetHeight;if(c>i){var d=p+c-i;d+i>s&&(t=d+i-s+r,i===s&&(t=n.height()),o.css({"padding-bottom":t+"px"})),o.scrollTop(d,300)}}}(),l.push&&(s=parseInt(n.css("--f7-sheet-push-offset"),10),Number.isNaN(s)&&(s=0),s&&(n.addClass("sheet-modal-push"),l.$htmlEl.addClass("with-modal-sheet-push"),l.params.swipeToStep?(E=t.root.children(".view, .views"),T=parseFloat(n.css("border-"+(g?"bottom":"top")+"-left-radius")),E.css("border-radius","0px")):l.$htmlEl[0].style.setProperty("--f7-sheet-push-scale",d(s))))})),l.on("opened",(function(){(l.params.closeByOutsideClick||l.params.closeByBackdropClick)&&t.on("click",p)})),l.on("close",(function(){l.params.swipeToStep&&(n.removeClass("modal-in-swipe-step"),t.off("resize",z)),l.params.closeOnEscape&&$(doc).off("keydown",c),l.params.scrollToEl&&o&&o.length>0&&o.css({"padding-bottom":""}),(l.params.closeByOutsideClick||l.params.closeByBackdropClick)&&t.off("click",p),l.push&&s&&(l.$htmlEl.removeClass("with-modal-sheet-push"),l.$htmlEl.addClass("with-modal-sheet-push-closing"))})),l.on("closed",(function(){l.push&&s&&(l.$htmlEl.removeClass("with-modal-sheet-push-closing"),l.$htmlEl[0].style.removeProperty("--f7-sheet-push-scale"))})),l.stepOpen=function(){n.removeClass("modal-in-swipe-step"),l.push&&(s||(s=parseInt(n.css("--f7-sheet-push-offset"),10),Number.isNaN(s)&&(s=0)),s&&l.$htmlEl[0].style.setProperty("--f7-sheet-push-scale",d(s)))},l.stepClose=function(){n.addClass("modal-in-swipe-step"),l.push&&l.$htmlEl[0].style.removeProperty("--f7-sheet-push-scale")},l.stepToggle=function(){n.toggleClass("modal-in-swipe-step")},n[0].f7Modal=l,l}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t}(Modal),Sheet$1={name:"sheet",params:{sheet:{push:!1,backdrop:void 0,backdropEl:void 0,closeByBackdropClick:!0,closeByOutsideClick:!1,closeOnEscape:!1,swipeToClose:!1,swipeToStep:!1,swipeHandler:null}},static:{Sheet:Sheet},create:function(){var e=this;e.sheet=Utils.extend({},ModalMethods({app:e,constructor:Sheet,defaultSelector:".sheet-modal.modal-in"}),{stepOpen:function(t){var a=e.sheet.get(t);if(a&&a.stepOpen)return a.stepOpen()},stepClose:function(t){var a=e.sheet.get(t);if(a&&a.stepClose)return a.stepClose()},stepToggle:function(t){var a=e.sheet.get(t);if(a&&a.stepToggle)return a.stepToggle()}})},clicks:{".sheet-open":function(e,t){void 0===t&&(t={});$(".sheet-modal.modal-in").length>0&&t.sheet&&$(t.sheet)[0]!==$(".sheet-modal.modal-in")[0]&&this.sheet.close(".sheet-modal.modal-in"),this.sheet.open(t.sheet,t.animate)},".sheet-close":function(e,t){void 0===t&&(t={});this.sheet.close(t.sheet,t.animate)}}},Toast=function(e){function t(t,a){var r=Utils.extend({on:{}},t.params.toast,a);e.call(this,t,r);var n=this;n.app=t,n.params=r;var i,o,s=n.params,l=s.closeButton,p=s.closeTimeout;if(n.params.el)i=$(n.params.el);else{var c=n.render();i=$(c)}return i&&i.length>0&&i[0].f7Modal?i[0].f7Modal:0===i.length?n.destroy():(Utils.extend(n,{$el:i,el:i[0],type:"toast"}),i[0].f7Modal=n,l&&(i.find(".toast-button").on("click",(function(){n.emit("local::closeButtonClick toastCloseButtonClick",n),n.close()})),n.on("beforeDestroy",(function(){i.find(".toast-button").off("click")}))),n.on("open",(function(){$(".toast.modal-in").each((function(e,a){var r=t.toast.get(a);a!==n.el&&r&&r.close()})),p&&(o=Utils.nextTick((function(){n.close()}),p))})),n.on("close",(function(){win.clearTimeout(o)})),n.params.destroyOnClose&&n.once("closed",(function(){setTimeout((function(){n.destroy()}),0)})),n)}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t.prototype.render=function(){if(this.params.render)return this.params.render.call(this,this);var e=this.params,t=e.position,a=e.cssClass,r=e.icon,n=e.text,i=e.closeButton,o=e.closeButtonColor,s=e.closeButtonText;return('\n      <div class="toast toast-'+t+" "+(a||"")+" "+(r?"toast-with-icon":"")+'">\n        <div class="toast-content">\n          '+(r?'<div class="toast-icon">'+r+"</div>":"")+'\n          <div class="toast-text">'+n+"</div>\n          "+(i&&!r?('\n          <a class="toast-button button '+(o?"color-"+o:"")+'">'+s+"</a>\n          ").trim():"")+"\n        </div>\n      </div>\n    ").trim()},t}(Modal),Toast$1={name:"toast",static:{Toast:Toast},create:function(){var e=this;e.toast=Utils.extend({},ModalMethods({app:e,constructor:Toast,defaultSelector:".toast.modal-in"}),{show:function(t){return Utils.extend(t,{destroyOnClose:!0}),new Toast(e,t).open()}})},params:{toast:{icon:null,text:null,position:"bottom",closeButton:!1,closeButtonColor:null,closeButtonText:"Ok",closeTimeout:null,cssClass:null,render:null}}},Preloader={init:function(e){var t=$(e);0===t.length||t.children(".preloader-inner").length>0||t.children(".preloader-inner-line").length>0||t.append(Utils[this.theme+"PreloaderContent"])},visible:!1,show:function(e){void 0===e&&(e="white");if(!Preloader.visible){var t=Utils[this.theme+"PreloaderContent"]||"";$("html").addClass("with-modal-preloader"),this.root.append('\n      <div class="preloader-backdrop"></div>\n      <div class="preloader-modal">\n        <div class="preloader color-'+e+'">'+t+"</div>\n      </div>\n    "),Preloader.visible=!0}},showIn:function(e,t){void 0===t&&(t="white");var a=Utils[this.theme+"PreloaderContent"]||"";$(e||"html").addClass("with-modal-preloader"),$(e||this.root).append('\n      <div class="preloader-backdrop"></div>\n      <div class="preloader-modal">\n        <div class="preloader color-'+t+'">'+a+"</div>\n      </div>\n    ")},hide:function(){Preloader.visible&&($("html").removeClass("with-modal-preloader"),this.root.find(".preloader-backdrop, .preloader-modal").remove(),Preloader.visible=!1)},hideIn:function(e){$(e||"html").removeClass("with-modal-preloader"),$(e||this.root).find(".preloader-backdrop, .preloader-modal").remove()}},Preloader$1={name:"preloader",create:function(){Utils.extend(this,{preloader:{init:Preloader.init.bind(this),show:Preloader.show.bind(this),hide:Preloader.hide.bind(this),showIn:Preloader.showIn.bind(this),hideIn:Preloader.hideIn.bind(this)}})},on:{photoBrowserOpen:function(e){var t=this;e.$el.find(".preloader").each((function(e,a){t.preloader.init(a)}))},tabMounted:function(e){var t=this;$(e).find(".preloader").each((function(e,a){t.preloader.init(a)}))},pageInit:function(e){var t=this;e.$el.find(".preloader").each((function(e,a){t.preloader.init(a)}))}},vnode:{preloader:{insert:function(e){var t=e.elm;this.preloader.init(t)}}}},Progressbar={set:function(){for(var e,t=[],a=arguments.length;a--;)t[a]=arguments[a];var r=this,n=t[0],i=t[1],o=t[2];if("number"==typeof t[0]&&(i=(e=t)[0],o=e[1],n=r.root),null==i)return n;i||(i=0);var s=$(n||r.root);if(0===s.length)return n;var l,p=Math.min(Math.max(i,0),100);if(0===(l=s.hasClass("progressbar")?s.eq(0):s.children(".progressbar")).length||l.hasClass("progressbar-infinite"))return l;var c=l.children("span");return 0===c.length&&(c=$("<span></span>"),l.append(c)),c.transition(void 0!==o?o:"").transform("translate3d("+(-100+p)+"%,0,0)"),l[0]},show:function(){for(var e,t,a=[],r=arguments.length;r--;)a[r]=arguments[r];var n=this,i=a[0],o=a[1],s=a[2],l="determined";2===a.length?"string"!=typeof a[0]&&"object"!=typeof a[0]||"string"!=typeof a[1]?"number"==typeof a[0]&&"string"==typeof a[1]&&(o=(t=a)[0],s=t[1],i=n.root):(i=(e=a)[0],s=e[1],o=e[2],l="infinite"):1===a.length?"number"==typeof a[0]?(i=n.root,o=a[0]):"string"==typeof a[0]&&(l="infinite",i=n.root,s=a[0]):0===a.length&&(l="infinite",i=n.root);var p,c=$(i);if(0!==c.length)return c.hasClass("progressbar")||c.hasClass("progressbar-infinite")?p=c:0===(p=c.children(".progressbar:not(.progressbar-out), .progressbar-infinite:not(.progressbar-out)")).length&&(p=$('\n          <span class="progressbar'+("infinite"===l?"-infinite":"")+(s?" color-"+s:"")+' progressbar-in">\n            '+("infinite"===l?"":"<span></span>")+"\n          </span>"),c.append(p)),void 0!==o&&n.progressbar.set(p,o),p[0]},hide:function(e,t){void 0===t&&(t=!0);var a,r=$(e||this.root);if(0!==r.length)return 0===(a=r.hasClass("progressbar")||r.hasClass("progressbar-infinite")?r:r.children(".progressbar, .progressbar-infinite")).length||!a.hasClass("progressbar-in")||a.hasClass("progressbar-out")||a.removeClass("progressbar-in").addClass("progressbar-out").animationEnd((function(){t&&a.remove()})),a}},Progressbar$1={name:"progressbar",create:function(){Utils.extend(this,{progressbar:{set:Progressbar.set.bind(this),show:Progressbar.show.bind(this),hide:Progressbar.hide.bind(this)}})},on:{tabMounted:function(e){var t=this;$(e).find(".progressbar").each((function(e,a){var r=$(a);t.progressbar.set(r,r.attr("data-progress"))}))},pageInit:function(e){var t=this;e.$el.find(".progressbar").each((function(e,a){var r=$(a);t.progressbar.set(r,r.attr("data-progress"))}))}},vnode:{progressbar:{insert:function(e){var t=e.elm;this.progressbar.set(t,t.getAttribute("data-progress"))},update:function(e){var t=e.elm;this.progressbar.set(t,t.getAttribute("data-progress"))}}}},Sortable={init:function(){var e,t,a,r,n,i,o,s,l,p,c,d,u,h,f,m,v,g,b,y,w,C=this;function x(r,s){t=!1,e=!0,w=!1,a="touchstart"===r.type?r.targetTouches[0].pageY:r.pageY,n=$(r.target).closest("li").eq(0),u=n.index(),o=n.parents(".sortable");var l=n.parents(".list-group");l.length&&l.parents(o).length&&(o=l),i=o.children("ul").children("li:not(.disallow-sorting):not(.no-sorting)"),C.panel&&(C.panel.allowOpen=!1),C.swipeout&&(C.swipeout.allow=!1),s&&(n.addClass("sorting"),o.addClass("sortable-sorting"),w=!0)}var k=!!C.support.passiveListener&&{passive:!1,capture:!1};$(doc).on(C.touchEvents.start,".list.sortable .sortable-handler",x,k),C.on("touchmove:active",(function(u){if(e&&n){var w="touchmove"===u.type?u.targetTouches[0].pageY:u.pageY;if(!t){h=n.parents(".page"),f=n.parents(".page-content");var C=parseInt(f.css("padding-top"),10),x=parseInt(f.css("padding-bottom"),10);y=f[0].scrollTop,v=h.offset().top+C,m=h.height()-C-x,n.addClass("sorting"),o.addClass("sortable-sorting"),g=n[0].offsetTop,l=n[0].offsetTop,p=n.parent().height()-g-n.height(),s=n[0].offsetHeight,b=n.offset().top}t=!0,u.preventDefault(),u.f7PreventSwipePanel=!0,r=w-a;var k=f[0].scrollTop-y,E=Math.min(Math.max(r+k,-l),p);n.transform("translate3d(0,"+E+"px,0)");var T,S=!0;r+k+44<-l&&(S=!1),r+k-44>p&&(S=!1),d=void 0,c=void 0,S&&(b+r+s+44>v+m&&(T=b+r+s+44-(v+m)),b+r<v+44&&(T=b+r-v-44),T&&(f[0].scrollTop+=T)),i.each((function(e,t){var a=$(t);if(a[0]!==n[0]){var r=a[0].offsetTop,i=a.height(),o=g+E;o>=r-i/2&&n.index()<a.index()?(a.transform("translate3d(0, "+-s+"px,0)"),c=a,d=void 0):o<=r+i/2&&n.index()>a.index()?(a.transform("translate3d(0, "+s+"px,0)"),c=void 0,d||(d=a)):a.transform("translate3d(0, 0%,0)")}}))}})),C.on("touchend:passive",(function(){if(!e||!t)return e&&!t&&(C.panel&&(C.panel.allowOpen=!0),C.swipeout&&(C.swipeout.allow=!0),w&&(n.removeClass("sorting"),o.removeClass("sortable-sorting"))),e=!1,void(t=!1);var a;C.panel&&(C.panel.allowOpen=!0),C.swipeout&&(C.swipeout.allow=!0),i.transform(""),n.removeClass("sorting"),o.removeClass("sortable-sorting"),c?a=c.index():d&&(a=d.index());var r=o.dataset().sortableMoveElements;if(void 0===r&&(r=C.params.sortable.moveElements),r&&(c&&n.insertAfter(c),d&&n.insertBefore(d)),(c||d)&&o.hasClass("virtual-list")){void 0===(u=n[0].f7VirtualListIndex)&&(u=n.attr("data-virtual-list-index")),d?void 0===(a=d[0].f7VirtualListIndex)&&(a=d.attr("data-virtual-list-index")):void 0===(a=c[0].f7VirtualListIndex)&&(a=c.attr("data-virtual-list-index")),a=null!==a?parseInt(a,10):void 0;var s=o[0].f7VirtualList;u&&(u=parseInt(u,10)),a&&(a=parseInt(a,10)),s&&s.moveItem(u,a)}void 0===a||Number.isNaN(a)||a===u||(n.trigger("sortable:sort",{from:u,to:a}),C.emit("sortableSort",n[0],{from:u,to:a,el:n[0]},o[0])),d=void 0,c=void 0,e=!1,t=!1})),$(doc).on("taphold",".sortable-tap-hold",(function(e,t){x(t,!0)}))},enable:function(e){void 0===e&&(e=".list.sortable");var t=$(e);0!==t.length&&(t.addClass("sortable-enabled"),t.trigger("sortable:enable"),this.emit("sortableEnable",t[0]))},disable:function(e){void 0===e&&(e=".list.sortable");var t=$(e);0!==t.length&&(t.removeClass("sortable-enabled"),t.trigger("sortable:disable"),this.emit("sortableDisable",t[0]))},toggle:function(e){void 0===e&&(e=".list.sortable");var t=$(e);0!==t.length&&(t.hasClass("sortable-enabled")?this.sortable.disable(t):this.sortable.enable(t))}},Sortable$1={name:"sortable",params:{sortable:{moveElements:!0}},create:function(){Utils.extend(this,{sortable:{init:Sortable.init.bind(this),enable:Sortable.enable.bind(this),disable:Sortable.disable.bind(this),toggle:Sortable.toggle.bind(this)}})},on:{init:function(){this.params.sortable&&this.sortable.init()}},clicks:{".sortable-enable":function(e,t){void 0===t&&(t={});this.sortable.enable(t.sortable)},".sortable-disable":function(e,t){void 0===t&&(t={});this.sortable.disable(t.sortable)},".sortable-toggle":function(e,t){void 0===t&&(t={});this.sortable.toggle(t.sortable)}}},Swipeout={init:function(){var e,t,a,r,n,i,o,s,l,p,c,d,u,h,f,m,v,g,b,y,w,C=this,x={};var k=!!C.support.passiveListener&&{passive:!0};C.on("touchstart",(function(e){if(Swipeout.el){var t=$(e.target);$(Swipeout.el).is(t[0])||t.parents(".swipeout").is(Swipeout.el)||t.hasClass("modal-in")||(t.attr("class")||"").indexOf("-backdrop")>0||t.hasClass("actions-modal")||t.parents(".actions-modal.modal-in, .dialog.modal-in").length>0||C.swipeout.close(Swipeout.el)}})),$(doc).on(C.touchEvents.start,"li.swipeout",(function(n){Swipeout.allow&&(t=!1,e=!0,a=void 0,x.x="touchstart"===n.type?n.targetTouches[0].pageX:n.pageX,x.y="touchstart"===n.type?n.targetTouches[0].pageY:n.pageY,r=(new Date).getTime(),i=$(this))}),k),C.on("touchmove:active",(function(r){if(e){var k="touchmove"===r.type?r.targetTouches[0].pageX:r.pageX,E="touchmove"===r.type?r.targetTouches[0].pageY:r.pageY;if(void 0===a&&(a=!!(a||Math.abs(E-x.y)>Math.abs(k-x.x))),a)e=!1;else{if(!t){if($(".list.sortable-opened").length>0)return;o=i.find(".swipeout-content"),s=i.find(".swipeout-actions-right"),l=i.find(".swipeout-actions-left"),p=null,c=null,f=null,m=null,b=null,g=null,l.length>0&&(p=l.outerWidth(),f=l.children("a"),g=l.find(".swipeout-overswipe")),s.length>0&&(c=s.outerWidth(),m=s.children("a"),b=s.find(".swipeout-overswipe")),(u=i.hasClass("swipeout-opened"))&&(h=i.find(".swipeout-actions-left.swipeout-actions-opened").length>0?"left":"right"),i.removeClass("swipeout-transitioning"),C.params.swipeout.noFollow||(i.find(".swipeout-actions-opened").removeClass("swipeout-actions-opened"),i.removeClass("swipeout-opened"))}if(t=!0,r.preventDefault(),n=k-x.x,d=n,u&&("right"===h?d-=c:d+=p),d>0&&0===l.length||d<0&&0===s.length){if(!u)return e=!1,t=!1,o.transform(""),m&&m.length>0&&m.transform(""),void(f&&f.length>0&&f.transform(""));d=0}var T,S;if(d<0?v="to-left":d>0?v="to-right":v||(v="to-left"),r.f7PreventSwipePanel=!0,C.params.swipeout.noFollow)return u?("right"===h&&n>0&&C.swipeout.close(i),"left"===h&&n<0&&C.swipeout.close(i)):(n<0&&s.length>0&&C.swipeout.open(i,"right"),n>0&&l.length>0&&C.swipeout.open(i,"left")),e=!1,void(t=!1);if(y=!1,w=!1,s.length>0){var M=d;S=M/c,M<-c&&(M=-c-Math.pow(-M-c,.8),d=M,b.length>0&&(w=!0)),"to-left"!==v&&(S=0,M=0),m.each((function(e,t){var a=$(t);void 0===t.f7SwipeoutButtonOffset&&(a[0].f7SwipeoutButtonOffset=t.offsetLeft),T=t.f7SwipeoutButtonOffset,b.length>0&&a.hasClass("swipeout-overswipe")&&"to-left"===v&&(a.css({left:(w?-T:0)+"px"}),w?(a.hasClass("swipeout-overswipe-active")||(i.trigger("swipeout:overswipeenter"),C.emit("swipeoutOverswipeEnter",i[0])),a.addClass("swipeout-overswipe-active")):(a.hasClass("swipeout-overswipe-active")&&(i.trigger("swipeout:overswipeexit"),C.emit("swipeoutOverswipeExit",i[0])),a.removeClass("swipeout-overswipe-active"))),a.transform("translate3d("+(M-T*(1+Math.max(S,-1)))+"px,0,0)")}))}if(l.length>0){var P=d;S=P/p,P>p&&(P=p+Math.pow(P-p,.8),d=P,g.length>0&&(y=!0)),"to-right"!==v&&(P=0,S=0),f.each((function(e,t){var a=$(t);void 0===t.f7SwipeoutButtonOffset&&(a[0].f7SwipeoutButtonOffset=p-t.offsetLeft-t.offsetWidth),T=t.f7SwipeoutButtonOffset,g.length>0&&a.hasClass("swipeout-overswipe")&&"to-right"===v&&(a.css({left:(y?T:0)+"px"}),y?(a.hasClass("swipeout-overswipe-active")||(i.trigger("swipeout:overswipeenter"),C.emit("swipeoutOverswipeEnter",i[0])),a.addClass("swipeout-overswipe-active")):(a.hasClass("swipeout-overswipe-active")&&(i.trigger("swipeout:overswipeexit"),C.emit("swipeoutOverswipeExit",i[0])),a.removeClass("swipeout-overswipe-active"))),f.length>1&&a.css("z-index",f.length-e),a.transform("translate3d("+(P+T*(1-Math.min(S,1)))+"px,0,0)")}))}i.trigger("swipeout",S),C.emit("swipeout",i[0],S),o.transform("translate3d("+d+"px,0,0)")}}})),C.on("touchend:passive",(function(){if(!e||!t)return e=!1,void(t=!1);e=!1,t=!1;var a,h,g,b,x=(new Date).getTime()-r,k="to-left"===v?s:l,E="to-left"===v?c:p;if(a=x<300&&(n<-10&&"to-left"===v||n>10&&"to-right"===v)||x>=300&&Math.abs(d)>E/2?"open":"close",x<300&&(0===Math.abs(d)&&(a="close"),Math.abs(d)===E&&(a="open")),"open"===a){Swipeout.el=i[0],i.trigger("swipeout:open"),C.emit("swipeoutOpen",i[0]),i.addClass("swipeout-opened swipeout-transitioning");var T="to-left"===v?-E:E;if(o.transform("translate3d("+T+"px,0,0)"),k.addClass("swipeout-actions-opened"),h="to-left"===v?m:f)for(g=0;g<h.length;g+=1)$(h[g]).transform("translate3d("+T+"px,0,0)");w&&s.find(".swipeout-overswipe").trigger("click","f7Overswipe"),y&&l.find(".swipeout-overswipe").trigger("click","f7Overswipe")}else i.trigger("swipeout:close"),C.emit("swipeoutClose",i[0]),Swipeout.el=void 0,i.addClass("swipeout-transitioning").removeClass("swipeout-opened"),o.transform(""),k.removeClass("swipeout-actions-opened");f&&f.length>0&&f!==h&&f.each((function(e,t){var a=$(t);void 0===(b=t.f7SwipeoutButtonOffset)&&(a[0].f7SwipeoutButtonOffset=p-t.offsetLeft-t.offsetWidth),a.transform("translate3d("+b+"px,0,0)")})),m&&m.length>0&&m!==h&&m.each((function(e,t){var a=$(t);void 0===(b=t.f7SwipeoutButtonOffset)&&(a[0].f7SwipeoutButtonOffset=t.offsetLeft),a.transform("translate3d("+-b+"px,0,0)")})),o.transitionEnd((function(){u&&"open"===a||!u&&"close"===a||(i.trigger("open"===a?"swipeout:opened":"swipeout:closed"),C.emit("open"===a?"swipeoutOpened":"swipeoutClosed",i[0]),i.removeClass("swipeout-transitioning"),u&&"close"===a&&(s.length>0&&m.transform(""),l.length>0&&f.transform("")))}))}))},allow:!0,el:void 0,open:function(){for(var e,t=[],a=arguments.length;a--;)t[a]=arguments[a];var r=this,n=t[0],i=t[1],o=t[2];"function"==typeof t[1]&&(n=(e=t)[0],o=e[1],i=e[2]);var s=$(n).eq(0);if(0!==s.length&&s.hasClass("swipeout")&&!s.hasClass("swipeout-opened")){i||(i=s.find(".swipeout-actions-right").length>0?"right":"left");var l=s.find(".swipeout-actions-"+i),p=s.find(".swipeout-content");if(0!==l.length){s.trigger("swipeout:open").addClass("swipeout-opened").removeClass("swipeout-transitioning"),r.emit("swipeoutOpen",s[0]),l.addClass("swipeout-actions-opened");var c=l.children("a"),d=l.outerWidth(),u="right"===i?-d:d;c.length>1&&c.each((function(e,t){var a=$(t);"right"===i?a.transform("translate3d("+-t.offsetLeft+"px,0,0)"):a.css("z-index",c.length-e).transform("translate3d("+(d-t.offsetWidth-t.offsetLeft)+"px,0,0)")})),s.addClass("swipeout-transitioning"),p.transitionEnd((function(){s.trigger("swipeout:opened"),r.emit("swipeoutOpened",s[0]),o&&o.call(s[0])})),Utils.nextFrame((function(){c.transform("translate3d("+u+"px,0,0)"),p.transform("translate3d("+u+"px,0,0)")})),Swipeout.el=s[0]}}},close:function(e,t){var a=this,r=$(e).eq(0);if(0!==r.length&&r.hasClass("swipeout-opened")){var n,i=r.find(".swipeout-actions-opened").hasClass("swipeout-actions-right")?"right":"left",o=r.find(".swipeout-actions-opened").removeClass("swipeout-actions-opened"),s=o.children("a"),l=o.outerWidth();Swipeout.allow=!1,r.trigger("swipeout:close"),a.emit("swipeoutClose",r[0]),r.removeClass("swipeout-opened").addClass("swipeout-transitioning"),r.find(".swipeout-content").transform("").transitionEnd(p),n=setTimeout(p,500),s.each((function(e,t){var a=$(t);"right"===i?a.transform("translate3d("+-t.offsetLeft+"px,0,0)"):a.transform("translate3d("+(l-t.offsetWidth-t.offsetLeft)+"px,0,0)"),a.css({left:"0px"}).removeClass("swipeout-overswipe-active")})),Swipeout.el&&Swipeout.el===r[0]&&(Swipeout.el=void 0)}function p(){Swipeout.allow=!0,r.hasClass("swipeout-opened")||(r.removeClass("swipeout-transitioning"),s.transform(""),r.trigger("swipeout:closed"),a.emit("swipeoutClosed",r[0]),t&&t.call(r[0]),n&&clearTimeout(n))}},delete:function(e,t){var a=this,r=$(e).eq(0);0!==r.length&&(Swipeout.el=void 0,r.trigger("swipeout:delete"),a.emit("swipeoutDelete",r[0]),r.css({height:r.outerHeight()+"px"}),r.transitionEnd((function(){if(r.trigger("swipeout:deleted"),a.emit("swipeoutDeleted",r[0]),t&&t.call(r[0]),r.parents(".virtual-list").length>0){var e=r.parents(".virtual-list")[0].f7VirtualList,n=r[0].f7VirtualListIndex;e&&void 0!==n&&e.deleteItem(n)}else a.params.swipeout.removeElements?a.params.swipeout.removeElementsWithTimeout?setTimeout((function(){r.remove()}),a.params.swipeout.removeElementsTimeout):r.remove():r.removeClass("swipeout-deleting swipeout-transitioning")})),Utils.nextFrame((function(){r.addClass("swipeout-deleting swipeout-transitioning").css({height:"0px"}).find(".swipeout-content").transform("translate3d(-100%,0,0)")})))}},Swipeout$1={name:"swipeout",params:{swipeout:{actionsNoFold:!1,noFollow:!1,removeElements:!0,removeElementsWithTimeout:!1,removeElementsTimeout:0}},create:function(){Utils.extend(this,{swipeout:{init:Swipeout.init.bind(this),open:Swipeout.open.bind(this),close:Swipeout.close.bind(this),delete:Swipeout.delete.bind(this)}}),Object.defineProperty(this.swipeout,"el",{enumerable:!0,configurable:!0,get:function(){return Swipeout.el},set:function(e){Swipeout.el=e}}),Object.defineProperty(this.swipeout,"allow",{enumerable:!0,configurable:!0,get:function(){return Swipeout.allow},set:function(e){Swipeout.allow=e}})},clicks:{".swipeout-open":function(e,t){void 0===t&&(t={});this.swipeout.open(t.swipeout,t.side)},".swipeout-close":function(e){var t=e.closest(".swipeout");0!==t.length&&this.swipeout.close(t)},".swipeout-delete":function(e,t){void 0===t&&(t={});var a=this,r=e.closest(".swipeout");if(0!==r.length){var n=t.confirm,i=t.confirmTitle;t.confirm?a.dialog.confirm(n,i,(function(){a.swipeout.delete(r)})):a.swipeout.delete(r)}}},on:{init:function(){this.params.swipeout&&this.swipeout.init()}}},Accordion={toggleClicked:function(e){var t=e.closest(".accordion-item").eq(0);t.length||(t=e.parents("li").eq(0));var a=e.parents(".accordion-item-content").eq(0);a.length&&a.parents(t).length||e.parents("li").length>1&&e.parents("li")[0]!==t[0]||this.accordion.toggle(t)},open:function(e){var t=this,a=$(e),r=!1;function n(){r=!0}if(a.trigger("accordion:beforeopen",{prevent:n},n),t.emit("accordionBeforeOpen",a[0],n),!r){var i=a.parents(".accordion-list").eq(0),o=a.children(".accordion-item-content");if(o.removeAttr("aria-hidden"),0===o.length&&(o=a.find(".accordion-item-content")),0!==o.length){var s=i.length>0&&a.parent().children(".accordion-item-opened");s.length>0&&t.accordion.close(s),o.transitionEnd((function(){a.hasClass("accordion-item-opened")?(o.transition(0),o.css("height","auto"),Utils.nextFrame((function(){o.transition(""),a.trigger("accordion:opened"),t.emit("accordionOpened",a[0])}))):(o.css("height",""),a.trigger("accordion:closed"),t.emit("accordionClosed",a[0]))})),o.css("height",o[0].scrollHeight+"px"),a.trigger("accordion:open"),a.addClass("accordion-item-opened"),t.emit("accordionOpen",a[0])}}},close:function(e){var t=this,a=$(e),r=!1;function n(){r=!0}if(a.trigger("accordion:beforeclose",{prevent:n},n),t.emit("accordionBeforeClose",a[0],n),!r){var i=a.children(".accordion-item-content");0===i.length&&(i=a.find(".accordion-item-content")),a.removeClass("accordion-item-opened"),i.attr("aria-hidden",!0),i.transition(0),i.css("height",i[0].scrollHeight+"px"),i.transitionEnd((function(){a.hasClass("accordion-item-opened")?(i.transition(0),i.css("height","auto"),Utils.nextFrame((function(){i.transition(""),a.trigger("accordion:opened"),t.emit("accordionOpened",a[0])}))):(i.css("height",""),a.trigger("accordion:closed"),t.emit("accordionClosed",a[0]))})),Utils.nextFrame((function(){i.transition(""),i.css("height",""),a.trigger("accordion:close"),t.emit("accordionClose",a[0])}))}},toggle:function(e){var t=$(e);0!==t.length&&(t.hasClass("accordion-item-opened")?this.accordion.close(e):this.accordion.open(e))}},Accordion$1={name:"accordion",create:function(){Utils.extend(this,{accordion:{open:Accordion.open.bind(this),close:Accordion.close.bind(this),toggle:Accordion.toggle.bind(this)}})},clicks:{".accordion-item .item-link, .accordion-item-toggle, .links-list.accordion-list > ul > li > a":function(e){Accordion.toggleClicked.call(this,e)}}},ContactsList={name:"contactsList"},VirtualList=function(e){function t(t,a){void 0===a&&(a={}),e.call(this,a,[t]);var r,n=this;"md"===t.theme?r=48:"ios"===t.theme?r=44:"aurora"===t.theme&&(r=38);var i={cols:1,height:r,cache:!0,dynamicHeightBufferSize:1,showFilteredItemsOnly:!1,renderExternal:void 0,setListHeight:!0,searchByItem:void 0,searchAll:void 0,itemTemplate:void 0,ul:null,createUl:!0,scrollableParentEl:void 0,renderItem:function(e){return('\n          <li>\n            <div class="item-content">\n              <div class="item-inner">\n                <div class="item-title">'+e+"</div>\n              </div>\n            </div>\n          </li>\n        ").trim()},on:{}};if(n.useModulesParams(i),n.params=Utils.extend(i,a),void 0!==n.params.height&&n.params.height||(n.params.height=r),n.$el=$(a.el),n.el=n.$el[0],0!==n.$el.length){n.$el[0].f7VirtualList=n,n.items=n.params.items,n.params.showFilteredItemsOnly&&(n.filteredItems=[]),n.params.itemTemplate?"string"==typeof n.params.itemTemplate?n.renderItem=t.t7.compile(n.params.itemTemplate):"function"==typeof n.params.itemTemplate&&(n.renderItem=n.params.itemTemplate):n.params.renderItem&&(n.renderItem=n.params.renderItem),n.$pageContentEl=n.$el.parents(".page-content"),n.pageContentEl=n.$pageContentEl[0],n.$scrollableParentEl=n.params.scrollableParentEl?$(n.params.scrollableParentEl).eq(0):n.$pageContentEl,!n.$scrollableParentEl.length&&n.$pageContentEl.length&&(n.$scrollableParentEl=n.$pageContentEl),n.scrollableParentEl=n.$scrollableParentEl[0],void 0!==n.params.updatableScroll?n.updatableScroll=n.params.updatableScroll:(n.updatableScroll=!0,Device.ios&&Device.osVersion.split(".")[0]<8&&(n.updatableScroll=!1));var o,s=n.params.ul;n.$ul=s?$(n.params.ul):n.$el.children("ul"),0===n.$ul.length&&n.params.createUl&&(n.$el.append("<ul></ul>"),n.$ul=n.$el.children("ul")),n.ul=n.$ul[0],o=n.ul||n.params.createUl?n.$ul:n.$el,Utils.extend(n,{$itemsWrapEl:o,itemsWrapEl:o[0],domCache:{},displayDomCache:{},tempDomElement:doc.createElement("ul"),lastRepaintY:null,fragment:doc.createDocumentFragment(),pageHeight:void 0,rowsPerScreen:void 0,rowsBefore:void 0,rowsAfter:void 0,rowsToRender:void 0,maxBufferHeight:0,listHeight:void 0,dynamicHeight:"function"==typeof n.params.height}),n.useModules();var l,p,c,d,u=n.handleScroll.bind(n),h=n.handleResize.bind(n);return n.attachEvents=function(){l=n.$el.parents(".page").eq(0),p=n.$el.parents(".tab").eq(0),c=n.$el.parents(".panel").eq(0),d=n.$el.parents(".popup").eq(0),n.$scrollableParentEl.on("scroll",u),l&&l.on("page:reinit",h),p&&p.on("tab:show",h),c&&c.on("panel:open",h),d&&d.on("popup:open",h),t.on("resize",h)},n.detachEvents=function(){n.$scrollableParentEl.off("scroll",u),l&&l.off("page:reinit",h),p&&p.off("tab:show",h),c&&c.off("panel:open",h),d&&d.off("popup:open",h),t.off("resize",h)},n.init(),n}}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t.prototype.setListSize=function(){var e=this,t=e.filteredItems||e.items;if(e.pageHeight=e.$scrollableParentEl[0].offsetHeight,e.dynamicHeight){e.listHeight=0,e.heights=[];for(var a=0;a<t.length;a+=1){var r=e.params.height(t[a]);e.listHeight+=r,e.heights.push(r)}}else e.listHeight=Math.ceil(t.length/e.params.cols)*e.params.height,e.rowsPerScreen=Math.ceil(e.pageHeight/e.params.height),e.rowsBefore=e.params.rowsBefore||2*e.rowsPerScreen,e.rowsAfter=e.params.rowsAfter||e.rowsPerScreen,e.rowsToRender=e.rowsPerScreen+e.rowsBefore+e.rowsAfter,e.maxBufferHeight=e.rowsBefore/2*e.params.height;(e.updatableScroll||e.params.setListHeight)&&e.$itemsWrapEl.css({height:e.listHeight+"px"})},t.prototype.render=function(e,t){var a=this;e&&(a.lastRepaintY=null);var r=-(a.$el[0].getBoundingClientRect().top-a.$scrollableParentEl[0].getBoundingClientRect().top);if(void 0!==t&&(r=t),null===a.lastRepaintY||Math.abs(r-a.lastRepaintY)>a.maxBufferHeight||!a.updatableScroll&&a.$scrollableParentEl[0].scrollTop+a.pageHeight>=a.$scrollableParentEl[0].scrollHeight){a.lastRepaintY=r;var n,i,o,s=a.filteredItems||a.items,l=0,p=0;if(a.dynamicHeight){var c,d=0;a.maxBufferHeight=a.pageHeight;for(var u=0;u<a.heights.length;u+=1)c=a.heights[u],void 0===n&&(d+c>=r-2*a.pageHeight*a.params.dynamicHeightBufferSize?n=u:l+=c),void 0===i&&((d+c>=r+2*a.pageHeight*a.params.dynamicHeightBufferSize||u===a.heights.length-1)&&(i=u+1),p+=c),d+=c;i=Math.min(i,s.length)}else(n=(parseInt(r/a.params.height,10)-a.rowsBefore)*a.params.cols)<0&&(n=0),i=Math.min(n+a.rowsToRender*a.params.cols,s.length);var h,f=[];for(a.reachEnd=!1,h=n;h<i;h+=1){var m=void 0,v=a.items.indexOf(s[h]);h===n&&(a.currentFromIndex=v),h===i-1&&(a.currentToIndex=v),a.filteredItems?a.items[v]===a.filteredItems[a.filteredItems.length-1]&&(a.reachEnd=!0):v===a.items.length-1&&(a.reachEnd=!0),a.params.renderExternal?f.push(s[h]):a.domCache[v]?(m=a.domCache[v]).f7VirtualListIndex=v:(a.renderItem?a.tempDomElement.innerHTML=a.renderItem(s[h],v).trim():a.tempDomElement.innerHTML=s[h].toString().trim(),m=a.tempDomElement.childNodes[0],a.params.cache&&(a.domCache[v]=m),m.f7VirtualListIndex=v),h===n&&(o=a.dynamicHeight?l:h*a.params.height/a.params.cols),a.params.renderExternal||(m.style.top=o+"px",a.emit("local::itemBeforeInsert vlItemBeforeInsert",a,m,s[h]),a.fragment.appendChild(m))}a.updatableScroll||(a.dynamicHeight?a.itemsWrapEl.style.height=p+"px":a.itemsWrapEl.style.height=h*a.params.height/a.params.cols+"px"),a.params.renderExternal?s&&0===s.length&&(a.reachEnd=!0):(a.emit("local::beforeClear vlBeforeClear",a,a.fragment),a.itemsWrapEl.innerHTML="",a.emit("local::itemsBeforeInsert vlItemsBeforeInsert",a,a.fragment),s&&0===s.length?(a.reachEnd=!0,a.params.emptyTemplate&&(a.itemsWrapEl.innerHTML=a.params.emptyTemplate)):a.itemsWrapEl.appendChild(a.fragment),a.emit("local::itemsAfterInsert vlItemsAfterInsert",a,a.fragment)),void 0!==t&&e&&a.$scrollableParentEl.scrollTop(t,0),a.params.renderExternal&&a.params.renderExternal(a,{fromIndex:n,toIndex:i,listHeight:a.listHeight,topPosition:o,items:f})}},t.prototype.filterItems=function(e,t){void 0===t&&(t=!0);var a=this;a.filteredItems=[];for(var r=0;r<e.length;r+=1)a.filteredItems.push(a.items[e[r]]);t&&(a.$scrollableParentEl[0].scrollTop=0),a.update()},t.prototype.resetFilter=function(){var e=this;e.params.showFilteredItemsOnly?e.filteredItems=[]:(e.filteredItems=null,delete e.filteredItems),e.update()},t.prototype.scrollToItem=function(e){var t=this;if(e>t.items.length)return!1;var a=0;if(t.dynamicHeight)for(var r=0;r<e;r+=1)a+=t.heights[r];else a=e*t.params.height;var n=t.$el[0].offsetTop;return t.render(!0,n+a-parseInt(t.$scrollableParentEl.css("padding-top"),10)),!0},t.prototype.handleScroll=function(){this.render()},t.prototype.isVisible=function(){return!!(this.el.offsetWidth||this.el.offsetHeight||this.el.getClientRects().length)},t.prototype.handleResize=function(){this.isVisible()&&(this.setListSize(),this.render(!0))},t.prototype.appendItems=function(e){for(var t=0;t<e.length;t+=1)this.items.push(e[t]);this.update()},t.prototype.appendItem=function(e){this.appendItems([e])},t.prototype.replaceAllItems=function(e){this.items=e,delete this.filteredItems,this.domCache={},this.update()},t.prototype.replaceItem=function(e,t){this.items[e]=t,this.params.cache&&delete this.domCache[e],this.update()},t.prototype.prependItems=function(e){for(var t=this,a=e.length-1;a>=0;a-=1)t.items.unshift(e[a]);if(t.params.cache){var r={};Object.keys(t.domCache).forEach((function(a){r[parseInt(a,10)+e.length]=t.domCache[a]})),t.domCache=r}t.update()},t.prototype.prependItem=function(e){this.prependItems([e])},t.prototype.moveItem=function(e,t){var a=this,r=e,n=t;if(r!==n){var i=a.items.splice(r,1)[0];if(n>=a.items.length?(a.items.push(i),n=a.items.length-1):a.items.splice(n,0,i),a.params.cache){var o={};Object.keys(a.domCache).forEach((function(e){var t=parseInt(e,10),i=r<n?r:n,s=r<n?n:r,l=r<n?-1:1;(t<i||t>s)&&(o[t]=a.domCache[t]),t===i&&(o[s]=a.domCache[t]),t>i&&t<=s&&(o[t+l]=a.domCache[t])})),a.domCache=o}a.update()}},t.prototype.insertItemBefore=function(e,t){var a=this;if(0!==e)if(e>=a.items.length)a.appendItem(t);else{if(a.items.splice(e,0,t),a.params.cache){var r={};Object.keys(a.domCache).forEach((function(t){var n=parseInt(t,10);n>=e&&(r[n+1]=a.domCache[n])})),a.domCache=r}a.update()}else a.prependItem(t)},t.prototype.deleteItems=function(e){for(var t,a=this,r=0,n=function(n){var i=e[n];void 0!==t&&i>t&&(r=-n),i+=r,t=e[n];var o=a.items.splice(i,1)[0];if(a.filteredItems&&a.filteredItems.indexOf(o)>=0&&a.filteredItems.splice(a.filteredItems.indexOf(o),1),a.params.cache){var s={};Object.keys(a.domCache).forEach((function(e){var t=parseInt(e,10);t===i?delete a.domCache[i]:parseInt(e,10)>i?s[t-1]=a.domCache[e]:s[t]=a.domCache[e]})),a.domCache=s}},i=0;i<e.length;i+=1)n(i);a.update()},t.prototype.deleteAllItems=function(){var e=this;e.items=[],delete e.filteredItems,e.params.cache&&(e.domCache={}),e.update()},t.prototype.deleteItem=function(e){this.deleteItems([e])},t.prototype.clearCache=function(){this.domCache={}},t.prototype.update=function(e){e&&this.params.cache&&(this.domCache={}),this.setListSize(),this.render(!0)},t.prototype.init=function(){this.attachEvents(),this.setListSize(),this.render()},t.prototype.destroy=function(){var e=this;e.detachEvents(),e.$el[0].f7VirtualList=null,delete e.$el[0].f7VirtualList,Utils.deleteProps(e),e=null},t}(Framework7Class),VirtualList$1={name:"virtualList",static:{VirtualList:VirtualList},create:function(){this.virtualList=ConstructorMethods({defaultSelector:".virtual-list",constructor:VirtualList,app:this,domProp:"f7VirtualList"})}},ListIndex=function(e){function t(t,a){void 0===a&&(a={}),e.call(this,a,[t]);var r,n,i,o,s=this,l={el:null,listEl:null,indexes:"auto",iosItemHeight:14,mdItemHeight:14,auroraItemHeight:14,scrollList:!0,label:!1,renderItem:function(e,t){return("\n          <li>"+e+"</li>\n        ").trim()},renderSkipPlaceholder:function(){return'<li class="list-index-skip-placeholder"></li>'},on:{}};if(s.useModulesParams(l),s.params=Utils.extend(l,a),!s.params.el)return s;if((r=$(s.params.el))[0].f7ListIndex)return r[0].f7ListIndex;if(0===(o=r.find("ul")).length&&(o=$("<ul></ul>"),r.append(o)),s.params.listEl&&(n=$(s.params.listEl)),"auto"===s.params.indexes&&!n)return s;function p(){var e={index:s};s.calcSize(),e!==s.height&&s.render()}function c(e){var t=$(e.target).closest("li");if(t.length){var a=t.index();if(s.skipRate>0){var r=a/(t.siblings("li").length-1);a=Math.round((s.indexes.length-1)*r)}var n=s.indexes[a];s.$el.trigger("listindex:click",{content:n,index:a}),s.emit("local::click listIndexClick",s,n,a),s.$el.trigger("listindex:select",{content:n,index:a}),s.emit("local::select listIndexSelect",s,n,a),s.$listEl&&s.params.scrollList&&s.scrollListToIndex(n,a)}}n?i=n.parents(".page-content").eq(0):0===(i=r.siblings(".page-content").eq(0)).length&&(i=r.parents(".page").eq(0).find(".page-content").eq(0)),r[0].f7ListIndex=s,Utils.extend(s,{app:t,$el:r,el:r&&r[0],$ul:o,ul:o&&o[0],$listEl:n,listEl:n&&n[0],$pageContentEl:i,pageContentEl:i&&i[0],indexes:a.indexes,height:0,skipRate:0}),s.useModules();var d,u,h,f,m,v={},g=null;function b(e){var t=o.children();t.length&&(h=t[0].getBoundingClientRect().top,f=t[t.length-1].getBoundingClientRect().top+t[0].offsetHeight,v.x="touchstart"===e.type?e.targetTouches[0].pageX:e.pageX,v.y="touchstart"===e.type?e.targetTouches[0].pageY:e.pageY,d=!0,u=!1,g=null)}function y(e){if(d){!u&&s.params.label&&(m=$('<span class="list-index-label"></span>'),r.append(m)),u=!0;var t="touchmove"===e.type?e.targetTouches[0].pageY:e.pageY;e.preventDefault();var a=(t-h)/(f-h);a=Math.min(Math.max(a,0),1);var n=Math.round((s.indexes.length-1)*a),i=s.indexes[n],o=f-h,l=(s.height-o)/2+(1-a)*o;n!==g&&(s.params.label&&m.html(i).transform("translateY(-"+l+"px)"),s.$listEl&&s.params.scrollList&&s.scrollListToIndex(i,n)),g=n,s.$el.trigger("listindex:select"),s.emit("local::select listIndexSelect",s,i,n)}}function w(){d&&(d=!1,u=!1,s.params.label&&(m&&m.remove(),m=void 0))}var C=!!t.support.passiveListener&&{passive:!0};return s.attachEvents=function(){r.parents(".tab").on("tab:show",p),r.parents(".page").on("page:reinit",p),r.parents(".panel").on("panel:open",p),r.parents(".sheet-modal, .actions-modal, .popup, .popover, .login-screen, .dialog, .toast").on("modal:open",p),t.on("resize",p),r.on("click",c),r.on(t.touchEvents.start,b,C),t.on("touchmove:active",y),t.on("touchend:passive",w)},s.detachEvents=function(){r.parents(".tab").off("tab:show",p),r.parents(".page").off("page:reinit",p),r.parents(".panel").off("panel:open",p),r.parents(".sheet-modal, .actions-modal, .popup, .popover, .login-screen, .dialog, .toast").off("modal:open",p),t.off("resize",p),r.off("click",c),r.off(t.touchEvents.start,b,C),t.off("touchmove:active",y),t.off("touchend:passive",w)},s.init(),s}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t.prototype.scrollListToIndex=function(e,t){var a,r=this.$listEl,n=this.$pageContentEl,i=this.app;if(!r||!n||0===n.length)return this;if(r.find(".list-group-title, .item-divider").each((function(t,r){if(!a){var n=$(r);n.text()===e&&(a=n)}})),!a||0===a.length)return this;var o=a.parent().offset().top,s=parseInt(n.css("padding-top"),10),l=n[0].scrollTop,p=a.offset().top;if(n.parents(".page-with-navbar-large").length){var c=$(i.navbar.getElByPage(n.parents(".page-with-navbar-large").eq(0))).find(".title-large");c.length&&(s-=c[0].offsetHeight||0)}return o<=s?n.scrollTop(o+l-s):n.scrollTop(p+l-s),this},t.prototype.renderSkipPlaceholder=function(){return this.params.renderSkipPlaceholder.call(this)},t.prototype.renderItem=function(e,t){return this.params.renderItem.call(this,e,t)},t.prototype.render=function(){var e,t=this,a=t.$ul,r=t.indexes,n=t.skipRate,i=r.map((function(a,r){if(r%n!=0&&n>0)return e=!0,"";var i=t.renderItem(a,r);return e&&(i=t.renderSkipPlaceholder()+i),e=!1,i})).join("");return a.html(i),t},t.prototype.calcSize=function(){var e=this.app,t=this.params,a=this.el,r=this.indexes,n=a.offsetHeight,i=t[e.theme+"ItemHeight"],o=Math.floor(n/i),s=r.length,l=0;return s>o&&(l=Math.ceil((2*s-1)/o)),this.height=n,this.skipRate=l,this},t.prototype.calcIndexes=function(){var e=this;return"auto"===e.params.indexes?(e.indexes=[],e.$listEl.find(".list-group-title, .item-divider").each((function(t,a){var r=$(a).text();e.indexes.indexOf(r)<0&&e.indexes.push(r)}))):e.indexes=e.params.indexes,e},t.prototype.update=function(){return this.calcIndexes(),this.calcSize(),this.render(),this},t.prototype.init=function(){this.calcIndexes(),this.calcSize(),this.render(),this.attachEvents()},t.prototype.destroy=function(){var e=this;e.$el.trigger("listindex:beforedestroy",e),e.emit("local::beforeDestroy listIndexBeforeDestroy"),e.detachEvents(),e.$el[0]&&(e.$el[0].f7ListIndex=null,delete e.$el[0].f7ListIndex),Utils.deleteProps(e),e=null},t}(Framework7Class),ListIndex$1={name:"listIndex",static:{ListIndex:ListIndex},create:function(){this.listIndex=ConstructorMethods({defaultSelector:".list-index",constructor:ListIndex,app:this,domProp:"f7ListIndex"})},on:{tabMounted:function(e){var t=this;$(e).find(".list-index-init").each((function(e,a){var r=Utils.extend($(a).dataset(),{el:a});t.listIndex.create(r)}))},tabBeforeRemove:function(e){$(e).find(".list-index-init").each((function(e,t){t.f7ListIndex&&t.f7ListIndex.destroy()}))},pageInit:function(e){var t=this;e.$el.find(".list-index-init").each((function(e,a){var r=Utils.extend($(a).dataset(),{el:a});t.listIndex.create(r)}))},pageBeforeRemove:function(e){e.$el.find(".list-index-init").each((function(e,t){t.f7ListIndex&&t.f7ListIndex.destroy()}))}},vnode:{"list-index-init":{insert:function(e){var t=e.elm,a=Utils.extend($(t).dataset(),{el:t});this.listIndex.create(a)},destroy:function(e){var t=e.elm;t.f7ListIndex&&t.f7ListIndex.destroy()}}}},Timeline={name:"timeline"},Tab={show:function(){for(var e,t,a,r=[],n=arguments.length;n--;)r[n]=arguments[n];var i,o,s,l,p=this;1===r.length&&r[0].constructor===Object?(i=r[0].tabEl,o=r[0].tabLinkEl,s=r[0].animate,l=r[0].tabRoute):(i=(e=r)[0],o=e[1],s=e[2],l=e[3],"boolean"==typeof r[1]&&(i=(t=r)[0],s=t[1],o=t[2],l=t[3],r.length>2&&o.constructor===Object&&(i=(a=r)[0],s=a[1],l=a[2],o=a[3]))),void 0===s&&(s=!0);var c,d=$(i);if(l&&d[0]&&(d[0].f7TabRoute=l),0===d.length||d.hasClass("tab-active"))return{$newTabEl:d,newTabEl:d[0]};o&&(c=$(o));var u=d.parent(".tabs");if(0===u.length)return{$newTabEl:d,newTabEl:d[0]};p.swipeout&&(p.swipeout.allowOpen=!0);var h=[];function f(e){h.push(e)}function m(){h.forEach((function(e){e()}))}var v,g=!1;if(u.parent().hasClass("tabs-animated-wrap")){u.parent()[s?"removeClass":"addClass"]("not-animated");var b=parseFloat(u.css("transition-duration").replace(",","."));s&&b&&(u.transitionEnd(m),g=!0);var y=100*(p.rtl?d.index():-d.index());u.transform("translate3d("+y+"%,0,0)")}u.parent().hasClass("tabs-swipeable-wrap")&&p.swiper&&((v=u.parent()[0].swiper)&&v.activeIndex!==d.index()?(g=!0,v.once("slideChangeTransitionEnd",(function(){m()})).slideTo(d.index(),s?void 0:0)):v&&v.animating&&(g=!0,v.once("slideChangeTransitionEnd",(function(){m()}))));var w=u.children(".tab-active");if(w.removeClass("tab-active"),(!v||v&&!v.animating||v&&l)&&(w.trigger("tab:hide"),p.emit("tabHide",w[0])),d.addClass("tab-active"),(!v||v&&!v.animating||v&&l)&&(d.trigger("tab:show"),p.emit("tabShow",d[0])),!c&&((!(c=$("string"==typeof i?'.tab-link[href="'+i+'"]':'.tab-link[href="#'+d.attr("id")+'"]'))||c&&0===c.length)&&$("[data-tab]").each((function(e,t){d.is($(t).attr("data-tab"))&&(c=$(t))})),l&&(!c||c&&0===c.length)&&0===(c=$('[data-route-tab-id="'+l.route.tab.id+'"]')).length&&(c=$('.tab-link[href="'+l.url+'"]')),c.length>1&&d.parents(".page").length&&(c=c.filter((function(e,t){return $(t).parents(".page")[0]===d.parents(".page")[0]})),"ios"===p.theme&&0===c.length&&l))){var C=d.parents(".page"),x=$(p.navbar.getElByPage(C));0===(c=x.find('[data-route-tab-id="'+l.route.tab.id+'"]')).length&&(c=x.find('.tab-link[href="'+l.url+'"]'))}if(c.length>0){var k;if(w&&w.length>0){var E=w.attr("id");E&&(!(k=$('.tab-link[href="#'+E+'"]'))||k&&0===k.length)&&(k=$('.tab-link[data-route-tab-id="'+E+'"]')),(!k||k&&0===k.length)&&$("[data-tab]").each((function(e,t){w.is($(t).attr("data-tab"))&&(k=$(t))})),(!k||k&&0===k.length)&&(k=c.siblings(".tab-link-active"))}else l&&(k=c.siblings(".tab-link-active"));if(k&&k.length>1&&w&&w.parents(".page").length&&(k=k.filter((function(e,t){return $(t).parents(".page")[0]===w.parents(".page")[0]}))),k&&k.length>0&&k.removeClass("tab-link-active"),c&&c.length>0&&(c.addClass("tab-link-active"),"md"===p.theme&&p.toolbar)){var T=c.parents(".tabbar, .tabbar-labels");T.length>0&&p.toolbar.setHighlight(T)}}return{$newTabEl:d,newTabEl:d[0],$oldTabEl:w,oldTabEl:w[0],onTabsChanged:f,animated:g}}},Tabs={name:"tabs",create:function(){Utils.extend(this,{tab:{show:Tab.show.bind(this)}})},clicks:{".tab-link":function(e,t){void 0===t&&(t={});(e.attr("href")&&0===e.attr("href").indexOf("#")||e.attr("data-tab"))&&this.tab.show({tabEl:t.tab||e.attr("href"),tabLinkEl:e,animate:t.animate})}}};function swipePanel(e){var t=e.app;if(!e.swipeInitialized){Utils.extend(e,{swipeable:!0,swipeInitialized:!0});var a,r,n,i,o,s,l,p,c,d,u,h,f=e.params,m=e.$el,v=e.$backdropEl,g=e.side,b=e.effect,y={},w=0;t.on("touchstart:passive",C),t.on("touchmove:active",x),t.on("touchend:passive",k),t.on("gesturestart",E),t.on("gestureend",T),e.on("panelDestroy",(function(){t.off("touchstart:passive",C),t.off("touchmove:active",x),t.off("touchend:passive",k),t.off("gesturestart",E),t.off("gestureend",T)}))}function C(l){if(e.swipeable&&!n&&t.panel.allowOpen&&(f.swipe||f.swipeOnlyClose)&&!r&&!($(".modal-in:not(.toast):not(.notification), .photo-browser-in").length>0)){var p=(a=t.panel.get("left"===g?"right":"left")||{}).opened&&a.$el&&!a.$el.hasClass("panel-in-breakpoint");if((e.opened||!p)&&(f.swipeOnlyClose||!p)&&(!l.target||"input"!==l.target.nodeName.toLowerCase()||"range"!==l.target.type)&&!($(l.target).closest(".range-slider, .tabs-swipeable-wrap, .calendar-months, .no-swipe-panel, .card-opened").length>0)&&(y.x="touchstart"===l.type?l.targetTouches[0].pageX:l.pageX,y.y="touchstart"===l.type?l.targetTouches[0].pageY:l.pageY,!f.swipeOnlyClose||e.opened)){if(f.swipeActiveArea&&!e.opened){if("left"===g&&y.x>f.swipeActiveArea)return;if("right"===g&&y.x<t.width-f.swipeActiveArea)return}w=0,h=$(e.getViewEl()),i=!1,r=!0,o=void 0,s=Utils.now(),u=void 0}}}function x(a){if(r&&!n&&!((w+=1)<2))if(a.f7PreventSwipePanel||t.preventSwipePanelBySwipeBack||t.preventSwipePanel)r=!1;else{var s="touchmove"===a.type?a.targetTouches[0].pageX:a.pageX,C="touchmove"===a.type?a.targetTouches[0].pageY:a.pageY;if(void 0===o&&(o=!!(o||Math.abs(C-y.y)>Math.abs(s-y.x))),o)r=!1;else{if(!u){if(u=s>y.x?"to-right":"to-left",f.swipeActiveArea>0&&!e.opened){if("left"===g&&y.x>f.swipeActiveArea)return void(r=!1);if("right"===g&&y.x<t.width-f.swipeActiveArea)return void(r=!1)}if(m.hasClass("panel-in-breakpoint"))return void(r=!1);if("left"===g&&"to-left"===u&&!m.hasClass("panel-in")||"right"===g&&"to-right"===u&&!m.hasClass("panel-in"))return void(r=!1)}var x=e.opened?0:-f.swipeThreshold;"right"===g&&(x=-x),i||(e.opened||(e.insertToRoot(),m.addClass("panel-in-swipe"),v.css("visibility","visible"),m.trigger("panel:swipeopen"),e.emit("local::swipeOpen panelSwipeOpen",e)),d=m[0].offsetWidth,"reveal"===b&&m.hasClass("panel-in-collapsed")&&(d-=parseFloat(h.css("margin-"+g))),m.transition(0)),i=!0,a.preventDefault(),l=s-y.x+x,"right"===g?"cover"===b?((p=l+(e.opened?0:d))<0&&(p=0),p>d&&(p=d)):((p=l-(e.opened?d:0))>0&&(p=0),p<-d&&(p=-d)):((p=l+(e.opened?d:0))<0&&(p=0),p>d&&(p=d)),"reveal"===b?(h.transform("translate3d("+p+"px,0,0)").transition(0),v.transform("translate3d("+p+"px,0,0)").transition(0),m.trigger("panel:swipe",Math.abs(p/d)),e.emit("local::swipe panelSwipe",e,Math.abs(p/d))):("left"===g&&(p-=d),m.transform("translate3d("+p+"px,0,0)").transition(0),v.transition(0),c=1-Math.abs(p/d),v.css({opacity:c}),m.trigger("panel:swipe",Math.abs(p/d)),e.emit("local::swipe panelSwipe",e,Math.abs(p/d)))}}}function k(t){if(!r||!i)return r=!1,void(i=!1);var a="gesturestart"===t.type||n;r=!1,i=!1;var o,c=(new Date).getTime()-s,u=0===p||Math.abs(p)===d,y=f.swipeThreshold||0;"swap"===(o=a?"reset":e.opened?"cover"===b?0===p?"reset":c<300&&Math.abs(p)>0?"swap":c>=300&&Math.abs(p)<d/2?"reset":"swap":p===-d?"reset":c<300&&Math.abs(p)>=0||c>=300&&Math.abs(p)<=d/2?"left"===g&&p===d?"reset":"swap":"reset":Math.abs(l)<y?"reset":"cover"===b?0===p||c<300&&Math.abs(p)>0||c>=300&&Math.abs(p)<d/2?"swap":"reset":0===p?"reset":c<300&&Math.abs(p)>0||c>=300&&Math.abs(p)>=d/2?"swap":"reset")&&(e.opened?e.close(!u):e.open(!u));var w=!0;if("reset"===o&&!e.opened)if(u)m.removeClass("panel-in-swipe");else{w=!1;var C="reveal"===b?h:m;$("html").addClass("with-panel-closing"),C.transitionEnd((function(){m.hasClass("panel-in")||(m.removeClass("panel-in-swipe"),$("html").removeClass("with-panel-closing"))}))}"reveal"===b&&Utils.nextFrame((function(){h.transition(""),h.transform("")})),w&&m.removeClass("panel-in-swipe"),m.transition("").transform(""),v.transform("").transition("").css({opacity:"",visibility:""})}function E(e){n=!0,k(e)}function T(){n=!1}}function resizablePanel(e){var t=e.app;if(!e.resizableInitialized){Utils.extend(e,{resizable:!0,resizableWidth:null,resizableInitialized:!0});var a=$("html"),r=e.$el,n=e.$backdropEl,i=e.side,o=e.effect;if(r){var s,l,p,c,d,u,h,f,m={};0===e.$el.find(".panel-resize-handler").length&&e.$el.append('<div class="panel-resize-handler"></div>'),e.$resizeHandlerEl=e.$el.children(".panel-resize-handler"),r.addClass("panel-resizable");var v=!!Support.passiveListener&&{passive:!0};e.$el.on(t.touchEvents.start,".panel-resize-handler",b,v),t.on("touchmove:active",y),t.on("touchend:passive",w),t.on("resize",C),e.on("beforeOpen",C),e.once("panelDestroy",(function(){r.removeClass("panel-resizable"),e.$resizeHandlerEl.remove(),e.$el.off(t.touchEvents.start,".panel-resize-handler",b,v),t.off("touchmove:active",y),t.off("touchend:passive",w),t.off("resize",C),e.off("beforeOpen",C)}))}}function g(e){if(!e)return null;if(e.indexOf("%")>=0||e.indexOf("vw")>=0)return parseInt(e,10)/100*t.width;var a=parseInt(e,10);return Number.isNaN(a)?null:a}function b(t){e.resizable&&r.hasClass("panel-resizable")&&(m.x="touchstart"===t.type?t.targetTouches[0].pageX:t.pageX,m.y="touchstart"===t.type?t.targetTouches[0].pageY:t.pageY,l=!1,s=!0,u=g(r.css("min-width")),h=g(r.css("max-width")),f=r.hasClass("panel-in-breakpoint"))}function y(v){if(s){var g="touchmove"===v.type?v.targetTouches[0].pageX:v.pageX;l||(c=r[0].offsetWidth,r.transition(0),r.addClass("panel-resizing"),a.css("cursor","col-resize"),("reveal"===o||f)&&(d=$(e.getViewEl())),"reveal"!==o||f||(n.transition(0),d.transition(0))),l=!0,v.preventDefault(),p=g-m.x;var b="left"===i?c+p:c-p;u&&!Number.isNaN(u)&&(b=Math.max(b,u)),h&&!Number.isNaN(h)&&(b=Math.min(b,h)),b=Math.min(Math.max(b,0),t.width),e.resizableWidth=b,r[0].style.width=b+"px","reveal"!==o||f?f&&d&&d.css("margin-"+i,b+"px"):(d&&d.transform("translate3d("+("left"===i?b:-b)+"px, 0, 0)"),n&&n.transform("translate3d("+("left"===i?b:-b)+"px, 0, 0)")),r.trigger("panel:resize",b),e.emit("local::resize panelResize",e,b)}}function w(){if($("html").css("cursor",""),!s||!l)return s=!1,void(l=!1);s=!1,l=!1,a[0].style.setProperty("--f7-panel-"+i+"-width",e.resizableWidth+"px"),r[0].style.width="","reveal"!==o||f||(d.transform(""),n.transform("")),r.removeClass("panel-resizing"),Utils.nextFrame((function(){f||(r.transition(""),"reveal"===o&&(n.transition(""),d&&d.transition("")))}))}function C(){e.opened&&e.resizableWidth&&(u=g(r.css("min-width")),h=g(r.css("max-width")),u&&!Number.isNaN(u)&&e.resizableWidth<u&&(e.resizableWidth=Math.max(e.resizableWidth,u)),h&&!Number.isNaN(h)&&e.resizableWidth>h&&(e.resizableWidth=Math.min(e.resizableWidth,h)),e.resizableWidth=Math.min(Math.max(e.resizableWidth,0),t.width),a[0].style.setProperty("--f7-panel-"+i+"-width",e.resizableWidth+"px"))}}var Panel=function(e){function t(t,a){void 0===a&&(a={});var r=Utils.extend({on:{}},t.params.panel,a);e.call(this,r,[t]);var n;if(this.params=r,this.params.el?n=$(this.params.el).eq(0):this.params.content&&(n=$(this.params.content).filter((function(e,t){return 1===t.nodeType})).eq(0)),0===n.length)return this;if(n[0].f7Panel)return n[0].f7Panel;n[0].f7Panel=this;var i,o=this.params,s=o.side,l=o.effect,p=o.resizable;return void 0===s&&(s=n.hasClass("panel-left")?"left":"right"),void 0===l&&(l=n.hasClass("panel-cover")?"cover":"reveal"),void 0===p&&(p=n.hasClass("panel-resizable")),this.params.backdrop&&this.params.backdropEl?i=$(this.params.backdropEl):this.params.backdrop&&0===(i=t.root.children(".panel-backdrop")).length&&(i=$('<div class="panel-backdrop"></div>'),t.root.prepend(i)),Utils.extend(this,{app:t,side:s,effect:l,resizable:p,$el:n,el:n[0],opened:!1,$backdropEl:i,backdropEl:i&&i[0]}),this.useModules(),this.init(),this}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t.prototype.getViewEl=function(){var e=this.app;return e.root.children(".views").length>0?e.root.children(".views")[0]:e.root.children(".view")[0]},t.prototype.enableVisibleBreakpoint=function(){return this.visibleBreakpointDisabled=!1,this.setVisibleBreakpoint(),this},t.prototype.disableVisibleBreakpoint=function(){return this.visibleBreakpointDisabled=!0,this.setVisibleBreakpoint(),this},t.prototype.toggleVisibleBreakpoint=function(){return this.visibleBreakpointDisabled=!this.visibleBreakpointDisabled,this.setVisibleBreakpoint(),this},t.prototype.setVisibleBreakpoint=function(e){var t,a,r;void 0===e&&(e=!0);var n=this,i=n.app;n.visibleBreakpointResizeHandler||(n.visibleBreakpointResizeHandler=function(){n.setVisibleBreakpoint()},i.on("resize",n.visibleBreakpointResizeHandler));var o=n.side,s=n.$el,l=n.params,p=n.visibleBreakpointDisabled,c=l.visibleBreakpoint,d=$(n.getViewEl()),u=s.hasClass("panel-in-breakpoint");i.width>=c&&null!=c&&!p?u?d.css(((a={})["margin-"+o]=s.width()+"px",a)):($("html").removeClass("with-panel-"+o+"-reveal with-panel-"+o+"-cover with-panel"),s.addClass("panel-in-breakpoint").removeClass("panel-in panel-in-collapsed"),n.onOpen(!1),n.onOpened(),d.css(((t={})["margin-"+o]=s.width()+"px",t)),i.allowPanelOpen=!0,e&&(n.emit("local::breakpoint panelBreakpoint",n),n.$el.trigger("panel:breakpoint"))):u&&(s.removeClass("panel-in-breakpoint panel-in"),n.onClose(),n.onClosed(),d.css(((r={})["margin-"+o]="",r)),e&&(n.emit("local::breakpoint panelBreakpoint",n),n.$el.trigger("panel:breakpoint")))},t.prototype.enableCollapsedBreakpoint=function(){return this.collapsedBreakpointDisabled=!1,this.setCollapsedBreakpoint(),this},t.prototype.disableCollapsedBreakpoint=function(){return this.collapsedBreakpointDisabled=!0,this.setCollapsedBreakpoint(),this},t.prototype.toggleCollapsedBreakpoint=function(){return this.collapsedBreakpointDisabled=!this.collapsedBreakpointDisabled,this.setCollapsedBreakpoint(),this},t.prototype.setCollapsedBreakpoint=function(e){var t=this,a=t.app;t.collapsedBreakpointResizeHandler||(t.collapsedBreakpointResizeHandler=function(){t.setCollapsedBreakpoint()},a.on("resize",t.collapsedBreakpointResizeHandler));var r=t.side,n=t.$el,i=t.params,o=t.collapsedBreakpointDisabled;if(!n.hasClass("panel-in-breakpoint")){var s=i.collapsedBreakpoint,l=n.hasClass("panel-in-collapsed");a.width>=s&&null!=s&&!o?l||($("html").removeClass("with-panel-"+r+"-reveal with-panel-"+r+"-cover with-panel"),n.addClass("panel-in-collapsed").removeClass("panel-in"),t.collapsed=!0,a.allowPanelOpen=!0,e&&(t.emit("local::collapsedBreakpoint panelCollapsedBreakpoint",t),t.$el.trigger("panel:collapsedbreakpoint"))):l&&(n.removeClass("panel-in-collapsed panel-in"),t.collapsed=!1,e&&(t.emit("local::collapsedBreakpoint panelCollapsedBreakpoint",t),t.$el.trigger("panel:collapsedbreakpoint")))}},t.prototype.enableResizable=function(){return this.resizableInitialized?(this.resizable=!0,this.$el.addClass("panel-resizable")):resizablePanel(this),this},t.prototype.disableResizable=function(){return this.resizable=!1,this.$el.removeClass("panel-resizable"),this},t.prototype.enableSwipe=function(){return this.swipeInitialized?this.swipeable=!0:swipePanel(this),this},t.prototype.disableSwipe=function(){return this.swipeable=!1,this},t.prototype.onOpen=function(e){void 0===e&&(e=!0);var t=this.app;this.opened=!0,t.panel.allowOpen=!1,this.$el.trigger("panel:beforeopen"),this.emit("local::beforeOpen panelBeforeOpen",this),e&&$("html").addClass("with-panel with-panel-"+this.side+"-"+this.effect),this.$el.trigger("panel:open"),this.emit("local::open panelOpen",this)},t.prototype.onOpened=function(){this.app.panel.allowOpen=!0,this.$el.trigger("panel:opened"),this.emit("local::opened panelOpened",this)},t.prototype.onClose=function(){var e=this.app;this.opened=!1,e.panel.allowOpen=!1,this.$el.trigger("panel:beforeclose"),this.emit("local::beforeClose panelBeforeClose",this),$("html").addClass("with-panel-closing"),$("html").removeClass("with-panel with-panel-"+this.side+"-"+this.effect),this.$el.trigger("panel:close"),this.emit("local::close panelClose",this)},t.prototype.onClosed=function(){this.app.panel.allowOpen=!0,$("html").removeClass("with-panel-closing"),this.$el.removeClass("panel-out"),this.$el.trigger("panel:closed"),this.emit("local::closed panelClosed",this)},t.prototype.toggle=function(e){void 0===e&&(e=!0);var t=this.params.visibleBreakpoint;return this.app.width>=t&&null!=t?this.toggleVisibleBreakpoint():(this.opened?this.close(e):this.open(e),this)},t.prototype.insertToRoot=function(){var e=this.$el,t=this.app,a=this.$backdropEl,r=e.parent(),n=e.parents(document).length>0;if(!r.is(t.root)||e.prevAll(".views, .view").length){var i=t.root.children(".panel, .views, .view").eq(0),o=t.root.children(".panel-backdrop").eq(0);i.length?e.insertBefore(i):o?e.insertBefore(o):t.root.prepend(e),a&&a.length&&(!a.parent().is(t.root)&&0===a.nextAll(".panel").length||a.parent().is(t.root)&&0===a.nextAll(".panel").length)&&a.insertBefore(e),this.once("panelClosed",(function(){n?r.append(e):e.remove()}))}},t.prototype.open=function(e){void 0===e&&(e=!0);var t=this,a=t.app;if(!a.panel.allowOpen)return!1;var r=t.effect,n=t.$el,i=t.$backdropEl,o=t.opened;if(!n||n.hasClass("panel-in"))return t;if(t.insertToRoot(),o||n.hasClass("panel-in-breakpoint")||n.hasClass("panel-in"))return!1;var s=a.panel.get(".panel-in");s&&s!==t&&s.close(e),n[e?"removeClass":"addClass"]("not-animated"),n.addClass("panel-in"),i[e?"removeClass":"addClass"]("not-animated"),"cover"===t.effect&&(t._clientLeft=n[0].clientLeft);var l="reveal"===r?n.nextAll(".view, .views").eq(0):n;return e?(i&&i.removeClass("not-animated"),function e(){l.transitionEnd((function(a){$(a.target).is(l)?n.hasClass("panel-out")?t.onClosed():t.onOpened():e()}))}(),n.removeClass("panel-out not-animated").addClass("panel-in"),t.onOpen()):(i&&i.addClass("not-animated"),n.removeClass("panel-out").addClass("panel-in not-animated"),t.onOpen(),t.onOpened()),!0},t.prototype.close=function(e){void 0===e&&(e=!0);var t=this,a=t.effect,r=t.$el,n=t.$backdropEl;if(!t.opened||r.hasClass("panel-in-breakpoint")||!r.hasClass("panel-in"))return t;r[e?"removeClass":"addClass"]("not-animated"),n[e?"removeClass":"addClass"]("not-animated");var i="reveal"===a?r.nextAll(".view, .views").eq(0):r;return e?(i.transitionEnd((function(){r.hasClass("panel-out")?t.onClosed():r.hasClass("panel-in")&&t.onOpened(),$("html").removeClass("with-panel-closing")})),r.removeClass("panel-in").addClass("panel-out"),t.onClose()):(r.addClass("not-animated").removeClass("panel-in").addClass("panel-out"),t.onClose(),t.onClosed()),t},t.prototype.init=function(){void 0!==this.params.visibleBreakpoint&&this.setVisibleBreakpoint(),void 0!==this.params.collapsedBreakpoint&&this.setCollapsedBreakpoint(),this.params.swipe&&this.enableSwipe(),this.resizable&&this.enableResizable()},t.prototype.destroy=function(){var e,t=this,a=t.app;if(t.$el){if(t.emit("local::beforeDestroy panelBeforeDestroy",t),t.$el.trigger("panel:beforedestroy"),t.visibleBreakpointResizeHandler&&a.off("resize",t.visibleBreakpointResizeHandler),t.collapsedBreakpointResizeHandler&&a.off("resize",t.collapsedBreakpointResizeHandler),t.$el.hasClass("panel-in-breakpoint")||t.$el.hasClass("panel-in-collapsed")){var r=$(t.getViewEl());t.$el.removeClass("panel-in-breakpoint panel-in-collapsed panel-in"),r.css(((e={})["margin-"+t.side]="",e)),t.emit("local::breakpoint panelBreakpoint",t),t.$el.trigger("panel:breakpoint")}t.$el.trigger("panel:destroy"),t.emit("local::destroy panelDestroy",t),t.el&&(t.el.f7Panel=null,delete t.el.f7Panel),Utils.deleteProps(t),t=null}},t}(Framework7Class),Panel$1={name:"panel",params:{panel:{opened:void 0,side:void 0,effect:void 0,resizable:void 0,backdrop:!0,backdropEl:void 0,visibleBreakpoint:void 0,collapsedBreakpoint:void 0,swipe:!1,swipeOnlyClose:!1,swipeActiveArea:0,swipeThreshold:0,closeByBackdropClick:!0}},static:{Panel:Panel},instance:{panel:{allowOpen:!0}},create:function(){var e=this;Utils.extend(e.panel,{create:function(t){return new Panel(e,t)},get:function(e){if(void 0===e&&(e=".panel"),e instanceof Panel)return e;"left"!==e&&"right"!==e||(e=".panel-"+e);var t=$(e);return 0===t.length||t.length>1?void 0:t[0].f7Panel},destroy:function(t){void 0===t&&(t=".panel");var a=e.panel.get(t);if(a&&a.destroy)return a.destroy()},open:function(t,a){void 0===t&&(t=".panel"),"left"!==t&&"right"!==t||(t=".panel-"+t);var r=e.panel.get(t);return r&&r.open?r.open(a):r?void 0:(r=e.panel.create({el:t})).open(a)},close:function(t,a){void 0===t&&(t=".panel-in"),"left"!==t&&"right"!==t||(t=".panel-"+t);var r=e.panel.get(t);return r&&r.open?r.close(a):r?void 0:(r=e.panel.create({el:t})).close(a)},toggle:function(t,a){void 0===t&&(t=".panel"),"left"!==t&&"right"!==t||(t=".panel-"+t);var r=e.panel.get(t);return r&&r.toggle?r.toggle(a):r?void 0:(r=e.panel.create({el:t})).toggle(a)}})},on:{init:function(){var e=this;$(".panel-init").each((function(t,a){var r=Object.assign({el:a},$(a).dataset()||{});e.panel.create(r)}))},pageInit:function(e){var t=this;e.$el.find(".panel-init").each((function(e,a){var r=Object.assign({el:a},$(a).dataset()||{});t.panel.create(r)}))},pageBeforeRemove:function(e){var t=this;e.$el.find(".panel-init").each((function(e,a){var r=t.panel.get(a);r&&r.destroy&&r.destroy()}))}},vnode:{"panel-init":{insert:function(e){var t=e.elm,a=Object.assign({el:t},$(t).dataset()||{});this.panel.create(a)},destroy:function(e){var t=e.elm,a=this.panel.get(t);a&&a.destroy&&a.destroy()}}},clicks:{".panel-open":function(e,t){void 0===t&&(t={});this.panel.open(t.panel,t.animate)},".panel-close":function(e,t){void 0===t&&(t={});this.panel.close(t.panel,t.animate)},".panel-toggle":function(e,t){void 0===t&&(t={});this.panel.toggle(t.panel,t.animate)},".panel-backdrop":function(){var e=$(".panel-in:not(.panel-out)");if(e.length){var t=e[0]&&e[0].f7Panel;e.trigger("panel:backdrop-click"),t&&t.emit("backdropClick",t),this.emit("panelBackdropClick",t||e[0]),this.params.panel.closeByBackdropClick&&this.panel.close()}}}},CardExpandable={open:function(e,t){var a;void 0===e&&(e=".card-expandable"),void 0===t&&(t=!0);var r=this;if(!$(".card-opened").length){var n=$(e).eq(0);if(n&&n.length&&!(n.hasClass("card-opened")||n.hasClass("card-opening")||n.hasClass("card-closing"))){var i,o=n.parents(".page").eq(0);if(o.length)if(n.trigger("card:beforeopen",{prevent:X}),r.emit("cardBeforeOpen",n[0],X),!i){var s,l,p,c=Object.assign({animate:t},r.params.card,n.dataset()),d=n.parents(".page-content");n.attr("data-backdrop-el")&&(s=$(n.attr("data-backdrop-el"))),!s&&c.backdrop&&((s=d.find(".card-backdrop")).length||(s=$('<div class="card-backdrop"></div>'),d.append(s))),c.hideNavbarOnOpen&&((l=o.children(".navbar")).length||o[0].f7Page&&(l=o[0].f7Page.$navbarEl)),c.hideToolbarOnOpen&&((p=o.children(".toolbar")).length||(p=o.parents(".view").children(".toolbar")),p.length||(p=o.parents(".views").children(".toolbar")));var u,h=n.css("transform");h&&h.match(/[2-9]/)&&(u=!0);var f=n.children(".card-content"),m=$(document.createElement("div")).addClass("card-expandable-size");n.append(m);var v,g=n[0].offsetWidth,b=n[0].offsetHeight,y=o[0].offsetWidth,w=o[0].offsetHeight,C=m[0].offsetWidth||y,x=m[0].offsetHeight||w;l&&!c.hideStatusbarOnOpen&&x===w&&(v=parseInt(l.css("--f7-safe-area-top"),10),Number.isNaN(v)&&(v=0)),v&&(x-=v);var k,E,T=C/g,S=x/b,M=n.offset(),P=o.offset();if(v&&(P.top+=v/2),M.left-=P.left,u){var O=h.replace(/matrix\(|\)/g,"").split(",").map((function(e){return e.trim()}));if(O&&O.length>1){var D=parseFloat(O[0]);k=M.left-g*(1-D)/2,E=M.top-P.top-b*(1-D)/2,r.rtl&&(k-=n[0].scrollLeft)}else k=n[0].offsetLeft,E=n[0].offsetTop-(d.length?d[0].scrollTop:0)}else k=M.left,E=M.top-P.top,r.rtl&&(k-=n[0].scrollLeft);E-=(w-x)/2;var I=C-g-(k-=(y-C)/2);r.rtl&&(k=(a=[I,k])[0],I=a[1]);var B,R,L,z,A,H,U,N,F,V,q,j,_=x-b-E,Y=(I-k)/2,W=(_-E)/2;c.hideNavbarOnOpen&&l&&l.length&&(l.closest(".navbar-hidden").length?n[0].f7KeepNavbarOnClose=!0:(delete n[0].f7KeepNavbarOnClose,r.navbar.hide(l,c.animate,c.hideStatusbarOnOpen))),c.hideToolbarOnOpen&&p&&p.length&&(p.closest(".toolbar-hidden").length?n[0].f7KeepToolbarOnClose=!0:(delete n[0].f7KeepToolbarOnClose,r.toolbar.hide(p,c.animate))),s&&s.removeClass("card-backdrop-out").addClass("card-backdrop-in"),n.removeClass("card-transitioning"),c.animate&&n.addClass("card-opening"),n.trigger("card:open"),r.emit("cardOpen",n[0]),f.css({width:C+"px",height:x+"px"}).transform("translate3d("+(r.rtl?k+Y:-k-Y)+"px, 0px, 0) scale("+1/T+", "+1/S+")"),n.transform("translate3d("+(r.rtl?-Y:Y)+"px, "+W+"px, 0) scale("+T+", "+S+")"),c.animate?n.transitionEnd((function(){G()})):G(),n[0].detachEventHandlers=function(){r.off("resize",K),Support.touch&&c.swipeToClose&&(r.off("touchstart:passive",Q),r.off("touchmove:active",J),r.off("touchend:passive",Z))},r.on("resize",K),Support.touch&&c.swipeToClose&&(r.on("touchstart:passive",Q),r.on("touchmove:active",J),r.on("touchend:passive",Z))}}}function X(){i=!0}function G(){o.addClass("page-with-card-opened"),r.device.ios&&d.length&&(d.css("height",d[0].offsetHeight+1+"px"),setTimeout((function(){d.css("height","")}))),n.addClass("card-opened"),n.removeClass("card-opening"),n.trigger("card:opened"),r.emit("cardOpened",n[0],o[0])}function K(){var e;n.removeClass("card-transitioning"),g=n[0].offsetWidth,b=n[0].offsetHeight,y=o[0].offsetWidth,w=o[0].offsetHeight,C=m[0].offsetWidth||y,x=m[0].offsetHeight||w,v=0,l&&!c.hideStatusbarOnOpen&&x===w&&(v=parseInt(l.css("--f7-safe-area-top"),10),Number.isNaN(v)&&(v=0)),v&&(x-=v),T=C/g,S=x/b,n.transform("translate3d(0px, 0px, 0) scale(1)"),M=n.offset(),P=o.offset(),v&&(P.top+=v/2),M.left-=P.left,M.top-=P.top,k=M.left-(y-C)/2,r.rtl&&(k-=n[0].scrollLeft),E=M.top-(w-x)/2,I=C-g-k,_=x-b-E,r.rtl&&(k=(e=[I,k])[0],I=e[1]),Y=(I-k)/2,W=(_-E)/2,n.transform("translate3d("+(r.rtl?-Y:Y)+"px, "+W+"px, 0) scale("+T+", "+S+")"),f.css({width:C+"px",height:x+"px"}).transform("translate3d("+(r.rtl?k+Y:-k-Y)+"px, 0px, 0) scale("+1/T+", "+1/S+")")}function Q(e){$(e.target).closest(n).length&&n.hasClass("card-opened")&&(j=n.find(c.scrollableEl),B=j[0]&&j[0]!==f[0]&&!j[0].contains(e.target)?0:j.scrollTop(),R=!0,z=e.targetTouches[0].pageX,A=e.targetTouches[0].pageY,N=void 0,V=!1,q=!1)}function J(e){if(R){if(H=e.targetTouches[0].pageX,U=e.targetTouches[0].pageY,void 0===N&&(N=!!(N||Math.abs(U-A)>Math.abs(H-z))),q||V||(!N&&e.targetTouches[0].clientX<=50?q=!0:V=!0),!q&&!V||V&&0!==B)return R=!0,void(L=!0);L||n.removeClass("card-transitioning"),L=!0,((F=V?Math.max((U-A)/150,0):Math.max((H-z)/(g/2),0))>0&&V||q)&&(V&&r.device.ios&&j[0]===f[0]&&(j.css("-webkit-overflow-scrolling","auto"),j.scrollTop(0)),e.preventDefault()),F>1&&(F=Math.pow(F,.3)),F>(V?1.3:1.1)?(R=!1,L=!1,r.card.close(n)):n.transform("translate3d("+(r.rtl?-Y:Y)+"px, "+W+"px, 0) scale("+T*(1-.2*F)+", "+S*(1-.2*F)+")")}}function Z(){R&&L&&(R=!1,L=!1,r.device.ios&&j.css("-webkit-overflow-scrolling",""),F>=.8?r.card.close(n):n.addClass("card-transitioning").transform("translate3d("+(r.rtl?-Y:Y)+"px, "+W+"px, 0) scale("+T+", "+S+")"))}},close:function(e,t){void 0===e&&(e=".card-expandable.card-opened"),void 0===t&&(t=!0);var a=this,r=$(e).eq(0);if(r&&r.length&&r.hasClass("card-opened")&&!r.hasClass("card-opening")&&!r.hasClass("card-closing")){var n=r.children(".card-content"),i=r.parents(".page-content"),o=r.parents(".page").eq(0);if(o.length){var s,l,p,c=Object.assign({animate:t},a.params.card,r.dataset()),d=r.find(c.scrollableEl);r.attr("data-backdrop-el")&&(p=$(r.attr("data-backdrop-el"))),c.backdrop&&(p=r.parents(".page-content").find(".card-backdrop")),c.hideNavbarOnOpen&&((s=o.children(".navbar")).length||o[0].f7Page&&(s=o[0].f7Page.$navbarEl),s&&s.length&&!r[0].f7KeepNavbarOnClose&&a.navbar.show(s,c.animate)),c.hideToolbarOnOpen&&((l=o.children(".toolbar")).length||(l=o.parents(".view").children(".toolbar")),l.length||(l=o.parents(".views").children(".toolbar")),l&&l.length&&!r[0].f7KeepToolbarOnClose&&a.toolbar.show(l,c.animate)),o.removeClass("page-with-card-opened"),a.device.ios&&i.length&&(i.css("height",i[0].offsetHeight+1+"px"),setTimeout((function(){i.css("height","")}))),p&&p.length&&p.removeClass("card-backdrop-in").addClass("card-backdrop-out"),r.removeClass("card-opened card-transitioning"),c.animate?r.addClass("card-closing"):r.addClass("card-no-transition"),r.transform(""),r.trigger("card:close"),a.emit("cardClose",r[0],o[0]);var u=r.hasClass("card-expandable-animate-width");u&&n.css({width:"",height:""}),n.transform("").scrollTop(0,t?300:0),d.length&&d[0]!==n[0]&&d.scrollTop(0,t?300:0),t?n.transitionEnd((function(){h()})):h(),r[0].detachEventHandlers&&(r[0].detachEventHandlers(),delete r[0].detachEventHandlers)}}function h(){u||n.css({width:"",height:""}),p&&p.length&&p.removeClass("card-backdrop-in card-backdrop-out"),r.removeClass("card-closing card-no-transition"),r.trigger("card:closed"),r.find(".card-expandable-size").remove(),a.emit("cardClosed",r[0],o[0])}},toggle:function(e,t){void 0===e&&(e=".card-expandable");var a=$(e).eq(0);a.length&&(a.hasClass("card-opened")?this.card.close(a,t):this.card.open(a,t))}},Card={name:"card",params:{card:{hideNavbarOnOpen:!0,hideStatusbarOnOpen:!0,hideToolbarOnOpen:!0,scrollableEl:".card-content",swipeToClose:!0,closeByBackdropClick:!0,backdrop:!0}},create:function(){Utils.extend(this,{card:{open:CardExpandable.open.bind(this),close:CardExpandable.close.bind(this),toggle:CardExpandable.toggle.bind(this)}})},on:{pageBeforeIn:function(e){if(this.params.card.hideNavbarOnOpen&&e.navbarEl&&e.$el.find(".card-opened.card-expandable").length&&this.navbar.hide(e.navbarEl,!0,this.params.card.hideStatusbarOnOpen),this.params.card.hideToolbarOnOpen&&e.$el.find(".card-opened.card-expandable").length){var t=e.$el.children(".toolbar");t.length||(t=e.$el.parents(".view").children(".toolbar")),t.length||(t=e.$el.parents(".views").children(".toolbar")),t&&t.length&&this.toolbar.hide(t)}}},clicks:{".card-close":function(e,t){this.card.close(t.card,t.animate)},".card-open":function(e,t){this.card.open(t.card,t.animate)},".card-expandable":function(e,t,a){e.hasClass("card-opened")||e.hasClass("card-opening")||e.hasClass("card-closing")||$(a.target).closest(".card-prevent-open, .card-close").length||this.card.open(e)},".card-backdrop-in":function(){var e=!1;this.params.card.closeByBackdropClick&&(e=!0);var t=$(".card-opened");t.length&&("true"===t.attr("data-close-by-backdrop-click")?e=!0:"false"===t.attr("data-close-by-backdrop-click")&&(e=!1),e&&this.card.close(t))}}},Chip={name:"chip"},FormData$1={store:function(e,t){var a=e,r=$(e);r.length&&r.is("form")&&r.attr("id")&&(a=r.attr("id")),this.form.data["form-"+a]=t,win.localStorage["f7form-"+a]=JSON.stringify(t)},get:function(e){var t=e,a=$(e);return a.length&&a.is("form")&&a.attr("id")&&(t=a.attr("id")),win.localStorage["f7form-"+t]?JSON.parse(win.localStorage["f7form-"+t]):this.form.data["form-"+t]?this.form.data["form-"+t]:void 0},remove:function(e){var t=e,a=$(e);a.length&&a.is("form")&&a.attr("id")&&(t=a.attr("id")),this.form.data["form-"+t]&&(this.form.data["form-"+t]="",delete this.form.data["form-"+t]),win.localStorage["f7form-"+t]&&(win.localStorage["f7form-"+t]="",win.localStorage.removeItem("f7form-"+t))}},FormStorage={init:function(e){var t=this,a=$(e),r=a.attr("id");if(r){var n=t.form.getFormData(r);n&&t.form.fillFromData(a,n),a.on("change submit",(function(){var e=t.form.convertToData(a);e&&(t.form.storeFormData(r,e),a.trigger("form:storedata",e),t.emit("formStoreData",a[0],e))}))}},destroy:function(e){$(e).off("change submit")}};function formToData(e){var t=$(e).eq(0);if(0!==t.length){var a={},r=["submit","image","button","file"],n=[];return t.find("input, select, textarea").each((function(e,i){var o=$(i);if(!o.hasClass("ignore-store-data")&&!o.hasClass("no-store-data")){var s=o.attr("name"),l=o.attr("type"),p=i.nodeName.toLowerCase();if(!(r.indexOf(l)>=0)&&!(n.indexOf(s)>=0)&&s)if("select"===p&&o.prop("multiple"))n.push(s),a[s]=[],t.find('select[name="'+s+'"] option').each((function(e,t){t.selected&&a[s].push(t.value)}));else switch(l){case"checkbox":n.push(s),a[s]=[],t.find('input[name="'+s+'"]').each((function(e,t){t.checked&&a[s].push(t.value)}));break;case"radio":n.push(s),t.find('input[name="'+s+'"]').each((function(e,t){t.checked&&(a[s]=t.value)}));break;default:a[s]=o.val()}}})),t.trigger("form:todata",a),this.emit("formToData",t[0],a),a}}function formFromData(e,t){var a=$(e).eq(0);if(a.length){var r=t,n=a.attr("id");if(!r&&n&&(r=this.form.getFormData(n)),r){var i=["submit","image","button","file"],o=[];a.find("input, select, textarea").each((function(e,t){var n=$(t);if(!n.hasClass("ignore-store-data")&&!n.hasClass("no-store-data")){var s=n.attr("name"),l=n.attr("type"),p=t.nodeName.toLowerCase();if(void 0!==r[s]&&null!==r[s]&&!(i.indexOf(l)>=0)&&!(o.indexOf(s)>=0)&&s){if("select"===p&&n.prop("multiple"))o.push(s),a.find('select[name="'+s+'"] option').each((function(e,t){var a=t;r[s].indexOf(t.value)>=0?a.selected=!0:a.selected=!1}));else switch(l){case"checkbox":o.push(s),a.find('input[name="'+s+'"]').each((function(e,t){var a=t;r[s].indexOf(t.value)>=0?a.checked=!0:a.checked=!1}));break;case"radio":o.push(s),a.find('input[name="'+s+'"]').each((function(e,t){var a=t;r[s]===t.value?a.checked=!0:a.checked=!1}));break;default:n.val(r[s])}"select"!==p&&"input"!==p&&"textarea"!==p||n.trigger("change","fromdata")}}})),a.trigger("form:fromdata",r),this.emit("formFromData",a[0],r)}}}function initAjaxForm(){var e=this;$(doc).on("submit change","form.form-ajax-submit, form.form-ajax-submit-onchange",(function(t,a){var r=$(this);if(("change"!==t.type||r.hasClass("form-ajax-submit-onchange"))&&("submit"===t.type&&t.preventDefault(),"change"!==t.type||"fromdata"!==a)){var n,i=(r.attr("method")||"GET").toUpperCase(),o=r.prop("enctype")||r.attr("enctype"),s=r.attr("action");if(s)n="POST"===i?"application/x-www-form-urlencoded"===o?e.form.convertToData(r[0]):new win.FormData(r[0]):Utils.serializeObject(e.form.convertToData(r[0])),e.request({method:i,url:s,contentType:o,data:n,beforeSend:function(t){r.trigger("formajax:beforesend",{data:n,xhr:t}),e.emit("formAjaxBeforeSend",r[0],n,t)},error:function(t){r.trigger("formajax:error",{data:n,xhr:t}),e.emit("formAjaxError",r[0],n,t)},complete:function(t){r.trigger("formajax:complete",{data:n,xhr:t}),e.emit("formAjaxComplete",r[0],n,t)},success:function(t,a,i){r.trigger("formajax:success",{data:n,xhr:i}),e.emit("formAjaxSuccess",r[0],n,i)}})}}))}var Form={name:"form",create:function(){Utils.extend(this,{form:{data:{},storeFormData:FormData$1.store.bind(this),getFormData:FormData$1.get.bind(this),removeFormData:FormData$1.remove.bind(this),convertToData:formToData.bind(this),fillFromData:formFromData.bind(this),storage:{init:FormStorage.init.bind(this),destroy:FormStorage.destroy.bind(this)}}})},on:{init:function(){initAjaxForm.call(this)},tabBeforeRemove:function(e){var t=this;$(e).find(".form-store-data").each((function(e,a){t.form.storage.destroy(a)}))},tabMounted:function(e){var t=this;$(e).find(".form-store-data").each((function(e,a){t.form.storage.init(a)}))},pageBeforeRemove:function(e){var t=this;e.$el.find(".form-store-data").each((function(e,a){t.form.storage.destroy(a)}))},pageInit:function(e){var t=this;e.$el.find(".form-store-data").each((function(e,a){t.form.storage.init(a)}))}}},Input={ignoreTypes:["checkbox","button","submit","range","radio","image"],createTextareaResizableShadow:function(){var e=$(doc.createElement("textarea"));e.addClass("textarea-resizable-shadow"),e.prop({disabled:!0,readonly:!0}),Input.textareaResizableShadow=e},textareaResizableShadow:void 0,resizeTextarea:function(e){var t=$(e);Input.textareaResizableShadow||Input.createTextareaResizableShadow();var a=Input.textareaResizableShadow;if(t.length&&t.hasClass("resizable")){0===Input.textareaResizableShadow.parents().length&&this.root.append(a);var r=win.getComputedStyle(t[0]);"padding-top padding-bottom padding-left padding-right margin-left margin-right margin-top margin-bottom width font-size font-family font-style font-weight line-height font-variant text-transform letter-spacing border box-sizing display".split(" ").forEach((function(e){var t=r[e];"font-size line-height letter-spacing width".split(" ").indexOf(e)>=0&&(t=t.replace(",",".")),a.css(e,t)}));var n=t[0].clientHeight;a.val("");var i=a[0].scrollHeight;a.val(t.val()),a.css("height",0);var o=a[0].scrollHeight;n!==o&&(o>i?t.css("height",o+"px"):o<n&&t.css("height",""),(o>i||o<n)&&(t.trigger("textarea:resize",{initialHeight:i,currentHeight:n,scrollHeight:o}),this.emit("textareaResize",{initialHeight:i,currentHeight:n,scrollHeight:o})))}},validate:function(e){var t=$(e);if(t.length){var a=t.parents(".item-input"),r=t.parents(".input"),n=t[0].validity,i=t.dataset().errorMessage||t[0].validationMessage||"";if(n)if(n.valid)a.removeClass("item-input-invalid item-input-with-error-message"),r.removeClass("input-invalid input-with-error-message"),t.removeClass("input-invalid");else{var o=t.nextAll(".item-input-error-message, .input-error-message");i&&(0===o.length&&(o=$('<div class="'+(r.length?"input-error-message":"item-input-error-message")+'"></div>')).insertAfter(t),o.text(i)),o.length>0&&(a.addClass("item-input-with-error-message"),r.addClass("input-with-error-message")),a.addClass("item-input-invalid"),r.addClass("input-invalid"),t.addClass("input-invalid")}}},validateInputs:function(e){var t=this;$(e).find("input, textarea, select").each((function(e,a){t.input.validate(a)}))},focus:function(e){var t=$(e),a=t.attr("type");Input.ignoreTypes.indexOf(a)>=0||(t.parents(".item-input").addClass("item-input-focused"),t.parents(".input").addClass("input-focused"),t.addClass("input-focused"))},blur:function(e){var t=$(e);t.parents(".item-input").removeClass("item-input-focused"),t.parents(".input").removeClass("input-focused"),t.removeClass("input-focused")},checkEmptyState:function(e){var t=$(e);if(t.is("input, select, textarea, .item-input [contenteditable]")||(t=t.find("input, select, textarea, .item-input [contenteditable]").eq(0)),t.length){var a;a=t[0].hasAttribute("contenteditable")?t.find(".text-editor-placeholder").length?"":t.html():t.val();var r=t.parents(".item-input"),n=t.parents(".input");a&&"string"==typeof a&&""!==a.trim()||Array.isArray(a)&&a.length>0?(r.addClass("item-input-with-value"),n.addClass("input-with-value"),t.addClass("input-with-value"),t.trigger("input:notempty"),this.emit("inputNotEmpty",t[0])):(r.removeClass("item-input-with-value"),n.removeClass("input-with-value"),t.removeClass("input-with-value"),t.trigger("input:empty"),this.emit("inputEmpty",t[0]))}},scrollIntoView:function(e,t,a,r){void 0===t&&(t=0);var n=$(e),i=n.parents(".page-content, .panel, .card-expandable .card-content").eq(0);if(!i.length)return!1;var o=i[0].offsetHeight,s=i[0].scrollTop,l=parseInt(i.css("padding-top"),10),p=parseInt(i.css("padding-bottom"),10),c=i.offset().top-s,d=n.offset().top-c,u=d+s-l,h=d+s-o+p+n[0].offsetHeight,f=u+(h-u)/2;return s>u?(i.scrollTop(a?f:u,t),!0):s<h?(i.scrollTop(a?f:h,t),!0):(r&&i.scrollTop(a?f:h,t),!1)},init:function(){var e=this;Input.createTextareaResizableShadow(),$(doc).on("click",".input-clear-button",(function(){var t=$(this).siblings("input, textarea").eq(0),a=t.val();t.val("").trigger("input change").focus().trigger("input:clear",a),e.emit("inputClear",a)})),$(doc).on("change input","input, textarea, select, .item-input [contenteditable]",(function(){var t=$(this),a=t.attr("type"),r=t[0].nodeName.toLowerCase(),n=t[0].hasAttribute("contenteditable");Input.ignoreTypes.indexOf(a)>=0||(e.input.checkEmptyState(t),n||(null!==t.attr("data-validate-on-blur")||!t.dataset().validate&&null===t.attr("validate")||e.input.validate(t),"textarea"===r&&t.hasClass("resizable")&&e.input.resizeTextarea(t)))}),!0),$(doc).on("focus","input, textarea, select, .item-input [contenteditable]",(function(){var t=this;e.params.input.scrollIntoViewOnFocus&&(Device.android?$(win).once("resize",(function(){doc&&doc.activeElement===t&&e.input.scrollIntoView(t,e.params.input.scrollIntoViewDuration,e.params.input.scrollIntoViewCentered,e.params.input.scrollIntoViewAlways)})):e.input.scrollIntoView(t,e.params.input.scrollIntoViewDuration,e.params.input.scrollIntoViewCentered,e.params.input.scrollIntoViewAlways)),e.input.focus(t)}),!0),$(doc).on("blur","input, textarea, select, .item-input [contenteditable]",(function(){var t=$(this),a=t[0].nodeName.toLowerCase();e.input.blur(t),(t.dataset().validate||null!==t.attr("validate")||null!==t.attr("data-validate-on-blur"))&&e.input.validate(t),"textarea"===a&&t.hasClass("resizable")&&Input.textareaResizableShadow&&Input.textareaResizableShadow.remove()}),!0),$(doc).on("invalid","input, textarea, select",(function(t){var a=$(this);null!==a.attr("data-validate-on-blur")||!a.dataset().validate&&null===a.attr("validate")||(t.preventDefault(),e.input.validate(a))}),!0)}},Input$1={name:"input",params:{input:{scrollIntoViewOnFocus:Device.android,scrollIntoViewCentered:!1,scrollIntoViewDuration:0,scrollIntoViewAlways:!1}},create:function(){Utils.extend(this,{input:{scrollIntoView:Input.scrollIntoView.bind(this),focus:Input.focus.bind(this),blur:Input.blur.bind(this),validate:Input.validate.bind(this),validateInputs:Input.validateInputs.bind(this),checkEmptyState:Input.checkEmptyState.bind(this),resizeTextarea:Input.resizeTextarea.bind(this),init:Input.init.bind(this)}})},on:{init:function(){this.input.init()},tabMounted:function(e){var t=this,a=$(e);a.find(".item-input, .input").each((function(e,a){$(a).find("input, select, textarea, [contenteditable]").each((function(e,a){var r=$(a);Input.ignoreTypes.indexOf(r.attr("type"))>=0||t.input.checkEmptyState(r)}))})),a.find("textarea.resizable").each((function(e,a){t.input.resizeTextarea(a)}))},pageInit:function(e){var t=this,a=e.$el;a.find(".item-input, .input").each((function(e,a){$(a).find("input, select, textarea, [contenteditable]").each((function(e,a){var r=$(a);Input.ignoreTypes.indexOf(r.attr("type"))>=0||t.input.checkEmptyState(r)}))})),a.find("textarea.resizable").each((function(e,a){t.input.resizeTextarea(a)}))},"panelBreakpoint panelCollapsedBreakpoint panelResize panelOpen panelSwipeOpen resize viewMasterDetailBreakpoint":function(e){var t=this;e&&e.$el?e.$el.find("textarea.resizable").each((function(e,a){t.input.resizeTextarea(a)})):$("textarea.resizable").each((function(e,a){t.input.resizeTextarea(a)}))}}},Checkbox={name:"checkbox"},Radio={name:"radio"},Toggle=function(e){function t(t,a){void 0===a&&(a={}),e.call(this,a,[t]);var r=this,n={};r.useModulesParams(n),r.params=Utils.extend(n,a);var i=r.params.el;if(!i)return r;var o=$(i);if(0===o.length)return r;if(o[0].f7Toggle)return o[0].f7Toggle;var s,l=o.children('input[type="checkbox"]');Utils.extend(r,{app:t,$el:o,el:o[0],$inputEl:l,inputEl:l[0],disabled:o.hasClass("disabled")||l.hasClass("disabled")||l.attr("disabled")||l[0].disabled}),Object.defineProperty(r,"checked",{enumerable:!0,configurable:!0,set:function(e){r&&void 0!==r.$inputEl&&r.checked!==e&&(l[0].checked=e,r.$inputEl.trigger("change"))},get:function(){return l[0].checked}}),o[0].f7Toggle=r;var p,c,d,u,h,f={};function m(e){s||r.disabled||(f.x="touchstart"===e.type?e.targetTouches[0].pageX:e.pageX,f.y="touchstart"===e.type?e.targetTouches[0].pageY:e.pageY,c=0,s=!0,p=void 0,u=Utils.now(),h=r.checked,d=o[0].offsetWidth,Utils.nextTick((function(){s&&o.addClass("toggle-active-state")})))}function v(e){if(s&&!r.disabled){var a,n="touchmove"===e.type?e.targetTouches[0].pageX:e.pageX,i="touchmove"===e.type?e.targetTouches[0].pageY:e.pageY,o=t.rtl?-1:1;if(void 0===p&&(p=!!(p||Math.abs(i-f.y)>Math.abs(n-f.x))),p)s=!1;else e.preventDefault(),(c=n-f.x)*o<0&&Math.abs(c)>d/3&&h&&(a=!0),c*o>0&&Math.abs(c)>d/3&&!h&&(a=!0),a&&(f.x=n,r.checked=!h,h=!h)}}function g(){if(!s||r.disabled)return p&&o.removeClass("toggle-active-state"),void(s=!1);var e,a=t.rtl?-1:1;s=!1,o.removeClass("toggle-active-state"),Utils.now()-u<300&&(c*a<0&&h&&(e=!0),c*a>0&&!h&&(e=!0),e&&(r.checked=!h))}function b(){r.$el.trigger("toggle:change"),r.emit("local::change toggleChange",r)}r.attachEvents=function(){var e=!!Support.passiveListener&&{passive:!0};o.on(t.touchEvents.start,m,e),t.on("touchmove",v),t.on("touchend:passive",g),r.$inputEl.on("change",b)},r.detachEvents=function(){var e=!!Support.passiveListener&&{passive:!0};o.off(t.touchEvents.start,m,e),t.off("touchmove",v),t.off("touchend:passive",g),r.$inputEl.off("change",b)},r.useModules(),r.init()}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t.prototype.toggle=function(){this.checked=!this.checked},t.prototype.init=function(){this.attachEvents()},t.prototype.destroy=function(){var e=this;e.$el.trigger("toggle:beforedestroy"),e.emit("local::beforeDestroy toggleBeforeDestroy",e),delete e.$el[0].f7Toggle,e.detachEvents(),Utils.deleteProps(e),e=null},t}(Framework7Class),Toggle$1={name:"toggle",create:function(){this.toggle=ConstructorMethods({defaultSelector:".toggle",constructor:Toggle,app:this,domProp:"f7Toggle"})},static:{Toggle:Toggle},on:{tabMounted:function(e){var t=this;$(e).find(".toggle-init").each((function(e,a){return t.toggle.create({el:a})}))},tabBeforeRemove:function(e){$(e).find(".toggle-init").each((function(e,t){t.f7Toggle&&t.f7Toggle.destroy()}))},pageInit:function(e){var t=this;e.$el.find(".toggle-init").each((function(e,a){return t.toggle.create({el:a})}))},pageBeforeRemove:function(e){e.$el.find(".toggle-init").each((function(e,t){t.f7Toggle&&t.f7Toggle.destroy()}))}},vnode:{"toggle-init":{insert:function(e){var t=e.elm;this.toggle.create({el:t})},destroy:function(e){var t=e.elm;t.f7Toggle&&t.f7Toggle.destroy()}}}},Range=function(e){function t(t,a){e.call(this,a,[t]);var r=this,n={el:null,inputEl:null,dual:!1,step:1,label:!1,min:0,max:100,value:0,draggableBar:!0,vertical:!1,verticalReversed:!1,formatLabel:null,scale:!1,scaleSteps:5,scaleSubSteps:0,formatScaleLabel:null,limitKnobPosition:"ios"===t.theme};r.useModulesParams(n),r.params=Utils.extend(n,a);var i=r.params.el;if(!i)return r;var o=$(i);if(0===o.length)return r;if(o[0].f7Range)return o[0].f7Range;var s,l=o.dataset();"step min max value scaleSteps scaleSubSteps".split(" ").forEach((function(e){void 0===a[e]&&void 0!==l[e]&&(r.params[e]=parseFloat(l[e]))})),"dual label vertical verticalReversed scale".split(" ").forEach((function(e){void 0===a[e]&&void 0!==l[e]&&(r.params[e]=l[e])})),r.params.value||(void 0!==l.value&&(r.params.value=l.value),void 0!==l.valueLeft&&void 0!==l.valueRight&&(r.params.value=[parseFloat(l.valueLeft),parseFloat(l.valueRight)])),r.params.dual||(r.params.inputEl?s=$(r.params.inputEl):o.find('input[type="range"]').length&&(s=o.find('input[type="range"]').eq(0)));var p=r.params,c=p.dual,d=p.step,u=p.label,h=p.min,f=p.max,m=p.value,v=p.vertical,g=p.verticalReversed,b=p.scale,y=p.scaleSteps,w=p.scaleSubSteps,C=p.limitKnobPosition;Utils.extend(r,{app:t,$el:o,el:o[0],$inputEl:s,inputEl:s?s[0]:void 0,dual:c,step:d,label:u,min:h,max:f,value:m,previousValue:m,vertical:v,verticalReversed:g,scale:b,scaleSteps:y,scaleSubSteps:w,limitKnobPosition:C}),s&&("step min max".split(" ").forEach((function(e){!a[e]&&s.attr(e)&&(r.params[e]=parseFloat(s.attr(e)),r[e]=parseFloat(s.attr(e)))})),void 0!==s.val()&&(r.params.value=parseFloat(s.val()),r.value=parseFloat(s.val()))),r.dual&&o.addClass("range-slider-dual"),r.label&&o.addClass("range-slider-label"),r.vertical?(o.addClass("range-slider-vertical"),r.verticalReversed&&o.addClass("range-slider-vertical-reversed")):o.addClass("range-slider-horizontal");var x=$('<div class="range-bar"></div>'),k=$('<div class="range-bar-active"></div>');x.append(k);var E='\n      <div class="range-knob-wrap">\n        <div class="range-knob"></div>\n        '+(r.label?'<div class="range-knob-label"></div>':"")+"\n      </div>\n    ",T=[$(E)];r.dual&&T.push($(E)),o.append(x),T.forEach((function(e){o.append(e)}));var S,M,P=[];r.label&&(P.push(T[0].find(".range-knob-label")),r.dual&&P.push(T[1].find(".range-knob-label"))),r.scale&&r.scaleSteps>1&&(S=$('\n        <div class="range-scale">\n          '+r.renderScale()+"\n        </div>\n      "),o.append(S)),Utils.extend(r,{knobs:T,labels:P,$barEl:x,$barActiveEl:k,$scaleEl:S}),o[0].f7Range=r;var O,D,I,B,R,L,z,A,H,U,N,F={};function V(){z=!0}function q(e){if(!M&&(r.params.draggableBar||0!==$(e.target).closest(".range-knob").length)){var t;z=!1,F.x="touchstart"===e.type?e.targetTouches[0].pageX:e.pageX,F.y="touchstart"===e.type?e.targetTouches[0].pageY:e.pageY,"touchstart"===e.type&&(A=e.targetTouches[0].identifier),M=!0,O=void 0,D=o.offset(),I=D.left,B=D.top,r.vertical?(t=(F.y-B)/r.rangeHeight,r.verticalReversed||(t=1-t)):t=r.app.rtl?(I+r.rangeWidth-F.x)/r.rangeWidth:(F.x-I)/r.rangeWidth;var a=t*(r.max-r.min)+r.min;r.dual?Math.abs(r.value[0]-a)<Math.abs(r.value[1]-a)?(L=0,R=r.knobs[0],a=[a,r.value[1]]):(L=1,R=r.knobs[1],a=[r.value[0],a]):(R=r.knobs[0],a=t*(r.max-r.min)+r.min),Utils.nextTick((function(){M&&R.addClass("range-knob-active-state")}),70),r.on("change",V),r.setValue(a,!0)}}function j(e){if(M){var t,a;if("touchmove"===e.type)for(var n=0;n<e.targetTouches.length;n+=1)e.targetTouches[n].identifier===A&&(t=e.targetTouches[n].pageX,a=e.targetTouches[n].pageY);else t=e.pageX,a=e.pageY;if(void 0!==t||void 0!==a)if(void 0!==O||r.vertical||(O=!!(O||Math.abs(a-F.y)>Math.abs(t-F.x))),O)M=!1;else{var i;e.preventDefault(),r.vertical?(i=(a-B)/r.rangeHeight,r.verticalReversed||(i=1-i)):i=r.app.rtl?(I+r.rangeWidth-t)/r.rangeWidth:(t-I)/r.rangeWidth;var o,s,l=i*(r.max-r.min)+r.min;if(r.dual)0===L?(o=l)>(s=r.value[1])&&(s=o):(s=l)<(o=r.value[0])&&(o=s),l=[o,s];r.setValue(l,!0)}}}function _(e){if("touchend"===e.type){for(var t,a=0;a<e.changedTouches.length;a+=1)e.changedTouches[a].identifier===A&&(t=!0);if(!t)return}if(!M)return O&&R.removeClass("range-knob-active-state"),void(M=!1);r.off("change",V),M=!1,R.removeClass("range-knob-active-state"),z&&r.$inputEl&&!r.dual&&r.$inputEl.trigger("change"),z=!1,void 0!==r.previousValue&&(r.dual&&(r.previousValue[0]!==r.value[0]||r.previousValue[1]!==r.value[1])||!r.dual&&r.previousValue!==r.value)&&(r.$el.trigger("range:changed",r.value),r.emit("local::changed rangeChanged",r,r.value))}function Y(){r.calcSize(),r.layout()}return r.attachEvents=function(){var e=!!Support.passiveListener&&{passive:!0};r.$el.on(t.touchEvents.start,q,e),t.on("touchmove",j),t.on("touchend:passive",_),t.on("tabShow",Y),t.on("resize",Y),(H=r.$el.parents(".sheet-modal, .actions-modal, .popup, .popover, .login-screen, .dialog, .toast")).on("modal:open",Y),(U=r.$el.parents(".panel")).on("panel:open",Y),(N=r.$el.parents(".page").eq(0)).on("page:reinit",Y)},r.detachEvents=function(){var e=!!Support.passiveListener&&{passive:!0};r.$el.off(t.touchEvents.start,q,e),t.off("touchmove",j),t.off("touchend:passive",_),t.off("tabShow",Y),t.off("resize",Y),H&&H.off("modal:open",Y),U&&U.off("panel:open",Y),N&&N.off("page:reinit",Y),H=null,U=null,N=null},r.useModules(),r.init(),r}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t.prototype.calcSize=function(){if(this.vertical){var e=this.$el.outerHeight();if(0===e)return;this.rangeHeight=e,this.knobHeight=this.knobs[0].outerHeight()}else{var t=this.$el.outerWidth();if(0===t)return;this.rangeWidth=t,this.knobWidth=this.knobs[0].outerWidth()}},t.prototype.layout=function(){var e,t=this,a=t.app,r=t.knobWidth,n=t.knobHeight,i=t.rangeWidth,o=t.rangeHeight,s=t.min,l=t.max,p=t.knobs,c=t.$barActiveEl,d=t.value,u=t.label,h=t.labels,f=t.vertical,m=t.verticalReversed,v=t.limitKnobPosition,g=f?n:r,b=f?o:i,y=f?m?"top":"bottom":a.rtl?"right":"left";if(t.dual){var w=[(d[0]-s)/(l-s),(d[1]-s)/(l-s)];c.css(((e={})[y]=100*w[0]+"%",e[f?"height":"width"]=100*(w[1]-w[0])+"%",e)),p.forEach((function(e,a){var r=b*w[a];if(v){var n=b*w[a]-g/2;n<0&&(r=g/2),n+g>b&&(r=b-g/2)}e.css(y,r+"px"),u&&h[a].text(t.formatLabel(d[a],h[a][0]))}))}else{var C=(d-s)/(l-s);c.css(f?"height":"width",100*C+"%");var x=b*C;if(v){var $=b*C-g/2;$<0&&(x=g/2),$+g>b&&(x=b-g/2)}p[0].css(y,x+"px"),u&&h[0].text(t.formatLabel(d,h[0][0]))}t.dual&&d.indexOf(s)>=0||!t.dual&&d===s?t.$el.addClass("range-slider-min"):t.$el.removeClass("range-slider-min"),t.dual&&d.indexOf(l)>=0||!t.dual&&d===l?t.$el.addClass("range-slider-max"):t.$el.removeClass("range-slider-max")},t.prototype.setValue=function(e,t){var a,r,n=this,i=n.step,o=n.min,s=n.max;if(n.dual){r=[n.value[0],n.value[1]];var l=e;if(Array.isArray(l)||(l=[e,e]),e[0]>e[1]&&(l=[l[0],l[0]]),(l=l.map((function(e){return Math.max(Math.min(Math.round(e/i)*i,s),o)})))[0]===n.value[0]&&l[1]===n.value[1])return n;l.forEach((function(e,t){n.value[t]=e})),a=r[0]!==l[0]||r[1]!==l[1],n.layout()}else{r=n.value;var p=Math.max(Math.min(Math.round(e/i)*i,s),o);n.value=p,n.layout(),a=r!==p}return a&&(n.previousValue=r),a?(n.$el.trigger("range:change",n.value),n.$inputEl&&!n.dual&&(n.$inputEl.val(n.value),t?n.$inputEl.trigger("input"):n.$inputEl.trigger("input change")),t||(n.$el.trigger("range:changed",n.value),n.emit("local::changed rangeChanged",n,n.value)),n.emit("local::change rangeChange",n,n.value),n):n},t.prototype.getValue=function(){return this.value},t.prototype.formatLabel=function(e,t){return this.params.formatLabel?this.params.formatLabel.call(this,e,t):e},t.prototype.formatScaleLabel=function(e){return this.params.formatScaleLabel?this.params.formatScaleLabel.call(this,e):e},t.prototype.renderScale=function(){var e=this,t=e.app,a=e.verticalReversed,r=e.vertical?a?"top":"bottom":t.rtl?"right":"left",n="";return Array.from({length:e.scaleSteps+1}).forEach((function(t,a){var i=(e.max-e.min)/e.scaleSteps,o=e.min+i*a,s=(o-e.min)/(e.max-e.min);n+='<div class="range-scale-step" style="'+r+": "+100*s+'%">'+e.formatScaleLabel(o)+"</div>",e.scaleSubSteps&&e.scaleSubSteps>1&&a<e.scaleSteps&&Array.from({length:e.scaleSubSteps-1}).forEach((function(t,a){var s=i/e.scaleSubSteps,l=(o+s*(a+1)-e.min)/(e.max-e.min);n+='<div class="range-scale-step range-scale-substep" style="'+r+": "+100*l+'%"></div>'}))})),n},t.prototype.updateScale=function(){if(!this.scale||this.scaleSteps<2)return this.$scaleEl&&this.$scaleEl.remove(),void delete this.$scaleEl;this.$scaleEl||(this.$scaleEl=$('<div class="range-scale"></div>'),this.$el.append(this.$scaleEl)),this.$scaleEl.html(this.renderScale())},t.prototype.init=function(){return this.calcSize(),this.layout(),this.attachEvents(),this},t.prototype.destroy=function(){var e=this;e.$el.trigger("range:beforedestroy"),e.emit("local::beforeDestroy rangeBeforeDestroy",e),delete e.$el[0].f7Range,e.detachEvents(),Utils.deleteProps(e),e=null},t}(Framework7Class),Range$1={name:"range",create:function(){var e=this;e.range=Utils.extend(ConstructorMethods({defaultSelector:".range-slider",constructor:Range,app:e,domProp:"f7Range"}),{getValue:function(t){void 0===t&&(t=".range-slider");var a=e.range.get(t);if(a)return a.getValue()},setValue:function(t,a){void 0===t&&(t=".range-slider");var r=e.range.get(t);if(r)return r.setValue(a)}})},static:{Range:Range},on:{tabMounted:function(e){var t=this;$(e).find(".range-slider-init").each((function(e,a){return new Range(t,{el:a})}))},tabBeforeRemove:function(e){$(e).find(".range-slider-init").each((function(e,t){t.f7Range&&t.f7Range.destroy()}))},pageInit:function(e){var t=this;e.$el.find(".range-slider-init").each((function(e,a){return new Range(t,{el:a})}))},pageBeforeRemove:function(e){e.$el.find(".range-slider-init").each((function(e,t){t.f7Range&&t.f7Range.destroy()}))}},vnode:{"range-slider-init":{insert:function(e){var t=e.elm;this.range.create({el:t})},destroy:function(e){var t=e.elm;t.f7Range&&t.f7Range.destroy()}}}},Stepper=function(e){function t(t,a){e.call(this,a,[t]);var r=this,n={el:null,inputEl:null,valueEl:null,value:0,formatValue:null,step:1,min:0,max:100,watchInput:!0,autorepeat:!1,autorepeatDynamic:!1,wraps:!1,manualInputMode:!1,decimalPoint:4,buttonsEndInputMode:!0};r.useModulesParams(n),r.params=Utils.extend(n,a),r.params.value<r.params.min&&(r.params.value=r.params.min),r.params.value>r.params.max&&(r.params.value=r.params.max);var i=r.params.el;if(!i)return r;var o,s,l=$(i);if(0===l.length)return r;if(l[0].f7Stepper)return l[0].f7Stepper;if(r.params.inputEl?o=$(r.params.inputEl):l.find(".stepper-input-wrap").find("input, textarea").length&&(o=l.find(".stepper-input-wrap").find("input, textarea").eq(0)),o&&o.length){"step min max".split(" ").forEach((function(e){!a[e]&&o.attr(e)&&(r.params[e]=parseFloat(o.attr(e)))}));var p=parseInt(r.params.decimalPoint,10);Number.isNaN(p)?r.params.decimalPoint=0:r.params.decimalPoint=p;var c=parseFloat(o.val());void 0!==a.value||Number.isNaN(c)||!c&&0!==c||(r.params.value=c)}r.params.valueEl?s=$(r.params.valueEl):l.find(".stepper-value").length&&(s=l.find(".stepper-value").eq(0));var d=l.find(".stepper-button-plus"),u=l.find(".stepper-button-minus"),h=r.params,f=h.step,m=h.min,v=h.max,g=h.value,b=h.decimalPoint;Utils.extend(r,{app:t,$el:l,el:l[0],$buttonPlusEl:d,buttonPlusEl:d[0],$buttonMinusEl:u,buttonMinusEl:u[0],$inputEl:o,inputEl:o?o[0]:void 0,$valueEl:s,valueEl:s?s[0]:void 0,step:f,min:m,max:v,value:g,decimalPoint:b,typeModeChanged:!1}),l[0].f7Stepper=r;var y,w,C,x,k,E={},T=null,S=!1,M=!1;function P(e){y||(M||($(e.target).closest(d).length?T="increment":$(e.target).closest(u).length&&(T="decrement"),T&&(E.x="touchstart"===e.type?e.targetTouches[0].pageX:e.pageX,E.y="touchstart"===e.type?e.targetTouches[0].pageY:e.pageY,y=!0,w=void 0,function e(t,a,r,n,i,o){clearTimeout(k),k=setTimeout((function(){1===t&&(C=!0,S=!0),clearInterval(x),o(),x=setInterval((function(){o()}),i),t<a&&e(t+1,a,r,n,i/2,o)}),1===t?r:n)}(1,r.params.autorepeatDynamic?4:1,500,1e3,300,(function(){r[T]()})))))}function O(e){if(y&&!M){var t="touchmove"===e.type?e.targetTouches[0].pageX:e.pageX,a="touchmove"===e.type?e.targetTouches[0].pageY:e.pageY;void 0!==w||S||(w=!!(w||Math.abs(a-E.y)>Math.abs(t-E.x)));var r=Math.pow(Math.pow(t-E.x,2)+Math.pow(a-E.y,2),.5);(w||r>20)&&(y=!1,clearTimeout(k),clearInterval(x))}}function D(){clearTimeout(k),clearInterval(x),T=null,S=!1,y=!1}function I(){M?r.params.buttonsEndInputMode&&(M=!1,r.endTypeMode(!0)):C?C=!1:r.decrement(!0)}function B(){M?r.params.buttonsEndInputMode&&(M=!1,r.endTypeMode(!0)):C?C=!1:r.increment(!0)}function R(e){!e.target.readOnly&&r.params.manualInputMode&&(M=!0,"number"==typeof e.target.selectionStart&&(e.target.selectionStart=e.target.value.length,e.target.selectionEnd=e.target.value.length))}function L(e){13!==e.keyCode&&13!==e.which||(e.preventDefault(),M=!1,r.endTypeMode())}function z(){M=!1,r.endTypeMode(!0)}function A(e){M?r.typeValue(e.target.value):e.detail&&e.detail.sentByF7Stepper||r.setValue(e.target.value,!0)}return r.attachEvents=function(){u.on("click",I),d.on("click",B),r.params.watchInput&&o&&o.length&&(o.on("input",A),o.on("click",R),o.on("blur",z),o.on("keyup",L)),r.params.autorepeat&&(t.on("touchstart:passive",P),t.on("touchmove:active",O),t.on("touchend:passive",D))},r.detachEvents=function(){u.off("click",I),d.off("click",B),r.params.watchInput&&o&&o.length&&(o.off("input",A),o.off("click",R),o.off("blur",z),o.off("keyup",L))},r.useModules(),r.init(),r}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t.prototype.minus=function(){return this.decrement()},t.prototype.plus=function(){return this.increment()},t.prototype.decrement=function(){return this.setValue(this.value-this.step,!1,!0)},t.prototype.increment=function(){return this.setValue(this.value+this.step,!1,!0)},t.prototype.setValue=function(e,t,a){var r=this.step,n=this.min,i=this.max,o=this.value,s=Math.round(e/r)*r;if(this.params.wraps&&a?(s>i&&(s=n),s<n&&(s=i)):s=Math.max(Math.min(s,i),n),Number.isNaN(s)&&(s=o),this.value=s,!(o!==s)&&!t)return this;this.$el.trigger("stepper:change",this.value);var l=this.formatValue(this.value);return this.$inputEl&&this.$inputEl.length&&(this.$inputEl.val(l),this.$inputEl.trigger("input change",{sentByF7Stepper:!0})),this.$valueEl&&this.$valueEl.length&&this.$valueEl.html(l),this.emit("local::change stepperChange",this,this.value),this},t.prototype.endTypeMode=function(e){var t=this.min,a=this.max,r=parseFloat(this.value);if(Number.isNaN(r)&&(r=0),r=Math.max(Math.min(r,a),t),this.value=r,!this.typeModeChanged)return this.$inputEl&&this.$inputEl.length&&!e&&this.$inputEl.blur(),this;this.typeModeChanged=!1,this.$el.trigger("stepper:change",this.value);var n=this.formatValue(this.value);return this.$inputEl&&this.$inputEl.length&&(this.$inputEl.val(n),this.$inputEl.trigger("input change",{sentByF7Stepper:!0}),e||this.$inputEl.blur()),this.$valueEl&&this.$valueEl.length&&this.$valueEl.html(n),this.emit("local::change stepperChange",this,this.value),this},t.prototype.typeValue=function(e){this.typeModeChanged=!0;var t=String(e);if(t.lastIndexOf(".")+1!==t.length&&t.lastIndexOf(",")+1!==t.length){var a=parseFloat(t.replace(",","."));if(0===a)return this.value=t.replace(",","."),this.$inputEl.val(this.value),this;if(Number.isNaN(a))return this.value=0,this.$inputEl.val(this.value),this;var r=Math.pow(10,this.params.decimalPoint);return a=Math.round(a*r).toFixed(this.params.decimalPoint+1)/r,this.value=parseFloat(String(a).replace(",",".")),this.$inputEl.val(this.value),this}return t.lastIndexOf(".")!==t.indexOf(".")||t.lastIndexOf(",")!==t.indexOf(",")?(t=t.slice(0,-1),this.value=t,this.$inputEl.val(this.value),this):(this.value=t,this.$inputEl.val(t),this)},t.prototype.getValue=function(){return this.value},t.prototype.formatValue=function(e){return this.params.formatValue?this.params.formatValue.call(this,e):e},t.prototype.init=function(){if(this.attachEvents(),this.$valueEl&&this.$valueEl.length){var e=this.formatValue(this.value);this.$valueEl.html(e)}return this},t.prototype.destroy=function(){var e=this;e.$el.trigger("stepper:beforedestroy"),e.emit("local::beforeDestroy stepperBeforeDestroy",e),delete e.$el[0].f7Stepper,e.detachEvents(),Utils.deleteProps(e),e=null},t}(Framework7Class),Stepper$1={name:"stepper",create:function(){var e=this;e.stepper=Utils.extend(ConstructorMethods({defaultSelector:".stepper",constructor:Stepper,app:e,domProp:"f7Stepper"}),{getValue:function(t){void 0===t&&(t=".stepper");var a=e.stepper.get(t);if(a)return a.getValue()},setValue:function(t,a){void 0===t&&(t=".stepper");var r=e.stepper.get(t);if(r)return r.setValue(a)}})},static:{Stepper:Stepper},on:{tabMounted:function(e){var t=this;$(e).find(".stepper-init").each((function(e,a){var r=$(a).dataset();t.stepper.create(Utils.extend({el:a},r||{}))}))},tabBeforeRemove:function(e){$(e).find(".stepper-init").each((function(e,t){t.f7Stepper&&t.f7Stepper.destroy()}))},pageInit:function(e){var t=this;e.$el.find(".stepper-init").each((function(e,a){var r=$(a).dataset();t.stepper.create(Utils.extend({el:a},r||{}))}))},pageBeforeRemove:function(e){e.$el.find(".stepper-init").each((function(e,t){t.f7Stepper&&t.f7Stepper.destroy()}))}},vnode:{"stepper-init":{insert:function(e){var t=e.elm,a=$(t).dataset();this.stepper.create(Utils.extend({el:t},a||{}))},destroy:function(e){var t=e.elm;t.f7Stepper&&t.f7Stepper.destroy()}}}},SmartSelect=function(e){function t(t,a){void 0===a&&(a={}),e.call(this,a,[t]);var r=this,n=Utils.extend({on:{}},t.params.smartSelect);void 0===n.searchbarDisableButton&&(n.searchbarDisableButton="aurora"!==t.theme),r.useModulesParams(n),r.params=Utils.extend({},n,a),r.app=t;var i=$(r.params.el).eq(0);if(0===i.length)return r;if(i[0].f7SmartSelect)return i[0].f7SmartSelect;var o,s=i.find("select").eq(0);if(0===s.length)return r;r.params.setValueText&&(0===(o=$(r.params.valueEl)).length&&(o=i.find(".item-after")),0===o.length&&(o=$('<div class="item-after"></div>')).insertAfter(i.find(".item-title")));var l=a.url;l||(i.attr("href")&&"#"!==i.attr("href")?l=i.attr("href"):s.attr("name")&&(l=s.attr("name").toLowerCase()+"-select/")),l||(l=r.params.url);var p=s[0].multiple,c=p?"checkbox":"radio",d=Utils.id();function u(){r.open()}function h(){var e=r.$selectEl.val();r.$el.trigger("smartselect:change",e),r.emit("local::change smartSelectChange",r,e),r.vl&&r.vl.clearCache(),r.setValueText()}function f(){var e,t,a,n=this.value,i=[];if("checkbox"===this.type){for(var o=0;o<r.selectEl.options.length;o+=1)(e=r.selectEl.options[o]).value===n&&(e.selected=this.checked),e.selected&&(t=(a=e.dataset?e.dataset.displayAs:$(e).data("display-value-as"))&&void 0!==a?a:e.textContent,i.push(t.trim()));r.maxLength&&r.checkMaxLength()}else i=[t=(a=(e=r.$selectEl.find('option[value="'+n+'"]')[0]).dataset?e.dataset.displayAs:$(e).data("display-as"))&&void 0!==a?a:e.textContent],r.selectEl.value=n;r.$selectEl.trigger("change"),r.params.setValueText&&r.$valueEl.text(r.formatValueText(i)),r.params.closeOnSelect&&"radio"===r.inputType&&r.close()}return Utils.extend(r,{$el:i,el:i[0],$selectEl:s,selectEl:s[0],$valueEl:o,valueEl:o&&o[0],url:l,multiple:p,inputType:c,id:d,inputName:c+"-"+d,selectName:s.attr("name"),maxLength:s.attr("maxlength")||a.maxLength}),i[0].f7SmartSelect=r,r.attachEvents=function(){i.on("click",u),i.on("change","select",h)},r.detachEvents=function(){i.off("click",u),i.off("change","select",h)},r.attachInputsEvents=function(){r.$containerEl.on("change",'input[type="checkbox"], input[type="radio"]',f)},r.detachInputsEvents=function(){r.$containerEl.off("change",'input[type="checkbox"], input[type="radio"]',f)},r.useModules(),r.init(),r}e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t;var a={view:{configurable:!0}};return t.prototype.setValue=function(e){var t,a,r,n=this,i=e,o=[];if(n.multiple){Array.isArray(i)||(i=[i]);for(var s=0;s<n.selectEl.options.length;s+=1)t=n.selectEl.options[s],i.indexOf(t.value)>=0?t.selected=!0:t.selected=!1,t.selected&&(r=(a=t.dataset?t.dataset.displayAs:$(t).data("display-value-as"))&&void 0!==a?a:t.textContent,o.push(r.trim()))}else(t=n.$selectEl.find('option[value="'+i+'"]')[0])&&(o=[r=(a=t.dataset?t.dataset.displayAs:$(t).data("display-as"))&&void 0!==a?a:t.textContent]),n.selectEl.value=i;return n.params.setValueText&&n.$valueEl.text(n.formatValueText(o)),n.$selectEl.trigger("change"),n},t.prototype.unsetValue=function(){var e=this;e.params.setValueText&&e.$valueEl.text(e.formatValueText([])),e.$selectEl.find("option").each((function(e,t){t.selected=!1,t.checked=!1})),e.$selectEl[0].value=null,e.$containerEl&&e.$containerEl.find('input[name="'+e.inputName+'"][type="checkbox"], input[name="'+e.inputName+'"][type="radio"]').prop("checked",!1),e.$selectEl.trigger("change")},t.prototype.getValue=function(){return this.$selectEl.val()},a.view.get=function(){var e,t=this.params,a=this.$el;if(t.view&&(e=t.view),e||(e=a.parents(".view").length&&a.parents(".view")[0].f7View),!e&&"page"===t.openIn)throw Error("Smart Select requires initialized View");return e},t.prototype.checkMaxLength=function(){var e=this.$containerEl;this.selectEl.selectedOptions.length>=this.maxLength?e.find('input[type="checkbox"]').each((function(e,t){t.checked?$(t).parents("li").removeClass("disabled"):$(t).parents("li").addClass("disabled")})):e.find(".disabled").removeClass("disabled")},t.prototype.formatValueText=function(e){return this.params.formatValueText?this.params.formatValueText.call(this,e,this):e.join(", ")},t.prototype.setValueText=function(e){var t=[];void 0!==e?t=Array.isArray(e)?e:[e]:this.$selectEl.find("option").each((function(e,a){var r=$(a);if(a.selected){var n=a.dataset?a.dataset.displayAs:r.data("display-value-as");n&&void 0!==n?t.push(n):t.push(a.textContent.trim())}})),this.params.setValueText&&this.$valueEl.text(this.formatValueText(t))},t.prototype.getItemsData=function(){var e,t=this,a=[];return t.$selectEl.find("option").each((function(r,n){var i=$(n),o=i.dataset(),s=o.optionImage||t.params.optionImage,l=o.optionIcon||t.params.optionIcon,p=s||l,c=o.optionColor,d=o.optionClass||"";i[0].disabled&&(d+=" disabled");var u=i.parent("optgroup")[0],h=u&&u.label,f=!1;u&&u!==e&&(f=!0,e=u,a.push({groupLabel:h,isLabel:f})),a.push({value:i[0].value,text:i[0].textContent.trim(),selected:i[0].selected,groupEl:u,groupLabel:h,image:s,icon:l,color:c,className:d,disabled:i[0].disabled,id:t.id,hasMedia:p,checkbox:"checkbox"===t.inputType,radio:"radio"===t.inputType,inputName:t.inputName,inputType:t.inputType})})),t.items=a,a},t.prototype.renderSearchbar=function(){var e=this;return e.params.renderSearchbar?e.params.renderSearchbar.call(e):'\n      <form class="searchbar">\n        <div class="searchbar-inner">\n          <div class="searchbar-input-wrap">\n            <input type="search" placeholder="'+e.params.searchbarPlaceholder+'"/>\n            <i class="searchbar-icon"></i>\n            <span class="input-clear-button"></span>\n          </div>\n          '+(e.params.searchbarDisableButton?'\n          <span class="searchbar-disable-button">'+e.params.searchbarDisableText+"</span>\n          ":"")+"\n        </div>\n      </form>\n    "},t.prototype.renderItem=function(e,t){var a,r=this;if(r.params.renderItem)return r.params.renderItem.call(r,e,t);if(e.isLabel)a='<li class="item-divider">'+e.groupLabel+"</li>";else{var n,i=e.selected;if(r.params.virtualList){var o=r.getValue();i=r.multiple?o.indexOf(e.value)>=0:o===e.value,r.multiple&&(n=r.multiple&&!i&&o.length===parseInt(r.maxLength,10))}a='\n        <li class="'+(e.className||"")+(n?" disabled":"")+'">\n          <label class="item-'+e.inputType+' item-content">\n            <input type="'+e.inputType+'" name="'+e.inputName+'" value="'+e.value+'" '+(i?"checked":"")+'/>\n            <i class="icon icon-'+e.inputType+'"></i>\n            '+(e.hasMedia?'\n              <div class="item-media">\n                '+(e.icon?'<i class="icon '+e.icon+'"></i>':"")+"\n                "+(e.image?'<img src="'+e.image+'">':"")+"\n              </div>\n            ":"")+'\n            <div class="item-inner">\n              <div class="item-title'+(e.color?" text-color-"+e.color:"")+'">'+e.text+"</div>\n            </div>\n          </label>\n        </li>\n      "}return a},t.prototype.renderItems=function(){var e=this;return e.params.renderItems?e.params.renderItems.call(e,e.items):"\n      "+e.items.map((function(t,a){return""+e.renderItem(t,a)})).join("")+"\n    "},t.prototype.renderPage=function(){var e=this;if(e.params.renderPage)return e.params.renderPage.call(e,e.items);var t=e.params.pageTitle;if(void 0===t){var a=e.$el.find(".item-title");t=a.length?a.text().trim():""}return'\n      <div class="page smart-select-page '+e.params.cssClass+'" data-name="smart-select-page" data-select-name="'+e.selectName+'">\n        <div class="navbar '+(e.params.navbarColorTheme?"color-"+e.params.navbarColorTheme:"")+'">\n          <div class="navbar-bg"></div>\n          <div class="navbar-inner sliding '+(e.params.navbarColorTheme?"color-"+e.params.navbarColorTheme:"")+'">\n            <div class="left">\n              <a class="link back">\n                <i class="icon icon-back"></i>\n                <span class="if-not-md">'+e.params.pageBackLinkText+"</span>\n              </a>\n            </div>\n            "+(t?'<div class="title">'+t+"</div>":"")+"\n            "+(e.params.searchbar?'<div class="subnavbar">'+e.renderSearchbar()+"</div>":"")+"\n          </div>\n        </div>\n        "+(e.params.searchbar?'<div class="searchbar-backdrop"></div>':"")+'\n        <div class="page-content">\n          <div class="list smart-select-list-'+e.id+" "+(e.params.virtualList?" virtual-list":"")+" "+(e.params.formColorTheme?"color-"+e.params.formColorTheme:"")+'">\n            <ul>'+(!e.params.virtualList&&e.renderItems(e.items))+"</ul>\n          </div>\n        </div>\n      </div>\n    "},t.prototype.renderPopup=function(){var e=this;if(e.params.renderPopup)return e.params.renderPopup.call(e,e.items);var t=e.params.pageTitle;if(void 0===t){var a=e.$el.find(".item-title");t=a.length?a.text().trim():""}return'\n      <div class="popup smart-select-popup '+(e.params.cssClass||"")+" "+(e.params.popupTabletFullscreen?"popup-tablet-fullscreen":"")+'" data-select-name="'+e.selectName+'">\n        <div class="view">\n          <div class="page smart-select-page '+(e.params.searchbar?"page-with-subnavbar":"")+'" data-name="smart-select-page">\n            <div class="navbar '+(e.params.navbarColorTheme?"color-"+e.params.navbarColorTheme:"")+'">\n              <div class="navbar-bg"></div>\n              <div class="navbar-inner sliding">\n                '+(t?'<div class="title">'+t+"</div>":"")+'\n                <div class="right">\n                  <a class="link popup-close" data-popup=".smart-select-popup[data-select-name=\''+e.selectName+"']\">"+e.params.popupCloseLinkText+"</span></a>\n                </div>\n                "+(e.params.searchbar?'<div class="subnavbar">'+e.renderSearchbar()+"</div>":"")+"\n              </div>\n            </div>\n            "+(e.params.searchbar?'<div class="searchbar-backdrop"></div>':"")+'\n            <div class="page-content">\n              <div class="list smart-select-list-'+e.id+" "+(e.params.virtualList?" virtual-list":"")+" "+(e.params.formColorTheme?"color-"+e.params.formColorTheme:"")+'">\n                <ul>'+(!e.params.virtualList&&e.renderItems(e.items))+"</ul>\n              </div>\n            </div>\n          </div>\n        </div>\n      </div>\n    "},t.prototype.renderSheet=function(){var e=this;return e.params.renderSheet?e.params.renderSheet.call(e,e.items):'\n      <div class="sheet-modal smart-select-sheet '+e.params.cssClass+'" data-select-name="'+e.selectName+'">\n        <div class="toolbar toolbar-top '+(e.params.toolbarColorTheme?"color-"+e.params.toolbarColorTheme:"")+'">\n          <div class="toolbar-inner">\n            <div class="left"></div>\n            <div class="right">\n              <a class="link sheet-close">'+e.params.sheetCloseLinkText+'</a>\n            </div>\n          </div>\n        </div>\n        <div class="sheet-modal-inner">\n          <div class="page-content">\n            <div class="list smart-select-list-'+e.id+" "+(e.params.virtualList?" virtual-list":"")+" "+(e.params.formColorTheme?"color-"+e.params.formColorTheme:"")+'">\n              <ul>'+(!e.params.virtualList&&e.renderItems(e.items))+"</ul>\n            </div>\n          </div>\n        </div>\n      </div>\n    "},t.prototype.renderPopover=function(){var e=this;return e.params.renderPopover?e.params.renderPopover.call(e,e.items):'\n      <div class="popover smart-select-popover '+e.params.cssClass+'" data-select-name="'+e.selectName+'">\n        <div class="popover-inner">\n          <div class="list smart-select-list-'+e.id+" "+(e.params.virtualList?" virtual-list":"")+" "+(e.params.formColorTheme?"color-"+e.params.formColorTheme:"")+'">\n            <ul>'+(!e.params.virtualList&&e.renderItems(e.items))+"</ul>\n          </div>\n        </div>\n      </div>\n    "},t.prototype.scrollToSelectedItem=function(){var e=this,t=e.params,a=e.$containerEl;if(!e.opened)return e;if(t.virtualList){var r;e.vl.items.forEach((function(e,t){void 0===r&&e.selected&&(r=t)})),void 0!==r&&e.vl.scrollToItem(r)}else{var n=a.find("input:checked").parents("li");if(!n.length)return e;var i=a.find(".page-content");i.scrollTop(n.offset().top-i.offset().top-parseInt(i.css("padding-top"),10))}return e},t.prototype.onOpen=function(e,t){var a=this,r=a.app,n=$(t);if(a.$containerEl=n,a.openedIn=e,a.opened=!0,a.params.virtualList&&(a.vl=r.virtualList.create({el:n.find(".virtual-list"),items:a.items,renderItem:a.renderItem.bind(a),height:a.params.virtualListHeight,searchByItem:function(e,t){return!!(t.text&&t.text.toLowerCase().indexOf(e.trim().toLowerCase())>=0)}})),a.params.scrollToSelectedItem&&a.scrollToSelectedItem(),a.params.searchbar){var i=n.find(".searchbar");if("page"===e&&"ios"===r.theme&&(i=$(r.navbar.getElByPage(n)).find(".searchbar")),a.params.appendSearchbarNotFound&&("page"===e||"popup"===e)){var o=null;(o="string"==typeof a.params.appendSearchbarNotFound?$('<div class="block searchbar-not-found">'+a.params.appendSearchbarNotFound+"</div>"):"boolean"==typeof a.params.appendSearchbarNotFound?$('<div class="block searchbar-not-found">Nothing found</div>'):a.params.appendSearchbarNotFound)&&n.find(".page-content").append(o[0])}var s=Utils.extend({el:i,backdropEl:n.find(".searchbar-backdrop"),searchContainer:".smart-select-list-"+a.id,searchIn:".item-title"},"object"==typeof a.params.searchbar?a.params.searchbar:{});a.searchbar=r.searchbar.create(s)}a.maxLength&&a.checkMaxLength(),a.params.closeOnSelect&&a.$containerEl.find('input[type="radio"][name="'+a.inputName+'"]:checked').parents("label").once("click",(function(){a.close()})),a.attachInputsEvents(),a.$el.trigger("smartselect:open"),a.emit("local::open smartSelectOpen",a)},t.prototype.onOpened=function(){this.$el.trigger("smartselect:opened"),this.emit("local::opened smartSelectOpened",this)},t.prototype.onClose=function(){var e=this;e.destroyed||(e.vl&&e.vl.destroy&&(e.vl.destroy(),e.vl=null,delete e.vl),e.searchbar&&e.searchbar.destroy&&(e.searchbar.destroy(),e.searchbar=null,delete e.searchbar),e.detachInputsEvents(),e.$el.trigger("smartselect:close"),e.emit("local::close smartSelectClose",e))},t.prototype.onClosed=function(){var e=this;e.destroyed||(e.opened=!1,e.$containerEl=null,delete e.$containerEl,e.$el.trigger("smartselect:closed"),e.emit("local::closed smartSelectClosed",e))},t.prototype.openPage=function(){var e=this;if(e.opened)return e;e.getItemsData();var t=e.renderPage(e.items);return e.view.router.navigate({url:e.url,route:{content:t,path:e.url,on:{pageBeforeIn:function(t,a){e.onOpen("page",a.el)},pageAfterIn:function(t,a){e.onOpened("page",a.el)},pageBeforeOut:function(t,a){e.onClose("page",a.el)},pageAfterOut:function(t,a){e.onClosed("page",a.el)}}}}),e},t.prototype.openPopup=function(){var e=this;if(e.opened)return e;e.getItemsData();var t={content:e.renderPopup(e.items),push:e.params.popupPush,swipeToClose:e.params.popupSwipeToClose,on:{popupOpen:function(t){e.onOpen("popup",t.el)},popupOpened:function(t){e.onOpened("popup",t.el)},popupClose:function(t){e.onClose("popup",t.el)},popupClosed:function(t){e.onClosed("popup",t.el)}}};return e.params.routableModals&&e.view?e.view.router.navigate({url:e.url,route:{path:e.url,popup:t}}):e.modal=e.app.popup.create(t).open(),e},t.prototype.openSheet=function(){var e=this;if(e.opened)return e;e.getItemsData();var t={content:e.renderSheet(e.items),backdrop:!1,scrollToEl:e.$el,closeByOutsideClick:!0,push:e.params.sheetPush,swipeToClose:e.params.sheetSwipeToClose,on:{sheetOpen:function(t){e.onOpen("sheet",t.el)},sheetOpened:function(t){e.onOpened("sheet",t.el)},sheetClose:function(t){e.onClose("sheet",t.el)},sheetClosed:function(t){e.onClosed("sheet",t.el)}}};return e.params.routableModals&&e.view?e.view.router.navigate({url:e.url,route:{path:e.url,sheet:t}}):e.modal=e.app.sheet.create(t).open(),e},t.prototype.openPopover=function(){var e=this;if(e.opened)return e;e.getItemsData();var t={content:e.renderPopover(e.items),targetEl:e.$el,on:{popoverOpen:function(t){e.onOpen("popover",t.el)},popoverOpened:function(t){e.onOpened("popover",t.el)},popoverClose:function(t){e.onClose("popover",t.el)},popoverClosed:function(t){e.onClosed("popover",t.el)}}};return e.params.routableModals&&e.view?e.view.router.navigate({url:e.url,route:{path:e.url,popover:t}}):e.modal=e.app.popover.create(t).open(),e},t.prototype.open=function(e){var t=this;if(t.opened)return t;var a=!1;function r(){a=!0}return t.$el&&t.$el.trigger("smartselect:beforeopen",{prevent:r}),t.emit("local::beforeOpen smartSelectBeforeOpen",t,r),a||t["open"+(e||t.params.openIn).split("").map((function(e,t){return 0===t?e.toUpperCase():e})).join("")](),t},t.prototype.close=function(){var e=this;return e.opened?(e.params.routableModals&&e.view||"page"===e.openedIn?e.view.router.back():(e.modal.once("modalClosed",(function(){Utils.nextTick((function(){e.destroyed||(e.modal.destroy(),delete e.modal)}))})),e.modal.close()),e):e},t.prototype.init=function(){this.attachEvents(),this.setValueText()},t.prototype.destroy=function(){var e=this;e.emit("local::beforeDestroy smartSelectBeforeDestroy",e),e.$el.trigger("smartselect:beforedestroy"),e.detachEvents(),delete e.$el[0].f7SmartSelect,Utils.deleteProps(e),e.destroyed=!0},Object.defineProperties(t.prototype,a),t}(Framework7Class),SmartSelect$1={name:"smartSelect",params:{smartSelect:{el:void 0,valueEl:void 0,setValueText:!0,formatValueText:null,openIn:"page",popupPush:!1,popupSwipeToClose:void 0,sheetPush:!1,sheetSwipeToClose:void 0,pageTitle:void 0,pageBackLinkText:"Back",popupCloseLinkText:"Close",popupTabletFullscreen:!1,sheetCloseLinkText:"Done",searchbar:!1,searchbarPlaceholder:"Search",searchbarDisableText:"Cancel",searchbarDisableButton:void 0,closeOnSelect:!1,virtualList:!1,virtualListHeight:void 0,scrollToSelectedItem:!1,formColorTheme:void 0,navbarColorTheme:void 0,routableModals:!0,url:"select/",cssClass:"",renderPage:void 0,renderPopup:void 0,renderSheet:void 0,renderPopover:void 0,renderItems:void 0,renderItem:void 0,renderSearchbar:void 0}},static:{SmartSelect:SmartSelect},create:function(){var e=this;e.smartSelect=Utils.extend(ConstructorMethods({defaultSelector:".smart-select",constructor:SmartSelect,app:e,domProp:"f7SmartSelect"}),{open:function(t){var a=e.smartSelect.get(t);if(a&&a.open)return a.open()},close:function(t){var a=e.smartSelect.get(t);if(a&&a.close)return a.close()}})},on:{tabMounted:function(e){var t=this;$(e).find(".smart-select-init").each((function(e,a){t.smartSelect.create(Utils.extend({el:a},$(a).dataset()))}))},tabBeforeRemove:function(e){$(e).find(".smart-select-init").each((function(e,t){t.f7SmartSelect&&t.f7SmartSelect.destroy&&t.f7SmartSelect.destroy()}))},pageInit:function(e){var t=this;e.$el.find(".smart-select-init").each((function(e,a){t.smartSelect.create(Utils.extend({el:a},$(a).dataset()))}))},pageBeforeRemove:function(e){e.$el.find(".smart-select-init").each((function(e,t){t.f7SmartSelect&&t.f7SmartSelect.destroy&&t.f7SmartSelect.destroy()}))}},clicks:{".smart-select":function(e,t){e[0].f7SmartSelect||this.smartSelect.create(Utils.extend({el:e},t)).open()}},vnode:{"smart-select-init":{insert:function(e){var t=e.elm;this.smartSelect.create(Utils.extend({el:t},$(t).dataset()))},destroy:function(e){var t=e.elm;t.f7SmartSelect&&t.f7SmartSelect.destroy&&t.f7SmartSelect.destroy()}}}};function getElMinSize(e,t){var a=t.css("min-"+e);return"auto"===a||"none"===a?a=0:a.indexOf("px")>=0?a=parseFloat(a):a.indexOf("%")>=0&&(a=t.parent()[0]["height"===e?"offsetHeight":"offsetWidth"]*parseFloat(a)/100),a}function getElMaxSize(e,t){var a=t.css("max-"+e);return"auto"===a||"none"===a?a=null:a.indexOf("px")>=0?a=parseFloat(a):a.indexOf("%")>=0&&(a=t.parent()[0]["height"===e?"offsetHeight":"offsetWidth"]*parseFloat(a)/100),a}var Grid={init:function(){var e,t,a,r,n,i,o,s,l,p,c,d,u,h,f,m,v,g=this;$(document).on(g.touchEvents.start,".col > .resize-handler, .row > .resize-handler",(function(s){e||t||(n=$(s.target).closest(".resize-handler"),a="touchstart"===s.type?s.targetTouches[0].pageX:s.pageX,r="touchstart"===s.type?s.targetTouches[0].pageY:s.pageY,e=!0,i=void 0,o=void 0,v=void 0)})),g.on("touchmove",(function(b){if(e){var y=1===n.parent(".row").length,w=y?"height":"width",C=y?"offsetHeight":"offsetWidth";t||(!(i=n.parent(y?".row":".col")).length||i.hasClass("resizable")&&!i.hasClass("resizable-fixed")||(i=i.prevAll(".resizable:not(.resizable-fixed)").eq(0)),!(o=i.next(y?".row":".col")).length||o.hasClass("resizable")&&!o.hasClass("resizable-fixed")||(o=o.nextAll(".resizable:not(.resizable-fixed)").eq(0)),i.length&&(s=i[0][C],l=getElMinSize(w,i),p=getElMaxSize(w,i),h=i.parent()[0][C],f=i.parent().children(y?".row":'[class*="col-"], .col').length,m=parseFloat(i.css(y?"--f7-grid-row-gap":"--f7-grid-gap"))),o.length&&(c=o[0][C],d=getElMinSize(w,o),u=getElMaxSize(w,o),i.length||(h=o.parent()[0][C],f=o.parent().children(y?".row":'[class*="col-"], .col').length,m=parseFloat(o.css(y?"--f7-grid-row-gap":"--f7-grid-gap"))))),t=!0;var x="touchmove"===b.type?b.targetTouches[0].pageX:b.pageX,$="touchmove"===b.type?b.targetTouches[0].pageY:b.pageY;if(void 0!==v||y||(v=!!(v||Math.abs($-r)>Math.abs(x-a))),v)return e=!1,void(t=!1);var k=i.hasClass("resizable-absolute")||o.hasClass("resizable-absolute"),E=!y||y&&!k;if(E&&!o.length||!i.length)return e=!1,void(t=!1);b.preventDefault();var T,S,M=y?$-r:x-a;if(i.length&&((T=s+M)<l&&(M=(T=l)-s),p&&T>p&&(M=(T=p)-s)),o.length&&E&&((S=c-M)<d&&(T=s+(M=c-(S=d))),u&&S>u&&(T=s+(M=c-(S=u)))),k)return i[0].style[w]=T+"px",E&&(o[0].style[w]=S+"px"),i.trigger("grid:resize"),o.trigger("grid:resize"),g.emit("gridResize",i[0]),void g.emit("gridResize",o[0]);var P=(f-1)*m/f,O=y?f-1+" * var(--f7-grid-row-gap) / "+f:"(var(--f7-cols-per-row) - 1) * var(--f7-grid-gap) / var(--f7-cols-per-row)",D=T+P,I=S+P;i[0].style[w]="calc("+D/h*100+"% - "+O+")",o[0].style[w]="calc("+I/h*100+"% - "+O+")",i.trigger("grid:resize"),o.trigger("grid:resize"),g.emit("gridResize",i[0]),g.emit("gridResize",o[0])}})),g.on("touchend",(function(){e&&(t||(e=!1),e=!1,t=!1)}))}},Grid$1={name:"grid",create:function(){Utils.extend(this,{grid:{init:Grid.init.bind(this)}})},on:{init:function(){this.grid.init()}}},Calendar=function(e){function t(t,a){void 0===a&&(a={}),e.call(this,a,[t]);var r,n,i=this;if(i.params=Utils.extend({},t.params.calendar,a),i.params.containerEl&&0===(r=$(i.params.containerEl)).length)return i;i.params.inputEl&&(n=$(i.params.inputEl));var o="horizontal"===i.params.direction,s=1;o&&(s=t.rtl?-1:1),Utils.extend(i,{app:t,$containerEl:r,containerEl:r&&r[0],inline:r&&r.length>0,$inputEl:n,inputEl:n&&n[0],initialized:!1,opened:!1,url:i.params.url,isHorizontal:o,inverter:s,animating:!1,hasTimePicker:i.params.timePicker&&!i.params.rangePicker&&!i.params.multiple}),i.dayFormatter=new Intl.DateTimeFormat(i.params.locale,{day:"numeric"}),i.monthFormatter=new Intl.DateTimeFormat(i.params.locale,{month:"long"}),i.yearFormatter=new Intl.DateTimeFormat(i.params.locale,{year:"numeric"}),i.timeSelectorFormatter=new Intl.DateTimeFormat(i.params.locale,i.params.timePickerFormat);var l=i.params,p=l.monthNames,c=l.monthNamesShort,d=l.dayNames,u=l.dayNamesShort,h=i.getIntlNames(),f=h.monthNamesIntl,m=h.monthNamesShortIntl,v=h.dayNamesIntl,g=h.dayNamesShortIntl;function b(){i.open()}function y(e){e.preventDefault()}function w(){i.setValue([]),i.opened&&i.update()}function C(e){var t=$(e.target);!i.destroyed&&i.params&&(i.isPopover()||i.opened&&!i.closing&&(t.closest('[class*="backdrop"]').length||(n&&n.length>0?t[0]!==n[0]&&0===t.closest(".sheet-modal, .calendar-modal").length&&i.close():0===$(e.target).closest(".sheet-modal, .calendar-modal").length&&i.close())))}return"auto"===p&&(p=f),"auto"===c&&(c=m),"auto"===d&&(d=v),"auto"===u&&(u=g),Utils.extend(i,{monthNames:p,monthNamesShort:c,dayNames:d,dayNamesShort:u}),Utils.extend(i,{attachInputEvents:function(){i.$inputEl.on("click",b),i.$inputEl.on("input:clear",w),i.params.inputReadOnly&&i.$inputEl.on("focus mousedown",y)},detachInputEvents:function(){i.$inputEl.off("click",b),i.$inputEl.off("input:clear",w),i.params.inputReadOnly&&i.$inputEl.off("focus mousedown",y)},attachHtmlEvents:function(){t.on("click",C)},detachHtmlEvents:function(){t.off("click",C)}}),i.attachCalendarEvents=function(){var e,a,r,n,o,s,l,p,c,d,u,h,f,m=!0,v=i.$el,g=i.$wrapperEl;function b(t){a||e||(e=!0,r="touchstart"===t.type?t.targetTouches[0].pageX:t.pageX,o=r,n="touchstart"===t.type?t.targetTouches[0].pageY:t.pageY,s=n,l=(new Date).getTime(),u=0,m=!0,f=void 0,p=i.monthsTranslate)}function y(t){if(e){var l=i.isHorizontal;o="touchmove"===t.type?t.targetTouches[0].pageX:t.pageX,s="touchmove"===t.type?t.targetTouches[0].pageY:t.pageY,void 0===f&&(f=!!(f||Math.abs(s-n)>Math.abs(o-r))),l&&f?e=!1:(t.preventDefault(),i.animating?e=!1:(m=!1,a||(a=!0,c=g[0].offsetWidth,d=g[0].offsetHeight,g.transition(0)),u=(h=l?o-r:s-n)/(l?c:d),p=100*(i.monthsTranslate*i.inverter+u),g.transform("translate3d("+(l?p:0)+"%, "+(l?0:p)+"%, 0)")))}}function w(){if(!e||!a)return e=!1,void(a=!1);e=!1,a=!1,(new Date).getTime()-l<300?Math.abs(h)<10?i.resetMonth():h>=10?t.rtl?i.nextMonth():i.prevMonth():t.rtl?i.prevMonth():i.nextMonth():u<=-.5?t.rtl?i.prevMonth():i.nextMonth():u>=.5?t.rtl?i.nextMonth():i.prevMonth():i.resetMonth(),setTimeout((function(){m=!0}),100)}function C(e){if(m){var t=$(e.target).parents(".calendar-day");if(0===t.length&&$(e.target).hasClass("calendar-day")&&(t=$(e.target)),0!==t.length&&!t.hasClass("calendar-day-disabled")){i.params.rangePicker||(t.hasClass("calendar-day-next")&&i.nextMonth(),t.hasClass("calendar-day-prev")&&i.prevMonth());var a=parseInt(t.attr("data-year"),10),r=parseInt(t.attr("data-month"),10),n=parseInt(t.attr("data-day"),10);if(i.emit("local::dayClick calendarDayClick",i,t[0],a,r,n),!t.hasClass("calendar-day-selected")||i.params.multiple||i.params.rangePicker){var o=new Date(a,r,n,0,0,0);i.hasTimePicker&&(i.value&&i.value[0]?o.setHours(i.value[0].getHours(),i.value[0].getMinutes()):o.setHours((new Date).getHours(),(new Date).getMinutes())),i.addValue(o)}i.params.closeOnSelect&&(i.params.rangePicker&&2===i.value.length||!i.params.rangePicker)&&i.close()}}}function x(){i.nextMonth()}function k(){i.prevMonth()}function E(){i.nextYear()}function T(){i.prevYear()}function S(){v.append(i.renderMonthPicker())}function M(){var e=$(this);if(e.hasClass("calendar-month-picker-item-current"))v.find(".calendar-month-picker").remove();else{v.find(".calendar-month-picker-item-current").add(e).toggleClass("calendar-month-picker-item-current");var t=e.index()-(parseInt(i.$el.find(".calendar-month-current").attr("data-locale-month"),10)-i.currentMonth);i.setYearMonth(i.currentYear,t,0),setTimeout((function(){v.find(".calendar-month-picker").remove()}),200)}}function P(){v.append(i.renderYearPicker());var e=v.find(".calendar-year-picker-item-current"),t=v.find(".calendar-year-picker");e&&e.length&&t.scrollTop(e[0].offsetTop-t[0].offsetHeight/2+e[0].offsetHeight/2)}function O(){var e=$(this);if(e.hasClass("calendar-year-picker-item-current"))v.find(".calendar-year-picker").remove();else{v.find(".calendar-year-picker-item-current").add(e).toggleClass("calendar-year-picker-item-current");var t=parseInt(e.attr("data-year"),10);i.setYearMonth(t,void 0,0),setTimeout((function(){v.find(".calendar-year-picker").remove()}),200)}}function D(){i.openTimePicker()}function I(){i.closeTimePicker()}var B=!("touchstart"!==t.touchEvents.start||!t.support.passiveListener)&&{passive:!0,capture:!1};v.find(".calendar-prev-month-button").on("click",k),v.find(".calendar-next-month-button").on("click",x),v.find(".calendar-prev-year-button").on("click",T),v.find(".calendar-next-year-button").on("click",E),i.params.monthPicker&&(v.find(".current-month-value").on("click",S),v.on("click",".calendar-month-picker-item",M)),i.params.yearPicker&&(v.find(".current-year-value").on("click",P),v.on("click",".calendar-year-picker-item",O)),i.hasTimePicker&&(v.find(".calendar-time-selector a").on("click",D),v.on("click",".calendar-time-picker-close",I)),g.on("click",C),i.params.touchMove&&(g.on(t.touchEvents.start,b,B),t.on("touchmove:active",y),t.on("touchend:passive",w)),i.detachCalendarEvents=function(){v.find(".calendar-prev-month-button").off("click",k),v.find(".calendar-next-month-button").off("click",x),v.find(".calendar-prev-year-button").off("click",T),v.find(".calendar-next-year-button").off("click",E),i.params.monthPicker&&(v.find(".current-month-value").off("click",S),v.off("click",".calendar-month-picker-item",M)),i.params.yearPicker&&(v.find(".current-year-value").off("click",P),v.off("click",".calendar-year-picker-item",O)),i.hasTimePicker&&(v.find(".calendar-time-selector a").off("click",D),v.off("click",".calendar-time-picker-close",I)),g.off("click",C),i.params.touchMove&&(g.off(t.touchEvents.start,b,B),t.off("touchmove:active",y),t.off("touchend:passive",w))}},i.init(),i}e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t;var a={view:{configurable:!0}};return a.view.get=function(){var e,t=this.$inputEl,a=this.app,r=this.params;return r.view?e=r.view:t&&(e=t.parents(".view").length&&t.parents(".view")[0].f7View),e||(e=a.views.main),e},t.prototype.getIntlNames=function(){for(var e,t,a,r=this.params.locale,n=[],i=[],o=[],s=[],l=new Intl.DateTimeFormat(r,{month:"long"}),p=new Intl.DateTimeFormat(r,{month:"short"}),c=new Intl.DateTimeFormat(r,{weekday:"long"}),d=new Intl.DateTimeFormat(r,{weekday:"short"}),u=0;u<24;u+=1){var h=(new Date).setMonth(u,1),f=this.yearFormatter.format(h);e&&f!==e&&(t&&(a=!0),t=!0,e=f),e||(e=f),t&&e===f&&!a&&(n.push(l.format(h)),i.push(p.format(h)))}for(var m=(new Date).getDay(),v=0;v<7;v+=1){var g=(new Date).getTime()+24*(v-m)*60*60*1e3;o.push(c.format(g)),s.push(d.format(g))}return{monthNamesIntl:n,monthNamesShortIntl:i,dayNamesIntl:o,dayNamesShortIntl:s}},t.prototype.normalizeDate=function(e){var t=new Date(e);return this.hasTimePicker?new Date(t.getFullYear(),t.getMonth(),t.getDate(),t.getHours(),t.getMinutes()):new Date(t.getFullYear(),t.getMonth(),t.getDate())},t.prototype.normalizeValues=function(e){var t=this,a=[];return e&&Array.isArray(e)&&(a=e.map((function(e){return t.normalizeDate(e)}))),a},t.prototype.initInput=function(){this.$inputEl&&this.params.inputReadOnly&&this.$inputEl.prop("readOnly",!0)},t.prototype.isPopover=function(){var e=this.app,t=this.modal,a=this.params;if("sheet"===a.openIn)return!1;if(t&&"popover"!==t.type)return!1;if(!this.inline&&this.inputEl){if("popover"===a.openIn)return!0;if(e.device.ios)return!!e.device.ipad;if(e.width>=768)return!0;if(e.device.desktop&&"aurora"===e.theme)return!0}return!1},t.prototype.formatDate=function(e){var t=new Date(e),a=t.getFullYear(),r=t.getMonth(),n=r+1,i=t.getDate(),o=t.getDay(),s=this.monthNames,l=this.monthNamesShort,p=this.dayNames,c=this.dayNamesShort,d=this.params,u=d.dateFormat,h=d.locale;function f(e){return e<10?"0"+e:e}if("string"==typeof u){var m={yyyy:a,yy:String(a).substring(2),mm:f(n),m:n,MM:s[r],M:l[r],dd:f(i),d:i,DD:p[o],D:c[o]};if(this.params.timePicker){var v=t.getHours(),g=t.getMinutes(),b=t.getSeconds(),y=v;v>12&&(y=v-12),0===v&&(y=12);var w=v>=12&&0!==v?"pm":"am";Object.assign(m,{HH:f(v),H:v,hh:f(y),h:y,ss:f(b),s:b,":mm":f(g),":m":g,a:w,A:w.toUpperCase()})}var C=new RegExp(Object.keys(m).map((function(e){return"("+e+")"})).join("|"),"g");return u.replace(C,(function(e){return e in m?m[e]:e}))}return"function"==typeof u?u(t):new Intl.DateTimeFormat(h,u).format(t)},t.prototype.formatValue=function(){var e=this,t=e.value;return e.params.formatValue?e.params.formatValue.call(e,t):t.map((function(t){return e.formatDate(t)})).join(e.params.rangePicker?" - ":", ")},t.prototype.addValue=function(e){var t=this.params,a=t.multiple,r=t.rangePicker,n=t.rangePickerMinDays,i=t.rangePickerMaxDays;if(a){var o;this.value||(this.value=[]);for(var s=0;s<this.value.length;s+=1)new Date(e).getTime()===new Date(this.value[s]).getTime()&&(o=s);void 0===o?this.value.push(e):this.value.splice(o,1),this.updateValue()}else r?(this.value||(this.value=[]),2!==this.value.length&&0!==this.value.length||(this.value=[]),0===this.value.length||Math.abs(this.value[0].getTime()-e.getTime())>=60*(n-1)*60*24*1e3&&(0===i||Math.abs(this.value[0].getTime()-e.getTime())<=60*(i-1)*60*24*1e3)?this.value.push(e):this.value=[],this.value.sort((function(e,t){return e-t})),this.updateValue()):(this.value=[e],this.updateValue())},t.prototype.setValue=function(e){var t=this.value;if(Array.isArray(t)&&Array.isArray(e)&&t.length===e.length){var a=!0;if(t.forEach((function(t,r){t!==e[r]&&(a=!1)})),a)return}this.value=e,this.updateValue()},t.prototype.getValue=function(){return this.value},t.prototype.updateValue=function(e){var t,a,r=this.$el,n=this.$wrapperEl,i=this.$inputEl,o=this.value,s=this.params;if(r&&r.length>0)if(n.find(".calendar-day-selected").removeClass("calendar-day-selected"),s.rangePicker&&2===o.length)for(t=new Date(o[0]).getTime();t<=new Date(o[1]).getTime();t+=864e5)a=new Date(t),n.find('.calendar-day[data-date="'+a.getFullYear()+"-"+a.getMonth()+"-"+a.getDate()+'"]').addClass("calendar-day-selected");else for(t=0;t<this.value.length;t+=1)a=new Date(o[t]),n.find('.calendar-day[data-date="'+a.getFullYear()+"-"+a.getMonth()+"-"+a.getDate()+'"]').addClass("calendar-day-selected");if(e||this.emit("local::change calendarChange",this,o),r&&r.length>0&&this.hasTimePicker&&r.find(".calendar-time-selector a").text(o&&o.length?this.timeSelectorFormatter.format(o[0]):this.params.timePickerPlaceholder),i&&i.length||s.header){var l=this.formatValue(o);s.header&&r&&r.length&&r.find(".calendar-selected-date").text(l),i&&i.length&&!e&&(i.val(l),i.trigger("change"))}},t.prototype.updateCurrentMonthYear=function(e){var t,a,r=this.$months,n=this.$el,i=this.monthNames;void 0===e?(this.currentMonth=parseInt(r.eq(1).attr("data-month"),10),this.currentYear=parseInt(r.eq(1).attr("data-year"),10),t=r.eq(1).attr("data-locale-month"),a=r.eq(1).attr("data-locale-year")):(this.currentMonth=parseInt(r.eq("next"===e?r.length-1:0).attr("data-month"),10),this.currentYear=parseInt(r.eq("next"===e?r.length-1:0).attr("data-year"),10),t=r.eq("next"===e?r.length-1:0).attr("data-locale-month"),a=r.eq("next"===e?r.length-1:0).attr("data-locale-year")),n.find(".current-month-value").text(i[t]),n.find(".current-year-value").text(a)},t.prototype.update=function(){var e=this,t=e.currentYear,a=e.currentMonth,r=e.$wrapperEl,n=new Date(t,a),i=e.renderMonth(n,"prev"),o=e.renderMonth(n),s=e.renderMonth(n,"next");r.transition(0).html(""+i+o+s).transform("translate3d(0,0,0)"),e.$months=r.find(".calendar-month"),e.monthsTranslate=0,e.setMonthsTranslate(),e.$months.each((function(t,a){e.emit("local::monthAdd calendarMonthAdd",a)}))},t.prototype.onMonthChangeStart=function(e){var t=this.$months,a=this.currentYear,r=this.currentMonth;this.updateCurrentMonthYear(e),t.removeClass("calendar-month-current calendar-month-prev calendar-month-next");var n="next"===e?t.length-1:0;t.eq(n).addClass("calendar-month-current"),t.eq("next"===e?n-1:n+1).addClass("next"===e?"calendar-month-prev":"calendar-month-next"),this.emit("local::monthYearChangeStart calendarMonthYearChangeStart",this,a,r)},t.prototype.onMonthChangeEnd=function(e,t){var a,r,n,i=this.currentYear,o=this.currentMonth,s=this.$wrapperEl,l=this.monthsTranslate;this.animating=!1,s.find(".calendar-month:not(.calendar-month-prev):not(.calendar-month-current):not(.calendar-month-next)").remove(),void 0===e&&(e="next",t=!0),t?(s.find(".calendar-month-next, .calendar-month-prev").remove(),r=this.renderMonth(new Date(i,o),"prev"),a=this.renderMonth(new Date(i,o),"next")):n=this.renderMonth(new Date(i,o),e),("next"===e||t)&&s.append(n||a),("prev"===e||t)&&s.prepend(n||r);var p=s.find(".calendar-month");this.$months=p,this.setMonthsTranslate(l),this.emit("local::monthAdd calendarMonthAdd",this,"next"===e?p.eq(p.length-1)[0]:p.eq(0)[0]),this.emit("local::monthYearChangeEnd calendarMonthYearChangeEnd",this,i,o)},t.prototype.setMonthsTranslate=function(e){var t=this.$months,a=this.isHorizontal,r=this.inverter;e=e||this.monthsTranslate||0,void 0===this.monthsTranslate&&(this.monthsTranslate=e),t.removeClass("calendar-month-current calendar-month-prev calendar-month-next");var n=100*-(e+1)*r,i=100*-e*r,o=100*-(e-1)*r;t.eq(0).transform("translate3d("+(a?n:0)+"%, "+(a?0:n)+"%, 0)").addClass("calendar-month-prev"),t.eq(1).transform("translate3d("+(a?i:0)+"%, "+(a?0:i)+"%, 0)").addClass("calendar-month-current"),t.eq(2).transform("translate3d("+(a?o:0)+"%, "+(a?0:o)+"%, 0)").addClass("calendar-month-next")},t.prototype.nextMonth=function(e){var t=this,a=t.params,r=t.$wrapperEl,n=t.inverter,i=t.isHorizontal;void 0!==e&&"object"!=typeof e||(e="",a.animate||(e=0));var o=parseInt(t.$months.eq(t.$months.length-1).attr("data-month"),10),s=parseInt(t.$months.eq(t.$months.length-1).attr("data-year"),10),l=new Date(s,o).getTime(),p=!t.animating;if(a.maxDate&&l>new Date(a.maxDate).getTime())t.resetMonth();else{if(t.monthsTranslate-=1,o===t.currentMonth){var c=100*-t.monthsTranslate*n,d=$(t.renderMonth(l,"next")).transform("translate3d("+(i?c:0)+"%, "+(i?0:c)+"%, 0)").addClass("calendar-month-next");r.append(d[0]),t.$months=r.find(".calendar-month"),t.emit("local::monthAdd calendarMonthAdd",t.$months.eq(t.$months.length-1)[0])}t.animating=!0,t.onMonthChangeStart("next");var u=100*t.monthsTranslate*n;r.transition(e).transform("translate3d("+(i?u:0)+"%, "+(i?0:u)+"%, 0)"),p&&r.transitionEnd((function(){t.onMonthChangeEnd("next")})),a.animate||t.onMonthChangeEnd("next")}},t.prototype.prevMonth=function(e){var t=this,a=t.params,r=t.$wrapperEl,n=t.inverter,i=t.isHorizontal;void 0!==e&&"object"!=typeof e||(e="",a.animate||(e=0));var o=parseInt(t.$months.eq(0).attr("data-month"),10),s=parseInt(t.$months.eq(0).attr("data-year"),10),l=new Date(s,o+1,-1).getTime(),p=!t.animating;if(a.minDate){var c=new Date(a.minDate);if(l<(c=new Date(c.getFullYear(),c.getMonth(),1)).getTime())return void t.resetMonth()}if(t.monthsTranslate+=1,o===t.currentMonth){var d=100*-t.monthsTranslate*n,u=$(t.renderMonth(l,"prev")).transform("translate3d("+(i?d:0)+"%, "+(i?0:d)+"%, 0)").addClass("calendar-month-prev");r.prepend(u[0]),t.$months=r.find(".calendar-month"),t.emit("local::monthAdd calendarMonthAdd",t.$months.eq(0)[0])}t.animating=!0,t.onMonthChangeStart("prev");var h=100*t.monthsTranslate*n;r.transition(e).transform("translate3d("+(i?h:0)+"%, "+(i?0:h)+"%, 0)"),p&&r.transitionEnd((function(){t.onMonthChangeEnd("prev")})),a.animate||t.onMonthChangeEnd("prev")},t.prototype.resetMonth=function(e){void 0===e&&(e="");var t=this.$wrapperEl,a=this.inverter,r=this.isHorizontal,n=100*this.monthsTranslate*a;t.transition(e).transform("translate3d("+(r?n:0)+"%, "+(r?0:n)+"%, 0)")},t.prototype.setYearMonth=function(e,t,a){var r,n=this,i=n.params,o=n.isHorizontal,s=n.$wrapperEl,l=n.inverter;if(void 0===e&&(e=n.currentYear),void 0===t&&(t=n.currentMonth),void 0!==a&&"object"!=typeof a||(a="",i.animate||(a=0)),r=e<n.currentYear?new Date(e,t+1,-1).getTime():new Date(e,t).getTime(),i.maxDate&&r>new Date(i.maxDate).getTime())return!1;if(i.minDate){var p=new Date(i.minDate);if(r<(p=new Date(p.getFullYear(),p.getMonth(),1)).getTime())return!1}var c=new Date(n.currentYear,n.currentMonth).getTime(),d=r>c?"next":"prev",u=n.renderMonth(new Date(e,t));n.monthsTranslate=n.monthsTranslate||0;var h,f=n.monthsTranslate,m=!n.animating&&0!==a;r>c?(n.monthsTranslate-=1,n.animating||n.$months.eq(n.$months.length-1).remove(),s.append(u),n.$months=s.find(".calendar-month"),h=100*-(f-1)*l,n.$months.eq(n.$months.length-1).transform("translate3d("+(o?h:0)+"%, "+(o?0:h)+"%, 0)").addClass("calendar-month-next")):(n.monthsTranslate+=1,n.animating||n.$months.eq(0).remove(),s.prepend(u),n.$months=s.find(".calendar-month"),h=100*-(f+1)*l,n.$months.eq(0).transform("translate3d("+(o?h:0)+"%, "+(o?0:h)+"%, 0)").addClass("calendar-month-prev")),n.emit("local::monthAdd calendarMonthAdd","next"===d?n.$months.eq(n.$months.length-1)[0]:n.$months.eq(0)[0]),n.animating=!0,n.onMonthChangeStart(d);var v=100*n.monthsTranslate*l;s.transition(a).transform("translate3d("+(o?v:0)+"%, "+(o?0:v)+"%, 0)"),m&&s.transitionEnd((function(){n.onMonthChangeEnd(d,!0)})),i.animate&&0!==a||n.onMonthChangeEnd(d,!0)},t.prototype.nextYear=function(){this.setYearMonth(this.currentYear+1)},t.prototype.prevYear=function(){this.setYearMonth(this.currentYear-1)},t.prototype.dateInRange=function(e,t){var a,r=!1;if(!t)return!1;if(Array.isArray(t))for(a=0;a<t.length;a+=1)t[a].from||t[a].to?t[a].from&&t[a].to?e<=new Date(t[a].to).getTime()&&e>=new Date(t[a].from).getTime()&&(r=!0):t[a].from?e>=new Date(t[a].from).getTime()&&(r=!0):t[a].to&&e<=new Date(t[a].to).getTime()&&(r=!0):t[a].date?e===new Date(t[a].date).getTime()&&(r=!0):e===new Date(t[a]).getTime()&&(r=!0);else t.from||t.to?t.from&&t.to?e<=new Date(t.to).getTime()&&e>=new Date(t.from).getTime()&&(r=!0):t.from?e>=new Date(t.from).getTime()&&(r=!0):t.to&&e<=new Date(t.to).getTime()&&(r=!0):t.date?r=e===new Date(t.date).getTime():"function"==typeof t&&(r=t(new Date(e)));return r},t.prototype.daysInMonth=function(e){var t=new Date(e);return new Date(t.getFullYear(),t.getMonth()+1,0).getDate()},t.prototype.renderMonths=function(e){return this.params.renderMonths?this.params.renderMonths.call(this,e):('\n    <div class="calendar-months-wrapper">\n    '+this.renderMonth(e,"prev")+"\n    "+this.renderMonth(e)+"\n    "+this.renderMonth(e,"next")+"\n    </div>\n  ").trim()},t.prototype.renderMonth=function(e,t){var a=this,r=a.params,n=a.value;if(r.renderMonth)return r.renderMonth.call(a,e,t);var i=new Date(e),o=i.getFullYear(),s=i.getMonth(),l=a.monthNames.indexOf(a.monthFormatter.format(i));l<0&&(l=s);var p=a.yearFormatter.format(i);"next"===t&&(i=11===s?new Date(o+1,0):new Date(o,s+1,1)),"prev"===t&&(i=0===s?new Date(o-1,11):new Date(o,s-1,1)),"next"!==t&&"prev"!==t||(s=i.getMonth(),o=i.getFullYear(),(l=a.monthNames.indexOf(a.monthFormatter.format(i)))<0&&(l=s),p=a.yearFormatter.format(i));var c,d,u=[],h=(new Date).setHours(0,0,0,0),f=r.minDate?new Date(r.minDate).getTime():null,m=r.maxDate?new Date(r.maxDate).getTime():null,v=a.daysInMonth(new Date(i.getFullYear(),i.getMonth()).getTime()-864e6),g=a.daysInMonth(i),b=6===r.firstDay?0:1,y="",w=r.firstDay-1+0,C=new Date(i.getFullYear(),i.getMonth()).getDay();if(0===C&&(C=7),n&&n.length)for(var x=0;x<n.length;x+=1)u.push(new Date(n[x]).setHours(0,0,0,0));for(var $=1;$<=6;$+=1){for(var k="",E=function(e){var t=void 0,n=(w+=1)-C,i="";1===$&&1===e&&n>b&&1!==r.firstDay&&(n=(w-=7)-C);var l=e-1+r.firstDay>6?e-1-7+r.firstDay:e-1+r.firstDay;n<0?(n=v+n+1,i+=" calendar-day-prev",t=new Date(s-1<0?o-1:o,s-1<0?11:s-1,n).getTime()):(n+=1)>g?(n-=g,i+=" calendar-day-next",t=new Date(s+1>11?o+1:o,s+1>11?0:s+1,n).getTime()):t=new Date(o,s,n).getTime(),t===h&&(i+=" calendar-day-today"),r.rangePicker&&2===u.length?t>=u[0]&&t<=u[1]&&(i+=" calendar-day-selected"):u.indexOf(t)>=0&&(i+=" calendar-day-selected"),r.weekendDays.indexOf(l)>=0&&(i+=" calendar-day-weekend");var p="";if(d=!1,r.events&&a.dateInRange(t,r.events)&&(d=!0),d&&(i+=" calendar-day-has-events",p='\n            <span class="calendar-day-events">\n              <span class="calendar-day-event"></span>\n            </span>\n          ',Array.isArray(r.events))){var y=[];r.events.forEach((function(e){var r=e.color||"";y.indexOf(r)<0&&a.dateInRange(t,e)&&y.push(r)})),p='\n              <span class="calendar-day-events">\n                '+y.map((function(e){return('\n                  <span class="calendar-day-event" style="'+(e?"background-color: "+e:"")+'"></span>\n                ').trim()})).join("")+"\n              </span>\n            "}if(r.rangesClasses)for(var x=0;x<r.rangesClasses.length;x+=1)a.dateInRange(t,r.rangesClasses[x].range)&&(i+=" "+r.rangesClasses[x].cssClass);c=!1,(f&&t<f||m&&t>m)&&(c=!0),r.disabled&&a.dateInRange(t,r.disabled)&&(c=!0),c&&(i+=" calendar-day-disabled");var E=(t=new Date(t)).getFullYear(),T=t.getMonth(),S=a.dayFormatter.format(t);k+=('\n          <div data-year="'+E+'" data-month="'+T+'" data-day="'+n+'" class="calendar-day'+i+'" data-date="'+E+"-"+T+"-"+n+'">\n            <span class="calendar-day-number">'+S+p+"</span>\n          </div>").trim()},T=1;T<=7;T+=1)E(T);y+='<div class="calendar-row">'+k+"</div>"}return y='<div class="calendar-month" data-year="'+o+'" data-month="'+s+'" data-locale-year="'+p+'" data-locale-month="'+l+'">'+y+"</div>"},t.prototype.renderWeekHeader=function(){if(this.params.renderWeekHeader)return this.params.renderWeekHeader.call(this);for(var e=this.params,t="",a=0;a<7;a+=1){var r=a+e.firstDay>6?a-7+e.firstDay:a+e.firstDay;t+='<div class="calendar-week-day">'+this.dayNamesShort[r]+"</div>"}return('\n    <div class="calendar-week-header">\n      '+t+"\n    </div>\n  ").trim()},t.prototype.renderMonthSelector=function(){return this.params.renderMonthSelector?this.params.renderMonthSelector.call(this):('\n    <div class="calendar-month-selector">\n      <a class="link icon-only calendar-prev-month-button">\n        <i class="icon icon-prev"></i>\n      </a>\n      '+(this.params.monthPicker?'\n        <a class="current-month-value link"></a>\n      ':'\n        <span class="current-month-value"></span>\n      ')+'\n      <a class="link icon-only calendar-next-month-button">\n        <i class="icon icon-next"></i>\n      </a>\n    </div>\n  ').trim()},t.prototype.renderMonthPicker=function(){var e=parseInt(this.$el.find(".calendar-month-current").attr("data-locale-month"),10);return'\n      <div class="calendar-month-picker">\n        '+this.monthNames.map((function(t,a){return'\n          <div class="calendar-month-picker-item '+(e===a?"calendar-month-picker-item-current":"")+'">\n            <span>'+t+"</span>\n          </div>\n        "})).join("")+"\n      </div>\n    "},t.prototype.renderYearSelector=function(){return this.params.renderYearSelector?this.params.renderYearSelector.call(this):('\n    <div class="calendar-year-selector">\n      <a class="link icon-only calendar-prev-year-button">\n        <i class="icon icon-prev"></i>\n      </a>\n      '+(this.params.yearPicker?'\n        <a class="current-year-value link"></a>\n      ':'\n        <span class="current-year-value"></span>\n      ')+'\n      <a class="link icon-only calendar-next-year-button">\n        <i class="icon icon-next"></i>\n      </a>\n    </div>\n  ').trim()},t.prototype.renderYearPicker=function(){var e=this,t=e.currentYear,a=e.params.yearPickerMin||(new Date).getFullYear()-100;e.params.minDate&&(a=Math.max(a,new Date(e.params.minDate).getFullYear()));var r=e.params.yearPickerMax||(new Date).getFullYear()+100;e.params.maxDate&&(r=Math.min(r,new Date(e.params.maxDate).getFullYear()));for(var n=[],i=a;i<=r;i+=1)n.push(i);return'\n      <div class="calendar-year-picker">\n        '+n.map((function(a){return'\n          <div data-year="'+a+'" class="calendar-year-picker-item '+(a===t?"calendar-year-picker-item-current":"")+'">\n            <span>'+e.yearFormatter.format((new Date).setFullYear(a))+"</span>\n          </div>\n        "})).join("")+"\n      </div>\n    "},t.prototype.renderTimeSelector=function(){var e,t=this.value&&this.value[0];return t&&(e=this.timeSelectorFormatter.format(t)),'\n      <div class="calendar-time-selector"><a class="link">'+(e||this.params.timePickerPlaceholder)+"</a></div>\n    "},t.prototype.renderHeader=function(){return this.params.renderHeader?this.params.renderHeader.call(this):('\n    <div class="calendar-header">\n      <div class="calendar-selected-date">'+this.params.headerPlaceholder+"</div>\n    </div>\n  ").trim()},t.prototype.renderFooter=function(){var e=this.app;return this.params.renderFooter?this.params.renderFooter.call(this):('\n    <div class="calendar-footer">\n      <a class="'+("md"===e.theme?"button":"link")+' calendar-close sheet-close popover-close">'+this.params.toolbarCloseText+"</a>\n    </div>\n  ").trim()},t.prototype.renderToolbar=function(){return this.params.renderToolbar?this.params.renderToolbar.call(this,this):('\n    <div class="toolbar toolbar-top no-shadow">\n      <div class="toolbar-inner">\n        '+(this.params.monthSelector?this.renderMonthSelector():"")+"\n        "+(this.params.yearSelector?this.renderYearSelector():"")+"\n      </div>\n    </div>\n  ").trim()},t.prototype.renderInline=function(){var e=this.params,t=e.cssClass,a=e.toolbar,r=e.header,n=e.footer,i=e.rangePicker,o=e.weekHeader,s=this.value,l=this.hasTimePicker,p=s&&s.length?s[0]:(new Date).setHours(0,0,0);return('\n    <div class="calendar calendar-inline '+(i?"calendar-range":"")+" "+(t||"")+'">\n      '+(r?this.renderHeader():"")+"\n      "+(a?this.renderToolbar():"")+"\n      "+(o?this.renderWeekHeader():"")+'\n      <div class="calendar-months">\n        '+this.renderMonths(p)+"\n      </div>\n      "+(l?this.renderTimeSelector():"")+"\n      "+(n?this.renderFooter():"")+"\n    </div>\n  ").trim()},t.prototype.renderCustomModal=function(){var e=this.params,t=e.cssClass,a=e.toolbar,r=e.header,n=e.footer,i=e.rangePicker,o=e.weekHeader,s=this.value,l=this.hasTimePicker,p=s&&s.length?s[0]:(new Date).setHours(0,0,0);return('\n    <div class="calendar calendar-modal '+(i?"calendar-range":"")+" "+(t||"")+'">\n      '+(r?this.renderHeader():"")+"\n      "+(a?this.renderToolbar():"")+"\n      "+(o?this.renderWeekHeader():"")+'\n      <div class="calendar-months">\n        '+this.renderMonths(p)+"\n      </div>\n      "+(l?this.renderTimeSelector():"")+"\n      "+(n?this.renderFooter():"")+"\n    </div>\n  ").trim()},t.prototype.renderSheet=function(){var e=this.params,t=e.cssClass,a=e.toolbar,r=e.header,n=e.footer,i=e.rangePicker,o=e.weekHeader,s=this.value,l=this.hasTimePicker,p=s&&s.length?s[0]:(new Date).setHours(0,0,0);return('\n    <div class="sheet-modal calendar calendar-sheet '+(i?"calendar-range":"")+" "+(t||"")+'">\n      '+(r?this.renderHeader():"")+"\n      "+(a?this.renderToolbar():"")+"\n      "+(o?this.renderWeekHeader():"")+'\n      <div class="sheet-modal-inner calendar-months">\n        '+this.renderMonths(p)+"\n      </div>\n      "+(l?this.renderTimeSelector():"")+"\n      "+(n?this.renderFooter():"")+"\n    </div>\n  ").trim()},t.prototype.renderPopover=function(){var e=this.params,t=e.cssClass,a=e.toolbar,r=e.header,n=e.footer,i=e.rangePicker,o=e.weekHeader,s=this.value,l=this.hasTimePicker,p=s&&s.length?s[0]:(new Date).setHours(0,0,0);return('\n    <div class="popover calendar-popover">\n      <div class="popover-inner">\n        <div class="calendar '+(i?"calendar-range":"")+" "+(t||"")+'">\n        '+(r?this.renderHeader():"")+"\n        "+(a?this.renderToolbar():"")+"\n        "+(o?this.renderWeekHeader():"")+'\n        <div class="calendar-months">\n          '+this.renderMonths(p)+"\n        </div>\n        "+(l?this.renderTimeSelector():"")+"\n        "+(n?this.renderFooter():"")+"\n        </div>\n      </div>\n    </div>\n  ").trim()},t.prototype.render=function(){var e=this.params;if(e.render)return e.render.call(this);if(!this.inline){var t=e.openIn;return"auto"===t&&(t=this.isPopover()?"popover":"sheet"),"popover"===t?this.renderPopover():"sheet"===t?this.renderSheet():this.renderCustomModal()}return this.renderInline()},t.prototype.openTimePicker=function(){var e=this.$el,t=this.app;if(e&&e.length){e.append('<div class="calendar-time-picker"></div>');for(var a,r=[],n=[],i=0;i<=23;i+=1)r.push(i);for(var o=0;o<=59;o+=1)n.push(o);a=this.value&&this.value.length?[this.value[0].getHours(),this.value[0].getMinutes()]:[(new Date).getHours(),(new Date).getMinutes()],this.timePickerInstance=t.picker.create({containerEl:e.find(".calendar-time-picker"),value:a,toolbar:!0,rotateEffect:!1,toolbarCloseText:this.params.toolbarCloseText,cols:[{values:r},{divider:!0,content:":"},{values:n,displayValues:n.map((function(e){return e<10?"0"+e:e}))}]}),this.timePickerInstance.$el.find(".toolbar a").removeClass("sheet-close popover-close").addClass("calendar-time-picker-close")}},t.prototype.closeTimePicker=function(){if(this.timePickerInstance){var e=this.timePickerInstance.value.map((function(e){return parseInt(e,10)})),t=e[0],a=e[1],r=this.value&&this.value.length&&this.value[0];r?(r=new Date(r)).setHours(t,a):(r=new Date).setHours(t,a,0,0),this.setValue([r]),this.timePickerInstance.close(),this.timePickerInstance.destroy(),delete this.timePickerInstance}this.$el&&this.$el.length&&this.$el.find(".calendar-time-picker").remove()},t.prototype.onOpen=function(){var e=this,t=e.initialized,a=e.$el,r=e.app,n=e.$inputEl,i=e.inline,o=e.value,s=e.params;e.closing=!1,e.opened=!0,e.opening=!0,e.attachCalendarEvents();var l=!o&&s.value;t?o&&e.setValue(o,0):o?e.setValue(o,0):s.value&&e.setValue(e.normalizeValues(s.value),0),e.updateCurrentMonthYear(),e.monthsTranslate=0,e.setMonthsTranslate(),l?e.updateValue():s.header&&o&&e.updateValue(!0),!i&&n&&n.length&&"md"===r.theme&&n.trigger("focus"),e.initialized=!0,e.$months.each((function(t,a){e.emit("local::monthAdd calendarMonthAdd",a)})),a&&a.trigger("calendar:open"),n&&n.trigger("calendar:open"),e.emit("local::open calendarOpen",e)},t.prototype.onOpened=function(){this.opening=!1,this.$el&&this.$el.trigger("calendar:opened"),this.$inputEl&&this.$inputEl.trigger("calendar:opened"),this.emit("local::opened calendarOpened",this)},t.prototype.onClose=function(){var e=this.app;this.opening=!1,this.closing=!0,this.$inputEl&&"md"===e.theme&&this.$inputEl.trigger("blur"),this.detachCalendarEvents&&this.detachCalendarEvents(),this.$el&&this.$el.trigger("calendar:close"),this.$inputEl&&this.$inputEl.trigger("calendar:close"),this.emit("local::close calendarClose",this)},t.prototype.onClosed=function(){var e=this;e.opened=!1,e.closing=!1,e.inline||Utils.nextTick((function(){e.modal&&e.modal.el&&e.modal.destroy&&(e.params.routableModals||e.modal.destroy()),delete e.modal})),e.timePickerInstance&&(e.timePickerInstance.destroy&&e.timePickerInstance.destroy(),delete e.timePickerInstance),e.$el&&e.$el.trigger("calendar:closed"),e.$inputEl&&e.$inputEl.trigger("calendar:closed"),e.emit("local::closed calendarClosed",e)},t.prototype.open=function(){var e,t=this,a=t.app,r=t.opened,n=t.inline,i=t.$inputEl,o=t.params;if(!r){if(n)return t.$el=$(t.render()),t.$el[0].f7Calendar=t,t.$wrapperEl=t.$el.find(".calendar-months-wrapper"),t.$months=t.$wrapperEl.find(".calendar-month"),t.$containerEl.append(t.$el),t.onOpen(),void t.onOpened();var s=o.openIn;"auto"===s&&(s=t.isPopover()?"popover":"sheet");var l=t.render(),p={targetEl:i,scrollToEl:o.scrollToInput?i:void 0,content:l,backdrop:!0===o.backdrop||"popover"===s&&!1!==a.params.popover.backdrop&&!1!==o.backdrop,closeByBackdropClick:o.closeByBackdropClick,on:{open:function(){t.modal=this,t.$el="popover"===s?this.$el.find(".calendar"):this.$el,t.$wrapperEl=t.$el.find(".calendar-months-wrapper"),t.$months=t.$wrapperEl.find(".calendar-month"),t.$el[0].f7Calendar=t,"customModal"===s&&$(t.$el).find(".calendar-close").once("click",(function(){t.close()})),t.onOpen()},opened:function(){t.onOpened()},close:function(){t.onClose()},closed:function(){t.onClosed()}}};"sheet"===s&&(p.push=o.sheetPush,p.swipeToClose=o.sheetSwipeToClose),o.routableModals&&t.view?t.view.router.navigate({url:t.url,route:(e={path:t.url},e[s]=p,e)}):(t.modal=a[s].create(p),t.modal.open())}},t.prototype.close=function(){var e=this.opened,t=this.inline;if(e)return t?(this.onClose(),void this.onClosed()):void(this.params.routableModals&&this.view?this.view.router.back():this.modal.close())},t.prototype.init=function(){if(this.initInput(),this.inline)return this.open(),void this.emit("local::init calendarInit",this);!this.initialized&&this.params.value&&this.setValue(this.normalizeValues(this.params.value)),this.$inputEl&&this.attachInputEvents(),this.params.closeByOutsideClick&&this.attachHtmlEvents(),this.emit("local::init calendarInit",this)},t.prototype.destroy=function(){if(!this.destroyed){var e=this.$el;this.emit("local::beforeDestroy calendarBeforeDestroy",this),e&&e.trigger("calendar:beforedestroy"),this.close(),this.$inputEl&&this.detachInputEvents(),this.params.closeByOutsideClick&&this.detachHtmlEvents(),this.timePickerInstance&&(this.timePickerInstance.destroy&&this.timePickerInstance.destroy(),delete this.timePickerInstance),e&&e.length&&delete this.$el[0].f7Calendar,Utils.deleteProps(this),this.destroyed=!0}},Object.defineProperties(t.prototype,a),t}(Framework7Class),Calendar$1={name:"calendar",static:{Calendar:Calendar},create:function(){this.calendar=ConstructorMethods({defaultSelector:".calendar",constructor:Calendar,app:this,domProp:"f7Calendar"}),this.calendar.close=function(e){void 0===e&&(e=".calendar");var t=$(e);if(0!==t.length){var a=t[0].f7Calendar;!a||a&&!a.opened||a.close()}}},params:{calendar:{dateFormat:void 0,monthNames:"auto",monthNamesShort:"auto",dayNames:"auto",dayNamesShort:"auto",locale:void 0,firstDay:1,weekendDays:[0,6],multiple:!1,rangePicker:!1,rangePickerMinDays:1,rangePickerMaxDays:0,direction:"horizontal",minDate:null,maxDate:null,disabled:null,events:null,rangesClasses:null,touchMove:!0,animate:!0,closeOnSelect:!1,monthSelector:!0,monthPicker:!0,yearSelector:!0,yearPicker:!0,yearPickerMin:void 0,yearPickerMax:void 0,timePicker:!1,timePickerFormat:{hour:"numeric",minute:"numeric"},timePickerPlaceholder:"Select time",weekHeader:!0,value:null,containerEl:null,openIn:"auto",sheetPush:!1,sheetSwipeToClose:void 0,formatValue:null,inputEl:null,inputReadOnly:!0,closeByOutsideClick:!0,scrollToInput:!0,header:!1,headerPlaceholder:"Select date",toolbar:!0,toolbarCloseText:"Done",footer:!1,cssClass:null,routableModals:!0,view:null,url:"date/",backdrop:null,closeByBackdropClick:!0,renderWeekHeader:null,renderMonths:null,renderMonth:null,renderMonthSelector:null,renderYearSelector:null,renderHeader:null,renderFooter:null,renderToolbar:null,renderInline:null,renderPopover:null,renderSheet:null,render:null}}};function pickerColumn(e,t){var a=this,r=a.app,n=$(e),i=n.index(),o=a.cols[i];if(!o.divider){var s,l,p,c,d;o.$el=n,o.el=n[0],o.$itemsEl=o.$el.find(".picker-items"),o.items=o.$itemsEl.find(".picker-item"),o.replaceValues=function(e,t){o.detachEvents(),o.values=e,o.displayValues=t,o.$itemsEl.html(a.renderColumn(o,!0)),o.items=o.$itemsEl.find(".picker-item"),o.calcSize(),o.setValue(o.values[0],0,!0),o.attachEvents()},o.calcSize=function(){a.params.rotateEffect&&(o.$el.removeClass("picker-column-absolute"),o.width||o.$el.css({width:""}));var e=0,t=o.$el[0].offsetHeight;s=o.items[0].offsetHeight,l=s*o.items.length,p=t/2-l+s/2,c=t/2-s/2,o.width&&(e=o.width,parseInt(e,10)===e&&(e+="px"),o.$el.css({width:e})),a.params.rotateEffect&&(o.width||(o.items.each((function(t,a){var r=$(a).children("span");e=Math.max(e,r[0].offsetWidth)})),o.$el.css({width:e+2+"px"})),o.$el.addClass("picker-column-absolute"))},o.setValue=function(e,t,r){void 0===t&&(t="");var n=o.$itemsEl.find('.picker-item[data-picker-value="'+e+'"]').index();if(void 0!==n&&-1!==n){var i=-n*s+c;o.$itemsEl.transition(t),o.$itemsEl.transform("translate3d(0,"+i+"px,0)"),a.params.updateValuesOnMomentum&&o.activeIndex&&o.activeIndex!==n&&(Utils.cancelAnimationFrame(d),o.$itemsEl.transitionEnd((function(){Utils.cancelAnimationFrame(d)})),T()),o.updateItems(n,i,t,r)}},o.updateItems=function(e,t,r,n){void 0===t&&(t=Utils.getTranslate(o.$itemsEl[0],"y")),void 0===e&&(e=-Math.round((t-c)/s)),e<0&&(e=0),e>=o.items.length&&(e=o.items.length-1);var i=o.activeIndex;o.activeIndex=e,o.$itemsEl.find(".picker-item-selected").removeClass("picker-item-selected"),o.items.transition(r);var l=o.items.eq(e).addClass("picker-item-selected").transform("");a.params.rotateEffect&&o.items.each((function(e,r){var n=$(r),i=(n.index()*s-(c-t))/s,l=Math.ceil(o.height/s/2)+1,p=-18*i;p>180&&(p=180),p<-180&&(p=-180),Math.abs(i)>l?n.addClass("picker-item-far"):n.removeClass("picker-item-far"),n.transform("translate3d(0, "+(-t+c)+"px, "+(a.needsOriginFix?-110:0)+"px) rotateX("+p+"deg)")})),(n||void 0===n)&&(o.value=l.attr("data-picker-value"),o.displayValue=o.displayValues?o.displayValues[e]:o.value,i!==e&&(o.onChange&&o.onChange(a,o.value,o.displayValue),a.updateValue()))};var u,h,f,m,v,g,b,y,w,C,x,k=!0,E=!!r.support.passiveListener&&{passive:!1,capture:!1};o.attachEvents=function(){o.$el.on(r.touchEvents.start,S,E),r.on("touchmove:active",M),r.on("touchend:passive",P),a.params.mousewheel&&o.$el.on("wheel",O),o.items.on("click",D)},o.detachEvents=function(){o.$el.off(r.touchEvents.start,S,E),r.off("touchmove:active",M),r.off("touchend:passive",P),a.params.mousewheel&&o.$el.off("wheel",O),o.items.off("click",D)},o.init=function(){o.calcSize(),o.$itemsEl.transform("translate3d(0,"+c+"px,0)").transition(0),0===i&&o.$el.addClass("picker-column-first"),i===a.cols.length-1&&o.$el.addClass("picker-column-last"),t&&o.updateItems(0,c,0),o.attachEvents()},o.destroy=function(){o.detachEvents()},o.init()}function T(){d=Utils.requestAnimationFrame((function(){o.updateItems(void 0,void 0,0),T()}))}function S(e){h||u||(e.preventDefault(),u=!0,f="touchstart"===e.type?e.targetTouches[0].pageY:e.pageY,m=f,v=(new Date).getTime(),k=!0,g=Utils.getTranslate(o.$itemsEl[0],"y"),y=g)}function M(e){u&&(e.preventDefault(),k=!1,m="touchmove"===e.type?e.targetTouches[0].pageY:e.pageY,h||(Utils.cancelAnimationFrame(d),h=!0,g=Utils.getTranslate(o.$itemsEl[0],"y"),y=g,o.$itemsEl.transition(0)),b=void 0,(y=g+(m-f))<p&&(y=p-Math.pow(p-y,.8),b="min"),y>c&&(y=c+Math.pow(y-c,.8),b="max"),o.$itemsEl.transform("translate3d(0,"+y+"px,0)"),o.updateItems(void 0,y,0,a.params.updateValuesOnTouchmove),C=y-w||y,w=y)}function P(){if(!u||!h)return u=!1,void(h=!1);var e;u=!1,h=!1,o.$itemsEl.transition(""),b&&("min"===b?o.$itemsEl.transform("translate3d(0,"+p+"px,0)"):o.$itemsEl.transform("translate3d(0,"+c+"px,0)")),e=(new Date).getTime()-v>300?y:y+C*a.params.momentumRatio,e=Math.max(Math.min(e,c),p);var t=Math.round(Math.abs((e-c)/s));a.params.freeMode||(e=-t*s+c),o.$itemsEl.transform("translate3d(0,"+parseInt(e,10)+"px,0)"),o.updateItems(t,e,"",!0),a.params.updateValuesOnMomentum&&(T(),o.$itemsEl.transitionEnd((function(){Utils.cancelAnimationFrame(d)}))),setTimeout((function(){k=!0}),100)}function O(e){var t=e.deltaX,r=e.deltaY;Math.abs(t)>Math.abs(r)||(clearTimeout(x),e.preventDefault(),Utils.cancelAnimationFrame(d),g=Utils.getTranslate(o.$itemsEl[0],"y"),o.$itemsEl.transition(0),b=void 0,(y=g-r)<p&&(y=p,b="min"),y>c&&(y=c,b="max"),o.$itemsEl.transform("translate3d(0,"+y+"px,0)"),o.updateItems(void 0,y,0,a.params.updateValuesOnMousewheel),x=setTimeout((function(){o.$itemsEl.transition(""),b&&("min"===b?o.$itemsEl.transform("translate3d(0,"+p+"px,0)"):o.$itemsEl.transform("translate3d(0,"+c+"px,0)")),(new Date).getTime();var e=y;e=Math.max(Math.min(e,c),p);var t=Math.round(Math.abs((e-c)/s));a.params.freeMode||(e=-t*s+c),o.$itemsEl.transform("translate3d(0,"+parseInt(e,10)+"px,0)"),o.updateItems(t,e,"",!0)}),200))}function D(){if(k){Utils.cancelAnimationFrame(d);var e=$(this).attr("data-picker-value");o.setValue(e)}}}var Picker=function(e){function t(t,a){void 0===a&&(a={}),e.call(this,a,[t]);var r,n,i=this;if(i.params=Utils.extend({},t.params.picker,a),i.params.containerEl&&0===(r=$(i.params.containerEl)).length)return i;i.params.inputEl&&(n=$(i.params.inputEl));var o=i.params.scrollToInput?n:void 0;if(i.params.scrollToEl){var s=$(i.params.scrollToEl);s.length>0&&(o=s)}function l(){i.resizeCols()}function p(){i.open()}function c(e){e.preventDefault()}function d(e){if(!i.destroyed&&i.params){var t=$(e.target);i.isPopover()||i.opened&&!i.closing&&(t.closest('[class*="backdrop"]').length||(n&&n.length>0?t[0]!==n[0]&&0===t.closest(".sheet-modal").length&&i.close():0===$(e.target).closest(".sheet-modal").length&&i.close()))}}return Utils.extend(i,{app:t,$containerEl:r,containerEl:r&&r[0],inline:r&&r.length>0,needsOriginFix:t.device.ios||win.navigator.userAgent.toLowerCase().indexOf("safari")>=0&&win.navigator.userAgent.toLowerCase().indexOf("chrome")<0&&!t.device.android,cols:[],$inputEl:n,inputEl:n&&n[0],$scrollToEl:o,initialized:!1,opened:!1,url:i.params.url}),Utils.extend(i,{attachResizeEvent:function(){t.on("resize",l)},detachResizeEvent:function(){t.off("resize",l)},attachInputEvents:function(){i.$inputEl.on("click",p),i.params.inputReadOnly&&i.$inputEl.on("focus mousedown",c)},detachInputEvents:function(){i.$inputEl.off("click",p),i.params.inputReadOnly&&i.$inputEl.off("focus mousedown",c)},attachHtmlEvents:function(){t.on("click",d)},detachHtmlEvents:function(){t.off("click",d)}}),i.init(),i}e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t;var a={view:{configurable:!0}};return a.view.get=function(){var e,t=this.app,a=this.params,r=this.$inputEl;return a.view?e=a.view:r&&(e=r.parents(".view").length&&r.parents(".view")[0].f7View),e||(e=t.views.main),e},t.prototype.initInput=function(){this.$inputEl&&this.params.inputReadOnly&&this.$inputEl.prop("readOnly",!0)},t.prototype.resizeCols=function(){if(this.opened)for(var e=0;e<this.cols.length;e+=1)this.cols[e].divider||(this.cols[e].calcSize(),this.cols[e].setValue(this.cols[e].value,0,!1))},t.prototype.isPopover=function(){var e=this.app,t=this.modal,a=this.params;if("sheet"===a.openIn)return!1;if(t&&"popover"!==t.type)return!1;if(!this.inline&&this.inputEl){if("popover"===a.openIn)return!0;if(e.device.ios)return!!e.device.ipad;if(e.width>=768)return!0;if(e.device.desktop&&"aurora"===e.theme)return!0}return!1},t.prototype.formatValue=function(){var e=this.value,t=this.displayValue;return this.params.formatValue?this.params.formatValue.call(this,e,t):e.join(" ")},t.prototype.setValue=function(e,t){var a=0;if(0===this.cols.length)return this.value=e,void this.updateValue(e);for(var r=0;r<this.cols.length;r+=1)this.cols[r]&&!this.cols[r].divider&&(this.cols[r].setValue(e[a],t),a+=1)},t.prototype.getValue=function(){return this.value},t.prototype.updateValue=function(e){var t,a=e||[],r=[];if(0===this.cols.length)for(var n=this.params.cols.filter((function(e){return!e.divider})),i=0;i<n.length;i+=1)void 0!==(t=n[i]).displayValues&&void 0!==t.values&&-1!==t.values.indexOf(a[i])?r.push(t.displayValues[t.values.indexOf(a[i])]):r.push(a[i]);else for(var o=0;o<this.cols.length;o+=1)this.cols[o].divider||(a.push(this.cols[o].value),r.push(this.cols[o].displayValue));a.indexOf(void 0)>=0||(this.value=a,this.displayValue=r,this.emit("local::change pickerChange",this,this.value,this.displayValue),this.inputEl&&(this.$inputEl.val(this.formatValue()),this.$inputEl.trigger("change")))},t.prototype.initColumn=function(e,t){pickerColumn.call(this,e,t)},t.prototype.destroyColumn=function(e){var t=$(e).index();this.cols[t]&&this.cols[t].destroy&&this.cols[t].destroy()},t.prototype.renderToolbar=function(){return this.params.renderToolbar?this.params.renderToolbar.call(this,this):('\n      <div class="toolbar toolbar-top no-shadow">\n        <div class="toolbar-inner">\n          <div class="left"></div>\n          <div class="right">\n            <a class="link sheet-close popover-close">'+this.params.toolbarCloseText+"</a>\n          </div>\n        </div>\n      </div>\n    ").trim()},t.prototype.renderColumn=function(e,t){var a,r,n="picker-column "+(e.textAlign?"picker-column-"+e.textAlign:"")+" "+(e.cssClass||"");return a=e.divider?'\n        <div class="'+n+' picker-column-divider">'+e.content+"</div>\n      ":'\n        <div class="'+n+'">\n          <div class="picker-items">'+(r=e.values.map((function(t,a){return'\n        <div class="picker-item" data-picker-value="'+t+'">\n          <span>'+(e.displayValues?e.displayValues[a]:t)+"</span>\n        </div>\n      "})).join(""))+"</div>\n        </div>\n      ",t?r.trim():a.trim()},t.prototype.renderInline=function(){var e=this,t=e.params;return('\n      <div class="picker picker-inline '+(t.rotateEffect?"picker-3d":"")+" "+(t.cssClass||"")+'">\n        '+(t.toolbar?e.renderToolbar():"")+'\n        <div class="picker-columns">\n          '+e.cols.map((function(t){return e.renderColumn(t)})).join("")+'\n          <div class="picker-center-highlight"></div>\n        </div>\n      </div>\n    ').trim()},t.prototype.renderSheet=function(){var e=this,t=e.params;return('\n      <div class="sheet-modal picker picker-sheet '+(t.rotateEffect?"picker-3d":"")+" "+(t.cssClass||"")+'">\n        '+(t.toolbar?e.renderToolbar():"")+'\n        <div class="sheet-modal-inner picker-columns">\n          '+e.cols.map((function(t){return e.renderColumn(t)})).join("")+'\n          <div class="picker-center-highlight"></div>\n        </div>\n      </div>\n    ').trim()},t.prototype.renderPopover=function(){var e=this,t=e.params;return('\n      <div class="popover picker-popover">\n        <div class="popover-inner">\n          <div class="picker '+(t.rotateEffect?"picker-3d":"")+" "+(t.cssClass||"")+'">\n            '+(t.toolbar?e.renderToolbar():"")+'\n            <div class="picker-columns">\n              '+e.cols.map((function(t){return e.renderColumn(t)})).join("")+'\n              <div class="picker-center-highlight"></div>\n            </div>\n          </div>\n        </div>\n      </div>\n    ').trim()},t.prototype.render=function(){return this.params.render?this.params.render.call(this):this.inline?this.renderInline():this.isPopover()?this.renderPopover():this.renderSheet()},t.prototype.onOpen=function(){var e=this,t=e.initialized,a=e.$el,r=e.app,n=e.$inputEl,i=e.inline,o=e.value,s=e.params;e.opened=!0,e.closing=!1,e.opening=!0,e.attachResizeEvent(),a.find(".picker-column").each((function(a,r){var n=!0;(!t&&s.value||t&&o)&&(n=!1),e.initColumn(r,n)})),t?o&&e.setValue(o,0):o?e.setValue(o,0):s.value&&e.setValue(s.value,0),!i&&n&&n.length&&"md"===r.theme&&n.trigger("focus"),e.initialized=!0,a&&a.trigger("picker:open"),n&&n.trigger("picker:open"),e.emit("local::open pickerOpen",e)},t.prototype.onOpened=function(){this.opening=!1,this.$el&&this.$el.trigger("picker:opened"),this.$inputEl&&this.$inputEl.trigger("picker:opened"),this.emit("local::opened pickerOpened",this)},t.prototype.onClose=function(){var e=this.app;this.opening=!1,this.closing=!0,this.detachResizeEvent(),this.cols.forEach((function(e){e.destroy&&e.destroy()})),this.$inputEl&&"md"===e.theme&&this.$inputEl.trigger("blur"),this.$el&&this.$el.trigger("picker:close"),this.$inputEl&&this.$inputEl.trigger("picker:close"),this.emit("local::close pickerClose",this)},t.prototype.onClosed=function(){var e=this;e.opened=!1,e.closing=!1,e.inline||Utils.nextTick((function(){e.modal&&e.modal.el&&e.modal.destroy&&(e.params.routableModals||e.modal.destroy()),delete e.modal})),e.$el&&e.$el.trigger("picker:closed"),e.$inputEl&&e.$inputEl.trigger("picker:closed"),e.emit("local::closed pickerClosed",e)},t.prototype.open=function(){var e,t=this,a=t.app,r=t.opened,n=t.inline,i=t.$inputEl,o=t.$scrollToEl,s=t.params;if(!r){if(0===t.cols.length&&s.cols.length&&s.cols.forEach((function(e){t.cols.push(e)})),n)return t.$el=$(t.render()),t.$el[0].f7Picker=t,t.$containerEl.append(t.$el),t.onOpen(),void t.onOpened();var l=t.isPopover(),p=l?"popover":"sheet",c={targetEl:i,scrollToEl:o,content:t.render(),backdrop:void 0!==s.backdrop?s.backdrop:l,on:{open:function(){t.modal=this,t.$el=l?this.$el.find(".picker"):this.$el,t.$el[0].f7Picker=t,t.onOpen()},opened:function(){t.onOpened()},close:function(){t.onClose()},closed:function(){t.onClosed()}}};"sheet"===p&&(c.push=s.sheetPush,c.swipeToClose=s.sheetSwipeToClose),s.routableModals&&t.view?t.view.router.navigate({url:t.url,route:(e={path:t.url},e[p]=c,e)}):(t.modal=a[p].create(c),t.modal.open())}},t.prototype.close=function(){var e=this.opened,t=this.inline;if(e)return t?(this.onClose(),void this.onClosed()):void(this.params.routableModals&&this.view?this.view.router.back():this.modal.close())},t.prototype.init=function(){if(this.initInput(),this.inline)return this.open(),void this.emit("local::init pickerInit",this);!this.initialized&&this.params.value&&this.setValue(this.params.value),this.$inputEl&&this.attachInputEvents(),this.params.closeByOutsideClick&&this.attachHtmlEvents(),this.emit("local::init pickerInit",this)},t.prototype.destroy=function(){if(!this.destroyed){var e=this.$el;this.emit("local::beforeDestroy pickerBeforeDestroy",this),e&&e.trigger("picker:beforedestroy"),this.close(),this.$inputEl&&this.detachInputEvents(),this.params.closeByOutsideClick&&this.detachHtmlEvents(),e&&e.length&&delete this.$el[0].f7Picker,Utils.deleteProps(this),this.destroyed=!0}},Object.defineProperties(t.prototype,a),t}(Framework7Class),Picker$1={name:"picker",static:{Picker:Picker},create:function(){this.picker=ConstructorMethods({defaultSelector:".picker",constructor:Picker,app:this,domProp:"f7Picker"}),this.picker.close=function(e){void 0===e&&(e=".picker");var t=$(e);if(0!==t.length){var a=t[0].f7Picker;!a||a&&!a.opened||a.close()}}},params:{picker:{updateValuesOnMomentum:!1,updateValuesOnTouchmove:!0,updateValuesOnMousewheel:!0,mousewheel:!0,rotateEffect:!1,momentumRatio:7,freeMode:!1,cols:[],containerEl:null,openIn:"auto",sheetPush:!1,sheetSwipeToClose:void 0,backdrop:void 0,formatValue:null,inputEl:null,inputReadOnly:!0,closeByOutsideClick:!0,scrollToInput:!0,scrollToEl:void 0,toolbar:!0,toolbarCloseText:"Done",cssClass:null,routableModals:!0,view:null,url:"select/",renderToolbar:null,render:null}}},InfiniteScroll={handleScroll:function(e,t){var a,r=$(e),n=r[0].scrollTop,i=r[0].scrollHeight,o=r[0].offsetHeight,s=r[0].getAttribute("data-infinite-distance"),l=r.find(".virtual-list"),p=r.hasClass("infinite-scroll-top");if(s||(s=50),"string"==typeof s&&s.indexOf("%")>=0&&(s=parseInt(s,10)/100*o),s>o&&(s=o),p)n<s&&(r.trigger("infinite",t),this.emit("infinite",r[0],t));else if(n+o>=i-s){if(l.length>0&&(a=l.eq(-1)[0].f7VirtualList)&&!a.reachEnd&&!a.params.updatableScroll)return;r.trigger("infinite",t),this.emit("infinite",r[0],t)}},create:function(e){var t=$(e),a=this;function r(e){a.infiniteScroll.handle(this,e)}t.each((function(e,t){t.f7InfiniteScrollHandler=r,t.addEventListener("scroll",t.f7InfiniteScrollHandler)}))},destroy:function(e){$(e).each((function(e,t){t.removeEventListener("scroll",t.f7InfiniteScrollHandler),delete t.f7InfiniteScrollHandler}))}},InfiniteScroll$1={name:"infiniteScroll",create:function(){Utils.extend(this,{infiniteScroll:{handle:InfiniteScroll.handleScroll.bind(this),create:InfiniteScroll.create.bind(this),destroy:InfiniteScroll.destroy.bind(this)}})},on:{tabMounted:function(e){var t=this,a=$(e),r=a.find(".infinite-scroll-content");a.is(".infinite-scroll-content")&&r.add(a),r.each((function(e,a){t.infiniteScroll.create(a)}))},tabBeforeRemove:function(e){var t=$(e),a=this,r=t.find(".infinite-scroll-content");t.is(".infinite-scroll-content")&&r.add(t),r.each((function(e,t){a.infiniteScroll.destroy(t)}))},pageInit:function(e){var t=this;e.$el.find(".infinite-scroll-content").each((function(e,a){t.infiniteScroll.create(a)}))},pageBeforeRemove:function(e){var t=this;e.$el.find(".infinite-scroll-content").each((function(e,a){t.infiniteScroll.destroy(a)}))}}},PullToRefresh=function(e){function t(t,a){e.call(this,{},[t]);var r=this,n=$(a),i=n.find(".ptr-preloader");r.$el=n,r.el=n[0],r.app=t,r.bottom=r.$el.hasClass("ptr-bottom"),r.useModulesParams({});var o,s,l,p="md"===t.theme,c="ios"===t.theme,d="aurora"===t.theme;r.done=function(){return(p?i:n).transitionEnd((function(){n.removeClass("ptr-transitioning ptr-pull-up ptr-pull-down ptr-closing"),n.trigger("ptr:done"),r.emit("local::done ptrDone",n[0])})),n.removeClass("ptr-refreshing").addClass("ptr-transitioning ptr-closing"),r},r.refresh=function(){return n.hasClass("ptr-refreshing")||(n.addClass("ptr-transitioning ptr-refreshing"),n.trigger("ptr:refresh",r.done),r.emit("local::refresh ptrRefresh",n[0],r.done)),r},r.mousewheel="true"===n.attr("data-ptr-mousewheel");var u,h,f,m,v,g,b,y,w,C,x,k,E,T={},S=!1,M=!1,P=!1,O=0,D=!1,I=n.parents(".page");if((I.find(".navbar").length>0||I.parents(".view").children(".navbars").length>0)&&(D=!0),I.hasClass("no-navbar")&&(D=!1),!r.bottom){var B=t.navbar.getElByPage(I[0]);if(B){var R=$(B),L=R.hasClass("navbar-large-transparent")||R.hasClass("navbar-large")&&R.hasClass("navbar-transparent"),z=R.hasClass("navbar-transparent")&&!R.hasClass("navbar-large");L?n.addClass("ptr-with-navbar-large-transparent"):z&&n.addClass("ptr-with-navbar-transparent")}}function A(e){if(s){if("android"!==Device.os)return;if("targetTouches"in e&&e.targetTouches.length>1)return}n.hasClass("ptr-refreshing")||$(e.target).closest(".sortable-handler, .ptr-ignore, .card-expandable.card-opened").length||(l=!1,y=!1,s=!0,u=void 0,v=void 0,"touchstart"===e.type&&(o=e.targetTouches[0].identifier),T.x="touchstart"===e.type?e.targetTouches[0].pageX:e.pageX,T.y="touchstart"===e.type?e.targetTouches[0].pageY:e.pageY)}function H(e){if(s){var t,c,d;if("touchmove"===e.type){if(o&&e.touches)for(var k=0;k<e.touches.length;k+=1)e.touches[k].identifier===o&&(d=e.touches[k]);d||(d=e.targetTouches[0]),t=d.pageX,c=d.pageY}else t=e.pageX,c=e.pageY;if(t&&c)if(void 0===u&&(u=!!(u||Math.abs(c-T.y)>Math.abs(t-T.x))),u){if(m=n[0].scrollTop,!l){var E;if(n.removeClass("ptr-transitioning"),w=n[0].scrollHeight,C=n[0].offsetHeight,r.bottom&&(x=w-C),m>w)return void(s=!1);var D=$(e.target).closest(".ptr-watch-scroll");if(D.length&&D.each((function(e,t){t!==a&&t.scrollHeight>t.offsetHeight&&"auto"===$(t).css("overflow")&&(!r.bottom&&t.scrollTop>0||r.bottom&&t.scrollTop<t.scrollHeight-t.offsetHeight)&&(E=!0)})),E)return void(s=!1);b&&(g=n.attr("data-ptr-distance")).indexOf("%")>=0&&(g=w*parseInt(g,10)/100),O=n.hasClass("ptr-refreshing")?g:0,M=!(w!==C&&"ios"===Device.os&&!p),P=!1}l=!0,h=c-T.y,void 0===v&&(r.bottom?m!==x:0!==m)&&(v=!0),(r.bottom?h<0&&m>=x||m>x:h>0&&m<=0||m<0)?("ios"===Device.os&&parseInt(Device.osVersion.split(".")[0],10)>7&&(r.bottom||0!==m||v||(M=!0),r.bottom&&m===x&&!v&&(M=!0)),M||!r.bottom||p||(n.css("-webkit-overflow-scrolling","auto"),n.scrollTop(x),P=!0),(M||P)&&(e.cancelable&&e.preventDefault(),f=(r.bottom?-1*Math.pow(Math.abs(h),.85):Math.pow(h,.85))+O,p?i.transform("translate3d(0,"+f+"px,0)").find(".ptr-arrow").transform("rotate("+(Math.abs(h)/66*180+100)+"deg)"):r.bottom?n.children().transform("translate3d(0,"+f+"px,0)"):n.transform("translate3d(0,"+f+"px,0)")),(M||P)&&Math.pow(Math.abs(h),.85)>g||!M&&Math.abs(h)>=2*g?(S=!0,n.addClass("ptr-pull-up").removeClass("ptr-pull-down")):(S=!1,n.removeClass("ptr-pull-up").addClass("ptr-pull-down")),y||(n.trigger("ptr:pullstart"),r.emit("local::pullStart ptrPullStart",n[0]),y=!0),n.trigger("ptr:pullmove",{event:e,scrollTop:m,translate:f,touchesDiff:h}),r.emit("local::pullMove ptrPullMove",n[0],{event:e,scrollTop:m,translate:f,touchesDiff:h})):(y=!1,n.removeClass("ptr-pull-up ptr-pull-down"),S=!1)}else s=!1}}function U(e){return"touchend"===e.type&&e.changedTouches&&e.changedTouches.length>0&&o&&e.changedTouches[0].identifier!==o?(s=!1,u=!1,l=!1,void(o=null)):s&&l?(f&&(n.addClass("ptr-transitioning"),f=0),p?i.transform("").find(".ptr-arrow").transform(""):r.bottom?n.children().transform(""):n.transform(""),M||!r.bottom||p||n.css("-webkit-overflow-scrolling",""),S?(n.addClass("ptr-refreshing"),n.trigger("ptr:refresh",r.done),r.emit("local::refresh ptrRefresh",n[0],r.done)):n.removeClass("ptr-pull-down"),s=!1,l=!1,void(y&&(n.trigger("ptr:pullend"),r.emit("local::pullEnd ptrPullEnd",n[0])))):(s=!1,void(l=!1))}D||r.bottom||n.addClass("ptr-no-navbar"),n.attr("data-ptr-distance")?b=!0:p?g=66:c?g=44:d&&(g=38);var N=!0,F=0;function V(){N=!0,E=!1,F=0,f&&(n.addClass("ptr-transitioning"),f=0),p?i.transform("").find(".ptr-arrow").transform(""):r.bottom?n.children().transform(""):n.transform(""),S?(n.addClass("ptr-refreshing"),n.trigger("ptr:refresh",r.done),r.emit("local::refresh ptrRefresh",n[0],r.done)):n.removeClass("ptr-pull-down"),y&&(n.trigger("ptr:pullend"),r.emit("local::pullEnd ptrPullEnd",n[0]))}function q(e){if(N){var t=e.deltaX,o=e.deltaY;if(!(Math.abs(t)>Math.abs(o)||n.hasClass("ptr-refreshing")||$(e.target).closest(".sortable-handler, .ptr-ignore, .card-expandable.card-opened").length)){if(clearTimeout(k),m=n[0].scrollTop,!E){var s;if(n.removeClass("ptr-transitioning"),w=n[0].scrollHeight,C=n[0].offsetHeight,r.bottom&&(x=w-C),m>w)return void(N=!1);var c=$(e.target).closest(".ptr-watch-scroll");if(c.length&&c.each((function(e,t){t!==a&&t.scrollHeight>t.offsetHeight&&"auto"===$(t).css("overflow")&&(!r.bottom&&t.scrollTop>0||r.bottom&&t.scrollTop<t.scrollHeight-t.offsetHeight)&&(s=!0)})),s)return void(N=!1);b&&(g=n.attr("data-ptr-distance")).indexOf("%")>=0&&(g=w*parseInt(g,10)/100)}l=!0,h=F-=o,void 0===v&&(r.bottom?m!==x:0!==m)&&(v=!0),(r.bottom?h<0&&m>=x||m>x:h>0&&m<=0||m<0)?(e.cancelable&&e.preventDefault(),f=h,Math.abs(f)>g&&(f=g+Math.pow(Math.abs(f)-g,.7),r.bottom&&(f=-f)),p?i.transform("translate3d(0,"+f+"px,0)").find(".ptr-arrow").transform("rotate("+(Math.abs(h)/66*180+100)+"deg)"):r.bottom?n.children().transform("translate3d(0,"+f+"px,0)"):n.transform("translate3d(0,"+f+"px,0)"),Math.abs(f)>g?(S=!0,n.addClass("ptr-pull-up").removeClass("ptr-pull-down")):(S=!1,n.removeClass("ptr-pull-up").addClass("ptr-pull-down")),y||(n.trigger("ptr:pullstart"),r.emit("local::pullStart ptrPullStart",n[0]),y=!0),n.trigger("ptr:pullmove",{event:e,scrollTop:m,translate:f,touchesDiff:h}),r.emit("local::pullMove ptrPullMove",n[0],{event:e,scrollTop:m,translate:f,touchesDiff:h})):(y=!1,n.removeClass("ptr-pull-up ptr-pull-down"),S=!1),k=setTimeout(V,300)}}}return I.length&&n.length?(n[0].f7PullToRefresh=r,r.attachEvents=function(){var e=!!Support.passiveListener&&{passive:!0};n.on(t.touchEvents.start,A,e),t.on("touchmove:active",H),t.on("touchend:passive",U),r.mousewheel&&!r.bottom&&n.on("wheel",q)},r.detachEvents=function(){var e=!!Support.passiveListener&&{passive:!0};n.off(t.touchEvents.start,A,e),t.off("touchmove:active",H),t.off("touchend:passive",U),r.mousewheel&&!r.bottom&&n.off("wheel",q)},r.useModules(),r.init(),r):r}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t.prototype.init=function(){this.attachEvents()},t.prototype.destroy=function(){var e=this;e.emit("local::beforeDestroy ptrBeforeDestroy",e),e.$el.trigger("ptr:beforedestroy"),delete e.el.f7PullToRefresh,e.detachEvents(),Utils.deleteProps(e),e=null},t}(Framework7Class),PullToRefresh$1={name:"pullToRefresh",create:function(){var e=this;e.ptr=Utils.extend(ConstructorMethods({defaultSelector:".ptr-content",constructor:PullToRefresh,app:e,domProp:"f7PullToRefresh"}),{done:function(t){var a=e.ptr.get(t);if(a)return a.done()},refresh:function(t){var a=e.ptr.get(t);if(a)return a.refresh()}})},static:{PullToRefresh:PullToRefresh},on:{tabMounted:function(e){var t=this,a=$(e),r=a.find(".ptr-content");a.is(".ptr-content")&&r.add(a),r.each((function(e,a){t.ptr.create(a)}))},tabBeforeRemove:function(e){var t=$(e),a=this,r=t.find(".ptr-content");t.is(".ptr-content")&&r.add(t),r.each((function(e,t){a.ptr.destroy(t)}))},pageInit:function(e){var t=this;e.$el.find(".ptr-content").each((function(e,a){t.ptr.create(a)}))},pageBeforeRemove:function(e){var t=this;e.$el.find(".ptr-content").each((function(e,a){t.ptr.destroy(a)}))}}},Lazy={destroy:function(e){var t=$(e).closest(".page");t.length&&t[0].f7LazyDestroy&&t[0].f7LazyDestroy()},create:function(e){var t=this,a=$(e).closest(".page").eq(0),r=a.find(".lazy");if(0!==r.length||a.hasClass("lazy")){var n=t.params.lazy.placeholder;!1!==n&&r.each((function(e,t){$(t).attr("data-src")&&!$(t).attr("src")&&$(t).attr("src",n)}));var i=[],o=!1;if(t.params.lazy.observer&&Support.intersectionObserver){var s=a[0].f7LazyObserver;return s||(s=new win.IntersectionObserver((function(e,a){e.forEach((function(e){if(e.isIntersecting){if(t.params.lazy.sequential&&o)return void(i.indexOf(e.target)<0&&i.push(e.target));o=!0,t.lazy.loadImage(e.target,l),a.unobserve(e.target)}}))}),{root:a[0]})),r.each((function(e,t){t.f7LazyObserverAdded||(t.f7LazyObserverAdded=!0,s.observe(t))})),void(a[0].f7LazyDestroy||(a[0].f7LazyDestroy=function(){s.disconnect(),delete a[0].f7LazyDestroy,delete a[0].f7LazyObserver}))}a[0].f7LazyDestroy||(a[0].f7LazyDestroy=function(){a[0].f7LazyAttached=!1,delete a[0].f7LazyAttached,a.off("lazy",p),a.off("scroll",p,!0),a.find(".tab").off("tab:mounted tab:show",p),t.off("resize",p)}),a[0].f7LazyAttached||(a[0].f7LazyAttached=!0,a.on("lazy",p),a.on("scroll",p,!0),a.find(".tab").on("tab:mounted tab:show",p),t.on("resize",p)),p()}function l(e){i.indexOf(e)>=0&&i.splice(i.indexOf(e),1),o=!1,t.params.lazy.sequential&&i.length>0&&(o=!0,t.lazy.loadImage(i[0],l))}function p(){t.lazy.load(a,(function(e){t.params.lazy.sequential&&o?i.indexOf(e)<0&&i.push(e):(o=!0,t.lazy.loadImage(e,l))}))}},isInViewport:function(e){var t=e.getBoundingClientRect(),a=this.params.lazy.threshold||0;return t.top>=0-a&&t.left>=0-a&&t.top<=this.height+a&&t.left<=this.width+a},loadImage:function(e,t){var a=this,r=$(e),n=r.attr("data-background"),i=n||r.attr("data-src");function o(){r.removeClass("lazy").addClass("lazy-loaded"),n?r.css("background-image","url("+i+")"):i&&r.attr("src",i),t&&t(e),r.trigger("lazy:loaded"),a.emit("lazyLoaded",r[0])}if(!i)return r.trigger("lazy:load"),a.emit("lazyLoad",r[0]),void o();var s=new win.Image;s.onload=o,s.onerror=function(){r.removeClass("lazy").addClass("lazy-loaded"),n?r.css("background-image","url("+(a.params.lazy.placeholder||"")+")"):r.attr("src",a.params.lazy.placeholder||""),t&&t(e),r.trigger("lazy:error"),a.emit("lazyError",r[0])},s.src=i,r.removeAttr("data-src").removeAttr("data-background"),r.trigger("lazy:load"),a.emit("lazyLoad",r[0])},load:function(e,t){var a=this,r=$(e);r.hasClass("page")||(r=r.parents(".page").eq(0)),0!==r.length&&r.find(".lazy").each((function(e,r){$(r).parents(".tab:not(.tab-active)").length>0||a.lazy.isInViewport(r)&&(t?t(r):a.lazy.loadImage(r))}))}},Lazy$1={name:"lazy",params:{lazy:{placeholder:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABAQMAAAAl21bKAAAAA1BMVEXCwsK592mkAAAACklEQVQI12NgAAAAAgAB4iG8MwAAAABJRU5ErkJggg==",threshold:0,sequential:!0,observer:!0}},create:function(){Utils.extend(this,{lazy:{create:Lazy.create.bind(this),destroy:Lazy.destroy.bind(this),loadImage:Lazy.loadImage.bind(this),load:Lazy.load.bind(this),isInViewport:Lazy.isInViewport.bind(this)}})},on:{pageInit:function(e){(e.$el.find(".lazy").length>0||e.$el.hasClass("lazy"))&&this.lazy.create(e.$el)},pageAfterIn:function(e){this.params.lazy.observer&&Support.intersectionObserver||(e.$el.find(".lazy").length>0||e.$el.hasClass("lazy"))&&this.lazy.create(e.$el)},pageBeforeRemove:function(e){(e.$el.find(".lazy").length>0||e.$el.hasClass("lazy"))&&this.lazy.destroy(e.$el)},tabMounted:function(e){var t=$(e);(t.find(".lazy").length>0||t.hasClass("lazy"))&&this.lazy.create(t)},tabBeforeRemove:function(e){if(!this.params.lazy.observer||!Support.intersectionObserver){var t=$(e);(t.find(".lazy").length>0||t.hasClass("lazy"))&&this.lazy.destroy(t)}}}},DataTable=function(e){function t(t,a){void 0===a&&(a={}),e.call(this,a,[t]);var r=this,n={};r.useModulesParams(n),r.params=Utils.extend(n,a);var i=$(r.params.el);if(0!==i.length){if(r.$el=i,r.el=i[0],r.$el[0].f7DataTable){var o=r.$el[0].f7DataTable;return r.destroy(),o}return r.$el[0].f7DataTable=r,Utils.extend(r,{collapsible:i.hasClass("data-table-collapsible"),$headerEl:i.find(".data-table-header"),$headerSelectedEl:i.find(".data-table-header-selected")}),r.attachEvents=function(){r.$el.on("change",'.checkbox-cell input[type="checkbox"]',s),r.$el.find("thead .sortable-cell").on("click",l)},r.detachEvents=function(){r.$el.off("change",'.checkbox-cell input[type="checkbox"]',s),r.$el.find("thead .sortable-cell").off("click",l)},r.useModules(),r.init(),r}function s(e){if(!e.detail||!e.detail.sentByF7DataTable){var t=$(this),a=t[0].checked,n=t.parents("td,th").index();if(t.parents("thead").length>0)0===n&&i.find("tbody tr")[a?"addClass":"removeClass"]("data-table-row-selected"),i.find("tbody tr td:nth-child("+(n+1)+") input").prop("checked",a).trigger("change",{sentByF7DataTable:!0}),t.prop("indeterminate",!1);else{0===n&&t.parents("tr")[a?"addClass":"removeClass"]("data-table-row-selected");var o=i.find("tbody .checkbox-cell:nth-child("+(n+1)+') input[type="checkbox"]:checked').length,s=i.find("tbody tr").length,l=i.find("thead .checkbox-cell:nth-child("+(n+1)+') input[type="checkbox"]');a?o===s&&l.prop("checked",!0).trigger("change",{sentByF7DataTable:!0}):l.prop("checked",!1),l.prop("indeterminate",o>0&&o<s)}r.checkSelectedHeader()}}function l(){var e,t=$(this),a=t.hasClass("sortable-cell-active"),n=t.hasClass("sortable-desc")?"desc":"asc";a?(e="desc"===n?"asc":"desc",t.removeClass("sortable-desc sortable-asc").addClass("sortable-"+e)):(i.find("thead .sortable-cell-active").removeClass("sortable-cell-active"),t.addClass("sortable-cell-active"),e=n),t.trigger("datatable:sort",e),r.emit("local::sort dataTableSort",r,e)}}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t.prototype.setCollapsibleLabels=function(){var e=this;e.collapsible&&e.$el.find("tbody td:not(.checkbox-cell)").each((function(t,a){var r=$(a),n=r.index(),i=r.attr("data-collapsible-title");i||""===i||r.attr("data-collapsible-title",e.$el.find("thead th").eq(n).text())}))},t.prototype.checkSelectedHeader=function(){if(this.$headerEl.length>0&&this.$headerSelectedEl.length>0){var e=this.$el.find("tbody .checkbox-cell input:checked").length;this.$el[e>0?"addClass":"removeClass"]("data-table-has-checked"),this.$headerSelectedEl.find(".data-table-selected-count").text(e)}},t.prototype.init=function(){this.attachEvents(),this.setCollapsibleLabels(),this.checkSelectedHeader()},t.prototype.destroy=function(){var e=this;e.$el.trigger("datatable:beforedestroy"),e.emit("local::beforeDestroy dataTableBeforeDestroy",e),e.attachEvents(),e.$el[0]&&(e.$el[0].f7DataTable=null,delete e.$el[0].f7DataTable),Utils.deleteProps(e),e=null},t}(Framework7Class),DataTable$1={name:"dataTable",static:{DataTable:DataTable},create:function(){this.dataTable=ConstructorMethods({defaultSelector:".data-table",constructor:DataTable,app:this,domProp:"f7DataTable"})},on:{tabBeforeRemove:function(e){var t=this;$(e).find(".data-table-init").each((function(e,a){t.dataTable.destroy(a)}))},tabMounted:function(e){var t=this;$(e).find(".data-table-init").each((function(e,a){t.dataTable.create({el:a})}))},pageBeforeRemove:function(e){var t=this;e.$el.find(".data-table-init").each((function(e,a){t.dataTable.destroy(a)}))},pageInit:function(e){var t=this;e.$el.find(".data-table-init").each((function(e,a){t.dataTable.create({el:a})}))}},vnode:{"data-table-init":{insert:function(e){var t=e.elm;this.dataTable.create({el:t})},destroy:function(e){var t=e.elm;this.dataTable.destroy(t)}}}},Fab={morphOpen:function(e,t){var a=this,r=$(e),n=$(t);if(0!==n.length){n.transition(0).addClass("fab-morph-target-visible");var i={width:n[0].offsetWidth,height:n[0].offsetHeight,offset:n.offset(),borderRadius:n.css("border-radius"),zIndex:n.css("z-index")},o={width:r[0].offsetWidth,height:r[0].offsetHeight,offset:r.offset(),translateX:Utils.getTranslate(r[0],"x"),translateY:Utils.getTranslate(r[0],"y")};r[0].f7FabMorphData={$targetEl:n,target:i,fab:o};var s=o.offset.left+o.width/2-(i.offset.left+i.width/2)-o.translateX,l=o.offset.top+o.height/2-(i.offset.top+i.height/2)-o.translateY,p=i.width/o.width,c=i.height/o.height,d=Math.ceil(parseInt(i.borderRadius,10)/Math.max(p,c));d>0&&(d+=2),r[0].f7FabMorphResizeHandler=function(){r.transition(0).transform(""),n.transition(0),i.width=n[0].offsetWidth,i.height=n[0].offsetHeight,i.offset=n.offset(),o.offset=r.offset();var e=o.offset.left+o.width/2-(i.offset.left+i.width/2)-o.translateX,t=o.offset.top+o.height/2-(i.offset.top+i.height/2)-o.translateY,a=i.width/o.width,s=i.height/o.height;r.transform("translate3d("+-e+"px, "+-t+"px, 0) scale("+a+", "+s+")")},n.css("opacity",0).transform("scale("+1/p+", "+1/c+")"),r.addClass("fab-opened").css("z-index",i.zIndex-1).transform("translate3d("+-s+"px, "+-l+"px, 0)"),r.transitionEnd((function(){n.transition(""),Utils.nextFrame((function(){n.css("opacity",1).transform("scale(1,1)"),r.transform("translate3d("+-s+"px, "+-l+"px, 0) scale("+p+", "+c+")").css("border-radius",d+"px").css("box-shadow","none").css("opacity","0")})),a.on("resize",r[0].f7FabMorphResizeHandler),n.parents(".page-content").length>0&&n.parents(".page-content").on("scroll",r[0].f7FabMorphResizeHandler)}))}},morphClose:function(e){var t=$(e),a=t[0].f7FabMorphData;if(a){var r=a.$targetEl,n=a.target,i=a.fab;if(0!==r.length){var o=i.offset.left+i.width/2-(n.offset.left+n.width/2)-i.translateX,s=i.offset.top+i.height/2-(n.offset.top+n.height/2)-i.translateY,l=n.width/i.width,p=n.height/i.height;this.off("resize",t[0].f7FabMorphResizeHandler),r.parents(".page-content").length>0&&r.parents(".page-content").off("scroll",t[0].f7FabMorphResizeHandler),r.css("opacity",0).transform("scale("+1/l+", "+1/p+")"),t.transition("").css("box-shadow","").css("border-radius","").css("opacity","1").transform("translate3d("+-o+"px, "+-s+"px, 0)"),t.transitionEnd((function(){t.css("z-index","").removeClass("fab-opened").transform(""),Utils.nextFrame((function(){t.transitionEnd((function(){r.removeClass("fab-morph-target-visible").css("opacity","").transform("").transition("")}))}))}))}}},open:function(e,t){var a=$(e).eq(0),r=a.find(".fab-buttons");if(a.length&&!a.hasClass("fab-opened")&&(r.length||a.hasClass("fab-morph"))){if(this.fab.openedEl){if(this.fab.openedEl===a[0])return;this.fab.close(this.fab.openedEl)}this.fab.openedEl=a[0],a.hasClass("fab-morph")?this.fab.morphOpen(a,t||a.attr("data-morph-to")):a.addClass("fab-opened"),a.siblings(".fab-backdrop").addClass("backdrop-in"),a.trigger("fab:open")}},close:function(e){void 0===e&&(e=".fab-opened");var t=$(e).eq(0),a=t.find(".fab-buttons");t.length&&t.hasClass("fab-opened")&&(a.length||t.hasClass("fab-morph"))&&(this.fab.openedEl=null,t.hasClass("fab-morph")?this.fab.morphClose(t):t.removeClass("fab-opened"),t.siblings(".fab-backdrop").removeClass("backdrop-in"),t.trigger("fab:close"))},toggle:function(e){$(e).hasClass("fab-opened")?this.fab.close(e):this.fab.open(e)}},Fab$1={name:"fab",create:function(){Utils.extend(this,{fab:{openedEl:null,morphOpen:Fab.morphOpen.bind(this),morphClose:Fab.morphClose.bind(this),open:Fab.open.bind(this),close:Fab.close.bind(this),toggle:Fab.toggle.bind(this)}})},clicks:{".fab > a":function(e){this.fab.toggle(e.parents(".fab"))},".fab-open":function(e,t){void 0===t&&(t={});this.fab.open(t.fab)},".fab-close":function(e,t){void 0===t&&(t={});this.fab.close(t.fab)},".fab-backdrop":function(){this.fab.close()}}},Searchbar=function(e){function t(t,a){void 0===a&&(a={}),e.call(this,a,[t]);var r=this,n={el:void 0,inputEl:void 0,inputEvents:"change input compositionend",disableButton:!0,disableButtonEl:void 0,backdropEl:void 0,searchContainer:void 0,searchItem:"li",searchIn:void 0,searchGroup:".list-group",searchGroupTitle:".item-divider, .list-group-title",ignore:".searchbar-ignore",foundEl:".searchbar-found",notFoundEl:".searchbar-not-found",hideOnEnableEl:".searchbar-hide-on-enable",hideOnSearchEl:".searchbar-hide-on-search",backdrop:void 0,removeDiacritics:!0,customSearch:!1,hideDividers:!0,hideGroups:!0,disableOnBackdropClick:!0,expandable:!1,inline:!1};r.useModulesParams(n),r.params=Utils.extend(n,a);var i,o=$(r.params.el);if(0===o.length)return r;if(o[0].f7Searchbar)return o[0].f7Searchbar;o[0].f7Searchbar=r;var s,l,p,c,d=o.parents(".navbar");if(o.parents(".page").length>0)i=o.parents(".page");else if(d.length>0&&!(i=$(t.navbar.getPageByEl(d[0]))).length){var u=o.parents(".view").find(".page-current");u[0]&&u[0].f7Page&&u[0].f7Page.navbarEl===d[0]&&(i=u)}a.foundEl?s=$(a.foundEl):"string"==typeof r.params.foundEl&&i&&(s=i.find(r.params.foundEl)),a.notFoundEl?l=$(a.notFoundEl):"string"==typeof r.params.notFoundEl&&i&&(l=i.find(r.params.notFoundEl)),a.hideOnEnableEl?p=$(a.hideOnEnableEl):"string"==typeof r.params.hideOnEnableEl&&i&&(p=i.find(r.params.hideOnEnableEl)),a.hideOnSearchEl?c=$(a.hideOnSearchEl):"string"==typeof r.params.hideOnSearchEl&&i&&(c=i.find(r.params.hideOnSearchEl));var h,f,m,v,g=r.params.expandable||o.hasClass("searchbar-expandable"),b=r.params.inline||o.hasClass("searchbar-inline");function y(e){e.preventDefault()}function w(e){r.enable(e),r.$el.addClass("searchbar-focused")}function C(){r.$el.removeClass("searchbar-focused"),"aurora"!==t.theme||v&&v.length&&r.params.disableButton||r.query||r.disable()}function x(){var e=r.$inputEl.val().trim();(r.$searchContainer&&r.$searchContainer.length>0&&(r.params.searchIn||r.isVirtualList||r.params.searchIn===r.params.searchItem)||r.params.customSearch)&&r.search(e,!0)}function k(e,t){r.$el.trigger("searchbar:clear",t),r.emit("local::clear searchbarClear",r,t)}function E(e){r.disable(e)}function T(){!r||r&&!r.$el||r.enabled&&(r.$el.removeClass("searchbar-enabled"),r.expandable&&r.$el.parents(".navbar").removeClass("with-searchbar-expandable-enabled with-searchbar-expandable-enabled-no-transition"))}function S(){!r||r&&!r.$el||r.enabled&&(r.$el.addClass("searchbar-enabled"),r.expandable&&r.$el.parents(".navbar").addClass("with-searchbar-expandable-enabled-no-transition"))}return void 0===r.params.backdrop&&(r.params.backdrop=!b&&"aurora"!==t.theme),r.params.backdrop&&0===(h=r.params.backdropEl?$(r.params.backdropEl):i&&i.length>0?i.find(".searchbar-backdrop"):o.siblings(".searchbar-backdrop")).length&&(h=$('<div class="searchbar-backdrop"></div>'),i&&i.length?o.parents(i).length>0&&d&&0===o.parents(d).length?h.insertBefore(o):h.insertBefore(i.find(".page-content").eq(0)):h.insertBefore(o)),r.params.searchContainer&&(f=$(r.params.searchContainer)),m=r.params.inputEl?$(r.params.inputEl):o.find('input[type="search"]').eq(0),r.params.disableButton&&(v=r.params.disableButtonEl?$(r.params.disableButtonEl):o.find(".searchbar-disable-button")),Utils.extend(r,{app:t,view:t.views.get(o.parents(".view")),$el:o,el:o[0],$backdropEl:h,backdropEl:h&&h[0],$searchContainer:f,searchContainer:f&&f[0],$inputEl:m,inputEl:m[0],$disableButtonEl:v,disableButtonEl:v&&v[0],disableButtonHasMargin:!1,$pageEl:i,pageEl:i&&i[0],$navbarEl:d,navbarEl:d&&d[0],$foundEl:s,foundEl:s&&s[0],$notFoundEl:l,notFoundEl:l&&l[0],$hideOnEnableEl:p,hideOnEnableEl:p&&p[0],$hideOnSearchEl:c,hideOnSearchEl:c&&c[0],previousQuery:"",query:"",isVirtualList:f&&f.hasClass("virtual-list"),virtualList:void 0,enabled:!1,expandable:g,inline:b}),r.attachEvents=function(){o.on("submit",y),r.params.disableButton&&r.$disableButtonEl.on("click",E),r.params.disableOnBackdropClick&&r.$backdropEl&&r.$backdropEl.on("click",E),r.expandable&&"ios"===t.theme&&r.view&&d.length&&r.$pageEl&&(r.$pageEl.on("page:beforeout",T),r.$pageEl.on("page:beforein",S)),r.$inputEl.on("focus",w),r.$inputEl.on("blur",C),r.$inputEl.on(r.params.inputEvents,x),r.$inputEl.on("input:clear",k)},r.detachEvents=function(){o.off("submit",y),r.params.disableButton&&r.$disableButtonEl.off("click",E),r.params.disableOnBackdropClick&&r.$backdropEl&&r.$backdropEl.off("click",E),r.expandable&&"ios"===t.theme&&r.view&&d.length&&r.$pageEl&&(r.$pageEl.off("page:beforeout",T),r.$pageEl.off("page:beforein",S)),r.$inputEl.off("focus",w),r.$inputEl.off("blur",C),r.$inputEl.off(r.params.inputEvents,x),r.$inputEl.off("input:clear",k)},r.useModules(),r.init(),r}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t.prototype.clear=function(e){var t=this;if(!t.query&&e&&$(e.target).hasClass("searchbar-clear"))return t.disable(),t;var a=t.value;return t.$inputEl.val("").trigger("change").focus(),t.$el.trigger("searchbar:clear",a),t.emit("local::clear searchbarClear",t,a),t},t.prototype.setDisableButtonMargin=function(){var e=this;if(!e.expandable){var t=e.app;e.$disableButtonEl.transition(0).show(),e.$disableButtonEl.css("margin-"+(t.rtl?"left":"right"),-e.disableButtonEl.offsetWidth+"px"),e._clientLeft=e.$disableButtonEl[0].clientLeft,e.$disableButtonEl.transition(""),e.disableButtonHasMargin=!0}},t.prototype.enable=function(e){var t=this;if(t.enabled)return t;var a=t.app;function r(){t.$backdropEl&&(t.$searchContainer&&t.$searchContainer.length||t.params.customSearch)&&!t.$el.hasClass("searchbar-enabled")&&!t.query&&t.backdropShow(),t.$el.addClass("searchbar-enabled"),(!t.$disableButtonEl||t.$disableButtonEl&&0===t.$disableButtonEl.length)&&t.$el.addClass("searchbar-enabled-no-disable-button"),!t.expandable&&t.$disableButtonEl&&t.$disableButtonEl.length>0&&"md"!==a.theme&&(t.disableButtonHasMargin||t.setDisableButtonMargin(),t.$disableButtonEl.css("margin-"+(a.rtl?"left":"right"),"0px")),t.expandable&&(t.$el.parents(".navbar").hasClass("navbar-large")&&t.$pageEl&&t.$pageEl.find(".page-content").addClass("with-searchbar-expandable-enabled"),"md"===a.theme&&t.$el.parents(".navbar").length?t.$el.parents(".navbar").addClass("with-searchbar-expandable-enabled"):(t.$el.parents(".navbar").addClass("with-searchbar-expandable-enabled"),t.$el.parents(".navbar-large").addClass("navbar-large-collapsed"))),t.$hideOnEnableEl&&t.$hideOnEnableEl.addClass("hidden-by-searchbar"),t.$el.trigger("searchbar:enable"),t.emit("local::enable searchbarEnable",t)}t.enabled=!0;var n=!1;return!0===e&&doc.activeElement!==t.inputEl&&(n=!0),a.device.ios&&"ios"===a.theme?t.expandable?(n&&t.$inputEl.focus(),r()):(n&&t.$inputEl.focus(),!e||"focus"!==e.type&&!0!==e?r():Utils.nextTick((function(){r()}),400)):(n&&t.$inputEl.focus(),"md"===a.theme&&t.expandable&&t.$el.parents(".page, .view, .navbar-inner, .navbar").scrollLeft(a.rtl?100:0),r()),t},t.prototype.disable=function(){var e=this;if(!e.enabled)return e;var t=e.app;return e.$inputEl.val("").trigger("change"),e.$el.removeClass("searchbar-enabled searchbar-focused searchbar-enabled-no-disable-button"),e.expandable&&(e.$el.parents(".navbar").hasClass("navbar-large")&&e.$pageEl&&(e.$pageEl.find(".page-content").removeClass("with-searchbar-expandable-enabled").addClass("with-searchbar-expandable-closing"),e.$el.transitionEnd((function(){e.$pageEl.find(".page-content").removeClass("with-searchbar-expandable-closing")}))),"md"===t.theme&&e.$el.parents(".navbar").length?(e.$el.parents(".navbar").removeClass("with-searchbar-expandable-enabled with-searchbar-expandable-enabled-no-transition").addClass("with-searchbar-expandable-closing"),e.$el.transitionEnd((function(){e.$el.parents(".navbar").removeClass("with-searchbar-expandable-closing")}))):(e.$el.parents(".navbar").removeClass("with-searchbar-expandable-enabled with-searchbar-expandable-enabled-no-transition").addClass("with-searchbar-expandable-closing"),e.$el.transitionEnd((function(){e.$el.parents(".navbar").removeClass("with-searchbar-expandable-closing")})),e.$pageEl&&e.$pageEl.find(".page-content").trigger("scroll"))),!e.expandable&&e.$disableButtonEl&&e.$disableButtonEl.length>0&&"md"!==t.theme&&e.$disableButtonEl.css("margin-"+(t.rtl?"left":"right"),-e.disableButtonEl.offsetWidth+"px"),e.$backdropEl&&(e.$searchContainer&&e.$searchContainer.length||e.params.customSearch)&&e.backdropHide(),e.enabled=!1,e.$inputEl.blur(),e.$hideOnEnableEl&&e.$hideOnEnableEl.removeClass("hidden-by-searchbar"),e.$el.trigger("searchbar:disable"),e.emit("local::disable searchbarDisable",e),e},t.prototype.toggle=function(){return this.enabled?this.disable():this.enable(!0),this},t.prototype.backdropShow=function(){return this.$backdropEl&&this.$backdropEl.addClass("searchbar-backdrop-in"),this},t.prototype.backdropHide=function(){return this.$backdropEl&&this.$backdropEl.removeClass("searchbar-backdrop-in"),this},t.prototype.search=function(e,t){var a=this;if(a.previousQuery=a.query||"",e===a.previousQuery)return a;t||(a.enabled||a.enable(),a.$inputEl.val(e),a.$inputEl.trigger("input")),a.query=e,a.value=e;var r=a.$searchContainer,n=a.$el,i=a.$foundEl,o=a.$notFoundEl,s=a.$hideOnSearchEl,l=a.isVirtualList;if(e.length>0&&s?s.addClass("hidden-by-searchbar"):s&&s.removeClass("hidden-by-searchbar"),(r&&r.length&&n.hasClass("searchbar-enabled")||a.params.customSearch&&n.hasClass("searchbar-enabled"))&&(0===e.length?a.backdropShow():a.backdropHide()),a.params.customSearch)return n.trigger("searchbar:search",{query:e,previousQuery:a.previousQuery}),a.emit("local::search searchbarSearch",a,e,a.previousQuery),a;var p,c=[];if(l){if(a.virtualList=r[0].f7VirtualList,""===e.trim())return a.virtualList.resetFilter(),o&&o.hide(),i&&i.show(),n.trigger("searchbar:search",{query:e,previousQuery:a.previousQuery}),a.emit("local::search searchbarSearch",a,e,a.previousQuery),a;if(p=a.params.removeDiacritics?Utils.removeDiacritics(e):e,a.virtualList.params.searchAll)c=a.virtualList.params.searchAll(p,a.virtualList.items)||[];else if(a.virtualList.params.searchByItem)for(var d=0;d<a.virtualList.items.length;d+=1)a.virtualList.params.searchByItem(p,a.virtualList.params.items[d],d)&&c.push(d)}else{var u;u=a.params.removeDiacritics?Utils.removeDiacritics(e.trim().toLowerCase()).split(" "):e.trim().toLowerCase().split(" "),r.find(a.params.searchItem).removeClass("hidden-by-searchbar").each((function(e,t){var r=$(t),n=[],i=a.params.searchIn?r.find(a.params.searchIn):r;a.params.searchIn===a.params.searchItem&&(i=r),i.each((function(e,t){var r=$(t).text().trim().toLowerCase();a.params.removeDiacritics&&(r=Utils.removeDiacritics(r)),n.push(r)})),n=n.join(" ");for(var o=0,s=0;s<u.length;s+=1)n.indexOf(u[s])>=0&&(o+=1);o===u.length||a.params.ignore&&r.is(a.params.ignore)?c.push(r[0]):r.addClass("hidden-by-searchbar")})),a.params.hideDividers&&r.find(a.params.searchGroupTitle).each((function(e,t){for(var r=$(t),n=r.nextAll(a.params.searchItem),i=!0,o=0;o<n.length;o+=1){var s=n.eq(o);if(s.is(a.params.searchGroupTitle))break;s.hasClass("hidden-by-searchbar")||(i=!1)}var l=a.params.ignore&&r.is(a.params.ignore);i&&!l?r.addClass("hidden-by-searchbar"):r.removeClass("hidden-by-searchbar")})),a.params.hideGroups&&r.find(a.params.searchGroup).each((function(e,t){var r=$(t),n=a.params.ignore&&r.is(a.params.ignore);0!==r.find(a.params.searchItem).filter((function(e,t){return!$(t).hasClass("hidden-by-searchbar")})).length||n?r.removeClass("hidden-by-searchbar"):r.addClass("hidden-by-searchbar")}))}return 0===c.length?(o&&o.show(),i&&i.hide()):(o&&o.hide(),i&&i.show()),l&&a.virtualList&&a.virtualList.filterItems(c),n.trigger("searchbar:search",{query:e,previousQuery:a.previousQuery,foundItems:c}),a.emit("local::search searchbarSearch",a,e,a.previousQuery,c),a},t.prototype.init=function(){var e=this;e.expandable&&e.$el&&e.$el.addClass("searchbar-expandable"),e.inline&&e.$el&&e.$el.addClass("searchbar-inline"),e.attachEvents()},t.prototype.destroy=function(){var e=this;e.emit("local::beforeDestroy searchbarBeforeDestroy",e),e.$el.trigger("searchbar:beforedestroy"),e.detachEvents(),e.$el[0]&&(e.$el[0].f7Searchbar=null,delete e.$el[0].f7Searchbar),Utils.deleteProps(e)},t}(Framework7Class),Searchbar$1={name:"searchbar",static:{Searchbar:Searchbar},create:function(){this.searchbar=ConstructorMethods({defaultSelector:".searchbar",constructor:Searchbar,app:this,domProp:"f7Searchbar",addMethods:"clear enable disable toggle search".split(" ")})},on:{tabMounted:function(e){var t=this;$(e).find(".searchbar-init").each((function(e,a){var r=$(a);t.searchbar.create(Utils.extend(r.dataset(),{el:a}))}))},tabBeforeRemove:function(e){$(e).find(".searchbar-init").each((function(e,t){t.f7Searchbar&&t.f7Searchbar.destroy&&t.f7Searchbar.destroy()}))},pageInit:function(e){var t=this;e.$el.find(".searchbar-init").each((function(e,a){var r=$(a);t.searchbar.create(Utils.extend(r.dataset(),{el:a}))})),"ios"===t.theme&&e.view&&e.view.router.dynamicNavbar&&e.$navbarEl&&e.$navbarEl.length>0&&e.$navbarEl.find(".searchbar-init").each((function(e,a){var r=$(a);t.searchbar.create(Utils.extend(r.dataset(),{el:a}))}))},pageBeforeRemove:function(e){e.$el.find(".searchbar-init").each((function(e,t){t.f7Searchbar&&t.f7Searchbar.destroy&&t.f7Searchbar.destroy()})),"ios"===this.theme&&e.view&&e.view.router.dynamicNavbar&&e.$navbarEl&&e.$navbarEl.length>0&&e.$navbarEl.find(".searchbar-init").each((function(e,t){t.f7Searchbar&&t.f7Searchbar.destroy&&t.f7Searchbar.destroy()}))}},clicks:{".searchbar-clear":function(e,t){void 0===t&&(t={});var a=this.searchbar.get(t.searchbar);a&&a.clear()},".searchbar-enable":function(e,t){void 0===t&&(t={});var a=this.searchbar.get(t.searchbar);a&&a.enable(!0)},".searchbar-disable":function(e,t){void 0===t&&(t={});var a=this.searchbar.get(t.searchbar);a&&a.disable()},".searchbar-toggle":function(e,t){void 0===t&&(t={});var a=this.searchbar.get(t.searchbar);a&&a.toggle()}},vnode:{"searchbar-init":{insert:function(e){var t=e.elm,a=$(t);this.searchbar.create(Utils.extend(a.dataset(),{el:t}))},destroy:function(e){var t=e.elm;t.f7Searchbar&&t.f7Searchbar.destroy&&t.f7Searchbar.destroy()}}}},Messages=function(e){function t(t,a){void 0===a&&(a={}),e.call(this,a,[t]);var r=this,n={autoLayout:!0,messages:[],newMessagesFirst:!1,scrollMessages:!0,scrollMessagesOnEdge:!0,firstMessageRule:void 0,lastMessageRule:void 0,tailMessageRule:void 0,sameNameMessageRule:void 0,sameHeaderMessageRule:void 0,sameFooterMessageRule:void 0,sameAvatarMessageRule:void 0,customClassMessageRule:void 0,renderMessage:void 0};r.useModulesParams(n),r.params=Utils.extend(n,a);var i=$(a.el).eq(0);if(0===i.length)return r;if(i[0].f7Messages)return i[0].f7Messages;i[0].f7Messages=r;var o=i.closest(".page-content").eq(0);return Utils.extend(r,{messages:r.params.messages,$el:i,el:i[0],$pageContentEl:o,pageContentEl:o[0]}),r.useModules(),r.init(),r}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t.prototype.getMessageData=function(e){var t=$(e),a={name:t.find(".message-name").html(),header:t.find(".message-header").html(),textHeader:t.find(".message-text-header").html(),textFooter:t.find(".message-text-footer").html(),footer:t.find(".message-footer").html(),isTitle:t.hasClass("messages-title"),type:t.hasClass("message-sent")?"sent":"received",text:t.find(".message-text").html(),image:t.find(".message-image").html(),imageSrc:t.find(".message-image img").attr("src"),typing:t.hasClass("message-typing")};a.isTitle&&(a.text=t.html()),a.text&&a.textHeader&&(a.text=a.text.replace('<div class="message-text-header">'+a.textHeader+"</div>","")),a.text&&a.textFooter&&(a.text=a.text.replace('<div class="message-text-footer">'+a.textFooter+"</div>",""));var r=t.find(".message-avatar").css("background-image");return"none"!==r&&""!==r||(r=void 0),r=r&&"string"==typeof r?r.replace("url(","").replace(")","").replace(/"/g,"").replace(/'/g,""):void 0,a.avatar=r,a},t.prototype.getMessagesData=function(){var e=this,t=[];return e.$el.find(".message, .messages-title").each((function(a,r){t.push(e.getMessageData(r))})),t},t.prototype.renderMessage=function(e){var t=this,a=Utils.extend({type:"sent",attrs:{}},e);if(t.params.renderMessage)return t.params.renderMessage.call(t,a);if(a.isTitle)return'<div class="messages-title">'+a.text+"</div>";var r=Object.keys(a.attrs).map((function(e){return e+'="'+a.attrs[e]+'"'})).join(" ");return'\n      <div class="message message-'+a.type+" "+(a.isTyping?"message-typing":"")+" "+(a.cssClass||"")+'" '+r+">\n        "+(a.avatar?'\n        <div class="message-avatar" style="background-image:url('+a.avatar+')"></div>\n        ':"")+'\n        <div class="message-content">\n          '+(a.name?'<div class="message-name">'+a.name+"</div>":"")+"\n          "+(a.header?'<div class="message-header">'+a.header+"</div>":"")+'\n          <div class="message-bubble">\n            '+(a.textHeader?'<div class="message-text-header">'+a.textHeader+"</div>":"")+"\n            "+(a.image?'<div class="message-image">'+a.image+"</div>":"")+"\n            "+(a.imageSrc&&!a.image?'<div class="message-image"><img src="'+a.imageSrc+'"></div>':"")+"\n            "+(a.text||a.isTyping?'<div class="message-text">'+(a.text||"")+(a.isTyping?'<div class="message-typing-indicator"><div></div><div></div><div></div></div>':"")+"</div>":"")+"\n            "+(a.textFooter?'<div class="message-text-footer">'+a.textFooter+"</div>":"")+"\n          </div>\n          "+(a.footer?'<div class="message-footer">'+a.footer+"</div>":"")+"\n        </div>\n      </div>\n    "},t.prototype.renderMessages=function(e,t){void 0===e&&(e=this.messages),void 0===t&&(t=this.params.newMessagesFirst?"prepend":"append");var a=this,r=e.map((function(e){return a.renderMessage(e)})).join("");a.$el[t](r)},t.prototype.isFirstMessage=function(){for(var e,t=[],a=arguments.length;a--;)t[a]=arguments[a];var r=this;return!!r.params.firstMessageRule&&(e=r.params).firstMessageRule.apply(e,t)},t.prototype.isLastMessage=function(){for(var e,t=[],a=arguments.length;a--;)t[a]=arguments[a];var r=this;return!!r.params.lastMessageRule&&(e=r.params).lastMessageRule.apply(e,t)},t.prototype.isTailMessage=function(){for(var e,t=[],a=arguments.length;a--;)t[a]=arguments[a];var r=this;return!!r.params.tailMessageRule&&(e=r.params).tailMessageRule.apply(e,t)},t.prototype.isSameNameMessage=function(){for(var e,t=[],a=arguments.length;a--;)t[a]=arguments[a];var r=this;return!!r.params.sameNameMessageRule&&(e=r.params).sameNameMessageRule.apply(e,t)},t.prototype.isSameHeaderMessage=function(){for(var e,t=[],a=arguments.length;a--;)t[a]=arguments[a];var r=this;return!!r.params.sameHeaderMessageRule&&(e=r.params).sameHeaderMessageRule.apply(e,t)},t.prototype.isSameFooterMessage=function(){for(var e,t=[],a=arguments.length;a--;)t[a]=arguments[a];var r=this;return!!r.params.sameFooterMessageRule&&(e=r.params).sameFooterMessageRule.apply(e,t)},t.prototype.isSameAvatarMessage=function(){for(var e,t=[],a=arguments.length;a--;)t[a]=arguments[a];var r=this;return!!r.params.sameAvatarMessageRule&&(e=r.params).sameAvatarMessageRule.apply(e,t)},t.prototype.isCustomClassMessage=function(){for(var e,t=[],a=arguments.length;a--;)t[a]=arguments[a];var r=this;if(r.params.customClassMessageRule)return(e=r.params).customClassMessageRule.apply(e,t)},t.prototype.layout=function(){var e=this;e.$el.find(".message, .messages-title").each((function(t,a){var r=$(a);e.messages||(e.messages=e.getMessagesData());var n=[],i=e.messages[t],o=e.messages[t-1],s=e.messages[t+1];e.isFirstMessage(i,o,s)&&n.push("message-first"),e.isLastMessage(i,o,s)&&n.push("message-last"),e.isTailMessage(i,o,s)&&n.push("message-tail"),e.isSameNameMessage(i,o,s)&&n.push("message-same-name"),e.isSameHeaderMessage(i,o,s)&&n.push("message-same-header"),e.isSameFooterMessage(i,o,s)&&n.push("message-same-footer"),e.isSameAvatarMessage(i,o,s)&&n.push("message-same-avatar");var l=e.isCustomClassMessage(i,o,s);l&&l.length&&("string"==typeof l&&(l=l.split(" ")),l.forEach((function(e){n.push(e)}))),r.removeClass("message-first message-last message-tail message-same-name message-same-header message-same-footer message-same-avatar"),n.forEach((function(e){r.addClass(e)}))}))},t.prototype.clear=function(){this.messages=[],this.$el.html("")},t.prototype.removeMessage=function(e,t){void 0===t&&(t=!0);var a,r,n=this;return"number"==typeof e?(a=e,r=n.$el.find(".message, .messages-title").eq(a)):n.messages&&n.messages.indexOf(e)>=0?(a=n.messages.indexOf(e),r=n.$el.children().eq(a)):a=(r=$(e)).index(),0===r.length||(r.remove(),n.messages.splice(a,1),n.params.autoLayout&&t&&n.layout()),n},t.prototype.removeMessages=function(e,t){void 0===t&&(t=!0);var a=this;if(Array.isArray(e)){var r=[];e.forEach((function(e){r.push(a.$el.find(".message, .messages-title").eq(e))})),r.forEach((function(e){a.removeMessage(e,!1)}))}else $(e).each((function(e,t){a.removeMessage(t,!1)}));return a.params.autoLayout&&t&&a.layout(),a},t.prototype.addMessage=function(){for(var e,t,a=[],r=arguments.length;r--;)a[r]=arguments[r];var n,i,o,s=this;return"boolean"==typeof a[1]?(n=(e=a)[0],i=e[1],o=e[2]):(n=(t=a)[0],o=t[1],i=t[2]),void 0===i&&(i=!0),void 0===o&&(o=s.params.newMessagesFirst?"prepend":"append"),s.addMessages([n],i,o)},t.prototype.addMessages=function(){for(var e,t,a=[],r=arguments.length;r--;)a[r]=arguments[r];var n,i,o,s=this;"boolean"==typeof a[1]?(n=(e=a)[0],i=e[1],o=e[2]):(n=(t=a)[0],o=t[1],i=t[2]),void 0===i&&(i=!0),void 0===o&&(o=s.params.newMessagesFirst?"prepend":"append");var l=s.pageContentEl.scrollHeight,p=s.pageContentEl.offsetHeight,c=s.pageContentEl.scrollTop,d="",u=s.messages.filter((function(e){return e.isTyping}))[0];n.forEach((function(e){u?"append"===o?s.messages.splice(s.messages.indexOf(u),0,e):s.messages.splice(s.messages.indexOf(u)+1,0,e):s.messages["append"===o?"push":"unshift"](e),d+=s.renderMessage(e)}));var h=$(d);if(i&&("append"!==o||s.params.newMessagesFirst||h.addClass("message-appear-from-bottom"),"prepend"===o&&s.params.newMessagesFirst&&h.addClass("message-appear-from-top")),u?"append"===o?h.insertBefore(s.$el.find(".message-typing")):h.insertAfter(s.$el.find(".message-typing")):s.$el[o](h),s.params.autoLayout&&s.layout(),"prepend"!==o||u||(s.pageContentEl.scrollTop=c+(s.pageContentEl.scrollHeight-l)),s.params.scrollMessages&&("append"===o&&!s.params.newMessagesFirst||"prepend"===o&&s.params.newMessagesFirst&&!u))if(s.params.scrollMessagesOnEdge){var f=!1;s.params.newMessagesFirst&&0===c&&(f=!0),!s.params.newMessagesFirst&&c-(l-p)>=-10&&(f=!0),f&&s.scroll(i?void 0:0)}else s.scroll(i?void 0:0);return s},t.prototype.showTyping=function(e){void 0===e&&(e={});var t=this,a=t.messages.filter((function(e){return e.isTyping}))[0];return a&&t.removeMessage(t.messages.indexOf(a)),t.addMessage(Utils.extend({type:"received",isTyping:!0},e)),t},t.prototype.hideTyping=function(){var e,t,a=this;if(a.messages.forEach((function(t,a){t.isTyping&&(e=a)})),void 0!==e&&a.$el.find(".message").eq(e).hasClass("message-typing")&&(t=!0,a.removeMessage(e)),!t){var r=a.$el.find(".message-typing");r.length&&a.removeMessage(r)}return a},t.prototype.scroll=function(e,t){void 0===e&&(e=300);var a,r=this,n=r.pageContentEl.scrollTop;if(void 0!==t)a=t;else if((a=r.params.newMessagesFirst?0:r.pageContentEl.scrollHeight-r.pageContentEl.offsetHeight)===n)return r;return r.$pageContentEl.scrollTop(a,e),r},t.prototype.init=function(){var e=this;e.messages&&0!==e.messages.length||(e.messages=e.getMessagesData()),e.params.messages&&e.params.messages.length&&e.renderMessages(),e.params.autoLayout&&e.layout(),e.params.scrollMessages&&e.scroll(0)},t.prototype.destroy=function(){var e=this;e.emit("local::beforeDestroy messagesBeforeDestroy",e),e.$el.trigger("messages:beforedestroy"),e.$el[0]&&(e.$el[0].f7Messages=null,delete e.$el[0].f7Messages),Utils.deleteProps(e)},t}(Framework7Class),Messages$1={name:"messages",static:{Messages:Messages},create:function(){this.messages=ConstructorMethods({defaultSelector:".messages",constructor:Messages,app:this,domProp:"f7Messages",addMethods:"renderMessages layout scroll clear removeMessage removeMessages addMessage addMessages".split(" ")})},on:{tabBeforeRemove:function(e){var t=this;$(e).find(".messages-init").each((function(e,a){t.messages.destroy(a)}))},tabMounted:function(e){var t=this;$(e).find(".messages-init").each((function(e,a){t.messages.create({el:a})}))},pageBeforeRemove:function(e){var t=this;e.$el.find(".messages-init").each((function(e,a){t.messages.destroy(a)}))},pageInit:function(e){var t=this;e.$el.find(".messages-init").each((function(e,a){t.messages.create({el:a})}))}},vnode:{"messages-init":{insert:function(e){var t=e.elm;this.messages.create({el:t})},destroy:function(e){var t=e.elm;this.messages.destroy(t)}}}},Messagebar=function(e){function t(t,a){void 0===a&&(a={}),e.call(this,a,[t]);var r=this,n={top:!1,topOffset:0,bottomOffset:0,attachments:[],renderAttachments:void 0,renderAttachment:void 0,maxHeight:null,resizePage:!0};r.useModulesParams(n),r.params=Utils.extend(n,a);var i=$(r.params.el);if(0===i.length)return r;if(i[0].f7Messagebar)return i[0].f7Messagebar;i[0].f7Messagebar=r;var o,s=i.parents(".page").eq(0),l=s.find(".page-content").eq(0),p=i.find(".messagebar-area");o=r.params.textareaEl?$(r.params.textareaEl):i.find("textarea");var c=i.find(".messagebar-attachments"),d=i.find(".messagebar-sheet");function u(){r.params.resizePage&&r.resizePage()}function h(e){e.preventDefault()}function f(e){var t=$(this).index();$(e.target).closest(".messagebar-attachment-delete").length?($(this).trigger("messagebar:attachmentdelete",t),r.emit("local::attachmentDelete messagebarAttachmentDelete",r,this,t)):($(this).trigger("messagebar:attachmentclick",t),r.emit("local::attachmentClick messagebarAttachmentClick",r,this,t))}function m(){r.checkEmptyState(),r.$el.trigger("messagebar:change"),r.emit("local::change messagebarChange",r)}function v(){r.sheetHide(),r.$el.addClass("messagebar-focused"),r.$el.trigger("messagebar:focus"),r.emit("local::focus messagebarFocus",r)}function g(){r.$el.removeClass("messagebar-focused"),r.$el.trigger("messagebar:blur"),r.emit("local::blur messagebarBlur",r)}return r.params.top&&i.addClass("messagebar-top"),Utils.extend(r,{$el:i,el:i[0],$areaEl:p,areaEl:p[0],$textareaEl:o,textareaEl:o[0],$attachmentsEl:c,attachmentsEl:c[0],attachmentsVisible:c.hasClass("messagebar-attachments-visible"),$sheetEl:d,sheetEl:d[0],sheetVisible:d.hasClass("messagebar-sheet-visible"),$pageEl:s,pageEl:s[0],$pageContentEl:l,pageContentEl:l,top:i.hasClass("messagebar-top")||r.params.top,attachments:[]}),r.attachEvents=function(){i.on("textarea:resize",u),i.on("submit",h),i.on("click",".messagebar-attachment",f),o.on("change input",m),o.on("focus",v),o.on("blur",g),t.on("resize",u)},r.detachEvents=function(){i.off("textarea:resize",u),i.off("submit",h),i.off("click",".messagebar-attachment",f),o.off("change input",m),o.off("focus",v),o.off("blur",g),t.off("resize",u)},r.useModules(),r.init(),r}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t.prototype.focus=function(){return this.$textareaEl.focus(),this},t.prototype.blur=function(){return this.$textareaEl.blur(),this},t.prototype.clear=function(){return this.$textareaEl.val("").trigger("change"),this},t.prototype.getValue=function(){return this.$textareaEl.val().trim()},t.prototype.setValue=function(e){return this.$textareaEl.val(e).trigger("change"),this},t.prototype.setPlaceholder=function(e){return this.$textareaEl.attr("placeholder",e),this},t.prototype.resizePage=function(){var e=this.params,t=this.$el,a=this.top,r=this.$pageEl,n=this.$pageContentEl,i=this.$areaEl,o=this.$textareaEl,s=this.$sheetEl,l=this.$attachmentsEl,p=t[0].offsetHeight,c=e.maxHeight;if(a);else{var d=parseInt(n.css("padding-bottom"),10),u=p+e.bottomOffset;if(u!==d&&n.length){var h=parseInt(n.css("padding-top"),10),f=n[0].scrollHeight,m=n[0].offsetHeight,v=n[0].scrollTop===f-m;c||(c=r[0].offsetHeight-h-s.outerHeight()-l.outerHeight()-parseInt(i.css("margin-top"),10)-parseInt(i.css("margin-bottom"),10)),o.css("max-height",c+"px"),n.css("padding-bottom",u+"px"),v&&n.scrollTop(n[0].scrollHeight-m),t.trigger("messagebar:resizepage"),this.emit("local::resizePage messagebarResizePage",this)}}},t.prototype.checkEmptyState=function(){var e=this.$el,t=this.$textareaEl.val().trim();t&&t.length?e.addClass("messagebar-with-value"):e.removeClass("messagebar-with-value")},t.prototype.attachmentsCreate=function(e){void 0===e&&(e="");var t=$('<div class="messagebar-attachments">'+e+"</div>");return t.insertBefore(this.$textareaEl),Utils.extend(this,{$attachmentsEl:t,attachmentsEl:t[0]}),this},t.prototype.attachmentsShow=function(e){void 0===e&&(e="");return this.$attachmentsEl=this.$el.find(".messagebar-attachments"),0===this.$attachmentsEl.length&&this.attachmentsCreate(e),this.$el.addClass("messagebar-attachments-visible"),this.attachmentsVisible=!0,this.params.resizePage&&this.resizePage(),this},t.prototype.attachmentsHide=function(){return this.$el.removeClass("messagebar-attachments-visible"),this.attachmentsVisible=!1,this.params.resizePage&&this.resizePage(),this},t.prototype.attachmentsToggle=function(){return this.attachmentsVisible?this.attachmentsHide():this.attachmentsShow(),this},t.prototype.renderAttachment=function(e){return this.params.renderAttachment?this.params.renderAttachment.call(this,e):'\n      <div class="messagebar-attachment">\n        <img src="'+e+'">\n        <span class="messagebar-attachment-delete"></span>\n      </div>\n    '},t.prototype.renderAttachments=function(){var e,t=this;e=t.params.renderAttachments?t.params.renderAttachments.call(t,t.attachments):""+t.attachments.map((function(e){return t.renderAttachment(e)})).join(""),0===t.$attachmentsEl.length?t.attachmentsCreate(e):t.$attachmentsEl.html(e)},t.prototype.sheetCreate=function(e){void 0===e&&(e="");var t=$('<div class="messagebar-sheet">'+e+"</div>");return this.$el.append(t),Utils.extend(this,{$sheetEl:t,sheetEl:t[0]}),this},t.prototype.sheetShow=function(e){void 0===e&&(e="");return this.$sheetEl=this.$el.find(".messagebar-sheet"),0===this.$sheetEl.length&&this.sheetCreate(e),this.$el.addClass("messagebar-sheet-visible"),this.sheetVisible=!0,this.params.resizePage&&this.resizePage(),this},t.prototype.sheetHide=function(){return this.$el.removeClass("messagebar-sheet-visible"),this.sheetVisible=!1,this.params.resizePage&&this.resizePage(),this},t.prototype.sheetToggle=function(){return this.sheetVisible?this.sheetHide():this.sheetShow(),this},t.prototype.init=function(){return this.attachEvents(),this.checkEmptyState(),this},t.prototype.destroy=function(){this.emit("local::beforeDestroy messagebarBeforeDestroy",this),this.$el.trigger("messagebar:beforedestroy"),this.detachEvents(),this.$el[0]&&(this.$el[0].f7Messagebar=null,delete this.$el[0].f7Messagebar),Utils.deleteProps(this)},t}(Framework7Class),Messagebar$1={name:"messagebar",static:{Messagebar:Messagebar},create:function(){this.messagebar=ConstructorMethods({defaultSelector:".messagebar",constructor:Messagebar,app:this,domProp:"f7Messagebar",addMethods:"clear getValue setValue setPlaceholder resizePage focus blur attachmentsCreate attachmentsShow attachmentsHide attachmentsToggle renderAttachments sheetCreate sheetShow sheetHide sheetToggle".split(" ")})},on:{tabBeforeRemove:function(e){var t=this;$(e).find(".messagebar-init").each((function(e,a){t.messagebar.destroy(a)}))},tabMounted:function(e){var t=this;$(e).find(".messagebar-init").each((function(e,a){t.messagebar.create(Utils.extend({el:a},$(a).dataset()))}))},pageBeforeRemove:function(e){var t=this;e.$el.find(".messagebar-init").each((function(e,a){t.messagebar.destroy(a)}))},pageInit:function(e){var t=this;e.$el.find(".messagebar-init").each((function(e,a){t.messagebar.create(Utils.extend({el:a},$(a).dataset()))}))}},vnode:{"messagebar-init":{insert:function(e){var t=e.elm;this.messagebar.create(Utils.extend({el:t},$(t).dataset()))},destroy:function(e){var t=e.elm;this.messagebar.destroy(t)}}}};function updateSize(){var e,t,a=this.$el;e=void 0!==this.params.width?this.params.width:a[0].clientWidth,t=void 0!==this.params.height?this.params.height:a[0].clientHeight,0===e&&this.isHorizontal()||0===t&&this.isVertical()||(e=e-parseInt(a.css("padding-left"),10)-parseInt(a.css("padding-right"),10),t=t-parseInt(a.css("padding-top"),10)-parseInt(a.css("padding-bottom"),10),Utils.extend(this,{width:e,height:t,size:this.isHorizontal()?e:t}))}function updateSlides(){var e=this.params,t=this.$wrapperEl,a=this.size,r=this.rtlTranslate,n=this.wrongRTL,i=this.virtual&&e.virtual.enabled,o=i?this.virtual.slides.length:this.slides.length,s=t.children("."+this.params.slideClass),l=i?this.virtual.slides.length:s.length,p=[],c=[],d=[];function u(t){return!e.cssMode||t!==s.length-1}var h=e.slidesOffsetBefore;"function"==typeof h&&(h=e.slidesOffsetBefore.call(this));var f=e.slidesOffsetAfter;"function"==typeof f&&(f=e.slidesOffsetAfter.call(this));var m=this.snapGrid.length,v=this.snapGrid.length,g=e.spaceBetween,b=-h,y=0,w=0;if(void 0!==a){var C,x;"string"==typeof g&&g.indexOf("%")>=0&&(g=parseFloat(g.replace("%",""))/100*a),this.virtualSize=-g,r?s.css({marginLeft:"",marginTop:""}):s.css({marginRight:"",marginBottom:""}),e.slidesPerColumn>1&&(C=Math.floor(l/e.slidesPerColumn)===l/this.params.slidesPerColumn?l:Math.ceil(l/e.slidesPerColumn)*e.slidesPerColumn,"auto"!==e.slidesPerView&&"row"===e.slidesPerColumnFill&&(C=Math.max(C,e.slidesPerView*e.slidesPerColumn)));for(var $,k=e.slidesPerColumn,E=C/k,T=Math.floor(l/e.slidesPerColumn),S=0;S<l;S+=1){x=0;var M=s.eq(S);if(e.slidesPerColumn>1){var P=void 0,O=void 0,D=void 0;if("row"===e.slidesPerColumnFill&&e.slidesPerGroup>1){var I=Math.floor(S/(e.slidesPerGroup*e.slidesPerColumn)),B=S-e.slidesPerColumn*e.slidesPerGroup*I,R=0===I?e.slidesPerGroup:Math.min(Math.ceil((l-I*k*e.slidesPerGroup)/k),e.slidesPerGroup);P=(O=B-(D=Math.floor(B/R))*R+I*e.slidesPerGroup)+D*C/k,M.css({"-webkit-box-ordinal-group":P,"-moz-box-ordinal-group":P,"-ms-flex-order":P,"-webkit-order":P,order:P})}else"column"===e.slidesPerColumnFill?(D=S-(O=Math.floor(S/k))*k,(O>T||O===T&&D===k-1)&&(D+=1)>=k&&(D=0,O+=1)):O=S-(D=Math.floor(S/E))*E;M.css("margin-"+(this.isHorizontal()?"top":"left"),0!==D&&e.spaceBetween&&e.spaceBetween+"px")}if("none"!==M.css("display")){if("auto"===e.slidesPerView){var L=win.getComputedStyle(M[0],null),z=M[0].style.transform,A=M[0].style.webkitTransform;if(z&&(M[0].style.transform="none"),A&&(M[0].style.webkitTransform="none"),e.roundLengths)x=this.isHorizontal()?M.outerWidth(!0):M.outerHeight(!0);else if(this.isHorizontal()){var H=parseFloat(L.getPropertyValue("width")),U=parseFloat(L.getPropertyValue("padding-left")),N=parseFloat(L.getPropertyValue("padding-right")),F=parseFloat(L.getPropertyValue("margin-left")),V=parseFloat(L.getPropertyValue("margin-right")),q=L.getPropertyValue("box-sizing");x=q&&"border-box"===q?H+F+V:H+U+N+F+V}else{var j=parseFloat(L.getPropertyValue("height")),_=parseFloat(L.getPropertyValue("padding-top")),Y=parseFloat(L.getPropertyValue("padding-bottom")),W=parseFloat(L.getPropertyValue("margin-top")),X=parseFloat(L.getPropertyValue("margin-bottom")),G=L.getPropertyValue("box-sizing");x=G&&"border-box"===G?j+W+X:j+_+Y+W+X}z&&(M[0].style.transform=z),A&&(M[0].style.webkitTransform=A),e.roundLengths&&(x=Math.floor(x))}else x=(a-(e.slidesPerView-1)*g)/e.slidesPerView,e.roundLengths&&(x=Math.floor(x)),s[S]&&(this.isHorizontal()?s[S].style.width=x+"px":s[S].style.height=x+"px");s[S]&&(s[S].swiperSlideSize=x),d.push(x),e.centeredSlides?(b=b+x/2+y/2+g,0===y&&0!==S&&(b=b-a/2-g),0===S&&(b=b-a/2-g),Math.abs(b)<.001&&(b=0),e.roundLengths&&(b=Math.floor(b)),w%e.slidesPerGroup==0&&p.push(b),c.push(b)):(e.roundLengths&&(b=Math.floor(b)),(w-Math.min(this.params.slidesPerGroupSkip,w))%this.params.slidesPerGroup==0&&p.push(b),c.push(b),b=b+x+g),this.virtualSize+=x+g,y=x,w+=1}}if(this.virtualSize=Math.max(this.virtualSize,a)+f,r&&n&&("slide"===e.effect||"coverflow"===e.effect)&&t.css({width:this.virtualSize+e.spaceBetween+"px"}),e.setWrapperSize&&(this.isHorizontal()?t.css({width:this.virtualSize+e.spaceBetween+"px"}):t.css({height:this.virtualSize+e.spaceBetween+"px"})),e.slidesPerColumn>1&&(this.virtualSize=(x+e.spaceBetween)*C,this.virtualSize=Math.ceil(this.virtualSize/e.slidesPerColumn)-e.spaceBetween,this.isHorizontal()?t.css({width:this.virtualSize+e.spaceBetween+"px"}):t.css({height:this.virtualSize+e.spaceBetween+"px"}),e.centeredSlides)){$=[];for(var K=0;K<p.length;K+=1){var Q=p[K];e.roundLengths&&(Q=Math.floor(Q)),p[K]<this.virtualSize+p[0]&&$.push(Q)}p=$}if(!e.centeredSlides){$=[];for(var J=0;J<p.length;J+=1){var Z=p[J];e.roundLengths&&(Z=Math.floor(Z)),p[J]<=this.virtualSize-a&&$.push(Z)}p=$,Math.floor(this.virtualSize-a)-Math.floor(p[p.length-1])>1&&p.push(this.virtualSize-a)}if(0===p.length&&(p=[0]),0!==e.spaceBetween&&(this.isHorizontal()?r?s.filter(u).css({marginLeft:g+"px"}):s.filter(u).css({marginRight:g+"px"}):s.filter(u).css({marginBottom:g+"px"})),e.centeredSlides&&e.centeredSlidesBounds){var ee=0;d.forEach((function(t){ee+=t+(e.spaceBetween?e.spaceBetween:0)}));var te=(ee-=e.spaceBetween)-a;p=p.map((function(e){return e<0?-h:e>te?te+f:e}))}if(e.centerInsufficientSlides){var ae=0;if(d.forEach((function(t){ae+=t+(e.spaceBetween?e.spaceBetween:0)})),(ae-=e.spaceBetween)<a){var re=(a-ae)/2;p.forEach((function(e,t){p[t]=e-re})),c.forEach((function(e,t){c[t]=e+re}))}}Utils.extend(this,{slides:s,snapGrid:p,slidesGrid:c,slidesSizesGrid:d}),l!==o&&this.emit("slidesLengthChange"),p.length!==m&&(this.params.watchOverflow&&this.checkOverflow(),this.emit("snapGridLengthChange")),c.length!==v&&this.emit("slidesGridLengthChange"),(e.watchSlidesProgress||e.watchSlidesVisibility)&&this.updateSlidesOffset()}}function updateAutoHeight(e){var t,a=[],r=0;if("number"==typeof e?this.setTransition(e):!0===e&&this.setTransition(this.params.speed),"auto"!==this.params.slidesPerView&&this.params.slidesPerView>1)if(this.params.centeredSlides)a.push.apply(a,this.visibleSlides);else for(t=0;t<Math.ceil(this.params.slidesPerView);t+=1){var n=this.activeIndex+t;if(n>this.slides.length)break;a.push(this.slides.eq(n)[0])}else a.push(this.slides.eq(this.activeIndex)[0]);for(t=0;t<a.length;t+=1)if(void 0!==a[t]){var i=a[t].offsetHeight;r=i>r?i:r}r&&this.$wrapperEl.css("height",r+"px")}function updateSlidesOffset(){for(var e=this.slides,t=0;t<e.length;t+=1)e[t].swiperSlideOffset=this.isHorizontal()?e[t].offsetLeft:e[t].offsetTop}function updateSlidesProgress(e){void 0===e&&(e=this&&this.translate||0);var t=this.params,a=this.slides,r=this.rtlTranslate;if(0!==a.length){void 0===a[0].swiperSlideOffset&&this.updateSlidesOffset();var n=-e;r&&(n=e),a.removeClass(t.slideVisibleClass),this.visibleSlidesIndexes=[],this.visibleSlides=[];for(var i=0;i<a.length;i+=1){var o=a[i],s=(n+(t.centeredSlides?this.minTranslate():0)-o.swiperSlideOffset)/(o.swiperSlideSize+t.spaceBetween);if(t.watchSlidesVisibility||t.centeredSlides&&t.autoHeight){var l=-(n-o.swiperSlideOffset),p=l+this.slidesSizesGrid[i];(l>=0&&l<this.size-1||p>1&&p<=this.size||l<=0&&p>=this.size)&&(this.visibleSlides.push(o),this.visibleSlidesIndexes.push(i),a.eq(i).addClass(t.slideVisibleClass))}o.progress=r?-s:s}this.visibleSlides=$(this.visibleSlides)}}function updateProgress(e){if(void 0===e){var t=this.rtlTranslate?-1:1;e=this&&this.translate&&this.translate*t||0}var a=this.params,r=this.maxTranslate()-this.minTranslate(),n=this.progress,i=this.isBeginning,o=this.isEnd,s=i,l=o;0===r?(n=0,i=!0,o=!0):(i=(n=(e-this.minTranslate())/r)<=0,o=n>=1),Utils.extend(this,{progress:n,isBeginning:i,isEnd:o}),(a.watchSlidesProgress||a.watchSlidesVisibility||a.centeredSlides&&a.autoHeight)&&this.updateSlidesProgress(e),i&&!s&&this.emit("reachBeginning toEdge"),o&&!l&&this.emit("reachEnd toEdge"),(s&&!i||l&&!o)&&this.emit("fromEdge"),this.emit("progress",n)}function updateSlidesClasses(){var e,t=this.slides,a=this.params,r=this.$wrapperEl,n=this.activeIndex,i=this.realIndex,o=this.virtual&&a.virtual.enabled;t.removeClass(a.slideActiveClass+" "+a.slideNextClass+" "+a.slidePrevClass+" "+a.slideDuplicateActiveClass+" "+a.slideDuplicateNextClass+" "+a.slideDuplicatePrevClass),(e=o?this.$wrapperEl.find("."+a.slideClass+'[data-swiper-slide-index="'+n+'"]'):t.eq(n)).addClass(a.slideActiveClass),a.loop&&(e.hasClass(a.slideDuplicateClass)?r.children("."+a.slideClass+":not(."+a.slideDuplicateClass+')[data-swiper-slide-index="'+i+'"]').addClass(a.slideDuplicateActiveClass):r.children("."+a.slideClass+"."+a.slideDuplicateClass+'[data-swiper-slide-index="'+i+'"]').addClass(a.slideDuplicateActiveClass));var s=e.nextAll("."+a.slideClass).eq(0).addClass(a.slideNextClass);a.loop&&0===s.length&&(s=t.eq(0)).addClass(a.slideNextClass);var l=e.prevAll("."+a.slideClass).eq(0).addClass(a.slidePrevClass);a.loop&&0===l.length&&(l=t.eq(-1)).addClass(a.slidePrevClass),a.loop&&(s.hasClass(a.slideDuplicateClass)?r.children("."+a.slideClass+":not(."+a.slideDuplicateClass+')[data-swiper-slide-index="'+s.attr("data-swiper-slide-index")+'"]').addClass(a.slideDuplicateNextClass):r.children("."+a.slideClass+"."+a.slideDuplicateClass+'[data-swiper-slide-index="'+s.attr("data-swiper-slide-index")+'"]').addClass(a.slideDuplicateNextClass),l.hasClass(a.slideDuplicateClass)?r.children("."+a.slideClass+":not(."+a.slideDuplicateClass+')[data-swiper-slide-index="'+l.attr("data-swiper-slide-index")+'"]').addClass(a.slideDuplicatePrevClass):r.children("."+a.slideClass+"."+a.slideDuplicateClass+'[data-swiper-slide-index="'+l.attr("data-swiper-slide-index")+'"]').addClass(a.slideDuplicatePrevClass))}function updateActiveIndex(e){var t,a=this.rtlTranslate?this.translate:-this.translate,r=this.slidesGrid,n=this.snapGrid,i=this.params,o=this.activeIndex,s=this.realIndex,l=this.snapIndex,p=e;if(void 0===p){for(var c=0;c<r.length;c+=1)void 0!==r[c+1]?a>=r[c]&&a<r[c+1]-(r[c+1]-r[c])/2?p=c:a>=r[c]&&a<r[c+1]&&(p=c+1):a>=r[c]&&(p=c);i.normalizeSlideIndex&&(p<0||void 0===p)&&(p=0)}if(n.indexOf(a)>=0)t=n.indexOf(a);else{var d=Math.min(i.slidesPerGroupSkip,p);t=d+Math.floor((p-d)/i.slidesPerGroup)}if(t>=n.length&&(t=n.length-1),p!==o){var u=parseInt(this.slides.eq(p).attr("data-swiper-slide-index")||p,10);Utils.extend(this,{snapIndex:t,realIndex:u,previousIndex:o,activeIndex:p}),this.emit("activeIndexChange"),this.emit("snapIndexChange"),s!==u&&this.emit("realIndexChange"),(this.initialized||this.runCallbacksOnInit)&&this.emit("slideChange")}else t!==l&&(this.snapIndex=t,this.emit("snapIndexChange"))}function updateClickedSlide(e){var t=this.params,a=$(e.target).closest("."+t.slideClass)[0],r=!1;if(a)for(var n=0;n<this.slides.length;n+=1)this.slides[n]===a&&(r=!0);if(!a||!r)return this.clickedSlide=void 0,void(this.clickedIndex=void 0);this.clickedSlide=a,this.virtual&&this.params.virtual.enabled?this.clickedIndex=parseInt($(a).attr("data-swiper-slide-index"),10):this.clickedIndex=$(a).index(),t.slideToClickedSlide&&void 0!==this.clickedIndex&&this.clickedIndex!==this.activeIndex&&this.slideToClickedSlide()}var update={updateSize:updateSize,updateSlides:updateSlides,updateAutoHeight:updateAutoHeight,updateSlidesOffset:updateSlidesOffset,updateSlidesProgress:updateSlidesProgress,updateProgress:updateProgress,updateSlidesClasses:updateSlidesClasses,updateActiveIndex:updateActiveIndex,updateClickedSlide:updateClickedSlide};function getTranslate(e){void 0===e&&(e=this.isHorizontal()?"x":"y");var t=this.params,a=this.rtlTranslate,r=this.translate,n=this.$wrapperEl;if(t.virtualTranslate)return a?-r:r;if(t.cssMode)return r;var i=Utils.getTranslate(n[0],e);return a&&(i=-i),i||0}function setTranslate(e,t){var a=this.rtlTranslate,r=this.params,n=this.$wrapperEl,i=this.wrapperEl,o=this.progress,s=0,l=0;this.isHorizontal()?s=a?-e:e:l=e,r.roundLengths&&(s=Math.floor(s),l=Math.floor(l)),r.cssMode?i[this.isHorizontal()?"scrollLeft":"scrollTop"]=this.isHorizontal()?-s:-l:r.virtualTranslate||n.transform("translate3d("+s+"px, "+l+"px, 0px)"),this.previousTranslate=this.translate,this.translate=this.isHorizontal()?s:l;var p=this.maxTranslate()-this.minTranslate();(0===p?0:(e-this.minTranslate())/p)!==o&&this.updateProgress(e),this.emit("setTranslate",this.translate,t)}function minTranslate(){return-this.snapGrid[0]}function maxTranslate(){return-this.snapGrid[this.snapGrid.length-1]}function translateTo(e,t,a,r,n){var i;void 0===e&&(e=0),void 0===t&&(t=this.params.speed),void 0===a&&(a=!0),void 0===r&&(r=!0);var o=this,s=o.params,l=o.wrapperEl;if(o.animating&&s.preventInteractionOnTransition)return!1;var p,c=o.minTranslate(),d=o.maxTranslate();if(p=r&&e>c?c:r&&e<d?d:e,o.updateProgress(p),s.cssMode){var u=o.isHorizontal();return 0===t?l[u?"scrollLeft":"scrollTop"]=-p:l.scrollTo?l.scrollTo(((i={})[u?"left":"top"]=-p,i.behavior="smooth",i)):l[u?"scrollLeft":"scrollTop"]=-p,!0}return 0===t?(o.setTransition(0),o.setTranslate(p),a&&(o.emit("beforeTransitionStart",t,n),o.emit("transitionEnd"))):(o.setTransition(t),o.setTranslate(p),a&&(o.emit("beforeTransitionStart",t,n),o.emit("transitionStart")),o.animating||(o.animating=!0,o.onTranslateToWrapperTransitionEnd||(o.onTranslateToWrapperTransitionEnd=function(e){o&&!o.destroyed&&e.target===this&&(o.$wrapperEl[0].removeEventListener("transitionend",o.onTranslateToWrapperTransitionEnd),o.$wrapperEl[0].removeEventListener("webkitTransitionEnd",o.onTranslateToWrapperTransitionEnd),o.onTranslateToWrapperTransitionEnd=null,delete o.onTranslateToWrapperTransitionEnd,a&&o.emit("transitionEnd"))}),o.$wrapperEl[0].addEventListener("transitionend",o.onTranslateToWrapperTransitionEnd),o.$wrapperEl[0].addEventListener("webkitTransitionEnd",o.onTranslateToWrapperTransitionEnd))),!0}var translate={getTranslate:getTranslate,setTranslate:setTranslate,minTranslate:minTranslate,maxTranslate:maxTranslate,translateTo:translateTo};function setTransition(e,t){this.params.cssMode||this.$wrapperEl.transition(e),this.emit("setTransition",e,t)}function transitionStart(e,t){void 0===e&&(e=!0);var a=this.activeIndex,r=this.params,n=this.previousIndex;if(!r.cssMode){r.autoHeight&&this.updateAutoHeight();var i=t;if(i||(i=a>n?"next":a<n?"prev":"reset"),this.emit("transitionStart"),e&&a!==n){if("reset"===i)return void this.emit("slideResetTransitionStart");this.emit("slideChangeTransitionStart"),"next"===i?this.emit("slideNextTransitionStart"):this.emit("slidePrevTransitionStart")}}}function transitionEnd$1(e,t){void 0===e&&(e=!0);var a=this.activeIndex,r=this.previousIndex,n=this.params;if(this.animating=!1,!n.cssMode){this.setTransition(0);var i=t;if(i||(i=a>r?"next":a<r?"prev":"reset"),this.emit("transitionEnd"),e&&a!==r){if("reset"===i)return void this.emit("slideResetTransitionEnd");this.emit("slideChangeTransitionEnd"),"next"===i?this.emit("slideNextTransitionEnd"):this.emit("slidePrevTransitionEnd")}}}var transition$1={setTransition:setTransition,transitionStart:transitionStart,transitionEnd:transitionEnd$1};function slideTo(e,t,a,r){var n;void 0===e&&(e=0),void 0===t&&(t=this.params.speed),void 0===a&&(a=!0);var i=this,o=e;o<0&&(o=0);var s=i.params,l=i.snapGrid,p=i.slidesGrid,c=i.previousIndex,d=i.activeIndex,u=i.rtlTranslate,h=i.wrapperEl;if(i.animating&&s.preventInteractionOnTransition)return!1;var f=Math.min(i.params.slidesPerGroupSkip,o),m=f+Math.floor((o-f)/i.params.slidesPerGroup);m>=l.length&&(m=l.length-1),(d||s.initialSlide||0)===(c||0)&&a&&i.emit("beforeSlideChangeStart");var v,g=-l[m];if(i.updateProgress(g),s.normalizeSlideIndex)for(var b=0;b<p.length;b+=1)-Math.floor(100*g)>=Math.floor(100*p[b])&&(o=b);if(i.initialized&&o!==d){if(!i.allowSlideNext&&g<i.translate&&g<i.minTranslate())return!1;if(!i.allowSlidePrev&&g>i.translate&&g>i.maxTranslate()&&(d||0)!==o)return!1}if(v=o>d?"next":o<d?"prev":"reset",u&&-g===i.translate||!u&&g===i.translate)return i.updateActiveIndex(o),s.autoHeight&&i.updateAutoHeight(),i.updateSlidesClasses(),"slide"!==s.effect&&i.setTranslate(g),"reset"!==v&&(i.transitionStart(a,v),i.transitionEnd(a,v)),!1;if(s.cssMode){var y=i.isHorizontal();return 0===t?h[y?"scrollLeft":"scrollTop"]=-g:h.scrollTo?h.scrollTo(((n={})[y?"left":"top"]=-g,n.behavior="smooth",n)):h[y?"scrollLeft":"scrollTop"]=-g,!0}return 0===t?(i.setTransition(0),i.setTranslate(g),i.updateActiveIndex(o),i.updateSlidesClasses(),i.emit("beforeTransitionStart",t,r),i.transitionStart(a,v),i.transitionEnd(a,v)):(i.setTransition(t),i.setTranslate(g),i.updateActiveIndex(o),i.updateSlidesClasses(),i.emit("beforeTransitionStart",t,r),i.transitionStart(a,v),i.animating||(i.animating=!0,i.onSlideToWrapperTransitionEnd||(i.onSlideToWrapperTransitionEnd=function(e){i&&!i.destroyed&&e.target===this&&(i.$wrapperEl[0].removeEventListener("transitionend",i.onSlideToWrapperTransitionEnd),i.$wrapperEl[0].removeEventListener("webkitTransitionEnd",i.onSlideToWrapperTransitionEnd),i.onSlideToWrapperTransitionEnd=null,delete i.onSlideToWrapperTransitionEnd,i.transitionEnd(a,v))}),i.$wrapperEl[0].addEventListener("transitionend",i.onSlideToWrapperTransitionEnd),i.$wrapperEl[0].addEventListener("webkitTransitionEnd",i.onSlideToWrapperTransitionEnd))),!0}function slideToLoop(e,t,a,r){void 0===e&&(e=0),void 0===t&&(t=this.params.speed),void 0===a&&(a=!0);var n=e;return this.params.loop&&(n+=this.loopedSlides),this.slideTo(n,t,a,r)}function slideNext(e,t,a){void 0===e&&(e=this.params.speed),void 0===t&&(t=!0);var r=this.params,n=this.animating,i=this.activeIndex<r.slidesPerGroupSkip?1:r.slidesPerGroup;if(r.loop){if(n)return!1;this.loopFix(),this._clientLeft=this.$wrapperEl[0].clientLeft}return this.slideTo(this.activeIndex+i,e,t,a)}function slidePrev(e,t,a){void 0===e&&(e=this.params.speed),void 0===t&&(t=!0);var r=this.params,n=this.animating,i=this.snapGrid,o=this.slidesGrid,s=this.rtlTranslate;if(r.loop){if(n)return!1;this.loopFix(),this._clientLeft=this.$wrapperEl[0].clientLeft}function l(e){return e<0?-Math.floor(Math.abs(e)):Math.floor(e)}var p,c=l(s?this.translate:-this.translate),d=i.map((function(e){return l(e)})),u=(o.map((function(e){return l(e)})),i[d.indexOf(c)],i[d.indexOf(c)-1]);return void 0===u&&r.cssMode&&i.forEach((function(e){!u&&c>=e&&(u=e)})),void 0!==u&&(p=o.indexOf(u))<0&&(p=this.activeIndex-1),this.slideTo(p,e,t,a)}function slideReset(e,t,a){void 0===e&&(e=this.params.speed),void 0===t&&(t=!0);return this.slideTo(this.activeIndex,e,t,a)}function slideToClosest(e,t,a,r){void 0===e&&(e=this.params.speed),void 0===t&&(t=!0),void 0===r&&(r=.5);var n=this.activeIndex,i=Math.min(this.params.slidesPerGroupSkip,n),o=i+Math.floor((n-i)/this.params.slidesPerGroup),s=this.rtlTranslate?this.translate:-this.translate;if(s>=this.snapGrid[o]){var l=this.snapGrid[o];s-l>(this.snapGrid[o+1]-l)*r&&(n+=this.params.slidesPerGroup)}else{var p=this.snapGrid[o-1];s-p<=(this.snapGrid[o]-p)*r&&(n-=this.params.slidesPerGroup)}return n=Math.max(n,0),n=Math.min(n,this.slidesGrid.length-1),this.slideTo(n,e,t,a)}function slideToClickedSlide(){var e,t=this,a=t.params,r=t.$wrapperEl,n="auto"===a.slidesPerView?t.slidesPerViewDynamic():a.slidesPerView,i=t.clickedIndex;if(a.loop){if(t.animating)return;e=parseInt($(t.clickedSlide).attr("data-swiper-slide-index"),10),a.centeredSlides?i<t.loopedSlides-n/2||i>t.slides.length-t.loopedSlides+n/2?(t.loopFix(),i=r.children("."+a.slideClass+'[data-swiper-slide-index="'+e+'"]:not(.'+a.slideDuplicateClass+")").eq(0).index(),Utils.nextTick((function(){t.slideTo(i)}))):t.slideTo(i):i>t.slides.length-n?(t.loopFix(),i=r.children("."+a.slideClass+'[data-swiper-slide-index="'+e+'"]:not(.'+a.slideDuplicateClass+")").eq(0).index(),Utils.nextTick((function(){t.slideTo(i)}))):t.slideTo(i)}else t.slideTo(i)}var slide={slideTo:slideTo,slideToLoop:slideToLoop,slideNext:slideNext,slidePrev:slidePrev,slideReset:slideReset,slideToClosest:slideToClosest,slideToClickedSlide:slideToClickedSlide};function loopCreate(){var e=this,t=e.params,a=e.$wrapperEl;a.children("."+t.slideClass+"."+t.slideDuplicateClass).remove();var r=a.children("."+t.slideClass);if(t.loopFillGroupWithBlank){var n=t.slidesPerGroup-r.length%t.slidesPerGroup;if(n!==t.slidesPerGroup){for(var i=0;i<n;i+=1){var o=$(doc.createElement("div")).addClass(t.slideClass+" "+t.slideBlankClass);a.append(o)}r=a.children("."+t.slideClass)}}"auto"!==t.slidesPerView||t.loopedSlides||(t.loopedSlides=r.length),e.loopedSlides=Math.ceil(parseFloat(t.loopedSlides||t.slidesPerView,10)),e.loopedSlides+=t.loopAdditionalSlides,e.loopedSlides>r.length&&(e.loopedSlides=r.length);var s=[],l=[];r.each((function(t,a){var n=$(a);t<e.loopedSlides&&l.push(a),t<r.length&&t>=r.length-e.loopedSlides&&s.push(a),n.attr("data-swiper-slide-index",t)}));for(var p=0;p<l.length;p+=1)a.append($(l[p].cloneNode(!0)).addClass(t.slideDuplicateClass));for(var c=s.length-1;c>=0;c-=1)a.prepend($(s[c].cloneNode(!0)).addClass(t.slideDuplicateClass))}function loopFix(){this.emit("beforeLoopFix");var e,t=this.activeIndex,a=this.slides,r=this.loopedSlides,n=this.allowSlidePrev,i=this.allowSlideNext,o=this.snapGrid,s=this.rtlTranslate;this.allowSlidePrev=!0,this.allowSlideNext=!0;var l=-o[t]-this.getTranslate();if(t<r)e=a.length-3*r+t,e+=r,this.slideTo(e,0,!1,!0)&&0!==l&&this.setTranslate((s?-this.translate:this.translate)-l);else if(t>=a.length-r){e=-a.length+t+r,e+=r,this.slideTo(e,0,!1,!0)&&0!==l&&this.setTranslate((s?-this.translate:this.translate)-l)}this.allowSlidePrev=n,this.allowSlideNext=i,this.emit("loopFix")}function loopDestroy(){var e=this.$wrapperEl,t=this.params,a=this.slides;e.children("."+t.slideClass+"."+t.slideDuplicateClass+",."+t.slideClass+"."+t.slideBlankClass).remove(),a.removeAttr("data-swiper-slide-index")}var loop={loopCreate:loopCreate,loopFix:loopFix,loopDestroy:loopDestroy};function setGrabCursor(e){if(!(Support.touch||!this.params.simulateTouch||this.params.watchOverflow&&this.isLocked||this.params.cssMode)){var t=this.el;t.style.cursor="move",t.style.cursor=e?"-webkit-grabbing":"-webkit-grab",t.style.cursor=e?"-moz-grabbin":"-moz-grab",t.style.cursor=e?"grabbing":"grab"}}function unsetGrabCursor(){Support.touch||this.params.watchOverflow&&this.isLocked||this.params.cssMode||(this.el.style.cursor="")}var grabCursor={setGrabCursor:setGrabCursor,unsetGrabCursor:unsetGrabCursor};function appendSlide(e){var t=this.$wrapperEl,a=this.params;if(a.loop&&this.loopDestroy(),"object"==typeof e&&"length"in e)for(var r=0;r<e.length;r+=1)e[r]&&t.append(e[r]);else t.append(e);a.loop&&this.loopCreate(),a.observer&&Support.observer||this.update()}function prependSlide(e){var t=this.params,a=this.$wrapperEl,r=this.activeIndex;t.loop&&this.loopDestroy();var n=r+1;if("object"==typeof e&&"length"in e){for(var i=0;i<e.length;i+=1)e[i]&&a.prepend(e[i]);n=r+e.length}else a.prepend(e);t.loop&&this.loopCreate(),t.observer&&Support.observer||this.update(),this.slideTo(n,0,!1)}function addSlide(e,t){var a=this.$wrapperEl,r=this.params,n=this.activeIndex;r.loop&&(n-=this.loopedSlides,this.loopDestroy(),this.slides=a.children("."+r.slideClass));var i=this.slides.length;if(e<=0)this.prependSlide(t);else if(e>=i)this.appendSlide(t);else{for(var o=n>e?n+1:n,s=[],l=i-1;l>=e;l-=1){var p=this.slides.eq(l);p.remove(),s.unshift(p)}if("object"==typeof t&&"length"in t){for(var c=0;c<t.length;c+=1)t[c]&&a.append(t[c]);o=n>e?n+t.length:n}else a.append(t);for(var d=0;d<s.length;d+=1)a.append(s[d]);r.loop&&this.loopCreate(),r.observer&&Support.observer||this.update(),r.loop?this.slideTo(o+this.loopedSlides,0,!1):this.slideTo(o,0,!1)}}function removeSlide(e){var t=this.params,a=this.$wrapperEl,r=this.activeIndex;t.loop&&(r-=this.loopedSlides,this.loopDestroy(),this.slides=a.children("."+t.slideClass));var n,i=r;if("object"==typeof e&&"length"in e){for(var o=0;o<e.length;o+=1)n=e[o],this.slides[n]&&this.slides.eq(n).remove(),n<i&&(i-=1);i=Math.max(i,0)}else n=e,this.slides[n]&&this.slides.eq(n).remove(),n<i&&(i-=1),i=Math.max(i,0);t.loop&&this.loopCreate(),t.observer&&Support.observer||this.update(),t.loop?this.slideTo(i+this.loopedSlides,0,!1):this.slideTo(i,0,!1)}function removeAllSlides(){for(var e=[],t=0;t<this.slides.length;t+=1)e.push(t);this.removeSlide(e)}var manipulation={appendSlide:appendSlide,prependSlide:prependSlide,addSlide:addSlide,removeSlide:removeSlide,removeAllSlides:removeAllSlides};function onTouchStart(e){var t=this.touchEventsData,a=this.params,r=this.touches;if(!this.animating||!a.preventInteractionOnTransition){var n=e;n.originalEvent&&(n=n.originalEvent);var i=$(n.target);if(("wrapper"!==a.touchEventsTarget||i.closest(this.wrapperEl).length)&&(t.isTouchEvent="touchstart"===n.type,(t.isTouchEvent||!("which"in n)||3!==n.which)&&!(!t.isTouchEvent&&"button"in n&&n.button>0||t.isTouched&&t.isMoved)))if(a.noSwiping&&i.closest(a.noSwipingSelector?a.noSwipingSelector:"."+a.noSwipingClass)[0])this.allowClick=!0;else if(!a.swipeHandler||i.closest(a.swipeHandler)[0]){r.currentX="touchstart"===n.type?n.targetTouches[0].pageX:n.pageX,r.currentY="touchstart"===n.type?n.targetTouches[0].pageY:n.pageY;var o=r.currentX,s=r.currentY,l=a.edgeSwipeDetection||a.iOSEdgeSwipeDetection,p=a.edgeSwipeThreshold||a.iOSEdgeSwipeThreshold;if(!l||!(o<=p||o>=win.screen.width-p)){if(Utils.extend(t,{isTouched:!0,isMoved:!1,allowTouchCallbacks:!0,isScrolling:void 0,startMoving:void 0}),r.startX=o,r.startY=s,t.touchStartTime=Utils.now(),this.allowClick=!0,this.updateSize(),this.swipeDirection=void 0,a.threshold>0&&(t.allowThresholdMove=!1),"touchstart"!==n.type){var c=!0;i.is(t.formElements)&&(c=!1),doc.activeElement&&$(doc.activeElement).is(t.formElements)&&doc.activeElement!==i[0]&&doc.activeElement.blur();var d=c&&this.allowTouchMove&&a.touchStartPreventDefault;(a.touchStartForcePreventDefault||d)&&n.preventDefault()}this.emit("touchStart",n)}}}}function onTouchMove(e){var t=this.touchEventsData,a=this.params,r=this.touches,n=this.rtlTranslate,i=e;if(i.originalEvent&&(i=i.originalEvent),t.isTouched){if(!t.isTouchEvent||"mousemove"!==i.type){var o="touchmove"===i.type&&i.targetTouches&&(i.targetTouches[0]||i.changedTouches[0]),s="touchmove"===i.type?o.pageX:i.pageX,l="touchmove"===i.type?o.pageY:i.pageY;if(i.preventedByNestedSwiper)return r.startX=s,void(r.startY=l);if(!this.allowTouchMove)return this.allowClick=!1,void(t.isTouched&&(Utils.extend(r,{startX:s,startY:l,currentX:s,currentY:l}),t.touchStartTime=Utils.now()));if(t.isTouchEvent&&a.touchReleaseOnEdges&&!a.loop)if(this.isVertical()){if(l<r.startY&&this.translate<=this.maxTranslate()||l>r.startY&&this.translate>=this.minTranslate())return t.isTouched=!1,void(t.isMoved=!1)}else if(s<r.startX&&this.translate<=this.maxTranslate()||s>r.startX&&this.translate>=this.minTranslate())return;if(t.isTouchEvent&&doc.activeElement&&i.target===doc.activeElement&&$(i.target).is(t.formElements))return t.isMoved=!0,void(this.allowClick=!1);if(t.allowTouchCallbacks&&this.emit("touchMove",i),!(i.targetTouches&&i.targetTouches.length>1)){r.currentX=s,r.currentY=l;var p=r.currentX-r.startX,c=r.currentY-r.startY;if(!(this.params.threshold&&Math.sqrt(Math.pow(p,2)+Math.pow(c,2))<this.params.threshold)){var d;if(void 0===t.isScrolling)this.isHorizontal()&&r.currentY===r.startY||this.isVertical()&&r.currentX===r.startX?t.isScrolling=!1:p*p+c*c>=25&&(d=180*Math.atan2(Math.abs(c),Math.abs(p))/Math.PI,t.isScrolling=this.isHorizontal()?d>a.touchAngle:90-d>a.touchAngle);if(t.isScrolling&&this.emit("touchMoveOpposite",i),void 0===t.startMoving&&(r.currentX===r.startX&&r.currentY===r.startY||(t.startMoving=!0)),t.isScrolling)t.isTouched=!1;else if(t.startMoving){this.allowClick=!1,a.cssMode||i.preventDefault(),a.touchMoveStopPropagation&&!a.nested&&i.stopPropagation(),t.isMoved||(a.loop&&this.loopFix(),t.startTranslate=this.getTranslate(),this.setTransition(0),this.animating&&this.$wrapperEl.trigger("webkitTransitionEnd transitionend"),t.allowMomentumBounce=!1,!a.grabCursor||!0!==this.allowSlideNext&&!0!==this.allowSlidePrev||this.setGrabCursor(!0),this.emit("sliderFirstMove",i)),this.emit("sliderMove",i),t.isMoved=!0;var u=this.isHorizontal()?p:c;r.diff=u,u*=a.touchRatio,n&&(u=-u),this.swipeDirection=u>0?"prev":"next",t.currentTranslate=u+t.startTranslate;var h=!0,f=a.resistanceRatio;if(a.touchReleaseOnEdges&&(f=0),u>0&&t.currentTranslate>this.minTranslate()?(h=!1,a.resistance&&(t.currentTranslate=this.minTranslate()-1+Math.pow(-this.minTranslate()+t.startTranslate+u,f))):u<0&&t.currentTranslate<this.maxTranslate()&&(h=!1,a.resistance&&(t.currentTranslate=this.maxTranslate()+1-Math.pow(this.maxTranslate()-t.startTranslate-u,f))),h&&(i.preventedByNestedSwiper=!0),!this.allowSlideNext&&"next"===this.swipeDirection&&t.currentTranslate<t.startTranslate&&(t.currentTranslate=t.startTranslate),!this.allowSlidePrev&&"prev"===this.swipeDirection&&t.currentTranslate>t.startTranslate&&(t.currentTranslate=t.startTranslate),a.threshold>0){if(!(Math.abs(u)>a.threshold||t.allowThresholdMove))return void(t.currentTranslate=t.startTranslate);if(!t.allowThresholdMove)return t.allowThresholdMove=!0,r.startX=r.currentX,r.startY=r.currentY,t.currentTranslate=t.startTranslate,void(r.diff=this.isHorizontal()?r.currentX-r.startX:r.currentY-r.startY)}a.followFinger&&!a.cssMode&&((a.freeMode||a.watchSlidesProgress||a.watchSlidesVisibility)&&(this.updateActiveIndex(),this.updateSlidesClasses()),a.freeMode&&(0===t.velocities.length&&t.velocities.push({position:r[this.isHorizontal()?"startX":"startY"],time:t.touchStartTime}),t.velocities.push({position:r[this.isHorizontal()?"currentX":"currentY"],time:Utils.now()})),this.updateProgress(t.currentTranslate),this.setTranslate(t.currentTranslate))}}}}}else t.startMoving&&t.isScrolling&&this.emit("touchMoveOpposite",i)}function onTouchEnd(e){var t=this,a=t.touchEventsData,r=t.params,n=t.touches,i=t.rtlTranslate,o=t.$wrapperEl,s=t.slidesGrid,l=t.snapGrid,p=e;if(p.originalEvent&&(p=p.originalEvent),a.allowTouchCallbacks&&t.emit("touchEnd",p),a.allowTouchCallbacks=!1,!a.isTouched)return a.isMoved&&r.grabCursor&&t.setGrabCursor(!1),a.isMoved=!1,void(a.startMoving=!1);r.grabCursor&&a.isMoved&&a.isTouched&&(!0===t.allowSlideNext||!0===t.allowSlidePrev)&&t.setGrabCursor(!1);var c,d=Utils.now(),u=d-a.touchStartTime;if(t.allowClick&&(t.updateClickedSlide(p),t.emit("tap click",p),u<300&&d-a.lastClickTime<300&&t.emit("doubleTap doubleClick",p)),a.lastClickTime=Utils.now(),Utils.nextTick((function(){t.destroyed||(t.allowClick=!0)})),!a.isTouched||!a.isMoved||!t.swipeDirection||0===n.diff||a.currentTranslate===a.startTranslate)return a.isTouched=!1,a.isMoved=!1,void(a.startMoving=!1);if(a.isTouched=!1,a.isMoved=!1,a.startMoving=!1,c=r.followFinger?i?t.translate:-t.translate:-a.currentTranslate,!r.cssMode)if(r.freeMode){if(c<-t.minTranslate())return void t.slideTo(t.activeIndex);if(c>-t.maxTranslate())return void(t.slides.length<l.length?t.slideTo(l.length-1):t.slideTo(t.slides.length-1));if(r.freeModeMomentum){if(a.velocities.length>1){var h=a.velocities.pop(),f=a.velocities.pop(),m=h.position-f.position,v=h.time-f.time;t.velocity=m/v,t.velocity/=2,Math.abs(t.velocity)<r.freeModeMinimumVelocity&&(t.velocity=0),(v>150||Utils.now()-h.time>300)&&(t.velocity=0)}else t.velocity=0;t.velocity*=r.freeModeMomentumVelocityRatio,a.velocities.length=0;var g=1e3*r.freeModeMomentumRatio,b=t.velocity*g,y=t.translate+b;i&&(y=-y);var w,C,x=!1,$=20*Math.abs(t.velocity)*r.freeModeMomentumBounceRatio;if(y<t.maxTranslate())r.freeModeMomentumBounce?(y+t.maxTranslate()<-$&&(y=t.maxTranslate()-$),w=t.maxTranslate(),x=!0,a.allowMomentumBounce=!0):y=t.maxTranslate(),r.loop&&r.centeredSlides&&(C=!0);else if(y>t.minTranslate())r.freeModeMomentumBounce?(y-t.minTranslate()>$&&(y=t.minTranslate()+$),w=t.minTranslate(),x=!0,a.allowMomentumBounce=!0):y=t.minTranslate(),r.loop&&r.centeredSlides&&(C=!0);else if(r.freeModeSticky){for(var k,E=0;E<l.length;E+=1)if(l[E]>-y){k=E;break}y=-(y=Math.abs(l[k]-y)<Math.abs(l[k-1]-y)||"next"===t.swipeDirection?l[k]:l[k-1])}if(C&&t.once("transitionEnd",(function(){t.loopFix()})),0!==t.velocity){if(g=i?Math.abs((-y-t.translate)/t.velocity):Math.abs((y-t.translate)/t.velocity),r.freeModeSticky){var T=Math.abs((i?-y:y)-t.translate),S=t.slidesSizesGrid[t.activeIndex];g=T<S?r.speed:T<2*S?1.5*r.speed:2.5*r.speed}}else if(r.freeModeSticky)return void t.slideToClosest();r.freeModeMomentumBounce&&x?(t.updateProgress(w),t.setTransition(g),t.setTranslate(y),t.transitionStart(!0,t.swipeDirection),t.animating=!0,o.transitionEnd((function(){t&&!t.destroyed&&a.allowMomentumBounce&&(t.emit("momentumBounce"),t.setTransition(r.speed),t.setTranslate(w),o.transitionEnd((function(){t&&!t.destroyed&&t.transitionEnd()})))}))):t.velocity?(t.updateProgress(y),t.setTransition(g),t.setTranslate(y),t.transitionStart(!0,t.swipeDirection),t.animating||(t.animating=!0,o.transitionEnd((function(){t&&!t.destroyed&&t.transitionEnd()})))):t.updateProgress(y),t.updateActiveIndex(),t.updateSlidesClasses()}else if(r.freeModeSticky)return void t.slideToClosest();(!r.freeModeMomentum||u>=r.longSwipesMs)&&(t.updateProgress(),t.updateActiveIndex(),t.updateSlidesClasses())}else{for(var M=0,P=t.slidesSizesGrid[0],O=0;O<s.length;O+=O<r.slidesPerGroupSkip?1:r.slidesPerGroup){var D=O<r.slidesPerGroupSkip-1?1:r.slidesPerGroup;void 0!==s[O+D]?c>=s[O]&&c<s[O+D]&&(M=O,P=s[O+D]-s[O]):c>=s[O]&&(M=O,P=s[s.length-1]-s[s.length-2])}var I=(c-s[M])/P,B=M<r.slidesPerGroupSkip-1?1:r.slidesPerGroup;if(u>r.longSwipesMs){if(!r.longSwipes)return void t.slideTo(t.activeIndex);"next"===t.swipeDirection&&(I>=r.longSwipesRatio?t.slideTo(M+B):t.slideTo(M)),"prev"===t.swipeDirection&&(I>1-r.longSwipesRatio?t.slideTo(M+B):t.slideTo(M))}else{if(!r.shortSwipes)return void t.slideTo(t.activeIndex);t.navigation&&(p.target===t.navigation.nextEl||p.target===t.navigation.prevEl)?p.target===t.navigation.nextEl?t.slideTo(M+B):t.slideTo(M):("next"===t.swipeDirection&&t.slideTo(M+B),"prev"===t.swipeDirection&&t.slideTo(M))}}}function onResize(){var e=this.params,t=this.el;if(!t||0!==t.offsetWidth){e.breakpoints&&this.setBreakpoint();var a=this.allowSlideNext,r=this.allowSlidePrev,n=this.snapGrid;this.allowSlideNext=!0,this.allowSlidePrev=!0,this.updateSize(),this.updateSlides(),this.updateSlidesClasses(),("auto"===e.slidesPerView||e.slidesPerView>1)&&this.isEnd&&!this.params.centeredSlides?this.slideTo(this.slides.length-1,0,!1,!0):this.slideTo(this.activeIndex,0,!1,!0),this.autoplay&&this.autoplay.running&&this.autoplay.paused&&this.autoplay.run(),this.allowSlidePrev=r,this.allowSlideNext=a,this.params.watchOverflow&&n!==this.snapGrid&&this.checkOverflow()}}function onClick(e){this.allowClick||(this.params.preventClicks&&e.preventDefault(),this.params.preventClicksPropagation&&this.animating&&(e.stopPropagation(),e.stopImmediatePropagation()))}function onScroll(){var e=this.wrapperEl;this.previousTranslate=this.translate,this.translate=this.isHorizontal()?-e.scrollLeft:-e.scrollTop,-0===this.translate&&(this.translate=0),this.updateActiveIndex(),this.updateSlidesClasses();var t=this.maxTranslate()-this.minTranslate();(0===t?0:(this.translate-this.minTranslate())/t)!==this.progress&&this.updateProgress(this.translate),this.emit("setTranslate",this.translate,!1)}var dummyEventAttached=!1;function dummyEventListener(){}function attachEvents(){var e=this.params,t=this.touchEvents,a=this.el,r=this.wrapperEl;this.onTouchStart=onTouchStart.bind(this),this.onTouchMove=onTouchMove.bind(this),this.onTouchEnd=onTouchEnd.bind(this),e.cssMode&&(this.onScroll=onScroll.bind(this)),this.onClick=onClick.bind(this);var n=!!e.nested;if(!Support.touch&&Support.pointerEvents)a.addEventListener(t.start,this.onTouchStart,!1),doc.addEventListener(t.move,this.onTouchMove,n),doc.addEventListener(t.end,this.onTouchEnd,!1);else{if(Support.touch){var i=!("touchstart"!==t.start||!Support.passiveListener||!e.passiveListeners)&&{passive:!0,capture:!1};a.addEventListener(t.start,this.onTouchStart,i),a.addEventListener(t.move,this.onTouchMove,Support.passiveListener?{passive:!1,capture:n}:n),a.addEventListener(t.end,this.onTouchEnd,i),t.cancel&&a.addEventListener(t.cancel,this.onTouchEnd,i),dummyEventAttached||(doc.addEventListener("touchstart",dummyEventListener),dummyEventAttached=!0)}(e.simulateTouch&&!Device.ios&&!Device.android||e.simulateTouch&&!Support.touch&&Device.ios)&&(a.addEventListener("mousedown",this.onTouchStart,!1),doc.addEventListener("mousemove",this.onTouchMove,n),doc.addEventListener("mouseup",this.onTouchEnd,!1))}(e.preventClicks||e.preventClicksPropagation)&&a.addEventListener("click",this.onClick,!0),e.cssMode&&r.addEventListener("scroll",this.onScroll),e.updateOnWindowResize?this.on(Device.ios||Device.android?"resize orientationchange observerUpdate":"resize observerUpdate",onResize,!0):this.on("observerUpdate",onResize,!0)}function detachEvents(){var e=this.params,t=this.touchEvents,a=this.el,r=this.wrapperEl,n=!!e.nested;if(!Support.touch&&Support.pointerEvents)a.removeEventListener(t.start,this.onTouchStart,!1),doc.removeEventListener(t.move,this.onTouchMove,n),doc.removeEventListener(t.end,this.onTouchEnd,!1);else{if(Support.touch){var i=!("onTouchStart"!==t.start||!Support.passiveListener||!e.passiveListeners)&&{passive:!0,capture:!1};a.removeEventListener(t.start,this.onTouchStart,i),a.removeEventListener(t.move,this.onTouchMove,n),a.removeEventListener(t.end,this.onTouchEnd,i),t.cancel&&a.removeEventListener(t.cancel,this.onTouchEnd,i)}(e.simulateTouch&&!Device.ios&&!Device.android||e.simulateTouch&&!Support.touch&&Device.ios)&&(a.removeEventListener("mousedown",this.onTouchStart,!1),doc.removeEventListener("mousemove",this.onTouchMove,n),doc.removeEventListener("mouseup",this.onTouchEnd,!1))}(e.preventClicks||e.preventClicksPropagation)&&a.removeEventListener("click",this.onClick,!0),e.cssMode&&r.removeEventListener("scroll",this.onScroll),this.off(Device.ios||Device.android?"resize orientationchange observerUpdate":"resize observerUpdate",onResize)}var events={attachEvents:attachEvents,detachEvents:detachEvents};function setBreakpoint(){var e=this.activeIndex,t=this.initialized,a=this.loopedSlides;void 0===a&&(a=0);var r=this.params,n=this.$el,i=r.breakpoints;if(i&&(!i||0!==Object.keys(i).length)){var o=this.getBreakpoint(i);if(o&&this.currentBreakpoint!==o){var s=o in i?i[o]:void 0;s&&["slidesPerView","spaceBetween","slidesPerGroup","slidesPerGroupSkip","slidesPerColumn"].forEach((function(e){var t=s[e];void 0!==t&&(s[e]="slidesPerView"!==e||"AUTO"!==t&&"auto"!==t?"slidesPerView"===e?parseFloat(t):parseInt(t,10):"auto")}));var l=s||this.originalParams,p=r.slidesPerColumn>1,c=l.slidesPerColumn>1;p&&!c?n.removeClass(r.containerModifierClass+"multirow "+r.containerModifierClass+"multirow-column"):!p&&c&&(n.addClass(r.containerModifierClass+"multirow"),"column"===l.slidesPerColumnFill&&n.addClass(r.containerModifierClass+"multirow-column"));var d=l.direction&&l.direction!==r.direction,u=r.loop&&(l.slidesPerView!==r.slidesPerView||d);d&&t&&this.changeDirection(),Utils.extend(this.params,l),Utils.extend(this,{allowTouchMove:this.params.allowTouchMove,allowSlideNext:this.params.allowSlideNext,allowSlidePrev:this.params.allowSlidePrev}),this.currentBreakpoint=o,u&&t&&(this.loopDestroy(),this.loopCreate(),this.updateSlides(),this.slideTo(e-a+this.loopedSlides,0,!1)),this.emit("breakpoint",l)}}}function getBreakpoint(e){if(e){var t=!1,a=Object.keys(e).map((function(e){if("string"==typeof e&&0===e.indexOf("@")){var t=parseFloat(e.substr(1));return{value:win.innerHeight*t,point:e}}return{value:e,point:e}}));a.sort((function(e,t){return parseInt(e.value,10)-parseInt(t.value,10)}));for(var r=0;r<a.length;r+=1){var n=a[r],i=n.point;n.value<=win.innerWidth&&(t=i)}return t||"max"}}var breakpoints={setBreakpoint:setBreakpoint,getBreakpoint:getBreakpoint};function addClasses(){var e=this.classNames,t=this.params,a=this.rtl,r=this.$el,n=[];n.push("initialized"),n.push(t.direction),t.freeMode&&n.push("free-mode"),t.autoHeight&&n.push("autoheight"),a&&n.push("rtl"),t.slidesPerColumn>1&&(n.push("multirow"),"column"===t.slidesPerColumnFill&&n.push("multirow-column")),Device.android&&n.push("android"),Device.ios&&n.push("ios"),t.cssMode&&n.push("css-mode"),n.forEach((function(a){e.push(t.containerModifierClass+a)})),r.addClass(e.join(" "))}function removeClasses(){var e=this.$el,t=this.classNames;e.removeClass(t.join(" "))}var classes={addClasses:addClasses,removeClasses:removeClasses};function loadImage(e,t,a,r,n,i){var o;function s(){i&&i()}e.complete&&n?s():t?((o=new win.Image).onload=s,o.onerror=s,r&&(o.sizes=r),a&&(o.srcset=a),t&&(o.src=t)):s()}function preloadImages(){var e=this;function t(){null!=e&&e&&!e.destroyed&&(void 0!==e.imagesLoaded&&(e.imagesLoaded+=1),e.imagesLoaded===e.imagesToLoad.length&&(e.params.updateOnImagesReady&&e.update(),e.emit("imagesReady")))}e.imagesToLoad=e.$el.find("img");for(var a=0;a<e.imagesToLoad.length;a+=1){var r=e.imagesToLoad[a];e.loadImage(r,r.currentSrc||r.getAttribute("src"),r.srcset||r.getAttribute("srcset"),r.sizes||r.getAttribute("sizes"),!0,t)}}var images={loadImage:loadImage,preloadImages:preloadImages};function checkOverflow(){var e=this.params,t=this.isLocked,a=this.slides.length>0&&e.slidesOffsetBefore+e.spaceBetween*(this.slides.length-1)+this.slides[0].offsetWidth*this.slides.length;e.slidesOffsetBefore&&e.slidesOffsetAfter&&a?this.isLocked=a<=this.size:this.isLocked=1===this.snapGrid.length,this.allowSlideNext=!this.isLocked,this.allowSlidePrev=!this.isLocked,t!==this.isLocked&&this.emit(this.isLocked?"lock":"unlock"),t&&t!==this.isLocked&&(this.isEnd=!1,this.navigation.update())}var checkOverflow$1={checkOverflow:checkOverflow},defaults={init:!0,direction:"horizontal",touchEventsTarget:"container",initialSlide:0,speed:300,cssMode:!1,updateOnWindowResize:!0,preventInteractionOnTransition:!1,edgeSwipeDetection:!1,edgeSwipeThreshold:20,freeMode:!1,freeModeMomentum:!0,freeModeMomentumRatio:1,freeModeMomentumBounce:!0,freeModeMomentumBounceRatio:1,freeModeMomentumVelocityRatio:1,freeModeSticky:!1,freeModeMinimumVelocity:.02,autoHeight:!1,setWrapperSize:!1,virtualTranslate:!1,effect:"slide",breakpoints:void 0,spaceBetween:0,slidesPerView:1,slidesPerColumn:1,slidesPerColumnFill:"column",slidesPerGroup:1,slidesPerGroupSkip:0,centeredSlides:!1,centeredSlidesBounds:!1,slidesOffsetBefore:0,slidesOffsetAfter:0,normalizeSlideIndex:!0,centerInsufficientSlides:!1,watchOverflow:!1,roundLengths:!1,touchRatio:1,touchAngle:45,simulateTouch:!0,shortSwipes:!0,longSwipes:!0,longSwipesRatio:.5,longSwipesMs:300,followFinger:!0,allowTouchMove:!0,threshold:0,touchMoveStopPropagation:!1,touchStartPreventDefault:!0,touchStartForcePreventDefault:!1,touchReleaseOnEdges:!1,uniqueNavElements:!0,resistance:!0,resistanceRatio:.85,watchSlidesProgress:!1,watchSlidesVisibility:!1,grabCursor:!1,preventClicks:!0,preventClicksPropagation:!0,slideToClickedSlide:!1,preloadImages:!0,updateOnImagesReady:!0,loop:!1,loopAdditionalSlides:0,loopedSlides:null,loopFillGroupWithBlank:!1,allowSlidePrev:!0,allowSlideNext:!0,swipeHandler:null,noSwiping:!0,noSwipingClass:"swiper-no-swiping",noSwipingSelector:null,passiveListeners:!0,containerModifierClass:"swiper-container-",slideClass:"swiper-slide",slideBlankClass:"swiper-slide-invisible-blank",slideActiveClass:"swiper-slide-active",slideDuplicateActiveClass:"swiper-slide-duplicate-active",slideVisibleClass:"swiper-slide-visible",slideDuplicateClass:"swiper-slide-duplicate",slideNextClass:"swiper-slide-next",slideDuplicateNextClass:"swiper-slide-duplicate-next",slidePrevClass:"swiper-slide-prev",slideDuplicatePrevClass:"swiper-slide-duplicate-prev",wrapperClass:"swiper-wrapper",runCallbacksOnInit:!0},prototypes={update:update,translate:translate,transition:transition$1,slide:slide,loop:loop,grabCursor:grabCursor,manipulation:manipulation,events:events,breakpoints:breakpoints,checkOverflow:checkOverflow$1,classes:classes,images:images},extendedDefaults={},Swiper=function(e){function t(){for(var a,r,n,i=[],o=arguments.length;o--;)i[o]=arguments[o];1===i.length&&i[0].constructor&&i[0].constructor===Object?n=i[0]:(r=(a=i)[0],n=a[1]),n||(n={}),n=Utils.extend({},n),r&&!n.el&&(n.el=r),e.call(this,n),Object.keys(prototypes).forEach((function(e){Object.keys(prototypes[e]).forEach((function(a){t.prototype[a]||(t.prototype[a]=prototypes[e][a])}))}));var s=this;void 0===s.modules&&(s.modules={}),Object.keys(s.modules).forEach((function(e){var t=s.modules[e];if(t.params){var a=Object.keys(t.params)[0],r=t.params[a];if("object"!=typeof r||null===r)return;if(!(a in n&&"enabled"in r))return;!0===n[a]&&(n[a]={enabled:!0}),"object"!=typeof n[a]||"enabled"in n[a]||(n[a].enabled=!0),n[a]||(n[a]={enabled:!1})}}));var l=Utils.extend({},defaults);s.useModulesParams(l),s.params=Utils.extend({},l,extendedDefaults,n),s.originalParams=Utils.extend({},s.params),s.passedParams=Utils.extend({},n),s.$=$;var p=$(s.params.el);if(r=p[0]){if(p.length>1){var c=[];return p.each((function(e,a){var r=Utils.extend({},n,{el:a});c.push(new t(r))})),c}var d,u,h;return r.swiper=s,p.data("swiper",s),r&&r.shadowRoot&&r.shadowRoot.querySelector?(d=$(r.shadowRoot.querySelector("."+s.params.wrapperClass))).children=function(e){return p.children(e)}:d=p.children("."+s.params.wrapperClass),Utils.extend(s,{$el:p,el:r,$wrapperEl:d,wrapperEl:d[0],classNames:[],slides:$(),slidesGrid:[],snapGrid:[],slidesSizesGrid:[],isHorizontal:function(){return"horizontal"===s.params.direction},isVertical:function(){return"vertical"===s.params.direction},rtl:"rtl"===r.dir.toLowerCase()||"rtl"===p.css("direction"),rtlTranslate:"horizontal"===s.params.direction&&("rtl"===r.dir.toLowerCase()||"rtl"===p.css("direction")),wrongRTL:"-webkit-box"===d.css("display"),activeIndex:0,realIndex:0,isBeginning:!0,isEnd:!1,translate:0,previousTranslate:0,progress:0,velocity:0,animating:!1,allowSlideNext:s.params.allowSlideNext,allowSlidePrev:s.params.allowSlidePrev,touchEvents:(u=["touchstart","touchmove","touchend","touchcancel"],h=["mousedown","mousemove","mouseup"],Support.pointerEvents&&(h=["pointerdown","pointermove","pointerup"]),s.touchEventsTouch={start:u[0],move:u[1],end:u[2],cancel:u[3]},s.touchEventsDesktop={start:h[0],move:h[1],end:h[2]},Support.touch||!s.params.simulateTouch?s.touchEventsTouch:s.touchEventsDesktop),touchEventsData:{isTouched:void 0,isMoved:void 0,allowTouchCallbacks:void 0,touchStartTime:void 0,isScrolling:void 0,currentTranslate:void 0,startTranslate:void 0,allowThresholdMove:void 0,formElements:"input, select, option, textarea, button, video, label",lastClickTime:Utils.now(),clickTimeout:void 0,velocities:[],allowMomentumBounce:void 0,isTouchEvent:void 0,startMoving:void 0},allowClick:!0,allowTouchMove:s.params.allowTouchMove,touches:{startX:0,startY:0,currentX:0,currentY:0,diff:0},imagesToLoad:[],imagesLoaded:0}),s.useModules(),s.params.init&&s.init(),s}}e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t;var a={extendedDefaults:{configurable:!0},defaults:{configurable:!0},Class:{configurable:!0},$:{configurable:!0}};return t.prototype.slidesPerViewDynamic=function(){var e=this.params,t=this.slides,a=this.slidesGrid,r=this.size,n=this.activeIndex,i=1;if(e.centeredSlides){for(var o,s=t[n].swiperSlideSize,l=n+1;l<t.length;l+=1)t[l]&&!o&&(i+=1,(s+=t[l].swiperSlideSize)>r&&(o=!0));for(var p=n-1;p>=0;p-=1)t[p]&&!o&&(i+=1,(s+=t[p].swiperSlideSize)>r&&(o=!0))}else for(var c=n+1;c<t.length;c+=1)a[c]-a[n]<r&&(i+=1);return i},t.prototype.update=function(){var e=this;if(e&&!e.destroyed){var t=e.snapGrid,a=e.params;a.breakpoints&&e.setBreakpoint(),e.updateSize(),e.updateSlides(),e.updateProgress(),e.updateSlidesClasses(),e.params.freeMode?(r(),e.params.autoHeight&&e.updateAutoHeight()):(("auto"===e.params.slidesPerView||e.params.slidesPerView>1)&&e.isEnd&&!e.params.centeredSlides?e.slideTo(e.slides.length-1,0,!1,!0):e.slideTo(e.activeIndex,0,!1,!0))||r(),a.watchOverflow&&t!==e.snapGrid&&e.checkOverflow(),e.emit("update")}function r(){var t=e.rtlTranslate?-1*e.translate:e.translate,a=Math.min(Math.max(t,e.maxTranslate()),e.minTranslate());e.setTranslate(a),e.updateActiveIndex(),e.updateSlidesClasses()}},t.prototype.changeDirection=function(e,t){void 0===t&&(t=!0);var a=this.params.direction;return e||(e="horizontal"===a?"vertical":"horizontal"),e===a||"horizontal"!==e&&"vertical"!==e||(this.$el.removeClass(""+this.params.containerModifierClass+a).addClass(""+this.params.containerModifierClass+e),this.params.direction=e,this.slides.each((function(t,a){"vertical"===e?a.style.width="":a.style.height=""})),this.emit("changeDirection"),t&&this.update()),this},t.prototype.init=function(){this.initialized||(this.emit("beforeInit"),this.params.breakpoints&&this.setBreakpoint(),this.addClasses(),this.params.loop&&this.loopCreate(),this.updateSize(),this.updateSlides(),this.params.watchOverflow&&this.checkOverflow(),this.params.grabCursor&&this.setGrabCursor(),this.params.preloadImages&&this.preloadImages(),this.params.loop?this.slideTo(this.params.initialSlide+this.loopedSlides,0,this.params.runCallbacksOnInit):this.slideTo(this.params.initialSlide,0,this.params.runCallbacksOnInit),this.attachEvents(),this.initialized=!0,this.emit("init"))},t.prototype.destroy=function(e,t){void 0===e&&(e=!0),void 0===t&&(t=!0);var a=this,r=a.params,n=a.$el,i=a.$wrapperEl,o=a.slides;return void 0===a.params||a.destroyed||(a.emit("beforeDestroy"),a.initialized=!1,a.detachEvents(),r.loop&&a.loopDestroy(),t&&(a.removeClasses(),n.removeAttr("style"),i.removeAttr("style"),o&&o.length&&o.removeClass([r.slideVisibleClass,r.slideActiveClass,r.slideNextClass,r.slidePrevClass].join(" ")).removeAttr("style").removeAttr("data-swiper-slide-index")),a.emit("destroy"),Object.keys(a.eventsListeners).forEach((function(e){a.off(e)})),!1!==e&&(a.$el[0].swiper=null,a.$el.data("swiper",null),Utils.deleteProps(a)),a.destroyed=!0),null},t.extendDefaults=function(e){Utils.extend(extendedDefaults,e)},a.extendedDefaults.get=function(){return extendedDefaults},a.defaults.get=function(){return defaults},a.Class.get=function(){return e},a.$.get=function(){return $},Object.defineProperties(t,a),t}(Framework7Class),Device$1={name:"device",proto:{device:Device},static:{device:Device}},Support$1={name:"support",proto:{support:Support},static:{support:Support}},Browser={isEdge:!!win.navigator.userAgent.match(/Edge/g),isSafari:(ua=win.navigator.userAgent.toLowerCase(),ua.indexOf("safari")>=0&&ua.indexOf("chrome")<0&&ua.indexOf("android")<0),isUiWebView:/(iPhone|iPod|iPad).*AppleWebKit(?!.*Safari)/i.test(win.navigator.userAgent)},ua,Browser$1={name:"browser",proto:{browser:Browser},static:{browser:Browser}},Resize={name:"resize",create:function(){var e=this;Utils.extend(e,{resize:{resizeHandler:function(){e&&!e.destroyed&&e.initialized&&(e.emit("beforeResize"),e.emit("resize"))},orientationChangeHandler:function(){e&&!e.destroyed&&e.initialized&&e.emit("orientationchange")}}})},on:{init:function(){win.addEventListener("resize",this.resize.resizeHandler),win.addEventListener("orientationchange",this.resize.orientationChangeHandler)},destroy:function(){win.removeEventListener("resize",this.resize.resizeHandler),win.removeEventListener("orientationchange",this.resize.orientationChangeHandler)}}},Observer={func:win.MutationObserver||win.WebkitMutationObserver,attach:function(e,t){void 0===t&&(t={});var a=this,r=new(0,Observer.func)((function(e){if(1!==e.length){var t=function(){a.emit("observerUpdate",e[0])};win.requestAnimationFrame?win.requestAnimationFrame(t):win.setTimeout(t,0)}else a.emit("observerUpdate",e[0])}));r.observe(e,{attributes:void 0===t.attributes||t.attributes,childList:void 0===t.childList||t.childList,characterData:void 0===t.characterData||t.characterData}),a.observer.observers.push(r)},init:function(){if(Support.observer&&this.params.observer){if(this.params.observeParents)for(var e=this.$el.parents(),t=0;t<e.length;t+=1)this.observer.attach(e[t]);this.observer.attach(this.$el[0],{childList:this.params.observeSlideChildren}),this.observer.attach(this.$wrapperEl[0],{attributes:!1})}},destroy:function(){this.observer.observers.forEach((function(e){e.disconnect()})),this.observer.observers=[]}},Observer$1={name:"observer",params:{observer:!1,observeParents:!1,observeSlideChildren:!1},create:function(){Utils.extend(this,{observer:{init:Observer.init.bind(this),attach:Observer.attach.bind(this),destroy:Observer.destroy.bind(this),observers:[]}})},on:{init:function(){this.observer.init()},destroy:function(){this.observer.destroy()}}},Virtual={update:function(e){var t=this,a=t.params,r=a.slidesPerView,n=a.slidesPerGroup,i=a.centeredSlides,o=t.params.virtual,s=o.addSlidesBefore,l=o.addSlidesAfter,p=t.virtual,c=p.from,d=p.to,u=p.slides,h=p.slidesGrid,f=p.renderSlide,m=p.offset;t.updateActiveIndex();var v,g,b,y=t.activeIndex||0;v=t.rtlTranslate?"right":t.isHorizontal()?"left":"top",i?(g=Math.floor(r/2)+n+s,b=Math.floor(r/2)+n+l):(g=r+(n-1)+s,b=n+l);var w=Math.max((y||0)-b,0),C=Math.min((y||0)+g,u.length-1),x=(t.slidesGrid[w]||0)-(t.slidesGrid[0]||0);function $(){t.updateSlides(),t.updateProgress(),t.updateSlidesClasses(),t.lazy&&t.params.lazy.enabled&&t.lazy.load()}if(Utils.extend(t.virtual,{from:w,to:C,offset:x,slidesGrid:t.slidesGrid}),c===w&&d===C&&!e)return t.slidesGrid!==h&&x!==m&&t.slides.css(v,x+"px"),void t.updateProgress();if(t.params.virtual.renderExternal)return t.params.virtual.renderExternal.call(t,{offset:x,from:w,to:C,slides:function(){for(var e=[],t=w;t<=C;t+=1)e.push(u[t]);return e}()}),void $();var k=[],E=[];if(e)t.$wrapperEl.find("."+t.params.slideClass).remove();else for(var T=c;T<=d;T+=1)(T<w||T>C)&&t.$wrapperEl.find("."+t.params.slideClass+'[data-swiper-slide-index="'+T+'"]').remove();for(var S=0;S<u.length;S+=1)S>=w&&S<=C&&(void 0===d||e?E.push(S):(S>d&&E.push(S),S<c&&k.push(S)));E.forEach((function(e){t.$wrapperEl.append(f(u[e],e))})),k.sort((function(e,t){return t-e})).forEach((function(e){t.$wrapperEl.prepend(f(u[e],e))})),t.$wrapperEl.children(".swiper-slide").css(v,x+"px"),$()},renderSlide:function(e,t){var a=this.params.virtual;if(a.cache&&this.virtual.cache[t])return this.virtual.cache[t];var r=a.renderSlide?$(a.renderSlide.call(this,e,t)):$('<div class="'+this.params.slideClass+'" data-swiper-slide-index="'+t+'">'+e+"</div>");return r.attr("data-swiper-slide-index")||r.attr("data-swiper-slide-index",t),a.cache&&(this.virtual.cache[t]=r),r},appendSlide:function(e){if("object"==typeof e&&"length"in e)for(var t=0;t<e.length;t+=1)e[t]&&this.virtual.slides.push(e[t]);else this.virtual.slides.push(e);this.virtual.update(!0)},prependSlide:function(e){var t=this.activeIndex,a=t+1,r=1;if(Array.isArray(e)){for(var n=0;n<e.length;n+=1)e[n]&&this.virtual.slides.unshift(e[n]);a=t+e.length,r=e.length}else this.virtual.slides.unshift(e);if(this.params.virtual.cache){var i=this.virtual.cache,o={};Object.keys(i).forEach((function(e){var t=i[e],a=t.attr("data-swiper-slide-index");a&&t.attr("data-swiper-slide-index",parseInt(a,10)+1),o[parseInt(e,10)+r]=t})),this.virtual.cache=o}this.virtual.update(!0),this.slideTo(a,0)},removeSlide:function(e){if(null!=e){var t=this.activeIndex;if(Array.isArray(e))for(var a=e.length-1;a>=0;a-=1)this.virtual.slides.splice(e[a],1),this.params.virtual.cache&&delete this.virtual.cache[e[a]],e[a]<t&&(t-=1),t=Math.max(t,0);else this.virtual.slides.splice(e,1),this.params.virtual.cache&&delete this.virtual.cache[e],e<t&&(t-=1),t=Math.max(t,0);this.virtual.update(!0),this.slideTo(t,0)}},removeAllSlides:function(){this.virtual.slides=[],this.params.virtual.cache&&(this.virtual.cache={}),this.virtual.update(!0),this.slideTo(0,0)}},Virtual$1={name:"virtual",params:{virtual:{enabled:!1,slides:[],cache:!0,renderSlide:null,renderExternal:null,addSlidesBefore:0,addSlidesAfter:0}},create:function(){Utils.extend(this,{virtual:{update:Virtual.update.bind(this),appendSlide:Virtual.appendSlide.bind(this),prependSlide:Virtual.prependSlide.bind(this),removeSlide:Virtual.removeSlide.bind(this),removeAllSlides:Virtual.removeAllSlides.bind(this),renderSlide:Virtual.renderSlide.bind(this),slides:this.params.virtual.slides,cache:{}}})},on:{beforeInit:function(){if(this.params.virtual.enabled){this.classNames.push(this.params.containerModifierClass+"virtual");var e={watchSlidesProgress:!0};Utils.extend(this.params,e),Utils.extend(this.originalParams,e),this.params.initialSlide||this.virtual.update()}},setTranslate:function(){this.params.virtual.enabled&&this.virtual.update()}}},Keyboard={handle:function(e){var t=this.rtlTranslate,a=e;a.originalEvent&&(a=a.originalEvent);var r=a.keyCode||a.charCode;if(!this.allowSlideNext&&(this.isHorizontal()&&39===r||this.isVertical()&&40===r||34===r))return!1;if(!this.allowSlidePrev&&(this.isHorizontal()&&37===r||this.isVertical()&&38===r||33===r))return!1;if(!(a.shiftKey||a.altKey||a.ctrlKey||a.metaKey||doc.activeElement&&doc.activeElement.nodeName&&("input"===doc.activeElement.nodeName.toLowerCase()||"textarea"===doc.activeElement.nodeName.toLowerCase()))){if(this.params.keyboard.onlyInViewport&&(33===r||34===r||37===r||39===r||38===r||40===r)){var n=!1;if(this.$el.parents("."+this.params.slideClass).length>0&&0===this.$el.parents("."+this.params.slideActiveClass).length)return;var i=win.innerWidth,o=win.innerHeight,s=this.$el.offset();t&&(s.left-=this.$el[0].scrollLeft);for(var l=[[s.left,s.top],[s.left+this.width,s.top],[s.left,s.top+this.height],[s.left+this.width,s.top+this.height]],p=0;p<l.length;p+=1){var c=l[p];c[0]>=0&&c[0]<=i&&c[1]>=0&&c[1]<=o&&(n=!0)}if(!n)return}this.isHorizontal()?(33!==r&&34!==r&&37!==r&&39!==r||(a.preventDefault?a.preventDefault():a.returnValue=!1),(34!==r&&39!==r||t)&&(33!==r&&37!==r||!t)||this.slideNext(),(33!==r&&37!==r||t)&&(34!==r&&39!==r||!t)||this.slidePrev()):(33!==r&&34!==r&&38!==r&&40!==r||(a.preventDefault?a.preventDefault():a.returnValue=!1),34!==r&&40!==r||this.slideNext(),33!==r&&38!==r||this.slidePrev()),this.emit("keyPress",r)}},enable:function(){this.keyboard.enabled||($(doc).on("keydown",this.keyboard.handle),this.keyboard.enabled=!0)},disable:function(){this.keyboard.enabled&&($(doc).off("keydown",this.keyboard.handle),this.keyboard.enabled=!1)}},Keyboard$1={name:"keyboard",params:{keyboard:{enabled:!1,onlyInViewport:!0}},create:function(){Utils.extend(this,{keyboard:{enabled:!1,enable:Keyboard.enable.bind(this),disable:Keyboard.disable.bind(this),handle:Keyboard.handle.bind(this)}})},on:{init:function(){this.params.keyboard.enabled&&this.keyboard.enable()},destroy:function(){this.keyboard.enabled&&this.keyboard.disable()}}};function isEventSupported(){var e="onwheel"in doc;if(!e){var t=doc.createElement("div");t.setAttribute("onwheel","return;"),e="function"==typeof t.onwheel}return!e&&doc.implementation&&doc.implementation.hasFeature&&!0!==doc.implementation.hasFeature("","")&&(e=doc.implementation.hasFeature("Events.wheel","3.0")),e}var Mousewheel={lastScrollTime:Utils.now(),lastEventBeforeSnap:void 0,recentWheelEvents:[],event:function(){return win.navigator.userAgent.indexOf("firefox")>-1?"DOMMouseScroll":isEventSupported()?"wheel":"mousewheel"},normalize:function(e){var t=0,a=0,r=0,n=0;return"detail"in e&&(a=e.detail),"wheelDelta"in e&&(a=-e.wheelDelta/120),"wheelDeltaY"in e&&(a=-e.wheelDeltaY/120),"wheelDeltaX"in e&&(t=-e.wheelDeltaX/120),"axis"in e&&e.axis===e.HORIZONTAL_AXIS&&(t=a,a=0),r=10*t,n=10*a,"deltaY"in e&&(n=e.deltaY),"deltaX"in e&&(r=e.deltaX),e.shiftKey&&!r&&(r=n,n=0),(r||n)&&e.deltaMode&&(1===e.deltaMode?(r*=40,n*=40):(r*=800,n*=800)),r&&!t&&(t=r<1?-1:1),n&&!a&&(a=n<1?-1:1),{spinX:t,spinY:a,pixelX:r,pixelY:n}},handleMouseEnter:function(){this.mouseEntered=!0},handleMouseLeave:function(){this.mouseEntered=!1},handle:function(e){var t=e,a=this,r=a.params.mousewheel;a.params.cssMode&&t.preventDefault();var n=a.$el;if("container"!==a.params.mousewheel.eventsTarged&&(n=$(a.params.mousewheel.eventsTarged)),!a.mouseEntered&&!n[0].contains(t.target)&&!r.releaseOnEdges)return!0;t.originalEvent&&(t=t.originalEvent);var i=0,o=a.rtlTranslate?-1:1,s=Mousewheel.normalize(t);if(r.forceToAxis)if(a.isHorizontal()){if(!(Math.abs(s.pixelX)>Math.abs(s.pixelY)))return!0;i=s.pixelX*o}else{if(!(Math.abs(s.pixelY)>Math.abs(s.pixelX)))return!0;i=s.pixelY}else i=Math.abs(s.pixelX)>Math.abs(s.pixelY)?-s.pixelX*o:-s.pixelY;if(0===i)return!0;if(r.invert&&(i=-i),a.params.freeMode){var l={time:Utils.now(),delta:Math.abs(i),direction:Math.sign(i)},p=a.mousewheel.lastEventBeforeSnap,c=p&&l.time<p.time+500&&l.delta<=p.delta&&l.direction===p.direction;if(!c){a.mousewheel.lastEventBeforeSnap=void 0,a.params.loop&&a.loopFix();var d=a.getTranslate()+i*r.sensitivity,u=a.isBeginning,h=a.isEnd;if(d>=a.minTranslate()&&(d=a.minTranslate()),d<=a.maxTranslate()&&(d=a.maxTranslate()),a.setTransition(0),a.setTranslate(d),a.updateProgress(),a.updateActiveIndex(),a.updateSlidesClasses(),(!u&&a.isBeginning||!h&&a.isEnd)&&a.updateSlidesClasses(),a.params.freeModeSticky){clearTimeout(a.mousewheel.timeout),a.mousewheel.timeout=void 0;var f=a.mousewheel.recentWheelEvents;f.length>=15&&f.shift();var m=f.length?f[f.length-1]:void 0,v=f[0];if(f.push(l),m&&(l.delta>m.delta||l.direction!==m.direction))f.splice(0);else if(f.length>=15&&l.time-v.time<500&&v.delta-l.delta>=1&&l.delta<=6){var g=i>0?.8:.2;a.mousewheel.lastEventBeforeSnap=l,f.splice(0),a.mousewheel.timeout=Utils.nextTick((function(){a.slideToClosest(a.params.speed,!0,void 0,g)}),0)}a.mousewheel.timeout||(a.mousewheel.timeout=Utils.nextTick((function(){a.mousewheel.lastEventBeforeSnap=l,f.splice(0),a.slideToClosest(a.params.speed,!0,void 0,.5)}),500))}if(c||a.emit("scroll",t),a.params.autoplay&&a.params.autoplayDisableOnInteraction&&a.autoplay.stop(),d===a.minTranslate()||d===a.maxTranslate())return!0}}else{var b={time:Utils.now(),delta:Math.abs(i),direction:Math.sign(i),raw:e},y=a.mousewheel.recentWheelEvents;y.length>=2&&y.shift();var w=y.length?y[y.length-1]:void 0;if(y.push(b),w?(b.direction!==w.direction||b.delta>w.delta)&&a.mousewheel.animateSlider(b):a.mousewheel.animateSlider(b),a.mousewheel.releaseScroll(b))return!0}return t.preventDefault?t.preventDefault():t.returnValue=!1,!1},animateSlider:function(e){return e.delta>=6&&Utils.now()-this.mousewheel.lastScrollTime<60||(e.direction<0?this.isEnd&&!this.params.loop||this.animating||(this.slideNext(),this.emit("scroll",e.raw)):this.isBeginning&&!this.params.loop||this.animating||(this.slidePrev(),this.emit("scroll",e.raw)),this.mousewheel.lastScrollTime=(new win.Date).getTime(),!1)},releaseScroll:function(e){var t=this.params.mousewheel;if(e.direction<0){if(this.isEnd&&!this.params.loop&&t.releaseOnEdges)return!0}else if(this.isBeginning&&!this.params.loop&&t.releaseOnEdges)return!0;return!1},enable:function(){var e=Mousewheel.event();if(this.params.cssMode)return this.wrapperEl.removeEventListener(e,this.mousewheel.handle),!0;if(!e)return!1;if(this.mousewheel.enabled)return!1;var t=this.$el;return"container"!==this.params.mousewheel.eventsTarged&&(t=$(this.params.mousewheel.eventsTarged)),t.on("mouseenter",this.mousewheel.handleMouseEnter),t.on("mouseleave",this.mousewheel.handleMouseLeave),t.on(e,this.mousewheel.handle),this.mousewheel.enabled=!0,!0},disable:function(){var e=Mousewheel.event();if(this.params.cssMode)return this.wrapperEl.addEventListener(e,this.mousewheel.handle),!0;if(!e)return!1;if(!this.mousewheel.enabled)return!1;var t=this.$el;return"container"!==this.params.mousewheel.eventsTarged&&(t=$(this.params.mousewheel.eventsTarged)),t.off(e,this.mousewheel.handle),this.mousewheel.enabled=!1,!0}},Mousewheel$1={name:"mousewheel",params:{mousewheel:{enabled:!1,releaseOnEdges:!1,invert:!1,forceToAxis:!1,sensitivity:1,eventsTarged:"container"}},create:function(){Utils.extend(this,{mousewheel:{enabled:!1,enable:Mousewheel.enable.bind(this),disable:Mousewheel.disable.bind(this),handle:Mousewheel.handle.bind(this),handleMouseEnter:Mousewheel.handleMouseEnter.bind(this),handleMouseLeave:Mousewheel.handleMouseLeave.bind(this),animateSlider:Mousewheel.animateSlider.bind(this),releaseScroll:Mousewheel.releaseScroll.bind(this),lastScrollTime:Utils.now(),lastEventBeforeSnap:void 0,recentWheelEvents:[]}})},on:{init:function(){!this.params.mousewheel.enabled&&this.params.cssMode&&this.mousewheel.disable(),this.params.mousewheel.enabled&&this.mousewheel.enable()},destroy:function(){this.params.cssMode&&this.mousewheel.enable(),this.mousewheel.enabled&&this.mousewheel.disable()}}},Navigation={update:function(){var e=this.params.navigation;if(!this.params.loop){var t=this.navigation,a=t.$nextEl,r=t.$prevEl;r&&r.length>0&&(this.isBeginning?r.addClass(e.disabledClass):r.removeClass(e.disabledClass),r[this.params.watchOverflow&&this.isLocked?"addClass":"removeClass"](e.lockClass)),a&&a.length>0&&(this.isEnd?a.addClass(e.disabledClass):a.removeClass(e.disabledClass),a[this.params.watchOverflow&&this.isLocked?"addClass":"removeClass"](e.lockClass))}},onPrevClick:function(e){e.preventDefault(),this.isBeginning&&!this.params.loop||this.slidePrev()},onNextClick:function(e){e.preventDefault(),this.isEnd&&!this.params.loop||this.slideNext()},init:function(){var e,t,a=this.params.navigation;(a.nextEl||a.prevEl)&&(a.nextEl&&(e=$(a.nextEl),this.params.uniqueNavElements&&"string"==typeof a.nextEl&&e.length>1&&1===this.$el.find(a.nextEl).length&&(e=this.$el.find(a.nextEl))),a.prevEl&&(t=$(a.prevEl),this.params.uniqueNavElements&&"string"==typeof a.prevEl&&t.length>1&&1===this.$el.find(a.prevEl).length&&(t=this.$el.find(a.prevEl))),e&&e.length>0&&e.on("click",this.navigation.onNextClick),t&&t.length>0&&t.on("click",this.navigation.onPrevClick),Utils.extend(this.navigation,{$nextEl:e,nextEl:e&&e[0],$prevEl:t,prevEl:t&&t[0]}))},destroy:function(){var e=this.navigation,t=e.$nextEl,a=e.$prevEl;t&&t.length&&(t.off("click",this.navigation.onNextClick),t.removeClass(this.params.navigation.disabledClass)),a&&a.length&&(a.off("click",this.navigation.onPrevClick),a.removeClass(this.params.navigation.disabledClass))}},Navigation$1={name:"navigation",params:{navigation:{nextEl:null,prevEl:null,hideOnClick:!1,disabledClass:"swiper-button-disabled",hiddenClass:"swiper-button-hidden",lockClass:"swiper-button-lock"}},create:function(){Utils.extend(this,{navigation:{init:Navigation.init.bind(this),update:Navigation.update.bind(this),destroy:Navigation.destroy.bind(this),onNextClick:Navigation.onNextClick.bind(this),onPrevClick:Navigation.onPrevClick.bind(this)}})},on:{init:function(){this.navigation.init(),this.navigation.update()},toEdge:function(){this.navigation.update()},fromEdge:function(){this.navigation.update()},destroy:function(){this.navigation.destroy()},click:function(e){var t,a=this.navigation,r=a.$nextEl,n=a.$prevEl;!this.params.navigation.hideOnClick||$(e.target).is(n)||$(e.target).is(r)||(r?t=r.hasClass(this.params.navigation.hiddenClass):n&&(t=n.hasClass(this.params.navigation.hiddenClass)),!0===t?this.emit("navigationShow",this):this.emit("navigationHide",this),r&&r.toggleClass(this.params.navigation.hiddenClass),n&&n.toggleClass(this.params.navigation.hiddenClass))}}},Pagination={update:function(){var e=this.rtl,t=this.params.pagination;if(t.el&&this.pagination.el&&this.pagination.$el&&0!==this.pagination.$el.length){var a,r=this.virtual&&this.params.virtual.enabled?this.virtual.slides.length:this.slides.length,n=this.pagination.$el,i=this.params.loop?Math.ceil((r-2*this.loopedSlides)/this.params.slidesPerGroup):this.snapGrid.length;if(this.params.loop?((a=Math.ceil((this.activeIndex-this.loopedSlides)/this.params.slidesPerGroup))>r-1-2*this.loopedSlides&&(a-=r-2*this.loopedSlides),a>i-1&&(a-=i),a<0&&"bullets"!==this.params.paginationType&&(a=i+a)):a=void 0!==this.snapIndex?this.snapIndex:this.activeIndex||0,"bullets"===t.type&&this.pagination.bullets&&this.pagination.bullets.length>0){var o,s,l,p=this.pagination.bullets;if(t.dynamicBullets&&(this.pagination.bulletSize=p.eq(0)[this.isHorizontal()?"outerWidth":"outerHeight"](!0),n.css(this.isHorizontal()?"width":"height",this.pagination.bulletSize*(t.dynamicMainBullets+4)+"px"),t.dynamicMainBullets>1&&void 0!==this.previousIndex&&(this.pagination.dynamicBulletIndex+=a-this.previousIndex,this.pagination.dynamicBulletIndex>t.dynamicMainBullets-1?this.pagination.dynamicBulletIndex=t.dynamicMainBullets-1:this.pagination.dynamicBulletIndex<0&&(this.pagination.dynamicBulletIndex=0)),o=a-this.pagination.dynamicBulletIndex,l=((s=o+(Math.min(p.length,t.dynamicMainBullets)-1))+o)/2),p.removeClass(t.bulletActiveClass+" "+t.bulletActiveClass+"-next "+t.bulletActiveClass+"-next-next "+t.bulletActiveClass+"-prev "+t.bulletActiveClass+"-prev-prev "+t.bulletActiveClass+"-main"),n.length>1)p.each((function(e,r){var n=$(r),i=n.index();i===a&&n.addClass(t.bulletActiveClass),t.dynamicBullets&&(i>=o&&i<=s&&n.addClass(t.bulletActiveClass+"-main"),i===o&&n.prev().addClass(t.bulletActiveClass+"-prev").prev().addClass(t.bulletActiveClass+"-prev-prev"),i===s&&n.next().addClass(t.bulletActiveClass+"-next").next().addClass(t.bulletActiveClass+"-next-next"))}));else{var c=p.eq(a),d=c.index();if(c.addClass(t.bulletActiveClass),t.dynamicBullets){for(var u=p.eq(o),h=p.eq(s),f=o;f<=s;f+=1)p.eq(f).addClass(t.bulletActiveClass+"-main");if(this.params.loop)if(d>=p.length-t.dynamicMainBullets){for(var m=t.dynamicMainBullets;m>=0;m-=1)p.eq(p.length-m).addClass(t.bulletActiveClass+"-main");p.eq(p.length-t.dynamicMainBullets-1).addClass(t.bulletActiveClass+"-prev")}else u.prev().addClass(t.bulletActiveClass+"-prev").prev().addClass(t.bulletActiveClass+"-prev-prev"),h.next().addClass(t.bulletActiveClass+"-next").next().addClass(t.bulletActiveClass+"-next-next");else u.prev().addClass(t.bulletActiveClass+"-prev").prev().addClass(t.bulletActiveClass+"-prev-prev"),h.next().addClass(t.bulletActiveClass+"-next").next().addClass(t.bulletActiveClass+"-next-next")}}if(t.dynamicBullets){var v=Math.min(p.length,t.dynamicMainBullets+4),g=(this.pagination.bulletSize*v-this.pagination.bulletSize)/2-l*this.pagination.bulletSize,b=e?"right":"left";p.css(this.isHorizontal()?b:"top",g+"px")}}if("fraction"===t.type&&(n.find("."+t.currentClass).text(t.formatFractionCurrent(a+1)),n.find("."+t.totalClass).text(t.formatFractionTotal(i))),"progressbar"===t.type){var y;y=t.progressbarOpposite?this.isHorizontal()?"vertical":"horizontal":this.isHorizontal()?"horizontal":"vertical";var w=(a+1)/i,C=1,x=1;"horizontal"===y?C=w:x=w,n.find("."+t.progressbarFillClass).transform("translate3d(0,0,0) scaleX("+C+") scaleY("+x+")").transition(this.params.speed)}"custom"===t.type&&t.renderCustom?(n.html(t.renderCustom(this,a+1,i)),this.emit("paginationRender",this,n[0])):this.emit("paginationUpdate",this,n[0]),n[this.params.watchOverflow&&this.isLocked?"addClass":"removeClass"](t.lockClass)}},render:function(){var e=this.params.pagination;if(e.el&&this.pagination.el&&this.pagination.$el&&0!==this.pagination.$el.length){var t=this.virtual&&this.params.virtual.enabled?this.virtual.slides.length:this.slides.length,a=this.pagination.$el,r="";if("bullets"===e.type){for(var n=this.params.loop?Math.ceil((t-2*this.loopedSlides)/this.params.slidesPerGroup):this.snapGrid.length,i=0;i<n;i+=1)e.renderBullet?r+=e.renderBullet.call(this,i,e.bulletClass):r+="<"+e.bulletElement+' class="'+e.bulletClass+'"></'+e.bulletElement+">";a.html(r),this.pagination.bullets=a.find("."+e.bulletClass)}"fraction"===e.type&&(r=e.renderFraction?e.renderFraction.call(this,e.currentClass,e.totalClass):'<span class="'+e.currentClass+'"></span> / <span class="'+e.totalClass+'"></span>',a.html(r)),"progressbar"===e.type&&(r=e.renderProgressbar?e.renderProgressbar.call(this,e.progressbarFillClass):'<span class="'+e.progressbarFillClass+'"></span>',a.html(r)),"custom"!==e.type&&this.emit("paginationRender",this.pagination.$el[0])}},init:function(){var e=this,t=e.params.pagination;if(t.el){var a=$(t.el);0!==a.length&&(e.params.uniqueNavElements&&"string"==typeof t.el&&a.length>1&&1===e.$el.find(t.el).length&&(a=e.$el.find(t.el)),"bullets"===t.type&&t.clickable&&a.addClass(t.clickableClass),a.addClass(t.modifierClass+t.type),"bullets"===t.type&&t.dynamicBullets&&(a.addClass(""+t.modifierClass+t.type+"-dynamic"),e.pagination.dynamicBulletIndex=0,t.dynamicMainBullets<1&&(t.dynamicMainBullets=1)),"progressbar"===t.type&&t.progressbarOpposite&&a.addClass(t.progressbarOppositeClass),t.clickable&&a.on("click","."+t.bulletClass,(function(t){t.preventDefault();var a=$(this).index()*e.params.slidesPerGroup;e.params.loop&&(a+=e.loopedSlides),e.slideTo(a)})),Utils.extend(e.pagination,{$el:a,el:a[0]}))}},destroy:function(){var e=this.params.pagination;if(e.el&&this.pagination.el&&this.pagination.$el&&0!==this.pagination.$el.length){var t=this.pagination.$el;t.removeClass(e.hiddenClass),t.removeClass(e.modifierClass+e.type),this.pagination.bullets&&this.pagination.bullets.removeClass(e.bulletActiveClass),e.clickable&&t.off("click","."+e.bulletClass)}}},Pagination$1={name:"pagination",params:{pagination:{el:null,bulletElement:"span",clickable:!1,hideOnClick:!1,renderBullet:null,renderProgressbar:null,renderFraction:null,renderCustom:null,progressbarOpposite:!1,type:"bullets",dynamicBullets:!1,dynamicMainBullets:1,formatFractionCurrent:function(e){return e},formatFractionTotal:function(e){return e},bulletClass:"swiper-pagination-bullet",bulletActiveClass:"swiper-pagination-bullet-active",modifierClass:"swiper-pagination-",currentClass:"swiper-pagination-current",totalClass:"swiper-pagination-total",hiddenClass:"swiper-pagination-hidden",progressbarFillClass:"swiper-pagination-progressbar-fill",progressbarOppositeClass:"swiper-pagination-progressbar-opposite",clickableClass:"swiper-pagination-clickable",lockClass:"swiper-pagination-lock"}},create:function(){Utils.extend(this,{pagination:{init:Pagination.init.bind(this),render:Pagination.render.bind(this),update:Pagination.update.bind(this),destroy:Pagination.destroy.bind(this),dynamicBulletIndex:0}})},on:{init:function(){this.pagination.init(),this.pagination.render(),this.pagination.update()},activeIndexChange:function(){(this.params.loop||void 0===this.snapIndex)&&this.pagination.update()},snapIndexChange:function(){this.params.loop||this.pagination.update()},slidesLengthChange:function(){this.params.loop&&(this.pagination.render(),this.pagination.update())},snapGridLengthChange:function(){this.params.loop||(this.pagination.render(),this.pagination.update())},destroy:function(){this.pagination.destroy()},click:function(e){this.params.pagination.el&&this.params.pagination.hideOnClick&&this.pagination.$el.length>0&&!$(e.target).hasClass(this.params.pagination.bulletClass)&&(!0===this.pagination.$el.hasClass(this.params.pagination.hiddenClass)?this.emit("paginationShow",this):this.emit("paginationHide",this),this.pagination.$el.toggleClass(this.params.pagination.hiddenClass))}}},Scrollbar={setTranslate:function(){if(this.params.scrollbar.el&&this.scrollbar.el){var e=this.scrollbar,t=this.rtlTranslate,a=this.progress,r=e.dragSize,n=e.trackSize,i=e.$dragEl,o=e.$el,s=this.params.scrollbar,l=r,p=(n-r)*a;t?(p=-p)>0?(l=r-p,p=0):-p+r>n&&(l=n+p):p<0?(l=r+p,p=0):p+r>n&&(l=n-p),this.isHorizontal()?(i.transform("translate3d("+p+"px, 0, 0)"),i[0].style.width=l+"px"):(i.transform("translate3d(0px, "+p+"px, 0)"),i[0].style.height=l+"px"),s.hide&&(clearTimeout(this.scrollbar.timeout),o[0].style.opacity=1,this.scrollbar.timeout=setTimeout((function(){o[0].style.opacity=0,o.transition(400)}),1e3))}},setTransition:function(e){this.params.scrollbar.el&&this.scrollbar.el&&this.scrollbar.$dragEl.transition(e)},updateSize:function(){if(this.params.scrollbar.el&&this.scrollbar.el){var e=this.scrollbar,t=e.$dragEl,a=e.$el;t[0].style.width="",t[0].style.height="";var r,n=this.isHorizontal()?a[0].offsetWidth:a[0].offsetHeight,i=this.size/this.virtualSize,o=i*(n/this.size);r="auto"===this.params.scrollbar.dragSize?n*i:parseInt(this.params.scrollbar.dragSize,10),this.isHorizontal()?t[0].style.width=r+"px":t[0].style.height=r+"px",a[0].style.display=i>=1?"none":"",this.params.scrollbar.hide&&(a[0].style.opacity=0),Utils.extend(e,{trackSize:n,divider:i,moveDivider:o,dragSize:r}),e.$el[this.params.watchOverflow&&this.isLocked?"addClass":"removeClass"](this.params.scrollbar.lockClass)}},getPointerPosition:function(e){return this.isHorizontal()?"touchstart"===e.type||"touchmove"===e.type?e.targetTouches[0].clientX:e.clientX:"touchstart"===e.type||"touchmove"===e.type?e.targetTouches[0].clientY:e.clientY},setDragPosition:function(e){var t,a=this.scrollbar,r=this.rtlTranslate,n=a.$el,i=a.dragSize,o=a.trackSize,s=a.dragStartPos;t=(a.getPointerPosition(e)-n.offset()[this.isHorizontal()?"left":"top"]-(null!==s?s:i/2))/(o-i),t=Math.max(Math.min(t,1),0),r&&(t=1-t);var l=this.minTranslate()+(this.maxTranslate()-this.minTranslate())*t;this.updateProgress(l),this.setTranslate(l),this.updateActiveIndex(),this.updateSlidesClasses()},onDragStart:function(e){var t=this.params.scrollbar,a=this.scrollbar,r=this.$wrapperEl,n=a.$el,i=a.$dragEl;this.scrollbar.isTouched=!0,this.scrollbar.dragStartPos=e.target===i[0]||e.target===i?a.getPointerPosition(e)-e.target.getBoundingClientRect()[this.isHorizontal()?"left":"top"]:null,e.preventDefault(),e.stopPropagation(),r.transition(100),i.transition(100),a.setDragPosition(e),clearTimeout(this.scrollbar.dragTimeout),n.transition(0),t.hide&&n.css("opacity",1),this.params.cssMode&&this.$wrapperEl.css("scroll-snap-type","none"),this.emit("scrollbarDragStart",e)},onDragMove:function(e){var t=this.scrollbar,a=this.$wrapperEl,r=t.$el,n=t.$dragEl;this.scrollbar.isTouched&&(e.preventDefault?e.preventDefault():e.returnValue=!1,t.setDragPosition(e),a.transition(0),r.transition(0),n.transition(0),this.emit("scrollbarDragMove",e))},onDragEnd:function(e){var t=this.params.scrollbar,a=this.scrollbar,r=this.$wrapperEl,n=a.$el;this.scrollbar.isTouched&&(this.scrollbar.isTouched=!1,this.params.cssMode&&(this.$wrapperEl.css("scroll-snap-type",""),r.transition("")),t.hide&&(clearTimeout(this.scrollbar.dragTimeout),this.scrollbar.dragTimeout=Utils.nextTick((function(){n.css("opacity",0),n.transition(400)}),1e3)),this.emit("scrollbarDragEnd",e),t.snapOnRelease&&this.slideToClosest())},enableDraggable:function(){if(this.params.scrollbar.el){var e=this.scrollbar,t=this.touchEventsTouch,a=this.touchEventsDesktop,r=this.params,n=e.$el[0],i=!(!Support.passiveListener||!r.passiveListeners)&&{passive:!1,capture:!1},o=!(!Support.passiveListener||!r.passiveListeners)&&{passive:!0,capture:!1};Support.touch?(n.addEventListener(t.start,this.scrollbar.onDragStart,i),n.addEventListener(t.move,this.scrollbar.onDragMove,i),n.addEventListener(t.end,this.scrollbar.onDragEnd,o)):(n.addEventListener(a.start,this.scrollbar.onDragStart,i),doc.addEventListener(a.move,this.scrollbar.onDragMove,i),doc.addEventListener(a.end,this.scrollbar.onDragEnd,o))}},disableDraggable:function(){if(this.params.scrollbar.el){var e=this.scrollbar,t=this.touchEventsTouch,a=this.touchEventsDesktop,r=this.params,n=e.$el[0],i=!(!Support.passiveListener||!r.passiveListeners)&&{passive:!1,capture:!1},o=!(!Support.passiveListener||!r.passiveListeners)&&{passive:!0,capture:!1};Support.touch?(n.removeEventListener(t.start,this.scrollbar.onDragStart,i),n.removeEventListener(t.move,this.scrollbar.onDragMove,i),n.removeEventListener(t.end,this.scrollbar.onDragEnd,o)):(n.removeEventListener(a.start,this.scrollbar.onDragStart,i),doc.removeEventListener(a.move,this.scrollbar.onDragMove,i),doc.removeEventListener(a.end,this.scrollbar.onDragEnd,o))}},init:function(){if(this.params.scrollbar.el){var e=this.scrollbar,t=this.$el,a=this.params.scrollbar,r=$(a.el);this.params.uniqueNavElements&&"string"==typeof a.el&&r.length>1&&1===t.find(a.el).length&&(r=t.find(a.el));var n=r.find("."+this.params.scrollbar.dragClass);0===n.length&&(n=$('<div class="'+this.params.scrollbar.dragClass+'"></div>'),r.append(n)),Utils.extend(e,{$el:r,el:r[0],$dragEl:n,dragEl:n[0]}),a.draggable&&e.enableDraggable()}},destroy:function(){this.scrollbar.disableDraggable()}},Scrollbar$1={name:"scrollbar",params:{scrollbar:{el:null,dragSize:"auto",hide:!1,draggable:!1,snapOnRelease:!0,lockClass:"swiper-scrollbar-lock",dragClass:"swiper-scrollbar-drag"}},create:function(){Utils.extend(this,{scrollbar:{init:Scrollbar.init.bind(this),destroy:Scrollbar.destroy.bind(this),updateSize:Scrollbar.updateSize.bind(this),setTranslate:Scrollbar.setTranslate.bind(this),setTransition:Scrollbar.setTransition.bind(this),enableDraggable:Scrollbar.enableDraggable.bind(this),disableDraggable:Scrollbar.disableDraggable.bind(this),setDragPosition:Scrollbar.setDragPosition.bind(this),getPointerPosition:Scrollbar.getPointerPosition.bind(this),onDragStart:Scrollbar.onDragStart.bind(this),onDragMove:Scrollbar.onDragMove.bind(this),onDragEnd:Scrollbar.onDragEnd.bind(this),isTouched:!1,timeout:null,dragTimeout:null}})},on:{init:function(){this.scrollbar.init(),this.scrollbar.updateSize(),this.scrollbar.setTranslate()},update:function(){this.scrollbar.updateSize()},resize:function(){this.scrollbar.updateSize()},observerUpdate:function(){this.scrollbar.updateSize()},setTranslate:function(){this.scrollbar.setTranslate()},setTransition:function(e){this.scrollbar.setTransition(e)},destroy:function(){this.scrollbar.destroy()}}},Parallax={setTransform:function(e,t){var a=this.rtl,r=$(e),n=a?-1:1,i=r.attr("data-swiper-parallax")||"0",o=r.attr("data-swiper-parallax-x"),s=r.attr("data-swiper-parallax-y"),l=r.attr("data-swiper-parallax-scale"),p=r.attr("data-swiper-parallax-opacity");if(o||s?(o=o||"0",s=s||"0"):this.isHorizontal()?(o=i,s="0"):(s=i,o="0"),o=o.indexOf("%")>=0?parseInt(o,10)*t*n+"%":o*t*n+"px",s=s.indexOf("%")>=0?parseInt(s,10)*t+"%":s*t+"px",null!=p){var c=p-(p-1)*(1-Math.abs(t));r[0].style.opacity=c}if(null==l)r.transform("translate3d("+o+", "+s+", 0px)");else{var d=l-(l-1)*(1-Math.abs(t));r.transform("translate3d("+o+", "+s+", 0px) scale("+d+")")}},setTranslate:function(){var e=this,t=e.$el,a=e.slides,r=e.progress,n=e.snapGrid;t.children("[data-swiper-parallax], [data-swiper-parallax-x], [data-swiper-parallax-y], [data-swiper-parallax-opacity], [data-swiper-parallax-scale]").each((function(t,a){e.parallax.setTransform(a,r)})),a.each((function(t,a){var i=a.progress;e.params.slidesPerGroup>1&&"auto"!==e.params.slidesPerView&&(i+=Math.ceil(t/2)-r*(n.length-1)),i=Math.min(Math.max(i,-1),1),$(a).find("[data-swiper-parallax], [data-swiper-parallax-x], [data-swiper-parallax-y], [data-swiper-parallax-opacity], [data-swiper-parallax-scale]").each((function(t,a){e.parallax.setTransform(a,i)}))}))},setTransition:function(e){void 0===e&&(e=this.params.speed);this.$el.find("[data-swiper-parallax], [data-swiper-parallax-x], [data-swiper-parallax-y], [data-swiper-parallax-opacity], [data-swiper-parallax-scale]").each((function(t,a){var r=$(a),n=parseInt(r.attr("data-swiper-parallax-duration"),10)||e;0===e&&(n=0),r.transition(n)}))}},Parallax$1={name:"parallax",params:{parallax:{enabled:!1}},create:function(){Utils.extend(this,{parallax:{setTransform:Parallax.setTransform.bind(this),setTranslate:Parallax.setTranslate.bind(this),setTransition:Parallax.setTransition.bind(this)}})},on:{beforeInit:function(){this.params.parallax.enabled&&(this.params.watchSlidesProgress=!0,this.originalParams.watchSlidesProgress=!0)},init:function(){this.params.parallax.enabled&&this.parallax.setTranslate()},setTranslate:function(){this.params.parallax.enabled&&this.parallax.setTranslate()},setTransition:function(e){this.params.parallax.enabled&&this.parallax.setTransition(e)}}},Zoom={getDistanceBetweenTouches:function(e){if(e.targetTouches.length<2)return 1;var t=e.targetTouches[0].pageX,a=e.targetTouches[0].pageY,r=e.targetTouches[1].pageX,n=e.targetTouches[1].pageY;return Math.sqrt(Math.pow(r-t,2)+Math.pow(n-a,2))},onGestureStart:function(e){var t=this.params.zoom,a=this.zoom,r=a.gesture;if(a.fakeGestureTouched=!1,a.fakeGestureMoved=!1,!Support.gestures){if("touchstart"!==e.type||"touchstart"===e.type&&e.targetTouches.length<2)return;a.fakeGestureTouched=!0,r.scaleStart=Zoom.getDistanceBetweenTouches(e)}r.$slideEl&&r.$slideEl.length||(r.$slideEl=$(e.target).closest("."+this.params.slideClass),0===r.$slideEl.length&&(r.$slideEl=this.slides.eq(this.activeIndex)),r.$imageEl=r.$slideEl.find("img, svg, canvas, picture, .swiper-zoom-target"),r.$imageWrapEl=r.$imageEl.parent("."+t.containerClass),r.maxRatio=r.$imageWrapEl.attr("data-swiper-zoom")||t.maxRatio,0!==r.$imageWrapEl.length)?(r.$imageEl.transition(0),this.zoom.isScaling=!0):r.$imageEl=void 0},onGestureChange:function(e){var t=this.params.zoom,a=this.zoom,r=a.gesture;if(!Support.gestures){if("touchmove"!==e.type||"touchmove"===e.type&&e.targetTouches.length<2)return;a.fakeGestureMoved=!0,r.scaleMove=Zoom.getDistanceBetweenTouches(e)}r.$imageEl&&0!==r.$imageEl.length&&(Support.gestures?a.scale=e.scale*a.currentScale:a.scale=r.scaleMove/r.scaleStart*a.currentScale,a.scale>r.maxRatio&&(a.scale=r.maxRatio-1+Math.pow(a.scale-r.maxRatio+1,.5)),a.scale<t.minRatio&&(a.scale=t.minRatio+1-Math.pow(t.minRatio-a.scale+1,.5)),r.$imageEl.transform("translate3d(0,0,0) scale("+a.scale+")"))},onGestureEnd:function(e){var t=this.params.zoom,a=this.zoom,r=a.gesture;if(!Support.gestures){if(!a.fakeGestureTouched||!a.fakeGestureMoved)return;if("touchend"!==e.type||"touchend"===e.type&&e.changedTouches.length<2&&!Device.android)return;a.fakeGestureTouched=!1,a.fakeGestureMoved=!1}r.$imageEl&&0!==r.$imageEl.length&&(a.scale=Math.max(Math.min(a.scale,r.maxRatio),t.minRatio),r.$imageEl.transition(this.params.speed).transform("translate3d(0,0,0) scale("+a.scale+")"),a.currentScale=a.scale,a.isScaling=!1,1===a.scale&&(r.$slideEl=void 0))},onTouchStart:function(e){var t=this.zoom,a=t.gesture,r=t.image;a.$imageEl&&0!==a.$imageEl.length&&(r.isTouched||(Device.android&&e.preventDefault(),r.isTouched=!0,r.touchesStart.x="touchstart"===e.type?e.targetTouches[0].pageX:e.pageX,r.touchesStart.y="touchstart"===e.type?e.targetTouches[0].pageY:e.pageY))},onTouchMove:function(e){var t=this.zoom,a=t.gesture,r=t.image,n=t.velocity;if(a.$imageEl&&0!==a.$imageEl.length&&(this.allowClick=!1,r.isTouched&&a.$slideEl)){r.isMoved||(r.width=a.$imageEl[0].offsetWidth,r.height=a.$imageEl[0].offsetHeight,r.startX=Utils.getTranslate(a.$imageWrapEl[0],"x")||0,r.startY=Utils.getTranslate(a.$imageWrapEl[0],"y")||0,a.slideWidth=a.$slideEl[0].offsetWidth,a.slideHeight=a.$slideEl[0].offsetHeight,a.$imageWrapEl.transition(0),this.rtl&&(r.startX=-r.startX,r.startY=-r.startY));var i=r.width*t.scale,o=r.height*t.scale;if(!(i<a.slideWidth&&o<a.slideHeight)){if(r.minX=Math.min(a.slideWidth/2-i/2,0),r.maxX=-r.minX,r.minY=Math.min(a.slideHeight/2-o/2,0),r.maxY=-r.minY,r.touchesCurrent.x="touchmove"===e.type?e.targetTouches[0].pageX:e.pageX,r.touchesCurrent.y="touchmove"===e.type?e.targetTouches[0].pageY:e.pageY,!r.isMoved&&!t.isScaling){if(this.isHorizontal()&&(Math.floor(r.minX)===Math.floor(r.startX)&&r.touchesCurrent.x<r.touchesStart.x||Math.floor(r.maxX)===Math.floor(r.startX)&&r.touchesCurrent.x>r.touchesStart.x))return void(r.isTouched=!1);if(!this.isHorizontal()&&(Math.floor(r.minY)===Math.floor(r.startY)&&r.touchesCurrent.y<r.touchesStart.y||Math.floor(r.maxY)===Math.floor(r.startY)&&r.touchesCurrent.y>r.touchesStart.y))return void(r.isTouched=!1)}e.preventDefault(),e.stopPropagation(),r.isMoved=!0,r.currentX=r.touchesCurrent.x-r.touchesStart.x+r.startX,r.currentY=r.touchesCurrent.y-r.touchesStart.y+r.startY,r.currentX<r.minX&&(r.currentX=r.minX+1-Math.pow(r.minX-r.currentX+1,.8)),r.currentX>r.maxX&&(r.currentX=r.maxX-1+Math.pow(r.currentX-r.maxX+1,.8)),r.currentY<r.minY&&(r.currentY=r.minY+1-Math.pow(r.minY-r.currentY+1,.8)),r.currentY>r.maxY&&(r.currentY=r.maxY-1+Math.pow(r.currentY-r.maxY+1,.8)),n.prevPositionX||(n.prevPositionX=r.touchesCurrent.x),n.prevPositionY||(n.prevPositionY=r.touchesCurrent.y),n.prevTime||(n.prevTime=Date.now()),n.x=(r.touchesCurrent.x-n.prevPositionX)/(Date.now()-n.prevTime)/2,n.y=(r.touchesCurrent.y-n.prevPositionY)/(Date.now()-n.prevTime)/2,Math.abs(r.touchesCurrent.x-n.prevPositionX)<2&&(n.x=0),Math.abs(r.touchesCurrent.y-n.prevPositionY)<2&&(n.y=0),n.prevPositionX=r.touchesCurrent.x,n.prevPositionY=r.touchesCurrent.y,n.prevTime=Date.now(),a.$imageWrapEl.transform("translate3d("+r.currentX+"px, "+r.currentY+"px,0)")}}},onTouchEnd:function(){var e=this.zoom,t=e.gesture,a=e.image,r=e.velocity;if(t.$imageEl&&0!==t.$imageEl.length){if(!a.isTouched||!a.isMoved)return a.isTouched=!1,void(a.isMoved=!1);a.isTouched=!1,a.isMoved=!1;var n=300,i=300,o=r.x*n,s=a.currentX+o,l=r.y*i,p=a.currentY+l;0!==r.x&&(n=Math.abs((s-a.currentX)/r.x)),0!==r.y&&(i=Math.abs((p-a.currentY)/r.y));var c=Math.max(n,i);a.currentX=s,a.currentY=p;var d=a.width*e.scale,u=a.height*e.scale;a.minX=Math.min(t.slideWidth/2-d/2,0),a.maxX=-a.minX,a.minY=Math.min(t.slideHeight/2-u/2,0),a.maxY=-a.minY,a.currentX=Math.max(Math.min(a.currentX,a.maxX),a.minX),a.currentY=Math.max(Math.min(a.currentY,a.maxY),a.minY),t.$imageWrapEl.transition(c).transform("translate3d("+a.currentX+"px, "+a.currentY+"px,0)")}},onTransitionEnd:function(){var e=this.zoom,t=e.gesture;t.$slideEl&&this.previousIndex!==this.activeIndex&&(t.$imageEl.transform("translate3d(0,0,0) scale(1)"),t.$imageWrapEl.transform("translate3d(0,0,0)"),e.scale=1,e.currentScale=1,t.$slideEl=void 0,t.$imageEl=void 0,t.$imageWrapEl=void 0)},toggle:function(e){var t=this.zoom;t.scale&&1!==t.scale?t.out():t.in(e)},in:function(e){var t,a,r,n,i,o,s,l,p,c,d,u,h,f,m,v,g=this.zoom,b=this.params.zoom,y=g.gesture,w=g.image;(y.$slideEl||(y.$slideEl=this.slides.eq(this.activeIndex),y.$imageEl=y.$slideEl.find("img, svg, canvas, picture, .swiper-zoom-target"),y.$imageWrapEl=y.$imageEl.parent("."+b.containerClass)),y.$imageEl&&0!==y.$imageEl.length)&&(y.$slideEl.addClass(""+b.zoomedSlideClass),void 0===w.touchesStart.x&&e?(t="touchend"===e.type?e.changedTouches[0].pageX:e.pageX,a="touchend"===e.type?e.changedTouches[0].pageY:e.pageY):(t=w.touchesStart.x,a=w.touchesStart.y),g.scale=y.$imageWrapEl.attr("data-swiper-zoom")||b.maxRatio,g.currentScale=y.$imageWrapEl.attr("data-swiper-zoom")||b.maxRatio,e?(m=y.$slideEl[0].offsetWidth,v=y.$slideEl[0].offsetHeight,r=y.$slideEl.offset().left+m/2-t,n=y.$slideEl.offset().top+v/2-a,s=y.$imageEl[0].offsetWidth,l=y.$imageEl[0].offsetHeight,p=s*g.scale,c=l*g.scale,h=-(d=Math.min(m/2-p/2,0)),f=-(u=Math.min(v/2-c/2,0)),(i=r*g.scale)<d&&(i=d),i>h&&(i=h),(o=n*g.scale)<u&&(o=u),o>f&&(o=f)):(i=0,o=0),y.$imageWrapEl.transition(300).transform("translate3d("+i+"px, "+o+"px,0)"),y.$imageEl.transition(300).transform("translate3d(0,0,0) scale("+g.scale+")"))},out:function(){var e=this.zoom,t=this.params.zoom,a=e.gesture;a.$slideEl||(a.$slideEl=this.slides.eq(this.activeIndex),a.$imageEl=a.$slideEl.find("img, svg, canvas, picture, .swiper-zoom-target"),a.$imageWrapEl=a.$imageEl.parent("."+t.containerClass)),a.$imageEl&&0!==a.$imageEl.length&&(e.scale=1,e.currentScale=1,a.$imageWrapEl.transition(300).transform("translate3d(0,0,0)"),a.$imageEl.transition(300).transform("translate3d(0,0,0) scale(1)"),a.$slideEl.removeClass(""+t.zoomedSlideClass),a.$slideEl=void 0)},enable:function(){var e=this.zoom;if(!e.enabled){e.enabled=!0;var t=!("touchstart"!==this.touchEvents.start||!Support.passiveListener||!this.params.passiveListeners)&&{passive:!0,capture:!1},a=!Support.passiveListener||{passive:!1,capture:!0},r="."+this.params.slideClass;Support.gestures?(this.$wrapperEl.on("gesturestart",r,e.onGestureStart,t),this.$wrapperEl.on("gesturechange",r,e.onGestureChange,t),this.$wrapperEl.on("gestureend",r,e.onGestureEnd,t)):"touchstart"===this.touchEvents.start&&(this.$wrapperEl.on(this.touchEvents.start,r,e.onGestureStart,t),this.$wrapperEl.on(this.touchEvents.move,r,e.onGestureChange,a),this.$wrapperEl.on(this.touchEvents.end,r,e.onGestureEnd,t),this.touchEvents.cancel&&this.$wrapperEl.on(this.touchEvents.cancel,r,e.onGestureEnd,t)),this.$wrapperEl.on(this.touchEvents.move,"."+this.params.zoom.containerClass,e.onTouchMove,a)}},disable:function(){var e=this.zoom;if(e.enabled){this.zoom.enabled=!1;var t=!("touchstart"!==this.touchEvents.start||!Support.passiveListener||!this.params.passiveListeners)&&{passive:!0,capture:!1},a=!Support.passiveListener||{passive:!1,capture:!0},r="."+this.params.slideClass;Support.gestures?(this.$wrapperEl.off("gesturestart",r,e.onGestureStart,t),this.$wrapperEl.off("gesturechange",r,e.onGestureChange,t),this.$wrapperEl.off("gestureend",r,e.onGestureEnd,t)):"touchstart"===this.touchEvents.start&&(this.$wrapperEl.off(this.touchEvents.start,r,e.onGestureStart,t),this.$wrapperEl.off(this.touchEvents.move,r,e.onGestureChange,a),this.$wrapperEl.off(this.touchEvents.end,r,e.onGestureEnd,t),this.touchEvents.cancel&&this.$wrapperEl.off(this.touchEvents.cancel,r,e.onGestureEnd,t)),this.$wrapperEl.off(this.touchEvents.move,"."+this.params.zoom.containerClass,e.onTouchMove,a)}}},Zoom$1={name:"zoom",params:{zoom:{enabled:!1,maxRatio:3,minRatio:1,toggle:!0,containerClass:"swiper-zoom-container",zoomedSlideClass:"swiper-slide-zoomed"}},create:function(){var e=this,t={enabled:!1,scale:1,currentScale:1,isScaling:!1,gesture:{$slideEl:void 0,slideWidth:void 0,slideHeight:void 0,$imageEl:void 0,$imageWrapEl:void 0,maxRatio:3},image:{isTouched:void 0,isMoved:void 0,currentX:void 0,currentY:void 0,minX:void 0,minY:void 0,maxX:void 0,maxY:void 0,width:void 0,height:void 0,startX:void 0,startY:void 0,touchesStart:{},touchesCurrent:{}},velocity:{x:void 0,y:void 0,prevPositionX:void 0,prevPositionY:void 0,prevTime:void 0}};"onGestureStart onGestureChange onGestureEnd onTouchStart onTouchMove onTouchEnd onTransitionEnd toggle enable disable in out".split(" ").forEach((function(a){t[a]=Zoom[a].bind(e)})),Utils.extend(e,{zoom:t});var a=1;Object.defineProperty(e.zoom,"scale",{get:function(){return a},set:function(t){if(a!==t){var r=e.zoom.gesture.$imageEl?e.zoom.gesture.$imageEl[0]:void 0,n=e.zoom.gesture.$slideEl?e.zoom.gesture.$slideEl[0]:void 0;e.emit("zoomChange",t,r,n)}a=t}})},on:{init:function(){this.params.zoom.enabled&&this.zoom.enable()},destroy:function(){this.zoom.disable()},touchStart:function(e){this.zoom.enabled&&this.zoom.onTouchStart(e)},touchEnd:function(e){this.zoom.enabled&&this.zoom.onTouchEnd(e)},doubleTap:function(e){this.params.zoom.enabled&&this.zoom.enabled&&this.params.zoom.toggle&&this.zoom.toggle(e)},transitionEnd:function(){this.zoom.enabled&&this.params.zoom.enabled&&this.zoom.onTransitionEnd()},slideChange:function(){this.zoom.enabled&&this.params.zoom.enabled&&this.params.cssMode&&this.zoom.onTransitionEnd()}}},Lazy$2={loadInSlide:function(e,t){void 0===t&&(t=!0);var a=this,r=a.params.lazy;if(void 0!==e&&0!==a.slides.length){var n=a.virtual&&a.params.virtual.enabled?a.$wrapperEl.children("."+a.params.slideClass+'[data-swiper-slide-index="'+e+'"]'):a.slides.eq(e),i=n.find("."+r.elementClass+":not(."+r.loadedClass+"):not(."+r.loadingClass+")");!n.hasClass(r.elementClass)||n.hasClass(r.loadedClass)||n.hasClass(r.loadingClass)||(i=i.add(n[0])),0!==i.length&&i.each((function(e,i){var o=$(i);o.addClass(r.loadingClass);var s=o.attr("data-background"),l=o.attr("data-src"),p=o.attr("data-srcset"),c=o.attr("data-sizes");a.loadImage(o[0],l||s,p,c,!1,(function(){if(null!=a&&a&&(!a||a.params)&&!a.destroyed){if(s?(o.css("background-image",'url("'+s+'")'),o.removeAttr("data-background")):(p&&(o.attr("srcset",p),o.removeAttr("data-srcset")),c&&(o.attr("sizes",c),o.removeAttr("data-sizes")),l&&(o.attr("src",l),o.removeAttr("data-src"))),o.addClass(r.loadedClass).removeClass(r.loadingClass),n.find("."+r.preloaderClass).remove(),a.params.loop&&t){var e=n.attr("data-swiper-slide-index");if(n.hasClass(a.params.slideDuplicateClass)){var i=a.$wrapperEl.children('[data-swiper-slide-index="'+e+'"]:not(.'+a.params.slideDuplicateClass+")");a.lazy.loadInSlide(i.index(),!1)}else{var d=a.$wrapperEl.children("."+a.params.slideDuplicateClass+'[data-swiper-slide-index="'+e+'"]');a.lazy.loadInSlide(d.index(),!1)}}a.emit("lazyImageReady",n[0],o[0]),a.params.autoHeight&&a.updateAutoHeight()}})),a.emit("lazyImageLoad",n[0],o[0])}))}},load:function(){var e=this,t=e.$wrapperEl,a=e.params,r=e.slides,n=e.activeIndex,i=e.virtual&&a.virtual.enabled,o=a.lazy,s=a.slidesPerView;function l(e){if(i){if(t.children("."+a.slideClass+'[data-swiper-slide-index="'+e+'"]').length)return!0}else if(r[e])return!0;return!1}function p(e){return i?$(e).attr("data-swiper-slide-index"):$(e).index()}if("auto"===s&&(s=0),e.lazy.initialImageLoaded||(e.lazy.initialImageLoaded=!0),e.params.watchSlidesVisibility)t.children("."+a.slideVisibleClass).each((function(t,a){var r=i?$(a).attr("data-swiper-slide-index"):$(a).index();e.lazy.loadInSlide(r)}));else if(s>1)for(var c=n;c<n+s;c+=1)l(c)&&e.lazy.loadInSlide(c);else e.lazy.loadInSlide(n);if(o.loadPrevNext)if(s>1||o.loadPrevNextAmount&&o.loadPrevNextAmount>1){for(var d=o.loadPrevNextAmount,u=s,h=Math.min(n+u+Math.max(d,u),r.length),f=Math.max(n-Math.max(u,d),0),m=n+s;m<h;m+=1)l(m)&&e.lazy.loadInSlide(m);for(var v=f;v<n;v+=1)l(v)&&e.lazy.loadInSlide(v)}else{var g=t.children("."+a.slideNextClass);g.length>0&&e.lazy.loadInSlide(p(g));var b=t.children("."+a.slidePrevClass);b.length>0&&e.lazy.loadInSlide(p(b))}}},Lazy$3={name:"lazy",params:{lazy:{enabled:!1,loadPrevNext:!1,loadPrevNextAmount:1,loadOnTransitionStart:!1,elementClass:"swiper-lazy",loadingClass:"swiper-lazy-loading",loadedClass:"swiper-lazy-loaded",preloaderClass:"swiper-lazy-preloader"}},create:function(){Utils.extend(this,{lazy:{initialImageLoaded:!1,load:Lazy$2.load.bind(this),loadInSlide:Lazy$2.loadInSlide.bind(this)}})},on:{beforeInit:function(){this.params.lazy.enabled&&this.params.preloadImages&&(this.params.preloadImages=!1)},init:function(){this.params.lazy.enabled&&!this.params.loop&&0===this.params.initialSlide&&this.lazy.load()},scroll:function(){this.params.freeMode&&!this.params.freeModeSticky&&this.lazy.load()},resize:function(){this.params.lazy.enabled&&this.lazy.load()},scrollbarDragMove:function(){this.params.lazy.enabled&&this.lazy.load()},transitionStart:function(){this.params.lazy.enabled&&(this.params.lazy.loadOnTransitionStart||!this.params.lazy.loadOnTransitionStart&&!this.lazy.initialImageLoaded)&&this.lazy.load()},transitionEnd:function(){this.params.lazy.enabled&&!this.params.lazy.loadOnTransitionStart&&this.lazy.load()},slideChange:function(){this.params.lazy.enabled&&this.params.cssMode&&this.lazy.load()}}},Controller={LinearSpline:function(e,t){var a,r,n,i,o,s=function(e,t){for(r=-1,a=e.length;a-r>1;)e[n=a+r>>1]<=t?r=n:a=n;return a};return this.x=e,this.y=t,this.lastIndex=e.length-1,this.interpolate=function(e){return e?(o=s(this.x,e),i=o-1,(e-this.x[i])*(this.y[o]-this.y[i])/(this.x[o]-this.x[i])+this.y[i]):0},this},getInterpolateFunction:function(e){this.controller.spline||(this.controller.spline=this.params.loop?new Controller.LinearSpline(this.slidesGrid,e.slidesGrid):new Controller.LinearSpline(this.snapGrid,e.snapGrid))},setTranslate:function(e,t){var a,r,n=this,i=n.controller.control;function o(e){var t=n.rtlTranslate?-n.translate:n.translate;"slide"===n.params.controller.by&&(n.controller.getInterpolateFunction(e),r=-n.controller.spline.interpolate(-t)),r&&"container"!==n.params.controller.by||(a=(e.maxTranslate()-e.minTranslate())/(n.maxTranslate()-n.minTranslate()),r=(t-n.minTranslate())*a+e.minTranslate()),n.params.controller.inverse&&(r=e.maxTranslate()-r),e.updateProgress(r),e.setTranslate(r,n),e.updateActiveIndex(),e.updateSlidesClasses()}if(Array.isArray(i))for(var s=0;s<i.length;s+=1)i[s]!==t&&i[s]instanceof Swiper&&o(i[s]);else i instanceof Swiper&&t!==i&&o(i)},setTransition:function(e,t){var a,r=this,n=r.controller.control;function i(t){t.setTransition(e,r),0!==e&&(t.transitionStart(),t.params.autoHeight&&Utils.nextTick((function(){t.updateAutoHeight()})),t.$wrapperEl.transitionEnd((function(){n&&(t.params.loop&&"slide"===r.params.controller.by&&t.loopFix(),t.transitionEnd())})))}if(Array.isArray(n))for(a=0;a<n.length;a+=1)n[a]!==t&&n[a]instanceof Swiper&&i(n[a]);else n instanceof Swiper&&t!==n&&i(n)}},Controller$1={name:"controller",params:{controller:{control:void 0,inverse:!1,by:"slide"}},create:function(){Utils.extend(this,{controller:{control:this.params.controller.control,getInterpolateFunction:Controller.getInterpolateFunction.bind(this),setTranslate:Controller.setTranslate.bind(this),setTransition:Controller.setTransition.bind(this)}})},on:{update:function(){this.controller.control&&this.controller.spline&&(this.controller.spline=void 0,delete this.controller.spline)},resize:function(){this.controller.control&&this.controller.spline&&(this.controller.spline=void 0,delete this.controller.spline)},observerUpdate:function(){this.controller.control&&this.controller.spline&&(this.controller.spline=void 0,delete this.controller.spline)},setTranslate:function(e,t){this.controller.control&&this.controller.setTranslate(e,t)},setTransition:function(e,t){this.controller.control&&this.controller.setTransition(e,t)}}},a11y={makeElFocusable:function(e){return e.attr("tabIndex","0"),e},addElRole:function(e,t){return e.attr("role",t),e},addElLabel:function(e,t){return e.attr("aria-label",t),e},disableEl:function(e){return e.attr("aria-disabled",!0),e},enableEl:function(e){return e.attr("aria-disabled",!1),e},onEnterKey:function(e){var t=this.params.a11y;if(13===e.keyCode){var a=$(e.target);this.navigation&&this.navigation.$nextEl&&a.is(this.navigation.$nextEl)&&(this.isEnd&&!this.params.loop||this.slideNext(),this.isEnd?this.a11y.notify(t.lastSlideMessage):this.a11y.notify(t.nextSlideMessage)),this.navigation&&this.navigation.$prevEl&&a.is(this.navigation.$prevEl)&&(this.isBeginning&&!this.params.loop||this.slidePrev(),this.isBeginning?this.a11y.notify(t.firstSlideMessage):this.a11y.notify(t.prevSlideMessage)),this.pagination&&a.is("."+this.params.pagination.bulletClass)&&a[0].click()}},notify:function(e){var t=this.a11y.liveRegion;0!==t.length&&(t.html(""),t.html(e))},updateNavigation:function(){if(!this.params.loop&&this.navigation){var e=this.navigation,t=e.$nextEl,a=e.$prevEl;a&&a.length>0&&(this.isBeginning?this.a11y.disableEl(a):this.a11y.enableEl(a)),t&&t.length>0&&(this.isEnd?this.a11y.disableEl(t):this.a11y.enableEl(t))}},updatePagination:function(){var e=this,t=e.params.a11y;e.pagination&&e.params.pagination.clickable&&e.pagination.bullets&&e.pagination.bullets.length&&e.pagination.bullets.each((function(a,r){var n=$(r);e.a11y.makeElFocusable(n),e.a11y.addElRole(n,"button"),e.a11y.addElLabel(n,t.paginationBulletMessage.replace(/{{index}}/,n.index()+1))}))},init:function(){this.$el.append(this.a11y.liveRegion);var e,t,a=this.params.a11y;this.navigation&&this.navigation.$nextEl&&(e=this.navigation.$nextEl),this.navigation&&this.navigation.$prevEl&&(t=this.navigation.$prevEl),e&&(this.a11y.makeElFocusable(e),this.a11y.addElRole(e,"button"),this.a11y.addElLabel(e,a.nextSlideMessage),e.on("keydown",this.a11y.onEnterKey)),t&&(this.a11y.makeElFocusable(t),this.a11y.addElRole(t,"button"),this.a11y.addElLabel(t,a.prevSlideMessage),t.on("keydown",this.a11y.onEnterKey)),this.pagination&&this.params.pagination.clickable&&this.pagination.bullets&&this.pagination.bullets.length&&this.pagination.$el.on("keydown","."+this.params.pagination.bulletClass,this.a11y.onEnterKey)},destroy:function(){var e,t;this.a11y.liveRegion&&this.a11y.liveRegion.length>0&&this.a11y.liveRegion.remove(),this.navigation&&this.navigation.$nextEl&&(e=this.navigation.$nextEl),this.navigation&&this.navigation.$prevEl&&(t=this.navigation.$prevEl),e&&e.off("keydown",this.a11y.onEnterKey),t&&t.off("keydown",this.a11y.onEnterKey),this.pagination&&this.params.pagination.clickable&&this.pagination.bullets&&this.pagination.bullets.length&&this.pagination.$el.off("keydown","."+this.params.pagination.bulletClass,this.a11y.onEnterKey)}},A11y={name:"a11y",params:{a11y:{enabled:!0,notificationClass:"swiper-notification",prevSlideMessage:"Previous slide",nextSlideMessage:"Next slide",firstSlideMessage:"This is the first slide",lastSlideMessage:"This is the last slide",paginationBulletMessage:"Go to slide {{index}}"}},create:function(){var e=this;Utils.extend(e,{a11y:{liveRegion:$('<span class="'+e.params.a11y.notificationClass+'" aria-live="assertive" aria-atomic="true"></span>')}}),Object.keys(a11y).forEach((function(t){e.a11y[t]=a11y[t].bind(e)}))},on:{init:function(){this.params.a11y.enabled&&(this.a11y.init(),this.a11y.updateNavigation())},toEdge:function(){this.params.a11y.enabled&&this.a11y.updateNavigation()},fromEdge:function(){this.params.a11y.enabled&&this.a11y.updateNavigation()},paginationUpdate:function(){this.params.a11y.enabled&&this.a11y.updatePagination()},destroy:function(){this.params.a11y.enabled&&this.a11y.destroy()}}},Autoplay={run:function(){var e=this,t=e.slides.eq(e.activeIndex),a=e.params.autoplay.delay;t.attr("data-swiper-autoplay")&&(a=t.attr("data-swiper-autoplay")||e.params.autoplay.delay),clearTimeout(e.autoplay.timeout),e.autoplay.timeout=Utils.nextTick((function(){e.params.autoplay.reverseDirection?e.params.loop?(e.loopFix(),e.slidePrev(e.params.speed,!0,!0),e.emit("autoplay")):e.isBeginning?e.params.autoplay.stopOnLastSlide?e.autoplay.stop():(e.slideTo(e.slides.length-1,e.params.speed,!0,!0),e.emit("autoplay")):(e.slidePrev(e.params.speed,!0,!0),e.emit("autoplay")):e.params.loop?(e.loopFix(),e.slideNext(e.params.speed,!0,!0),e.emit("autoplay")):e.isEnd?e.params.autoplay.stopOnLastSlide?e.autoplay.stop():(e.slideTo(0,e.params.speed,!0,!0),e.emit("autoplay")):(e.slideNext(e.params.speed,!0,!0),e.emit("autoplay")),e.params.cssMode&&e.autoplay.running&&e.autoplay.run()}),a)},start:function(){return void 0===this.autoplay.timeout&&(!this.autoplay.running&&(this.autoplay.running=!0,this.emit("autoplayStart"),this.autoplay.run(),!0))},stop:function(){return!!this.autoplay.running&&(void 0!==this.autoplay.timeout&&(this.autoplay.timeout&&(clearTimeout(this.autoplay.timeout),this.autoplay.timeout=void 0),this.autoplay.running=!1,this.emit("autoplayStop"),!0))},pause:function(e){this.autoplay.running&&(this.autoplay.paused||(this.autoplay.timeout&&clearTimeout(this.autoplay.timeout),this.autoplay.paused=!0,0!==e&&this.params.autoplay.waitForTransition?(this.$wrapperEl[0].addEventListener("transitionend",this.autoplay.onTransitionEnd),this.$wrapperEl[0].addEventListener("webkitTransitionEnd",this.autoplay.onTransitionEnd)):(this.autoplay.paused=!1,this.autoplay.run())))}},Autoplay$1={name:"autoplay",params:{autoplay:{enabled:!1,delay:3e3,waitForTransition:!0,disableOnInteraction:!0,stopOnLastSlide:!1,reverseDirection:!1}},create:function(){var e=this;Utils.extend(e,{autoplay:{running:!1,paused:!1,run:Autoplay.run.bind(e),start:Autoplay.start.bind(e),stop:Autoplay.stop.bind(e),pause:Autoplay.pause.bind(e),onVisibilityChange:function(){"hidden"===document.visibilityState&&e.autoplay.running&&e.autoplay.pause(),"visible"===document.visibilityState&&e.autoplay.paused&&(e.autoplay.run(),e.autoplay.paused=!1)},onTransitionEnd:function(t){e&&!e.destroyed&&e.$wrapperEl&&t.target===this&&(e.$wrapperEl[0].removeEventListener("transitionend",e.autoplay.onTransitionEnd),e.$wrapperEl[0].removeEventListener("webkitTransitionEnd",e.autoplay.onTransitionEnd),e.autoplay.paused=!1,e.autoplay.running?e.autoplay.run():e.autoplay.stop())}}})},on:{init:function(){this.params.autoplay.enabled&&(this.autoplay.start(),document.addEventListener("visibilitychange",this.autoplay.onVisibilityChange))},beforeTransitionStart:function(e,t){this.autoplay.running&&(t||!this.params.autoplay.disableOnInteraction?this.autoplay.pause(e):this.autoplay.stop())},sliderFirstMove:function(){this.autoplay.running&&(this.params.autoplay.disableOnInteraction?this.autoplay.stop():this.autoplay.pause())},touchEnd:function(){this.params.cssMode&&this.autoplay.paused&&!this.params.autoplay.disableOnInteraction&&this.autoplay.run()},destroy:function(){this.autoplay.running&&this.autoplay.stop(),document.removeEventListener("visibilitychange",this.autoplay.onVisibilityChange)}}},Fade={setTranslate:function(){for(var e=this.slides,t=0;t<e.length;t+=1){var a=this.slides.eq(t),r=-a[0].swiperSlideOffset;this.params.virtualTranslate||(r-=this.translate);var n=0;this.isHorizontal()||(n=r,r=0);var i=this.params.fadeEffect.crossFade?Math.max(1-Math.abs(a[0].progress),0):1+Math.min(Math.max(a[0].progress,-1),0);a.css({opacity:i}).transform("translate3d("+r+"px, "+n+"px, 0px)")}},setTransition:function(e){var t=this,a=t.slides,r=t.$wrapperEl;if(a.transition(e),t.params.virtualTranslate&&0!==e){var n=!1;a.transitionEnd((function(){if(!n&&t&&!t.destroyed){n=!0,t.animating=!1;for(var e=["webkitTransitionEnd","transitionend"],a=0;a<e.length;a+=1)r.trigger(e[a])}}))}}},EffectFade={name:"effect-fade",params:{fadeEffect:{crossFade:!1}},create:function(){Utils.extend(this,{fadeEffect:{setTranslate:Fade.setTranslate.bind(this),setTransition:Fade.setTransition.bind(this)}})},on:{beforeInit:function(){if("fade"===this.params.effect){this.classNames.push(this.params.containerModifierClass+"fade");var e={slidesPerView:1,slidesPerColumn:1,slidesPerGroup:1,watchSlidesProgress:!0,spaceBetween:0,virtualTranslate:!0};Utils.extend(this.params,e),Utils.extend(this.originalParams,e)}},setTranslate:function(){"fade"===this.params.effect&&this.fadeEffect.setTranslate()},setTransition:function(e){"fade"===this.params.effect&&this.fadeEffect.setTransition(e)}}},Cube={setTranslate:function(){var e,t=this.$el,a=this.$wrapperEl,r=this.slides,n=this.width,i=this.height,o=this.rtlTranslate,s=this.size,l=this.params.cubeEffect,p=this.isHorizontal(),c=this.virtual&&this.params.virtual.enabled,d=0;l.shadow&&(p?(0===(e=a.find(".swiper-cube-shadow")).length&&(e=$('<div class="swiper-cube-shadow"></div>'),a.append(e)),e.css({height:n+"px"})):0===(e=t.find(".swiper-cube-shadow")).length&&(e=$('<div class="swiper-cube-shadow"></div>'),t.append(e)));for(var u=0;u<r.length;u+=1){var h=r.eq(u),f=u;c&&(f=parseInt(h.attr("data-swiper-slide-index"),10));var m=90*f,v=Math.floor(m/360);o&&(m=-m,v=Math.floor(-m/360));var g=Math.max(Math.min(h[0].progress,1),-1),b=0,y=0,w=0;f%4==0?(b=4*-v*s,w=0):(f-1)%4==0?(b=0,w=4*-v*s):(f-2)%4==0?(b=s+4*v*s,w=s):(f-3)%4==0&&(b=-s,w=3*s+4*s*v),o&&(b=-b),p||(y=b,b=0);var C="rotateX("+(p?0:-m)+"deg) rotateY("+(p?m:0)+"deg) translate3d("+b+"px, "+y+"px, "+w+"px)";if(g<=1&&g>-1&&(d=90*f+90*g,o&&(d=90*-f-90*g)),h.transform(C),l.slideShadows){var x=p?h.find(".swiper-slide-shadow-left"):h.find(".swiper-slide-shadow-top"),k=p?h.find(".swiper-slide-shadow-right"):h.find(".swiper-slide-shadow-bottom");0===x.length&&(x=$('<div class="swiper-slide-shadow-'+(p?"left":"top")+'"></div>'),h.append(x)),0===k.length&&(k=$('<div class="swiper-slide-shadow-'+(p?"right":"bottom")+'"></div>'),h.append(k)),x.length&&(x[0].style.opacity=Math.max(-g,0)),k.length&&(k[0].style.opacity=Math.max(g,0))}}if(a.css({"-webkit-transform-origin":"50% 50% -"+s/2+"px","-moz-transform-origin":"50% 50% -"+s/2+"px","-ms-transform-origin":"50% 50% -"+s/2+"px","transform-origin":"50% 50% -"+s/2+"px"}),l.shadow)if(p)e.transform("translate3d(0px, "+(n/2+l.shadowOffset)+"px, "+-n/2+"px) rotateX(90deg) rotateZ(0deg) scale("+l.shadowScale+")");else{var E=Math.abs(d)-90*Math.floor(Math.abs(d)/90),T=1.5-(Math.sin(2*E*Math.PI/360)/2+Math.cos(2*E*Math.PI/360)/2),S=l.shadowScale,M=l.shadowScale/T,P=l.shadowOffset;e.transform("scale3d("+S+", 1, "+M+") translate3d(0px, "+(i/2+P)+"px, "+-i/2/M+"px) rotateX(-90deg)")}var O=Browser.isSafari||Browser.isUiWebView?-s/2:0;a.transform("translate3d(0px,0,"+O+"px) rotateX("+(this.isHorizontal()?0:d)+"deg) rotateY("+(this.isHorizontal()?-d:0)+"deg)")},setTransition:function(e){var t=this.$el;this.slides.transition(e).find(".swiper-slide-shadow-top, .swiper-slide-shadow-right, .swiper-slide-shadow-bottom, .swiper-slide-shadow-left").transition(e),this.params.cubeEffect.shadow&&!this.isHorizontal()&&t.find(".swiper-cube-shadow").transition(e)}},EffectCube={name:"effect-cube",params:{cubeEffect:{slideShadows:!0,shadow:!0,shadowOffset:20,shadowScale:.94}},create:function(){Utils.extend(this,{cubeEffect:{setTranslate:Cube.setTranslate.bind(this),setTransition:Cube.setTransition.bind(this)}})},on:{beforeInit:function(){if("cube"===this.params.effect){this.classNames.push(this.params.containerModifierClass+"cube"),this.classNames.push(this.params.containerModifierClass+"3d");var e={slidesPerView:1,slidesPerColumn:1,slidesPerGroup:1,watchSlidesProgress:!0,resistanceRatio:0,spaceBetween:0,centeredSlides:!1,virtualTranslate:!0};Utils.extend(this.params,e),Utils.extend(this.originalParams,e)}},setTranslate:function(){"cube"===this.params.effect&&this.cubeEffect.setTranslate()},setTransition:function(e){"cube"===this.params.effect&&this.cubeEffect.setTransition(e)}}},Flip={setTranslate:function(){for(var e=this.slides,t=this.rtlTranslate,a=0;a<e.length;a+=1){var r=e.eq(a),n=r[0].progress;this.params.flipEffect.limitRotation&&(n=Math.max(Math.min(r[0].progress,1),-1));var i=-180*n,o=0,s=-r[0].swiperSlideOffset,l=0;if(this.isHorizontal()?t&&(i=-i):(l=s,s=0,o=-i,i=0),r[0].style.zIndex=-Math.abs(Math.round(n))+e.length,this.params.flipEffect.slideShadows){var p=this.isHorizontal()?r.find(".swiper-slide-shadow-left"):r.find(".swiper-slide-shadow-top"),c=this.isHorizontal()?r.find(".swiper-slide-shadow-right"):r.find(".swiper-slide-shadow-bottom");0===p.length&&(p=$('<div class="swiper-slide-shadow-'+(this.isHorizontal()?"left":"top")+'"></div>'),r.append(p)),0===c.length&&(c=$('<div class="swiper-slide-shadow-'+(this.isHorizontal()?"right":"bottom")+'"></div>'),r.append(c)),p.length&&(p[0].style.opacity=Math.max(-n,0)),c.length&&(c[0].style.opacity=Math.max(n,0))}r.transform("translate3d("+s+"px, "+l+"px, 0px) rotateX("+o+"deg) rotateY("+i+"deg)")}},setTransition:function(e){var t=this,a=t.slides,r=t.activeIndex,n=t.$wrapperEl;if(a.transition(e).find(".swiper-slide-shadow-top, .swiper-slide-shadow-right, .swiper-slide-shadow-bottom, .swiper-slide-shadow-left").transition(e),t.params.virtualTranslate&&0!==e){var i=!1;a.eq(r).transitionEnd((function(){if(!i&&t&&!t.destroyed){i=!0,t.animating=!1;for(var e=["webkitTransitionEnd","transitionend"],a=0;a<e.length;a+=1)n.trigger(e[a])}}))}}},EffectFlip={name:"effect-flip",params:{flipEffect:{slideShadows:!0,limitRotation:!0}},create:function(){Utils.extend(this,{flipEffect:{setTranslate:Flip.setTranslate.bind(this),setTransition:Flip.setTransition.bind(this)}})},on:{beforeInit:function(){if("flip"===this.params.effect){this.classNames.push(this.params.containerModifierClass+"flip"),this.classNames.push(this.params.containerModifierClass+"3d");var e={slidesPerView:1,slidesPerColumn:1,slidesPerGroup:1,watchSlidesProgress:!0,spaceBetween:0,virtualTranslate:!0};Utils.extend(this.params,e),Utils.extend(this.originalParams,e)}},setTranslate:function(){"flip"===this.params.effect&&this.flipEffect.setTranslate()},setTransition:function(e){"flip"===this.params.effect&&this.flipEffect.setTransition(e)}}},Coverflow={setTranslate:function(){for(var e=this.width,t=this.height,a=this.slides,r=this.$wrapperEl,n=this.slidesSizesGrid,i=this.params.coverflowEffect,o=this.isHorizontal(),s=this.translate,l=o?e/2-s:t/2-s,p=o?i.rotate:-i.rotate,c=i.depth,d=0,u=a.length;d<u;d+=1){var h=a.eq(d),f=n[d],m=(l-h[0].swiperSlideOffset-f/2)/f*i.modifier,v=o?p*m:0,g=o?0:p*m,b=-c*Math.abs(m),y=i.stretch;"string"==typeof y&&-1!==y.indexOf("%")&&(y=parseFloat(i.stretch)/100*f);var w=o?0:y*m,C=o?y*m:0;Math.abs(C)<.001&&(C=0),Math.abs(w)<.001&&(w=0),Math.abs(b)<.001&&(b=0),Math.abs(v)<.001&&(v=0),Math.abs(g)<.001&&(g=0);var x="translate3d("+C+"px,"+w+"px,"+b+"px)  rotateX("+g+"deg) rotateY("+v+"deg)";if(h.transform(x),h[0].style.zIndex=1-Math.abs(Math.round(m)),i.slideShadows){var k=o?h.find(".swiper-slide-shadow-left"):h.find(".swiper-slide-shadow-top"),E=o?h.find(".swiper-slide-shadow-right"):h.find(".swiper-slide-shadow-bottom");0===k.length&&(k=$('<div class="swiper-slide-shadow-'+(o?"left":"top")+'"></div>'),h.append(k)),0===E.length&&(E=$('<div class="swiper-slide-shadow-'+(o?"right":"bottom")+'"></div>'),h.append(E)),k.length&&(k[0].style.opacity=m>0?m:0),E.length&&(E[0].style.opacity=-m>0?-m:0)}}(Support.pointerEvents||Support.prefixedPointerEvents)&&(r[0].style.perspectiveOrigin=l+"px 50%")},setTransition:function(e){this.slides.transition(e).find(".swiper-slide-shadow-top, .swiper-slide-shadow-right, .swiper-slide-shadow-bottom, .swiper-slide-shadow-left").transition(e)}},EffectCoverflow={name:"effect-coverflow",params:{coverflowEffect:{rotate:50,stretch:0,depth:100,modifier:1,slideShadows:!0}},create:function(){Utils.extend(this,{coverflowEffect:{setTranslate:Coverflow.setTranslate.bind(this),setTransition:Coverflow.setTransition.bind(this)}})},on:{beforeInit:function(){"coverflow"===this.params.effect&&(this.classNames.push(this.params.containerModifierClass+"coverflow"),this.classNames.push(this.params.containerModifierClass+"3d"),this.params.watchSlidesProgress=!0,this.originalParams.watchSlidesProgress=!0)},setTranslate:function(){"coverflow"===this.params.effect&&this.coverflowEffect.setTranslate()},setTransition:function(e){"coverflow"===this.params.effect&&this.coverflowEffect.setTransition(e)}}},Thumbs={init:function(){var e=this.params.thumbs,t=this.constructor;e.swiper instanceof t?(this.thumbs.swiper=e.swiper,Utils.extend(this.thumbs.swiper.originalParams,{watchSlidesProgress:!0,slideToClickedSlide:!1}),Utils.extend(this.thumbs.swiper.params,{watchSlidesProgress:!0,slideToClickedSlide:!1})):Utils.isObject(e.swiper)&&(this.thumbs.swiper=new t(Utils.extend({},e.swiper,{watchSlidesVisibility:!0,watchSlidesProgress:!0,slideToClickedSlide:!1})),this.thumbs.swiperCreated=!0),this.thumbs.swiper.$el.addClass(this.params.thumbs.thumbsContainerClass),this.thumbs.swiper.on("tap",this.thumbs.onThumbClick)},onThumbClick:function(){var e=this.thumbs.swiper;if(e){var t=e.clickedIndex,a=e.clickedSlide;if(!(a&&$(a).hasClass(this.params.thumbs.slideThumbActiveClass)||null==t)){var r;if(r=e.params.loop?parseInt($(e.clickedSlide).attr("data-swiper-slide-index"),10):t,this.params.loop){var n=this.activeIndex;this.slides.eq(n).hasClass(this.params.slideDuplicateClass)&&(this.loopFix(),this._clientLeft=this.$wrapperEl[0].clientLeft,n=this.activeIndex);var i=this.slides.eq(n).prevAll('[data-swiper-slide-index="'+r+'"]').eq(0).index(),o=this.slides.eq(n).nextAll('[data-swiper-slide-index="'+r+'"]').eq(0).index();r=void 0===i?o:void 0===o?i:o-n<n-i?o:i}this.slideTo(r)}}},update:function(e){var t=this.thumbs.swiper;if(t){var a="auto"===t.params.slidesPerView?t.slidesPerViewDynamic():t.params.slidesPerView;if(this.realIndex!==t.realIndex){var r,n=t.activeIndex;if(t.params.loop){t.slides.eq(n).hasClass(t.params.slideDuplicateClass)&&(t.loopFix(),t._clientLeft=t.$wrapperEl[0].clientLeft,n=t.activeIndex);var i=t.slides.eq(n).prevAll('[data-swiper-slide-index="'+this.realIndex+'"]').eq(0).index(),o=t.slides.eq(n).nextAll('[data-swiper-slide-index="'+this.realIndex+'"]').eq(0).index();r=void 0===i?o:void 0===o?i:o-n==n-i?n:o-n<n-i?o:i}else r=this.realIndex;t.visibleSlidesIndexes&&t.visibleSlidesIndexes.indexOf(r)<0&&(t.params.centeredSlides?r=r>n?r-Math.floor(a/2)+1:r+Math.floor(a/2)-1:r>n&&(r=r-a+1),t.slideTo(r,e?0:void 0))}var s=1,l=this.params.thumbs.slideThumbActiveClass;if(this.params.slidesPerView>1&&!this.params.centeredSlides&&(s=this.params.slidesPerView),this.params.thumbs.multipleActiveThumbs||(s=1),s=Math.floor(s),t.slides.removeClass(l),t.params.loop||t.params.virtual&&t.params.virtual.enabled)for(var p=0;p<s;p+=1)t.$wrapperEl.children('[data-swiper-slide-index="'+(this.realIndex+p)+'"]').addClass(l);else for(var c=0;c<s;c+=1)t.slides.eq(this.realIndex+c).addClass(l)}}},Thumbs$1={name:"thumbs",params:{thumbs:{multipleActiveThumbs:!0,swiper:null,slideThumbActiveClass:"swiper-slide-thumb-active",thumbsContainerClass:"swiper-container-thumbs"}},create:function(){Utils.extend(this,{thumbs:{swiper:null,init:Thumbs.init.bind(this),update:Thumbs.update.bind(this),onThumbClick:Thumbs.onThumbClick.bind(this)}})},on:{beforeInit:function(){var e=this.params.thumbs;e&&e.swiper&&(this.thumbs.init(),this.thumbs.update(!0))},slideChange:function(){this.thumbs.swiper&&this.thumbs.update()},update:function(){this.thumbs.swiper&&this.thumbs.update()},resize:function(){this.thumbs.swiper&&this.thumbs.update()},observerUpdate:function(){this.thumbs.swiper&&this.thumbs.update()},setTransition:function(e){var t=this.thumbs.swiper;t&&t.setTransition(e)},beforeDestroy:function(){var e=this.thumbs.swiper;e&&this.thumbs.swiperCreated&&e&&e.destroy()}}};function initSwiper(e){var t=this,a=$(e);if(0!==a.length&&!a[0].swiper){var r,n,i,o={};a.hasClass("tabs-swipeable-wrap")&&(a.addClass("swiper-container").children(".tabs").addClass("swiper-wrapper").children(".tab").addClass("swiper-slide"),r=a.children(".tabs").children(".tab-active").index(),n=!0,i=a.find(".tabs-routable").length>0),a.attr("data-swiper")?o=JSON.parse(a.attr("data-swiper")):a[0].f7SwiperParams?o=a[0].f7SwiperParams:(o=a.dataset(),Object.keys(o).forEach((function(e){var t=o[e];if("string"==typeof t&&0===t.indexOf("{")&&t.indexOf("}")>0)try{o[e]=JSON.parse(t)}catch(e){}}))),void 0===o.initialSlide&&void 0!==r&&(o.initialSlide=r);var s=t.swiper.create(a[0],o);a.parents(".popup, .login-screen, .sheet-modal, .popover").on("modal:open",l),a.parents(".panel").on("panel:open",l),a.parents(".tab").on("tab:show",l),s.on("beforeDestroy",(function(){a.parents(".popup, .login-screen, .sheet-modal, .popover").off("modal:open",l),a.parents(".panel").off("panel:open",l),a.parents(".tab").off("tab:show",l)})),n&&s.on("slideChange",(function(){if(i){var e=t.views.get(a.parents(".view"));e||(e=t.views.main);var r=e.router,n=r.findTabRoute(s.slides.eq(s.activeIndex)[0]);n&&setTimeout((function(){r.navigate(n.path)}),0)}else t.tab.show({tabEl:s.slides.eq(s.activeIndex)})}))}function l(){s.update()}}Swiper.use([Device$1,Browser$1,Support$1,Resize,Observer$1,Virtual$1,Keyboard$1,Mousewheel$1,Navigation$1,Pagination$1,Scrollbar$1,Parallax$1,Zoom$1,Lazy$3,Controller$1,A11y,Autoplay$1,EffectFade,EffectCube,EffectFlip,EffectCoverflow,Thumbs$1]),window.Swiper||(window.Swiper=Swiper);var Swiper$1={name:"swiper",static:{Swiper:Swiper},create:function(){this.swiper=ConstructorMethods({defaultSelector:".swiper-container",constructor:Swiper,domProp:"swiper"})},on:{pageBeforeRemove:function(e){var t=this;e.$el.find(".swiper-init, .tabs-swipeable-wrap").each((function(e,a){t.swiper.destroy(a)}))},pageMounted:function(e){var t=this;e.$el.find(".tabs-swipeable-wrap").each((function(e,a){initSwiper.call(t,a)}))},pageInit:function(e){var t=this;e.$el.find(".swiper-init, .tabs-swipeable-wrap").each((function(e,a){initSwiper.call(t,a)}))},pageReinit:function(e){var t=this;e.$el.find(".swiper-init, .tabs-swipeable-wrap").each((function(e,a){var r=t.swiper.get(a);r&&r.update&&r.update()}))},tabMounted:function(e){var t=this;$(e).find(".swiper-init, .tabs-swipeable-wrap").each((function(e,a){initSwiper.call(t,a)}))},tabShow:function(e){var t=this;$(e).find(".swiper-init, .tabs-swipeable-wrap").each((function(e,a){var r=t.swiper.get(a);r&&r.update&&r.update()}))},tabBeforeRemove:function(e){var t=this;$(e).find(".swiper-init, .tabs-swipeable-wrap").each((function(e,a){t.swiper.destroy(a)}))}},vnode:{"swiper-init":{insert:function(e){var t=e.elm;initSwiper.call(this,t)},destroy:function(e){var t=e.elm;this.swiper.destroy(t)}},"tabs-swipeable-wrap":{insert:function(e){var t=e.elm;initSwiper.call(this,t)},destroy:function(e){var t=e.elm;this.swiper.destroy(t)}}}},PhotoBrowser=function(e){function t(t,a){void 0===a&&(a={}),e.call(this,a,[t]);var r=this;r.app=t;var n=Utils.extend({on:{}},t.params.photoBrowser);r.useModulesParams(n),r.params=Utils.extend(n,a),Utils.extend(r,{exposed:!1,opened:!1,activeIndex:r.params.swiper.initialSlide,url:r.params.url,swipeToClose:{allow:!0,isTouched:!1,diff:void 0,start:void 0,current:void 0,started:!1,activeSlide:void 0,timeStart:void 0}}),r.useModules(),r.init()}e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t;var a={view:{configurable:!0}};return a.view.get=function(){var e=this.params,t=this.app;return e.view||t.views.main},t.prototype.onSlideChange=function(e){var t=this;t.activeIndex=e.activeIndex;var a=e.activeIndex+1,r=t.params.virtualSlides?t.params.photos.length:e.slides.length;e.params.loop&&(r-=2,(a-=e.loopedSlides)<1&&(a=r+a),a>r&&(a-=r));var n,i=t.params.virtualSlides?e.$wrapperEl.find('.swiper-slide[data-swiper-slide-index="'+e.activeIndex+'"]'):e.slides.eq(e.activeIndex),o=t.params.virtualSlides?e.$wrapperEl.find('.swiper-slide[data-swiper-slide-index="'+e.previousIndex+'"]'):e.slides.eq(e.previousIndex),s=t.$el.find(".photo-browser-current"),l=t.$el.find(".photo-browser-total");if("page"===t.params.type&&t.params.navbar&&0===s.length&&"ios"===t.app.theme&&(n=t.app.navbar.getElByPage(t.$el))&&(s=$(n).find(".photo-browser-current"),l=$(n).find(".photo-browser-total")),s.length&&l.length&&(s.text(a),l.text(r),n||(n=s.parents(".navbar")[0]),n&&t.app.navbar.size(n)),t.captions.length>0){var p=e.params.loop?i.attr("data-swiper-slide-index"):t.activeIndex;t.$captionsContainerEl.find(".photo-browser-caption-active").removeClass("photo-browser-caption-active"),t.$captionsContainerEl.find('[data-caption-index="'+p+'"]').addClass("photo-browser-caption-active")}var c=o.find("video");c.length>0&&"pause"in c[0]&&c[0].pause()},t.prototype.onTouchStart=function(){var e=this.swipeToClose;e.allow&&(e.isTouched=!0)},t.prototype.onTouchMove=function(e){var t=this,a=t.swipeToClose;a.isTouched&&(a.started||(a.started=!0,a.start="touchmove"===e.type?e.targetTouches[0].pageY:e.pageY,t.params.virtualSlides?a.activeSlide=t.swiper.$wrapperEl.children(".swiper-slide-active"):a.activeSlide=t.swiper.slides.eq(t.swiper.activeIndex),a.timeStart=Utils.now()),e.preventDefault(),a.current="touchmove"===e.type?e.targetTouches[0].pageY:e.pageY,a.diff=a.start-a.current,t.$el.transition(0).transform("translate3d(0,"+-a.diff+"px,0)"))},t.prototype.onTouchEnd=function(){var e=this,t=e.swipeToClose;if(t.isTouched=!1,t.started){t.started=!1,t.allow=!1;var a=Math.abs(t.diff),r=(new Date).getTime()-t.timeStart;r<300&&a>20||r>=300&&a>100?Utils.nextTick((function(){e.$el&&(t.diff<0?e.$el.addClass("swipe-close-to-bottom"):e.$el.addClass("swipe-close-to-top")),e.emit("local::swipeToClose",e),e.$el.transform("").transition(""),e.close(),t.allow=!0})):(0!==a?e.$el.addClass("photo-browser-transitioning").transitionEnd((function(){t.allow=!0,e.$el.removeClass("photo-browser-transitioning")})):t.allow=!0,Utils.nextTick((function(){e.$el.transform("").transition("")})))}else t.started=!1},t.prototype.renderNavbar=function(){var e=this;if(e.params.renderNavbar)return e.params.renderNavbar.call(e);var t=e.params.iconsColor;e.params.iconsColor||"dark"!==e.params.theme||(t="white");var a="ios"!==e.app.theme&&"aurora"!==e.app.theme||!e.params.pageBackLinkText?"":e.params.pageBackLinkText,r=void 0===e.params.navbarShowCount?e.params.photos.length>1:e.params.navbarShowCount,n="page"!==e.params.type;return('\n      <div class="navbar navbar-photo-browser '+("dark"===e.params.theme?"navbar-photo-browser-dark":"")+'">\n        <div class="navbar-bg"></div>\n        <div class="navbar-inner navbar-inner-centered-title sliding">\n          '+(n?"":'\n          <div class="left">\n            <a class="link '+(a?"":"icon-only")+' back">\n              <i class="icon icon-back '+(t?"color-"+t:"")+'"></i>\n              '+(a?"<span>"+a+"</span>":"")+"\n            </a>\n          </div>\n          ")+"\n          "+(r?'\n          <div class="title">\n            <span class="photo-browser-current"></span>\n            <span class="photo-browser-of">'+e.params.navbarOfText+'</span>\n            <span class="photo-browser-total"></span>\n          </div>\n          ':"")+"\n          "+(n?'\n          <div class="right">\n            <a class="link popup-close" data-popup=".photo-browser-popup">\n              <span>'+e.params.popupCloseLinkText+"</span>\n            </a>\n          </div>\n          ":"")+"\n        </div>\n      </div>\n    ").trim()},t.prototype.renderToolbar=function(){var e=this;if(e.params.renderToolbar)return e.params.renderToolbar.call(e);var t=e.params.iconsColor;return e.params.iconsColor||"dark"!==e.params.theme||(t="white"),('\n      <div class="toolbar toolbar-bottom tabbar">\n        <div class="toolbar-inner">\n          <a class="link photo-browser-prev">\n            <i class="icon icon-back '+(t?"color-"+t:"")+'"></i>\n          </a>\n          <a class="link photo-browser-next">\n            <i class="icon icon-forward '+(t?"color-"+t:"")+'"></i>\n          </a>\n        </div>\n      </div>\n    ').trim()},t.prototype.renderCaption=function(e,t){return this.params.renderCaption?this.params.renderCaption.call(this,e,t):('\n      <div class="photo-browser-caption" data-caption-index="'+t+'">\n        '+e+"\n      </div>\n    ").trim()},t.prototype.renderObject=function(e,t){return this.params.renderObject?this.params.renderObject.call(this,e,t):'\n      <div class="photo-browser-slide photo-browser-object-slide swiper-slide" data-swiper-slide-index="'+t+'">'+(e.html?e.html:e)+"</div>\n    "},t.prototype.renderLazyPhoto=function(e,t){return this.params.renderLazyPhoto?this.params.renderLazyPhoto.call(this,e,t):('\n      <div class="photo-browser-slide photo-browser-slide-lazy swiper-slide" data-swiper-slide-index="'+t+'">\n          <div class="swiper-lazy-preloader"></div>\n          <span class="swiper-zoom-container">\n              <img data-src="'+(e.url?e.url:e)+'" class="swiper-lazy">\n          </span>\n      </div>\n    ').trim()},t.prototype.renderPhoto=function(e,t){return this.params.renderPhoto?this.params.renderPhoto.call(this,e,t):('\n      <div class="photo-browser-slide swiper-slide" data-swiper-slide-index="'+t+'">\n        <span class="swiper-zoom-container">\n          <img src="'+(e.url?e.url:e)+'">\n        </span>\n      </div>\n    ').trim()},t.prototype.render=function(){var e=this;return e.params.render?e.params.render.call(e,e.params):('\n      <div class="photo-browser photo-browser-'+e.params.theme+'">\n        <div class="view">\n          <div class="page photo-browser-page photo-browser-page-'+e.params.theme+" no-toolbar "+(e.params.navbar?"":"no-navbar")+'" data-name="photo-browser-page">\n            '+(e.params.navbar?e.renderNavbar():"")+"\n            "+(e.params.toolbar?e.renderToolbar():"")+'\n            <div class="photo-browser-captions photo-browser-captions-'+(e.params.captionsTheme||e.params.theme)+'">\n              '+e.params.photos.map((function(t,a){return t.caption?e.renderCaption(t.caption,a):""})).join(" ")+'\n            </div>\n            <div class="photo-browser-swiper-container swiper-container">\n              <div class="photo-browser-swiper-wrapper swiper-wrapper">\n                '+(e.params.virtualSlides?"":e.params.photos.map((function(t,a){return t.html||("string"==typeof t||t instanceof String)&&t.indexOf("<")>=0&&t.indexOf(">")>=0?e.renderObject(t,a):!0===e.params.swiper.lazy||e.params.swiper.lazy&&e.params.swiper.lazy.enabled?e.renderLazyPhoto(t,a):e.renderPhoto(t,a)})).join(" "))+"\n              </div>\n            </div>\n          </div>\n        </div>\n      </div>\n    ").trim()},t.prototype.renderStandalone=function(){return this.params.renderStandalone?this.params.renderStandalone.call(this):'<div class="popup photo-browser-popup photo-browser-standalone popup-tablet-fullscreen">'+this.render()+"</div>"},t.prototype.renderPage=function(){return this.params.renderPage?this.params.renderPage.call(this):this.render()},t.prototype.renderPopup=function(){return this.params.renderPopup?this.params.renderPopup.call(this):'<div class="popup photo-browser-popup">'+this.render()+"</div>"},t.prototype.onOpen=function(e,t){var a,r=this,n=r.app,i=$(t);i[0].f7PhotoBrowser=r,r.$el=i,r.el=i[0],r.openedIn=e,r.opened=!0,r.$swiperContainerEl=r.$el.find(".photo-browser-swiper-container"),r.$swiperWrapperEl=r.$el.find(".photo-browser-swiper-wrapper"),r.slides=r.$el.find(".photo-browser-slide"),r.$captionsContainerEl=r.$el.find(".photo-browser-captions"),r.captions=r.$el.find(".photo-browser-caption");var o=Utils.extend({},r.params.swiper,{initialSlide:r.activeIndex,on:{click:function(e){clearTimeout(a),r.params.exposition&&(a=setTimeout((function(){r.expositionToggle()}),350)),r.emit("local::tap",e),r.emit("local::click",e)},doubleClick:function(e){clearTimeout(a),r.emit("local::doubleTap",e),r.emit("local::doubleClick",e)},slideChange:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];var a=this;r.onSlideChange(a),r.emit.apply(r,["local::slideChange"].concat(e))},transitionStart:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];r.emit.apply(r,["local::transitionStart"].concat(e))},transitionEnd:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];r.emit.apply(r,["local::transitionEnd"].concat(e))},slideChangeTransitionStart:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];var a=this;r.onSlideChange(a),r.emit.apply(r,["local::slideChangeTransitionStart"].concat(e))},slideChangeTransitionEnd:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];r.emit.apply(r,["local::slideChangeTransitionEnd"].concat(e))},lazyImageLoad:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];r.emit.apply(r,["local::lazyImageLoad"].concat(e))},lazyImageReady:function(){for(var e=[],t=arguments.length;t--;)e[t]=arguments[t];var a=e[0];$(a).removeClass("photo-browser-slide-lazy"),r.emit.apply(r,["local::lazyImageReady"].concat(e))}}});r.params.swipeToClose&&"page"!==r.params.type&&Utils.extend(o.on,{touchStart:function(e){r.onTouchStart(e),r.emit("local::touchStart",e)},touchMoveOpposite:function(e){r.onTouchMove(e),r.emit("local::touchMoveOpposite",e)},touchEnd:function(e){r.onTouchEnd(e),r.emit("local::touchEnd",e)}}),r.params.virtualSlides&&Utils.extend(o,{virtual:{slides:r.params.photos,renderSlide:function(e,t){return e.html||("string"==typeof e||e instanceof String)&&e.indexOf("<")>=0&&e.indexOf(">")>=0?r.renderObject(e,t):!0===r.params.swiper.lazy||r.params.swiper.lazy&&r.params.swiper.lazy.enabled?r.renderLazyPhoto(e,t):r.renderPhoto(e,t)}}}),r.swiper=n.swiper.create(r.$swiperContainerEl,o),0===r.activeIndex&&r.onSlideChange(r.swiper),r.$el&&r.$el.trigger("photobrowser:open"),r.emit("local::open photoBrowserOpen",r)},t.prototype.onOpened=function(){var e=this;e.$el&&"standalone"===e.params.type&&e.$el.css("animation","none"),e.$el&&e.$el.trigger("photobrowser:opened"),e.emit("local::opened photoBrowserOpened",e)},t.prototype.onClose=function(){var e=this;e.destroyed||(e.swiper&&e.swiper.destroy&&(e.swiper.destroy(!0,!1),e.swiper=null,delete e.swiper),e.$el&&e.$el.trigger("photobrowser:close"),e.emit("local::close photoBrowserClose",e))},t.prototype.onClosed=function(){var e=this;e.destroyed||(e.opened=!1,e.$el=null,e.el=null,delete e.$el,delete e.el,e.$el&&e.$el.trigger("photobrowser:closed"),e.emit("local::closed photoBrowserClosed",e))},t.prototype.openPage=function(){var e=this;if(e.opened)return e;var t=e.renderPage();return e.view.router.navigate({url:e.url,route:{content:t,path:e.url,on:{pageBeforeIn:function(t,a){e.view.$el.addClass("with-photo-browser-page with-photo-browser-page-"+e.params.theme),e.onOpen("page",a.el)},pageAfterIn:function(t,a){e.onOpened("page",a.el)},pageBeforeOut:function(t,a){e.view.$el.removeClass("with-photo-browser-page with-photo-browser-page-exposed with-photo-browser-page-"+e.params.theme),e.onClose("page",a.el)},pageAfterOut:function(t,a){e.onClosed("page",a.el)}}}}),e},t.prototype.openStandalone=function(){var e=this;if(e.opened)return e;var t={backdrop:!1,content:e.renderStandalone(),on:{popupOpen:function(t){e.onOpen("popup",t.el)},popupOpened:function(t){e.onOpened("popup",t.el)},popupClose:function(t){e.onClose("popup",t.el)},popupClosed:function(t){e.onClosed("popup",t.el)}}};return e.params.routableModals&&e.view?e.view.router.navigate({url:e.url,route:{path:e.url,popup:t}}):e.modal=e.app.popup.create(t).open(),e},t.prototype.openPopup=function(){var e=this;if(e.opened)return e;var t={content:e.renderPopup(),push:e.params.popupPush,on:{popupOpen:function(t){e.onOpen("popup",t.el)},popupOpened:function(t){e.onOpened("popup",t.el)},popupClose:function(t){e.onClose("popup",t.el)},popupClosed:function(t){e.onClosed("popup",t.el)}}};return e.params.routableModals&&e.view?e.view.router.navigate({url:e.url,route:{path:e.url,popup:t}}):e.modal=e.app.popup.create(t).open(),e},t.prototype.expositionEnable=function(){var e=this;return"page"===e.params.type&&e.view.$el.addClass("with-photo-browser-page-exposed"),e.$el&&e.$el.addClass("photo-browser-exposed"),e.params.expositionHideCaptions&&e.$captionsContainerEl.addClass("photo-browser-captions-exposed"),e.exposed=!0,e},t.prototype.expositionDisable=function(){var e=this;return"page"===e.params.type&&e.view.$el.removeClass("with-photo-browser-page-exposed"),e.$el&&e.$el.removeClass("photo-browser-exposed"),e.params.expositionHideCaptions&&e.$captionsContainerEl.removeClass("photo-browser-captions-exposed"),e.exposed=!1,e},t.prototype.expositionToggle=function(){var e=this;return"page"===e.params.type&&e.view.$el.toggleClass("with-photo-browser-page-exposed"),e.$el&&e.$el.toggleClass("photo-browser-exposed"),e.params.expositionHideCaptions&&e.$captionsContainerEl.toggleClass("photo-browser-captions-exposed"),e.exposed=!e.exposed,e},t.prototype.open=function(e){var t=this,a=t.params.type;return t.opened?(t.swiper&&void 0!==e&&t.swiper.slideTo(parseInt(e,10)),t):(void 0!==e&&(t.activeIndex=e),"standalone"===a&&t.openStandalone(),"page"===a&&t.openPage(),"popup"===a&&t.openPopup(),t)},t.prototype.close=function(){var e=this;return e.opened?(e.params.routableModals&&e.view||"page"===e.openedIn?e.view.router.back():(e.modal.once("modalClosed",(function(){Utils.nextTick((function(){e.destroyed||(e.modal.destroy(),delete e.modal)}))})),e.modal.close()),e):e},t.prototype.init=function(){},t.prototype.destroy=function(){var e=this;e.emit("local::beforeDestroy photoBrowserBeforeDestroy",e),e.$el&&(e.$el.trigger("photobrowser:beforedestroy"),e.$el[0].f7PhotoBrowser=null,delete e.$el[0].f7PhotoBrowser),Utils.deleteProps(e),e.destroyed=!0,e=null},Object.defineProperties(t.prototype,a),t}(Framework7Class),PhotoBrowser$1={name:"photoBrowser",params:{photoBrowser:{photos:[],exposition:!0,expositionHideCaptions:!1,type:"standalone",navbar:!0,toolbar:!0,theme:"light",captionsTheme:void 0,iconsColor:void 0,popupPush:!1,swipeToClose:!0,pageBackLinkText:"Back",popupCloseLinkText:"Close",navbarOfText:"of",navbarShowCount:void 0,view:void 0,url:"photos/",routableModals:!0,virtualSlides:!0,renderNavbar:void 0,renderToolbar:void 0,renderCaption:void 0,renderObject:void 0,renderLazyPhoto:void 0,renderPhoto:void 0,renderPage:void 0,renderPopup:void 0,renderStandalone:void 0,swiper:{initialSlide:0,spaceBetween:20,speed:300,loop:!1,preloadImages:!0,navigation:{nextEl:".photo-browser-next",prevEl:".photo-browser-prev"},zoom:{enabled:!0,maxRatio:3,minRatio:1},lazy:{enabled:!0}}}},create:function(){this.photoBrowser=ConstructorMethods({defaultSelector:".photo-browser-popup, .photo-browser-page",constructor:PhotoBrowser,app:this,domProp:"f7PhotoBrowser"})},static:{PhotoBrowser:PhotoBrowser}},Notification=function(e){function t(t,a){var r=Utils.extend({on:{}},t.params.notification,a);e.call(this,t,r);var n=this;n.app=t,n.params=r;var i,o,s,l,p,c,d,u=n.params,h=u.icon,f=u.title,m=u.titleRightText,v=u.subtitle,g=u.text,b=u.closeButton,y=u.closeTimeout,w=u.cssClass,C=u.closeOnClick;if(n.params.el)i=$(n.params.el);else{var x=n.render({icon:h,title:f,titleRightText:m,subtitle:v,text:g,closeButton:b,cssClass:w});i=$(x)}if(i&&i.length>0&&i[0].f7Modal)return i[0].f7Modal;if(0===i.length)return n.destroy();Utils.extend(n,{$el:i,el:i[0],type:"notification"}),i[0].f7Modal=n,b&&i.find(".notification-close-button").on("click",(function(){n.close()})),i.on("click",(function(e){b&&$(e.target).closest(".notification-close-button").length||(n.emit("local::click notificationClick",n),C&&n.close())})),n.on("beforeDestroy",(function(){i.off("click")}));var k,E={};function T(e){o||(o=!0,s=!1,l=void 0,c=Utils.now(),E.x="touchstart"===e.type?e.targetTouches[0].pageX:e.pageX,E.y="touchstart"===e.type?e.targetTouches[0].pageY:e.pageY)}function S(e){if(o){var t="touchmove"===e.type?e.targetTouches[0].pageX:e.pageX,a="touchmove"===e.type?e.targetTouches[0].pageY:e.pageY;if(void 0===l&&(l=!!(l||Math.abs(a-E.y)<Math.abs(t-E.x))),l)o=!1;else{e.preventDefault(),s||(n.$el.removeClass("notification-transitioning"),n.$el.transition(0),d=n.$el[0].offsetHeight/2),s=!0;var r=p=a-E.y;p>0&&(r=Math.pow(p,.8)),n.$el.transform("translate3d(0, "+r+"px, 0)")}}}function M(){if(!o||!s)return o=!1,void(s=!1);if(o=!1,s=!1,0!==p){var e=Utils.now()-c;n.$el.transition(""),n.$el.addClass("notification-transitioning"),n.$el.transform(""),(p<-10&&e<300||-p>=d/1)&&n.close()}}return n.on("open",(function(){n.params.swipeToClose&&(n.$el.on(t.touchEvents.start,T,{passive:!0}),t.on("touchmove:active",S),t.on("touchend:passive",M)),$(".notification.modal-in").each((function(e,a){var r=t.notification.get(a);a!==n.el&&r&&r.close()})),y&&function e(){k=Utils.nextTick((function(){o&&s?e():n.close()}),y)}()})),n.on("close beforeDestroy",(function(){n.params.swipeToClose&&(n.$el.off(t.touchEvents.start,T,{passive:!0}),t.off("touchmove:active",S),t.off("touchend:passive",M)),win.clearTimeout(k)})),n}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t.prototype.render=function(){if(this.params.render)return this.params.render.call(this,this);var e=this.params,t=e.icon,a=e.title,r=e.titleRightText,n=e.subtitle,i=e.text,o=e.closeButton;return('\n      <div class="notification '+(e.cssClass||"")+'">\n        <div class="notification-header">\n          '+(t?'<div class="notification-icon">'+t+"</div>":"")+"\n          "+(a?'<div class="notification-title">'+a+"</div>":"")+"\n          "+(r?'<div class="notification-title-right-text">'+r+"</div>":"")+"\n          "+(o?'<span class="notification-close-button"></span>':"")+'\n        </div>\n        <div class="notification-content">\n          '+(n?'<div class="notification-subtitle">'+n+"</div>":"")+"\n          "+(i?'<div class="notification-text">'+i+"</div>":"")+"\n        </div>\n      </div>\n    ").trim()},t}(Modal),Notification$1={name:"notification",static:{Notification:Notification},create:function(){this.notification=Utils.extend({},ModalMethods({app:this,constructor:Notification,defaultSelector:".notification.modal-in"}))},params:{notification:{icon:null,title:null,titleRightText:null,subtitle:null,text:null,closeButton:!1,closeTimeout:null,closeOnClick:!1,swipeToClose:!0,cssClass:null,render:null}}},Autocomplete=function(e){function t(t,a){void 0===a&&(a={}),e.call(this,a,[t]);var r=this;r.app=t;var n,i,o=Utils.extend({on:{}},t.params.autocomplete);void 0===o.searchbarDisableButton&&(o.searchbarDisableButton="aurora"!==t.theme),r.useModulesParams(o),r.params=Utils.extend(o,a),r.params.openerEl&&(n=$(r.params.openerEl)).length&&(n[0].f7Autocomplete=r),r.params.inputEl&&(i=$(r.params.inputEl)).length&&(i[0].f7Autocomplete=r);var s=Utils.id(),l=a.url;!l&&n&&n.length&&(n.attr("href")?l=n.attr("href"):n.find("a").length>0&&(l=n.find("a").attr("href"))),l&&"#"!==l&&""!==l||(l=r.params.url);var p=r.params.multiple?"checkbox":"radio";Utils.extend(r,{$openerEl:n,openerEl:n&&n[0],$inputEl:i,inputEl:i&&i[0],id:s,url:l,value:r.params.value||[],inputType:p,inputName:p+"-"+s,$modalEl:void 0,$dropdownEl:void 0});var c="";function d(){var e=r.$inputEl.val().trim();r.params.source&&r.params.source.call(r,e,(function(t){var a,n,o,s="",l=r.params.limit?Math.min(r.params.limit,t.length):t.length;r.items=t,r.params.highlightMatches&&(e=e.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g,"\\$&"),a=new RegExp("("+e+")","i"));for(var p=0;p<l;p+=1){var d="object"==typeof t[p]?t[p][r.params.valueProperty]:t[p],u="object"==typeof t[p]?t[p][r.params.textProperty]:t[p];0===p&&(n=d,o=r.items[p]),s+=r.renderItem({value:d,text:r.params.highlightMatches?u.replace(a,"<b>$1</b>"):u},p)}if(""===s&&""===e&&r.params.dropdownPlaceholderText&&(s+=r.renderItem({placeholder:!0,text:r.params.dropdownPlaceholderText})),r.$dropdownEl.find("ul").html(s),r.params.typeahead){if(!n||!o)return;if(0!==n.toLowerCase().indexOf(e.toLowerCase()))return;if(c.toLowerCase()===e.toLowerCase())return void(r.value=[]);if(0===c.toLowerCase().indexOf(e.toLowerCase()))return c=e,void(r.value=[]);i.val(n),i[0].setSelectionRange(e.length,n.length);var h="object"==typeof r.value[0]?r.value[0][r.params.valueProperty]:r.value[0];h&&n.toLowerCase()===h.toLowerCase()||(r.value=[o],r.emit("local::change autocompleteChange",[o]))}c=e}))}function u(){var e,t,a,n=this.value;if($(this).parents(".autocomplete-values").length>0){if("checkbox"===r.inputType&&!this.checked){for(var i=0;i<r.value.length;i+=1)(a="string"==typeof r.value[i]?r.value[i]:r.value[i][r.params.valueProperty])!==n&&1*a!=1*n||r.value.splice(i,1);r.updateValues(),r.emit("local::change autocompleteChange",r.value)}}else{for(var o=0;o<r.items.length;o+=1)(t="object"==typeof r.items[o]?r.items[o][r.params.valueProperty]:r.items[o])!==n&&1*t!=1*n||(e=r.items[o]);if("radio"===r.inputType)r.value=[e];else if(this.checked)r.value.push(e);else for(var s=0;s<r.value.length;s+=1)(a="object"==typeof r.value[s]?r.value[s][r.params.valueProperty]:r.value[s])!==n&&1*a!=1*n||r.value.splice(s,1);r.updateValues(),("radio"===r.inputType&&this.checked||"checkbox"===r.inputType)&&r.emit("local::change autocompleteChange",r.value)}}function h(e){var t=$(e.target);t.is(r.$inputEl[0])||r.$dropdownEl&&t.closest(r.$dropdownEl[0]).length||r.close()}function f(){r.open()}function m(){r.open()}function v(){r.$dropdownEl.find("label.active-state").length>0||setTimeout((function(){r.close()}),0)}function g(){r.positionDropdown()}function b(e){if(r.opened){if(27===e.keyCode)return e.preventDefault(),void r.$inputEl.blur();if(13===e.keyCode){var t=r.$dropdownEl.find(".autocomplete-dropdown-selected label");return t.length?(e.preventDefault(),t.trigger("click"),void r.$inputEl.blur()):void(r.params.typeahead&&(e.preventDefault(),r.$inputEl.blur()))}if(40===e.keyCode||38===e.keyCode){e.preventDefault();var a,n=r.$dropdownEl.find(".autocomplete-dropdown-selected");n.length&&(a=n[40===e.keyCode?"next":"prev"]("li")).length||(a=r.$dropdownEl.find("li").eq(40===e.keyCode?0:r.$dropdownEl.find("li").length-1)),a.hasClass("autocomplete-dropdown-placeholder")||(n.removeClass("autocomplete-dropdown-selected"),a.addClass("autocomplete-dropdown-selected"))}}}function y(){for(var e,t=$(this),a=0;a<r.items.length;a+=1){var n="object"==typeof r.items[a]?r.items[a][r.params.valueProperty]:r.items[a],i=t.attr("data-value");n!==i&&1*n!=1*i||(e=r.items[a])}r.params.updateInputValueOnSelect&&(r.$inputEl.val("object"==typeof e?e[r.params.valueProperty]:e),r.$inputEl.trigger("input change")),r.value=[e],r.emit("local::change autocompleteChange",[e]),r.close()}return r.attachEvents=function(){"dropdown"!==r.params.openIn&&r.$openerEl&&r.$openerEl.on("click",f),"dropdown"===r.params.openIn&&r.$inputEl&&(r.$inputEl.on("focus",m),r.$inputEl.on(r.params.inputEvents,d),t.device.android?$("html").on("click",h):r.$inputEl.on("blur",v),r.$inputEl.on("keydown",b))},r.detachEvents=function(){"dropdown"!==r.params.openIn&&r.$openerEl&&r.$openerEl.off("click",f),"dropdown"===r.params.openIn&&r.$inputEl&&(r.$inputEl.off("focus",m),r.$inputEl.off(r.params.inputEvents,d),t.device.android?$("html").off("click",h):r.$inputEl.off("blur",v),r.$inputEl.off("keydown",b))},r.attachDropdownEvents=function(){r.$dropdownEl.on("click","label",y),t.on("resize",g)},r.detachDropdownEvents=function(){r.$dropdownEl.off("click","label",y),t.off("resize",g)},r.attachPageEvents=function(){r.$el.on("change",'input[type="radio"], input[type="checkbox"]',u),r.params.closeOnSelect&&!r.params.multiple&&r.$el.once("click",".list label",(function(){Utils.nextTick((function(){r.close()}))}))},r.detachPageEvents=function(){r.$el.off("change",'input[type="radio"], input[type="checkbox"]',u)},r.useModules(),r.init(),r}e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t;var a={view:{configurable:!0}};return a.view.get=function(){var e,t=this,a=t.$openerEl,r=t.$inputEl,n=t.app;if(t.params.view)e=t.params.view;else if(a||r){var i=a||r;e=i.closest(".view").length&&i.closest(".view")[0].f7View}return e||(e=n.views.main),e},t.prototype.positionDropdown=function(){var e,t=this,a=t.$inputEl,r=t.app,n=t.$dropdownEl,i=a.parents(".page-content");if(0!==i.length){var o,s=a.offset(),l=a[0].offsetWidth,p=a[0].offsetHeight,c=a.parents(".list");c.parents().each((function(e,t){if(!o){var a=$(t);a.parent(i).length&&(o=a)}}));var d,u=c.offset(),h=parseInt(i.css("padding-bottom"),10),f=c.length>0?u.left-i.offset().left:0,m=s.left-(c.length>0?u.left:0)-(r.rtl,0),v=s.top-(i.offset().top-i[0].scrollTop),g=i[0].scrollHeight-h-(v+i[0].scrollTop)-a[0].offsetHeight,b=r.rtl?"padding-right":"padding-left";c.length&&!t.params.expandInput&&(d=(r.rtl?c[0].offsetWidth-m-l:m)-("md"===r.theme?16:15)),n.css({left:(c.length>0?f:m)+"px",top:v+i[0].scrollTop+p+"px",width:(c.length>0?c[0].offsetWidth:l)+"px"}),n.children(".autocomplete-dropdown-inner").css(((e={maxHeight:g+"px"})[b]=c.length>0&&!t.params.expandInput?d+"px":"",e))}},t.prototype.focus=function(){this.$el.find("input[type=search]").focus()},t.prototype.source=function(e){var t=this;if(t.params.source){var a=t.$el;t.params.source.call(t,e,(function(r){var n="",i=t.params.limit?Math.min(t.params.limit,r.length):r.length;t.items=r;for(var o=0;o<i;o+=1){for(var s=!1,l="object"==typeof r[o]?r[o][t.params.valueProperty]:r[o],p=0;p<t.value.length;p+=1){var c="object"==typeof t.value[p]?t.value[p][t.params.valueProperty]:t.value[p];c!==l&&1*c!=1*l||(s=!0)}n+=t.renderItem({value:l,text:"object"==typeof r[o]?r[o][t.params.textProperty]:r[o],inputType:t.inputType,id:t.id,inputName:t.inputName,selected:s},o)}a.find(".autocomplete-found ul").html(n),0===r.length?0!==e.length?(a.find(".autocomplete-not-found").show(),a.find(".autocomplete-found, .autocomplete-values").hide()):(a.find(".autocomplete-values").show(),a.find(".autocomplete-found, .autocomplete-not-found").hide()):(a.find(".autocomplete-found").show(),a.find(".autocomplete-not-found, .autocomplete-values").hide())}))}},t.prototype.updateValues=function(){for(var e=this,t="",a=0;a<e.value.length;a+=1)t+=e.renderItem({value:"object"==typeof e.value[a]?e.value[a][e.params.valueProperty]:e.value[a],text:"object"==typeof e.value[a]?e.value[a][e.params.textProperty]:e.value[a],inputType:e.inputType,id:e.id,inputName:e.inputName+"-checked}",selected:!0},a);e.$el.find(".autocomplete-values ul").html(t)},t.prototype.preloaderHide=function(){"dropdown"===this.params.openIn&&this.$dropdownEl?this.$dropdownEl.find(".autocomplete-preloader").removeClass("autocomplete-preloader-visible"):$(".autocomplete-preloader").removeClass("autocomplete-preloader-visible")},t.prototype.preloaderShow=function(){"dropdown"===this.params.openIn&&this.$dropdownEl?this.$dropdownEl.find(".autocomplete-preloader").addClass("autocomplete-preloader-visible"):$(".autocomplete-preloader").addClass("autocomplete-preloader-visible")},t.prototype.renderPreloader=function(){return('\n      <div class="autocomplete-preloader preloader '+(this.params.preloaderColor?"color-"+this.params.preloaderColor:"")+'">'+(Utils[this.app.theme+"PreloaderContent"]||"")+"</div>\n    ").trim()},t.prototype.renderSearchbar=function(){var e=this;return e.params.renderSearchbar?e.params.renderSearchbar.call(e):('\n      <form class="searchbar">\n        <div class="searchbar-inner">\n          <div class="searchbar-input-wrap">\n            <input type="search" placeholder="'+e.params.searchbarPlaceholder+'"/>\n            <i class="searchbar-icon"></i>\n            <span class="input-clear-button"></span>\n          </div>\n          '+(e.params.searchbarDisableButton?'\n          <span class="searchbar-disable-button">'+e.params.searchbarDisableText+"</span>\n          ":"")+"\n        </div>\n      </form>\n    ").trim()},t.prototype.renderItem=function(e,t){if(this.params.renderItem)return this.params.renderItem.call(this,e,t);var a=e.value&&"string"==typeof e.value?e.value.replace(/"/g,"&quot;"):e.value;return("dropdown"!==this.params.openIn?'\n        <li>\n          <label class="item-'+e.inputType+' item-content">\n            <input type="'+e.inputType+'" name="'+e.inputName+'" value="'+a+'" '+(e.selected?"checked":"")+'>\n            <i class="icon icon-'+e.inputType+'"></i>\n            <div class="item-inner">\n              <div class="item-title">'+e.text+"</div>\n            </div>\n          </label>\n        </li>\n      ":e.placeholder?'\n        <li class="autocomplete-dropdown-placeholder">\n          <label class="item-content">\n            <div class="item-inner">\n              <div class="item-title">'+e.text+"</div>\n            </div>\n          </label>\n        </li>\n      ":'\n        <li>\n          <label class="item-radio item-content" data-value="'+a+'">\n            <div class="item-inner">\n              <div class="item-title">'+e.text+"</div>\n            </div>\n          </label>\n        </li>\n      ").trim()},t.prototype.renderNavbar=function(){var e=this;if(e.params.renderNavbar)return e.params.renderNavbar.call(e);var t=e.params.pageTitle;void 0===t&&e.$openerEl&&e.$openerEl.length&&(t=e.$openerEl.find(".item-title").text().trim());var a="popup"===e.params.openIn,r=a?"\n        "+(e.params.preloader?'\n        <div class="left">\n          '+e.renderPreloader()+"\n        </div>\n        ":"")+"\n      ":'\n        <div class="left sliding">\n          <a class="link back">\n            <i class="icon icon-back"></i>\n            <span class="if-not-md">'+e.params.pageBackLinkText+"</span>\n          </a>\n        </div>\n      ",n=a?'\n        <div class="right">\n          <a class="link popup-close" data-popup=".autocomplete-popup">\n            '+e.params.popupCloseLinkText+"\n          </a>\n        </div>\n      ":"\n        "+(e.params.preloader?'\n        <div class="right">\n          '+e.renderPreloader()+"\n        </div>\n        ":"")+"\n      ";return('\n      <div class="navbar '+(e.params.navbarColorTheme?"color-"+e.params.navbarColorTheme:"")+'">\n        <div class="navbar-bg"></div>\n        <div class="navbar-inner '+(e.params.navbarColorTheme?"color-"+e.params.navbarColorTheme:"")+'">\n          '+r+"\n          "+(t?'<div class="title sliding">'+t+"</div>":"")+"\n          "+n+'\n          <div class="subnavbar sliding">'+e.renderSearchbar()+"</div>\n        </div>\n      </div>\n    ").trim()},t.prototype.renderDropdown=function(){var e=this;return e.params.renderDropdown?e.params.renderDropdown.call(e,e.items):('\n      <div class="autocomplete-dropdown">\n        <div class="autocomplete-dropdown-inner">\n          <div class="list '+(e.params.expandInput?"":"no-safe-areas")+'">\n            <ul></ul>\n          </div>\n        </div>\n        '+(e.params.preloader?e.renderPreloader():"")+"\n      </div>\n    ").trim()},t.prototype.renderPage=function(e){var t=this;return t.params.renderPage?t.params.renderPage.call(t,t.items):('\n      <div class="page page-with-subnavbar autocomplete-page" data-name="autocomplete-page">\n        '+t.renderNavbar(e)+'\n        <div class="searchbar-backdrop"></div>\n        <div class="page-content">\n          <div class="list autocomplete-list autocomplete-found autocomplete-list-'+t.id+" "+(t.params.formColorTheme?"color-"+t.params.formColorTheme:"")+'">\n            <ul></ul>\n          </div>\n          <div class="list autocomplete-not-found">\n            <ul>\n              <li class="item-content"><div class="item-inner"><div class="item-title">'+t.params.notFoundText+'</div></div></li>\n            </ul>\n          </div>\n          <div class="list autocomplete-values">\n            <ul></ul>\n          </div>\n        </div>\n      </div>\n    ').trim()},t.prototype.renderPopup=function(){var e=this;return e.params.renderPopup?e.params.renderPopup.call(e,e.items):('\n      <div class="popup autocomplete-popup">\n        <div class="view">\n          '+e.renderPage(!0)+";\n        </div>\n      </div>\n    ").trim()},t.prototype.onOpen=function(e,t){var a=this,r=a.app,n=$(t);if(a.$el=n,a.el=n[0],a.openedIn=e,a.opened=!0,"dropdown"===a.params.openIn)a.attachDropdownEvents(),a.$dropdownEl.addClass("autocomplete-dropdown-in"),a.$inputEl.trigger("input");else{var i=n.find(".searchbar");"page"===a.params.openIn&&"ios"===r.theme&&0===i.length&&(i=$(r.navbar.getElByPage(n)).find(".searchbar")),a.searchbar=r.searchbar.create({el:i,backdropEl:n.find(".searchbar-backdrop"),customSearch:!0,on:{search:function(e,t){0===t.length&&a.searchbar.enabled?a.searchbar.backdropShow():a.searchbar.backdropHide(),a.source(t)}}}),a.attachPageEvents(),a.updateValues(),a.params.requestSourceOnOpen&&a.source("")}a.emit("local::open autocompleteOpen",a)},t.prototype.autoFocus=function(){return this.searchbar&&this.searchbar.$inputEl&&this.searchbar.$inputEl.focus(),this},t.prototype.onOpened=function(){var e=this;"dropdown"!==e.params.openIn&&e.params.autoFocus&&e.autoFocus(),e.emit("local::opened autocompleteOpened",e)},t.prototype.onClose=function(){var e=this;e.destroyed||(e.searchbar&&e.searchbar.destroy&&(e.searchbar.destroy(),e.searchbar=null,delete e.searchbar),"dropdown"===e.params.openIn?(e.detachDropdownEvents(),e.$dropdownEl.removeClass("autocomplete-dropdown-in").remove(),e.$inputEl.parents(".item-content-dropdown-expanded").removeClass("item-content-dropdown-expanded")):e.detachPageEvents(),e.emit("local::close autocompleteClose",e))},t.prototype.onClosed=function(){var e=this;e.destroyed||(e.opened=!1,e.$el=null,e.el=null,delete e.$el,delete e.el,e.emit("local::closed autocompleteClosed",e))},t.prototype.openPage=function(){var e=this;if(e.opened)return e;var t=e.renderPage();return e.view.router.navigate({url:e.url,route:{content:t,path:e.url,on:{pageBeforeIn:function(t,a){e.onOpen("page",a.el)},pageAfterIn:function(t,a){e.onOpened("page",a.el)},pageBeforeOut:function(t,a){e.onClose("page",a.el)},pageAfterOut:function(t,a){e.onClosed("page",a.el)}},options:{animate:e.params.animate}}}),e},t.prototype.openPopup=function(){var e=this;if(e.opened)return e;var t={content:e.renderPopup(),animate:e.params.animate,push:e.params.popupPush,swipeToClose:e.params.popupSwipeToClose,on:{popupOpen:function(t){e.onOpen("popup",t.el)},popupOpened:function(t){e.onOpened("popup",t.el)},popupClose:function(t){e.onClose("popup",t.el)},popupClosed:function(t){e.onClosed("popup",t.el)}}};return e.params.routableModals&&e.view?e.view.router.navigate({url:e.url,route:{path:e.url,popup:t}}):e.modal=e.app.popup.create(t).open(e.params.animate),e},t.prototype.openDropdown=function(){var e=this;e.$dropdownEl||(e.$dropdownEl=$(e.renderDropdown())),e.$inputEl.parents(".list").length&&e.$inputEl.parents(".item-content").length>0&&e.params.expandInput&&e.$inputEl.parents(".item-content").addClass("item-content-dropdown-expanded");var t=e.$inputEl.parents(".page-content");e.params.dropdownContainerEl?$(e.params.dropdownContainerEl).append(e.$dropdownEl):0===t.length?e.$dropdownEl.insertAfter(e.$inputEl):(e.positionDropdown(),t.append(e.$dropdownEl)),e.onOpen("dropdown",e.$dropdownEl),e.onOpened("dropdown",e.$dropdownEl)},t.prototype.open=function(){var e=this;return e.opened||e["open"+e.params.openIn.split("").map((function(e,t){return 0===t?e.toUpperCase():e})).join("")](),e},t.prototype.close=function(){var e=this;return e.opened?("dropdown"===e.params.openIn?(e.onClose(),e.onClosed()):e.params.routableModals&&e.view||"page"===e.openedIn?e.view.router.back({animate:e.params.animate}):(e.modal.once("modalClosed",(function(){Utils.nextTick((function(){e.destroyed||(e.modal.destroy(),delete e.modal)}))})),e.modal.close()),e):e},t.prototype.init=function(){this.attachEvents()},t.prototype.destroy=function(){var e=this;e.emit("local::beforeDestroy autocompleteBeforeDestroy",e),e.detachEvents(),e.$inputEl&&e.$inputEl[0]&&delete e.$inputEl[0].f7Autocomplete,e.$openerEl&&e.$openerEl[0]&&delete e.$openerEl[0].f7Autocomplete,Utils.deleteProps(e),e.destroyed=!0},Object.defineProperties(t.prototype,a),t}(Framework7Class),Autocomplete$1={name:"autocomplete",params:{autocomplete:{openerEl:void 0,inputEl:void 0,view:void 0,dropdownContainerEl:void 0,dropdownPlaceholderText:void 0,typeahead:!1,highlightMatches:!0,expandInput:!1,updateInputValueOnSelect:!0,inputEvents:"input",value:void 0,multiple:!1,source:void 0,limit:void 0,valueProperty:"id",textProperty:"text",openIn:"page",pageBackLinkText:"Back",popupCloseLinkText:"Close",pageTitle:void 0,searchbarPlaceholder:"Search...",searchbarDisableText:"Cancel",searchbarDisableButton:void 0,popupPush:!1,popupSwipeToClose:void 0,animate:!0,autoFocus:!1,closeOnSelect:!1,notFoundText:"Nothing found",requestSourceOnOpen:!1,preloaderColor:void 0,preloader:!1,formColorTheme:void 0,navbarColorTheme:void 0,routableModals:!0,url:"select/",renderDropdown:void 0,renderPage:void 0,renderPopup:void 0,renderItem:void 0,renderSearchbar:void 0,renderNavbar:void 0}},static:{Autocomplete:Autocomplete},create:function(){var e=this;e.autocomplete=Utils.extend(ConstructorMethods({defaultSelector:void 0,constructor:Autocomplete,app:e,domProp:"f7Autocomplete"}),{open:function(t){var a=e.autocomplete.get(t);if(a&&a.open)return a.open()},close:function(t){var a=e.autocomplete.get(t);if(a&&a.close)return a.close()}})}},Tooltip=function(e){function t(t,a){void 0===a&&(a={}),e.call(this,a,[t]);var r=this,n=Utils.extend({},t.params.tooltip);r.useModulesParams(n),r.params=Utils.extend(n,a);var i=r.params.targetEl;if(!i)return r;var o=$(i);if(0===o.length)return r;if(o[0].f7Tooltip)return o[0].f7Tooltip;var s=$(r.render()).eq(0);Utils.extend(r,{app:t,$targetEl:o,targetEl:o&&o[0],$el:s,el:s&&s[0],text:r.params.text||"",visible:!1,opened:!1}),o[0].f7Tooltip=r;var l,p={};function c(){r.opened?r.hide():r.show(this)}function d(e){r.opened&&($(e.target).closest(o).length||$(e.target).closest(r.$el).length)||r.hide()}function u(e){l||(l=!0,p.x="touchstart"===e.type?e.targetTouches[0].pageX:e.pageX,p.y="touchstart"===e.type?e.targetTouches[0].pageY:e.pageY,r.show(this))}function h(e){if(l){var t="touchmove"===e.type?e.targetTouches[0].pageX:e.pageX,a="touchmove"===e.type?e.targetTouches[0].pageY:e.pageY;Math.pow(Math.pow(t-p.x,2)+Math.pow(a-p.y,2),.5)>50&&(l=!1,r.hide())}}function f(){l&&(l=!1,r.hide())}function m(){r.show(this)}function v(){r.hide()}function g(){s.hasClass("tooltip-in")||s.removeClass("tooltip-out").remove()}return r.attachEvents=function(){if(s.on("transitionend",g),"click"===r.params.trigger)return o.on("click",c),void $("html").on("click",d);if(Support.touch){var e=!!Support.passiveListener&&{passive:!0};o.on(t.touchEvents.start,u,e),t.on("touchmove",h),t.on("touchend:passive",f)}else o.on(Support.pointerEvents?"pointerenter":"mouseenter",m),o.on(Support.pointerEvents?"pointerleave":"mouseleave",v)},r.detachEvents=function(){if(s.off("transitionend",g),"click"===r.params.trigger)return o.off("click",c),void $("html").off("click",d);if(Support.touch){var e=!!Support.passiveListener&&{passive:!0};o.off(t.touchEvents.start,u,e),t.off("touchmove",h),t.off("touchend:passive",f)}else o.off(Support.pointerEvents?"pointerenter":"mouseenter",m),o.off(Support.pointerEvents?"pointerleave":"mouseleave",v)},r.useModules(),r.init(),r}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t.prototype.position=function(e){var t=this.$el,a=this.app,r=this.params.offset||0;t.css({left:"",top:""});var n,i,o,s,l=$(e||this.targetEl),p=[t.width(),t.height()],c=p[0],d=p[1];if(t.css({left:"",top:""}),l&&l.length>0){n=l.outerWidth(),i=l.outerHeight();var u=l.offset();o=u.left-a.left,s=u.top-a.top;var h=l.parents(".page");h.length>0&&(s-=h[0].scrollTop)}var f=[0,0,0],m=f[0],v=f[1],g="top";d+r<s?v=s-d-r:d<a.height-s-i?(g="bottom",v=s+i+r):(g="middle",(v=i/2+s-d/2)<=0?v=8:v+d>=a.height&&(v=a.height-d-8)),"top"===g||"bottom"===g?((m=n/2+o-c/2)<8&&(m=8),m+c>a.width&&(m=a.width-c-8),m<0&&(m=0)):"middle"===g&&((m=o-c)<8||m+c>a.width)&&(m<8&&(m=o+n),m+c>a.width&&(m=a.width-c-8)),t.css({top:v+"px",left:m+"px"})},t.prototype.show=function(e){var t=this.app,a=this.$el,r=this.$targetEl;t.root.append(a),this.position(e);var n=$(e);return this.visible=!0,this.opened=!0,r.trigger("tooltip:show"),a.trigger("tooltip:show"),n.length&&n[0]!==r[0]&&n.trigger("tooltip:show"),this.emit("local::show tooltipShow",this),a.removeClass("tooltip-out").addClass("tooltip-in"),this},t.prototype.hide=function(){var e=this.$el,t=this.$targetEl;return this.visible=!1,this.opened=!1,t.trigger("tooltip:hide"),e.trigger("tooltip:hide"),this.emit("local::hide tooltipHide",this),e.addClass("tooltip-out").removeClass("tooltip-in"),this},t.prototype.render=function(){if(this.params.render)return this.params.render.call(this,this);var e=this.params;return('\n      <div class="tooltip '+(e.cssClass||"")+'">\n        <div class="tooltip-content">'+(e.text||"")+"</div>\n      </div>\n    ").trim()},t.prototype.setText=function(e){return void 0===e||(this.params.text=e,this.text=e,this.$el&&this.$el.children(".tooltip-content").html(e),this.opened&&this.position()),this},t.prototype.init=function(){this.attachEvents()},t.prototype.destroy=function(){this.$targetEl&&!this.destroyed&&(this.$targetEl.trigger("tooltip:beforedestroy"),this.emit("local::beforeDestroy tooltipBeforeDestroy",this),this.$el.remove(),delete this.$targetEl[0].f7Tooltip,this.detachEvents(),Utils.deleteProps(this),this.destroyed=!0)},t}(Framework7Class),Tooltip$1={name:"tooltip",static:{Tooltip:Tooltip},create:function(){this.tooltip=ConstructorMethods({defaultSelector:".tooltip",constructor:Tooltip,app:this,domProp:"f7Tooltip"}),this.tooltip.show=function(e){var t=$(e);if(0!==t.length){var a=t[0].f7Tooltip;if(a)return a.show(t[0]),a}},this.tooltip.hide=function(e){var t=$(e);if(0!==t.length){var a=t[0].f7Tooltip;if(a)return a.hide(),a}},this.tooltip.setText=function(e,t){var a=$(e);if(0!==a.length){var r=a[0].f7Tooltip;if(r)return r.setText(t),r}}},params:{tooltip:{targetEl:null,text:null,cssClass:null,render:null,offset:0,trigger:"hover"}},on:{tabMounted:function(e){var t=this;$(e).find(".tooltip-init").each((function(e,a){var r=$(a).attr("data-tooltip");r&&t.tooltip.create({targetEl:a,text:r})}))},tabBeforeRemove:function(e){$(e).find(".tooltip-init").each((function(e,t){t.f7Tooltip&&t.f7Tooltip.destroy()}))},pageInit:function(e){var t=this;e.$el.find(".tooltip-init").each((function(e,a){var r=$(a).attr("data-tooltip");r&&t.tooltip.create({targetEl:a,text:r})})),"ios"===t.theme&&e.view&&e.view.router.dynamicNavbar&&e.$navbarEl&&e.$navbarEl.length>0&&e.$navbarEl.find(".tooltip-init").each((function(e,a){var r=$(a).attr("data-tooltip");r&&t.tooltip.create({targetEl:a,text:r})}))},pageBeforeRemove:function(e){e.$el.find(".tooltip-init").each((function(e,t){t.f7Tooltip&&t.f7Tooltip.destroy()})),"ios"===this.theme&&e.view&&e.view.router.dynamicNavbar&&e.$navbarEl&&e.$navbarEl.length>0&&e.$navbarEl.find(".tooltip-init").each((function(e,t){t.f7Tooltip&&t.f7Tooltip.destroy()}))}},vnode:{"tooltip-init":{insert:function(e){var t=e.elm,a=$(t).attr("data-tooltip");a&&this.tooltip.create({targetEl:t,text:a})},update:function(e){var t=e.elm;t.f7Tooltip&&e&&e.data&&e.data.attrs&&e.data.attrs["data-tooltip"]&&t.f7Tooltip.setText(e.data.attrs["data-tooltip"])},destroy:function(e){var t=e.elm;t.f7Tooltip&&t.f7Tooltip.destroy()}}}},Gauge=function(e){function t(t,a){void 0===a&&(a={}),e.call(this,a,[t]);var r=Utils.extend({},t.params.gauge);this.useModulesParams(r),this.params=Utils.extend(r,a);var n=this.params.el;if(!n)return this;var i=$(n);return 0===i.length?this:i[0].f7Gauge?i[0].f7Gauge:(Utils.extend(this,{app:t,$el:i,el:i&&i[0]}),i[0].f7Gauge=this,this.useModules(),this.init(),this)}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t.prototype.calcRadius=function(){var e=this.params;return e.size/2-e.borderWidth/2},t.prototype.calcBorderLength=function(){var e=this.calcRadius();return 2*Math.PI*e},t.prototype.render=function(){if(this.params.render)return this.params.render.call(this,this);var e=this.params,t=e.type,a=e.value,r=e.size,n=e.bgColor,i=e.borderBgColor,o=e.borderColor,s=e.borderWidth,l=e.valueText,p=e.valueTextColor,c=e.valueFontSize,d=e.valueFontWeight,u=e.labelText,h=e.labelTextColor,f=e.labelFontSize,m=e.labelFontWeight,v="semicircle"===t,g=this.calcRadius(),b=this.calcBorderLength(),y=Math.max(Math.min(a,1),0);return('\n      <svg class="gauge-svg" width="'+r+'px" height="'+(v?r/2:r)+'px" viewBox="0 0 '+r+" "+(v?r/2:r)+'">\n        '+(v?'\n          <path\n            class="gauge-back-semi"\n            d="M'+(r-s/2)+","+r/2+" a1,1 0 0,0 -"+(r-s)+',0"\n            stroke="'+i+'"\n            stroke-width="'+s+'"\n            fill="'+(n||"none")+'"\n          />\n          <path\n            class="gauge-front-semi"\n            d="M'+(r-s/2)+","+r/2+" a1,1 0 0,0 -"+(r-s)+',0"\n            stroke="'+o+'"\n            stroke-width="'+s+'"\n            stroke-dasharray="'+b/2+'"\n            stroke-dashoffset="'+b/2*(1+y)+'"\n            fill="'+(i?"none":n||"none")+'"\n          />\n        ':"\n          "+(i?'\n            <circle\n              class="gauge-back-circle"\n              stroke="'+i+'"\n              stroke-width="'+s+'"\n              fill="'+(n||"none")+'"\n              cx="'+r/2+'"\n              cy="'+r/2+'"\n              r="'+g+'"\n            ></circle>\n          ':"")+'\n          <circle\n            class="gauge-front-circle"\n            transform="rotate(-90 '+r/2+" "+r/2+')"\n            stroke="'+o+'"\n            stroke-width="'+s+'"\n            stroke-dasharray="'+b+'"\n            stroke-dashoffset="'+b*(1-y)+'"\n            fill="'+(i?"none":n||"none")+'"\n            cx="'+r/2+'"\n            cy="'+r/2+'"\n            r="'+g+'"\n          ></circle>\n        ')+"\n        "+(l?'\n          <text\n            class="gauge-value-text"\n            x="50%"\n            y="'+(v?"100%":"50%")+'"\n            font-weight="'+d+'"\n            font-size="'+c+'"\n            fill="'+p+'"\n            dy="'+(v?u?-f-15:-5:0)+'"\n            text-anchor="middle"\n            dominant-baseline="'+(!v&&"middle")+'"\n          >'+l+"</text>\n        ":"")+"\n        "+(u?'\n          <text\n            class="gauge-label-text"\n            x="50%"\n            y="'+(v?"100%":"50%")+'"\n            font-weight="'+m+'"\n            font-size="'+f+'"\n            fill="'+h+'"\n            dy="'+(v?-5:l?c/2+10:0)+'"\n            text-anchor="middle"\n            dominant-baseline="'+(!v&&"middle")+'"\n          >'+u+"</text>\n        ":"")+"\n      </svg>\n    ").trim()},t.prototype.update=function(e){void 0===e&&(e={});var t=this.params,a=this.$gaugeSvgEl;if(Object.keys(e).forEach((function(a){void 0!==e[a]&&(t[a]=e[a])})),0===a.length)return this;var r=t.value,n=t.size,i=t.bgColor,o=t.borderBgColor,s=t.borderColor,l=t.borderWidth,p=t.valueText,c=t.valueTextColor,d=t.valueFontSize,u=t.valueFontWeight,h=t.labelText,f=t.labelTextColor,m=t.labelFontSize,v=t.labelFontWeight,g=this.calcBorderLength(),b=Math.max(Math.min(r,1),0),y=this.calcRadius(),w="semicircle"===t.type,C={width:n+"px",height:(w?n/2:n)+"px",viewBox:"0 0 "+n+" "+(w?n/2:n)};if(Object.keys(C).forEach((function(e){a.attr(e,C[e])})),w){var x={d:"M"+(n-l/2)+","+n/2+" a1,1 0 0,0 -"+(n-l)+",0",stroke:o,"stroke-width":l,fill:i||"none"},$={d:"M"+(n-l/2)+","+n/2+" a1,1 0 0,0 -"+(n-l)+",0",stroke:s,"stroke-width":l,"stroke-dasharray":g/2,"stroke-dashoffset":g/2*(1+b),fill:o?"none":i||"none"};Object.keys(x).forEach((function(e){a.find(".gauge-back-semi").attr(e,x[e])})),Object.keys($).forEach((function(e){a.find(".gauge-front-semi").attr(e,$[e])}))}else{var k={stroke:o,"stroke-width":l,fill:i||"none",cx:n/2,cy:n/2,r:y},E={transform:"rotate(-90 "+n/2+" "+n/2+")",stroke:s,"stroke-width":l,"stroke-dasharray":g,"stroke-dashoffset":g*(1-b),fill:o?"none":i||"none",cx:n/2,cy:n/2,r:y};Object.keys(k).forEach((function(e){a.find(".gauge-back-circle").attr(e,k[e])})),Object.keys(E).forEach((function(e){a.find(".gauge-front-circle").attr(e,E[e])}))}if(p){a.find(".gauge-value-text").length||a.append('<text class="gauge-value-text"></text>');var T={x:"50%",y:w?"100%":"50%","font-weight":u,"font-size":d,fill:c,dy:w?h?-m-15:-5:0,"text-anchor":"middle","dominant-baseline":!w&&"middle"};Object.keys(T).forEach((function(e){a.find(".gauge-value-text").attr(e,T[e])})),a.find(".gauge-value-text").text(p)}else a.find(".gauge-value-text").remove();if(h){a.find(".gauge-label-text").length||a.append('<text class="gauge-label-text"></text>');var S={x:"50%",y:w?"100%":"50%","font-weight":v,"font-size":m,fill:f,dy:w?-5:p?d/2+10:0,"text-anchor":"middle","dominant-baseline":!w&&"middle"};Object.keys(S).forEach((function(e){a.find(".gauge-label-text").attr(e,S[e])})),a.find(".gauge-label-text").text(h)}else a.find(".gauge-label-text").remove();return this},t.prototype.init=function(){var e=$(this.render()).eq(0);return e.f7Gauge=this,Utils.extend(this,{$gaugeSvgEl:e,gaugeSvgEl:e&&e[0]}),this.$el.append(e),this},t.prototype.destroy=function(){this.$el&&!this.destroyed&&(this.$el.trigger("gauge:beforedestroy"),this.emit("local::beforeDestroy gaugeBeforeDestroy",this),this.$gaugeSvgEl.remove(),delete this.$el[0].f7Gauge,Utils.deleteProps(this),this.destroyed=!0)},t}(Framework7Class),Gauge$1={name:"gauge",static:{Gauge:Gauge},create:function(){var e=this;e.gauge=ConstructorMethods({defaultSelector:".gauge",constructor:Gauge,app:e,domProp:"f7Gauge"}),e.gauge.update=function(t,a){if(0!==$(t).length){var r=e.gauge.get(t);if(r)return r.update(a),r}}},params:{gauge:{el:null,type:"circle",value:0,size:200,bgColor:"transparent",borderBgColor:"#eeeeee",borderColor:"#000000",borderWidth:10,valueText:null,valueTextColor:"#000000",valueFontSize:31,valueFontWeight:500,labelText:null,labelTextColor:"#888888",labelFontSize:14,labelFontWeight:400}},on:{tabMounted:function(e){var t=this;$(e).find(".gauge-init").each((function(e,a){t.gauge.create(Utils.extend({el:a},$(a).dataset()||{}))}))},tabBeforeRemove:function(e){$(e).find(".gauge-init").each((function(e,t){t.f7Gauge&&t.f7Gauge.destroy()}))},pageInit:function(e){var t=this;e.$el.find(".gauge-init").each((function(e,a){t.gauge.create(Utils.extend({el:a},$(a).dataset()||{}))}))},pageBeforeRemove:function(e){e.$el.find(".gauge-init").each((function(e,t){t.f7Gauge&&t.f7Gauge.destroy()}))}},vnode:{"gauge-init":{insert:function(e){var t=e.elm;this.gauge.create(Utils.extend({el:t},$(t).dataset()||{}))},destroy:function(e){var t=e.elm;t.f7Gauge&&t.f7Gauge.destroy()}}}},Skeleton={name:"skeleton"},Menu={open:function(e){void 0===e&&(e=".menu-item-dropdown");if(e){var t=$(e).closest(".menu-item-dropdown");if(t.length){var a=t.closest(".menu").eq(0);if(a.length){var r=a.css("z-index"),n=a[0].style.zIndex;a.css("z-index",parseInt(r||0,0)+1),a[0].f7MenuZIndex=n}t.eq(0).addClass("menu-item-dropdown-opened").trigger("menu:opened"),this.emit("menuOpened",t.eq(0)[0])}}},close:function(e){void 0===e&&(e=".menu-item-dropdown-opened");if(e){var t=$(e).closest(".menu-item-dropdown-opened");if(t.length){var a=t.closest(".menu").eq(0);if(a.length){var r=a[0].f7MenuZIndex;a.css("z-index",r),delete a[0].f7MenuZIndex}t.eq(0).removeClass("menu-item-dropdown-opened").trigger("menu:closed"),this.emit("menuClosed",t.eq(0)[0])}}}},Menu$1={name:"menu",create:function(){this.menu={open:Menu.open.bind(this),close:Menu.close.bind(this)}},on:{click:function(e){var t=this,a=$(".menu-item-dropdown-opened");a.length&&a.each((function(a,r){$(e.target).closest(".menu-item-dropdown-opened").length||t.menu.close(r)}))}},clicks:{".menu-item-dropdown":function(e,t,a){if(e.hasClass("menu-item-dropdown-opened")){if($(a.target).closest(".menu-dropdown").length)return;this.menu.close(e)}else this.menu.open(e)},".menu-close":function(){this.menu.close()}}},moduleAlphaSlider={render:function(e){var t=e.params,a=t.sliderLabel,r=t.sliderValue,n=t.sliderValueEditable,i=t.alphaLabelText;return'\n      <div class="color-picker-module color-picker-module-alpha-slider">\n        <div class="color-picker-slider-wrap">\n          '+(a?'\n            <div class="color-picker-slider-label">'+i+"</div>\n          ":"")+'\n          <div class="range-slider color-picker-slider color-picker-slider-alpha"></div>\n          '+(r?'\n            <div class="color-picker-slider-value">\n              '+(n?'\n                <input type="number" step="0.01" min="0" max="1" class="color-picker-value-alpha">\n              ':'\n                <span class="color-picker-value-alpha"></span>\n              ')+"\n            </div>\n          ":"")+"\n        </div>\n      </div>\n    "},init:function(e){function t(t){var a=e.value.alpha,r=parseFloat(t.target.value);Number.isNaN(r)?t.target.value=a:(r=Math.max(0,Math.min(1,r)),e.setValue({alpha:r}))}e.alphaRangeSlider=e.app.range.create({el:e.$el.find(".color-picker-slider-alpha"),min:0,max:1,step:.01,value:1,on:{change:function(t,a){var r=Math.floor(100*a)/100;e.setValue({alpha:r})}}}),e.$el.on("change",".color-picker-module-alpha-slider input",t),e.destroyAlphaSliderEvents=function(){e.$el.off("change",".color-picker-module-alpha-slider input",t)}},update:function(e){var t=e.value,a=e.params,r=a.sliderValue,n=a.sliderValueEditable,i=t.alpha;e.alphaRangeSlider.value=i,e.alphaRangeSlider.layout(),r&&n?e.$el.find("input.color-picker-value-alpha").val(i):e.$el.find("span.color-picker-value-alpha").text(i)},destroy:function(e){e.alphaRangeSlider&&e.alphaRangeSlider.destroy&&e.alphaRangeSlider.destroy(),delete e.alphaRangeSlider,e.destroyAlphaSliderEvents&&e.destroyAlphaSliderEvents(),delete e.destroyAlphaSliderEvents}},moduleCurrentColor={render:function(){return'\n      <div class="color-picker-module color-picker-module-current-color">\n        <div class="color-picker-current-color"></div>\n      </div>\n    '},update:function(e){e.$el.find(".color-picker-module-current-color .color-picker-current-color").css("background-color",e.value.hex)}},moduleHex={render:function(e){var t=e.params,a=t.hexLabel,r=t.hexLabelText;return'\n      <div class="color-picker-module color-picker-module-hex">\n        <div class="color-picker-hex-wrap">\n          '+(a?'\n            <div class="color-picker-hex-label">'+r+"</div>\n          ":"")+'\n          <div class="color-picker-hex-value">\n            '+(t.hexValueEditable?'\n              <input type="text" class="color-picker-value-hex">\n            ':'\n              <span class="color-picker-value-hex"></span>\n            ')+"\n          </div>\n        </div>\n      </div>\n    "},init:function(e){function t(t){var a=e.value.hex,r=t.target.value.replace(/#/g,"");if(Number.isNaN(r)||!r||3!==r.length&&6!==r.length)t.target.value=a;else{var n=parseInt(r,16);n>parseInt("ffffff",16)&&(r="fff"),n<0&&(r="000"),e.setValue({hex:r})}}e.$el.on("change",".color-picker-module-hex input",t),e.destroyHexEvents=function(){e.$el.off("change",".color-picker-module-hex input",t)}},update:function(e){var t=e.value,a=e.params.hexValueEditable,r=t.hex;a?e.$el.find("input.color-picker-value-hex").val(r):e.$el.find("span.color-picker-value-hex").text(r)},destroy:function(e){e.destroyHexEvents&&e.destroyHexEvents(),delete e.destroyHexEvents}},moduleHsbSliders={render:function(e){var t=e.params,a=t.sliderLabel,r=t.sliderValue,n=t.sliderValueEditable,i=t.hueLabelText,o=t.saturationLabelText,s=t.brightnessLabelText;return'\n      <div class="color-picker-module color-picker-module-hsb-sliders">\n        <div class="color-picker-slider-wrap">\n          '+(a?'\n            <div class="color-picker-slider-label">'+i+"</div>\n          ":"")+'\n          <div class="range-slider color-picker-slider color-picker-slider-hue"></div>\n          '+(r?'\n            <div class="color-picker-slider-value">\n              '+(n?'\n                <input type="number" step="0.1" min="0" max="360" class="color-picker-value-hue" data-color-index="0">\n              ':'\n                <span class="color-picker-value-hue"></span>\n              ')+"\n            </div>\n          ":"")+'\n        </div>\n        <div class="color-picker-slider-wrap">\n          '+(a?'\n            <div class="color-picker-slider-label">'+o+"</div>\n          ":"")+'\n          <div class="range-slider color-picker-slider color-picker-slider-saturation"></div>\n          '+(r?'\n            <div class="color-picker-slider-value">\n              '+(n?'\n                <input type="number" step="0.1" min="0" max="100" class="color-picker-value-saturation" data-color-index="1">\n              ':'\n                <span class="color-picker-value-saturation"></span>\n              ')+"\n            </div>\n          ":"")+'\n        </div>\n        <div class="color-picker-slider-wrap">\n          '+(a?'\n            <div class="color-picker-slider-label">'+s+"</div>\n          ":"")+'\n          <div class="range-slider color-picker-slider color-picker-slider-brightness"></div>\n          '+(r?'\n            <div class="color-picker-slider-value">\n              '+(n?'\n                <input type="number" step="0.1" min="0" max="100" class="color-picker-value-brightness" data-color-index="2">\n              ':'\n                <span class="color-picker-value-brightness"></span>\n              ')+"\n            </div>\n          ":"")+"\n        </div>\n      </div>\n    "},init:function(e){function t(t){var a=[].concat(e.value.hsb),r=parseInt($(t.target).attr("data-color-index"),10),n=parseFloat(t.target.value);Number.isNaN(n)?t.target.value=a[r]:(n=0===r?Math.max(0,Math.min(360,n)):Math.max(0,Math.min(100,n))/100,a[r]=n,e.setValue({hsb:a}))}e.hueRangeSlider=e.app.range.create({el:e.$el.find(".color-picker-slider-hue"),min:0,max:360,step:.1,value:0,on:{change:function(t,a){e.setValue({hue:a})}}}),e.saturationRangeSlider=e.app.range.create({el:e.$el.find(".color-picker-slider-saturation"),min:0,max:1,step:.001,value:0,on:{change:function(t,a){var r=Math.floor(1e3*a)/1e3;e.setValue({hsb:[e.value.hsb[0],r,e.value.hsb[2]]})}}}),e.brightnessRangeSlider=e.app.range.create({el:e.$el.find(".color-picker-slider-brightness"),min:0,max:1,step:.001,value:0,on:{change:function(t,a){var r=Math.floor(1e3*a)/1e3;e.setValue({hsb:[e.value.hsb[0],e.value.hsb[1],r]})}}}),e.$el.on("change",".color-picker-module-hsb-sliders input",t),e.destroyHsbSlidersEvents=function(){e.$el.off("change",".color-picker-module-hsb-sliders input",t)}},update:function(e){var t=e.app,a=e.value,r=e.params,n=r.sliderValue,i=r.sliderValueEditable,o=a.hsb,s=a.hue;e.hueRangeSlider.value=s,e.saturationRangeSlider.value=o[1],e.brightnessRangeSlider.value=o[2],e.hueRangeSlider.layout(),e.saturationRangeSlider.layout(),e.brightnessRangeSlider.layout();var l=Utils.colorHsbToHsl(o[0],o[1],1),p=Utils.colorHsbToHsl(o[0],0,1),c=Utils.colorHsbToHsl(o[0],1,1),d=o[2];e.hueRangeSlider.$el[0].style.setProperty("--f7-range-knob-color","hsl("+s+", 100%, 50%)"),e.saturationRangeSlider.$el[0].style.setProperty("--f7-range-knob-color","hsl("+l[0]+", "+100*l[1]+"%, "+100*l[2]+"%)"),e.brightnessRangeSlider.$el[0].style.setProperty("--f7-range-knob-color","rgb("+255*d+", "+255*d+", "+255*d+")"),e.saturationRangeSlider.$el.find(".range-bar").css("background-image","linear-gradient("+(t.rtl?"to left":"to right")+", hsl("+p[0]+", "+100*p[1]+"%, "+100*p[2]+"%), hsl("+c[0]+", "+100*c[1]+"%, "+100*c[2]+"%))"),n&&i?(e.$el.find("input.color-picker-value-hue").val(""+s),e.$el.find("input.color-picker-value-saturation").val(""+1e3*o[1]/10),e.$el.find("input.color-picker-value-brightness").val(""+1e3*o[2]/10)):n&&(e.$el.find("span.color-picker-value-hue").text(""+s),e.$el.find("span.color-picker-value-saturation").text(""+1e3*o[1]/10),e.$el.find("span.color-picker-value-brightness").text(""+1e3*o[2]/10))},destroy:function(e){e.hueRangeSlider&&e.hueRangeSlider.destroy&&e.hueRangeSlider.destroy(),e.saturationRangeSlider&&e.saturationRangeSlider.destroy&&e.saturationRangeSlider.destroy(),e.brightnessRangeSlider&&e.brightnessRangeSlider.destroy&&e.brightnessRangeSlider.destroy(),delete e.hueRangeSlider,delete e.saturationRangeSlider,delete e.brightnessRangeSlider,e.destroyHsbSlidersEvents&&e.destroyHsbSlidersEvents(),delete e.destroyHsbSlidersEvents}},moduleHueSlider={render:function(e){var t=e.params,a=t.sliderLabel,r=t.sliderValue,n=t.sliderValueEditable,i=t.hueLabelText;return'\n      <div class="color-picker-module color-picker-module-hue-slider">\n        <div class="color-picker-slider-wrap">\n          '+(a?'\n            <div class="color-picker-slider-label">'+i+"</div>\n          ":"")+'\n          <div class="range-slider color-picker-slider color-picker-slider-hue"></div>\n          '+(r?'\n            <div class="color-picker-slider-value">\n              '+(n?'\n                <input type="number" step="0.1" min="0" max="360" class="color-picker-value-hue">\n              ':'\n                <span class="color-picker-value-hue"></span>\n              ')+"\n            </div>\n          ":"")+"\n        </div>\n      </div>\n    "},init:function(e){e.hueRangeSlider=e.app.range.create({el:e.$el.find(".color-picker-slider-hue"),min:0,max:360,step:.1,value:0,on:{change:function(t,a){e.setValue({hue:a})}}})},update:function(e){var t=e.value,a=e.params,r=a.sliderValue,n=a.sliderValueEditable,i=t.hue;e.hueRangeSlider.value=i,e.hueRangeSlider.layout(),e.hueRangeSlider.$el[0].style.setProperty("--f7-range-knob-color","hsl("+i+", 100%, 50%)"),r&&n?e.$el.find("input.color-picker-value-hue").val(""+i):r&&e.$el.find("span.color-picker-value-hue").text(""+i)},destroy:function(e){e.hueRangeSlider&&e.hueRangeSlider.destroy&&e.hueRangeSlider.destroy(),delete e.hueRangeSlider}},moduleBrightnessSlider={render:function(e){var t=e.params,a=t.sliderLabel,r=t.sliderValue,n=t.sliderValueEditable,i=t.brightnessLabelText;return'\n      <div class="color-picker-module color-picker-module-brightness-slider">\n        <div class="color-picker-slider-wrap">\n          '+(a?'\n            <div class="color-picker-slider-label">'+i+"</div>\n          ":"")+'\n          <div class="range-slider color-picker-slider color-picker-slider-brightness"></div>\n          '+(r?'\n            <div class="color-picker-slider-value">\n              '+(n?'\n                <input type="number" step="0.1" min="0" max="100" class="color-picker-value-brightness">\n              ':'\n                <span class="color-picker-value-brightness"></span>\n              ')+"\n            </div>\n          ":"")+"\n        </div>\n      </div>\n    "},init:function(e){e.brightnessRangeSlider=e.app.range.create({el:e.$el.find(".color-picker-slider-brightness"),min:0,max:1,step:.001,value:0,on:{change:function(t,a){var r=Math.floor(1e3*a)/1e3;e.setValue({hsb:[e.value.hsb[0],e.value.hsb[1],r]})}}})},update:function(e){var t=e.value,a=e.app,r=e.params,n=r.sliderValue,i=r.sliderValueEditable,o=t.hsb;e.brightnessRangeSlider.value=o[2],e.brightnessRangeSlider.layout();var s=Utils.colorHsbToHsl(o[0],o[1],o[2]),l=Utils.colorHsbToHsl(o[0],o[1],0),p=Utils.colorHsbToHsl(o[0],o[1],1);e.brightnessRangeSlider.$el[0].style.setProperty("--f7-range-knob-color","hsl("+s[0]+", "+100*s[1]+"%, "+100*s[2]+"%)"),e.brightnessRangeSlider.$el.find(".range-bar").css("background-image","linear-gradient("+(a.rtl?"to left":"to right")+", hsl("+l[0]+", "+100*l[1]+"%, "+100*l[2]+"%), hsl("+p[0]+", "+100*p[1]+"%, "+100*p[2]+"%))"),n&&i?e.$el.find("input.color-picker-value-brightness").val(""+1e3*o[2]/10):n&&e.$el.find("span.color-picker-value-brightness").text(""+1e3*o[2]/10)},destroy:function(e){e.brightnessRangeSlider&&e.brightnessRangeSlider.destroy&&e.brightnessRangeSlider.destroy(),delete e.brightnessRangeSlider}},modulePalette={render:function(e){return'\n      <div class="color-picker-module color-picker-module-palette">\n        <div class="color-picker-palette">\n          '+e.params.palette.map((function(e){if(Array.isArray(e)){var t='<div class="color-picker-palette-row">';return t+=e.map((function(e){return'\n                <div class="color-picker-palette-value" data-palette-color="'+e+'" style="background-color: '+e+'"></div>\n              '})).join(""),t+="</div>"}return'\n              <div class="color-picker-palette-value" data-palette-color="'+e+'" style="background-color: '+e+'"></div>\n            '})).join("")+"\n        </div>\n      </div>\n    "},init:function(e){function t(t){var a=$(t.target).attr("data-palette-color");e.setValue({hex:a})}e.$el.on("click",".color-picker-module-palette .color-picker-palette-value",t),e.destroyPaletteEvents=function(){e.$el.off("click",".color-picker-module-hex input",t)}},destroy:function(e){e.destroyPaletteEvents&&e.destroyPaletteEvents(),delete e.destroyPaletteEvents}},moduleInitialCurrentColors={render:function(){return'\n      <div class="color-picker-module color-picker-module-initial-current-colors">\n        <div class="color-picker-initial-current-colors">\n          <div class="color-picker-initial-color"></div>\n          <div class="color-picker-current-color"></div>\n        </div>\n      </div>\n    '},init:function(e){function t(){if(e.initialValue){var t=e.initialValue,a=t.hex,r=t.alpha;e.setValue({hex:a,alpha:r})}}e.$el.on("click",".color-picker-initial-color",t),e.destroyInitialCurrentEvents=function(){e.$el.off("click",".color-picker-initial-color",t)}},update:function(e){e.$el.find(".color-picker-module-initial-current-colors .color-picker-initial-color").css("background-color",e.initialValue.hex),e.$el.find(".color-picker-module-initial-current-colors .color-picker-current-color").css("background-color",e.value.hex)},destroy:function(e){e.destroyInitialCurrentEvents&&e.destroyInitialCurrentEvents(),delete e.destroyInitialCurrentEvents}},moduleRgbBars={render:function(e){var t=e.params,a=t.barLabel,r=t.barValue,n=t.barValueEditable,i=t.redLabelText,o=t.greenLabelText,s=t.blueLabelText;return'\n      <div class="color-picker-module color-picker-module-rgb-bars">\n        <div class="color-picker-bar-wrap">\n          '+(a?'\n            <div class="color-picker-bar-label">'+i+"</div>\n          ":"")+'\n          <div class="range-slider color-picker-bar color-picker-bar-red"></div>\n          '+(r?'\n            <div class="color-picker-bar-value">\n              '+(n?'\n                <input type="number" step="1" min="0" max="255" class="color-picker-value-bar-red" data-color-index="0">\n              ':'\n                <span class="color-picker-value-bar-red"></span>\n              ')+"\n            </div>\n          ":"")+'\n        </div>\n        <div class="color-picker-bar-wrap">\n          '+(a?'\n            <div class="color-picker-bar-label">'+o+"</div>\n          ":"")+'\n          <div class="range-slider color-picker-bar color-picker-bar-green"></div>\n          '+(r?'\n            <div class="color-picker-bar-value">\n              '+(n?'\n                <input type="number" step="1" min="0" max="255" class="color-picker-value-bar-green" data-color-index="1">\n              ':'\n                <span class="color-picker-value-bar-green"></span>\n              ')+"\n            </div>\n          ":"")+'\n        </div>\n        <div class="color-picker-bar-wrap">\n          '+(a?'\n            <div class="color-picker-bar-label">'+s+"</div>\n          ":"")+'\n          <div class="range-slider color-picker-bar color-picker-bar-blue"></div>\n          '+(r?'\n            <div class="color-picker-bar-value">\n              '+(n?'\n                <input type="number" step="1" min="0" max="255" class="color-picker-value-bar-blue" data-color-index="2">\n              ':'\n                <span class="color-picker-value-bar-blue"></span>\n              ')+"\n            </div>\n          ":"")+"\n        </div>\n      </div>\n    "},init:function(e){function t(t){var a=[].concat(e.value.rgb),r=parseInt($(t.target).attr("data-color-index"),10),n=parseInt(t.target.value,10);Number.isNaN(n)?t.target.value=a[r]:(n=Math.max(0,Math.min(255,n)),a[r]=n,e.setValue({rgb:a}))}e.redBar=e.app.range.create({el:e.$el.find(".color-picker-bar-red"),min:0,max:255,step:1,value:0,vertical:!0,on:{change:function(t,a){e.setValue({rgb:[a,e.value.rgb[1],e.value.rgb[2]]})}}}),e.greenBar=e.app.range.create({el:e.$el.find(".color-picker-bar-green"),min:0,max:255,step:1,value:0,vertical:!0,on:{change:function(t,a){e.setValue({rgb:[e.value.rgb[0],a,e.value.rgb[2]]})}}}),e.blueBar=e.app.range.create({el:e.$el.find(".color-picker-bar-blue"),min:0,max:255,step:1,value:0,vertical:!0,on:{change:function(t,a){e.setValue({rgb:[e.value.rgb[0],e.value.rgb[1],a]})}}}),e.$el.on("change",".color-picker-module-rgb-bars input",t),e.destroyRgbBarsEvents=function(){e.$el.off("change",".color-picker-module-rgb-bars input",t)}},update:function(e){var t=e.value,a=e.redBar,r=e.greenBar,n=e.blueBar,i=e.params,o=i.barValue,s=i.barValueEditable,l=t.rgb;a.value=l[0],r.value=l[1],n.value=l[2],a.layout(),r.layout(),n.layout(),a.$el.find(".range-bar").css("background-image","linear-gradient(to top, rgb(0, "+l[1]+", "+l[2]+"), rgb(255, "+l[1]+", "+l[2]+"))"),r.$el.find(".range-bar").css("background-image","linear-gradient(to top, rgb("+l[0]+", 0, "+l[2]+"), rgb("+l[0]+", 255, "+l[2]+"))"),n.$el.find(".range-bar").css("background-image","linear-gradient(to top, rgb("+l[0]+", "+l[1]+", 0), rgb("+l[0]+", "+l[1]+", 255))"),o&&s?(e.$el.find("input.color-picker-value-bar-red").val(l[0]),e.$el.find("input.color-picker-value-bar-green").val(l[1]),e.$el.find("input.color-picker-value-bar-blue").val(l[2])):o&&(e.$el.find("span.color-picker-value-bar-red").text(l[0]),e.$el.find("span.color-picker-value-bar-green").text(l[1]),e.$el.find("span.color-picker-value-bar-blue").text(l[2]))},destroy:function(e){e.redBar&&e.redBar.destroy&&e.redBar.destroy(),e.greenBar&&e.greenBar.destroy&&e.greenBar.destroy(),e.blueBar&&e.blueBar.destroy&&e.blueBar.destroy(),delete e.redBar,delete e.greenBar,delete e.blueBar,e.destroyRgbBarsEvents&&e.destroyRgbBarsEvents(),delete e.destroyRgbBarsEvents}},moduleRgbSliders={render:function(e){var t=e.params,a=t.sliderLabel,r=t.sliderValue,n=t.sliderValueEditable,i=t.redLabelText,o=t.greenLabelText,s=t.blueLabelText;return'\n      <div class="color-picker-module color-picker-module-rgb-sliders">\n        <div class="color-picker-slider-wrap">\n          '+(a?'\n            <div class="color-picker-slider-label">'+i+"</div>\n          ":"")+'\n          <div class="range-slider color-picker-slider color-picker-slider-red"></div>\n          '+(r?'\n            <div class="color-picker-slider-value">\n              '+(n?'\n                <input type="number" step="1" min="0" max="255" class="color-picker-value-red" data-color-index="0">\n              ':'\n                <span class="color-picker-value-red"></span>\n              ')+"\n            </div>\n          ":"")+'\n        </div>\n        <div class="color-picker-slider-wrap">\n          '+(a?'\n            <div class="color-picker-slider-label">'+o+"</div>\n          ":"")+'\n          <div class="range-slider color-picker-slider color-picker-slider-green"></div>\n          '+(r?'\n            <div class="color-picker-slider-value">\n              '+(n?'\n                <input type="number" step="1" min="0" max="255" class="color-picker-value-green" data-color-index="1">\n              ':'\n                <span class="color-picker-value-green"></span>\n              ')+"\n            </div>\n          ":"")+'\n        </div>\n        <div class="color-picker-slider-wrap">\n          '+(a?'\n            <div class="color-picker-slider-label">'+s+"</div>\n          ":"")+'\n          <div class="range-slider color-picker-slider color-picker-slider-blue"></div>\n          '+(r?'\n            <div class="color-picker-slider-value">\n              '+(n?'\n                <input type="number" step="1" min="0" max="255" class="color-picker-value-blue" data-color-index="2">\n              ':'\n                <span class="color-picker-value-blue"></span>\n              ')+"\n            </div>\n          ":"")+"\n        </div>\n      </div>\n    "},init:function(e){function t(t){var a=[].concat(e.value.rgb),r=parseInt($(t.target).attr("data-color-index"),10),n=parseInt(t.target.value,10);Number.isNaN(n)?t.target.value=a[r]:(n=Math.max(0,Math.min(255,n)),a[r]=n,e.setValue({rgb:a}))}e.redRangeSlider=e.app.range.create({el:e.$el.find(".color-picker-slider-red"),min:0,max:255,step:1,value:0,on:{change:function(t,a){e.setValue({rgb:[a,e.value.rgb[1],e.value.rgb[2]]})}}}),e.greenRangeSlider=e.app.range.create({el:e.$el.find(".color-picker-slider-green"),min:0,max:255,step:1,value:0,on:{change:function(t,a){e.setValue({rgb:[e.value.rgb[0],a,e.value.rgb[2]]})}}}),e.blueRangeSlider=e.app.range.create({el:e.$el.find(".color-picker-slider-blue"),min:0,max:255,step:1,value:0,on:{change:function(t,a){e.setValue({rgb:[e.value.rgb[0],e.value.rgb[1],a]})}}}),e.$el.on("change",".color-picker-module-rgb-sliders input",t),e.destroyRgbSlidersEvents=function(){e.$el.off("change",".color-picker-module-rgb-sliders input",t)}},update:function(e){var t=e.app,a=e.value,r=e.redRangeSlider,n=e.greenRangeSlider,i=e.blueRangeSlider,o=e.params,s=o.sliderValue,l=o.sliderValueEditable,p=a.rgb;r.value=p[0],n.value=p[1],i.value=p[2],r.layout(),n.layout(),i.layout(),r.$el[0].style.setProperty("--f7-range-knob-color","rgb("+p[0]+", "+p[1]+", "+p[2]+")"),n.$el[0].style.setProperty("--f7-range-knob-color","rgb("+p[0]+", "+p[1]+", "+p[2]+")"),i.$el[0].style.setProperty("--f7-range-knob-color","rgb("+p[0]+", "+p[1]+", "+p[2]+")");var c=t.rtl?"to left":"to right";r.$el.find(".range-bar").css("background-image","linear-gradient("+c+", rgb(0, "+p[1]+", "+p[2]+"), rgb(255, "+p[1]+", "+p[2]+"))"),n.$el.find(".range-bar").css("background-image","linear-gradient("+c+", rgb("+p[0]+", 0, "+p[2]+"), rgb("+p[0]+", 255, "+p[2]+"))"),i.$el.find(".range-bar").css("background-image","linear-gradient("+c+", rgb("+p[0]+", "+p[1]+", 0), rgb("+p[0]+", "+p[1]+", 255))"),s&&l?(e.$el.find("input.color-picker-value-red").val(p[0]),e.$el.find("input.color-picker-value-green").val(p[1]),e.$el.find("input.color-picker-value-blue").val(p[2])):s&&(e.$el.find("span.color-picker-value-red").text(p[0]),e.$el.find("span.color-picker-value-green").text(p[1]),e.$el.find("span.color-picker-value-blue").text(p[2]))},destroy:function(e){e.redRangeSlider&&e.redRangeSlider.destroy&&e.redRangeSlider.destroy(),e.greenRangeSlider&&e.greenRangeSlider.destroy&&e.greenRangeSlider.destroy(),e.blueRangeSlider&&e.blueRangeSlider.destroy&&e.blueRangeSlider.destroy(),delete e.redRangeSlider,delete e.greenRangeSlider,delete e.blueRangeSlider,e.destroyRgbSlidersEvents&&e.destroyRgbSlidersEvents(),delete e.destroyRgbSlidersEvents}},moduleSbSpectrum={render:function(){return'\n      <div class="color-picker-module color-picker-module-sb-spectrum">\n        <div class="color-picker-sb-spectrum" style="background-color: hsl(0, 100%, 50%)">\n          <div class="color-picker-sb-spectrum-handle"></div>\n        </div>\n      </div>\n    '},init:function(e){var t,a,r,n,i,o,s,l,p=e.app,c=e.$el;function d(t,a){var r=(t-o.left)/o.width,n=(a-o.top)/o.height;r=Math.max(0,Math.min(1,r)),n=1-Math.max(0,Math.min(1,n)),e.setValue({hsb:[e.value.hue,r,n]})}function u(e){if(!t){a="touchstart"===e.type?e.targetTouches[0].pageX:e.pageX,n=a,r="touchstart"===e.type?e.targetTouches[0].pageY:e.pageY,i=r;var p=$(e.target);(l=p.closest(".color-picker-sb-spectrum-handle").length>0)||(s=p.closest(".color-picker-sb-spectrum").length>0),s&&(o=c.find(".color-picker-sb-spectrum")[0].getBoundingClientRect(),d(a,r)),(l||s)&&c.find(".color-picker-sb-spectrum-handle").addClass("color-picker-sb-spectrum-handle-pressed")}}function h(e){(s||l)&&(n="touchmove"===e.type?e.targetTouches[0].pageX:e.pageX,i="touchmove"===e.type?e.targetTouches[0].pageY:e.pageY,e.preventDefault(),t||(t=!0,l&&(o=c.find(".color-picker-sb-spectrum")[0].getBoundingClientRect())),(s||l)&&d(n,i))}function f(){t=!1,(s||l)&&c.find(".color-picker-sb-spectrum-handle").removeClass("color-picker-sb-spectrum-handle-pressed"),s=!1,l=!1}function m(){e.modules["sb-spectrum"].update(e)}var v=!("touchstart"!==p.touchEvents.start||!p.support.passiveListener)&&{passive:!0,capture:!1};e.$el.on(p.touchEvents.start,u,v),p.on("touchmove:active",h),p.on("touchend:passive",f),p.on("resize",m),e.destroySpectrumEvents=function(){e.$el.off(p.touchEvents.start,u,v),p.off("touchmove:active",h),p.off("touchend:passive",f),p.off("resize",m)}},update:function(e){var t=e.value,a=t.hsl,r=t.hsb,n=e.$el.find(".color-picker-sb-spectrum")[0].offsetWidth,i=e.$el.find(".color-picker-sb-spectrum")[0].offsetHeight;e.$el.find(".color-picker-sb-spectrum").css("background-color","hsl("+a[0]+", 100%, 50%)"),e.$el.find(".color-picker-sb-spectrum-handle").css("background-color","hsl("+a[0]+", "+100*a[1]+"%, "+100*a[2]+"%)").transform("translate("+n*r[1]+"px, "+i*(1-r[2])+"px)")},destroy:function(e){e.destroySpectrumEvents&&e.destroySpectrumEvents(),delete e.destroySpectrumEvents}},moduleHsSpectrum={render:function(){return'\n      <div class="color-picker-module color-picker-module-hs-spectrum">\n        <div class="color-picker-hs-spectrum">\n          <div class="color-picker-hs-spectrum-handle"></div>\n        </div>\n      </div>\n    '},init:function(e){var t,a,r,n,i,o,s,l,p=e.app,c=e.$el;function d(t,a){var r=(t-o.left)/o.width*360,n=(a-o.top)/o.height;r=Math.max(0,Math.min(360,r)),n=1-Math.max(0,Math.min(1,n)),e.setValue({hsb:[r,n,e.value.hsb[2]]})}function u(e){if(!t){a="touchstart"===e.type?e.targetTouches[0].pageX:e.pageX,n=a,r="touchstart"===e.type?e.targetTouches[0].pageY:e.pageY,i=r;var p=$(e.target);(l=p.closest(".color-picker-hs-spectrum-handle").length>0)||(s=p.closest(".color-picker-hs-spectrum").length>0),s&&(o=c.find(".color-picker-hs-spectrum")[0].getBoundingClientRect(),d(a,r)),(l||s)&&c.find(".color-picker-hs-spectrum-handle").addClass("color-picker-hs-spectrum-handle-pressed")}}function h(e){(s||l)&&(n="touchmove"===e.type?e.targetTouches[0].pageX:e.pageX,i="touchmove"===e.type?e.targetTouches[0].pageY:e.pageY,e.preventDefault(),t||(t=!0,l&&(o=c.find(".color-picker-hs-spectrum")[0].getBoundingClientRect())),(s||l)&&d(n,i))}function f(){t=!1,(s||l)&&c.find(".color-picker-hs-spectrum-handle").removeClass("color-picker-hs-spectrum-handle-pressed"),s=!1,l=!1}function m(){e.modules["hs-spectrum"].update(e)}var v=!("touchstart"!==p.touchEvents.start||!p.support.passiveListener)&&{passive:!0,capture:!1};e.$el.on(p.touchEvents.start,u,v),p.on("touchmove:active",h),p.on("touchend:passive",f),p.on("resize",m),e.destroySpectrumEvents=function(){e.$el.off(p.touchEvents.start,u,v),p.off("touchmove:active",h),p.off("touchend:passive",f),p.off("resize",m)}},update:function(e){var t=e.value.hsb,a=e.$el.find(".color-picker-hs-spectrum")[0].offsetWidth,r=e.$el.find(".color-picker-hs-spectrum")[0].offsetHeight,n=Utils.colorHsbToHsl(t[0],t[1],1);e.$el.find(".color-picker-hs-spectrum-handle").css("background-color","hsl("+n[0]+", "+100*n[1]+"%, "+100*n[2]+"%)").transform("translate("+a*(t[0]/360)+"px, "+r*(1-t[1])+"px)")},destroy:function(e){e.destroySpectrumEvents&&e.destroySpectrumEvents(),delete e.destroySpectrumEvents}};function svgWheelCircles(){for(var e="",t=256;t>0;t-=1){var a=t*Math.PI/128,r=1.40625*t;e+='<circle cx="'+(150-125*Math.sin(a))+'" cy="'+(150-125*Math.cos(a))+'" r="25" fill="hsl('+r+', 100%, 50%)"></circle>'}return e}var moduleWheel={render:function(){return'\n      <div class="color-picker-module color-picker-module-wheel">\n        <div class="color-picker-wheel">\n          <svg viewBox="0 0 300 300" width="300" height="300">'+svgWheelCircles()+'</svg>\n          <div class="color-picker-wheel-handle"></div>\n          <div class="color-picker-sb-spectrum" style="background-color: hsl(0, 100%, 50%)">\n            <div class="color-picker-sb-spectrum-handle"></div>\n          </div>\n        </div>\n      </div>\n    '},init:function(e){var t,a,r,n,i,o,s,l,p,c,d,u=e.app,h=e.$el;function f(t,a){var r=o.left+o.width/2,n=o.top+o.height/2,i=180*Math.atan2(a-n,t-r)/Math.PI+90;i<0&&(i+=360),i=360-i,e.setValue({hue:i})}function m(t,a){var r=(t-p.left)/p.width,n=(a-p.top)/p.height;r=Math.max(0,Math.min(1,r)),n=1-Math.max(0,Math.min(1,n)),e.setValue({hsb:[e.value.hue,r,n]})}function v(e){if(!t){a="touchstart"===e.type?e.targetTouches[0].pageX:e.pageX,n=a,r="touchstart"===e.type?e.targetTouches[0].pageY:e.pageY,i=r;var u=$(e.target);l=u.closest(".color-picker-wheel-handle").length>0,s=u.closest("circle").length>0,(d=u.closest(".color-picker-sb-spectrum-handle").length>0)||(c=u.closest(".color-picker-sb-spectrum").length>0),s&&(o=h.find(".color-picker-wheel")[0].getBoundingClientRect(),f(a,r)),c&&(p=h.find(".color-picker-sb-spectrum")[0].getBoundingClientRect(),m(a,r)),(d||c)&&h.find(".color-picker-sb-spectrum-handle").addClass("color-picker-sb-spectrum-handle-pressed")}}function g(e){(s||l||c||d)&&(n="touchmove"===e.type?e.targetTouches[0].pageX:e.pageX,i="touchmove"===e.type?e.targetTouches[0].pageY:e.pageY,e.preventDefault(),t||(t=!0,l&&(o=h.find(".color-picker-wheel")[0].getBoundingClientRect()),d&&(p=h.find(".color-picker-sb-spectrum")[0].getBoundingClientRect())),(s||l)&&f(n,i),(c||d)&&m(n,i))}function b(){t=!1,(c||d)&&h.find(".color-picker-sb-spectrum-handle").removeClass("color-picker-sb-spectrum-handle-pressed"),s=!1,l=!1,c=!1,d=!1}function y(){e.modules.wheel.update(e)}var w=!("touchstart"!==u.touchEvents.start||!u.support.passiveListener)&&{passive:!0,capture:!1};e.$el.on(u.touchEvents.start,v,w),u.on("touchmove:active",g),u.on("touchend:passive",b),u.on("resize",y),e.destroyWheelEvents=function(){e.$el.off(u.touchEvents.start,v,w),u.off("touchmove:active",g),u.off("touchend:passive",b),u.off("resize",y)}},update:function(e){var t=e.value,a=t.hsl,r=t.hsb,n=e.$el.find(".color-picker-sb-spectrum")[0].offsetWidth,i=e.$el.find(".color-picker-sb-spectrum")[0].offsetHeight,o=e.$el.find(".color-picker-wheel")[0].offsetWidth,s=o/2,l=t.hue*Math.PI/180,p=o/6/2,c=s-Math.sin(l)*(s-p)-p,d=s-Math.cos(l)*(s-p)-p;e.$el.find(".color-picker-wheel-handle").css("background-color","hsl("+a[0]+", 100%, 50%)").transform("translate("+c+"px, "+d+"px)"),e.$el.find(".color-picker-sb-spectrum").css("background-color","hsl("+a[0]+", 100%, 50%)"),e.$el.find(".color-picker-sb-spectrum-handle").css("background-color","hsl("+a[0]+", "+100*a[1]+"%, "+100*a[2]+"%)").transform("translate("+n*r[1]+"px, "+i*(1-r[2])+"px)")},destroy:function(e){e.destroyWheelEvents&&e.destroyWheelEvents(),delete e.destroyWheelEvents}},ColorPicker=function(e){function t(t,a){void 0===a&&(a={}),e.call(this,a,[t]);var r,n,i,o=this;if(o.params=Utils.extend({},t.params.colorPicker,a),o.params.containerEl&&0===(r=$(o.params.containerEl)).length)return o;function s(){o.open()}function l(e){e.preventDefault()}function p(){o.open()}function c(e){if(!o.destroyed&&o.params&&"page"!==o.params.openIn){var t=$(e.target);o.opened&&!o.closing&&(t.closest('[class*="backdrop"]').length||t.closest(".color-picker-popup, .color-picker-popover").length||(n&&n.length>0?t[0]!==n[0]&&0===t.closest(".sheet-modal").length&&o.close():0===$(e.target).closest(".sheet-modal").length&&o.close()))}}return o.params.inputEl&&(n=$(o.params.inputEl)),o.params.targetEl&&(i=$(o.params.targetEl)),Utils.extend(o,{app:t,$containerEl:r,containerEl:r&&r[0],inline:r&&r.length>0,$inputEl:n,inputEl:n&&n[0],$targetEl:i,targetEl:i&&i[0],initialized:!1,opened:!1,url:o.params.url,modules:{"alpha-slider":moduleAlphaSlider,"current-color":moduleCurrentColor,hex:moduleHex,"hsb-sliders":moduleHsbSliders,"hue-slider":moduleHueSlider,"brightness-slider":moduleBrightnessSlider,palette:modulePalette,"initial-current-colors":moduleInitialCurrentColors,"rgb-bars":moduleRgbBars,"rgb-sliders":moduleRgbSliders,"sb-spectrum":moduleSbSpectrum,"hs-spectrum":moduleHsSpectrum,wheel:moduleWheel}}),Utils.extend(o,{attachInputEvents:function(){o.$inputEl.on("click",s),o.params.inputReadOnly&&o.$inputEl.on("focus mousedown",l)},detachInputEvents:function(){o.$inputEl.off("click",s),o.params.inputReadOnly&&o.$inputEl.off("focus mousedown",l)},attachTargetEvents:function(){o.$targetEl.on("click",p)},detachTargetEvents:function(){o.$targetEl.off("click",p)},attachHtmlEvents:function(){t.on("click",c)},detachHtmlEvents:function(){t.off("click",c)}}),o.init(),o}e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t;var a={view:{configurable:!0}};return a.view.get=function(){var e,t=this.$inputEl,a=this.$targetEl,r=this.app,n=this.params;return n.view?e=n.view:(t&&(e=t.parents(".view").length&&t.parents(".view")[0].f7View),!e&&a&&(e=a.parents(".view").length&&a.parents(".view")[0].f7View)),e||(e=r.views.main),e},t.prototype.attachEvents=function(){this.centerModules=this.centerModules.bind(this),this.params.centerModules&&this.app.on("resize",this.centerModules)},t.prototype.detachEvents=function(){this.params.centerModules&&this.app.off("resize",this.centerModules)},t.prototype.centerModules=function(){if(this.opened&&this.$el&&!this.inline){var e=this.$el.find(".page-content");if(e.length){var t=e[0];t.scrollHeight<=t.offsetHeight?e.addClass("justify-content-center"):e.removeClass("justify-content-center")}}},t.prototype.initInput=function(){this.$inputEl&&this.params.inputReadOnly&&this.$inputEl.prop("readOnly",!0)},t.prototype.getModalType=function(){var e=this.app,t=this.modal,a=this.params,r=a.openIn,n=a.openInPhone;return t&&t.type?t.type:"auto"!==r?r:this.inline?null:e.device.ios?e.device.ipad?"popover":n:e.width>=768||e.device.desktop&&"aurora"===e.theme?"popover":n},t.prototype.formatValue=function(){var e=this.value;return this.params.formatValue?this.params.formatValue.call(this,e):e.hex},t.prototype.normalizeHsValues=function(e){return[Math.floor(10*e[0])/10,Math.floor(1e3*e[1])/1e3,Math.floor(1e3*e[2])/1e3]},t.prototype.setValue=function(e,t){void 0===e&&(e={}),void 0===t&&(t=!0);var a=this;if(void 0!==e){var r=a.value||{},n=r.hex,i=r.rgb,o=r.hsl,s=r.hsb,l=r.alpha;void 0===l&&(l=1);var p,c=r.hue,d=r.rgba,u=r.hsla,h=a.value||!a.value&&!a.params.value;if(Object.keys(e).forEach((function(t){if(a.value&&void 0!==a.value[t]){var r=e[t];Array.isArray(r)?r.forEach((function(e,r){e!==a.value[t][r]&&(p=!0)})):r!==a.value[t]&&(p=!0)}else p=!0})),p){if(e.rgb||e.rgba){var f=e.rgb||e.rgba,m=f[0],v=f[1],g=f[2],b=f[3];void 0===b&&(b=l),i=[m,v,g],n=Utils.colorRgbToHex.apply(Utils,i),o=Utils.colorRgbToHsl.apply(Utils,i),s=Utils.colorHslToHsb.apply(Utils,o),o=a.normalizeHsValues(o),c=(s=a.normalizeHsValues(s))[0],l=b,d=[i[0],i[1],i[2],b],u=[o[0],o[1],o[2],b]}if(e.hsl||e.hsla){var y=e.hsl||e.hsla,w=y[0],C=y[1],x=y[2],$=y[3];void 0===$&&($=l),o=[w,C,x],i=Utils.colorHslToRgb.apply(Utils,o),n=Utils.colorRgbToHex.apply(Utils,i),s=Utils.colorHslToHsb.apply(Utils,o),o=a.normalizeHsValues(o),c=(s=a.normalizeHsValues(s))[0],l=$,d=[i[0],i[1],i[2],$],u=[o[0],o[1],o[2],$]}if(e.hsb){var k=e.hsb,E=k[0],T=k[1],S=k[2],M=k[3];void 0===M&&(M=l),s=[E,T,S],o=Utils.colorHsbToHsl.apply(Utils,s),i=Utils.colorHslToRgb.apply(Utils,o),n=Utils.colorRgbToHex.apply(Utils,i),o=a.normalizeHsValues(o),c=(s=a.normalizeHsValues(s))[0],l=M,d=[i[0],i[1],i[2],M],u=[o[0],o[1],o[2],M]}if(e.hex&&(i=Utils.colorHexToRgb(e.hex),n=Utils.colorRgbToHex.apply(Utils,i),o=Utils.colorRgbToHsl.apply(Utils,i),s=Utils.colorHslToHsb.apply(Utils,o),o=a.normalizeHsValues(o),c=(s=a.normalizeHsValues(s))[0],d=[i[0],i[1],i[2],l],u=[o[0],o[1],o[2],l]),void 0!==e.alpha&&(l=e.alpha,void 0!==i&&(d=[i[0],i[1],i[2],l]),void 0!==o&&(u=[o[0],o[1],o[2],l])),void 0!==e.hue){o[0];var P=o[1],O=o[2];o=[e.hue,P,O],s=Utils.colorHslToHsb.apply(Utils,o),i=Utils.colorHslToRgb.apply(Utils,o),n=Utils.colorRgbToHex.apply(Utils,i),o=a.normalizeHsValues(o),c=(s=a.normalizeHsValues(s))[0],d=[i[0],i[1],i[2],l],u=[o[0],o[1],o[2],l]}a.value={hex:n,alpha:l,hue:c,rgb:i,hsl:o,hsb:s,rgba:d,hsla:u},a.initialValue||(a.initialValue=Utils.extend({},a.value)),a.updateValue(h),a.opened&&t&&a.updateModules()}}},t.prototype.getValue=function(){return this.value},t.prototype.updateValue=function(e){void 0===e&&(e=!0);var t=this.$inputEl,a=this.value,r=this.$targetEl;if(r&&this.params.targetElSetBackgroundColor){var n=a.rgba;r.css("background-color","rgba("+n.join(", ")+")")}if(e&&this.emit("local::change colorPickerChange",this,a),t&&t.length){var i=this.formatValue(a);t&&t.length&&(t.val(i),e&&t.trigger("change"))}},t.prototype.updateModules=function(){var e=this,t=e.modules;e.params.modules.forEach((function(a){"string"==typeof a&&t[a]&&t[a].update?t[a].update(e):a&&a.update&&a.update(e)}))},t.prototype.update=function(){this.updateModules()},t.prototype.renderPicker=function(){var e=this,t=e.params,a=e.modules,r="";return t.modules.forEach((function(t){"string"==typeof t&&a[t]&&a[t].render?r+=a[t].render(e):t&&t.render&&(r+=t.render(e))})),r},t.prototype.renderNavbar=function(){if(this.params.renderNavbar)return this.params.renderNavbar.call(this,this);var e=this.params,t=e.openIn,a=e.navbarTitleText,r=e.navbarBackLinkText,n=e.navbarCloseText;return('\n    <div class="navbar">\n      <div class="navbar-bg"></div>\n      <div class="navbar-inner sliding">\n        '+("page"===t?'\n        <div class="left">\n          <a class="link back">\n            <i class="icon icon-back"></i>\n            <span class="if-not-md">'+r+"</span>\n          </a>\n        </div>\n        ":"")+'\n        <div class="title">'+a+"</div>\n        "+("page"!==t?'\n        <div class="right">\n          <a class="link popup-close" data-popup=".color-picker-popup">'+n+"</a>\n        </div>\n        ":"")+"\n      </div>\n    </div>\n  ").trim()},t.prototype.renderToolbar=function(){return this.params.renderToolbar?this.params.renderToolbar.call(this,this):('\n    <div class="toolbar toolbar-top no-shadow">\n      <div class="toolbar-inner">\n        <div class="left"></div>\n        <div class="right">\n          <a class="link sheet-close popover-close" data-sheet=".color-picker-sheet-modal" data-popover=".color-picker-popover">'+this.params.toolbarCloseText+"</a>\n        </div>\n      </div>\n    </div>\n  ").trim()},t.prototype.renderInline=function(){var e=this.params,t=e.cssClass;return('\n    <div class="color-picker color-picker-inline '+(e.groupedModules?"color-picker-grouped-modules":"")+" "+(t||"")+'">\n      '+this.renderPicker()+"\n    </div>\n  ").trim()},t.prototype.renderSheet=function(){var e=this.params,t=e.cssClass,a=e.toolbarSheet;return('\n    <div class="sheet-modal color-picker color-picker-sheet-modal '+(e.groupedModules?"color-picker-grouped-modules":"")+" "+(t||"")+'">\n      '+(a?this.renderToolbar():"")+'\n      <div class="sheet-modal-inner">\n        <div class="page-content">\n          '+this.renderPicker()+"\n        </div>\n      </div>\n    </div>\n  ").trim()},t.prototype.renderPopover=function(){var e=this.params,t=e.cssClass,a=e.toolbarPopover;return('\n    <div class="popover color-picker-popover '+(t||"")+'">\n      <div class="popover-inner">\n        <div class="color-picker '+(e.groupedModules?"color-picker-grouped-modules":"")+'">\n          '+(a?this.renderToolbar():"")+'\n          <div class="page-content">\n            '+this.renderPicker()+"\n          </div>\n        </div>\n      </div>\n    </div>\n  ").trim()},t.prototype.renderPopup=function(){var e=this.params,t=e.cssClass,a=e.navbarPopup,r=e.groupedModules;return('\n    <div class="popup color-picker-popup '+(t||"")+'">\n      <div class="page">\n        '+(a?this.renderNavbar():"")+'\n        <div class="color-picker '+(r?"color-picker-grouped-modules":"")+'">\n          <div class="page-content">\n            '+this.renderPicker()+"\n          </div>\n        </div>\n      </div>\n    </div>\n  ").trim()},t.prototype.renderPage=function(){var e=this.params,t=e.cssClass,a=e.groupedModules;return('\n    <div class="page color-picker-page '+(t||"")+'" data-name="color-picker-page">\n      '+this.renderNavbar()+'\n      <div class="color-picker '+(a?"color-picker-grouped-modules":"")+'">\n        <div class="page-content">\n          '+this.renderPicker()+"\n        </div>\n      </div>\n    </div>\n  ").trim()},t.prototype.render=function(){var e=this.params;if(e.render)return e.render.call(this);if(this.inline)return this.renderInline();if("page"===e.openIn)return this.renderPage();var t=this.getModalType();return"popover"===t?this.renderPopover():"sheet"===t?this.renderSheet():"popup"===t?this.renderPopup():void 0},t.prototype.onOpen=function(){var e=this,t=e.initialized,a=e.$el,r=e.app,n=e.$inputEl,i=e.inline,o=e.value,s=e.params,l=e.modules;e.closing=!1,e.opened=!0,e.opening=!0,e.attachEvents(),s.modules.forEach((function(t){"string"==typeof t&&l[t]&&l[t].init?l[t].init(e):t&&t.init&&t.init(e)}));var p=!o&&s.value;t?o&&(e.initialValue=Utils.extend({},o),e.setValue(o,!1)):o?e.setValue(o):s.value?e.setValue(s.value,!1):s.value||e.setValue({hex:"#ff0000"},!1),p&&e.updateValue(),e.updateModules(),s.centerModules&&e.centerModules(),!i&&n&&n.length&&"md"===r.theme&&n.trigger("focus"),e.initialized=!0,a&&a.trigger("colorpicker:open"),n&&n.trigger("colorpicker:open"),e.emit("local::open colorPickerOpen",e)},t.prototype.onOpened=function(){this.opening=!1,this.$el&&this.$el.trigger("colorpicker:opened"),this.$inputEl&&this.$inputEl.trigger("colorpicker:opened"),this.emit("local::opened colorPickerOpened",this)},t.prototype.onClose=function(){var e=this,t=e.app,a=e.params,r=e.modules;e.opening=!1,e.closing=!0,e.detachEvents(),e.$inputEl&&"md"===t.theme&&e.$inputEl.trigger("blur"),a.modules.forEach((function(t){"string"==typeof t&&r[t]&&r[t].destroy?r[t].destroy(e):t&&t.destroy&&t.destroy(e)})),e.$el&&e.$el.trigger("colorpicker:close"),e.$inputEl&&e.$inputEl.trigger("colorpicker:close"),e.emit("local::close colorPickerClose",e)},t.prototype.onClosed=function(){var e=this;e.opened=!1,e.closing=!1,e.inline||Utils.nextTick((function(){e.modal&&e.modal.el&&e.modal.destroy&&(e.params.routableModals||e.modal.destroy()),delete e.modal})),e.$el&&e.$el.trigger("colorpicker:closed"),e.$inputEl&&e.$inputEl.trigger("colorpicker:closed"),e.emit("local::closed colorPickerClosed",e)},t.prototype.open=function(){var e,t=this,a=t.app,r=t.opened,n=t.inline,i=t.$inputEl,o=t.$targetEl,s=t.params;if(!r){if(n)return t.$el=$(t.render()),t.$el[0].f7ColorPicker=t,t.$containerEl.append(t.$el),t.onOpen(),void t.onOpened();var l=t.render();if("page"===s.openIn)t.view.router.navigate({url:t.url,route:{content:l,path:t.url,on:{pageBeforeIn:function(e,a){t.$el=a.$el.find(".color-picker"),t.$el[0].f7ColorPicker=t,t.onOpen()},pageAfterIn:function(){t.onOpened()},pageBeforeOut:function(){t.onClose()},pageAfterOut:function(){t.onClosed(),t.$el&&t.$el[0]&&(t.$el[0].f7ColorPicker=null,delete t.$el[0].f7ColorPicker)}}}});else{var p=t.getModalType(),c=s.backdrop;null==c&&("popover"===p&&!1!==a.params.popover.backdrop&&(c=!0),"popup"===p&&(c=!0));var d={targetEl:o||i,scrollToEl:s.scrollToInput?o||i:void 0,content:l,backdrop:c,closeByBackdropClick:s.closeByBackdropClick,on:{open:function(){t.modal=this,t.$el="popover"===p||"popup"===p?this.$el.find(".color-picker"):this.$el,t.$el[0].f7ColorPicker=t,t.onOpen()},opened:function(){t.onOpened()},close:function(){t.onClose()},closed:function(){t.onClosed(),t.$el&&t.$el[0]&&(t.$el[0].f7ColorPicker=null,delete t.$el[0].f7ColorPicker)}}};"popup"===p&&(d.push=s.popupPush,d.swipeToClose=s.popupSwipeToClose),"sheet"===p&&(d.push=s.sheetPush,d.swipeToClose=s.sheetSwipeToClose),s.routableModals&&t.view?t.view.router.navigate({url:t.url,route:(e={path:t.url},e[p]=d,e)}):(t.modal=a[p].create(d),t.modal.open())}}},t.prototype.close=function(){var e=this.opened,t=this.inline;if(e)return t?(this.onClose(),void this.onClosed()):void(this.params.routableModals&&this.view||"page"===this.params.openIn?this.view.router.back():this.modal.close())},t.prototype.init=function(){if(this.initInput(),this.inline)return this.open(),void this.emit("local::init colorPickerInit",this);!this.initialized&&this.params.value&&this.setValue(this.params.value),this.$inputEl&&this.attachInputEvents(),this.$targetEl&&this.attachTargetEvents(),this.params.closeByOutsideClick&&this.attachHtmlEvents(),this.emit("local::init colorPickerInit",this)},t.prototype.destroy=function(){if(!this.destroyed){var e=this.$el;this.emit("local::beforeDestroy colorPickerBeforeDestroy",this),e&&e.trigger("colorpicker:beforedestroy"),this.close(),this.detachEvents(),this.$inputEl&&this.detachInputEvents(),this.$targetEl&&this.detachTargetEvents(),this.params.closeByOutsideClick&&this.detachHtmlEvents(),e&&e.length&&delete this.$el[0].f7ColorPicker,Utils.deleteProps(this),this.destroyed=!0}},Object.defineProperties(t.prototype,a),t}(Framework7Class),ColorPicker$1={name:"colorPicker",static:{ColorPicker:ColorPicker},create:function(){this.colorPicker=ConstructorMethods({defaultSelector:".color-picker",constructor:ColorPicker,app:this,domProp:"f7ColorPicker"}),this.colorPicker.close=function(e){void 0===e&&(e=".color-picker");var t=$(e);if(0!==t.length){var a=t[0].f7ColorPicker;!a||a&&!a.opened||a.close()}}},params:{colorPicker:{value:null,modules:["wheel"],palette:[["#FFEBEE","#FFCDD2","#EF9A9A","#E57373","#EF5350","#F44336","#E53935","#D32F2F","#C62828","#B71C1C"],["#F3E5F5","#E1BEE7","#CE93D8","#BA68C8","#AB47BC","#9C27B0","#8E24AA","#7B1FA2","#6A1B9A","#4A148C"],["#E8EAF6","#C5CAE9","#9FA8DA","#7986CB","#5C6BC0","#3F51B5","#3949AB","#303F9F","#283593","#1A237E"],["#E1F5FE","#B3E5FC","#81D4FA","#4FC3F7","#29B6F6","#03A9F4","#039BE5","#0288D1","#0277BD","#01579B"],["#E0F2F1","#B2DFDB","#80CBC4","#4DB6AC","#26A69A","#009688","#00897B","#00796B","#00695C","#004D40"],["#F1F8E9","#DCEDC8","#C5E1A5","#AED581","#9CCC65","#8BC34A","#7CB342","#689F38","#558B2F","#33691E"],["#FFFDE7","#FFF9C4","#FFF59D","#FFF176","#FFEE58","#FFEB3B","#FDD835","#FBC02D","#F9A825","#F57F17"],["#FFF3E0","#FFE0B2","#FFCC80","#FFB74D","#FFA726","#FF9800","#FB8C00","#F57C00","#EF6C00","#E65100"]],groupedModules:!1,centerModules:!0,sliderLabel:!1,sliderValue:!1,sliderValueEdiable:!1,barLabel:!1,barValue:!1,barValueEdiable:!1,hexLabel:!1,hexValueEditable:!1,redLabelText:"R",greenLabelText:"G",blueLabelText:"B",hueLabelText:"H",saturationLabelText:"S",brightnessLabelText:"B",hexLabelText:"HEX",alphaLabelText:"A",containerEl:null,openIn:"popover",openInPhone:"popup",popupPush:!1,popupSwipeToClose:void 0,sheetPush:!1,sheetSwipeToClose:void 0,formatValue:null,targetEl:null,targetElSetBackgroundColor:!1,inputEl:null,inputReadOnly:!0,closeByOutsideClick:!0,scrollToInput:!0,toolbarSheet:!0,toolbarPopover:!1,toolbarCloseText:"Done",navbarPopup:!0,navbarCloseText:"Done",navbarTitleText:"Color",navbarBackLinkText:"Back",cssClass:null,routableModals:!0,view:null,url:"color/",backdrop:null,closeByBackdropClick:!0,renderToolbar:null,renderNavbar:null,renderInline:null,renderPopover:null,renderSheet:null,renderPopup:null,render:null}}},Treeview={open:function(e){var t=this,a=$(e).eq(0);function r(e){e?(a.removeClass("treeview-item-opened"),a.trigger("treeview:close"),t.emit("treeviewClose",a[0])):a[0].f7TreeviewChildrenLoaded=!0,a.find(".treeview-toggle").removeClass("treeview-toggle-hidden"),a.find(".treeview-preloader").remove()}a.length&&(a.addClass("treeview-item-opened"),a.trigger("treeview:open"),t.emit("treeviewOpen",a[0]),a.hasClass("treeview-load-children")&&!a[0].f7TreeviewChildrenLoaded&&(a.trigger("treeview:loadchildren",r),t.emit("treeviewLoadChildren",a[0],r),a.find(".treeview-toggle").addClass("treeview-toggle-hidden"),a.find(".treeview-item-root").prepend('<div class="preloader treeview-preloader">'+Utils[t.theme+"PreloaderContent"]+"</div>")))},close:function(e){var t=$(e).eq(0);t.length&&(t.removeClass("treeview-item-opened"),t.trigger("treeview:close"),this.emit("treeviewClose",t[0]))},toggle:function(e){var t=$(e).eq(0);if(t.length){var a=t.hasClass("treeview-item-opened");this.treeview[a?"close":"open"](t)}}},Treeview$1={name:"treeview",create:function(){Utils.extend(this,{treeview:{open:Treeview.open.bind(this),close:Treeview.close.bind(this),toggle:Treeview.toggle.bind(this)}})},clicks:{".treeview-toggle":function(e,t,a){if(!e.parents(".treeview-item-toggle").length){var r=e.parents(".treeview-item").eq(0);r.length&&(a.preventF7Router=!0,this.treeview.toggle(r[0]))}},".treeview-item-toggle":function(e,t,a){var r=e.closest(".treeview-item").eq(0);r.length&&(a.preventF7Router=!0,this.treeview.toggle(r[0]))}}},textEditorButtonsMap={bold:["bold","format_bold","bold"],italic:["italic","format_italic","italic"],underline:["underline","format_underline","underline"],strikeThrough:["strikethrough","strikethrough_s","strikeThrough"],orderedList:["list_number","format_list_numbered","insertOrderedList"],unorderedList:["list_bullet","format_list_bulleted","insertUnorderedList"],link:["link","link","createLink"],image:["photo","image","insertImage"],paragraph:["paragraph",'<i class="icon">¶</i>',"formatBlock.P"],h1:['<i class="icon">H<sub>1</sub></i>','<i class="icon">H<sub>1</sub></i>',"formatBlock.H1"],h2:['<i class="icon">H<sub>2</sub></i>','<i class="icon">H<sub>2</sub></i>',"formatBlock.H2"],h3:['<i class="icon">H<sub>3</sub></i>','<i class="icon">H<sub>3</sub></i>',"formatBlock.H3"],alignLeft:["text_alignleft","format_align_left","justifyLeft"],alignCenter:["text_aligncenter","format_align_center","justifyCenter"],alignRight:["text_alignright","format_align_right","justifyRight"],alignJustify:["text_justify","format_align_justify","justifyFull"],subscript:["textformat_subscript",'<i class="icon">A<sub>1</sub></i>',"subscript"],superscript:["textformat_superscript",'<i class="icon">A<sup>1</sup></i>',"superscript"],indent:["increase_indent","format_indent_increase","indent"],outdent:["decrease_indent","format_indent_decrease","outdent"]},TextEditor=function(e){function t(t,a){e.call(this,a,[t]);var r=this,n=Utils.extend({},t.params.textEditor);r.useModulesParams(n),r.params=Utils.extend(n,a);var i=r.params.el;if(!i)return r;var o=$(i);if(0===o.length)return r;if(o[0].f7TextEditor)return o[0].f7TextEditor;var s=o.children(".text-editor-content");if(s.length||(o.append('<div class="text-editor-content" contenteditable></div>'),s=o.children(".text-editor-content")),Utils.extend(r,{app:t,$el:o,el:o[0],$contentEl:s,contentEl:s[0]}),"value"in a&&(r.value=r.params.value),"keyboard-toolbar"===r.params.mode&&(t.device.cordova||t.device.android||(r.params.mode="popover")),"string"==typeof r.params.buttons)try{r.params.buttons=JSON.parse(r.params.buttons)}catch(e){throw new Error('Framework7: TextEditor: wrong "buttons" parameter format')}return o[0].f7TextEditor=r,r.onButtonClick=r.onButtonClick.bind(r),r.onFocus=r.onFocus.bind(r),r.onBlur=r.onBlur.bind(r),r.onInput=r.onInput.bind(r),r.onPaste=r.onPaste.bind(r),r.onSelectionChange=r.onSelectionChange.bind(r),r.closeKeyboardToolbar=r.closeKeyboardToolbar.bind(r),r.attachEvents=function(){"toolbar"===r.params.mode&&r.$el.find(".text-editor-toolbar").on("click","button",r.onButtonClick),"keyboard-toolbar"===r.params.mode&&(r.$keyboardToolbarEl.on("click","button",r.onButtonClick),r.$el.parents(".page").on("page:beforeout",r.closeKeyboardToolbar)),"popover"===r.params.mode&&r.popover&&r.popover.$el.on("click","button",r.onButtonClick),r.$contentEl.on("paste",r.onPaste),r.$contentEl.on("focus",r.onFocus),r.$contentEl.on("blur",r.onBlur),r.$contentEl.on("input",r.onInput,!0),$(doc).on("selectionchange",r.onSelectionChange)},r.detachEvents=function(){"toolbar"===r.params.mode&&r.$el.find(".text-editor-toolbar").off("click","button",r.onButtonClick),"keyboard-toolbar"===r.params.mode&&(r.$keyboardToolbarEl.off("click","button",r.onButtonClick),r.$el.parents(".page").off("page:beforeout",r.closeKeyboardToolbar)),"popover"===r.params.mode&&r.popover&&r.popover.$el.off("click","button",r.onButtonClick),r.$contentEl.off("paste",r.onPaste),r.$contentEl.off("focus",r.onFocus),r.$contentEl.off("blur",r.onBlur),r.$contentEl.off("input",r.onInput,!0),$(doc).off("selectionchange",r.onSelectionChange)},r.useModules(),r.init(),r}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t.prototype.setValue=function(e){return this.value===e||(this.value=e,this.$contentEl.html(e),this.$el.trigger("texteditor:change",this.value),this.emit("local::change textEditorChange",this,this.value)),this},t.prototype.getValue=function(){return this.value},t.prototype.createLink=function(){var e,t=this,a=win.getSelection(),r=[];if(a&&a.anchorNode&&$(a.anchorNode).parents(t.$el).length){for(var n=a.anchorNode;n;)r.push(n),n.nextSibling&&n!==a.focusNode||(n=null),n&&(n=n.nextSibling);e=$(r).closest("a").add($(r).children("a"))}if(e&&e.length)return e.each((function(e,t){var a=win.getSelection(),r=doc.createRange();r.selectNodeContents(t),a.removeAllRanges(),a.addRange(r),doc.execCommand("unlink",!1),a.removeAllRanges()})),t;var i=t.getSelectionRange();return i?(t.app.dialog.prompt(t.params.linkUrlText,"",(function(e){e&&e.trim().length&&(t.setSelectionRange(i),doc.execCommand("createLink",!1,e.trim()))})).$el.find("input").focus(),t):t},t.prototype.insertImage=function(){var e=this,t=e.getSelectionRange();return t?(e.app.dialog.prompt(e.params.imageUrlText,"",(function(a){a&&a.trim().length&&(e.setSelectionRange(t),doc.execCommand("insertImage",!1,a.trim()))})).$el.find("input").focus(),e):e},t.prototype.removePlaceholder=function(){this.$contentEl.find(".text-editor-placeholder").remove()},t.prototype.insertPlaceholder=function(){this.$contentEl.append('<div class="text-editor-placeholder">'+this.params.placeholder+"</div>")},t.prototype.onSelectionChange=function(){if("toolbar"!==this.params.mode){var e=win.getSelection(),t=$(e.anchorNode).parents(this.contentEl).length||e.anchorNode===this.contentEl;if("keyboard-toolbar"!==this.params.mode){if("popover"===this.params.mode){var a=$(e.anchorNode).parents(this.popover.el).length||e.anchorNode===this.popover.el;if(!t&&!a)return void this.closePopover();if(!e.isCollapsed&&e.rangeCount){var r=e.getRangeAt(0).getBoundingClientRect();this.openPopover(r.x+(win.scrollX||0),r.y+(win.scrollY||0),r.width,r.height)}else e.isCollapsed&&this.closePopover()}}else t?this.openKeyboardToolbar():this.closeKeyboardToolbar()}},t.prototype.onPaste=function(e){if(this.params.clearFormattingOnPaste&&e.clipboardData&&e.clipboardData.getData){var t=e.clipboardData.getData("text/plain");e.preventDefault(),doc.execCommand("insertText",!1,t)}},t.prototype.onInput=function(){var e=this.$contentEl.html();this.$el.trigger("texteditor:input"),this.emit("local:input textEditorInput",this),this.value=e,this.$el.trigger("texteditor:change",this.value),this.emit("local::change textEditorChange",this,this.value)},t.prototype.onFocus=function(){this.removePlaceholder(),this.$contentEl.focus(),this.$el.trigger("texteditor:focus"),this.emit("local::focus textEditorFocus",this)},t.prototype.onBlur=function(){if(this.params.placeholder&&""===this.$contentEl.html()&&this.insertPlaceholder(),"popover"===this.params.mode){var e=win.getSelection(),t=$(e.anchorNode).parents(this.contentEl).length||e.anchorNode===this.contentEl;doc.activeElement&&this.popover&&$(doc.activeElement).closest(this.popover.$el).length||t||this.closePopover()}if("keyboard-toolbar"===this.params.mode){var a=win.getSelection();$(a.anchorNode).parents(this.contentEl).length||a.anchorNode===this.contentEl||this.closeKeyboardToolbar()}this.$el.trigger("texteditor:blur"),this.emit("local::blur textEditorBlur",this)},t.prototype.onButtonClick=function(e){var t=win.getSelection();if($(t.anchorNode).parents(this.contentEl).length||t.anchorNode===this.contentEl){var a=$(e.target).closest("button");a.parents("form").length&&e.preventDefault();var r=a.attr("data-button"),n=this.params.customButtons&&this.params.customButtons[r];if(r&&(textEditorButtonsMap[r]||n))if(a.trigger("texteditor:buttonclick",r),this.emit("local::buttonClick textEditorButtonClick",this,r),n)n.onClick&&n.onClick(this,a[0]);else{var i=textEditorButtonsMap[r][2];if("createLink"!==i)if("insertImage"!==i)if(0!==i.indexOf("formatBlock"))doc.execCommand(i,!1);else{var o=i.split(".")[1],s=$(t.anchorNode);s.parents(o.toLowerCase()).length||s.is(o)?doc.execCommand("formatBlock",!1,"div"):doc.execCommand("formatBlock",!1,o)}else this.insertImage();else this.createLink()}}},t.prototype.getSelectionRange=function(){if(win.getSelection){var e=win.getSelection();if(e.getRangeAt&&e.rangeCount)return e.getRangeAt(0)}else if(doc.selection&&doc.selection.createRange)return doc.selection.createRange();return null},t.prototype.setSelectionRange=function(e){if(e)if(win.getSelection){var t=win.getSelection();t.removeAllRanges(),t.addRange(e)}else doc.selection&&e.select&&e.select()},t.prototype.renderButtons=function(){var e=this,t="";function a(t){var a="md"===e.app.theme?"material-icons":"f7-icons";if(e.params.customButtons&&e.params.customButtons[t])return'<button type="button" class="text-editor-button" data-button="'+t+'">'+(e.params.customButtons[t].content||"")+"</button>";if(!textEditorButtonsMap[t])return"";var r=textEditorButtonsMap[t]["md"===e.app.theme?1:0];return('<button type="button" class="text-editor-button" data-button="'+t+'">'+(r.indexOf("<")>=0?r:'<i class="'+a+'">'+r+"</i>")+"</button>").trim()}return e.params.buttons.forEach((function(r,n){Array.isArray(r)?(r.forEach((function(e){t+=a(e)})),n<e.params.buttons.length-1&&e.params.dividers&&(t+='<div class="text-editor-button-divider"></div>')):t+=a(r)})),t},t.prototype.createToolbar=function(){this.$el.prepend('<div class="text-editor-toolbar">'+this.renderButtons()+"</div>")},t.prototype.createKeyboardToolbar=function(){var e=this.$el.closest(".theme-dark").length>0||"dark"===this.app.device.prefersColorScheme();this.$keyboardToolbarEl=$('<div class="toolbar toolbar-bottom text-editor-keyboard-toolbar '+(e?"theme-dark":"")+'"><div class="toolbar-inner">'+this.renderButtons()+"</div></div>")},t.prototype.createPopover=function(){var e=this.$el.closest(".theme-dark").length>0;this.popover=this.app.popover.create({content:'\n        <div class="popover '+(e?"theme-light":"theme-dark")+' text-editor-popover">\n          <div class="popover-inner">'+this.renderButtons()+"</div>\n        </div>\n      ",closeByOutsideClick:!1,backdrop:!1})},t.prototype.openKeyboardToolbar=function(){this.$keyboardToolbarEl.parent(this.app.root).length||(this.$el.trigger("texteditor:keyboardopen"),this.emit("local::keyboardOpen textEditorKeyboardOpen",this),this.app.root.append(this.$keyboardToolbarEl))},t.prototype.closeKeyboardToolbar=function(){this.$keyboardToolbarEl.remove(),this.$el.trigger("texteditor:keyboardclose"),this.emit("local::keyboardClose textEditorKeyboardClose",this)},t.prototype.openPopover=function(e,t,a,r){var n=this;n.popover&&(Object.assign(n.popover.params,{targetX:e,targetY:t,targetWidth:a,targetHeight:r}),clearTimeout(n.popoverTimeout),n.popoverTimeout=setTimeout((function(){n.popover&&(n.popover.opened?n.popover.resize():(n.$el.trigger("texteditor:popoveropen"),n.emit("local::popoverOpen textEditorPopoverOpen",n),n.popover.open()))}),400))},t.prototype.closePopover=function(){var e=this;clearTimeout(e.popoverTimeout),e.popover&&e.popover.opened&&(e.popoverTimeout=setTimeout((function(){e.popover&&(e.$el.trigger("texteditor:popoverclose"),e.emit("local::popoverClose textEditorPopoverClose",e),e.popover.close())}),400))},t.prototype.init=function(){return this.value?this.$contentEl.html(this.value):this.value=this.$contentEl.html(),this.params.placeholder&&""===this.value&&this.insertPlaceholder(),"toolbar"===this.params.mode?this.createToolbar():"popover"===this.params.mode?this.createPopover():"keyboard-toolbar"===this.params.mode&&this.createKeyboardToolbar(),this.attachEvents(),this.$el.trigger("texteditor:init"),this.emit("local::init textEditorInit",this),this},t.prototype.destroy=function(){var e=this;e.$el.trigger("texteditor:beforedestroy"),e.emit("local::beforeDestroy textEditorBeforeDestroy",e),e.detachEvents(),"keyboard-toolbar"===e.params.mode&&e.$keyboardToolbarEl&&e.$keyboardToolbarEl.remove(),e.popover&&(e.popover.close(!1),e.popover.destroy()),delete e.$el[0].f7TextEditor,Utils.deleteProps(e),e=null},t}(Framework7Class),TextEditor$1={name:"textEditor",params:{textEditor:{el:null,mode:"toolbar",value:void 0,customButtons:null,buttons:[["bold","italic","underline","strikeThrough"],["orderedList","unorderedList"],["link","image"],["paragraph","h1","h2","h3"],["alignLeft","alignCenter","alignRight","alignJustify"],["subscript","superscript"],["indent","outdent"]],dividers:!0,imageUrlText:"Insert image URL",linkUrlText:"Insert link URL",placeholder:null,clearFormattingOnPaste:!0}},create:function(){this.textEditor=Utils.extend(ConstructorMethods({defaultSelector:".text-editor",constructor:TextEditor,app:this,domProp:"f7TextEditor"}))},static:{TextEditor:TextEditor},on:{tabMounted:function(e){var t=this;$(e).find(".text-editor-init").each((function(e,a){var r=$(a).dataset();t.textEditor.create(Utils.extend({el:a},r||{}))}))},tabBeforeRemove:function(e){$(e).find(".text-editor-init").each((function(e,t){t.f7TextEditor&&t.f7TextEditor.destroy()}))},pageInit:function(e){var t=this;e.$el.find(".text-editor-init").each((function(e,a){var r=$(a).dataset();t.textEditor.create(Utils.extend({el:a},r||{}))}))},pageBeforeRemove:function(e){e.$el.find(".text-editor-init").each((function(e,t){t.f7TextEditor&&t.f7TextEditor.destroy()}))}},vnode:{"text-editor-init":{insert:function(e){var t=e.elm,a=$(t).dataset();this.textEditor.create(Utils.extend({el:t},a||{}))},destroy:function(e){var t=e.elm;t.f7TextEditor&&t.f7TextEditor.destroy()}}}},Elevation={name:"elevation"},Typography={name:"typography"},ViAd=function(e){function t(t,a){void 0===a&&(a={}),e.call(this,a,[t]);var r,n=this;if(!win.vi)throw new Error("Framework7: vi SDK not found.");void 0!==win.orientation&&(r=-90===win.orientation||90===win.orientation?"horizontal":"vertical");var i=Utils.extend({},t.params.vi,{appId:t.id,appVer:t.version,language:t.language,width:t.width,height:t.height,os:Device.os,osVersion:Device.osVersion,orientation:r});n.useModulesParams(i),n.params=Utils.extend(i,a);var o={},s="on autoplay fallbackOverlay fallbackOverlayText enabled".split(" ");if(Object.keys(n.params).forEach((function(e){if(!(s.indexOf(e)>=0)){var t=n.params[e];[null,void 0].indexOf(t)>=0||(o[e]=t)}})),!n.params.appId)throw new Error('Framework7: "app.id" is required to display an ad. Make sure you have specified it on app initialization.');if(!n.params.placementId)throw new Error('Framework7: "placementId" is required to display an ad.');function l(){var e=$("iframe#viAd");0!==e.length&&e.css({width:t.width+"px",height:t.height+"px"})}function p(){n.$overlayEl&&(n.$overlayEl.off("click touchstart"),n.$overlayEl.remove())}n.ad=new win.vi.Ad(o),Utils.extend(n.ad,{onAdReady:function(){t.on("resize",l),n.emit("local::ready"),n.params.autoplay&&n.start()},onAdStarted:function(){n.emit("local::started")},onAdClick:function(e){n.emit("local::click",e)},onAdImpression:function(){n.emit("local::impression")},onAdStopped:function(e){t.off("resize",l),p(),n.emit("local::stopped",e),"complete"===e&&(n.emit("local::complete"),n.emit("local::completed")),"userexit"===e&&n.emit("local::userexit"),n.destroyed=!0},onAutoPlayFailed:function(e,a){n.emit("local::autoplayFailed",e,a),e&&e.name&&-1!==e.name.indexOf("NotAllowedError")&&n.params.fallbackOverlay&&function(e){var a;e&&(n.$overlayEl=$(('\n        <div class="vi-overlay">\n          '+(n.params.fallbackOverlayText?'<div class="vi-overlay-text">'+n.params.fallbackOverlayText+"</div>":"")+'\n          <div class="vi-overlay-play-button"></div>\n        </div>\n      ').trim()),n.$overlayEl.on("touchstart",(function(){a=Utils.now()})),n.$overlayEl.on("click",(function(){if(!(Utils.now()-a>300)){if(e)return e.play(),void p();n.start(),p()}})),t.root.append(n.$overlayEl))}(a)},onAdError:function(e){p(),t.off("resize",l),n.emit("local::error",e),n.destroyed=!0}}),n.init(),Utils.extend(n,{app:t})}return e&&(t.__proto__=e),t.prototype=Object.create(e&&e.prototype),t.prototype.constructor=t,t.prototype.start=function(){this.destroyed||this.ad&&this.ad.startAd()},t.prototype.pause=function(){this.destroyed||this.ad&&this.ad.pauseAd()},t.prototype.resume=function(){this.destroyed||this.ad&&this.ad.resumeAd()},t.prototype.stop=function(){this.destroyed||this.ad&&this.ad.stopAd()},t.prototype.init=function(){this.destroyed||this.ad&&this.ad.initAd()},t.prototype.destroy=function(){this.destroyed=!0,this.emit("local::beforeDestroy"),Utils.deleteProps(this)},t}(Framework7Class),Vi={name:"vi",params:{vi:{enabled:!1,autoplay:!0,fallbackOverlay:!0,fallbackOverlayText:"Please watch this ad",showMute:!0,startMuted:(Device.ios||Device.android)&&!Device.cordova,appId:null,appVer:null,language:null,width:null,height:null,placementId:"pltd4o7ibb9rc653x14",placementType:"interstitial",videoSlot:null,showProgress:!0,showBranding:!0,os:null,osVersion:null,orientation:null,age:null,gender:null,advertiserId:null,latitude:null,longitude:null,accuracy:null,storeId:null,ip:null,manufacturer:null,model:null,connectionType:null,connectionProvider:null}},create:function(){var e=this;e.vi={sdkReady:!1,createAd:function(t){return new ViAd(e,t)},loadSdk:function(){if(!e.vi.sdkReady){var t=doc.createElement("script");t.onload=function(){e.emit("viSdkReady"),e.vi.sdkReady=!0},t.src="https://c.vi-serve.com/viadshtml/vi.min.js",$("head").append(t)}}}},on:{init:function(){(this.params.vi.enabled||this.passedParams.vi&&!1!==this.passedParams.vi.enabled)&&this.vi.loadSdk()}}};return"undefined"!=typeof window&&(window.Template7||(window.Template7=Template7),window.Dom7||(window.Dom7=$)),Router.use([RouterTemplateLoaderModule,RouterComponentLoaderModule]),Framework7.use([DeviceModule,SupportModule,UtilsModule,ResizeModule,RequestModule,TouchModule,ClicksModule,RouterModule,HistoryModule,ComponentModule,ServiceWorkerModule,Statusbar$1,View$1,Navbar$1,Toolbar$1,Subnavbar,TouchRipple$1,Modal$1,Appbar,Dialog$1,Popup$1,LoginScreen$1,Popover$1,Actions$1,Sheet$1,Toast$1,Preloader$1,Progressbar$1,Sortable$1,Swipeout$1,Accordion$1,ContactsList,VirtualList$1,ListIndex$1,Timeline,Tabs,Panel$1,Card,Chip,Form,Input$1,Checkbox,Radio,Toggle$1,Range$1,Stepper$1,SmartSelect$1,Grid$1,Calendar$1,Picker$1,InfiniteScroll$1,PullToRefresh$1,Lazy$1,DataTable$1,Fab$1,Searchbar$1,Messages$1,Messagebar$1,Swiper$1,PhotoBrowser$1,Notification$1,Autocomplete$1,Tooltip$1,Gauge$1,Skeleton,Menu$1,ColorPicker$1,Treeview$1,TextEditor$1,Elevation,Typography,Vi]),Framework7}));
//# sourceMappingURL=framework7.bundle.min.js.map